/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyledDocument;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;
import org.jhotdraw.draw.AbstractCompositeFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.gui.datatransfer.InputStreamTransferable;
import org.jhotdraw.io.Base64;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.LinearGradient;
import org.jhotdraw.samples.svg.RadialGradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGEllipseFigure;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.samples.svg.figures.SVGTextAreaFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;

public class SVGOutputFormat
implements OutputFormat {
    private URL url;
    private int nextId;
    private HashMap<IXMLElement, String> identifiedElements;
    private IXMLElement defs;
    private IXMLElement document;
    private HashMap<Gradient, String> gradientToIDMap;
    private boolean isPrettyPrint;
    private static final HashMap<Integer, String> strokeLinejoinMap = new HashMap();
    private static final HashMap<Integer, String> strokeLinecapMap;
    private static final boolean isFloatPrecision = true;

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("Scalable Vector Graphics (SVG)", "svg");
    }

    @Override
    public JComponent getOutputFormatAccessory() {
        return null;
    }

    public void setPrettyPrint(boolean bl) {
        this.isPrettyPrint = bl;
    }

    public boolean isPrettyPrint() {
        return this.isPrettyPrint;
    }

    protected void writeElement(IXMLElement object, Figure figure) throws IOException {
        Object object2;
        if (figure.get(SVGAttributeKeys.LINK) != null && figure.get(SVGAttributeKeys.LINK).trim().length() > 0) {
            object2 = object.createElement("a");
            object2.setAttribute("xlink:href", figure.get(SVGAttributeKeys.LINK));
            if (figure.get(SVGAttributeKeys.LINK_TARGET) != null && figure.get(SVGAttributeKeys.LINK).trim().length() > 0) {
                object2.setAttribute("target", figure.get(SVGAttributeKeys.LINK_TARGET));
            }
            object.addChild((IXMLElement)object2);
            object = object2;
        }
        if (figure instanceof SVGEllipseFigure) {
            object2 = (SVGEllipseFigure)figure;
            if (((SVGEllipseFigure)object2).getWidth() == ((SVGEllipseFigure)object2).getHeight()) {
                this.writeCircleElement((IXMLElement)object, (SVGEllipseFigure)object2);
            } else {
                this.writeEllipseElement((IXMLElement)object, (SVGEllipseFigure)object2);
            }
        } else if (figure instanceof SVGGroupFigure) {
            this.writeGElement((IXMLElement)object, (SVGGroupFigure)figure);
        } else if (figure instanceof SVGImageFigure) {
            this.writeImageElement((IXMLElement)object, (SVGImageFigure)figure);
        } else if (figure instanceof SVGPathFigure) {
            object2 = (SVGPathFigure)figure;
            if (((AbstractCompositeFigure)object2).getChildCount() == 1) {
                SVGBezierFigure sVGBezierFigure = ((SVGPathFigure)object2).getChild(0);
                boolean bl = true;
                int n = sVGBezierFigure.getNodeCount();
                for (int i = 0; i < n; ++i) {
                    if (sVGBezierFigure.getNode(i).getMask() == 0) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    if (sVGBezierFigure.isClosed()) {
                        this.writePolygonElement((IXMLElement)object, (SVGPathFigure)object2);
                    } else if (sVGBezierFigure.getNodeCount() == 2) {
                        this.writeLineElement((IXMLElement)object, (SVGPathFigure)object2);
                    } else {
                        this.writePolylineElement((IXMLElement)object, (SVGPathFigure)object2);
                    }
                } else {
                    this.writePathElement((IXMLElement)object, (SVGPathFigure)object2);
                }
            } else {
                this.writePathElement((IXMLElement)object, (SVGPathFigure)object2);
            }
        } else if (figure instanceof SVGRectFigure) {
            this.writeRectElement((IXMLElement)object, (SVGRectFigure)figure);
        } else if (figure instanceof SVGTextFigure) {
            this.writeTextElement((IXMLElement)object, (SVGTextFigure)figure);
        } else if (figure instanceof SVGTextAreaFigure) {
            this.writeTextAreaElement((IXMLElement)object, (SVGTextAreaFigure)figure);
        } else {
            System.out.println("Unable to write: " + figure);
        }
    }

    protected void writeCircleElement(IXMLElement iXMLElement, SVGEllipseFigure sVGEllipseFigure) throws IOException {
        iXMLElement.addChild(this.createCircle(this.document, sVGEllipseFigure.getX() + sVGEllipseFigure.getWidth() / 2.0, sVGEllipseFigure.getY() + sVGEllipseFigure.getHeight() / 2.0, sVGEllipseFigure.getWidth() / 2.0, sVGEllipseFigure.getAttributes()));
    }

    protected IXMLElement createCircle(IXMLElement iXMLElement, double d, double d2, double d3, Map<AttributeKey, Object> map) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("circle");
        this.writeAttribute(iXMLElement2, "cx", d, 0.0);
        this.writeAttribute(iXMLElement2, "cy", d2, 0.0);
        this.writeAttribute(iXMLElement2, "r", d3, 0.0);
        this.writeShapeAttributes(iXMLElement2, map);
        this.writeOpacityAttribute(iXMLElement2, map);
        this.writeTransformAttribute(iXMLElement2, map);
        return iXMLElement2;
    }

    protected IXMLElement createG(IXMLElement iXMLElement, Map<AttributeKey, Object> map) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("g");
        this.writeOpacityAttribute(iXMLElement2, map);
        return iXMLElement2;
    }

    protected IXMLElement createLinearGradient(IXMLElement iXMLElement, double d, double d2, double d3, double d4, double[] dArray, Color[] colorArray, double[] dArray2, boolean bl, AffineTransform affineTransform) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("linearGradient");
        this.writeAttribute(iXMLElement2, "x1", SVGOutputFormat.toNumber(d), "0");
        this.writeAttribute(iXMLElement2, "y1", SVGOutputFormat.toNumber(d2), "0");
        this.writeAttribute(iXMLElement2, "x2", SVGOutputFormat.toNumber(d3), "1");
        this.writeAttribute(iXMLElement2, "y2", SVGOutputFormat.toNumber(d4), "0");
        this.writeAttribute(iXMLElement2, "gradientUnits", bl ? "objectBoundingBox" : "userSpaceOnUse", "objectBoundingBox");
        this.writeAttribute(iXMLElement2, "gradientTransform", SVGOutputFormat.toTransform(affineTransform), "none");
        for (int i = 0; i < dArray.length; ++i) {
            XMLElement xMLElement = new XMLElement("stop");
            this.writeAttribute((IXMLElement)xMLElement, "offset", SVGOutputFormat.toNumber(dArray[i]), null);
            this.writeAttribute((IXMLElement)xMLElement, "stop-color", SVGOutputFormat.toColor(colorArray[i]), null);
            this.writeAttribute((IXMLElement)xMLElement, "stop-opacity", SVGOutputFormat.toNumber(dArray2[i]), "1");
            iXMLElement2.addChild(xMLElement);
        }
        return iXMLElement2;
    }

    protected IXMLElement createRadialGradient(IXMLElement iXMLElement, double d, double d2, double d3, double d4, double d5, double[] dArray, Color[] colorArray, double[] dArray2, boolean bl, AffineTransform affineTransform) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("radialGradient");
        this.writeAttribute(iXMLElement2, "cx", SVGOutputFormat.toNumber(d), "0.5");
        this.writeAttribute(iXMLElement2, "cy", SVGOutputFormat.toNumber(d2), "0.5");
        this.writeAttribute(iXMLElement2, "fx", SVGOutputFormat.toNumber(d3), SVGOutputFormat.toNumber(d));
        this.writeAttribute(iXMLElement2, "fy", SVGOutputFormat.toNumber(d4), SVGOutputFormat.toNumber(d2));
        this.writeAttribute(iXMLElement2, "r", SVGOutputFormat.toNumber(d5), "0.5");
        this.writeAttribute(iXMLElement2, "gradientUnits", bl ? "objectBoundingBox" : "userSpaceOnUse", "objectBoundingBox");
        this.writeAttribute(iXMLElement2, "gradientTransform", SVGOutputFormat.toTransform(affineTransform), "none");
        for (int i = 0; i < dArray.length; ++i) {
            XMLElement xMLElement = new XMLElement("stop");
            this.writeAttribute((IXMLElement)xMLElement, "offset", SVGOutputFormat.toNumber(dArray[i]), null);
            this.writeAttribute((IXMLElement)xMLElement, "stop-color", SVGOutputFormat.toColor(colorArray[i]), null);
            this.writeAttribute((IXMLElement)xMLElement, "stop-opacity", SVGOutputFormat.toNumber(dArray2[i]), "1");
            iXMLElement2.addChild(xMLElement);
        }
        return iXMLElement2;
    }

    protected void writeEllipseElement(IXMLElement iXMLElement, SVGEllipseFigure sVGEllipseFigure) throws IOException {
        iXMLElement.addChild(this.createEllipse(this.document, sVGEllipseFigure.getX() + sVGEllipseFigure.getWidth() / 2.0, sVGEllipseFigure.getY() + sVGEllipseFigure.getHeight() / 2.0, sVGEllipseFigure.getWidth() / 2.0, sVGEllipseFigure.getHeight() / 2.0, sVGEllipseFigure.getAttributes()));
    }

    protected IXMLElement createEllipse(IXMLElement iXMLElement, double d, double d2, double d3, double d4, Map<AttributeKey, Object> map) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("ellipse");
        this.writeAttribute(iXMLElement2, "cx", d, 0.0);
        this.writeAttribute(iXMLElement2, "cy", d2, 0.0);
        this.writeAttribute(iXMLElement2, "rx", d3, 0.0);
        this.writeAttribute(iXMLElement2, "ry", d4, 0.0);
        this.writeShapeAttributes(iXMLElement2, map);
        this.writeOpacityAttribute(iXMLElement2, map);
        this.writeTransformAttribute(iXMLElement2, map);
        return iXMLElement2;
    }

    protected void writeGElement(IXMLElement iXMLElement, SVGGroupFigure sVGGroupFigure) throws IOException {
        IXMLElement iXMLElement2 = this.createG(this.document, sVGGroupFigure.getAttributes());
        for (Figure figure : sVGGroupFigure.getChildren()) {
            this.writeElement(iXMLElement2, figure);
        }
        iXMLElement.addChild(iXMLElement2);
    }

    protected void writeImageElement(IXMLElement iXMLElement, SVGImageFigure sVGImageFigure) throws IOException {
        iXMLElement.addChild(this.createImage(this.document, sVGImageFigure.getX(), sVGImageFigure.getY(), sVGImageFigure.getWidth(), sVGImageFigure.getHeight(), sVGImageFigure.getImageData(), sVGImageFigure.getAttributes()));
    }

    protected IXMLElement createImage(IXMLElement iXMLElement, double d, double d2, double d3, double d4, byte[] byArray, Map<AttributeKey, Object> map) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("image");
        this.writeAttribute(iXMLElement2, "x", d, 0.0);
        this.writeAttribute(iXMLElement2, "y", d2, 0.0);
        this.writeAttribute(iXMLElement2, "width", d3, 0.0);
        this.writeAttribute(iXMLElement2, "height", d4, 0.0);
        this.writeAttribute(iXMLElement2, "xlink:href", "data:image;base64," + Base64.encodeBytes(byArray), "");
        this.writeOpacityAttribute(iXMLElement2, map);
        this.writeTransformAttribute(iXMLElement2, map);
        return iXMLElement2;
    }

    protected void writePathElement(IXMLElement iXMLElement, SVGPathFigure sVGPathFigure) throws IOException {
        BezierPath[] bezierPathArray = new BezierPath[sVGPathFigure.getChildCount()];
        for (int i = 0; i < bezierPathArray.length; ++i) {
            bezierPathArray[i] = sVGPathFigure.getChild(i).getBezierPath();
        }
        iXMLElement.addChild(this.createPath(this.document, bezierPathArray, sVGPathFigure.getAttributes()));
    }

    protected IXMLElement createPath(IXMLElement iXMLElement, BezierPath[] bezierPathArray, Map<AttributeKey, Object> map) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("path");
        this.writeShapeAttributes(iXMLElement2, map);
        this.writeOpacityAttribute(iXMLElement2, map);
        this.writeTransformAttribute(iXMLElement2, map);
        this.writeAttribute(iXMLElement2, "d", SVGOutputFormat.toPath(bezierPathArray), null);
        return iXMLElement2;
    }

    protected void writePolygonElement(IXMLElement iXMLElement, SVGPathFigure sVGPathFigure) throws IOException {
        LinkedList<Point2D.Double> linkedList = new LinkedList<Point2D.Double>();
        BezierPath[] bezierPathArray = new BezierPath[sVGPathFigure.getChildCount()];
        int n = sVGPathFigure.getChildCount();
        for (int i = 0; i < n; ++i) {
            BezierPath bezierPath = sVGPathFigure.getChild(i).getBezierPath();
            for (BezierPath.Node node : bezierPath) {
                linkedList.add(new Point2D.Double(node.x[0], node.y[0]));
            }
        }
        iXMLElement.addChild(this.createPolygon(this.document, linkedList.toArray(new Point2D.Double[linkedList.size()]), sVGPathFigure.getAttributes()));
    }

    protected IXMLElement createPolygon(IXMLElement iXMLElement, Point2D.Double[] doubleArray, Map<AttributeKey, Object> map) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("polygon");
        this.writeAttribute(iXMLElement2, "points", SVGOutputFormat.toPoints(doubleArray), null);
        this.writeShapeAttributes(iXMLElement2, map);
        this.writeOpacityAttribute(iXMLElement2, map);
        this.writeTransformAttribute(iXMLElement2, map);
        return iXMLElement2;
    }

    protected void writePolylineElement(IXMLElement iXMLElement, SVGPathFigure sVGPathFigure) throws IOException {
        LinkedList<Point2D.Double> linkedList = new LinkedList<Point2D.Double>();
        BezierPath[] bezierPathArray = new BezierPath[sVGPathFigure.getChildCount()];
        int n = sVGPathFigure.getChildCount();
        for (int i = 0; i < n; ++i) {
            BezierPath bezierPath = sVGPathFigure.getChild(i).getBezierPath();
            for (BezierPath.Node node : bezierPath) {
                linkedList.add(new Point2D.Double(node.x[0], node.y[0]));
            }
        }
        iXMLElement.addChild(this.createPolyline(this.document, linkedList.toArray(new Point2D.Double[linkedList.size()]), sVGPathFigure.getAttributes()));
    }

    protected IXMLElement createPolyline(IXMLElement iXMLElement, Point2D.Double[] doubleArray, Map<AttributeKey, Object> map) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("polyline");
        this.writeAttribute(iXMLElement2, "points", SVGOutputFormat.toPoints(doubleArray), null);
        this.writeShapeAttributes(iXMLElement2, map);
        this.writeOpacityAttribute(iXMLElement2, map);
        this.writeTransformAttribute(iXMLElement2, map);
        return iXMLElement2;
    }

    protected void writeLineElement(IXMLElement iXMLElement, SVGPathFigure sVGPathFigure) throws IOException {
        SVGBezierFigure sVGBezierFigure = sVGPathFigure.getChild(0);
        iXMLElement.addChild(this.createLine(this.document, sVGBezierFigure.getNode((int)0).x[0], sVGBezierFigure.getNode((int)0).y[0], sVGBezierFigure.getNode((int)1).x[0], sVGBezierFigure.getNode((int)1).y[0], sVGPathFigure.getAttributes()));
    }

    protected IXMLElement createLine(IXMLElement iXMLElement, double d, double d2, double d3, double d4, Map<AttributeKey, Object> map) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("line");
        this.writeAttribute(iXMLElement2, "x1", d, 0.0);
        this.writeAttribute(iXMLElement2, "y1", d2, 0.0);
        this.writeAttribute(iXMLElement2, "x2", d3, 0.0);
        this.writeAttribute(iXMLElement2, "y2", d4, 0.0);
        this.writeShapeAttributes(iXMLElement2, map);
        this.writeOpacityAttribute(iXMLElement2, map);
        this.writeTransformAttribute(iXMLElement2, map);
        return iXMLElement2;
    }

    protected void writeRectElement(IXMLElement iXMLElement, SVGRectFigure sVGRectFigure) throws IOException {
        iXMLElement.addChild(this.createRect(this.document, sVGRectFigure.getX(), sVGRectFigure.getY(), sVGRectFigure.getWidth(), sVGRectFigure.getHeight(), sVGRectFigure.getArcWidth(), sVGRectFigure.getArcHeight(), sVGRectFigure.getAttributes()));
    }

    protected IXMLElement createRect(IXMLElement iXMLElement, double d, double d2, double d3, double d4, double d5, double d6, Map<AttributeKey, Object> map) throws IOException {
        IXMLElement iXMLElement2 = iXMLElement.createElement("rect");
        this.writeAttribute(iXMLElement2, "x", d, 0.0);
        this.writeAttribute(iXMLElement2, "y", d2, 0.0);
        this.writeAttribute(iXMLElement2, "width", d3, 0.0);
        this.writeAttribute(iXMLElement2, "height", d4, 0.0);
        this.writeAttribute(iXMLElement2, "rx", d5, 0.0);
        this.writeAttribute(iXMLElement2, "ry", d6, 0.0);
        this.writeShapeAttributes(iXMLElement2, map);
        this.writeOpacityAttribute(iXMLElement2, map);
        this.writeTransformAttribute(iXMLElement2, map);
        return iXMLElement2;
    }

    protected void writeTextElement(IXMLElement iXMLElement, SVGTextFigure sVGTextFigure) throws IOException {
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        try {
            defaultStyledDocument.insertString(0, sVGTextFigure.getText(), null);
        }
        catch (BadLocationException badLocationException) {
            InternalError internalError = new InternalError(badLocationException.getMessage());
            internalError.initCause(badLocationException);
            throw internalError;
        }
        iXMLElement.addChild(this.createText(this.document, sVGTextFigure.getCoordinates(), sVGTextFigure.getRotates(), defaultStyledDocument, sVGTextFigure.getAttributes()));
    }

    protected IXMLElement createText(IXMLElement iXMLElement, Point2D.Double[] doubleArray, double[] dArray, StyledDocument styledDocument, Map<AttributeKey, Object> map) throws IOException {
        String string;
        IXMLElement iXMLElement2 = iXMLElement.createElement("text");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < doubleArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
                stringBuilder2.append(',');
            }
            stringBuilder.append(SVGOutputFormat.toNumber(doubleArray[i].getX()));
            stringBuilder2.append(SVGOutputFormat.toNumber(doubleArray[i].getY()));
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                if (i != 0) {
                    stringBuilder3.append(',');
                }
                stringBuilder3.append(SVGOutputFormat.toNumber(dArray[i]));
            }
        }
        this.writeAttribute(iXMLElement2, "x", stringBuilder.toString(), "0");
        this.writeAttribute(iXMLElement2, "y", stringBuilder2.toString(), "0");
        this.writeAttribute(iXMLElement2, "rotate", stringBuilder3.toString(), "");
        try {
            string = styledDocument.getText(0, styledDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            InternalError internalError = new InternalError(badLocationException.getMessage());
            internalError.initCause(badLocationException);
            throw internalError;
        }
        iXMLElement2.setContent(string);
        this.writeShapeAttributes(iXMLElement2, map);
        this.writeOpacityAttribute(iXMLElement2, map);
        this.writeTransformAttribute(iXMLElement2, map);
        this.writeFontAttributes(iXMLElement2, map);
        return iXMLElement2;
    }

    protected void writeTextAreaElement(IXMLElement iXMLElement, SVGTextAreaFigure sVGTextAreaFigure) throws IOException {
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        try {
            defaultStyledDocument.insertString(0, sVGTextAreaFigure.getText(), null);
        }
        catch (BadLocationException badLocationException) {
            InternalError internalError = new InternalError(badLocationException.getMessage());
            internalError.initCause(badLocationException);
            throw internalError;
        }
        Rectangle2D.Double double_ = sVGTextAreaFigure.getBounds();
        iXMLElement.addChild(this.createTextArea(this.document, double_.x, double_.y, double_.width, double_.height, defaultStyledDocument, sVGTextAreaFigure.getAttributes()));
    }

    protected IXMLElement createTextArea(IXMLElement iXMLElement, double d, double d2, double d3, double d4, StyledDocument styledDocument, Map<AttributeKey, Object> map) throws IOException {
        String string;
        IXMLElement iXMLElement2 = iXMLElement.createElement("textArea");
        this.writeAttribute(iXMLElement2, "x", SVGOutputFormat.toNumber(d), "0");
        this.writeAttribute(iXMLElement2, "y", SVGOutputFormat.toNumber(d2), "0");
        this.writeAttribute(iXMLElement2, "width", SVGOutputFormat.toNumber(d3), "0");
        this.writeAttribute(iXMLElement2, "height", SVGOutputFormat.toNumber(d4), "0");
        try {
            string = styledDocument.getText(0, styledDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            InternalError internalError = new InternalError(badLocationException.getMessage());
            internalError.initCause(badLocationException);
            throw internalError;
        }
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                iXMLElement2.addChild(iXMLElement.createElement("tbreak"));
            }
            IXMLElement iXMLElement3 = iXMLElement.createElement(null);
            iXMLElement3.setContent(stringArray[i]);
            iXMLElement2.addChild(iXMLElement3);
        }
        this.writeShapeAttributes(iXMLElement2, map);
        this.writeTransformAttribute(iXMLElement2, map);
        this.writeOpacityAttribute(iXMLElement2, map);
        this.writeFontAttributes(iXMLElement2, map);
        return iXMLElement2;
    }

    protected void writeShapeAttributes(IXMLElement iXMLElement, Map<AttributeKey, Object> map) throws IOException {
        Object object;
        Gradient gradient;
        Object object2;
        Gradient gradient2 = SVGAttributeKeys.FILL_GRADIENT.get(map);
        if (gradient2 != null) {
            if (this.gradientToIDMap.containsKey(gradient2)) {
                object2 = this.gradientToIDMap.get(gradient2);
            } else {
                if (gradient2 instanceof LinearGradient) {
                    gradient = (LinearGradient)gradient2;
                    object = this.createLinearGradient(this.document, ((LinearGradient)gradient).getX1(), ((LinearGradient)gradient).getY1(), ((LinearGradient)gradient).getX2(), ((LinearGradient)gradient).getY2(), ((LinearGradient)gradient).getStopOffsets(), ((LinearGradient)gradient).getStopColors(), ((LinearGradient)gradient).getStopOpacities(), ((LinearGradient)gradient).isRelativeToFigureBounds(), ((LinearGradient)gradient).getTransform());
                } else {
                    gradient = (RadialGradient)gradient2;
                    object = this.createRadialGradient(this.document, ((RadialGradient)gradient).getCX(), ((RadialGradient)gradient).getCY(), ((RadialGradient)gradient).getFX(), ((RadialGradient)gradient).getFY(), ((RadialGradient)gradient).getR(), ((RadialGradient)gradient).getStopOffsets(), ((RadialGradient)gradient).getStopColors(), ((RadialGradient)gradient).getStopOpacities(), ((RadialGradient)gradient).isRelativeToFigureBounds(), ((RadialGradient)gradient).getTransform());
                }
                object2 = this.getId((IXMLElement)object);
                object.setAttribute("id", "xml", (String)object2);
                this.defs.addChild((IXMLElement)object);
                this.gradientToIDMap.put(gradient2, (String)object2);
            }
            this.writeAttribute(iXMLElement, "fill", "url(#" + (String)object2 + ")", "#000");
        } else {
            this.writeAttribute(iXMLElement, "fill", SVGOutputFormat.toColor((Color)SVGAttributeKeys.FILL_COLOR.get(map)), "#000");
        }
        this.writeAttribute(iXMLElement, "fill-opacity", SVGAttributeKeys.FILL_OPACITY.get(map), 1.0);
        if (SVGAttributeKeys.WINDING_RULE.get(map) != AttributeKeys.WindingRule.NON_ZERO) {
            this.writeAttribute(iXMLElement, "fill-rule", "evenodd", "nonzero");
        }
        if ((gradient2 = SVGAttributeKeys.STROKE_GRADIENT.get(map)) != null) {
            if (this.gradientToIDMap.containsKey(gradient2)) {
                object2 = this.gradientToIDMap.get(gradient2);
            } else {
                if (gradient2 instanceof LinearGradient) {
                    gradient = (LinearGradient)gradient2;
                    object = this.createLinearGradient(this.document, ((LinearGradient)gradient).getX1(), ((LinearGradient)gradient).getY1(), ((LinearGradient)gradient).getX2(), ((LinearGradient)gradient).getY2(), ((LinearGradient)gradient).getStopOffsets(), ((LinearGradient)gradient).getStopColors(), ((LinearGradient)gradient).getStopOpacities(), ((LinearGradient)gradient).isRelativeToFigureBounds(), ((LinearGradient)gradient).getTransform());
                } else {
                    gradient = (RadialGradient)gradient2;
                    object = this.createRadialGradient(this.document, ((RadialGradient)gradient).getCX(), ((RadialGradient)gradient).getCY(), ((RadialGradient)gradient).getFX(), ((RadialGradient)gradient).getFY(), ((RadialGradient)gradient).getR(), ((RadialGradient)gradient).getStopOffsets(), ((RadialGradient)gradient).getStopColors(), ((RadialGradient)gradient).getStopOpacities(), ((RadialGradient)gradient).isRelativeToFigureBounds(), ((RadialGradient)gradient).getTransform());
                }
                object2 = this.getId((IXMLElement)object);
                object.setAttribute("id", "xml", (String)object2);
                this.defs.addChild((IXMLElement)object);
                this.gradientToIDMap.put(gradient2, (String)object2);
            }
            this.writeAttribute(iXMLElement, "stroke", "url(#" + (String)object2 + ")", "none");
        } else {
            this.writeAttribute(iXMLElement, "stroke", SVGOutputFormat.toColor((Color)SVGAttributeKeys.STROKE_COLOR.get(map)), "none");
        }
        object2 = (double[])SVGAttributeKeys.STROKE_DASHES.get(map);
        if (object2 != null) {
            object = new StringBuilder();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                if (i != 0) {
                    ((StringBuilder)object).append(',');
                }
                ((StringBuilder)object).append(SVGOutputFormat.toNumber((double)object2[i]));
            }
            this.writeAttribute(iXMLElement, "stroke-dasharray", ((StringBuilder)object).toString(), null);
        }
        this.writeAttribute(iXMLElement, "stroke-dashoffset", (Double)SVGAttributeKeys.STROKE_DASH_PHASE.get(map), 0.0);
        this.writeAttribute(iXMLElement, "stroke-linecap", strokeLinecapMap.get(SVGAttributeKeys.STROKE_CAP.get(map)), "butt");
        this.writeAttribute(iXMLElement, "stroke-linejoin", strokeLinejoinMap.get(SVGAttributeKeys.STROKE_JOIN.get(map)), "miter");
        this.writeAttribute(iXMLElement, "stroke-miterlimit", (Double)SVGAttributeKeys.STROKE_MITER_LIMIT.get(map), 4.0);
        this.writeAttribute(iXMLElement, "stroke-opacity", SVGAttributeKeys.STROKE_OPACITY.get(map), 1.0);
        this.writeAttribute(iXMLElement, "stroke-width", (Double)SVGAttributeKeys.STROKE_WIDTH.get(map), 1.0);
    }

    protected void writeOpacityAttribute(IXMLElement iXMLElement, Map<AttributeKey, Object> map) throws IOException {
        this.writeAttribute(iXMLElement, "opacity", SVGAttributeKeys.OPACITY.get(map), 1.0);
    }

    protected void writeTransformAttribute(IXMLElement iXMLElement, Map<AttributeKey, Object> map) throws IOException {
        AffineTransform affineTransform = (AffineTransform)SVGAttributeKeys.TRANSFORM.get(map);
        if (affineTransform != null) {
            this.writeAttribute(iXMLElement, "transform", SVGOutputFormat.toTransform(affineTransform), "none");
        }
    }

    private void writeFontAttributes(IXMLElement iXMLElement, Map<AttributeKey, Object> map) throws IOException {
        this.writeAttribute(iXMLElement, "font-family", ((Font)SVGAttributeKeys.FONT_FACE.get(map)).getFontName(), "Dialog");
        this.writeAttribute(iXMLElement, "font-size", (Double)SVGAttributeKeys.FONT_SIZE.get(map), 0.0);
        this.writeAttribute(iXMLElement, "font-style", (Boolean)SVGAttributeKeys.FONT_ITALIC.get(map) != false ? "italic" : "normal", "normal");
        this.writeAttribute(iXMLElement, "font-variant", "normal", "normal");
        this.writeAttribute(iXMLElement, "font-weight", (Boolean)SVGAttributeKeys.FONT_BOLD.get(map) != false ? "bold" : "normal", "normal");
        this.writeAttribute(iXMLElement, "text-decoration", (Boolean)SVGAttributeKeys.FONT_UNDERLINE.get(map) != false ? "underline" : "none", "none");
    }

    private void writeViewportAttributes(IXMLElement iXMLElement, Map<AttributeKey, Object> map) throws IOException {
        if (SVGAttributeKeys.VIEWPORT_WIDTH.get(map) != null && SVGAttributeKeys.VIEWPORT_HEIGHT.get(map) != null) {
            this.writeAttribute(iXMLElement, "width", SVGOutputFormat.toNumber(SVGAttributeKeys.VIEWPORT_WIDTH.get(map)), null);
            this.writeAttribute(iXMLElement, "height", SVGOutputFormat.toNumber(SVGAttributeKeys.VIEWPORT_HEIGHT.get(map)), null);
        }
        this.writeAttribute(iXMLElement, "viewport-fill", SVGOutputFormat.toColor(SVGAttributeKeys.VIEWPORT_FILL.get(map)), "none");
        this.writeAttribute(iXMLElement, "viewport-fill-opacity", SVGAttributeKeys.VIEWPORT_FILL_OPACITY.get(map), 1.0);
    }

    protected void writeAttribute(IXMLElement iXMLElement, String string, String string2, String string3) {
        this.writeAttribute(iXMLElement, string, "http://www.w3.org/2000/svg", string2, string3);
    }

    protected void writeAttribute(IXMLElement iXMLElement, String string, String string2, String string3, String string4) {
        if (!string3.equals(string4)) {
            iXMLElement.setAttribute(string, string3);
        }
    }

    protected void writeAttribute(IXMLElement iXMLElement, String string, double d, double d2) {
        this.writeAttribute(iXMLElement, string, "http://www.w3.org/2000/svg", d, d2);
    }

    protected void writeAttribute(IXMLElement iXMLElement, String string, String string2, double d, double d2) {
        if (d != d2) {
            iXMLElement.setAttribute(string, SVGOutputFormat.toNumber(d));
        }
    }

    public static String toPath(BezierPath[] bezierPathArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < bezierPathArray.length; ++i) {
            BezierPath.Node node;
            BezierPath.Node node2;
            BezierPath bezierPath = bezierPathArray[i];
            if (bezierPath.size() == 0) continue;
            if (bezierPath.size() == 1) {
                node2 = (BezierPath.Node)bezierPath.get(0);
                stringBuilder.append("M ");
                stringBuilder.append(SVGOutputFormat.toNumber(node2.x[0]));
                stringBuilder.append(' ');
                stringBuilder.append(SVGOutputFormat.toNumber(node2.y[0]));
                stringBuilder.append(SVGOutputFormat.toNumber(node2.x[0]));
                stringBuilder.append(' ');
                stringBuilder.append(SVGOutputFormat.toNumber(node2.y[0] + 1.0));
                continue;
            }
            node2 = node = (BezierPath.Node)bezierPath.get(0);
            stringBuilder.append("M ");
            stringBuilder.append(SVGOutputFormat.toNumber(node.x[0]));
            stringBuilder.append(' ');
            stringBuilder.append(SVGOutputFormat.toNumber(node.y[0]));
            int n = 76;
            int n2 = bezierPath.size();
            for (int j = 1; j < n2; ++j) {
                node2 = node;
                node = (BezierPath.Node)bezierPath.get(j);
                if ((node2.mask & 2) == 0) {
                    if ((node.mask & 1) == 0) {
                        if (n != 76) {
                            stringBuilder.append(" L ");
                            n = 76;
                        } else {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(SVGOutputFormat.toNumber(node.x[0]));
                        stringBuilder.append(' ');
                        stringBuilder.append(SVGOutputFormat.toNumber(node.y[0]));
                        continue;
                    }
                    if (n != 81) {
                        stringBuilder.append(" Q ");
                        n = 81;
                    } else {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(SVGOutputFormat.toNumber(node.x[1]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node.y[1]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node.x[0]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node.y[0]));
                    continue;
                }
                if ((node.mask & 1) == 0) {
                    if (n != 81) {
                        stringBuilder.append(" Q ");
                        n = 81;
                    } else {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(SVGOutputFormat.toNumber(node2.x[2]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node2.y[2]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node.x[0]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node.y[0]));
                    continue;
                }
                if (n != 67) {
                    stringBuilder.append(" C ");
                    n = 67;
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(SVGOutputFormat.toNumber(node2.x[2]));
                stringBuilder.append(' ');
                stringBuilder.append(SVGOutputFormat.toNumber(node2.y[2]));
                stringBuilder.append(' ');
                stringBuilder.append(SVGOutputFormat.toNumber(node.x[1]));
                stringBuilder.append(' ');
                stringBuilder.append(SVGOutputFormat.toNumber(node.y[1]));
                stringBuilder.append(' ');
                stringBuilder.append(SVGOutputFormat.toNumber(node.x[0]));
                stringBuilder.append(' ');
                stringBuilder.append(SVGOutputFormat.toNumber(node.y[0]));
            }
            if (!bezierPath.isClosed()) continue;
            if (bezierPath.size() > 1) {
                node2 = (BezierPath.Node)bezierPath.get(bezierPath.size() - 1);
                node = (BezierPath.Node)bezierPath.get(0);
                if ((node2.mask & 2) == 0) {
                    if ((node.mask & 1) == 0) {
                        if (n != 76) {
                            stringBuilder.append(" L ");
                            n = 76;
                        } else {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(SVGOutputFormat.toNumber(node.x[0]));
                        stringBuilder.append(' ');
                        stringBuilder.append(SVGOutputFormat.toNumber(node.y[0]));
                    } else {
                        if (n != 81) {
                            stringBuilder.append(" Q ");
                            n = 81;
                        } else {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(SVGOutputFormat.toNumber(node.x[1]));
                        stringBuilder.append(' ');
                        stringBuilder.append(SVGOutputFormat.toNumber(node.y[1]));
                        stringBuilder.append(' ');
                        stringBuilder.append(SVGOutputFormat.toNumber(node.x[0]));
                        stringBuilder.append(' ');
                        stringBuilder.append(SVGOutputFormat.toNumber(node.y[0]));
                    }
                } else if ((node.mask & 1) == 0) {
                    if (n != 81) {
                        stringBuilder.append(" Q ");
                        n = 81;
                    } else {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(SVGOutputFormat.toNumber(node2.x[2]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node2.y[2]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node.x[0]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node.y[0]));
                } else {
                    if (n != 67) {
                        stringBuilder.append(" C ");
                        n = 67;
                    } else {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(SVGOutputFormat.toNumber(node2.x[2]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node2.y[2]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node.x[1]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node.y[1]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node.x[0]));
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(node.y[0]));
                }
            }
            stringBuilder.append(" Z");
            n = 0;
        }
        return stringBuilder.toString();
    }

    public static String toNumber(double d) {
        String string = Float.toString((float)d);
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public static String toPoints(Point2D.Double[] doubleArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < doubleArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(SVGOutputFormat.toNumber(doubleArray[i].x));
            stringBuilder.append(',');
            stringBuilder.append(SVGOutputFormat.toNumber(doubleArray[i].y));
        }
        return stringBuilder.toString();
    }

    public static String toTransform(AffineTransform affineTransform) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        switch (affineTransform.getType()) {
            case 0: {
                stringBuilder.append("none");
                break;
            }
            case 1: {
                stringBuilder.append("translate(");
                stringBuilder.append(SVGOutputFormat.toNumber(affineTransform.getTranslateX()));
                if (affineTransform.getTranslateY() != 0.0) {
                    stringBuilder.append(' ');
                    stringBuilder.append(SVGOutputFormat.toNumber(affineTransform.getTranslateY()));
                }
                stringBuilder.append(')');
                break;
            }
            case 2: {
                stringBuilder.append("scale(");
                stringBuilder.append(SVGOutputFormat.toNumber(affineTransform.getScaleX()));
                stringBuilder.append(')');
                break;
            }
            case 4: 
            case 6: {
                stringBuilder.append("scale(");
                stringBuilder.append(SVGOutputFormat.toNumber(affineTransform.getScaleX()));
                stringBuilder.append(' ');
                stringBuilder.append(SVGOutputFormat.toNumber(affineTransform.getScaleY()));
                stringBuilder.append(')');
                break;
            }
            default: {
                stringBuilder.append("matrix(");
                double[] dArray = new double[6];
                affineTransform.getMatrix(dArray);
                for (int i = 0; i < dArray.length; ++i) {
                    if (i != 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(SVGOutputFormat.toNumber(dArray[i]));
                }
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    public static String toColor(Color color) {
        if (color == null) {
            return "none";
        }
        String string = "000000" + Integer.toHexString(color.getRGB());
        string = "#" + string.substring(string.length() - 6);
        if (string.charAt(1) == string.charAt(2) && string.charAt(3) == string.charAt(4) && string.charAt(5) == string.charAt(6)) {
            string = "#" + string.charAt(1) + string.charAt(3) + string.charAt(5);
        }
        return string;
    }

    @Override
    public String getFileExtension() {
        return "svg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file, Drawing drawing) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.write(bufferedOutputStream, drawing);
        }
        finally {
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
        }
    }

    @Override
    public void write(OutputStream outputStream, Drawing drawing) throws IOException {
        this.write(outputStream, drawing, drawing.getChildren());
    }

    public void write(OutputStream outputStream, Drawing drawing, List<Figure> list) throws IOException {
        this.document = new XMLElement("svg", "http://www.w3.org/2000/svg");
        this.document.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.document.setAttribute("version", "1.2");
        this.document.setAttribute("baseProfile", "tiny");
        this.writeViewportAttributes(this.document, drawing.getAttributes());
        this.initStorageContext(this.document);
        this.defs = new XMLElement("defs");
        this.document.addChild(this.defs);
        for (Figure object2 : list) {
            this.writeElement(this.document, object2);
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        XMLWriter xMLWriter = new XMLWriter(printWriter);
        xMLWriter.write(this.document, this.isPrettyPrint);
        printWriter.flush();
        this.document.dispose();
    }

    private void initStorageContext(IXMLElement iXMLElement) {
        this.identifiedElements = new HashMap();
        this.gradientToIDMap = new HashMap();
    }

    public String getId(IXMLElement iXMLElement) {
        if (this.identifiedElements.containsKey(iXMLElement)) {
            return this.identifiedElements.get(iXMLElement);
        }
        String string = Integer.toString(this.nextId++, 36);
        this.identifiedElements.put(iXMLElement, string);
        return string;
    }

    @Override
    public Transferable createTransferable(Drawing drawing, List<Figure> list, double d) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream, drawing, list);
        return new InputStreamTransferable(new DataFlavor("image/svg+xml", "Image SVG"), byteArrayOutputStream.toByteArray());
    }

    static {
        strokeLinejoinMap.put(0, "miter");
        strokeLinejoinMap.put(1, "round");
        strokeLinejoinMap.put(2, "bevel");
        strokeLinecapMap = new HashMap();
        strokeLinecapMap.put(0, "butt");
        strokeLinecapMap.put(1, "round");
        strokeLinecapMap.put(2, "square");
    }
}

