/*
Copyright (C) 2010 Srivats P.

This file is part of "Ostinato"

This is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/
#ifndef _OSTM_FILE_FORMAT_H
#define _OSTM_FILE_FORMAT_H

#include "nativefileformat.h"
#include "streamfileformat.h"

#include "fileformat.pb.h"

class OstmFileFormat : public StreamFileFormat, public NativeFileFormat
{
public:
    OstmFileFormat();

    virtual bool open(const QString fileName,
            OstProto::StreamConfigList &streams, QString &error);
    virtual bool save(const OstProto::StreamConfigList streams,
            const QString fileName, QString &error);

    bool isMyFileFormat(const QString fileName);
    bool isMyFileType(const QString fileType);
};

extern OstmFileFormat fileFormat;

#endif
