# Debian Packagesearch
Author: Benjamin Mesing (bensmail@gmx.net)  
License: GPL_3+ 
Language: C++ 
Platforms: Debian-Linux 
Documentation: Doxygen 

This program provides a UI for package searches on Debian systems. 
In particular it integrates searching by tags (debtags).

Tags are categories that can be added to a package. They characterise
the program. Multiple Tags may be assigned to one package.

See the programs help page for more information (accessible via 
Help->Content in the menu).

# Developer Info

## Building
* install dependencies listed in debian/control
* generate Make file through cmake; inside root project dir
    * mkdir build-packagesearch
    * cd build-packagesearch
    * cmake ../ --> this will generate a Makefile for debug, to create one for release, define an environment variable PACKAGESEARCH_BUILD_TYPE=release
    * make --> should build packagesearch binary and all plugins
    * use fakeroot debian/rules binary to build a binary to try if everything is working on the packaging side

## Create Debian release
* within git repo
* update version via dch -v XXX
* run ./make-release.pl
* chdir to ../packagesearch-release/packagesearch-yyyy-mm-dd
* debuild
* check generated files with lintian, debdiff, dpkg -c,...
* as root
    * cowbuilder create (if not yet there)
    * cowbuilder update
    * cowbuilder build packagesearch_2.8.XX.dsc
* copy results from /var/cache/pbuilder/result/ (especially source.changes, which is somehow not generated from debuild)
* debsign packagesearch_2.8.XX_source.changes
* dput packagesearch_2.8.XX_source.changes

