/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_58 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 29902, "epsg", 29902,
        "TM65 / Irish Grid", 0, 0,
        "Airy Modified 1849", "Greenwich",
        "TM65", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=20000");
    add_proj4text (p, 1,
        "0 +y_0=250000 +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 2,
        "6,-1.042,-0.214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TM65 / Irish Grid\",GEOGCS[\"TM65\",DATUM[\"TM6");
    add_srs_wkt (p, 1,
        "5\",SPHEROID[\"Airy Modified 1849\",6377340.189,299.3249");
    add_srs_wkt (p, 2,
        "646,AUTHORITY[\"EPSG\",\"7002\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 3,
        "299\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 4,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4299\"]],PROJECTION[\"");
    add_srs_wkt (p, 6,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 7,
        "53.5],PARAMETER[\"central_meridian\",-8],PARAMETER[\"sca");
    add_srs_wkt (p, 8,
        "le_factor\",1.000035],PARAMETER[\"false_easting\",200000");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_northing\",250000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29902\"]]");
    p = add_epsg_def_ex (filter, first, last, 29903, "epsg", 29903,
        "TM75 / Irish Grid", 0, 0,
        "Airy Modified 1849", "Greenwich",
        "Geodetic_Datum_of_1965", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=20000");
    add_proj4text (p, 1,
        "0 +y_0=250000 +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 2,
        "6,-1.042,-0.214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TM75 / Irish Grid\",GEOGCS[\"TM75\",DATUM[\"Geo");
    add_srs_wkt (p, 1,
        "detic_Datum_of_1965\",SPHEROID[\"Airy Modified 1849\",63");
    add_srs_wkt (p, 2,
        "77340.189,299.3249646,AUTHORITY[\"EPSG\",\"7002\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6300\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"430");
    add_srs_wkt (p, 6,
        "0\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",53.5],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-8],PARAMETER[\"scale_factor\",1.000035],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",200000],PARAMETER[\"false_northing\",250000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"29903\"]]");
    p = add_epsg_def_ex (filter, first, last, 30161, "epsg", 30161,
        "Tokyo / Japan Plane Rectangular CS I", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS I\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",33],PARAMETER[\"central_meridian\",129.5],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30161\"]]");
    p = add_epsg_def_ex (filter, first, last, 30162, "epsg", 30162,
        "Tokyo / Japan Plane Rectangular CS II", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS II\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",33],PARAMETER[\"central_meridian\",131],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30162\"]]");
    p = add_epsg_def_ex (filter, first, last, 30163, "epsg", 30163,
        "Tokyo / Japan Plane Rectangular CS III", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS III\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",36],PARAMETER[\"central_meridian\",132.1");
    add_srs_wkt (p, 8,
        "66666666667],PARAMETER[\"scale_factor\",0.9999],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",0],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"30163\"]]");
    p = add_epsg_def_ex (filter, first, last, 30164, "epsg", 30164,
        "Tokyo / Japan Plane Rectangular CS IV", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS IV\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",33],PARAMETER[\"central_meridian\",133.5");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 11,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30164\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 30165, "epsg", 30165,
        "Tokyo / Japan Plane Rectangular CS V", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS V\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",36],PARAMETER[\"central_meridian\",134.333");
    add_srs_wkt (p, 8,
        "333333333],PARAMETER[\"scale_factor\",0.9999],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "30165\"]]");
    p = add_epsg_def_ex (filter, first, last, 30166, "epsg", 30166,
        "Tokyo / Japan Plane Rectangular CS VI", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VI\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",36],PARAMETER[\"central_meridian\",136],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30166\"]]");
    p = add_epsg_def_ex (filter, first, last, 30167, "epsg", 30167,
        "Tokyo / Japan Plane Rectangular CS VII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VII\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",36],PARAMETER[\"central_meridian\",137.1");
    add_srs_wkt (p, 8,
        "66666666667],PARAMETER[\"scale_factor\",0.9999],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",0],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"30167\"]]");
    p = add_epsg_def_ex (filter, first, last, 30168, "epsg", 30168,
        "Tokyo / Japan Plane Rectangular CS VIII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VIII\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",637");
    add_srs_wkt (p, 2,
        "7397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",36],PARAMETER[\"central_meridian\",138");
    add_srs_wkt (p, 8,
        ".5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30168\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 30169, "epsg", 30169,
        "Tokyo / Japan Plane Rectangular CS IX", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS IX\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",36],PARAMETER[\"central_meridian\",139.8");
    add_srs_wkt (p, 8,
        "33333333333],PARAMETER[\"scale_factor\",0.9999],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",0],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nor");
    add_srs_wkt (p, 11,
        "thing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"30169\"]]");
    p = add_epsg_def_ex (filter, first, last, 30170, "epsg", 30170,
        "Tokyo / Japan Plane Rectangular CS X", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS X\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",40],PARAMETER[\"central_meridian\",140.833");
    add_srs_wkt (p, 8,
        "333333333],PARAMETER[\"scale_factor\",0.9999],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",0],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "30170\"]]");
    p = add_epsg_def_ex (filter, first, last, 30171, "epsg", 30171,
        "Tokyo / Japan Plane Rectangular CS XI", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XI\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",44],PARAMETER[\"central_meridian\",140.2");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30171\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 30172, "epsg", 30172,
        "Tokyo / Japan Plane Rectangular CS XII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XII\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",44],PARAMETER[\"central_meridian\",142.2");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30172\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 30173, "epsg", 30173,
        "Tokyo / Japan Plane Rectangular CS XIII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XIII\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",637");
    add_srs_wkt (p, 2,
        "7397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",44],PARAMETER[\"central_meridian\",144");
    add_srs_wkt (p, 8,
        ".25],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30173");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 30174, "epsg", 30174,
        "Tokyo / Japan Plane Rectangular CS XIV", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XIV\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",26],PARAMETER[\"central_meridian\",142],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30174\"]]");
    p = add_epsg_def_ex (filter, first, last, 30175, "epsg", 30175,
        "Tokyo / Japan Plane Rectangular CS XV", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XV\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",26],PARAMETER[\"central_meridian\",127.5");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 11,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30175\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 30176, "epsg", 30176,
        "Tokyo / Japan Plane Rectangular CS XVI", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XVI\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",26],PARAMETER[\"central_meridian\",124],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30176\"]]");
    p = add_epsg_def_ex (filter, first, last, 30177, "epsg", 30177,
        "Tokyo / Japan Plane Rectangular CS XVII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XVII\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",637");
    add_srs_wkt (p, 2,
        "7397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",26],PARAMETER[\"central_meridian\",131");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 11,
        "TH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30177\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 30178, "epsg", 30178,
        "Tokyo / Japan Plane Rectangular CS XVIII", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XVIII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"430");
    add_srs_wkt (p, 6,
        "1\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",20],PARAMETER[\"central_meridian\",13");
    add_srs_wkt (p, 8,
        "6],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30178\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 30179, "epsg", 30179,
        "Tokyo / Japan Plane Rectangular CS XIX", 0, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XIX\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",26],PARAMETER[\"central_meridian\",154],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"30179\"]]");
    p = add_epsg_def_ex (filter, first, last, 30200, "epsg", 30200,
        "Trinidad 1903 / Trinidad Grid", 0, 0,
        "Clarke 1858", "Greenwich",
        "Trinidad_1903", "Cassini_Soldner", "Clarke's link",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=10.44166666666667 +lon_0=-61.333333333");
    add_proj4text (p, 1,
        "33334 +x_0=86501.46392051999 +y_0=65379.0134283 +a=63782");
    add_proj4text (p, 2,
        "93.645208759 +b=6356617.987679838 +towgs84=-61.702,284.4");
    add_proj4text (p, 3,
        "88,472.052,0,0,0,0 +to_meter=0.201166195164 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Trinidad 1903 / Trinidad Grid\",GEOGCS[\"Trinid");
    add_srs_wkt (p, 1,
        "ad 1903\",DATUM[\"Trinidad_1903\",SPHEROID[\"Clarke 1858");
    add_srs_wkt (p, 2,
        "\",6378293.64520876,294.260676369261,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7007\"]],AUTHORITY[\"EPSG\",\"6302\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4302\"]],PROJECTION[\"Cassini_Soldner\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",10.4416666666667],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-61.3333333333333],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",430000],PARAMETER[\"false_northing\",32500");
    add_srs_wkt (p, 10,
        "0],UNIT[\"Clarke's link\",0.201166195164,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9039\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"30200\"]]");
    p = add_epsg_def_ex (filter, first, last, 30339, "epsg", 30339,
        "TC(1948) / UTM zone 39N", 0, 0,
        "Helmert 1906", "Greenwich",
        "Trucial_Coast_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=helmert +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TC(1948) / UTM zone 39N\",GEOGCS[\"TC(1948)\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Trucial_Coast_1948\",SPHEROID[\"Helmert 1906\",63");
    add_srs_wkt (p, 2,
        "78200,298.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6303\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4303\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",51],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"30339\"]]");
    p = add_epsg_def_ex (filter, first, last, 30340, "epsg", 30340,
        "TC(1948) / UTM zone 40N", 0, 0,
        "Helmert 1906", "Greenwich",
        "Trucial_Coast_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=helmert +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TC(1948) / UTM zone 40N\",GEOGCS[\"TC(1948)\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Trucial_Coast_1948\",SPHEROID[\"Helmert 1906\",63");
    add_srs_wkt (p, 2,
        "78200,298.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6303\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4303\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",57],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"30340\"]]");
    p = add_epsg_def_ex (filter, first, last, 30491, "epsg", 30491,
        "Voirol 1875 / Nord Algerie (ancienne)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1875", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=2.7 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 2,
        "84=-73,-247,227,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Voirol 1875 / Nord Algerie (ancienne)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Voirol 1875\",DATUM[\"Voirol_1875\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7011\"]],AUTHORITY[\"EPSG\",\"6304\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4304\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",36],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",2.7],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.999625544],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",300000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"30491\"]]");
    p = add_epsg_def_ex (filter, first, last, 30492, "epsg", 30492,
        "Voirol 1875 / Sud Algerie (ancienne)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1875", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=2.7 +k_0=0.9996");
    add_proj4text (p, 1,
        "25769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +t");
    add_proj4text (p, 2,
        "owgs84=-73,-247,227,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Voirol 1875 / Sud Algerie (ancienne)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Voirol 1875\",DATUM[\"Voirol_1875\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7011\"]],AUTHORITY[\"EPSG\",\"6304\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4304\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",33.3],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",2.7],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.999625769],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",300000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"30492\"]]");
    p = add_epsg_def_ex (filter, first, last, 30493, "epsg", 30493,
        "Voirol 1879 / Nord Algerie (ancienne)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1879", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=2.7 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Voirol 1879 / Nord Algerie (ancienne)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Voirol 1879\",DATUM[\"Voirol_1879\",SPHEROID[\"Clarke ");
    add_srs_wkt (p, 2,
        "1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7011\"]],AUTHORITY[\"EPSG\",\"6671\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4671\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",36],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",2.7],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.999625544],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",300000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"30493\"]]");
    p = add_epsg_def_ex (filter, first, last, 30494, "epsg", 30494,
        "Voirol 1879 / Sud Algerie (ancienne)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Voirol_1879", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=2.7 +k_0=0.9996");
    add_proj4text (p, 1,
        "25769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Voirol 1879 / Sud Algerie (ancienne)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Voirol 1879\",DATUM[\"Voirol_1879\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7011\"]],AUTHORITY[\"EPSG\",\"6671\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4671\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",33.3],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",2.7],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "0.999625769],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",300000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"30494\"]]");
    p = add_epsg_def_ex (filter, first, last, 30729, "epsg", 30729,
        "Nord Sahara 1959 / UTM zone 29N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=clrk80 +towgs84=-209.3622,-87.");
    add_proj4text (p, 1,
        "8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / UTM zone 29N\",GEOGCS[\"Nord");
    add_srs_wkt (p, 1,
        " Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],AUTHORITY[\"EPSG\",\"6307\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4307\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-9],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"30729\"]]");
    p = add_epsg_def_ex (filter, first, last, 30730, "epsg", 30730,
        "Nord Sahara 1959 / UTM zone 30N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=clrk80 +towgs84=-209.3622,-87.");
    add_proj4text (p, 1,
        "8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / UTM zone 30N\",GEOGCS[\"Nord");
    add_srs_wkt (p, 1,
        " Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],AUTHORITY[\"EPSG\",\"6307\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4307\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-3],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"30730\"]]");
    p = add_epsg_def_ex (filter, first, last, 30731, "epsg", 30731,
        "Nord Sahara 1959 / UTM zone 31N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=clrk80 +towgs84=-209.3622,-87.");
    add_proj4text (p, 1,
        "8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / UTM zone 31N\",GEOGCS[\"Nord");
    add_srs_wkt (p, 1,
        " Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],AUTHORITY[\"EPSG\",\"6307\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4307\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",3],PARAMETER[\"scale_factor\",0.9996],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"30731\"]]");
    p = add_epsg_def_ex (filter, first, last, 30732, "epsg", 30732,
        "Nord Sahara 1959 / UTM zone 32N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=clrk80 +towgs84=-209.3622,-87.");
    add_proj4text (p, 1,
        "8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / UTM zone 32N\",GEOGCS[\"Nord");
    add_srs_wkt (p, 1,
        " Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],AUTHORITY[\"EPSG\",\"6307\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4307\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",9],PARAMETER[\"scale_factor\",0.9996],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",500000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"30732\"]]");
    p = add_epsg_def_ex (filter, first, last, 30791, "epsg", 30791,
        "Nord Sahara 1959 / Nord Algerie", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=2.7 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500135 +y_0=300090 +ellps=clrk80 +towgs84=-209.36");
    add_proj4text (p, 2,
        "22,-87.8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / Nord Algerie\",GEOGCS[\"Nord");
    add_srs_wkt (p, 1,
        " Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],AUTHORITY[\"EPSG\",\"6307\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4307\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 7,
        "c_1SP\"],PARAMETER[\"latitude_of_origin\",36],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",2.7],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "99625544],PARAMETER[\"false_easting\",500135],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",300090],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"30791\"]]");
    p = add_epsg_def_ex (filter, first, last, 30792, "epsg", 30792,
        "Nord Sahara 1959 / Sud Algerie", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Nord_Sahara_1959", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=2.7 +k_0=0.9996");
    add_proj4text (p, 1,
        "25769 +x_0=500135 +y_0=300090 +ellps=clrk80 +towgs84=-20");
    add_proj4text (p, 2,
        "9.3622,-87.8162,404.6198,0.0046,3.4784,0.5805,-1.4547 +u");
    add_proj4text (p, 3,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Nord Sahara 1959 / Sud Algerie\",GEOGCS[\"Nord ");
    add_srs_wkt (p, 1,
        "Sahara 1959\",DATUM[\"Nord_Sahara_1959\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7012\"]],AUTHORITY[\"EPSG\",\"6307\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4307\"]],PROJECTION[\"Lambert_Conformal_Conic_1");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"latitude_of_origin\",33.3],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",2.7],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "625769],PARAMETER[\"false_easting\",500135],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",300090],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"30792\"]]");
    p = add_epsg_def_ex (filter, first, last, 30800, "epsg", 30800,
        "RT38 2.5 gon W (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Stockholm_1938", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=");
    add_proj4text (p, 1,
        "1500000 +y_0=0 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RT38 2.5 gon W (deprecated)\",GEOGCS[\"RT38\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Stockholm_1938\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6308\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4308\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",15.80827");
    add_srs_wkt (p, 8,
        "77777778],PARAMETER[\"scale_factor\",1],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",1500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 11,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "30800\"]]");
    p = add_epsg_def_ex (filter, first, last, 31028, "epsg", 31028,
        "Yoff / UTM zone 28N", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Yoff", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-30,");
    add_proj4text (p, 1,
        "190,89,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Yoff / UTM zone 28N\",GEOGCS[\"Yoff\",DATUM[\"Y");
    add_srs_wkt (p, 1,
        "off\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602");
    add_srs_wkt (p, 2,
        "1293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6310\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4310\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",-15],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"31028\"]]");
    p = add_epsg_def_ex (filter, first, last, 31121, "epsg", 31121,
        "Zanderij / UTM zone 21N", 0, 0,
        "International 1924", "Greenwich",
        "Zanderij", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=intl +towgs84=-265,120,-358,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Zanderij / UTM zone 21N\",GEOGCS[\"Zanderij\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Zanderij\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6311\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4311\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"31121\"]]");
    p = add_epsg_def_ex (filter, first, last, 31154, "epsg", 31154,
        "Zanderij / TM 54 NW", 0, 0,
        "International 1924", "Greenwich",
        "Zanderij", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-54 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=intl +towgs84=-265,120,-358,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Zanderij / TM 54 NW\",GEOGCS[\"Zanderij\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Zanderij\",SPHEROID[\"International 1924\",6378388,29");
    add_srs_wkt (p, 2,
        "7,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"631");
    add_srs_wkt (p, 3,
        "1\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4311\"]],PROJECTION[\"T");
    add_srs_wkt (p, 6,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"central_meridian\",-54],PARAMETER[\"scale_");
    add_srs_wkt (p, 8,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 10,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 11,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"31154\"]]");
    p = add_epsg_def_ex (filter, first, last, 31170, "epsg", 31170,
        "Zanderij / Suriname Old TM", 0, 0,
        "International 1924", "Greenwich",
        "Zanderij", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-55.68333333333333 +k=0.9996");
    add_proj4text (p, 1,
        " +x_0=500000 +y_0=0 +ellps=intl +towgs84=-265,120,-358,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Zanderij / Suriname Old TM\",GEOGCS[\"Zanderij\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Zanderij\",SPHEROID[\"International 1924\",6378");
    add_srs_wkt (p, 2,
        "388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6311\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4311\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",-55.6833333333333");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"311");
    add_srs_wkt (p, 12,
        "70\"]]");
    p = add_epsg_def_ex (filter, first, last, 31171, "epsg", 31171,
        "Zanderij / Suriname TM", 0, 0,
        "International 1924", "Greenwich",
        "Zanderij", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-55.68333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=500000 +y_0=0 +ellps=intl +towgs84=-265,120,-358,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Zanderij / Suriname TM\",GEOGCS[\"Zanderij\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Zanderij\",SPHEROID[\"International 1924\",6378388");
    add_srs_wkt (p, 2,
        ",297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6311\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4311\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",-55.6833333333333],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31171\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 31251, "epsg", 31251,
        "MGI (Ferro) / Austria GK West Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=0 +y_0=-5000000");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.4");
    add_proj4text (p, 2,
        "74,5.297,2.4232 +pm=ferro +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria GK West Zone\",GEOGCS[\"M");
    add_srs_wkt (p, 1,
        "GI (Ferro)\",DATUM[\"Militar-Geographische_Institut_Ferr");
    add_srs_wkt (p, 2,
        "o\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6805\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",28],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",-5000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"31251\"]]");
    p = add_epsg_def_ex (filter, first, last, 31252, "epsg", 31252,
        "MGI (Ferro) / Austria GK Central Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=-5000000");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.4");
    add_proj4text (p, 2,
        "74,5.297,2.4232 +pm=ferro +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria GK Central Zone\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"MGI (Ferro)\",DATUM[\"Militar-Geographische_Institut_F");
    add_srs_wkt (p, 2,
        "erro\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6805\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",31],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",-5000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"31252\"]]");
    p = add_epsg_def_ex (filter, first, last, 31253, "epsg", 31253,
        "MGI (Ferro) / Austria GK East Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=0 +y_0=-5000000");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.4");
    add_proj4text (p, 2,
        "74,5.297,2.4232 +pm=ferro +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria GK East Zone\",GEOGCS[\"M");
    add_srs_wkt (p, 1,
        "GI (Ferro)\",DATUM[\"Militar-Geographische_Institut_Ferr");
    add_srs_wkt (p, 2,
        "o\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6805\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",34],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",-5000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"31253\"]]");
    p = add_epsg_def_ex (filter, first, last, 31254, "epsg", 31254,
        "MGI / Austria GK West", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,46");
    add_proj4text (p, 2,
        "3.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK West\",GEOGCS[\"MGI\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Militar-Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "0.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",0],PARAMETER[\"false_northing\",-5000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"31254\"]]");
    p = add_epsg_def_ex (filter, first, last, 31255, "epsg", 31255,
        "MGI / Austria GK Central", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,46");
    add_proj4text (p, 2,
        "3.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK Central\",GEOGCS[\"MGI\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Militar-Geographische_Institut\",SPHEROID[\"Bessel 18");
    add_srs_wkt (p, 2,
        "41\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",13.3333333333333],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",0],PARAMETER[\"false_northing\",-");
    add_srs_wkt (p, 10,
        "5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31255\"]]");
    p = add_epsg_def_ex (filter, first, last, 31256, "epsg", 31256,
        "MGI / Austria GK East", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,46");
    add_proj4text (p, 2,
        "3.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK East\",GEOGCS[\"MGI\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Militar-Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "6.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",0],PARAMETER[\"false_northing\",-5000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"31256\"]]");
    p = add_epsg_def_ex (filter, first, last, 31257, "epsg", 31257,
        "MGI / Austria GK M28", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "150000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.1");
    add_proj4text (p, 2,
        "29,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK M28\",GEOGCS[\"MGI\",DATUM[\"M");
    add_srs_wkt (p, 1,
        "ilitar-Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "0.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",150000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"31257\"]]");
    p = add_epsg_def_ex (filter, first, last, 31258, "epsg", 31258,
        "MGI / Austria GK M31", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "450000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.1");
    add_proj4text (p, 2,
        "29,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK M31\",GEOGCS[\"MGI\",DATUM[\"M");
    add_srs_wkt (p, 1,
        "ilitar-Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "3.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",450000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"31258\"]]");
    p = add_epsg_def_ex (filter, first, last, 31259, "epsg", 31259,
        "MGI / Austria GK M34", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "750000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.1");
    add_proj4text (p, 2,
        "29,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria GK M34\",GEOGCS[\"MGI\",DATUM[\"M");
    add_srs_wkt (p, 1,
        "ilitar-Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "6.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",750000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"31259\"]]");
    p = add_epsg_def_ex (filter, first, last, 31265, "epsg", 31265,
        "MGI / 3-degree Gauss zone 5 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.47");
    add_proj4text (p, 2,
        "4,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / 3-degree Gauss zone 5 (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"MGI\",DATUM[\"Militar-Geographische_Institut\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",15],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",5500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31265\"]]");
    p = add_epsg_def_ex (filter, first, last, 31266, "epsg", 31266,
        "MGI / 3-degree Gauss zone 6 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.47");
    add_proj4text (p, 2,
        "4,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / 3-degree Gauss zone 6 (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"MGI\",DATUM[\"Militar-Geographische_Institut\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",18],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",6500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31266\"]]");
    p = add_epsg_def_ex (filter, first, last, 31267, "epsg", 31267,
        "MGI / 3-degree Gauss zone 7 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.47");
    add_proj4text (p, 2,
        "4,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / 3-degree Gauss zone 7 (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"MGI\",DATUM[\"Militar-Geographische_Institut\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",21],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",7500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31267\"]]");
    p = add_epsg_def_ex (filter, first, last, 31268, "epsg", 31268,
        "MGI / 3-degree Gauss zone 8 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.47");
    add_proj4text (p, 2,
        "4,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / 3-degree Gauss zone 8 (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"MGI\",DATUM[\"Militar-Geographische_Institut\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",24],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",8500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31268\"]]");
    p = add_epsg_def_ex (filter, first, last, 31275, "epsg", 31275,
        "MGI / Balkans zone 5 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=5500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137");
    add_proj4text (p, 2,
        ",1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Balkans zone 5 (deprecated)\",GEOGCS[\"MG");
    add_srs_wkt (p, 1,
        "I\",DATUM[\"Militar-Geographische_Institut\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",15],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",5500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31275\"]]");
    p = add_epsg_def_ex (filter, first, last, 31276, "epsg", 31276,
        "MGI / Balkans zone 6 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=6500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137");
    add_proj4text (p, 2,
        ",1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Balkans zone 6 (deprecated)\",GEOGCS[\"MG");
    add_srs_wkt (p, 1,
        "I\",DATUM[\"Militar-Geographische_Institut\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",18],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",6500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31276\"]]");
    p = add_epsg_def_ex (filter, first, last, 31277, "epsg", 31277,
        "MGI / Balkans zone 7 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137");
    add_proj4text (p, 2,
        ",1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Balkans zone 7 (deprecated)\",GEOGCS[\"MG");
    add_srs_wkt (p, 1,
        "I\",DATUM[\"Militar-Geographische_Institut\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",21],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",7500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31277\"]]");
    p = add_epsg_def_ex (filter, first, last, 31278, "epsg", 31278,
        "MGI / Balkans zone 8 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137");
    add_proj4text (p, 2,
        ",1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Balkans zone 8 (deprecated)\",GEOGCS[\"MG");
    add_srs_wkt (p, 1,
        "I\",DATUM[\"Militar-Geographische_Institut\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",21],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",7500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31278\"]]");
    p = add_epsg_def_ex (filter, first, last, 31279, "epsg", 31279,
        "MGI / Balkans zone 8 (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=8500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137");
    add_proj4text (p, 2,
        ",1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Balkans zone 8 (deprecated)\",GEOGCS[\"MG");
    add_srs_wkt (p, 1,
        "I\",DATUM[\"Militar-Geographische_Institut\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",24],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",8500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31279\"]]");
    p = add_epsg_def_ex (filter, first, last, 31281, "epsg", 31281,
        "MGI (Ferro) / Austria West Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria West Zone\",GEOGCS[\"MGI ");
    add_srs_wkt (p, 1,
        "(Ferro)\",DATUM[\"Militar-Geographische_Institut_Ferro\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6805\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"89");
    add_srs_wkt (p, 5,
        "09\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTION");
    add_srs_wkt (p, 7,
        "[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",0],PARAMETER[\"central_meridian\",28],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"31281\"]]");
    p = add_epsg_def_ex (filter, first, last, 31282, "epsg", 31282,
        "MGI (Ferro) / Austria Central Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria Central Zone\",GEOGCS[\"M");
    add_srs_wkt (p, 1,
        "GI (Ferro)\",DATUM[\"Militar-Geographische_Institut_Ferr");
    add_srs_wkt (p, 2,
        "o\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6805\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8909\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",0],PARAMETER[\"central_meridian\",31],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"31282\"]]");
    p = add_epsg_def_ex (filter, first, last, 31283, "epsg", 31283,
        "MGI (Ferro) / Austria East Zone", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria East Zone\",GEOGCS[\"MGI ");
    add_srs_wkt (p, 1,
        "(Ferro)\",DATUM[\"Militar-Geographische_Institut_Ferro\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6805\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"89");
    add_srs_wkt (p, 5,
        "09\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTION");
    add_srs_wkt (p, 7,
        "[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 8,
        "\",0],PARAMETER[\"central_meridian\",34],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"31283\"]]");
    p = add_epsg_def_ex (filter, first, last, 31284, "epsg", 31284,
        "MGI / Austria M28", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "150000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria M28\",GEOGCS[\"MGI\",DATUM[\"Mili");
    add_srs_wkt (p, 1,
        "tar-Geographische_Institut\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"431");
    add_srs_wkt (p, 6,
        "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",10.");
    add_srs_wkt (p, 8,
        "3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",150000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"31284\"]]");
    p = add_epsg_def_ex (filter, first, last, 31285, "epsg", 31285,
        "MGI / Austria M31", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "450000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria M31\",GEOGCS[\"MGI\",DATUM[\"Mili");
    add_srs_wkt (p, 1,
        "tar-Geographische_Institut\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"431");
    add_srs_wkt (p, 6,
        "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",13.");
    add_srs_wkt (p, 8,
        "3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",450000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"31285\"]]");
    p = add_epsg_def_ex (filter, first, last, 31286, "epsg", 31286,
        "MGI / Austria M34", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "750000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria M34\",GEOGCS[\"MGI\",DATUM[\"Mili");
    add_srs_wkt (p, 1,
        "tar-Geographische_Institut\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"431");
    add_srs_wkt (p, 6,
        "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",16.");
    add_srs_wkt (p, 8,
        "3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",750000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 10,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"No");
    add_srs_wkt (p, 11,
        "rthing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"31286\"]]");
    p = add_epsg_def_ex (filter, first, last, 31287, "epsg", 31287,
        "MGI / Austria Lambert", 0, 1,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.3333");
    add_proj4text (p, 1,
        "3333333333 +x_0=400000 +y_0=400000 +ellps=bessel +towgs8");
    add_proj4text (p, 2,
        "4=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria Lambert\",GEOGCS[\"MGI\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Militar-Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4312\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",47.5],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",13.3333333333333],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",49],PARAMETER[\"standard_parallel_2\",46],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",400000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"31287\"]]");
    p = add_epsg_def_ex (filter, first, last, 31288, "epsg", 31288,
        "MGI (Ferro) / Austria zone M28", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=150000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria zone M28\",GEOGCS[\"MGI (");
    add_srs_wkt (p, 1,
        "Ferro)\",DATUM[\"Militar-Geographische_Institut_Ferro\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6805\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "9\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",28],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",150000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"31288\"]]");
    p = add_epsg_def_ex (filter, first, last, 31289, "epsg", 31289,
        "MGI (Ferro) / Austria zone M31", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=450000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria zone M31\",GEOGCS[\"MGI (");
    add_srs_wkt (p, 1,
        "Ferro)\",DATUM[\"Militar-Geographische_Institut_Ferro\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6805\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "9\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",31],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",450000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"31289\"]]");
    p = add_epsg_def_ex (filter, first, last, 31290, "epsg", 31290,
        "MGI (Ferro) / Austria zone M34", 0, 1,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=750000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria zone M34\",GEOGCS[\"MGI (");
    add_srs_wkt (p, 1,
        "Ferro)\",DATUM[\"Militar-Geographische_Institut_Ferro\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6805\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Ferro\",-17.6666666666667,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "9\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",34],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",750000],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"31290\"]]");
    p = add_epsg_def_ex (filter, first, last, 31291, "epsg", 31291,
        "MGI (Ferro) / Austria West Zone (deprecated)", 0, 0,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria West Zone (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"MGI (Ferro)\",DATUM[\"Militar-Geographische_Ins");
    add_srs_wkt (p, 2,
        "titut_Ferro\",SPHEROID[\"Bessel 1841\",6377397.155,299.1");
    add_srs_wkt (p, 3,
        "528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6805\"]],PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8909\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",28],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"31291\"]]");
    p = add_epsg_def_ex (filter, first, last, 31292, "epsg", 31292,
        "MGI (Ferro) / Austria Central Zone (deprecated)", 0, 0,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria Central Zone (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"MGI (Ferro)\",DATUM[\"Militar-Geographische_");
    add_srs_wkt (p, 2,
        "Institut_Ferro\",SPHEROID[\"Bessel 1841\",6377397.155,29");
    add_srs_wkt (p, 3,
        "9.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6805\"]],PRIMEM[\"Ferro\",-17.6666666666667,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8909\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"480");
    add_srs_wkt (p, 7,
        "5\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",0],PARAMETER[\"central_meridian\",31]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31292\"]]");
    p = add_epsg_def_ex (filter, first, last, 31293, "epsg", 31293,
        "MGI (Ferro) / Austria East Zone (deprecated)", 0, 0,
        "Bessel 1841", "Ferro",
        "Militar-Geographische_Institut_Ferro", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=0 +y_0=0 +ellps");
    add_proj4text (p, 1,
        "=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI (Ferro) / Austria East Zone (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"MGI (Ferro)\",DATUM[\"Militar-Geographische_Ins");
    add_srs_wkt (p, 2,
        "titut_Ferro\",SPHEROID[\"Bessel 1841\",6377397.155,299.1");
    add_srs_wkt (p, 3,
        "528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6805\"]],PRIMEM[\"Ferro\",-17.6666666666667,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8909\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4805\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",34],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"31293\"]]");
    p = add_epsg_def_ex (filter, first, last, 31294, "epsg", 31294,
        "MGI / M28 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "150000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / M28 (deprecated)\",GEOGCS[\"MGI\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Militar-Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "0.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",150000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"31294\"]]");
    p = add_epsg_def_ex (filter, first, last, 31295, "epsg", 31295,
        "MGI / M31 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "450000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / M31 (deprecated)\",GEOGCS[\"MGI\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Militar-Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "3.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",450000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"31295\"]]");
    p = add_epsg_def_ex (filter, first, last, 31296, "epsg", 31296,
        "MGI / M34 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=");
    add_proj4text (p, 1,
        "750000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.");
    add_proj4text (p, 2,
        "919,5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / M34 (deprecated)\",GEOGCS[\"MGI\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Militar-Geographische_Institut\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4312\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "6.3333333333333],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",750000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"31296\"]]");
    p = add_epsg_def_ex (filter, first, last, 31297, "epsg", 31297,
        "MGI / Austria Lambert (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Militar-Geographische_Institut", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.3333");
    add_proj4text (p, 1,
        "3333333333 +x_0=400000 +y_0=400000 +ellps=bessel +towgs8");
    add_proj4text (p, 2,
        "4=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Austria Lambert (deprecated)\",GEOGCS[\"M");
    add_srs_wkt (p, 1,
        "GI\",DATUM[\"Militar-Geographische_Institut\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6312\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4312\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 7,
        "ic_2SP\"],PARAMETER[\"latitude_of_origin\",47.5],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",13.3333333333333],PARAMETER[\"st");
    add_srs_wkt (p, 9,
        "andard_parallel_1\",49],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",46],PARAMETER[\"false_easting\",400000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"31297\"]]");
    p = add_epsg_def_ex (filter, first, last, 31300, "epsg", 31300,
        "BD72 / Belge Lambert 72", 0, 0,
        "International 1924", "Greenwich",
        "Reseau_National_Belge_1972", "Lambert_Conformal_Conic_2SP_Belgium", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=90 +lon_0=4.356939722222222 +x_0=150000.01256");
    add_proj4text (p, 2,
        " +y_0=5400088.4378 +ellps=intl +towgs84=-106.8686,52.297");
    add_proj4text (p, 3,
        "8,-103.7239,0.3366,-0.457,1.8422,-1.2747 +units=m +no_de");
    add_proj4text (p, 4,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BD72 / Belge Lambert 72\",GEOGCS[\"BD72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Reseau_National_Belge_1972\",SPHEROID[\"International");
    add_srs_wkt (p, 2,
        " 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6313\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4313\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP_Belgium\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",4.35693972222222],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",49.8333333333333],PARAMETER[\"standard_parallel_2");
    add_srs_wkt (p, 10,
        "\",51.1666666666667],PARAMETER[\"false_easting\",150000.");
    add_srs_wkt (p, 11,
        "01256],PARAMETER[\"false_northing\",5400088.4378],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"313");
    add_srs_wkt (p, 14,
        "00\"]]");
    p = add_epsg_def_ex (filter, first, last, 31370, "epsg", 31370,
        "BD72 / Belgian Lambert 72", 0, 0,
        "International 1924", "Greenwich",
        "Reseau_National_Belge_1972", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=51.16666723333333 +lat_2=49.8333339 +la");
    add_proj4text (p, 1,
        "t_0=90 +lon_0=4.367486666666666 +x_0=150000.013 +y_0=540");
    add_proj4text (p, 2,
        "0088.438 +ellps=intl +towgs84=-106.8686,52.2978,-103.723");
    add_proj4text (p, 3,
        "9,0.3366,-0.457,1.8422,-1.2747 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BD72 / Belgian Lambert 72\",GEOGCS[\"BD72\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Reseau_National_Belge_1972\",SPHEROID[\"Internation");
    add_srs_wkt (p, 2,
        "al 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6313\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"431");
    add_srs_wkt (p, 6,
        "3\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_origin\",90],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",4.36748666666667],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",51.1666672333333],PARAMETER[\"standard_parallel_2\",49.");
    add_srs_wkt (p, 10,
        "8333339],PARAMETER[\"false_easting\",150000.013],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",5400088.438],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"31370\"]]");
    p = add_epsg_def_ex (filter, first, last, 31461, "epsg", 31461,
        "DHDN / 3-degree Gauss zone 1 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=3 +k=1 +x_0=1500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss zone 1 (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",3],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",1500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"31461\"]]");
    p = add_epsg_def_ex (filter, first, last, 31462, "epsg", 31462,
        "DHDN / 3-degree Gauss zone 2 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss zone 2 (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",6],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",2500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"31462\"]]");
    p = add_epsg_def_ex (filter, first, last, 31463, "epsg", 31463,
        "DHDN / 3-degree Gauss zone 3 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss zone 3 (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",9],PARAMETER[\"scale_factor\",1],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",3500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"31463\"]]");
    p = add_epsg_def_ex (filter, first, last, 31464, "epsg", 31464,
        "DHDN / 3-degree Gauss zone 4 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss zone 4 (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",12],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",4500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31464\"]]");
    p = add_epsg_def_ex (filter, first, last, 31465, "epsg", 31465,
        "DHDN / 3-degree Gauss zone 5 (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss zone 5 (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",15],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",5500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"31465\"]]");
    p = add_epsg_def_ex (filter, first, last, 31466, "epsg", 31466,
        "DHDN / 3-degree Gauss-Kruger zone 2", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 2\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",6],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",2500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"31466\"]]");
    p = add_epsg_def_ex (filter, first, last, 31467, "epsg", 31467,
        "DHDN / 3-degree Gauss-Kruger zone 3", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.45");
    add_proj4text (p, 2,
        "5,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 3\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",3500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"31467\"]]");
    p = add_epsg_def_ex (filter, first, last, 31468, "epsg", 31468,
        "DHDN / 3-degree Gauss-Kruger zone 4", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 4\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",12],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",4500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"31468\"]]");
    p = add_epsg_def_ex (filter, first, last, 31469, "epsg", 31469,
        "DHDN / 3-degree Gauss-Kruger zone 5", 0, 1,
        "Bessel 1841", "Greenwich",
        "Deutsches_Hauptdreiecksnetz", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.4");
    add_proj4text (p, 2,
        "55,6.7 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DHDN / 3-degree Gauss-Kruger zone 5\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "DHDN\",DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7004\"]],AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4314\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",5500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"31469\"]]");
    p = add_epsg_def_ex (filter, first, last, 31528, "epsg", 31528,
        "Conakry 1905 / UTM zone 28N", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Conakry_1905", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-23,");
    add_proj4text (p, 1,
        "259,-9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Conakry 1905 / UTM zone 28N\",GEOGCS[\"Conakry ");
    add_srs_wkt (p, 1,
        "1905\",DATUM[\"Conakry_1905\",SPHEROID[\"Clarke 1880 (IG");
    add_srs_wkt (p, 2,
        "N)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "1\"]],AUTHORITY[\"EPSG\",\"6315\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4315\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-15],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"31528\"]]");
    p = add_epsg_def_ex (filter, first, last, 31529, "epsg", 31529,
        "Conakry 1905 / UTM zone 29N", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Conakry_1905", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-23,");
    add_proj4text (p, 1,
        "259,-9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Conakry 1905 / UTM zone 29N\",GEOGCS[\"Conakry ");
    add_srs_wkt (p, 1,
        "1905\",DATUM[\"Conakry_1905\",SPHEROID[\"Clarke 1880 (IG");
    add_srs_wkt (p, 2,
        "N)\",6378249.2,293.466021293627,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "1\"]],AUTHORITY[\"EPSG\",\"6315\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4315\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"31529\"]]");
    p = add_epsg_def_ex (filter, first, last, 31600, "epsg", 31600,
        "Dealul Piscului 1930 / Stereo 33", 0, 0,
        "International 1924", "Greenwich",
        "Dealul_Piscului_1930", "Oblique_Stereographic", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=45.9 +lon_0=25.39246588888889 +k=0.9");
    add_proj4text (p, 1,
        "996667 +x_0=500000 +y_0=500000 +ellps=intl +towgs84=103.");
    add_proj4text (p, 2,
        "25,-100.4,-307.19,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Dealul Piscului 1930 / Stereo 33\",GEOGCS[\"Dea");
    add_srs_wkt (p, 1,
        "lul Piscului 1930\",DATUM[\"Dealul_Piscului_1930\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"6316\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4316\"]],PROJECTION[\"Oblique_Stereographic");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",45.9],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",25.3924658888889],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9996667],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",500000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"31600\"]]");
    p = add_epsg_def_ex (filter, first, last, 31700, "epsg", 31700,
        "Dealul Piscului 1970/ Stereo 70 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Dealul_Piscului_1970", "Oblique_Stereographic", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=46 +lon_0=25 +k=0.99975 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=500000 +ellps=krass +towgs84=28,-121,-77,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Dealul Piscului 1970/ Stereo 70 (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Dealul Piscului 1970 (deprecated)\",DATUM[\"Dea");
    add_srs_wkt (p, 2,
        "lul_Piscului_1970\",SPHEROID[\"Krassowsky 1940\",6378245");
    add_srs_wkt (p, 3,
        ",298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6317\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4317\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Oblique_Stereographic\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 8,
        "gin\",46],PARAMETER[\"central_meridian\",25],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.99975],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",500000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"31700\"]]");
    p = add_epsg_def_ex (filter, first, last, 31838, "epsg", 31838,
        "NGN / UTM zone 38N", 0, 0,
        "WGS 84", "Greenwich",
        "National_Geodetic_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGN / UTM zone 38N\",GEOGCS[\"NGN\",DATUM[\"Nat");
    add_srs_wkt (p, 1,
        "ional_Geodetic_Network\",SPHEROID[\"WGS 84\",6378137,298");
    add_srs_wkt (p, 2,
        ".257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6318\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4318\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",45],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31838\"]]");
    p = add_epsg_def_ex (filter, first, last, 31839, "epsg", 31839,
        "NGN / UTM zone 39N", 0, 0,
        "WGS 84", "Greenwich",
        "National_Geodetic_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NGN / UTM zone 39N\",GEOGCS[\"NGN\",DATUM[\"Nat");
    add_srs_wkt (p, 1,
        "ional_Geodetic_Network\",SPHEROID[\"WGS 84\",6378137,298");
    add_srs_wkt (p, 2,
        ".257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6318\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4318\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",51],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31839\"]]");
    p = add_epsg_def_ex (filter, first, last, 31900, "epsg", 31900,
        "KUDAMS / KTM (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "Kuwait_Utility", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=48 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=-20.8,11.3,2.4,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KUDAMS / KTM (deprecated)\",GEOGCS[\"KUDAMS\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Kuwait_Utility\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6319\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4319\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",48],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"31900\"]]");
    p = add_epsg_def_ex (filter, first, last, 31901, "epsg", 31901,
        "KUDAMS / KTM", 0, 0,
        "GRS 1980", "Greenwich",
        "Kuwait_Utility", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=-20.8,11.3,2.4,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KUDAMS / KTM\",GEOGCS[\"KUDAMS\",DATUM[\"Kuwait");
    add_srs_wkt (p, 1,
        "_Utility\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 2,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6319\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4319\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 6,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"central_meridian\",48],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 8,
        "or\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 10,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 11,
        "H],AUTHORITY[\"EPSG\",\"31901\"]]");
    p = add_epsg_def_ex (filter, first, last, 31965, "epsg", 31965,
        "SIRGAS 2000 / UTM zone 11N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 11N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-117],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"31965\"]]");
    p = add_epsg_def_ex (filter, first, last, 31966, "epsg", 31966,
        "SIRGAS 2000 / UTM zone 12N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 12N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"31966\"]]");
    p = add_epsg_def_ex (filter, first, last, 31967, "epsg", 31967,
        "SIRGAS 2000 / UTM zone 13N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 13N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-105],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"31967\"]]");
    p = add_epsg_def_ex (filter, first, last, 31968, "epsg", 31968,
        "SIRGAS 2000 / UTM zone 14N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 14N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-99],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"31968\"]]");
    p = add_epsg_def_ex (filter, first, last, 31969, "epsg", 31969,
        "SIRGAS 2000 / UTM zone 15N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 15N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-93],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"31969\"]]");
    p = add_epsg_def_ex (filter, first, last, 31970, "epsg", 31970,
        "SIRGAS 2000 / UTM zone 16N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 16N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-87],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"31970\"]]");
    p = add_epsg_def_ex (filter, first, last, 31971, "epsg", 31971,
        "SIRGAS 2000 / UTM zone 17N", 0, 0,
        "GRS 1980", "Greenwich",
        "Sistema_de_Referencia_Geocentrico_para_las_AmericaS_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 2000 / UTM zone 17N\",GEOGCS[\"SIRGAS 20");
    add_srs_wkt (p, 1,
        "00\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_las_");
    add_srs_wkt (p, 2,
        "AmericaS_2000\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "674\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4674\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",-81],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"31971\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

