// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(cmn)                       \
  M(cmp)                       \
  M(mov)                       \
  M(movs)                      \
  M(mvn)                       \
  M(mvns)                      \
  M(teq)                       \
  M(tst)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  ShiftType shift;
  Register rs;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] = {
    {{gt, r13, r11, LSL, r12},
     false,
     al,
     "gt r13 r11 LSL r12",
     "gt_r13_r11_LSL_r12"},
    {{gt, r12, r4, LSR, r6}, false, al, "gt r12 r4 LSR r6", "gt_r12_r4_LSR_r6"},
    {{ge, r11, r13, ROR, r2},
     false,
     al,
     "ge r11 r13 ROR r2",
     "ge_r11_r13_ROR_r2"},
    {{hi, r9, r8, ASR, r10}, false, al, "hi r9 r8 ASR r10", "hi_r9_r8_ASR_r10"},
    {{al, r9, r10, LSL, r4}, false, al, "al r9 r10 LSL r4", "al_r9_r10_LSL_r4"},
    {{gt, r4, r11, LSR, r4}, false, al, "gt r4 r11 LSR r4", "gt_r4_r11_LSR_r4"},
    {{vc, r4, r6, ASR, r11}, false, al, "vc r4 r6 ASR r11", "vc_r4_r6_ASR_r11"},
    {{mi, r9, r14, LSR, r9}, false, al, "mi r9 r14 LSR r9", "mi_r9_r14_LSR_r9"},
    {{ne, r5, r10, LSR, r8}, false, al, "ne r5 r10 LSR r8", "ne_r5_r10_LSR_r8"},
    {{eq, r3, r0, ROR, r11}, false, al, "eq r3 r0 ROR r11", "eq_r3_r0_ROR_r11"},
    {{gt, r9, r11, LSL, r12},
     false,
     al,
     "gt r9 r11 LSL r12",
     "gt_r9_r11_LSL_r12"},
    {{ge, r14, r6, ROR, r13},
     false,
     al,
     "ge r14 r6 ROR r13",
     "ge_r14_r6_ROR_r13"},
    {{vc, r14, r14, LSR, r11},
     false,
     al,
     "vc r14 r14 LSR r11",
     "vc_r14_r14_LSR_r11"},
    {{cc, r6, r3, LSL, r2}, false, al, "cc r6 r3 LSL r2", "cc_r6_r3_LSL_r2"},
    {{ge, r4, r6, ROR, r7}, false, al, "ge r4 r6 ROR r7", "ge_r4_r6_ROR_r7"},
    {{vs, r13, r3, LSR, r12},
     false,
     al,
     "vs r13 r3 LSR r12",
     "vs_r13_r3_LSR_r12"},
    {{ge, r8, r11, LSR, r13},
     false,
     al,
     "ge r8 r11 LSR r13",
     "ge_r8_r11_LSR_r13"},
    {{cc, r5, r0, LSR, r10}, false, al, "cc r5 r0 LSR r10", "cc_r5_r0_LSR_r10"},
    {{lt, r7, r12, ASR, r7}, false, al, "lt r7 r12 ASR r7", "lt_r7_r12_ASR_r7"},
    {{cc, r14, r1, LSR, r14},
     false,
     al,
     "cc r14 r1 LSR r14",
     "cc_r14_r1_LSR_r14"},
    {{vs, r10, r1, LSR, r1}, false, al, "vs r10 r1 LSR r1", "vs_r10_r1_LSR_r1"},
    {{lt, r5, r0, ASR, r2}, false, al, "lt r5 r0 ASR r2", "lt_r5_r0_ASR_r2"},
    {{ne, r6, r3, LSL, r2}, false, al, "ne r6 r3 LSL r2", "ne_r6_r3_LSL_r2"},
    {{vs, r5, r5, LSL, r13}, false, al, "vs r5 r5 LSL r13", "vs_r5_r5_LSL_r13"},
    {{hi, r9, r11, ROR, r13},
     false,
     al,
     "hi r9 r11 ROR r13",
     "hi_r9_r11_ROR_r13"},
    {{vs, r0, r2, LSL, r6}, false, al, "vs r0 r2 LSL r6", "vs_r0_r2_LSL_r6"},
    {{le, r7, r1, ASR, r0}, false, al, "le r7 r1 ASR r0", "le_r7_r1_ASR_r0"},
    {{ge, r2, r12, LSL, r10},
     false,
     al,
     "ge r2 r12 LSL r10",
     "ge_r2_r12_LSL_r10"},
    {{vc, r14, r1, ASR, r9}, false, al, "vc r14 r1 ASR r9", "vc_r14_r1_ASR_r9"},
    {{lt, r5, r1, ROR, r5}, false, al, "lt r5 r1 ROR r5", "lt_r5_r1_ROR_r5"},
    {{eq, r5, r12, ROR, r0}, false, al, "eq r5 r12 ROR r0", "eq_r5_r12_ROR_r0"},
    {{pl, r7, r7, ASR, r9}, false, al, "pl r7 r7 ASR r9", "pl_r7_r7_ASR_r9"},
    {{eq, r3, r10, LSR, r9}, false, al, "eq r3 r10 LSR r9", "eq_r3_r10_LSR_r9"},
    {{ge, r0, r5, LSR, r13}, false, al, "ge r0 r5 LSR r13", "ge_r0_r5_LSR_r13"},
    {{cc, r13, r1, ASR, r6}, false, al, "cc r13 r1 ASR r6", "cc_r13_r1_ASR_r6"},
    {{cs, r12, r3, ASR, r12},
     false,
     al,
     "cs r12 r3 ASR r12",
     "cs_r12_r3_ASR_r12"},
    {{al, r12, r10, ROR, r0},
     false,
     al,
     "al r12 r10 ROR r0",
     "al_r12_r10_ROR_r0"},
    {{al, r6, r13, LSL, r0}, false, al, "al r6 r13 LSL r0", "al_r6_r13_LSL_r0"},
    {{cc, r14, r14, ROR, r0},
     false,
     al,
     "cc r14 r14 ROR r0",
     "cc_r14_r14_ROR_r0"},
    {{ge, r2, r14, ROR, r9}, false, al, "ge r2 r14 ROR r9", "ge_r2_r14_ROR_r9"},
    {{hi, r5, r10, LSL, r8}, false, al, "hi r5 r10 LSL r8", "hi_r5_r10_LSL_r8"},
    {{ge, r13, r5, LSL, r7}, false, al, "ge r13 r5 LSL r7", "ge_r13_r5_LSL_r7"},
    {{cc, r12, r10, ASR, r4},
     false,
     al,
     "cc r12 r10 ASR r4",
     "cc_r12_r10_ASR_r4"},
    {{ls, r12, r3, LSL, r7}, false, al, "ls r12 r3 LSL r7", "ls_r12_r3_LSL_r7"},
    {{cs, r2, r9, ASR, r8}, false, al, "cs r2 r9 ASR r8", "cs_r2_r9_ASR_r8"},
    {{vs, r1, r5, LSR, r1}, false, al, "vs r1 r5 LSR r1", "vs_r1_r5_LSR_r1"},
    {{cs, r7, r14, ASR, r9}, false, al, "cs r7 r14 ASR r9", "cs_r7_r14_ASR_r9"},
    {{hi, r6, r10, ASR, r0}, false, al, "hi r6 r10 ASR r0", "hi_r6_r10_ASR_r0"},
    {{pl, r13, r8, ASR, r13},
     false,
     al,
     "pl r13 r8 ASR r13",
     "pl_r13_r8_ASR_r13"},
    {{vs, r1, r0, ROR, r2}, false, al, "vs r1 r0 ROR r2", "vs_r1_r0_ROR_r2"},
    {{lt, r14, r0, LSL, r10},
     false,
     al,
     "lt r14 r0 LSL r10",
     "lt_r14_r0_LSL_r10"},
    {{ls, r8, r12, ROR, r14},
     false,
     al,
     "ls r8 r12 ROR r14",
     "ls_r8_r12_ROR_r14"},
    {{al, r11, r2, LSL, r0}, false, al, "al r11 r2 LSL r0", "al_r11_r2_LSL_r0"},
    {{mi, r0, r8, LSR, r7}, false, al, "mi r0 r8 LSR r7", "mi_r0_r8_LSR_r7"},
    {{cc, r3, r5, LSL, r9}, false, al, "cc r3 r5 LSL r9", "cc_r3_r5_LSL_r9"},
    {{vc, r14, r4, ROR, r4}, false, al, "vc r14 r4 ROR r4", "vc_r14_r4_ROR_r4"},
    {{cs, r1, r8, LSR, r7}, false, al, "cs r1 r8 LSR r7", "cs_r1_r8_LSR_r7"},
    {{ls, r6, r5, ASR, r13}, false, al, "ls r6 r5 ASR r13", "ls_r6_r5_ASR_r13"},
    {{pl, r0, r12, LSR, r5}, false, al, "pl r0 r12 LSR r5", "pl_r0_r12_LSR_r5"},
    {{lt, r9, r7, ROR, r2}, false, al, "lt r9 r7 ROR r2", "lt_r9_r7_ROR_r2"},
    {{ne, r6, r13, ASR, r13},
     false,
     al,
     "ne r6 r13 ASR r13",
     "ne_r6_r13_ASR_r13"},
    {{cc, r9, r1, LSR, r5}, false, al, "cc r9 r1 LSR r5", "cc_r9_r1_LSR_r5"},
    {{ls, r8, r0, ROR, r10}, false, al, "ls r8 r0 ROR r10", "ls_r8_r0_ROR_r10"},
    {{mi, r9, r8, LSR, r2}, false, al, "mi r9 r8 LSR r2", "mi_r9_r8_LSR_r2"},
    {{pl, r10, r14, ROR, r8},
     false,
     al,
     "pl r10 r14 ROR r8",
     "pl_r10_r14_ROR_r8"},
    {{hi, r4, r6, ROR, r10}, false, al, "hi r4 r6 ROR r10", "hi_r4_r6_ROR_r10"},
    {{vc, r0, r8, ROR, r10}, false, al, "vc r0 r8 ROR r10", "vc_r0_r8_ROR_r10"},
    {{ne, r0, r4, LSR, r11}, false, al, "ne r0 r4 LSR r11", "ne_r0_r4_LSR_r11"},
    {{pl, r0, r13, ROR, r14},
     false,
     al,
     "pl r0 r13 ROR r14",
     "pl_r0_r13_ROR_r14"},
    {{ne, r5, r6, LSL, r5}, false, al, "ne r5 r6 LSL r5", "ne_r5_r6_LSL_r5"},
    {{ge, r8, r3, ROR, r14}, false, al, "ge r8 r3 ROR r14", "ge_r8_r3_ROR_r14"},
    {{ne, r8, r7, LSL, r10}, false, al, "ne r8 r7 LSL r10", "ne_r8_r7_LSL_r10"},
    {{eq, r13, r9, ROR, r13},
     false,
     al,
     "eq r13 r9 ROR r13",
     "eq_r13_r9_ROR_r13"},
    {{eq, r10, r8, ROR, r14},
     false,
     al,
     "eq r10 r8 ROR r14",
     "eq_r10_r8_ROR_r14"},
    {{mi, r1, r8, ROR, r9}, false, al, "mi r1 r8 ROR r9", "mi_r1_r8_ROR_r9"},
    {{le, r10, r8, ROR, r10},
     false,
     al,
     "le r10 r8 ROR r10",
     "le_r10_r8_ROR_r10"},
    {{le, r7, r2, LSR, r11}, false, al, "le r7 r2 LSR r11", "le_r7_r2_LSR_r11"},
    {{le, r11, r9, LSL, r11},
     false,
     al,
     "le r11 r9 LSL r11",
     "le_r11_r9_LSL_r11"},
    {{cc, r5, r5, LSR, r4}, false, al, "cc r5 r5 LSR r4", "cc_r5_r5_LSR_r4"},
    {{al, r9, r5, LSL, r8}, false, al, "al r9 r5 LSL r8", "al_r9_r5_LSL_r8"},
    {{cs, r7, r14, LSL, r8}, false, al, "cs r7 r14 LSL r8", "cs_r7_r14_LSL_r8"},
    {{vc, r9, r9, LSR, r7}, false, al, "vc r9 r9 LSR r7", "vc_r9_r9_LSR_r7"},
    {{al, r13, r9, LSL, r1}, false, al, "al r13 r9 LSL r1", "al_r13_r9_LSL_r1"},
    {{cc, r8, r4, LSR, r14}, false, al, "cc r8 r4 LSR r14", "cc_r8_r4_LSR_r14"},
    {{cc, r14, r3, LSL, r10},
     false,
     al,
     "cc r14 r3 LSL r10",
     "cc_r14_r3_LSL_r10"},
    {{ge, r8, r6, ROR, r14}, false, al, "ge r8 r6 ROR r14", "ge_r8_r6_ROR_r14"},
    {{le, r4, r5, ASR, r5}, false, al, "le r4 r5 ASR r5", "le_r4_r5_ASR_r5"},
    {{vc, r4, r8, LSR, r6}, false, al, "vc r4 r8 LSR r6", "vc_r4_r8_LSR_r6"},
    {{vc, r9, r8, ROR, r14}, false, al, "vc r9 r8 ROR r14", "vc_r9_r8_ROR_r14"},
    {{ne, r7, r5, LSL, r11}, false, al, "ne r7 r5 LSL r11", "ne_r7_r5_LSL_r11"},
    {{vs, r12, r12, ASR, r8},
     false,
     al,
     "vs r12 r12 ASR r8",
     "vs_r12_r12_ASR_r8"},
    {{pl, r2, r14, ASR, r7}, false, al, "pl r2 r14 ASR r7", "pl_r2_r14_ASR_r7"},
    {{cc, r7, r10, ASR, r9}, false, al, "cc r7 r10 ASR r9", "cc_r7_r10_ASR_r9"},
    {{ne, r7, r10, LSL, r11},
     false,
     al,
     "ne r7 r10 LSL r11",
     "ne_r7_r10_LSL_r11"},
    {{vs, r13, r14, ROR, r0},
     false,
     al,
     "vs r13 r14 ROR r0",
     "vs_r13_r14_ROR_r0"},
    {{gt, r4, r12, LSL, r6}, false, al, "gt r4 r12 LSL r6", "gt_r4_r12_LSL_r6"},
    {{ge, r14, r6, ROR, r11},
     false,
     al,
     "ge r14 r6 ROR r11",
     "ge_r14_r6_ROR_r11"},
    {{pl, r2, r14, ASR, r0}, false, al, "pl r2 r14 ASR r0", "pl_r2_r14_ASR_r0"},
    {{gt, r7, r6, LSL, r11}, false, al, "gt r7 r6 LSL r11", "gt_r7_r6_LSL_r11"},
    {{cc, r11, r9, LSL, r11},
     false,
     al,
     "cc r11 r9 LSL r11",
     "cc_r11_r9_LSL_r11"},
    {{ne, r1, r5, ROR, r8}, false, al, "ne r1 r5 ROR r8", "ne_r1_r5_ROR_r8"},
    {{cs, r6, r2, ROR, r6}, false, al, "cs r6 r2 ROR r6", "cs_r6_r2_ROR_r6"},
    {{vc, r1, r14, LSL, r11},
     false,
     al,
     "vc r1 r14 LSL r11",
     "vc_r1_r14_LSL_r11"},
    {{cc, r10, r13, LSL, r11},
     false,
     al,
     "cc r10 r13 LSL r11",
     "cc_r10_r13_LSL_r11"},
    {{mi, r12, r10, ROR, r5},
     false,
     al,
     "mi r12 r10 ROR r5",
     "mi_r12_r10_ROR_r5"},
    {{ls, r2, r11, LSL, r3}, false, al, "ls r2 r11 LSL r3", "ls_r2_r11_LSL_r3"},
    {{lt, r6, r13, LSL, r12},
     false,
     al,
     "lt r6 r13 LSL r12",
     "lt_r6_r13_LSL_r12"},
    {{eq, r2, r14, ASR, r5}, false, al, "eq r2 r14 ASR r5", "eq_r2_r14_ASR_r5"},
    {{eq, r0, r14, LSR, r5}, false, al, "eq r0 r14 LSR r5", "eq_r0_r14_LSR_r5"},
    {{ls, r7, r11, LSL, r1}, false, al, "ls r7 r11 LSL r1", "ls_r7_r11_LSL_r1"},
    {{vs, r14, r13, LSR, r14},
     false,
     al,
     "vs r14 r13 LSR r14",
     "vs_r14_r13_LSR_r14"},
    {{vs, r13, r10, ASR, r3},
     false,
     al,
     "vs r13 r10 ASR r3",
     "vs_r13_r10_ASR_r3"},
    {{gt, r5, r4, LSL, r2}, false, al, "gt r5 r4 LSL r2", "gt_r5_r4_LSL_r2"},
    {{hi, r5, r12, LSR, r10},
     false,
     al,
     "hi r5 r12 LSR r10",
     "hi_r5_r12_LSR_r10"},
    {{mi, r11, r7, ROR, r11},
     false,
     al,
     "mi r11 r7 ROR r11",
     "mi_r11_r7_ROR_r11"},
    {{ne, r10, r7, ROR, r9}, false, al, "ne r10 r7 ROR r9", "ne_r10_r7_ROR_r9"},
    {{ls, r8, r6, ASR, r10}, false, al, "ls r8 r6 ASR r10", "ls_r8_r6_ASR_r10"},
    {{vc, r7, r10, ROR, r9}, false, al, "vc r7 r10 ROR r9", "vc_r7_r10_ROR_r9"},
    {{mi, r8, r3, LSR, r3}, false, al, "mi r8 r3 LSR r3", "mi_r8_r3_LSR_r3"},
    {{lt, r8, r2, ROR, r12}, false, al, "lt r8 r2 ROR r12", "lt_r8_r2_ROR_r12"},
    {{le, r10, r14, LSL, r11},
     false,
     al,
     "le r10 r14 LSL r11",
     "le_r10_r14_LSL_r11"},
    {{pl, r6, r6, LSR, r5}, false, al, "pl r6 r6 LSR r5", "pl_r6_r6_LSR_r5"},
    {{cc, r8, r4, ROR, r2}, false, al, "cc r8 r4 ROR r2", "cc_r8_r4_ROR_r2"},
    {{al, r7, r6, ASR, r2}, false, al, "al r7 r6 ASR r2", "al_r7_r6_ASR_r2"},
    {{ne, r2, r13, ASR, r8}, false, al, "ne r2 r13 ASR r8", "ne_r2_r13_ASR_r8"},
    {{ne, r1, r5, ROR, r12}, false, al, "ne r1 r5 ROR r12", "ne_r1_r5_ROR_r12"},
    {{lt, r10, r6, ROR, r8}, false, al, "lt r10 r6 ROR r8", "lt_r10_r6_ROR_r8"},
    {{cs, r2, r7, LSL, r0}, false, al, "cs r2 r7 LSL r0", "cs_r2_r7_LSL_r0"},
    {{ne, r3, r2, ASR, r4}, false, al, "ne r3 r2 ASR r4", "ne_r3_r2_ASR_r4"},
    {{mi, r4, r1, LSR, r0}, false, al, "mi r4 r1 LSR r0", "mi_r4_r1_LSR_r0"},
    {{lt, r1, r6, LSL, r10}, false, al, "lt r1 r6 LSL r10", "lt_r1_r6_LSL_r10"},
    {{gt, r6, r9, LSL, r13}, false, al, "gt r6 r9 LSL r13", "gt_r6_r9_LSL_r13"},
    {{vc, r5, r2, LSL, r13}, false, al, "vc r5 r2 LSL r13", "vc_r5_r2_LSL_r13"},
    {{ne, r11, r8, ROR, r5}, false, al, "ne r11 r8 ROR r5", "ne_r11_r8_ROR_r5"},
    {{eq, r10, r2, ROR, r12},
     false,
     al,
     "eq r10 r2 ROR r12",
     "eq_r10_r2_ROR_r12"},
    {{ge, r0, r5, LSR, r12}, false, al, "ge r0 r5 LSR r12", "ge_r0_r5_LSR_r12"},
    {{vs, r5, r13, ROR, r9}, false, al, "vs r5 r13 ROR r9", "vs_r5_r13_ROR_r9"},
    {{gt, r0, r6, ASR, r9}, false, al, "gt r0 r6 ASR r9", "gt_r0_r6_ASR_r9"},
    {{hi, r6, r0, LSR, r9}, false, al, "hi r6 r0 LSR r9", "hi_r6_r0_LSR_r9"},
    {{lt, r7, r4, ASR, r9}, false, al, "lt r7 r4 ASR r9", "lt_r7_r4_ASR_r9"},
    {{ge, r5, r0, ROR, r2}, false, al, "ge r5 r0 ROR r2", "ge_r5_r0_ROR_r2"},
    {{ls, r10, r11, ROR, r7},
     false,
     al,
     "ls r10 r11 ROR r7",
     "ls_r10_r11_ROR_r7"},
    {{cs, r7, r1, ASR, r13}, false, al, "cs r7 r1 ASR r13", "cs_r7_r1_ASR_r13"},
    {{pl, r3, r9, ASR, r11}, false, al, "pl r3 r9 ASR r11", "pl_r3_r9_ASR_r11"},
    {{ne, r13, r5, LSR, r2}, false, al, "ne r13 r5 LSR r2", "ne_r13_r5_LSR_r2"},
    {{vc, r5, r8, ASR, r6}, false, al, "vc r5 r8 ASR r6", "vc_r5_r8_ASR_r6"},
    {{ge, r8, r11, ROR, r13},
     false,
     al,
     "ge r8 r11 ROR r13",
     "ge_r8_r11_ROR_r13"},
    {{lt, r0, r10, LSR, r5}, false, al, "lt r0 r10 LSR r5", "lt_r0_r10_LSR_r5"},
    {{vc, r8, r1, ASR, r11}, false, al, "vc r8 r1 ASR r11", "vc_r8_r1_ASR_r11"},
    {{pl, r11, r9, ASR, r9}, false, al, "pl r11 r9 ASR r9", "pl_r11_r9_ASR_r9"},
    {{ls, r3, r1, LSL, r11}, false, al, "ls r3 r1 LSL r11", "ls_r3_r1_LSL_r11"},
    {{hi, r8, r12, ASR, r7}, false, al, "hi r8 r12 ASR r7", "hi_r8_r12_ASR_r7"},
    {{ne, r10, r12, LSR, r9},
     false,
     al,
     "ne r10 r12 LSR r9",
     "ne_r10_r12_LSR_r9"},
    {{ge, r12, r4, ASR, r14},
     false,
     al,
     "ge r12 r4 ASR r14",
     "ge_r12_r4_ASR_r14"},
    {{mi, r6, r2, ROR, r1}, false, al, "mi r6 r2 ROR r1", "mi_r6_r2_ROR_r1"},
    {{ls, r13, r13, LSL, r0},
     false,
     al,
     "ls r13 r13 LSL r0",
     "ls_r13_r13_LSL_r0"},
    {{eq, r8, r10, LSR, r0}, false, al, "eq r8 r10 LSR r0", "eq_r8_r10_LSR_r0"},
    {{gt, r5, r0, ROR, r14}, false, al, "gt r5 r0 ROR r14", "gt_r5_r0_ROR_r14"},
    {{vs, r3, r4, ROR, r3}, false, al, "vs r3 r4 ROR r3", "vs_r3_r4_ROR_r3"},
    {{lt, r5, r13, LSL, r6}, false, al, "lt r5 r13 LSL r6", "lt_r5_r13_LSL_r6"},
    {{cc, r5, r1, ASR, r13}, false, al, "cc r5 r1 ASR r13", "cc_r5_r1_ASR_r13"},
    {{lt, r11, r3, ROR, r7}, false, al, "lt r11 r3 ROR r7", "lt_r11_r3_ROR_r7"},
    {{cs, r12, r2, LSR, r4}, false, al, "cs r12 r2 LSR r4", "cs_r12_r2_LSR_r4"},
    {{vc, r3, r12, LSL, r4}, false, al, "vc r3 r12 LSL r4", "vc_r3_r12_LSL_r4"},
    {{hi, r14, r9, LSL, r5}, false, al, "hi r14 r9 LSL r5", "hi_r14_r9_LSL_r5"},
    {{ls, r10, r4, LSR, r5}, false, al, "ls r10 r4 LSR r5", "ls_r10_r4_LSR_r5"},
    {{ne, r11, r14, ROR, r14},
     false,
     al,
     "ne r11 r14 ROR r14",
     "ne_r11_r14_ROR_r14"},
    {{vc, r11, r12, ASR, r7},
     false,
     al,
     "vc r11 r12 ASR r7",
     "vc_r11_r12_ASR_r7"},
    {{cc, r7, r0, LSR, r3}, false, al, "cc r7 r0 LSR r3", "cc_r7_r0_LSR_r3"},
    {{cs, r1, r8, LSR, r3}, false, al, "cs r1 r8 LSR r3", "cs_r1_r8_LSR_r3"},
    {{mi, r7, r6, LSL, r13}, false, al, "mi r7 r6 LSL r13", "mi_r7_r6_LSL_r13"},
    {{hi, r10, r3, ROR, r7}, false, al, "hi r10 r3 ROR r7", "hi_r10_r3_ROR_r7"},
    {{vs, r2, r11, LSR, r13},
     false,
     al,
     "vs r2 r11 LSR r13",
     "vs_r2_r11_LSR_r13"},
    {{eq, r12, r14, LSL, r2},
     false,
     al,
     "eq r12 r14 LSL r2",
     "eq_r12_r14_LSL_r2"},
    {{vs, r14, r13, LSL, r6},
     false,
     al,
     "vs r14 r13 LSL r6",
     "vs_r14_r13_LSL_r6"},
    {{cs, r1, r0, LSL, r10}, false, al, "cs r1 r0 LSL r10", "cs_r1_r0_LSL_r10"},
    {{ge, r2, r14, LSR, r10},
     false,
     al,
     "ge r2 r14 LSR r10",
     "ge_r2_r14_LSR_r10"},
    {{mi, r14, r10, ROR, r0},
     false,
     al,
     "mi r14 r10 ROR r0",
     "mi_r14_r10_ROR_r0"},
    {{eq, r8, r4, ROR, r4}, false, al, "eq r8 r4 ROR r4", "eq_r8_r4_ROR_r4"},
    {{gt, r4, r9, LSR, r3}, false, al, "gt r4 r9 LSR r3", "gt_r4_r9_LSR_r3"},
    {{ls, r13, r0, ASR, r5}, false, al, "ls r13 r0 ASR r5", "ls_r13_r0_ASR_r5"},
    {{ge, r3, r13, ASR, r12},
     false,
     al,
     "ge r3 r13 ASR r12",
     "ge_r3_r13_ASR_r12"},
    {{vc, r9, r7, LSR, r12}, false, al, "vc r9 r7 LSR r12", "vc_r9_r7_LSR_r12"},
    {{al, r1, r0, LSL, r8}, false, al, "al r1 r0 LSL r8", "al_r1_r0_LSL_r8"},
    {{ls, r11, r7, ROR, r5}, false, al, "ls r11 r7 ROR r5", "ls_r11_r7_ROR_r5"},
    {{vs, r11, r8, LSR, r13},
     false,
     al,
     "vs r11 r8 LSR r13",
     "vs_r11_r8_LSR_r13"},
    {{le, r6, r5, LSR, r3}, false, al, "le r6 r5 LSR r3", "le_r6_r5_LSR_r3"},
    {{cs, r4, r1, LSL, r7}, false, al, "cs r4 r1 LSL r7", "cs_r4_r1_LSL_r7"},
    {{lt, r4, r9, LSL, r2}, false, al, "lt r4 r9 LSL r2", "lt_r4_r9_LSL_r2"},
    {{mi, r12, r1, LSR, r10},
     false,
     al,
     "mi r12 r1 LSR r10",
     "mi_r12_r1_LSR_r10"},
    {{al, r14, r2, LSR, r3}, false, al, "al r14 r2 LSR r3", "al_r14_r2_LSR_r3"},
    {{al, r11, r9, LSL, r4}, false, al, "al r11 r9 LSL r4", "al_r11_r9_LSL_r4"},
    {{hi, r4, r4, ROR, r3}, false, al, "hi r4 r4 ROR r3", "hi_r4_r4_ROR_r3"},
    {{al, r3, r5, ROR, r6}, false, al, "al r3 r5 ROR r6", "al_r3_r5_ROR_r6"},
    {{al, r8, r4, LSR, r7}, false, al, "al r8 r4 LSR r7", "al_r8_r4_LSR_r7"},
    {{vs, r7, r5, LSL, r6}, false, al, "vs r7 r5 LSL r6", "vs_r7_r5_LSL_r6"},
    {{ls, r6, r2, LSL, r8}, false, al, "ls r6 r2 LSL r8", "ls_r6_r2_LSL_r8"},
    {{pl, r4, r12, LSL, r6}, false, al, "pl r4 r12 LSL r6", "pl_r4_r12_LSL_r6"},
    {{ge, r8, r12, LSR, r4}, false, al, "ge r8 r12 LSR r4", "ge_r8_r12_LSR_r4"},
    {{le, r11, r1, ROR, r9}, false, al, "le r11 r1 ROR r9", "le_r11_r1_ROR_r9"},
    {{hi, r1, r13, LSR, r9}, false, al, "hi r1 r13 LSR r9", "hi_r1_r13_LSR_r9"},
    {{cc, r3, r0, LSR, r1}, false, al, "cc r3 r0 LSR r1", "cc_r3_r0_LSR_r1"},
    {{ge, r10, r11, ROR, r0},
     false,
     al,
     "ge r10 r11 ROR r0",
     "ge_r10_r11_ROR_r0"},
    {{pl, r6, r5, ROR, r3}, false, al, "pl r6 r5 ROR r3", "pl_r6_r5_ROR_r3"},
    {{cs, r10, r1, LSR, r12},
     false,
     al,
     "cs r10 r1 LSR r12",
     "cs_r10_r1_LSR_r12"},
    {{ne, r10, r4, LSR, r1}, false, al, "ne r10 r4 LSR r1", "ne_r10_r4_LSR_r1"},
    {{vs, r5, r1, LSL, r7}, false, al, "vs r5 r1 LSL r7", "vs_r5_r1_LSL_r7"},
    {{ge, r10, r2, LSL, r4}, false, al, "ge r10 r2 LSL r4", "ge_r10_r2_LSL_r4"},
    {{vc, r3, r1, ASR, r2}, false, al, "vc r3 r1 ASR r2", "vc_r3_r1_ASR_r2"},
    {{ls, r2, r3, ASR, r14}, false, al, "ls r2 r3 ASR r14", "ls_r2_r3_ASR_r14"},
    {{vs, r1, r1, LSL, r7}, false, al, "vs r1 r1 LSL r7", "vs_r1_r1_LSL_r7"},
    {{gt, r2, r1, LSL, r14}, false, al, "gt r2 r1 LSL r14", "gt_r2_r1_LSL_r14"},
    {{al, r11, r12, ROR, r7},
     false,
     al,
     "al r11 r12 ROR r7",
     "al_r11_r12_ROR_r7"},
    {{eq, r2, r12, LSL, r10},
     false,
     al,
     "eq r2 r12 LSL r10",
     "eq_r2_r12_LSL_r10"},
    {{ls, r7, r2, LSR, r7}, false, al, "ls r7 r2 LSR r7", "ls_r7_r2_LSR_r7"},
    {{ne, r9, r5, ROR, r12}, false, al, "ne r9 r5 ROR r12", "ne_r9_r5_ROR_r12"},
    {{ge, r13, r8, LSR, r12},
     false,
     al,
     "ge r13 r8 LSR r12",
     "ge_r13_r8_LSR_r12"},
    {{ls, r12, r11, ROR, r9},
     false,
     al,
     "ls r12 r11 ROR r9",
     "ls_r12_r11_ROR_r9"},
    {{cc, r13, r5, LSL, r8}, false, al, "cc r13 r5 LSL r8", "cc_r13_r5_LSL_r8"},
    {{ne, r7, r12, LSL, r7}, false, al, "ne r7 r12 LSL r7", "ne_r7_r12_LSL_r7"},
    {{ge, r6, r13, ROR, r2}, false, al, "ge r6 r13 ROR r2", "ge_r6_r13_ROR_r2"},
    {{ne, r8, r7, ROR, r6}, false, al, "ne r8 r7 ROR r6", "ne_r8_r7_ROR_r6"},
    {{cc, r7, r10, ROR, r0}, false, al, "cc r7 r10 ROR r0", "cc_r7_r10_ROR_r0"},
    {{le, r5, r5, ASR, r5}, false, al, "le r5 r5 ASR r5", "le_r5_r5_ASR_r5"},
    {{hi, r14, r7, ROR, r0}, false, al, "hi r14 r7 ROR r0", "hi_r14_r7_ROR_r0"},
    {{vs, r9, r3, LSL, r11}, false, al, "vs r9 r3 LSL r11", "vs_r9_r3_LSL_r11"},
    {{ls, r0, r5, LSL, r11}, false, al, "ls r0 r5 LSL r11", "ls_r0_r5_LSL_r11"},
    {{ne, r12, r3, LSL, r14},
     false,
     al,
     "ne r12 r3 LSL r14",
     "ne_r12_r3_LSL_r14"},
    {{lt, r12, r12, ROR, r4},
     false,
     al,
     "lt r12 r12 ROR r4",
     "lt_r12_r12_ROR_r4"},
    {{gt, r13, r10, LSR, r3},
     false,
     al,
     "gt r13 r10 LSR r3",
     "gt_r13_r10_LSR_r3"},
    {{ls, r11, r2, ASR, r10},
     false,
     al,
     "ls r11 r2 ASR r10",
     "ls_r11_r2_ASR_r10"},
    {{vc, r7, r8, ASR, r13}, false, al, "vc r7 r8 ASR r13", "vc_r7_r8_ASR_r13"},
    {{eq, r8, r3, LSR, r13}, false, al, "eq r8 r3 LSR r13", "eq_r8_r3_LSR_r13"},
    {{mi, r10, r6, LSL, r8}, false, al, "mi r10 r6 LSL r8", "mi_r10_r6_LSL_r8"},
    {{le, r11, r11, LSR, r1},
     false,
     al,
     "le r11 r11 LSR r1",
     "le_r11_r11_LSR_r1"},
    {{vc, r11, r2, ROR, r13},
     false,
     al,
     "vc r11 r2 ROR r13",
     "vc_r11_r2_ROR_r13"},
    {{vs, r8, r9, ASR, r2}, false, al, "vs r8 r9 ASR r2", "vs_r8_r9_ASR_r2"},
    {{pl, r11, r11, ASR, r13},
     false,
     al,
     "pl r11 r11 ASR r13",
     "pl_r11_r11_ASR_r13"},
    {{mi, r14, r1, LSL, r7}, false, al, "mi r14 r1 LSL r7", "mi_r14_r1_LSL_r7"},
    {{mi, r7, r7, LSR, r6}, false, al, "mi r7 r7 LSR r6", "mi_r7_r7_LSR_r6"},
    {{eq, r5, r13, LSR, r8}, false, al, "eq r5 r13 LSR r8", "eq_r5_r13_LSR_r8"},
    {{cs, r8, r7, ASR, r0}, false, al, "cs r8 r7 ASR r0", "cs_r8_r7_ASR_r0"},
    {{pl, r8, r4, LSL, r5}, false, al, "pl r8 r4 LSL r5", "pl_r8_r4_LSL_r5"},
    {{pl, r1, r6, ROR, r2}, false, al, "pl r1 r6 ROR r2", "pl_r1_r6_ROR_r2"},
    {{cc, r13, r14, ASR, r0},
     false,
     al,
     "cc r13 r14 ASR r0",
     "cc_r13_r14_ASR_r0"},
    {{al, r3, r12, LSL, r3}, false, al, "al r3 r12 LSL r3", "al_r3_r12_LSL_r3"},
    {{vs, r12, r10, LSL, r14},
     false,
     al,
     "vs r12 r10 LSL r14",
     "vs_r12_r10_LSL_r14"},
    {{lt, r8, r3, ASR, r0}, false, al, "lt r8 r3 ASR r0", "lt_r8_r3_ASR_r0"},
    {{pl, r0, r13, LSL, r2}, false, al, "pl r0 r13 LSL r2", "pl_r0_r13_LSL_r2"},
    {{gt, r8, r2, LSL, r4}, false, al, "gt r8 r2 LSL r4", "gt_r8_r2_LSL_r4"},
    {{mi, r13, r0, LSL, r8}, false, al, "mi r13 r0 LSL r8", "mi_r13_r0_LSL_r8"},
    {{eq, r1, r10, LSL, r14},
     false,
     al,
     "eq r1 r10 LSL r14",
     "eq_r1_r10_LSL_r14"},
    {{hi, r8, r11, ASR, r10},
     false,
     al,
     "hi r8 r11 ASR r10",
     "hi_r8_r11_ASR_r10"},
    {{ne, r11, r9, ASR, r0}, false, al, "ne r11 r9 ASR r0", "ne_r11_r9_ASR_r0"},
    {{cc, r0, r13, ROR, r5}, false, al, "cc r0 r13 ROR r5", "cc_r0_r13_ROR_r5"},
    {{ge, r13, r7, ROR, r5}, false, al, "ge r13 r7 ROR r5", "ge_r13_r7_ROR_r5"},
    {{eq, r4, r5, LSL, r2}, false, al, "eq r4 r5 LSL r2", "eq_r4_r5_LSL_r2"},
    {{ge, r5, r12, ASR, r3}, false, al, "ge r5 r12 ASR r3", "ge_r5_r12_ASR_r3"},
    {{ge, r9, r7, ROR, r6}, false, al, "ge r9 r7 ROR r6", "ge_r9_r7_ROR_r6"},
    {{cc, r2, r2, LSR, r0}, false, al, "cc r2 r2 LSR r0", "cc_r2_r2_LSR_r0"},
    {{cs, r9, r7, ASR, r11}, false, al, "cs r9 r7 ASR r11", "cs_r9_r7_ASR_r11"},
    {{al, r10, r6, ASR, r10},
     false,
     al,
     "al r10 r6 ASR r10",
     "al_r10_r6_ASR_r10"},
    {{ls, r13, r10, LSL, r10},
     false,
     al,
     "ls r13 r10 LSL r10",
     "ls_r13_r10_LSL_r10"},
    {{ne, r14, r13, ASR, r8},
     false,
     al,
     "ne r14 r13 ASR r8",
     "ne_r14_r13_ASR_r8"},
    {{lt, r12, r3, ROR, r10},
     false,
     al,
     "lt r12 r3 ROR r10",
     "lt_r12_r3_ROR_r10"},
    {{al, r12, r8, ROR, r8}, false, al, "al r12 r8 ROR r8", "al_r12_r8_ROR_r8"},
    {{ls, r5, r8, ASR, r8}, false, al, "ls r5 r8 ASR r8", "ls_r5_r8_ASR_r8"},
    {{mi, r13, r11, LSR, r2},
     false,
     al,
     "mi r13 r11 LSR r2",
     "mi_r13_r11_LSR_r2"},
    {{le, r7, r10, ROR, r1}, false, al, "le r7 r10 ROR r1", "le_r7_r10_ROR_r1"},
    {{ne, r5, r2, LSL, r11}, false, al, "ne r5 r2 LSL r11", "ne_r5_r2_LSL_r11"},
    {{ne, r14, r7, LSL, r10},
     false,
     al,
     "ne r14 r7 LSL r10",
     "ne_r14_r7_LSL_r10"},
    {{al, r0, r1, LSR, r14}, false, al, "al r0 r1 LSR r14", "al_r0_r1_LSR_r14"},
    {{mi, r5, r9, LSR, r11}, false, al, "mi r5 r9 LSR r11", "mi_r5_r9_LSR_r11"},
    {{eq, r8, r3, LSR, r11}, false, al, "eq r8 r3 LSR r11", "eq_r8_r3_LSR_r11"},
    {{eq, r4, r14, LSR, r11},
     false,
     al,
     "eq r4 r14 LSR r11",
     "eq_r4_r14_LSR_r11"},
    {{le, r0, r7, LSL, r11}, false, al, "le r0 r7 LSL r11", "le_r0_r7_LSL_r11"},
    {{le, r2, r2, LSL, r10}, false, al, "le r2 r2 LSL r10", "le_r2_r2_LSL_r10"},
    {{le, r3, r5, ROR, r0}, false, al, "le r3 r5 ROR r0", "le_r3_r5_ROR_r0"},
    {{mi, r8, r10, LSL, r10},
     false,
     al,
     "mi r8 r10 LSL r10",
     "mi_r8_r10_LSL_r10"},
    {{ls, r11, r7, ROR, r8}, false, al, "ls r11 r7 ROR r8", "ls_r11_r7_ROR_r8"},
    {{hi, r14, r11, LSR, r7},
     false,
     al,
     "hi r14 r11 LSR r7",
     "hi_r14_r11_LSR_r7"},
    {{mi, r10, r2, LSR, r1}, false, al, "mi r10 r2 LSR r1", "mi_r10_r2_LSR_r1"},
    {{le, r3, r14, ASR, r10},
     false,
     al,
     "le r3 r14 ASR r10",
     "le_r3_r14_ASR_r10"},
    {{vs, r3, r11, ROR, r2}, false, al, "vs r3 r11 ROR r2", "vs_r3_r11_ROR_r2"},
    {{lt, r2, r8, ASR, r2}, false, al, "lt r2 r8 ASR r2", "lt_r2_r8_ASR_r2"},
    {{pl, r7, r4, ROR, r6}, false, al, "pl r7 r4 ROR r6", "pl_r7_r4_ROR_r6"},
    {{al, r7, r12, ASR, r12},
     false,
     al,
     "al r7 r12 ASR r12",
     "al_r7_r12_ASR_r12"},
    {{ge, r8, r9, ROR, r0}, false, al, "ge r8 r9 ROR r0", "ge_r8_r9_ROR_r0"},
    {{mi, r9, r5, LSL, r7}, false, al, "mi r9 r5 LSL r7", "mi_r9_r5_LSL_r7"},
    {{cs, r4, r13, LSL, r9}, false, al, "cs r4 r13 LSL r9", "cs_r4_r13_LSL_r9"},
    {{eq, r5, r3, LSR, r1}, false, al, "eq r5 r3 LSR r1", "eq_r5_r3_LSR_r1"},
    {{lt, r6, r14, LSR, r5}, false, al, "lt r6 r14 LSR r5", "lt_r6_r14_LSR_r5"},
    {{eq, r11, r9, LSL, r11},
     false,
     al,
     "eq r11 r9 LSL r11",
     "eq_r11_r9_LSL_r11"},
    {{cs, r4, r0, ROR, r0}, false, al, "cs r4 r0 ROR r0", "cs_r4_r0_ROR_r0"},
    {{pl, r11, r13, LSL, r4},
     false,
     al,
     "pl r11 r13 LSL r4",
     "pl_r11_r13_LSL_r4"},
    {{al, r1, r2, LSR, r7}, false, al, "al r1 r2 LSR r7", "al_r1_r2_LSR_r7"},
    {{mi, r7, r2, ROR, r2}, false, al, "mi r7 r2 ROR r2", "mi_r7_r2_ROR_r2"},
    {{ls, r2, r10, LSL, r10},
     false,
     al,
     "ls r2 r10 LSL r10",
     "ls_r2_r10_LSL_r10"},
    {{cs, r11, r8, LSL, r3}, false, al, "cs r11 r8 LSL r3", "cs_r11_r8_LSL_r3"},
    {{cc, r11, r5, ROR, r1}, false, al, "cc r11 r5 ROR r1", "cc_r11_r5_ROR_r1"},
    {{le, r11, r0, ASR, r12},
     false,
     al,
     "le r11 r0 ASR r12",
     "le_r11_r0_ASR_r12"},
    {{pl, r5, r8, LSL, r6}, false, al, "pl r5 r8 LSL r6", "pl_r5_r8_LSL_r6"},
    {{ls, r9, r13, LSL, r10},
     false,
     al,
     "ls r9 r13 LSL r10",
     "ls_r9_r13_LSL_r10"},
    {{ge, r14, r5, LSL, r10},
     false,
     al,
     "ge r14 r5 LSL r10",
     "ge_r14_r5_LSL_r10"},
    {{vs, r8, r10, ASR, r2}, false, al, "vs r8 r10 ASR r2", "vs_r8_r10_ASR_r2"},
    {{vs, r11, r11, LSR, r4},
     false,
     al,
     "vs r11 r11 LSR r4",
     "vs_r11_r11_LSR_r4"},
    {{ls, r7, r0, ASR, r7}, false, al, "ls r7 r0 ASR r7", "ls_r7_r0_ASR_r7"},
    {{cc, r10, r5, ASR, r13},
     false,
     al,
     "cc r10 r5 ASR r13",
     "cc_r10_r5_ASR_r13"},
    {{hi, r12, r13, ROR, r5},
     false,
     al,
     "hi r12 r13 ROR r5",
     "hi_r12_r13_ROR_r5"},
    {{le, r12, r14, LSR, r5},
     false,
     al,
     "le r12 r14 LSR r5",
     "le_r12_r14_LSR_r5"},
    {{le, r0, r0, LSL, r14}, false, al, "le r0 r0 LSL r14", "le_r0_r0_LSL_r14"},
    {{ge, r3, r7, ROR, r14}, false, al, "ge r3 r7 ROR r14", "ge_r3_r7_ROR_r14"},
    {{eq, r3, r1, LSL, r8}, false, al, "eq r3 r1 LSL r8", "eq_r3_r1_LSL_r8"},
    {{lt, r7, r1, LSR, r11}, false, al, "lt r7 r1 LSR r11", "lt_r7_r1_LSR_r11"},
    {{ls, r0, r10, ROR, r11},
     false,
     al,
     "ls r0 r10 ROR r11",
     "ls_r0_r10_ROR_r11"},
    {{le, r0, r1, LSL, r8}, false, al, "le r0 r1 LSL r8", "le_r0_r1_LSL_r8"},
    {{mi, r13, r3, LSR, r8}, false, al, "mi r13 r3 LSR r8", "mi_r13_r3_LSR_r8"},
    {{ls, r9, r6, LSR, r0}, false, al, "ls r9 r6 LSR r0", "ls_r9_r6_LSR_r0"},
    {{mi, r11, r6, LSR, r3}, false, al, "mi r11 r6 LSR r3", "mi_r11_r6_LSR_r3"},
    {{lt, r11, r6, LSL, r14},
     false,
     al,
     "lt r11 r6 LSL r14",
     "lt_r11_r6_LSL_r14"},
    {{pl, r4, r14, ROR, r5}, false, al, "pl r4 r14 ROR r5", "pl_r4_r14_ROR_r5"},
    {{eq, r7, r6, LSR, r6}, false, al, "eq r7 r6 LSR r6", "eq_r7_r6_LSR_r6"},
    {{hi, r11, r7, ASR, r8}, false, al, "hi r11 r7 ASR r8", "hi_r11_r7_ASR_r8"},
    {{al, r7, r14, ASR, r14},
     false,
     al,
     "al r7 r14 ASR r14",
     "al_r7_r14_ASR_r14"},
    {{cc, r3, r1, ASR, r10}, false, al, "cc r3 r1 ASR r10", "cc_r3_r1_ASR_r10"},
    {{pl, r9, r3, ROR, r2}, false, al, "pl r9 r3 ROR r2", "pl_r9_r3_ROR_r2"},
    {{vc, r6, r9, LSR, r14}, false, al, "vc r6 r9 LSR r14", "vc_r6_r9_LSR_r14"},
    {{le, r3, r14, ASR, r7}, false, al, "le r3 r14 ASR r7", "le_r3_r14_ASR_r7"},
    {{le, r12, r14, ROR, r14},
     false,
     al,
     "le r12 r14 ROR r14",
     "le_r12_r14_ROR_r14"},
    {{pl, r7, r11, ASR, r9}, false, al, "pl r7 r11 ASR r9", "pl_r7_r11_ASR_r9"},
    {{le, r1, r12, ASR, r4}, false, al, "le r1 r12 ASR r4", "le_r1_r12_ASR_r4"},
    {{eq, r7, r12, ASR, r6}, false, al, "eq r7 r12 ASR r6", "eq_r7_r12_ASR_r6"},
    {{mi, r12, r12, ROR, r14},
     false,
     al,
     "mi r12 r12 ROR r14",
     "mi_r12_r12_ROR_r14"},
    {{pl, r1, r3, ROR, r3}, false, al, "pl r1 r3 ROR r3", "pl_r1_r3_ROR_r3"},
    {{hi, r1, r12, ASR, r2}, false, al, "hi r1 r12 ASR r2", "hi_r1_r12_ASR_r2"},
    {{ls, r7, r5, LSR, r14}, false, al, "ls r7 r5 LSR r14", "ls_r7_r5_LSR_r14"},
    {{al, r6, r6, LSR, r2}, false, al, "al r6 r6 LSR r2", "al_r6_r6_LSR_r2"},
    {{al, r8, r3, ROR, r13}, false, al, "al r8 r3 ROR r13", "al_r8_r3_ROR_r13"},
    {{ls, r12, r14, LSL, r11},
     false,
     al,
     "ls r12 r14 LSL r11",
     "ls_r12_r14_LSL_r11"},
    {{ne, r9, r9, ROR, r1}, false, al, "ne r9 r9 ROR r1", "ne_r9_r9_ROR_r1"},
    {{hi, r9, r13, ROR, r1}, false, al, "hi r9 r13 ROR r1", "hi_r9_r13_ROR_r1"},
    {{vc, r10, r13, ASR, r13},
     false,
     al,
     "vc r10 r13 ASR r13",
     "vc_r10_r13_ASR_r13"},
    {{al, r13, r13, ROR, r7},
     false,
     al,
     "al r13 r13 ROR r7",
     "al_r13_r13_ROR_r7"},
    {{ls, r0, r14, LSL, r10},
     false,
     al,
     "ls r0 r14 LSL r10",
     "ls_r0_r14_LSL_r10"},
    {{vc, r9, r14, ROR, r11},
     false,
     al,
     "vc r9 r14 ROR r11",
     "vc_r9_r14_ROR_r11"},
    {{vc, r10, r3, LSR, r14},
     false,
     al,
     "vc r10 r3 LSR r14",
     "vc_r10_r3_LSR_r14"},
    {{cc, r11, r14, LSR, r3},
     false,
     al,
     "cc r11 r14 LSR r3",
     "cc_r11_r14_LSR_r3"},
    {{ge, r1, r2, LSL, r1}, false, al, "ge r1 r2 LSL r1", "ge_r1_r2_LSL_r1"},
    {{al, r10, r8, LSR, r5}, false, al, "al r10 r8 LSR r5", "al_r10_r8_LSR_r5"},
    {{vs, r2, r5, ASR, r8}, false, al, "vs r2 r5 ASR r8", "vs_r2_r5_ASR_r8"},
    {{cs, r10, r5, LSL, r11},
     false,
     al,
     "cs r10 r5 LSL r11",
     "cs_r10_r5_LSL_r11"},
    {{gt, r9, r0, LSR, r6}, false, al, "gt r9 r0 LSR r6", "gt_r9_r0_LSR_r6"},
    {{le, r8, r2, ROR, r0}, false, al, "le r8 r2 ROR r0", "le_r8_r2_ROR_r0"},
    {{cc, r0, r9, ASR, r4}, false, al, "cc r0 r9 ASR r4", "cc_r0_r9_ASR_r4"},
    {{pl, r7, r4, ASR, r4}, false, al, "pl r7 r4 ASR r4", "pl_r7_r4_ASR_r4"},
    {{cs, r6, r5, ASR, r6}, false, al, "cs r6 r5 ASR r6", "cs_r6_r5_ASR_r6"},
    {{al, r14, r6, LSL, r2}, false, al, "al r14 r6 LSL r2", "al_r14_r6_LSL_r2"},
    {{pl, r11, r14, ASR, r4},
     false,
     al,
     "pl r11 r14 ASR r4",
     "pl_r11_r14_ASR_r4"},
    {{pl, r4, r9, LSL, r10}, false, al, "pl r4 r9 LSL r10", "pl_r4_r9_LSL_r10"},
    {{le, r7, r1, ROR, r8}, false, al, "le r7 r1 ROR r8", "le_r7_r1_ROR_r8"},
    {{al, r3, r1, LSR, r10}, false, al, "al r3 r1 LSR r10", "al_r3_r1_LSR_r10"},
    {{ge, r8, r14, LSL, r11},
     false,
     al,
     "ge r8 r14 LSL r11",
     "ge_r8_r14_LSL_r11"},
    {{le, r11, r5, LSL, r2}, false, al, "le r11 r5 LSL r2", "le_r11_r5_LSL_r2"},
    {{le, r13, r2, ROR, r0}, false, al, "le r13 r2 ROR r0", "le_r13_r2_ROR_r0"},
    {{eq, r4, r13, ASR, r10},
     false,
     al,
     "eq r4 r13 ASR r10",
     "eq_r4_r13_ASR_r10"},
    {{lt, r14, r5, ASR, r14},
     false,
     al,
     "lt r14 r5 ASR r14",
     "lt_r14_r5_ASR_r14"},
    {{gt, r2, r6, ASR, r12}, false, al, "gt r2 r6 ASR r12", "gt_r2_r6_ASR_r12"},
    {{gt, r9, r1, ASR, r8}, false, al, "gt r9 r1 ASR r8", "gt_r9_r1_ASR_r8"},
    {{vs, r11, r6, LSL, r13},
     false,
     al,
     "vs r11 r6 LSL r13",
     "vs_r11_r6_LSL_r13"},
    {{ge, r2, r13, LSL, r3}, false, al, "ge r2 r13 LSL r3", "ge_r2_r13_LSL_r3"},
    {{hi, r4, r1, ROR, r14}, false, al, "hi r4 r1 ROR r14", "hi_r4_r1_ROR_r14"},
    {{gt, r8, r13, LSL, r2}, false, al, "gt r8 r13 LSL r2", "gt_r8_r13_LSL_r2"},
    {{pl, r13, r1, LSR, r3}, false, al, "pl r13 r1 LSR r3", "pl_r13_r1_LSR_r3"},
    {{cc, r13, r6, LSL, r10},
     false,
     al,
     "cc r13 r6 LSL r10",
     "cc_r13_r6_LSL_r10"},
    {{ls, r10, r1, LSR, r1}, false, al, "ls r10 r1 LSR r1", "ls_r10_r1_LSR_r1"},
    {{hi, r12, r2, LSR, r12},
     false,
     al,
     "hi r12 r2 LSR r12",
     "hi_r12_r2_LSR_r12"},
    {{ge, r1, r1, ROR, r12}, false, al, "ge r1 r1 ROR r12", "ge_r1_r1_ROR_r12"},
    {{vc, r12, r0, LSL, r10},
     false,
     al,
     "vc r12 r0 LSL r10",
     "vc_r12_r0_LSL_r10"},
    {{eq, r5, r8, ROR, r7}, false, al, "eq r5 r8 ROR r7", "eq_r5_r8_ROR_r7"},
    {{cc, r5, r1, LSR, r1}, false, al, "cc r5 r1 LSR r1", "cc_r5_r1_LSR_r1"},
    {{pl, r7, r14, ASR, r4}, false, al, "pl r7 r14 ASR r4", "pl_r7_r14_ASR_r4"},
    {{ge, r0, r5, LSR, r4}, false, al, "ge r0 r5 LSR r4", "ge_r0_r5_LSR_r4"},
    {{ge, r3, r10, LSL, r11},
     false,
     al,
     "ge r3 r10 LSL r11",
     "ge_r3_r10_LSL_r11"},
    {{cs, r13, r11, LSL, r9},
     false,
     al,
     "cs r13 r11 LSL r9",
     "cs_r13_r11_LSL_r9"},
    {{hi, r11, r14, LSL, r10},
     false,
     al,
     "hi r11 r14 LSL r10",
     "hi_r11_r14_LSL_r10"},
    {{mi, r7, r5, ROR, r7}, false, al, "mi r7 r5 ROR r7", "mi_r7_r5_ROR_r7"},
    {{ls, r1, r10, ROR, r13},
     false,
     al,
     "ls r1 r10 ROR r13",
     "ls_r1_r10_ROR_r13"},
    {{mi, r10, r10, LSR, r12},
     false,
     al,
     "mi r10 r10 LSR r12",
     "mi_r10_r10_LSR_r12"},
    {{le, r14, r7, LSR, r11},
     false,
     al,
     "le r14 r7 LSR r11",
     "le_r14_r7_LSR_r11"},
    {{al, r3, r12, LSR, r14},
     false,
     al,
     "al r3 r12 LSR r14",
     "al_r3_r12_LSR_r14"},
    {{vs, r1, r3, ROR, r1}, false, al, "vs r1 r3 ROR r1", "vs_r1_r3_ROR_r1"},
    {{ge, r4, r10, LSL, r13},
     false,
     al,
     "ge r4 r10 LSL r13",
     "ge_r4_r10_LSL_r13"},
    {{cs, r4, r3, LSL, r13}, false, al, "cs r4 r3 LSL r13", "cs_r4_r3_LSL_r13"},
    {{ge, r9, r5, ASR, r11}, false, al, "ge r9 r5 ASR r11", "ge_r9_r5_ASR_r11"},
    {{pl, r12, r4, ROR, r14},
     false,
     al,
     "pl r12 r4 ROR r14",
     "pl_r12_r4_ROR_r14"},
    {{mi, r11, r5, LSR, r3}, false, al, "mi r11 r5 LSR r3", "mi_r11_r5_LSR_r3"},
    {{mi, r13, r5, LSR, r4}, false, al, "mi r13 r5 LSR r4", "mi_r13_r5_LSR_r4"},
    {{ls, r13, r0, ASR, r14},
     false,
     al,
     "ls r13 r0 ASR r14",
     "ls_r13_r0_ASR_r14"},
    {{cc, r1, r9, ROR, r8}, false, al, "cc r1 r9 ROR r8", "cc_r1_r9_ROR_r8"},
    {{mi, r2, r9, LSL, r7}, false, al, "mi r2 r9 LSL r7", "mi_r2_r9_LSL_r7"},
    {{gt, r12, r13, LSR, r1},
     false,
     al,
     "gt r12 r13 LSR r1",
     "gt_r12_r13_LSR_r1"},
    {{le, r6, r3, LSL, r9}, false, al, "le r6 r3 LSL r9", "le_r6_r3_LSL_r9"},
    {{hi, r11, r2, LSR, r6}, false, al, "hi r11 r2 LSR r6", "hi_r11_r2_LSR_r6"},
    {{vc, r2, r7, ROR, r10}, false, al, "vc r2 r7 ROR r10", "vc_r2_r7_ROR_r10"},
    {{ge, r1, r1, ASR, r9}, false, al, "ge r1 r1 ASR r9", "ge_r1_r1_ASR_r9"},
    {{le, r8, r14, ROR, r2}, false, al, "le r8 r14 ROR r2", "le_r8_r14_ROR_r2"},
    {{cs, r5, r4, LSR, r12}, false, al, "cs r5 r4 LSR r12", "cs_r5_r4_LSR_r12"},
    {{ne, r6, r7, ASR, r10}, false, al, "ne r6 r7 ASR r10", "ne_r6_r7_ASR_r10"},
    {{lt, r8, r3, LSL, r7}, false, al, "lt r8 r3 LSL r7", "lt_r8_r3_LSL_r7"},
    {{ls, r6, r2, LSL, r6}, false, al, "ls r6 r2 LSL r6", "ls_r6_r2_LSL_r6"},
    {{hi, r6, r3, ROR, r1}, false, al, "hi r6 r3 ROR r1", "hi_r6_r3_ROR_r1"},
    {{le, r10, r9, LSL, r14},
     false,
     al,
     "le r10 r9 LSL r14",
     "le_r10_r9_LSL_r14"},
    {{le, r5, r6, ROR, r11}, false, al, "le r5 r6 ROR r11", "le_r5_r6_ROR_r11"},
    {{ne, r7, r12, ASR, r7}, false, al, "ne r7 r12 ASR r7", "ne_r7_r12_ASR_r7"},
    {{gt, r11, r5, ASR, r1}, false, al, "gt r11 r5 ASR r1", "gt_r11_r5_ASR_r1"},
    {{al, r9, r4, ROR, r10}, false, al, "al r9 r4 ROR r10", "al_r9_r4_ROR_r10"},
    {{vc, r5, r9, ROR, r12}, false, al, "vc r5 r9 ROR r12", "vc_r5_r9_ROR_r12"},
    {{hi, r1, r0, LSR, r3}, false, al, "hi r1 r0 LSR r3", "hi_r1_r0_LSR_r3"},
    {{mi, r2, r12, ROR, r8}, false, al, "mi r2 r12 ROR r8", "mi_r2_r12_ROR_r8"},
    {{eq, r14, r9, ROR, r10},
     false,
     al,
     "eq r14 r9 ROR r10",
     "eq_r14_r9_ROR_r10"},
    {{le, r8, r13, LSL, r1}, false, al, "le r8 r13 LSL r1", "le_r8_r13_LSL_r1"},
    {{ne, r13, r4, ROR, r4}, false, al, "ne r13 r4 ROR r4", "ne_r13_r4_ROR_r4"},
    {{ge, r4, r13, ROR, r14},
     false,
     al,
     "ge r4 r13 ROR r14",
     "ge_r4_r13_ROR_r14"},
    {{vc, r10, r10, LSL, r1},
     false,
     al,
     "vc r10 r10 LSL r1",
     "vc_r10_r10_LSL_r1"},
    {{gt, r10, r2, ROR, r10},
     false,
     al,
     "gt r10 r2 ROR r10",
     "gt_r10_r2_ROR_r10"},
    {{eq, r3, r10, ROR, r12},
     false,
     al,
     "eq r3 r10 ROR r12",
     "eq_r3_r10_ROR_r12"},
    {{pl, r8, r8, ASR, r14}, false, al, "pl r8 r8 ASR r14", "pl_r8_r8_ASR_r14"},
    {{hi, r6, r11, LSR, r0}, false, al, "hi r6 r11 LSR r0", "hi_r6_r11_LSR_r0"},
    {{pl, r2, r13, LSR, r13},
     false,
     al,
     "pl r2 r13 LSR r13",
     "pl_r2_r13_LSR_r13"},
    {{cs, r3, r1, ASR, r4}, false, al, "cs r3 r1 ASR r4", "cs_r3_r1_ASR_r4"},
    {{ge, r13, r8, ROR, r5}, false, al, "ge r13 r8 ROR r5", "ge_r13_r8_ROR_r5"},
    {{ne, r3, r9, ASR, r10}, false, al, "ne r3 r9 ASR r10", "ne_r3_r9_ASR_r10"},
    {{cc, r6, r12, ASR, r9}, false, al, "cc r6 r12 ASR r9", "cc_r6_r12_ASR_r9"},
    {{cc, r10, r8, LSR, r10},
     false,
     al,
     "cc r10 r8 LSR r10",
     "cc_r10_r8_LSR_r10"},
    {{vc, r7, r0, ASR, r7}, false, al, "vc r7 r0 ASR r7", "vc_r7_r0_ASR_r7"},
    {{lt, r2, r5, LSL, r2}, false, al, "lt r2 r5 LSL r2", "lt_r2_r5_LSL_r2"},
    {{gt, r13, r1, ASR, r8}, false, al, "gt r13 r1 ASR r8", "gt_r13_r1_ASR_r8"},
    {{hi, r11, r14, LSR, r0},
     false,
     al,
     "hi r11 r14 LSR r0",
     "hi_r11_r14_LSR_r0"},
    {{ls, r3, r2, LSL, r2}, false, al, "ls r3 r2 LSL r2", "ls_r3_r2_LSL_r2"},
    {{mi, r5, r2, ROR, r13}, false, al, "mi r5 r2 ROR r13", "mi_r5_r2_ROR_r13"},
    {{ne, r14, r2, ASR, r0}, false, al, "ne r14 r2 ASR r0", "ne_r14_r2_ASR_r0"},
    {{pl, r4, r8, LSL, r2}, false, al, "pl r4 r8 LSL r2", "pl_r4_r8_LSL_r2"},
    {{ge, r8, r10, LSR, r13},
     false,
     al,
     "ge r8 r10 LSR r13",
     "ge_r8_r10_LSR_r13"},
    {{mi, r14, r14, ASR, r12},
     false,
     al,
     "mi r14 r14 ASR r12",
     "mi_r14_r14_ASR_r12"},
    {{ge, r3, r1, LSL, r9}, false, al, "ge r3 r1 LSL r9", "ge_r3_r1_LSL_r9"},
    {{mi, r12, r4, ASR, r6}, false, al, "mi r12 r4 ASR r6", "mi_r12_r4_ASR_r6"},
    {{le, r1, r4, LSL, r6}, false, al, "le r1 r4 LSL r6", "le_r1_r4_LSL_r6"},
    {{ge, r14, r9, ROR, r7}, false, al, "ge r14 r9 ROR r7", "ge_r14_r9_ROR_r7"},
    {{gt, r6, r14, LSL, r7}, false, al, "gt r6 r14 LSL r7", "gt_r6_r14_LSL_r7"},
    {{vc, r12, r7, ASR, r3}, false, al, "vc r12 r7 ASR r3", "vc_r12_r7_ASR_r3"},
    {{ne, r7, r5, ROR, r0}, false, al, "ne r7 r5 ROR r0", "ne_r7_r5_ROR_r0"},
    {{ne, r13, r2, ROR, r12},
     false,
     al,
     "ne r13 r2 ROR r12",
     "ne_r13_r2_ROR_r12"},
    {{cc, r9, r2, ASR, r10}, false, al, "cc r9 r2 ASR r10", "cc_r9_r2_ASR_r10"},
    {{ls, r7, r6, LSR, r5}, false, al, "ls r7 r6 LSR r5", "ls_r7_r6_LSR_r5"},
    {{gt, r14, r1, ASR, r12},
     false,
     al,
     "gt r14 r1 ASR r12",
     "gt_r14_r1_ASR_r12"},
    {{vs, r11, r4, ROR, r4}, false, al, "vs r11 r4 ROR r4", "vs_r11_r4_ROR_r4"},
    {{le, r13, r13, ROR, r14},
     false,
     al,
     "le r13 r13 ROR r14",
     "le_r13_r13_ROR_r14"},
    {{eq, r12, r3, LSR, r2}, false, al, "eq r12 r3 LSR r2", "eq_r12_r3_LSR_r2"},
    {{vs, r9, r14, LSL, r1}, false, al, "vs r9 r14 LSL r1", "vs_r9_r14_LSL_r1"},
    {{le, r8, r9, LSL, r9}, false, al, "le r8 r9 LSL r9", "le_r8_r9_LSL_r9"},
    {{ne, r2, r13, ROR, r12},
     false,
     al,
     "ne r2 r13 ROR r12",
     "ne_r2_r13_ROR_r12"},
    {{eq, r0, r14, ROR, r14},
     false,
     al,
     "eq r0 r14 ROR r14",
     "eq_r0_r14_ROR_r14"},
    {{cc, r8, r0, ROR, r9}, false, al, "cc r8 r0 ROR r9", "cc_r8_r0_ROR_r9"},
    {{gt, r11, r0, LSR, r9}, false, al, "gt r11 r0 LSR r9", "gt_r11_r0_LSR_r9"},
    {{vc, r1, r8, LSL, r4}, false, al, "vc r1 r8 LSL r4", "vc_r1_r8_LSL_r4"},
    {{ne, r4, r4, ROR, r3}, false, al, "ne r4 r4 ROR r3", "ne_r4_r4_ROR_r3"},
    {{cs, r12, r6, LSR, r0}, false, al, "cs r12 r6 LSR r0", "cs_r12_r6_LSR_r0"},
    {{pl, r8, r14, ROR, r7}, false, al, "pl r8 r14 ROR r7", "pl_r8_r14_ROR_r7"},
    {{hi, r7, r11, LSR, r14},
     false,
     al,
     "hi r7 r11 LSR r14",
     "hi_r7_r11_LSR_r14"},
    {{vs, r1, r9, ASR, r14}, false, al, "vs r1 r9 ASR r14", "vs_r1_r9_ASR_r14"},
    {{ge, r11, r4, LSR, r14},
     false,
     al,
     "ge r11 r4 LSR r14",
     "ge_r11_r4_LSR_r14"},
    {{gt, r9, r13, LSL, r0}, false, al, "gt r9 r13 LSL r0", "gt_r9_r13_LSL_r0"},
    {{cc, r11, r1, LSR, r7}, false, al, "cc r11 r1 LSR r7", "cc_r11_r1_LSR_r7"},
    {{al, r14, r7, ROR, r12},
     false,
     al,
     "al r14 r7 ROR r12",
     "al_r14_r7_ROR_r12"},
    {{vc, r11, r5, ROR, r1}, false, al, "vc r11 r5 ROR r1", "vc_r11_r5_ROR_r1"},
    {{eq, r14, r9, ROR, r2}, false, al, "eq r14 r9 ROR r2", "eq_r14_r9_ROR_r2"},
    {{eq, r6, r10, LSR, r8}, false, al, "eq r6 r10 LSR r8", "eq_r6_r10_LSR_r8"},
    {{cc, r5, r7, LSL, r10}, false, al, "cc r5 r7 LSL r10", "cc_r5_r7_LSL_r10"},
    {{vc, r0, r6, ROR, r5}, false, al, "vc r0 r6 ROR r5", "vc_r0_r6_ROR_r5"},
    {{ls, r3, r2, ASR, r5}, false, al, "ls r3 r2 ASR r5", "ls_r3_r2_ASR_r5"},
    {{eq, r0, r5, LSL, r13}, false, al, "eq r0 r5 LSL r13", "eq_r0_r5_LSL_r13"},
    {{hi, r3, r2, ASR, r2}, false, al, "hi r3 r2 ASR r2", "hi_r3_r2_ASR_r2"},
    {{vs, r6, r1, ASR, r1}, false, al, "vs r6 r1 ASR r1", "vs_r6_r1_ASR_r1"},
    {{al, r7, r6, ASR, r11}, false, al, "al r7 r6 ASR r11", "al_r7_r6_ASR_r11"},
    {{al, r0, r7, LSR, r6}, false, al, "al r0 r7 LSR r6", "al_r0_r7_LSR_r6"},
    {{vc, r6, r11, LSL, r13},
     false,
     al,
     "vc r6 r11 LSL r13",
     "vc_r6_r11_LSL_r13"},
    {{mi, r11, r0, LSR, r11},
     false,
     al,
     "mi r11 r0 LSR r11",
     "mi_r11_r0_LSR_r11"},
    {{ne, r10, r10, ROR, r7},
     false,
     al,
     "ne r10 r10 ROR r7",
     "ne_r10_r10_ROR_r7"},
    {{eq, r9, r10, ROR, r8}, false, al, "eq r9 r10 ROR r8", "eq_r9_r10_ROR_r8"},
    {{vc, r0, r11, ROR, r6}, false, al, "vc r0 r11 ROR r6", "vc_r0_r11_ROR_r6"},
    {{eq, r3, r2, LSR, r10}, false, al, "eq r3 r2 LSR r10", "eq_r3_r2_LSR_r10"},
    {{gt, r13, r4, LSR, r7}, false, al, "gt r13 r4 LSR r7", "gt_r13_r4_LSR_r7"},
    {{lt, r1, r12, LSR, r11},
     false,
     al,
     "lt r1 r12 LSR r11",
     "lt_r1_r12_LSR_r11"},
    {{cs, r12, r7, LSR, r4}, false, al, "cs r12 r7 LSR r4", "cs_r12_r7_LSR_r4"},
    {{cc, r1, r13, ASR, r13},
     false,
     al,
     "cc r1 r13 ASR r13",
     "cc_r1_r13_ASR_r13"},
    {{mi, r4, r9, LSL, r0}, false, al, "mi r4 r9 LSL r0", "mi_r4_r9_LSL_r0"},
    {{gt, r14, r7, ROR, r0}, false, al, "gt r14 r7 ROR r0", "gt_r14_r7_ROR_r0"},
    {{gt, r1, r0, ASR, r6}, false, al, "gt r1 r0 ASR r6", "gt_r1_r0_ASR_r6"},
    {{ne, r14, r10, ASR, r10},
     false,
     al,
     "ne r14 r10 ASR r10",
     "ne_r14_r10_ASR_r10"},
    {{pl, r14, r9, LSR, r8}, false, al, "pl r14 r9 LSR r8", "pl_r14_r9_LSR_r8"},
    {{vs, r3, r7, LSL, r6}, false, al, "vs r3 r7 LSL r6", "vs_r3_r7_LSL_r6"},
    {{lt, r12, r0, LSL, r3}, false, al, "lt r12 r0 LSL r3", "lt_r12_r0_LSL_r3"},
    {{hi, r5, r11, ROR, r13},
     false,
     al,
     "hi r5 r11 ROR r13",
     "hi_r5_r11_ROR_r13"},
    {{vc, r5, r2, LSR, r2}, false, al, "vc r5 r2 LSR r2", "vc_r5_r2_LSR_r2"},
    {{le, r13, r8, ROR, r0}, false, al, "le r13 r8 ROR r0", "le_r13_r8_ROR_r0"},
    {{cc, r13, r9, LSL, r10},
     false,
     al,
     "cc r13 r9 LSL r10",
     "cc_r13_r9_LSL_r10"},
    {{ne, r0, r3, ASR, r9}, false, al, "ne r0 r3 ASR r9", "ne_r0_r3_ASR_r9"},
    {{mi, r0, r8, ASR, r10}, false, al, "mi r0 r8 ASR r10", "mi_r0_r8_ASR_r10"},
    {{cc, r4, r4, ASR, r4}, false, al, "cc r4 r4 ASR r4", "cc_r4_r4_ASR_r4"},
    {{vc, r5, r10, LSL, r11},
     false,
     al,
     "vc r5 r10 LSL r11",
     "vc_r5_r10_LSL_r11"},
    {{gt, r11, r10, ROR, r2},
     false,
     al,
     "gt r11 r10 ROR r2",
     "gt_r11_r10_ROR_r2"},
    {{ne, r5, r5, LSR, r11}, false, al, "ne r5 r5 LSR r11", "ne_r5_r5_LSR_r11"},
    {{ne, r6, r11, LSR, r13},
     false,
     al,
     "ne r6 r11 LSR r13",
     "ne_r6_r11_LSR_r13"},
    {{lt, r3, r1, ROR, r1}, false, al, "lt r3 r1 ROR r1", "lt_r3_r1_ROR_r1"},
    {{cc, r1, r14, ASR, r12},
     false,
     al,
     "cc r1 r14 ASR r12",
     "cc_r1_r14_ASR_r12"},
    {{mi, r2, r10, ROR, r10},
     false,
     al,
     "mi r2 r10 ROR r10",
     "mi_r2_r10_ROR_r10"},
    {{eq, r5, r8, ROR, r10}, false, al, "eq r5 r8 ROR r10", "eq_r5_r8_ROR_r10"},
    {{al, r3, r9, LSL, r2}, false, al, "al r3 r9 LSL r2", "al_r3_r9_LSL_r2"},
    {{cs, r1, r14, LSR, r7}, false, al, "cs r1 r14 LSR r7", "cs_r1_r14_LSR_r7"},
    {{cc, r14, r9, ROR, r1}, false, al, "cc r14 r9 ROR r1", "cc_r14_r9_ROR_r1"},
    {{al, r3, r8, ROR, r10}, false, al, "al r3 r8 ROR r10", "al_r3_r8_ROR_r10"},
    {{vs, r2, r10, ASR, r5}, false, al, "vs r2 r10 ASR r5", "vs_r2_r10_ASR_r5"},
    {{al, r7, r8, ROR, r11}, false, al, "al r7 r8 ROR r11", "al_r7_r8_ROR_r11"},
    {{cc, r11, r12, ASR, r13},
     false,
     al,
     "cc r11 r12 ASR r13",
     "cc_r11_r12_ASR_r13"},
    {{cs, r2, r7, LSR, r12}, false, al, "cs r2 r7 LSR r12", "cs_r2_r7_LSR_r12"},
    {{vs, r7, r4, ROR, r14}, false, al, "vs r7 r4 ROR r14", "vs_r7_r4_ROR_r14"},
    {{ne, r12, r1, ROR, r3}, false, al, "ne r12 r1 ROR r3", "ne_r12_r1_ROR_r3"},
    {{ne, r5, r11, LSL, r2}, false, al, "ne r5 r11 LSL r2", "ne_r5_r11_LSL_r2"},
    {{cc, r5, r12, ASR, r13},
     false,
     al,
     "cc r5 r12 ASR r13",
     "cc_r5_r12_ASR_r13"},
    {{gt, r8, r0, LSL, r14}, false, al, "gt r8 r0 LSL r14", "gt_r8_r0_LSL_r14"},
    {{cc, r5, r4, LSR, r12}, false, al, "cc r5 r4 LSR r12", "cc_r5_r4_LSR_r12"},
    {{ge, r6, r7, LSR, r14}, false, al, "ge r6 r7 LSR r14", "ge_r6_r7_LSR_r14"},
    {{vs, r2, r0, LSL, r13}, false, al, "vs r2 r0 LSL r13", "vs_r2_r0_LSL_r13"},
    {{gt, r7, r8, LSL, r0}, false, al, "gt r7 r8 LSL r0", "gt_r7_r8_LSL_r0"},
    {{ne, r3, r11, ROR, r8}, false, al, "ne r3 r11 ROR r8", "ne_r3_r11_ROR_r8"},
    {{ne, r0, r8, LSR, r4}, false, al, "ne r0 r8 LSR r4", "ne_r0_r8_LSR_r4"},
    {{eq, r1, r14, ASR, r13},
     false,
     al,
     "eq r1 r14 ASR r13",
     "eq_r1_r14_ASR_r13"},
    {{pl, r13, r10, LSL, r4},
     false,
     al,
     "pl r13 r10 LSL r4",
     "pl_r13_r10_LSL_r4"},
    {{mi, r12, r14, LSL, r11},
     false,
     al,
     "mi r12 r14 LSL r11",
     "mi_r12_r14_LSL_r11"},
    {{vc, r6, r4, LSL, r7}, false, al, "vc r6 r4 LSL r7", "vc_r6_r4_LSL_r7"},
    {{ge, r7, r8, LSR, r0}, false, al, "ge r7 r8 LSR r0", "ge_r7_r8_LSR_r0"},
    {{ls, r2, r12, LSR, r6}, false, al, "ls r2 r12 LSR r6", "ls_r2_r12_LSR_r6"},
    {{lt, r0, r13, LSL, r1}, false, al, "lt r0 r13 LSL r1", "lt_r0_r13_LSL_r1"},
    {{vs, r5, r7, LSR, r0}, false, al, "vs r5 r7 LSR r0", "vs_r5_r7_LSR_r0"},
    {{ne, r10, r8, ROR, r4}, false, al, "ne r10 r8 ROR r4", "ne_r10_r8_ROR_r4"},
    {{vc, r4, r1, LSL, r7}, false, al, "vc r4 r1 LSL r7", "vc_r4_r1_LSL_r7"},
    {{mi, r14, r1, ROR, r10},
     false,
     al,
     "mi r14 r1 ROR r10",
     "mi_r14_r1_ROR_r10"},
    {{le, r4, r5, LSL, r12}, false, al, "le r4 r5 LSL r12", "le_r4_r5_LSL_r12"},
    {{cs, r9, r3, ROR, r10}, false, al, "cs r9 r3 ROR r10", "cs_r9_r3_ROR_r10"},
    {{al, r5, r9, ROR, r7}, false, al, "al r5 r9 ROR r7", "al_r5_r9_ROR_r7"},
    {{cs, r14, r14, ROR, r1},
     false,
     al,
     "cs r14 r14 ROR r1",
     "cs_r14_r14_ROR_r1"},
    {{vc, r5, r11, LSR, r1}, false, al, "vc r5 r11 LSR r1", "vc_r5_r11_LSR_r1"},
    {{hi, r12, r7, ASR, r3}, false, al, "hi r12 r7 ASR r3", "hi_r12_r7_ASR_r3"},
    {{gt, r13, r3, LSL, r10},
     false,
     al,
     "gt r13 r3 LSL r10",
     "gt_r13_r3_LSL_r10"},
    {{pl, r12, r14, ASR, r14},
     false,
     al,
     "pl r12 r14 ASR r14",
     "pl_r12_r14_ASR_r14"},
    {{al, r3, r1, ROR, r6}, false, al, "al r3 r1 ROR r6", "al_r3_r1_ROR_r6"},
    {{le, r13, r2, ROR, r9}, false, al, "le r13 r2 ROR r9", "le_r13_r2_ROR_r9"},
    {{cs, r12, r4, LSL, r9}, false, al, "cs r12 r4 LSL r9", "cs_r12_r4_LSL_r9"},
    {{gt, r4, r7, ASR, r14}, false, al, "gt r4 r7 ASR r14", "gt_r4_r7_ASR_r14"},
    {{vc, r13, r1, ROR, r10},
     false,
     al,
     "vc r13 r1 ROR r10",
     "vc_r13_r1_ROR_r10"},
    {{ls, r10, r12, LSR, r1},
     false,
     al,
     "ls r10 r12 LSR r1",
     "ls_r10_r12_LSR_r1"},
    {{hi, r8, r0, LSL, r0}, false, al, "hi r8 r0 LSL r0", "hi_r8_r0_LSL_r0"},
    {{al, r4, r9, LSL, r0}, false, al, "al r4 r9 LSL r0", "al_r4_r9_LSL_r0"},
    {{eq, r12, r10, LSL, r14},
     false,
     al,
     "eq r12 r10 LSL r14",
     "eq_r12_r10_LSL_r14"},
    {{le, r4, r9, LSL, r12}, false, al, "le r4 r9 LSL r12", "le_r4_r9_LSL_r12"},
    {{cc, r1, r6, ASR, r14}, false, al, "cc r1 r6 ASR r14", "cc_r1_r6_ASR_r14"},
    {{pl, r3, r7, ASR, r2}, false, al, "pl r3 r7 ASR r2", "pl_r3_r7_ASR_r2"},
    {{eq, r14, r9, ROR, r0}, false, al, "eq r14 r9 ROR r0", "eq_r14_r9_ROR_r0"},
    {{hi, r8, r6, LSR, r5}, false, al, "hi r8 r6 LSR r5", "hi_r8_r6_LSR_r5"},
    {{hi, r10, r1, LSL, r0}, false, al, "hi r10 r1 LSL r0", "hi_r10_r1_LSL_r0"},
    {{ls, r0, r13, LSR, r0}, false, al, "ls r0 r13 LSR r0", "ls_r0_r13_LSR_r0"},
    {{vs, r10, r7, ROR, r7}, false, al, "vs r10 r7 ROR r7", "vs_r10_r7_ROR_r7"},
    {{eq, r1, r3, LSR, r6}, false, al, "eq r1 r3 LSR r6", "eq_r1_r3_LSR_r6"},
    {{eq, r8, r6, ASR, r0}, false, al, "eq r8 r6 ASR r0", "eq_r8_r6_ASR_r0"},
    {{eq, r2, r5, LSR, r10}, false, al, "eq r2 r5 LSR r10", "eq_r2_r5_LSR_r10"},
    {{al, r0, r4, LSL, r13}, false, al, "al r0 r4 LSL r13", "al_r0_r4_LSL_r13"},
    {{ge, r0, r12, ROR, r2}, false, al, "ge r0 r12 ROR r2", "ge_r0_r12_ROR_r2"},
    {{le, r0, r13, ROR, r4}, false, al, "le r0 r13 ROR r4", "le_r0_r13_ROR_r4"},
    {{ge, r3, r11, ASR, r6}, false, al, "ge r3 r11 ASR r6", "ge_r3_r11_ASR_r6"},
    {{ne, r7, r11, ROR, r0}, false, al, "ne r7 r11 ROR r0", "ne_r7_r11_ROR_r0"},
    {{hi, r14, r5, ASR, r0}, false, al, "hi r14 r5 ASR r0", "hi_r14_r5_ASR_r0"},
    {{cs, r12, r9, LSL, r2}, false, al, "cs r12 r9 LSL r2", "cs_r12_r9_LSL_r2"},
    {{cs, r12, r8, ASR, r10},
     false,
     al,
     "cs r12 r8 ASR r10",
     "cs_r12_r8_ASR_r10"},
    {{cc, r0, r2, LSR, r13}, false, al, "cc r0 r2 LSR r13", "cc_r0_r2_LSR_r13"},
    {{cc, r5, r0, LSR, r4}, false, al, "cc r5 r0 LSR r4", "cc_r5_r0_LSR_r4"},
    {{ne, r10, r14, ROR, r3},
     false,
     al,
     "ne r10 r14 ROR r3",
     "ne_r10_r14_ROR_r3"},
    {{hi, r5, r1, LSL, r10}, false, al, "hi r5 r1 LSL r10", "hi_r5_r1_LSL_r10"},
    {{lt, r14, r12, LSR, r13},
     false,
     al,
     "lt r14 r12 LSR r13",
     "lt_r14_r12_LSR_r13"},
    {{hi, r14, r9, LSR, r5}, false, al, "hi r14 r9 LSR r5", "hi_r14_r9_LSR_r5"},
    {{cc, r4, r4, LSR, r3}, false, al, "cc r4 r4 LSR r3", "cc_r4_r4_LSR_r3"},
    {{hi, r9, r4, ROR, r13}, false, al, "hi r9 r4 ROR r13", "hi_r9_r4_ROR_r13"},
    {{cc, r7, r6, ASR, r0}, false, al, "cc r7 r6 ASR r0", "cc_r7_r6_ASR_r0"},
    {{ne, r6, r12, ROR, r8}, false, al, "ne r6 r12 ROR r8", "ne_r6_r12_ROR_r8"},
    {{cc, r4, r1, LSL, r9}, false, al, "cc r4 r1 LSL r9", "cc_r4_r1_LSL_r9"},
    {{ls, r6, r10, LSR, r9}, false, al, "ls r6 r10 LSR r9", "ls_r6_r10_LSR_r9"},
    {{ge, r13, r6, ASR, r4}, false, al, "ge r13 r6 ASR r4", "ge_r13_r6_ASR_r4"},
    {{pl, r0, r6, ROR, r12}, false, al, "pl r0 r6 ROR r12", "pl_r0_r6_ROR_r12"},
    {{eq, r13, r2, LSL, r6}, false, al, "eq r13 r2 LSL r6", "eq_r13_r2_LSL_r6"},
    {{vc, r5, r14, LSR, r2}, false, al, "vc r5 r14 LSR r2", "vc_r5_r14_LSR_r2"},
    {{ls, r3, r7, LSL, r14}, false, al, "ls r3 r7 LSL r14", "ls_r3_r7_LSL_r14"},
    {{le, r13, r7, ROR, r1}, false, al, "le r13 r7 ROR r1", "le_r13_r7_ROR_r1"},
    {{ge, r6, r1, ROR, r2}, false, al, "ge r6 r1 ROR r2", "ge_r6_r1_ROR_r2"},
    {{le, r5, r13, LSL, r8}, false, al, "le r5 r13 LSL r8", "le_r5_r13_LSL_r8"},
    {{eq, r13, r14, ROR, r6},
     false,
     al,
     "eq r13 r14 ROR r6",
     "eq_r13_r14_ROR_r6"},
    {{vs, r10, r9, ASR, r2}, false, al, "vs r10 r9 ASR r2", "vs_r10_r9_ASR_r2"},
    {{ls, r7, r10, LSL, r10},
     false,
     al,
     "ls r7 r10 LSL r10",
     "ls_r7_r10_LSL_r10"},
    {{mi, r0, r8, LSL, r13}, false, al, "mi r0 r8 LSL r13", "mi_r0_r8_LSL_r13"},
    {{cc, r6, r5, ROR, r6}, false, al, "cc r6 r5 ROR r6", "cc_r6_r5_ROR_r6"},
    {{cc, r5, r14, ASR, r9}, false, al, "cc r5 r14 ASR r9", "cc_r5_r14_ASR_r9"},
    {{ge, r8, r3, ROR, r4}, false, al, "ge r8 r3 ROR r4", "ge_r8_r3_ROR_r4"},
    {{ge, r4, r3, ROR, r0}, false, al, "ge r4 r3 ROR r0", "ge_r4_r3_ROR_r0"},
    {{lt, r12, r13, ROR, r5},
     false,
     al,
     "lt r12 r13 ROR r5",
     "lt_r12_r13_ROR_r5"},
    {{cs, r14, r14, LSL, r8},
     false,
     al,
     "cs r14 r14 LSL r8",
     "cs_r14_r14_LSL_r8"},
    {{mi, r6, r3, ASR, r12}, false, al, "mi r6 r3 ASR r12", "mi_r6_r3_ASR_r12"},
    {{gt, r2, r1, ASR, r3}, false, al, "gt r2 r1 ASR r3", "gt_r2_r1_ASR_r3"},
    {{vc, r14, r14, LSL, r11},
     false,
     al,
     "vc r14 r14 LSL r11",
     "vc_r14_r14_LSL_r11"},
    {{pl, r12, r14, ASR, r5},
     false,
     al,
     "pl r12 r14 ASR r5",
     "pl_r12_r14_ASR_r5"},
    {{cs, r7, r12, LSL, r14},
     false,
     al,
     "cs r7 r12 LSL r14",
     "cs_r7_r12_LSL_r14"},
    {{eq, r3, r1, LSR, r3}, false, al, "eq r3 r1 LSR r3", "eq_r3_r1_LSR_r3"},
    {{cs, r6, r7, ASR, r12}, false, al, "cs r6 r7 ASR r12", "cs_r6_r7_ASR_r12"},
    {{le, r6, r4, ROR, r4}, false, al, "le r6 r4 ROR r4", "le_r6_r4_ROR_r4"},
    {{hi, r1, r6, LSR, r4}, false, al, "hi r1 r6 LSR r4", "hi_r1_r6_LSR_r4"},
    {{mi, r6, r3, ASR, r4}, false, al, "mi r6 r3 ASR r4", "mi_r6_r3_ASR_r4"},
    {{vs, r9, r10, ASR, r12},
     false,
     al,
     "vs r9 r10 ASR r12",
     "vs_r9_r10_ASR_r12"},
    {{cc, r9, r10, LSL, r1}, false, al, "cc r9 r10 LSL r1", "cc_r9_r10_LSL_r1"},
    {{ls, r12, r9, ASR, r4}, false, al, "ls r12 r9 ASR r4", "ls_r12_r9_ASR_r4"},
    {{vc, r10, r7, ASR, r12},
     false,
     al,
     "vc r10 r7 ASR r12",
     "vc_r10_r7_ASR_r12"},
    {{cs, r8, r1, LSR, r5}, false, al, "cs r8 r1 LSR r5", "cs_r8_r1_LSR_r5"},
    {{eq, r10, r10, ASR, r4},
     false,
     al,
     "eq r10 r10 ASR r4",
     "eq_r10_r10_ASR_r4"},
    {{ls, r7, r7, LSL, r5}, false, al, "ls r7 r7 LSL r5", "ls_r7_r7_LSL_r5"},
    {{vs, r8, r11, ROR, r12},
     false,
     al,
     "vs r8 r11 ROR r12",
     "vs_r8_r11_ROR_r12"},
    {{vs, r7, r6, ASR, r4}, false, al, "vs r7 r6 ASR r4", "vs_r7_r6_ASR_r4"},
    {{ge, r5, r3, LSL, r6}, false, al, "ge r5 r3 LSL r6", "ge_r5_r3_LSL_r6"},
    {{vc, r5, r5, LSL, r12}, false, al, "vc r5 r5 LSL r12", "vc_r5_r5_LSL_r12"},
    {{le, r0, r13, LSL, r12},
     false,
     al,
     "le r0 r13 LSL r12",
     "le_r0_r13_LSL_r12"},
    {{ls, r4, r0, ASR, r11}, false, al, "ls r4 r0 ASR r11", "ls_r4_r0_ASR_r11"},
    {{ge, r3, r7, ASR, r5}, false, al, "ge r3 r7 ASR r5", "ge_r3_r7_ASR_r5"},
    {{ge, r11, r4, ROR, r11},
     false,
     al,
     "ge r11 r4 ROR r11",
     "ge_r11_r4_ROR_r11"},
    {{al, r6, r7, ROR, r7}, false, al, "al r6 r7 ROR r7", "al_r6_r7_ROR_r7"},
    {{gt, r4, r4, LSR, r6}, false, al, "gt r4 r4 LSR r6", "gt_r4_r4_LSR_r6"},
    {{pl, r14, r2, LSR, r1}, false, al, "pl r14 r2 LSR r1", "pl_r14_r2_LSR_r1"},
    {{le, r10, r9, ROR, r9}, false, al, "le r10 r9 ROR r9", "le_r10_r9_ROR_r9"},
    {{ne, r5, r3, ASR, r2}, false, al, "ne r5 r3 ASR r2", "ne_r5_r3_ASR_r2"},
    {{lt, r12, r4, LSL, r11},
     false,
     al,
     "lt r12 r4 LSL r11",
     "lt_r12_r4_LSL_r11"},
    {{mi, r1, r1, LSR, r13}, false, al, "mi r1 r1 LSR r13", "mi_r1_r1_LSR_r13"},
    {{hi, r7, r4, ROR, r9}, false, al, "hi r7 r4 ROR r9", "hi_r7_r4_ROR_r9"},
    {{lt, r8, r14, LSR, r10},
     false,
     al,
     "lt r8 r14 LSR r10",
     "lt_r8_r14_LSR_r10"},
    {{ge, r7, r5, ROR, r11}, false, al, "ge r7 r5 ROR r11", "ge_r7_r5_ROR_r11"},
    {{ls, r12, r14, LSL, r7},
     false,
     al,
     "ls r12 r14 LSL r7",
     "ls_r12_r14_LSL_r7"},
    {{hi, r14, r0, LSL, r3}, false, al, "hi r14 r0 LSL r3", "hi_r14_r0_LSL_r3"},
    {{ge, r8, r10, ROR, r2}, false, al, "ge r8 r10 ROR r2", "ge_r8_r10_ROR_r2"},
    {{hi, r6, r3, LSR, r0}, false, al, "hi r6 r3 LSR r0", "hi_r6_r3_LSR_r0"},
    {{ls, r4, r1, ROR, r3}, false, al, "ls r4 r1 ROR r3", "ls_r4_r1_ROR_r3"},
    {{ls, r9, r13, ASR, r1}, false, al, "ls r9 r13 ASR r1", "ls_r9_r13_ASR_r1"},
    {{lt, r10, r1, LSR, r5}, false, al, "lt r10 r1 LSR r5", "lt_r10_r1_LSR_r5"},
    {{vc, r10, r13, ASR, r3},
     false,
     al,
     "vc r10 r13 ASR r3",
     "vc_r10_r13_ASR_r3"},
    {{gt, r1, r0, LSR, r9}, false, al, "gt r1 r0 LSR r9", "gt_r1_r0_LSR_r9"},
    {{vs, r13, r11, LSL, r14},
     false,
     al,
     "vs r13 r11 LSL r14",
     "vs_r13_r11_LSL_r14"},
    {{eq, r4, r7, LSL, r9}, false, al, "eq r4 r7 LSL r9", "eq_r4_r7_LSL_r9"},
    {{lt, r14, r9, LSL, r13},
     false,
     al,
     "lt r14 r9 LSL r13",
     "lt_r14_r9_LSL_r13"},
    {{le, r8, r8, ASR, r0}, false, al, "le r8 r8 ASR r0", "le_r8_r8_ASR_r0"},
    {{vs, r14, r9, LSR, r3}, false, al, "vs r14 r9 LSR r3", "vs_r14_r9_LSR_r3"},
    {{al, r10, r6, ROR, r13},
     false,
     al,
     "al r10 r6 ROR r13",
     "al_r10_r6_ROR_r13"},
    {{vs, r5, r2, ROR, r7}, false, al, "vs r5 r2 ROR r7", "vs_r5_r2_ROR_r7"},
    {{vs, r14, r12, ROR, r14},
     false,
     al,
     "vs r14 r12 ROR r14",
     "vs_r14_r12_ROR_r14"},
    {{lt, r11, r2, ASR, r0}, false, al, "lt r11 r2 ASR r0", "lt_r11_r2_ASR_r0"},
    {{vc, r3, r2, LSL, r9}, false, al, "vc r3 r2 LSL r9", "vc_r3_r2_LSL_r9"},
    {{hi, r14, r4, LSL, r2}, false, al, "hi r14 r4 LSL r2", "hi_r14_r4_LSL_r2"},
    {{gt, r8, r9, ASR, r0}, false, al, "gt r8 r9 ASR r0", "gt_r8_r9_ASR_r0"},
    {{gt, r4, r4, LSL, r11}, false, al, "gt r4 r4 LSL r11", "gt_r4_r4_LSL_r11"},
    {{cc, r5, r14, LSL, r9}, false, al, "cc r5 r14 LSL r9", "cc_r5_r14_LSL_r9"},
    {{lt, r10, r10, ASR, r5},
     false,
     al,
     "lt r10 r10 ASR r5",
     "lt_r10_r10_ASR_r5"},
    {{eq, r1, r12, LSR, r7}, false, al, "eq r1 r12 LSR r7", "eq_r1_r12_LSR_r7"},
    {{eq, r11, r9, ROR, r7}, false, al, "eq r11 r9 ROR r7", "eq_r11_r9_ROR_r7"},
    {{gt, r5, r7, ASR, r6}, false, al, "gt r5 r7 ASR r6", "gt_r5_r7_ASR_r6"},
    {{cc, r7, r2, LSL, r13}, false, al, "cc r7 r2 LSL r13", "cc_r7_r2_LSL_r13"},
    {{cs, r12, r12, LSL, r4},
     false,
     al,
     "cs r12 r12 LSL r4",
     "cs_r12_r12_LSL_r4"},
    {{ls, r4, r4, ROR, r7}, false, al, "ls r4 r4 ROR r7", "ls_r4_r4_ROR_r7"},
    {{al, r13, r8, ASR, r10},
     false,
     al,
     "al r13 r8 ASR r10",
     "al_r13_r8_ASR_r10"},
    {{cs, r1, r0, ASR, r1}, false, al, "cs r1 r0 ASR r1", "cs_r1_r0_ASR_r1"},
    {{ne, r6, r7, LSL, r0}, false, al, "ne r6 r7 LSL r0", "ne_r6_r7_LSL_r0"},
    {{cc, r5, r13, LSR, r9}, false, al, "cc r5 r13 LSR r9", "cc_r5_r13_LSR_r9"},
    {{cc, r9, r6, LSL, r14}, false, al, "cc r9 r6 LSL r14", "cc_r9_r6_LSL_r14"},
    {{al, r12, r13, ASR, r2},
     false,
     al,
     "al r12 r13 ASR r2",
     "al_r12_r13_ASR_r2"},
    {{gt, r0, r6, LSR, r6}, false, al, "gt r0 r6 LSR r6", "gt_r0_r6_LSR_r6"},
    {{al, r6, r10, ROR, r10},
     false,
     al,
     "al r6 r10 ROR r10",
     "al_r6_r10_ROR_r10"},
    {{lt, r4, r13, LSL, r6}, false, al, "lt r4 r13 LSL r6", "lt_r4_r13_LSL_r6"},
    {{hi, r12, r0, LSL, r10},
     false,
     al,
     "hi r12 r0 LSL r10",
     "hi_r12_r0_LSL_r10"},
    {{ge, r5, r9, ROR, r11}, false, al, "ge r5 r9 ROR r11", "ge_r5_r9_ROR_r11"},
    {{ge, r4, r5, ASR, r10}, false, al, "ge r4 r5 ASR r10", "ge_r4_r5_ASR_r10"},
    {{al, r0, r5, LSL, r11}, false, al, "al r0 r5 LSL r11", "al_r0_r5_LSL_r11"},
    {{mi, r6, r3, LSR, r8}, false, al, "mi r6 r3 LSR r8", "mi_r6_r3_LSR_r8"},
    {{gt, r2, r6, LSR, r6}, false, al, "gt r2 r6 LSR r6", "gt_r2_r6_LSR_r6"},
    {{le, r7, r3, ROR, r10}, false, al, "le r7 r3 ROR r10", "le_r7_r3_ROR_r10"},
    {{vs, r8, r5, LSR, r13}, false, al, "vs r8 r5 LSR r13", "vs_r8_r5_LSR_r13"},
    {{al, r10, r7, ASR, r14},
     false,
     al,
     "al r10 r7 ASR r14",
     "al_r10_r7_ASR_r14"},
    {{lt, r10, r11, LSL, r5},
     false,
     al,
     "lt r10 r11 LSL r5",
     "lt_r10_r11_LSL_r5"},
    {{lt, r11, r3, LSR, r4}, false, al, "lt r11 r3 LSR r4", "lt_r11_r3_LSR_r4"},
    {{vc, r11, r10, LSR, r8},
     false,
     al,
     "vc r11 r10 LSR r8",
     "vc_r11_r10_LSR_r8"},
    {{cs, r11, r5, LSL, r9}, false, al, "cs r11 r5 LSL r9", "cs_r11_r5_LSL_r9"},
    {{cs, r6, r5, LSR, r7}, false, al, "cs r6 r5 LSR r7", "cs_r6_r5_LSR_r7"},
    {{lt, r7, r7, ASR, r1}, false, al, "lt r7 r7 ASR r1", "lt_r7_r7_ASR_r1"},
    {{cc, r7, r4, ROR, r7}, false, al, "cc r7 r4 ROR r7", "cc_r7_r4_ROR_r7"},
    {{ls, r8, r12, LSR, r9}, false, al, "ls r8 r12 LSR r9", "ls_r8_r12_LSR_r9"},
    {{le, r5, r13, ROR, r11},
     false,
     al,
     "le r5 r13 ROR r11",
     "le_r5_r13_ROR_r11"},
    {{eq, r4, r5, ROR, r12}, false, al, "eq r4 r5 ROR r12", "eq_r4_r5_ROR_r12"},
    {{ls, r0, r0, LSL, r1}, false, al, "ls r0 r0 LSL r1", "ls_r0_r0_LSL_r1"},
    {{ge, r7, r2, ROR, r9}, false, al, "ge r7 r2 ROR r9", "ge_r7_r2_ROR_r9"},
    {{cc, r5, r6, LSR, r12}, false, al, "cc r5 r6 LSR r12", "cc_r5_r6_LSR_r12"},
    {{cs, r7, r4, ASR, r10}, false, al, "cs r7 r4 ASR r10", "cs_r7_r4_ASR_r10"},
    {{al, r5, r4, ROR, r14}, false, al, "al r5 r4 ROR r14", "al_r5_r4_ROR_r14"},
    {{eq, r7, r3, ROR, r12}, false, al, "eq r7 r3 ROR r12", "eq_r7_r3_ROR_r12"},
    {{cc, r9, r4, LSL, r14}, false, al, "cc r9 r4 LSL r14", "cc_r9_r4_LSL_r14"},
    {{le, r5, r2, ASR, r13}, false, al, "le r5 r2 ASR r13", "le_r5_r2_ASR_r13"},
    {{eq, r14, r12, ROR, r4},
     false,
     al,
     "eq r14 r12 ROR r4",
     "eq_r14_r12_ROR_r4"},
    {{eq, r5, r2, ASR, r8}, false, al, "eq r5 r2 ASR r8", "eq_r5_r2_ASR_r8"},
    {{gt, r12, r5, LSR, r7}, false, al, "gt r12 r5 LSR r7", "gt_r12_r5_LSR_r7"},
    {{cc, r11, r14, ROR, r1},
     false,
     al,
     "cc r11 r14 ROR r1",
     "cc_r11_r14_ROR_r1"},
    {{ge, r0, r11, LSL, r9}, false, al, "ge r0 r11 LSL r9", "ge_r0_r11_LSL_r9"},
    {{ls, r4, r4, ROR, r0}, false, al, "ls r4 r4 ROR r0", "ls_r4_r4_ROR_r0"},
    {{cs, r7, r9, ROR, r10}, false, al, "cs r7 r9 ROR r10", "cs_r7_r9_ROR_r10"},
    {{le, r9, r4, LSR, r5}, false, al, "le r9 r4 LSR r5", "le_r9_r4_LSR_r5"},
    {{ls, r1, r4, LSL, r10}, false, al, "ls r1 r4 LSL r10", "ls_r1_r4_LSL_r10"},
    {{lt, r9, r13, LSL, r2}, false, al, "lt r9 r13 LSL r2", "lt_r9_r13_LSL_r2"},
    {{vs, r13, r6, ROR, r13},
     false,
     al,
     "vs r13 r6 ROR r13",
     "vs_r13_r6_ROR_r13"},
    {{cs, r4, r0, LSL, r9}, false, al, "cs r4 r0 LSL r9", "cs_r4_r0_LSL_r9"},
    {{le, r8, r13, LSR, r14},
     false,
     al,
     "le r8 r13 LSR r14",
     "le_r8_r13_LSR_r14"},
    {{al, r9, r7, LSL, r10}, false, al, "al r9 r7 LSL r10", "al_r9_r7_LSL_r10"},
    {{mi, r6, r8, LSL, r2}, false, al, "mi r6 r8 LSL r2", "mi_r6_r8_LSL_r2"},
    {{ne, r6, r5, ASR, r5}, false, al, "ne r6 r5 ASR r5", "ne_r6_r5_ASR_r5"},
    {{ls, r1, r8, LSR, r12}, false, al, "ls r1 r8 LSR r12", "ls_r1_r8_LSR_r12"},
    {{cs, r9, r7, LSL, r10}, false, al, "cs r9 r7 LSL r10", "cs_r9_r7_LSL_r10"},
    {{cc, r3, r0, ROR, r2}, false, al, "cc r3 r0 ROR r2", "cc_r3_r0_ROR_r2"},
    {{vc, r5, r6, ASR, r11}, false, al, "vc r5 r6 ASR r11", "vc_r5_r6_ASR_r11"},
    {{le, r11, r9, ROR, r10},
     false,
     al,
     "le r11 r9 ROR r10",
     "le_r11_r9_ROR_r10"},
    {{gt, r4, r10, ROR, r13},
     false,
     al,
     "gt r4 r10 ROR r13",
     "gt_r4_r10_ROR_r13"},
    {{lt, r13, r14, LSL, r11},
     false,
     al,
     "lt r13 r14 LSL r11",
     "lt_r13_r14_LSL_r11"},
    {{ls, r10, r8, LSL, r11},
     false,
     al,
     "ls r10 r8 LSL r11",
     "ls_r10_r8_LSL_r11"},
    {{gt, r7, r9, ROR, r12}, false, al, "gt r7 r9 ROR r12", "gt_r7_r9_ROR_r12"},
    {{le, r11, r8, LSR, r0}, false, al, "le r11 r8 LSR r0", "le_r11_r8_LSR_r0"},
    {{vs, r3, r1, LSR, r3}, false, al, "vs r3 r1 LSR r3", "vs_r3_r1_LSR_r3"},
    {{cs, r14, r13, ROR, r5},
     false,
     al,
     "cs r14 r13 ROR r5",
     "cs_r14_r13_ROR_r5"},
    {{pl, r1, r0, LSL, r6}, false, al, "pl r1 r0 LSL r6", "pl_r1_r0_LSL_r6"},
    {{hi, r13, r8, ROR, r12},
     false,
     al,
     "hi r13 r8 ROR r12",
     "hi_r13_r8_ROR_r12"},
    {{vc, r6, r7, LSR, r0}, false, al, "vc r6 r7 LSR r0", "vc_r6_r7_LSR_r0"},
    {{gt, r4, r10, LSL, r4}, false, al, "gt r4 r10 LSL r4", "gt_r4_r10_LSL_r4"},
    {{ge, r4, r12, LSR, r7}, false, al, "ge r4 r12 LSR r7", "ge_r4_r12_LSR_r7"},
    {{pl, r1, r8, LSR, r3}, false, al, "pl r1 r8 LSR r3", "pl_r1_r8_LSR_r3"},
    {{hi, r0, r0, ASR, r7}, false, al, "hi r0 r0 ASR r7", "hi_r0_r0_ASR_r7"},
    {{cs, r0, r7, ROR, r12}, false, al, "cs r0 r7 ROR r12", "cs_r0_r7_ROR_r12"},
    {{eq, r10, r9, LSR, r0}, false, al, "eq r10 r9 LSR r0", "eq_r10_r9_LSR_r0"},
    {{cc, r5, r10, ROR, r10},
     false,
     al,
     "cc r5 r10 ROR r10",
     "cc_r5_r10_ROR_r10"},
    {{cs, r0, r14, ROR, r8}, false, al, "cs r0 r14 ROR r8", "cs_r0_r14_ROR_r8"},
    {{eq, r14, r11, LSR, r5},
     false,
     al,
     "eq r14 r11 LSR r5",
     "eq_r14_r11_LSR_r5"},
    {{le, r14, r4, LSR, r12},
     false,
     al,
     "le r14 r4 LSR r12",
     "le_r14_r4_LSR_r12"},
    {{lt, r10, r8, LSL, r10},
     false,
     al,
     "lt r10 r8 LSL r10",
     "lt_r10_r8_LSL_r10"},
    {{le, r13, r4, LSR, r0}, false, al, "le r13 r4 LSR r0", "le_r13_r4_LSR_r0"},
    {{vc, r9, r9, LSL, r14}, false, al, "vc r9 r9 LSL r14", "vc_r9_r9_LSL_r14"},
    {{vs, r1, r2, LSR, r7}, false, al, "vs r1 r2 LSR r7", "vs_r1_r2_LSR_r7"},
    {{al, r14, r4, ROR, r4}, false, al, "al r14 r4 ROR r4", "al_r14_r4_ROR_r4"},
    {{vs, r10, r6, ROR, r10},
     false,
     al,
     "vs r10 r6 ROR r10",
     "vs_r10_r6_ROR_r10"},
    {{cc, r11, r13, LSL, r11},
     false,
     al,
     "cc r11 r13 LSL r11",
     "cc_r11_r13_LSL_r11"},
    {{lt, r4, r9, ROR, r2}, false, al, "lt r4 r9 ROR r2", "lt_r4_r9_ROR_r2"},
    {{gt, r4, r12, ASR, r8}, false, al, "gt r4 r12 ASR r8", "gt_r4_r12_ASR_r8"},
    {{hi, r3, r6, LSR, r14}, false, al, "hi r3 r6 LSR r14", "hi_r3_r6_LSR_r14"},
    {{vs, r11, r6, LSL, r5}, false, al, "vs r11 r6 LSL r5", "vs_r11_r6_LSL_r5"},
    {{ne, r14, r12, LSR, r9},
     false,
     al,
     "ne r14 r12 LSR r9",
     "ne_r14_r12_LSR_r9"},
    {{cc, r12, r5, ROR, r0}, false, al, "cc r12 r5 ROR r0", "cc_r12_r5_ROR_r0"},
    {{al, r11, r1, ASR, r14},
     false,
     al,
     "al r11 r1 ASR r14",
     "al_r11_r1_ASR_r14"},
    {{ge, r9, r1, LSR, r12}, false, al, "ge r9 r1 LSR r12", "ge_r9_r1_LSR_r12"},
    {{pl, r12, r1, LSR, r11},
     false,
     al,
     "pl r12 r1 LSR r11",
     "pl_r12_r1_LSR_r11"},
    {{pl, r0, r1, ROR, r4}, false, al, "pl r0 r1 ROR r4", "pl_r0_r1_ROR_r4"},
    {{mi, r10, r12, ROR, r10},
     false,
     al,
     "mi r10 r12 ROR r10",
     "mi_r10_r12_ROR_r10"},
    {{cs, r4, r5, ASR, r0}, false, al, "cs r4 r5 ASR r0", "cs_r4_r5_ASR_r0"},
    {{lt, r6, r3, ASR, r11}, false, al, "lt r6 r3 ASR r11", "lt_r6_r3_ASR_r11"},
    {{cs, r5, r13, ASR, r6}, false, al, "cs r5 r13 ASR r6", "cs_r5_r13_ASR_r6"},
    {{vs, r10, r3, LSR, r10},
     false,
     al,
     "vs r10 r3 LSR r10",
     "vs_r10_r3_LSR_r10"},
    {{vc, r5, r12, LSR, r8}, false, al, "vc r5 r12 LSR r8", "vc_r5_r12_LSR_r8"},
    {{al, r3, r10, ROR, r8}, false, al, "al r3 r10 ROR r8", "al_r3_r10_ROR_r8"},
    {{vc, r11, r4, ASR, r0}, false, al, "vc r11 r4 ASR r0", "vc_r11_r4_ASR_r0"},
    {{ge, r10, r1, LSL, r11},
     false,
     al,
     "ge r10 r1 LSL r11",
     "ge_r10_r1_LSL_r11"},
    {{eq, r1, r3, LSR, r8}, false, al, "eq r1 r3 LSR r8", "eq_r1_r3_LSR_r8"},
    {{vc, r14, r4, LSL, r9}, false, al, "vc r14 r4 LSL r9", "vc_r14_r4_LSL_r9"},
    {{gt, r2, r0, ROR, r3}, false, al, "gt r2 r0 ROR r3", "gt_r2_r0_ROR_r3"},
    {{mi, r10, r3, LSR, r4}, false, al, "mi r10 r3 LSR r4", "mi_r10_r3_LSR_r4"},
    {{vs, r7, r9, ROR, r13}, false, al, "vs r7 r9 ROR r13", "vs_r7_r9_ROR_r13"},
    {{eq, r4, r3, LSR, r1}, false, al, "eq r4 r3 LSR r1", "eq_r4_r3_LSR_r1"},
    {{mi, r7, r0, LSL, r0}, false, al, "mi r7 r0 LSL r0", "mi_r7_r0_LSL_r0"},
    {{ls, r11, r6, LSR, r11},
     false,
     al,
     "ls r11 r6 LSR r11",
     "ls_r11_r6_LSR_r11"},
    {{al, r8, r4, LSL, r12}, false, al, "al r8 r4 LSL r12", "al_r8_r4_LSL_r12"},
    {{pl, r7, r13, LSR, r8}, false, al, "pl r7 r13 LSR r8", "pl_r7_r13_LSR_r8"},
    {{eq, r4, r4, LSR, r13}, false, al, "eq r4 r4 LSR r13", "eq_r4_r4_LSR_r13"},
    {{eq, r3, r4, ROR, r6}, false, al, "eq r3 r4 ROR r6", "eq_r3_r4_ROR_r6"},
    {{ne, r8, r11, LSR, r14},
     false,
     al,
     "ne r8 r11 LSR r14",
     "ne_r8_r11_LSR_r14"},
    {{ge, r12, r7, LSL, r1}, false, al, "ge r12 r7 LSL r1", "ge_r12_r7_LSL_r1"},
    {{gt, r12, r7, LSL, r14},
     false,
     al,
     "gt r12 r7 LSL r14",
     "gt_r12_r7_LSL_r14"},
    {{ne, r14, r13, LSR, r2},
     false,
     al,
     "ne r14 r13 LSR r2",
     "ne_r14_r13_LSR_r2"},
    {{ne, r14, r2, LSR, r14},
     false,
     al,
     "ne r14 r2 LSR r14",
     "ne_r14_r2_LSR_r14"},
    {{vs, r14, r5, ROR, r1}, false, al, "vs r14 r5 ROR r1", "vs_r14_r5_ROR_r1"},
    {{ne, r2, r6, ROR, r4}, false, al, "ne r2 r6 ROR r4", "ne_r2_r6_ROR_r4"},
    {{lt, r4, r11, ROR, r13},
     false,
     al,
     "lt r4 r11 ROR r13",
     "lt_r4_r11_ROR_r13"},
    {{pl, r9, r3, ASR, r2}, false, al, "pl r9 r3 ASR r2", "pl_r9_r3_ASR_r2"},
    {{cs, r5, r5, LSR, r2}, false, al, "cs r5 r5 LSR r2", "cs_r5_r5_LSR_r2"},
    {{cc, r3, r1, ASR, r5}, false, al, "cc r3 r1 ASR r5", "cc_r3_r1_ASR_r5"},
    {{ne, r0, r10, LSL, r1}, false, al, "ne r0 r10 LSL r1", "ne_r0_r10_LSL_r1"},
    {{pl, r5, r9, LSR, r0}, false, al, "pl r5 r9 LSR r0", "pl_r5_r9_LSR_r0"},
    {{gt, r11, r7, LSL, r11},
     false,
     al,
     "gt r11 r7 LSL r11",
     "gt_r11_r7_LSL_r11"},
    {{al, r5, r13, LSR, r0}, false, al, "al r5 r13 LSR r0", "al_r5_r13_LSR_r0"},
    {{al, r0, r6, ROR, r9}, false, al, "al r0 r6 ROR r9", "al_r0_r6_ROR_r9"},
    {{cc, r1, r1, LSR, r11}, false, al, "cc r1 r1 LSR r11", "cc_r1_r1_LSR_r11"},
    {{cs, r5, r5, ASR, r3}, false, al, "cs r5 r5 ASR r3", "cs_r5_r5_ASR_r3"},
    {{lt, r4, r5, ASR, r3}, false, al, "lt r4 r5 ASR r3", "lt_r4_r5_ASR_r3"},
    {{mi, r2, r5, LSL, r5}, false, al, "mi r2 r5 LSL r5", "mi_r2_r5_LSL_r5"},
    {{al, r5, r3, ASR, r1}, false, al, "al r5 r3 ASR r1", "al_r5_r3_ASR_r1"},
    {{gt, r8, r2, LSR, r3}, false, al, "gt r8 r2 LSR r3", "gt_r8_r2_LSR_r3"},
    {{ne, r5, r0, ASR, r3}, false, al, "ne r5 r0 ASR r3", "ne_r5_r0_ASR_r3"},
    {{ge, r12, r14, LSR, r6},
     false,
     al,
     "ge r12 r14 LSR r6",
     "ge_r12_r14_LSR_r6"},
    {{al, r13, r7, ASR, r10},
     false,
     al,
     "al r13 r7 ASR r10",
     "al_r13_r7_ASR_r10"},
    {{vs, r5, r12, ASR, r3}, false, al, "vs r5 r12 ASR r3", "vs_r5_r12_ASR_r3"},
    {{vc, r10, r10, ROR, r8},
     false,
     al,
     "vc r10 r10 ROR r8",
     "vc_r10_r10_ROR_r8"},
    {{vc, r4, r4, ASR, r4}, false, al, "vc r4 r4 ASR r4", "vc_r4_r4_ASR_r4"},
    {{hi, r1, r1, LSR, r3}, false, al, "hi r1 r1 LSR r3", "hi_r1_r1_LSR_r3"},
    {{ge, r14, r8, LSR, r8}, false, al, "ge r14 r8 LSR r8", "ge_r14_r8_LSR_r8"},
    {{le, r5, r5, LSL, r1}, false, al, "le r5 r5 LSL r1", "le_r5_r5_LSL_r1"},
    {{vc, r2, r8, LSL, r8}, false, al, "vc r2 r8 LSL r8", "vc_r2_r8_LSL_r8"},
    {{hi, r0, r6, LSL, r5}, false, al, "hi r0 r6 LSL r5", "hi_r0_r6_LSL_r5"},
    {{le, r8, r7, LSR, r3}, false, al, "le r8 r7 LSR r3", "le_r8_r7_LSR_r3"},
    {{cc, r10, r4, LSR, r4}, false, al, "cc r10 r4 LSR r4", "cc_r10_r4_LSR_r4"},
    {{cc, r5, r9, LSL, r7}, false, al, "cc r5 r9 LSL r7", "cc_r5_r9_LSL_r7"},
    {{lt, r1, r14, ROR, r13},
     false,
     al,
     "lt r1 r14 ROR r13",
     "lt_r1_r14_ROR_r13"},
    {{mi, r9, r9, ROR, r10}, false, al, "mi r9 r9 ROR r10", "mi_r9_r9_ROR_r10"},
    {{cc, r0, r5, ROR, r7}, false, al, "cc r0 r5 ROR r7", "cc_r0_r5_ROR_r7"},
    {{vs, r6, r5, LSR, r10}, false, al, "vs r6 r5 LSR r10", "vs_r6_r5_LSR_r10"},
    {{pl, r14, r13, ASR, r4},
     false,
     al,
     "pl r14 r13 ASR r4",
     "pl_r14_r13_ASR_r4"},
    {{ne, r7, r9, LSL, r11}, false, al, "ne r7 r9 LSL r11", "ne_r7_r9_LSL_r11"},
    {{ne, r13, r3, ROR, r9}, false, al, "ne r13 r3 ROR r9", "ne_r13_r3_ROR_r9"},
    {{mi, r6, r13, ROR, r5}, false, al, "mi r6 r13 ROR r5", "mi_r6_r13_ROR_r5"},
    {{vc, r10, r0, ASR, r6}, false, al, "vc r10 r0 ASR r6", "vc_r10_r0_ASR_r6"},
    {{ge, r5, r4, LSR, r12}, false, al, "ge r5 r4 LSR r12", "ge_r5_r4_LSR_r12"},
    {{vc, r10, r3, LSR, r8}, false, al, "vc r10 r3 LSR r8", "vc_r10_r3_LSR_r8"},
    {{hi, r8, r1, LSR, r7}, false, al, "hi r8 r1 LSR r7", "hi_r8_r1_LSR_r7"},
    {{al, r3, r6, ASR, r11}, false, al, "al r3 r6 ASR r11", "al_r3_r6_ASR_r11"},
    {{cc, r1, r5, ASR, r0}, false, al, "cc r1 r5 ASR r0", "cc_r1_r5_ASR_r0"},
    {{mi, r11, r3, LSR, r8}, false, al, "mi r11 r3 LSR r8", "mi_r11_r3_LSR_r8"},
    {{gt, r4, r8, ASR, r12}, false, al, "gt r4 r8 ASR r12", "gt_r4_r8_ASR_r12"},
    {{hi, r0, r8, ROR, r10}, false, al, "hi r0 r8 ROR r10", "hi_r0_r8_ROR_r10"},
    {{gt, r14, r8, LSR, r9}, false, al, "gt r14 r8 LSR r9", "gt_r14_r8_LSR_r9"},
    {{pl, r14, r13, LSR, r9},
     false,
     al,
     "pl r14 r13 LSR r9",
     "pl_r14_r13_LSR_r9"},
    {{cs, r11, r0, LSR, r8}, false, al, "cs r11 r0 LSR r8", "cs_r11_r0_LSR_r8"},
    {{cs, r10, r3, LSR, r4}, false, al, "cs r10 r3 LSR r4", "cs_r10_r3_LSR_r4"},
    {{ge, r9, r0, ASR, r3}, false, al, "ge r9 r0 ASR r3", "ge_r9_r0_ASR_r3"},
    {{eq, r12, r14, LSL, r9},
     false,
     al,
     "eq r12 r14 LSL r9",
     "eq_r12_r14_LSL_r9"},
    {{eq, r2, r11, ASR, r8}, false, al, "eq r2 r11 ASR r8", "eq_r2_r11_ASR_r8"},
    {{le, r9, r12, ASR, r4}, false, al, "le r9 r12 ASR r4", "le_r9_r12_ASR_r4"},
    {{lt, r6, r12, LSL, r0}, false, al, "lt r6 r12 LSL r0", "lt_r6_r12_LSL_r0"},
    {{vc, r14, r4, ROR, r6}, false, al, "vc r14 r4 ROR r6", "vc_r14_r4_ROR_r6"},
    {{hi, r6, r1, LSL, r8}, false, al, "hi r6 r1 LSL r8", "hi_r6_r1_LSL_r8"},
    {{le, r10, r12, ROR, r14},
     false,
     al,
     "le r10 r12 ROR r14",
     "le_r10_r12_ROR_r14"},
    {{ls, r9, r1, ROR, r5}, false, al, "ls r9 r1 ROR r5", "ls_r9_r1_ROR_r5"},
    {{mi, r3, r5, LSL, r9}, false, al, "mi r3 r5 LSL r9", "mi_r3_r5_LSL_r9"},
    {{hi, r5, r4, LSR, r10}, false, al, "hi r5 r4 LSR r10", "hi_r5_r4_LSR_r10"},
    {{ge, r2, r5, LSR, r9}, false, al, "ge r2 r5 LSR r9", "ge_r2_r5_LSR_r9"},
    {{ge, r11, r14, LSL, r9},
     false,
     al,
     "ge r11 r14 LSL r9",
     "ge_r11_r14_LSL_r9"},
    {{vc, r7, r2, LSR, r6}, false, al, "vc r7 r2 LSR r6", "vc_r7_r2_LSR_r6"},
    {{ls, r12, r1, ASR, r6}, false, al, "ls r12 r1 ASR r6", "ls_r12_r1_ASR_r6"},
    {{cs, r3, r2, ROR, r4}, false, al, "cs r3 r2 ROR r4", "cs_r3_r2_ROR_r4"},
    {{lt, r13, r14, ROR, r7},
     false,
     al,
     "lt r13 r14 ROR r7",
     "lt_r13_r14_ROR_r7"},
    {{le, r13, r9, LSR, r2}, false, al, "le r13 r9 LSR r2", "le_r13_r9_LSR_r2"},
    {{ls, r0, r4, LSL, r8}, false, al, "ls r0 r4 LSL r8", "ls_r0_r4_LSL_r8"},
    {{pl, r14, r5, ROR, r5}, false, al, "pl r14 r5 ROR r5", "pl_r14_r5_ROR_r5"},
    {{le, r7, r8, ASR, r13}, false, al, "le r7 r8 ASR r13", "le_r7_r8_ASR_r13"},
    {{vc, r4, r5, ASR, r5}, false, al, "vc r4 r5 ASR r5", "vc_r4_r5_ASR_r5"},
    {{gt, r14, r2, ROR, r3}, false, al, "gt r14 r2 ROR r3", "gt_r14_r2_ROR_r3"},
    {{eq, r13, r12, LSL, r5},
     false,
     al,
     "eq r13 r12 LSL r5",
     "eq_r13_r12_LSL_r5"},
    {{pl, r5, r12, LSR, r2}, false, al, "pl r5 r12 LSR r2", "pl_r5_r12_LSR_r2"},
    {{cc, r4, r13, ROR, r14},
     false,
     al,
     "cc r4 r13 ROR r14",
     "cc_r4_r13_ROR_r14"},
    {{ne, r10, r9, LSL, r9}, false, al, "ne r10 r9 LSL r9", "ne_r10_r9_LSL_r9"},
    {{eq, r1, r1, ROR, r14}, false, al, "eq r1 r1 ROR r14", "eq_r1_r1_ROR_r14"},
    {{eq, r13, r0, LSL, r13},
     false,
     al,
     "eq r13 r0 LSL r13",
     "eq_r13_r0_LSL_r13"},
    {{vc, r0, r11, ASR, r3}, false, al, "vc r0 r11 ASR r3", "vc_r0_r11_ASR_r3"},
    {{vc, r1, r4, LSR, r3}, false, al, "vc r1 r4 LSR r3", "vc_r1_r4_LSR_r3"},
    {{cc, r8, r3, ASR, r12}, false, al, "cc r8 r3 ASR r12", "cc_r8_r3_ASR_r12"},
    {{vs, r3, r10, LSL, r4}, false, al, "vs r3 r10 LSL r4", "vs_r3_r10_LSL_r4"},
    {{gt, r10, r9, ASR, r10},
     false,
     al,
     "gt r10 r9 ASR r10",
     "gt_r10_r9_ASR_r10"},
    {{cc, r10, r2, LSL, r10},
     false,
     al,
     "cc r10 r2 LSL r10",
     "cc_r10_r2_LSL_r10"},
    {{cs, r0, r2, LSL, r1}, false, al, "cs r0 r2 LSL r1", "cs_r0_r2_LSL_r1"},
    {{hi, r14, r14, ASR, r13},
     false,
     al,
     "hi r14 r14 ASR r13",
     "hi_r14_r14_ASR_r13"},
    {{mi, r4, r3, LSL, r1}, false, al, "mi r4 r3 LSL r1", "mi_r4_r3_LSL_r1"},
    {{gt, r5, r14, ROR, r2}, false, al, "gt r5 r14 ROR r2", "gt_r5_r14_ROR_r2"},
    {{cc, r10, r13, ASR, r12},
     false,
     al,
     "cc r10 r13 ASR r12",
     "cc_r10_r13_ASR_r12"},
    {{cs, r2, r4, LSL, r12}, false, al, "cs r2 r4 LSL r12", "cs_r2_r4_LSL_r12"},
    {{vs, r4, r2, ROR, r11}, false, al, "vs r4 r2 ROR r11", "vs_r4_r2_ROR_r11"},
    {{cs, r1, r13, LSR, r7}, false, al, "cs r1 r13 LSR r7", "cs_r1_r13_LSR_r7"},
    {{al, r3, r6, ASR, r5}, false, al, "al r3 r6 ASR r5", "al_r3_r6_ASR_r5"},
    {{ge, r12, r4, LSL, r2}, false, al, "ge r12 r4 LSL r2", "ge_r12_r4_LSL_r2"},
    {{cc, r8, r13, ROR, r5}, false, al, "cc r8 r13 ROR r5", "cc_r8_r13_ROR_r5"},
    {{vc, r0, r10, LSL, r7}, false, al, "vc r0 r10 LSL r7", "vc_r0_r10_LSL_r7"},
    {{ge, r13, r0, LSL, r4}, false, al, "ge r13 r0 LSL r4", "ge_r13_r0_LSL_r4"},
    {{cc, r14, r12, LSL, r10},
     false,
     al,
     "cc r14 r12 LSL r10",
     "cc_r14_r12_LSL_r10"},
    {{mi, r9, r9, ASR, r9}, false, al, "mi r9 r9 ASR r9", "mi_r9_r9_ASR_r9"},
    {{al, r1, r13, ROR, r14},
     false,
     al,
     "al r1 r13 ROR r14",
     "al_r1_r13_ROR_r14"},
    {{ls, r5, r10, ROR, r1}, false, al, "ls r5 r10 ROR r1", "ls_r5_r10_ROR_r1"},
    {{mi, r7, r9, LSL, r7}, false, al, "mi r7 r9 LSL r7", "mi_r7_r9_LSL_r7"},
    {{ne, r11, r13, LSR, r5},
     false,
     al,
     "ne r11 r13 LSR r5",
     "ne_r11_r13_LSR_r5"},
    {{mi, r1, r6, ROR, r9}, false, al, "mi r1 r6 ROR r9", "mi_r1_r6_ROR_r9"},
    {{le, r1, r2, LSR, r2}, false, al, "le r1 r2 LSR r2", "le_r1_r2_LSR_r2"},
    {{vc, r12, r9, LSR, r6}, false, al, "vc r12 r9 LSR r6", "vc_r12_r9_LSR_r6"},
    {{cc, r11, r2, ROR, r9}, false, al, "cc r11 r2 ROR r9", "cc_r11_r2_ROR_r9"},
    {{mi, r6, r11, LSL, r10},
     false,
     al,
     "mi r6 r11 LSL r10",
     "mi_r6_r11_LSL_r10"},
    {{cc, r6, r1, ROR, r6}, false, al, "cc r6 r1 ROR r6", "cc_r6_r1_ROR_r6"},
    {{gt, r1, r13, LSL, r10},
     false,
     al,
     "gt r1 r13 LSL r10",
     "gt_r1_r13_LSL_r10"},
    {{eq, r10, r12, ROR, r11},
     false,
     al,
     "eq r10 r12 ROR r11",
     "eq_r10_r12_ROR_r11"},
    {{cs, r5, r7, LSL, r5}, false, al, "cs r5 r7 LSL r5", "cs_r5_r7_LSL_r5"},
    {{cs, r2, r14, ROR, r6}, false, al, "cs r2 r14 ROR r6", "cs_r2_r14_ROR_r6"},
    {{cc, r4, r6, ASR, r7}, false, al, "cc r4 r6 ASR r7", "cc_r4_r6_ASR_r7"},
    {{mi, r5, r3, ASR, r8}, false, al, "mi r5 r3 ASR r8", "mi_r5_r3_ASR_r8"},
    {{vs, r5, r0, LSR, r4}, false, al, "vs r5 r0 LSR r4", "vs_r5_r0_LSR_r4"},
    {{ge, r4, r7, ASR, r5}, false, al, "ge r4 r7 ASR r5", "ge_r4_r7_ASR_r5"},
    {{lt, r4, r9, ASR, r7}, false, al, "lt r4 r9 ASR r7", "lt_r4_r9_ASR_r7"},
    {{cs, r3, r13, ASR, r6}, false, al, "cs r3 r13 ASR r6", "cs_r3_r13_ASR_r6"},
    {{vs, r3, r7, LSR, r2}, false, al, "vs r3 r7 LSR r2", "vs_r3_r7_LSR_r2"},
    {{pl, r0, r3, ASR, r7}, false, al, "pl r0 r3 ASR r7", "pl_r0_r3_ASR_r7"},
    {{lt, r7, r10, LSL, r0}, false, al, "lt r7 r10 LSL r0", "lt_r7_r10_LSL_r0"},
    {{pl, r5, r1, LSR, r4}, false, al, "pl r5 r1 LSR r4", "pl_r5_r1_LSR_r4"},
    {{gt, r10, r7, LSL, r10},
     false,
     al,
     "gt r10 r7 LSL r10",
     "gt_r10_r7_LSL_r10"},
    {{ls, r14, r6, ROR, r0}, false, al, "ls r14 r6 ROR r0", "ls_r14_r6_ROR_r0"},
    {{le, r1, r5, ROR, r11}, false, al, "le r1 r5 ROR r11", "le_r1_r5_ROR_r11"},
    {{ls, r6, r14, LSL, r8}, false, al, "ls r6 r14 LSL r8", "ls_r6_r14_LSL_r8"},
    {{mi, r12, r11, LSL, r5},
     false,
     al,
     "mi r12 r11 LSL r5",
     "mi_r12_r11_LSL_r5"},
    {{le, r13, r5, ASR, r3}, false, al, "le r13 r5 ASR r3", "le_r13_r5_ASR_r3"},
    {{ls, r14, r10, ROR, r14},
     false,
     al,
     "ls r14 r10 ROR r14",
     "ls_r14_r10_ROR_r14"},
    {{eq, r5, r12, ASR, r5}, false, al, "eq r5 r12 ASR r5", "eq_r5_r12_ASR_r5"},
    {{gt, r14, r4, ASR, r14},
     false,
     al,
     "gt r14 r4 ASR r14",
     "gt_r14_r4_ASR_r14"},
    {{ls, r0, r5, ASR, r13}, false, al, "ls r0 r5 ASR r13", "ls_r0_r5_ASR_r13"},
    {{pl, r6, r4, LSR, r1}, false, al, "pl r6 r4 LSR r1", "pl_r6_r4_LSR_r1"},
    {{pl, r7, r11, ROR, r3}, false, al, "pl r7 r11 ROR r3", "pl_r7_r11_ROR_r3"},
    {{lt, r11, r9, ASR, r13},
     false,
     al,
     "lt r11 r9 ASR r13",
     "lt_r11_r9_ASR_r13"},
    {{cc, r3, r9, ASR, r4}, false, al, "cc r3 r9 ASR r4", "cc_r3_r9_ASR_r4"},
    {{eq, r2, r1, ASR, r7}, false, al, "eq r2 r1 ASR r7", "eq_r2_r1_ASR_r7"},
    {{le, r8, r10, ASR, r9}, false, al, "le r8 r10 ASR r9", "le_r8_r10_ASR_r9"},
    {{hi, r14, r2, LSL, r6}, false, al, "hi r14 r2 LSL r6", "hi_r14_r2_LSL_r6"},
    {{mi, r12, r4, LSR, r8}, false, al, "mi r12 r4 LSR r8", "mi_r12_r4_LSR_r8"},
    {{pl, r4, r1, ROR, r2}, false, al, "pl r4 r1 ROR r2", "pl_r4_r1_ROR_r2"},
    {{hi, r5, r9, ROR, r7}, false, al, "hi r5 r9 ROR r7", "hi_r5_r9_ROR_r7"},
    {{le, r4, r2, LSR, r1}, false, al, "le r4 r2 LSR r1", "le_r4_r2_LSR_r1"},
    {{al, r8, r1, ROR, r9}, false, al, "al r8 r1 ROR r9", "al_r8_r1_ROR_r9"},
    {{mi, r3, r6, ASR, r6}, false, al, "mi r3 r6 ASR r6", "mi_r3_r6_ASR_r6"},
    {{ls, r1, r12, LSR, r9}, false, al, "ls r1 r12 LSR r9", "ls_r1_r12_LSR_r9"},
    {{le, r13, r5, LSR, r13},
     false,
     al,
     "le r13 r5 LSR r13",
     "le_r13_r5_LSR_r13"},
    {{ne, r3, r12, ROR, r7}, false, al, "ne r3 r12 ROR r7", "ne_r3_r12_ROR_r7"},
    {{mi, r0, r9, LSR, r5}, false, al, "mi r0 r9 LSR r5", "mi_r0_r9_LSR_r5"},
    {{al, r4, r4, ROR, r3}, false, al, "al r4 r4 ROR r3", "al_r4_r4_ROR_r3"},
    {{cc, r1, r1, ASR, r3}, false, al, "cc r1 r1 ASR r3", "cc_r1_r1_ASR_r3"},
    {{lt, r12, r0, LSL, r10},
     false,
     al,
     "lt r12 r0 LSL r10",
     "lt_r12_r0_LSL_r10"},
    {{ge, r1, r10, LSL, r4}, false, al, "ge r1 r10 LSL r4", "ge_r1_r10_LSL_r4"},
    {{hi, r2, r7, LSL, r4}, false, al, "hi r2 r7 LSL r4", "hi_r2_r7_LSL_r4"},
    {{le, r1, r6, ASR, r13}, false, al, "le r1 r6 ASR r13", "le_r1_r6_ASR_r13"},
    {{eq, r0, r2, ROR, r8}, false, al, "eq r0 r2 ROR r8", "eq_r0_r2_ROR_r8"},
    {{vc, r6, r0, LSL, r8}, false, al, "vc r6 r0 LSL r8", "vc_r6_r0_LSL_r8"},
    {{hi, r11, r7, LSL, r5}, false, al, "hi r11 r7 LSL r5", "hi_r11_r7_LSL_r5"},
    {{ne, r0, r1, ASR, r2}, false, al, "ne r0 r1 ASR r2", "ne_r0_r1_ASR_r2"},
    {{gt, r7, r10, ROR, r8}, false, al, "gt r7 r10 ROR r8", "gt_r7_r10_ROR_r8"},
    {{vc, r5, r2, ASR, r8}, false, al, "vc r5 r2 ASR r8", "vc_r5_r2_ASR_r8"},
    {{ls, r4, r9, LSL, r14}, false, al, "ls r4 r9 LSL r14", "ls_r4_r9_LSL_r14"},
    {{vs, r4, r4, LSR, r5}, false, al, "vs r4 r4 LSR r5", "vs_r4_r4_LSR_r5"},
    {{hi, r4, r14, LSL, r13},
     false,
     al,
     "hi r4 r14 LSL r13",
     "hi_r4_r14_LSL_r13"},
    {{cc, r8, r11, ROR, r13},
     false,
     al,
     "cc r8 r11 ROR r13",
     "cc_r8_r11_ROR_r13"},
    {{ls, r2, r2, LSR, r14}, false, al, "ls r2 r2 LSR r14", "ls_r2_r2_LSR_r14"},
    {{lt, r1, r4, ROR, r12}, false, al, "lt r1 r4 ROR r12", "lt_r1_r4_ROR_r12"},
    {{mi, r2, r6, ROR, r14}, false, al, "mi r2 r6 ROR r14", "mi_r2_r6_ROR_r14"},
    {{hi, r7, r2, ASR, r9}, false, al, "hi r7 r2 ASR r9", "hi_r7_r2_ASR_r9"},
    {{le, r10, r14, ROR, r13},
     false,
     al,
     "le r10 r14 ROR r13",
     "le_r10_r14_ROR_r13"},
    {{vc, r7, r14, ASR, r11},
     false,
     al,
     "vc r7 r14 ASR r11",
     "vc_r7_r14_ASR_r11"},
    {{mi, r4, r5, ASR, r6}, false, al, "mi r4 r5 ASR r6", "mi_r4_r5_ASR_r6"},
    {{al, r11, r14, ROR, r9},
     false,
     al,
     "al r11 r14 ROR r9",
     "al_r11_r14_ROR_r9"},
    {{vc, r0, r10, ASR, r13},
     false,
     al,
     "vc r0 r10 ASR r13",
     "vc_r0_r10_ASR_r13"},
    {{al, r10, r2, ROR, r13},
     false,
     al,
     "al r10 r2 ROR r13",
     "al_r10_r2_ROR_r13"},
    {{hi, r9, r2, LSR, r9}, false, al, "hi r9 r2 LSR r9", "hi_r9_r2_LSR_r9"},
    {{gt, r2, r0, ASR, r10}, false, al, "gt r2 r0 ASR r10", "gt_r2_r0_ASR_r10"},
    {{hi, r4, r12, ASR, r13},
     false,
     al,
     "hi r4 r12 ASR r13",
     "hi_r4_r12_ASR_r13"},
    {{vc, r10, r14, ASR, r0},
     false,
     al,
     "vc r10 r14 ASR r0",
     "vc_r10_r14_ASR_r0"},
    {{ne, r13, r9, ASR, r4}, false, al, "ne r13 r9 ASR r4", "ne_r13_r9_ASR_r4"},
    {{eq, r5, r8, ROR, r5}, false, al, "eq r5 r8 ROR r5", "eq_r5_r8_ROR_r5"},
    {{lt, r0, r13, ROR, r3}, false, al, "lt r0 r13 ROR r3", "lt_r0_r13_ROR_r3"},
    {{hi, r0, r1, LSL, r1}, false, al, "hi r0 r1 LSL r1", "hi_r0_r1_LSL_r1"},
    {{pl, r13, r6, ASR, r10},
     false,
     al,
     "pl r13 r6 ASR r10",
     "pl_r13_r6_ASR_r10"},
    {{hi, r0, r4, LSR, r2}, false, al, "hi r0 r4 LSR r2", "hi_r0_r4_LSR_r2"},
    {{eq, r5, r3, ASR, r8}, false, al, "eq r5 r3 ASR r8", "eq_r5_r3_ASR_r8"},
    {{al, r1, r5, LSR, r4}, false, al, "al r1 r5 LSR r4", "al_r1_r5_LSR_r4"},
    {{eq, r8, r5, LSR, r14}, false, al, "eq r8 r5 LSR r14", "eq_r8_r5_LSR_r14"},
    {{ne, r12, r13, ROR, r0},
     false,
     al,
     "ne r12 r13 ROR r0",
     "ne_r12_r13_ROR_r0"},
    {{pl, r0, r2, ROR, r11}, false, al, "pl r0 r2 ROR r11", "pl_r0_r2_ROR_r11"},
    {{cs, r10, r6, ROR, r9}, false, al, "cs r10 r6 ROR r9", "cs_r10_r6_ROR_r9"},
    {{eq, r10, r4, ASR, r14},
     false,
     al,
     "eq r10 r4 ASR r14",
     "eq_r10_r4_ASR_r14"},
    {{ls, r9, r4, LSR, r14}, false, al, "ls r9 r4 LSR r14", "ls_r9_r4_LSR_r14"},
    {{cs, r14, r2, ROR, r5}, false, al, "cs r14 r2 ROR r5", "cs_r14_r2_ROR_r5"},
    {{vc, r9, r9, LSL, r7}, false, al, "vc r9 r9 LSL r7", "vc_r9_r9_LSL_r7"},
    {{mi, r7, r0, LSL, r4}, false, al, "mi r7 r0 LSL r4", "mi_r7_r0_LSL_r4"},
    {{cc, r2, r10, ASR, r7}, false, al, "cc r2 r10 ASR r7", "cc_r2_r10_ASR_r7"},
    {{cs, r5, r10, LSR, r9},
     false,
     al,
     "cs r5 r10 LSR r9",
     "cs_r5_r10_LSR_"
     "r9"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-operand-rn-shift-rs-cmn-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-shift-rs-cmp-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-shift-rs-mov-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-shift-rs-movs-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-shift-rs-mvn-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-shift-rs-mvns-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-shift-rs-teq-a32.h"
#include "aarch32/traces/assembler-cond-rd-operand-rn-shift-rs-tst-a32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseA32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    ShiftType shift = kTests[i].operands.shift;
    Register rs = kTests[i].operands.rs;
    Operand op(rn, shift, rs);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RD_OPERAND_RN_SHIFT_RS_" #mnemonic "_A32",    \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
