/*****************************************************************************
 * sound_plugin.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2008, Greg Hosler
 * (ghosler ['at'] users.sourceforge.net)
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *****************************************************************************/

#include <string.h>
#include <gtk/gtk.h>

#include "sound_plugin.h"

GYACHI_SOUND_PLUGIN *selected_sound_plugin = NULL;
GYACHI_SOUND_PLUGIN *next_selected_sound_plugin = NULL;
GList *sound_plugins = NULL;

void sync_sound_device()
{
	if (next_selected_sound_plugin) {
		selected_sound_plugin = next_selected_sound_plugin;
		next_selected_sound_plugin = NULL;
	}

}

int register_sound_device(GYACHI_SOUND_PLUGIN *plugin)
{
	GList *element;
	GYACHI_SOUND_PLUGIN *item;

	if (!plugin->description ||
	    !plugin->name        ||
	    !plugin->open        ||
	    !plugin->close) {
		/* must have a description, name, open & close callbacks */
		return(-1);
	}

	for (element=sound_plugins; element; element=element->next) {
		item = (GYACHI_SOUND_PLUGIN *)element->data;
		if (!strcmp(plugin->description, item->description)) {
			/* already registered... */
			return(-1);
		}
	}

	sound_plugins = g_list_append(sound_plugins, plugin);
	return(0);
}

int select_sound_device(const char *name)
{
	GList *element;
	GYACHI_SOUND_PLUGIN *item;

	for (element=sound_plugins; element; element=element->next) {
		item = (GYACHI_SOUND_PLUGIN *)element->data;
		if (!strcmp(item->name, name)) {
			/* found */
			next_selected_sound_plugin = item;
			return TRUE;
		}
		if (!strcmp(item->description, name)) {
			/* found */
			next_selected_sound_plugin = item;
			return TRUE;
		}
	}

	return FALSE;
}

const char *sound_device_description(const char *name)
{
	GList *element;
	GYACHI_SOUND_PLUGIN *item;

	for (element=sound_plugins; element; element=element->next) {
		item = (GYACHI_SOUND_PLUGIN *)element->data;
		if (!strcmp(item->name, name)) {
			/* found */
			return(item->description);
		}
	}
	return("");
}

const char *sound_device_name(const char *description)
{
	GList *element;
	GYACHI_SOUND_PLUGIN *item;

	for (element=sound_plugins; element; element=element->next) {
		item = (GYACHI_SOUND_PLUGIN *)element->data;
		if (!strcmp(item->description, description)) {
			/* found */
			return(item->name);
		}
	}
	return("");
}

GList *gyachi_sound_devices_available()
{
	GList *devices = NULL;
	GList *element;
	GYACHI_SOUND_PLUGIN *item;

	for (element=sound_plugins; element; element=element->next) {
		item = (GYACHI_SOUND_PLUGIN *)element->data;
		devices = g_list_prepend(devices, strdup(item->description));
	}

	devices = g_list_sort(devices,  (GCompareFunc) g_utf8_collate);
	return(devices);
}

