# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Spicebird code.
#
# The Initial Developer of the Original Code is
#   Ashok Gudibandla <ashok@synovel.com>
# Portions created by the Initial Developer are Copyright (C) 2007-2008
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#   Sivakrishna Edpuganti <sivakrishna@synovel.com> 
#
#
# Alternatively, the contents of this file may be used under the terms of
# either of the GNU General Public License Version 2 or later (the "GPL"),
# or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK ***** 

const kAbView_CardView = 1;   // View typese
const kAbView_ListView = 2;

var gAbViewType = 0;    // Stores the view type
var gAbNeedsRelayout = false;

var alphabets; // Initialized in abVCardOverlayInit()

var relayTimer = null;

var gCardViewAbListener = {
   onItemAdded : function (aParentDir, aItem) {
      if (relayTimer)
         clearTimeout(relayTimer);
      if (gAbViewType != kAbView_CardView)
         gAbNeedsRelayout = true;
      else 
         relayTimer = setTimeout(showAllCards, 100);

      if (aItem instanceof Components.interfaces.nsIAbDirectory)
         status = gVCardBundle.getString('collab.contacts.listAdded');
      else
         status = gVCardBundle.getString('collab.contacts.contactAdded');
      document.getElementById("statusText").setInterimStatus(status);
   },

   onItemRemoved: function (aParentDir, aItem) {
      if (relayTimer)
         clearTimeout(relayTimer);
      if (gAbViewType != kAbView_CardView)
         gAbNeedsRelayout = true;
      else 
         relayTimer = setTimeout(showAllCards, 100);
   },

   onItemPropertyChanged: function(aItem, aProp, oldValue, newValue) {
      if (relayTimer)
         clearTimeout(relayTimer);
      if (gAbViewType != kAbView_CardView)
         gAbNeedsRelayout = true;
      else 
         relayTimer = setTimeout(showAllCards, 100);
  },
};

var addrbookManager = Components.classes["@mozilla.org/abmanager;1"]
                                .getService(Components.interfaces.nsIAbManager);
addrbookManager.addAddressBookListener( gCardViewAbListener,
                                        Components.interfaces.nsIAbListener.all);


function createXULElement(el) {
   return document.createElementNS("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", el);
}
 
var gCardSelection = {
  selected : new Array(),
  inBatch : false,
  add : function (item) {
     item.selected = true;
     this.selected.push(item);
     if(!this.inBatch)
        CommandUpdate_AddressBook();
  },

  remove: function (item) {
    item.selected = false;
    this.selected.splice (this.selected.indexOf(item),1);
     if(!this.inBatch)
        CommandUpdate_AddressBook();
  },

  set : function (item) {
     this.clear();
     item.selected = true;
     this.selected.push(item);
     if(!this.inBatch)
        CommandUpdate_AddressBook();
  },

  clear : function () {
     while (this.selected.length > 0) {
        var card = this.selected.pop();
        card.selected = false;
     }
     if(!this.inBatch)
        CommandUpdate_AddressBook();
  },

  startBatch : function() {
    this.inBatch = true;
  },

  endBatch : function() {
    this.inBatch = false;
    CommandUpdate_AddressBook();
  }
};

function GetSelectedCardAddr() {
  var cardArr = new Array();
  for each (var card in gCardSelection.selected)
    cardArr.push(card.mCard);
  return GetAddressesForCards(cardArr);
}

var gVCardBundle = null;
window.addEventListener("load", abVCardOverlayInit, true);

function abVCardOverlayInit() {
   function createButton(ch) {
      var button = createXULElement("toolbarbutton");
      button.setAttribute('label', ch );
      button.setAttribute('id', 'vcardtoolbar-button-' + ch );
      button.setAttribute('oncommand', 'scroll(this.label)' );
      return button;
   }
   gVCardBundle = document.getElementById('bundle_addressBook_vcardview');
   alphabets = gVCardBundle.getString('collab.contacts.cardview.alphabets');
   var scrollBox = document.getElementById("CardScroll");
   gScrollBoxObj = scrollBox.boxObject.QueryInterface(Components.interfaces.nsIScrollBoxObject);

   var toolbar = document.getElementById('abcardview-toolbar');
   var otherButton = toolbar.firstChild;
   for (var i=0; i< alphabets.length ; i++) {
      ch = alphabets.charAt(i);
      button = createButton(ch);
      toolbar.insertBefore(button, otherButton);
   }

   if (document.getElementById("abviewmode-deck").selectedPanel.id == "abCardViewBox") 
      gAbViewType = kAbView_CardView;
   else if (document.getElementById("abviewmode-deck").selectedPanel.id == "abListViewBox") 
      gAbViewType = kAbView_ListView;
   else dump("Contacts view type not know !!! \n");

   // Don't call abViewChanged immediately because onLoadAddressbook would not
   // have been called yet and this will lead to code using un-initialized
   // dirTree
   setTimeout(abViewChanged, 0);
}

var cardViewCurDir = "";

/**
 * When view is changes, show all cards
 * update toolbar buttons and menus
 */
function abViewChanged() {
  if (gAbViewType == kAbView_CardView) {
     document.getElementById("menu_showCardView").setAttribute("checked", "true");
     var btn = document.getElementById("button-cardview");
     if (btn)
       btn.checked = true;
     if ( gAbNeedsRelayout || (cardViewCurDir != GetSelectedDirectory()) )
         showAllCards();
     
     document.getElementById("CardScroll").focus();
  }
  else {
     document.getElementById("menu_showListView").setAttribute("checked", "true");
     var btn = document.getElementById("button-listview");
     if (btn)
       btn.checked = true;
     ChangeDirectoryByURI(GetSelectedDirectory());
     gAbResultsTree.focus();
  }
  gAbSearchInput.setSearchCriteriaText();

  CommandUpdate_AddressBook();
}

function AbChangeView(viewType)
{
   if (gAbViewType == viewType )
      return;
   
   if ( viewType == kAbView_CardView ) 
      document.getElementById("abviewmode-deck").selectedPanel = document.getElementById("abCardViewBox");
   else if (viewType == kAbView_ListView )
      document.getElementById("abviewmode-deck").selectedPanel = document.getElementById("abListViewBox");
   else {
      dump("AbChangeView :: Contacts view type unknown !!\n");
      return;
   }

   gAbViewType = viewType;
   abViewChanged();
}

function scroll(ch) {
   var scrollBox = document.getElementById("CardScroll");
   var item  = document.getElementById("separator-"+ch);

   if (!item && ch.length > 1) 
      return;

   var stackScroll = scrollBox.boxObject.QueryInterface(Components.interfaces.nsIScrollBoxObject); 
   stackScroll.scrollToElement(item);
}

var gScrollBoxObj = null;
function vcardMouseScroll(event) {
   if ( !gScrollBoxObj) {
      var scrollBox = document.getElementById("CardScroll");
      gScrollBoxObj = scrollBox.boxObject.QueryInterface(Components.interfaces.nsIScrollBoxObject);
   }
   gScrollBoxObj.scrollBy(event.detail * 40, 0);
}

function scrollToItem(aItem) {
   gScrollBoxObj.ensureElementIsVisible(aItem);
}

function selectCardInNextColumn( aRight ) {
   selected = gCardSelection.selected[0];
   if (aRight)
      nextVbox = selected.parentNode.nextSibling;
   else
      nextVbox = selected.parentNode.previousSibling;
   if (!nextVbox || nextVbox.boxObject.width == 0) // if no more vboxes
      return;
   nextSelect = nextVbox.firstChild;
   if (nextSelect && nextSelect.tagName != "vcard") // seperator
      nextSelect = nextSelect.nextSibling;
   prevSelect = nextSelect;
   var diff = 0;
   while (nextSelect && nextSelect.getAttribute("collapsed") != "true" 
            && nextSelect.boxObject.y < selected.boxObject.y) {
      diff = Math.abs(nextSelect.boxObject.y - selected.boxObject.y);
      prevSelect = nextSelect;
      nextSelect = nextSelect.nextSibling;
      if (nextSelect && nextSelect.tagName != "vcard") // seperator
         nextSelect = nextSelect.nextSibling;
   }
   if(!nextSelect || nextSelect.getAttribute("collapsed") == "true") 
      gCardSelection.set(prevSelect);
   else {
      newDiff = Math.abs(nextSelect.boxObject.y - selected.boxObject.y);
      if ( diff < newDiff ) {
         prevSelect = nextSelect;
         nextSelect = nextSelect.previousSibling;
         if (nextSelect && nextSelect.tagName != "vcard") // seperator
            nextSelect = nextSelect.previousSibling;
      }
      if (nextSelect)
         gCardSelection.set(nextSelect);
      else
         gCardSelection.set(prevSelect);
   }
}


function vcardKeyHandler(event) {
//   event.preventDefault();
   var scrollBox = document.getElementById("CardScroll");
   if ( !gScrollBoxObj) 
      gScrollBoxObj = scrollBox.boxObject.QueryInterface(Components.interfaces.nsIScrollBoxObject);
   if ( event.keyCode == event.DOM_VK_PAGE_DOWN ) 
      gScrollBoxObj.scrollBy( scrollBox.boxObject.width, 0);
   else if ( event.keyCode == event.DOM_VK_PAGE_UP) 
      gScrollBoxObj.scrollBy( -scrollBox.boxObject.width, 0);
   else if ( event.keyCode == event.DOM_VK_RETURN) {
      if (gCardSelection.selected.length == 1)
         AbCardDefaultAction();
   }
   else if (event.keyCode == event.DOM_VK_RIGHT) {
      if (gCardSelection.selected.length == 1) {
         selectCardInNextColumn(true);
         scrollToItem(gCardSelection.selected[0]);
      }
   }
   else if (event.keyCode == event.DOM_VK_LEFT) {
      if (gCardSelection.selected.length == 1) {
         selectCardInNextColumn(false);
         scrollToItem(gCardSelection.selected[0]);
      }
   }
   else if (event.keyCode == event.DOM_VK_UP) {
      if (gCardSelection.selected.length == 1) {
         selected = gCardSelection.selected[0];
         topCard = selected.previousSibling;
         if (topCard && topCard.tagName != "vcard") // seperator
            topCard = topCard.previousSibling;
         if (topCard && topCard.getAttribute("collapsed") != "true")
            gCardSelection.set(topCard);
      }
      scrollToItem(gCardSelection.selected[0]);
   }
   else if (event.keyCode == event.DOM_VK_DOWN) {
      if (gCardSelection.selected.length == 1) {
         selected = gCardSelection.selected[0];
         bottomCard = selected.nextSibling;
         if (bottomCard && bottomCard.tagName != "vcard") // seperator
           bottomCard = bottomCard.nextSibling;
         if (bottomCard && bottomCard.getAttribute("collapsed") != "true")
            gCardSelection.set(bottomCard);
      }
      scrollToItem(gCardSelection.selected[0]);
   }
   else if ( !(event.altKey || event.ctrlKey || event.shiftKey) 
             && (event.charCode > 96 && event.charCode < 123)) { // any alphabet without accel keys
      // send the input to search bar
      var searchBar = document.getElementById("abSearchInput");
      searchBar.focus();
      searchBar.value =  String.fromCharCode(event.charCode);
      onAbSearchInput(false);
   }
}

function doVCardSearch(searchStr) {
   if ( searchStr == "" ) {
      showAllCards();
      return;
   }

   var exprArr = Components.classes["@mozilla.org/array;1"]
                           .createInstance(Components.interfaces.nsIMutableArray);

   var dnQs = Components.classes["@mozilla.org/boolean-expression/condition-string;1"]
                        .createInstance(Components.interfaces.nsIAbBooleanConditionString);
   var fnQs = Components.classes["@mozilla.org/boolean-expression/condition-string;1"]
                        .createInstance(Components.interfaces.nsIAbBooleanConditionString);
   var lnQs = Components.classes["@mozilla.org/boolean-expression/condition-string;1"]
                        .createInstance(Components.interfaces.nsIAbBooleanConditionString);
   var emailQs = Components.classes["@mozilla.org/boolean-expression/condition-string;1"]
                        .createInstance(Components.interfaces.nsIAbBooleanConditionString);

   dnQs.name = "DisplayName";
   dnQs.value = searchStr;
   dnQs.condition = Components.interfaces.nsIAbBooleanConditionTypes.Contains;

   fnQs.name = "FirstName";
   fnQs.value = searchStr;
   fnQs.condition = Components.interfaces.nsIAbBooleanConditionTypes.Contains;

   lnQs.name = "LastName";
   lnQs.value = searchStr;
   lnQs.condition = Components.interfaces.nsIAbBooleanConditionTypes.Contains;

   emailQs.name = "PrimaryEmail";
   emailQs.value = searchStr;
   emailQs.condition = Components.interfaces.nsIAbBooleanConditionTypes.Contains;

   exprArr.appendElement(dnQs,false);
   exprArr.appendElement(fnQs,false);
   exprArr.appendElement(lnQs,false);
   exprArr.appendElement(emailQs,false);
   
   var qe = Components.classes["@mozilla.org/boolean-expression/n-peer;1"]
                      .createInstance(Components.interfaces.nsIAbBooleanExpression);
   var queryArgs = Components.classes["@mozilla.org/addressbook/directory/query-arguments;1"]
                             .createInstance(Components.interfaces.nsIAbDirectoryQueryArguments);
   var dirQProxy = Components.classes["@mozilla.org/addressbook/directory-query/proxy;1"]
                             .createInstance(Components.interfaces.nsIAbDirectoryQueryProxy);

   qe.expressions = exprArr;
   qe.operation = 1;//Components.interfaces.nsIAbBooleanOperationTypes.OR;

   queryArgs.querySubDirectories = true;
   queryArgs.expression = qe;
 
   var directory = rdf.GetResource(GetSelectedDirectory()).QueryInterface(Components.interfaces.nsIAbDirectory); 
   dirQProxy.initiate(directory);
 
   dirSearchListener.clear();

   var  dirQuery = dirQProxy.QueryInterface(Components.interfaces.nsIAbDirectoryQuery);
   dirQuery.doQuery( directory, queryArgs, dirSearchListener, 10000, 100); //xxx: max cards hard coded.
 
   var resultCards = dirSearchListener.items;
   layoutCards(resultCards);
 
   delete resultCards;
}

var dirSearchListener = {
     items : new Array(),
     onSearchFinished: function ( aResult,  aErrorMsg) {},
     onSearchFoundCard: function (aCard) {
      this.items.push(aCard);
     },
     clear: function () { this.items.length = 0; this.items = new Array(); }
};
 
function showAllCards()
{
   var dirUrl = GetSelectedDirectory();
   if (!dirUrl)
       dirUrl = dirTree.builderView.getResourceAtIndex(0).Value;
 
   var directory = rdf.GetResource(dirUrl).QueryInterface(Components.interfaces.nsIAbDirectory); 
   var cards = directory.childCards;
   var cardArr = new Array();
   while (cards.hasMoreElements())
     cardArr.push(cards.getNext().QueryInterface(Components.interfaces.nsIAbCard));

   layoutCards(cardArr);
   cardViewCurDir = GetSelectedDirectory();
   gAbNeedsRelayout = false;
}

function selectAllCards() {
   var mainBox = document.getElementById("abcardview-mainbox");
   var vCards = mainBox.getElementsByTagName("vcard");
   for each (card in vCards) {
    if ( card.getAttribute("collapsed") == "true")
      continue;
    gCardSelection.add(card);
   }
}

function clearView() {
   gCardSelection.clear();
   // disable all tollbar buttons
   var vcardToolbar = document.getElementById("abcardview-toolbar");
   for (var i=0; i< vcardToolbar.childNodes.length; i++ )
      vcardToolbar.childNodes[i].setAttribute("disabled","true");

   // Remove seprators and collapse all cards.
   var mainBox = document.getElementById("abcardview-mainbox");
   var vertBox = mainBox.firstChild;
   while (vertBox) {
      var item = vertBox.firstChild;
      while (item) {
         var nextItem = item.nextSibling;
         if (item.tagName == 'vcard')
            item.setAttribute("collapsed","true");
         else 
            vertBox.removeChild(item);
         item = nextItem;
      }
      vertBox = vertBox.nextSibling;
   }
}

var layoutQueue = new Array();

function layoutCards(aCards)
{
  var infoBar = document.getElementById("abcardview-messagebox");
  clearView();
  if (aCards.length > 100)
    infoBar.removeAttribute("collapsed");
  layoutQueue.push( function()
                    { 
                      displayCards(aCards);
                      infoBar.setAttribute("collapsed","true");
                    });
  setTimeout(processLayoutQueue, 0);
}

function processLayoutQueue() 
{
  // process only the last call.
  var layoutCall = layoutQueue.pop();
  layoutQueue = new Array();
  if (layoutCall)
    layoutCall();
}

function displayCards(cards)
{
   // Get alphabets from locale data
   var alphabets = document.getElementById('bundle_addressBook_vcardview').getString('collab.contacts.cardview.alphabets');
   var first = alphabets.toUpperCase().charCodeAt(0);
   var last = alphabets.toUpperCase().charCodeAt(alphabets.length -1);

   //Sort the cards on display name first.
   cards.sort( function(item1, item2) {
      var char1 = item1.displayName.toUpperCase().charCodeAt(0);
      var char2 = item2.displayName.toUpperCase().charCodeAt(0);

   // Make sure misc chars are all at the end - after sort.
      if ( !char1 || char1 < first || char1 > last )
         return 1;   
      if ( !char2 || char2 < first || char2 > last )
         return -1;   

      if ( item1.displayName.toUpperCase() > item2.displayName.toUpperCase() )
        return 1;
      else
         return -1;
    });

   var mainBox = document.getElementById("abcardview-mainbox");
   var scrollBox = document.getElementById("CardScroll");

   var height=0;
   var maxHeight = scrollBox.boxObject.height-10;
   var prevChar = "";
   var curChar = ".";
   var vertBox = mainBox.firstChild;
   if (!vertBox) { 
      vertBox = createXULElement('vbox');
      mainBox.appendChild(vertBox);
   }
   var vCard;
   var cardMargin = -1; // margin not known
   var nextCard = vertBox.firstChild;
   for each (abCard in cards) {
      abCard  = abCard.QueryInterface(Components.interfaces.nsIAbCard);
      curChar = (abCard.displayName)? abCard.displayName.toUpperCase().charAt(0):
                       abCard.firstName.toUpperCase().charAt(0);
      if ( curChar == "" || alphabets.indexOf(curChar) < 0) 
           curChar = "Other";
      if (curChar != prevChar && prevChar != "Other") { // Add a separator
         var separator = createXULElement("box");
         separator.setAttribute("id","separator-"+curChar);
         if (nextCard)
            vertBox.insertBefore(separator,nextCard);
         else 
            vertBox.appendChild(separator);
         // enable separator for that char
         document.getElementById("vcardtoolbar-button-" + curChar).removeAttribute("disabled");
      }

      if (nextCard == null) {
          vCard = createXULElement("vcard");
          vertBox.appendChild(vCard);
      } else {
          vCard = nextCard;
          vCard.removeAttribute("collapsed");
          nextCard = nextCard.nextSibling;
      }
      vCard.card = abCard;

      if (cardMargin < 0) { // Get cards margin heights
        var cardStyle = window.getComputedStyle(vCard,"");
        var topMargin = cardStyle.getPropertyValue("margin-top");
        var bottomMargin = cardStyle.getPropertyValue("margin-bottom");
        topMargin = parseInt(topMargin);
        bottomMargin = parseInt(bottomMargin);
        if (isNaN(topMargin))
          topMargin = 0;
        if (isNaN(bottomMargin))
          bottomMargin = 0;
        cardMargin = topMargin + bottomMargin;
      }

      height += vCard.boxObject.height + cardMargin;

      if (height > maxHeight) { // Start new row
         height = 0;
         vCard.setAttribute("collapsed", "true"); // last card removed.
         var newBox = vertBox.nextSibling;
         if (!newBox) {
            newBox = createXULElement('vbox');
            mainBox.appendChild(newBox);
         }
         vCard = newBox.firstChild;
         if (!vCard) {
            vCard = createXULElement('vcard');
            newBox.appendChild(vCard);
         }
         vCard.removeAttribute("collapsed");
         vCard.card = abCard;
         height += vCard.boxObject.height;

         // If there is a separator at the bottom of the box, move it to new box.
         var item = vertBox.lastChild;
         while (item && item.tagName == 'vcard' && item.getAttribute("collapsed") == "true")
            item = item.previousSibling;
         if (item.getAttribute("id").indexOf("separator") == 0) { // if the last uncollapsed element is a separator
            vertBox.removeChild(item);
            newBox.insertBefore(item,vCard);
         }
         vertBox = newBox;
         nextCard = vCard.nextSibling;
      }
      prevChar = curChar;
   }
  gObserverService.notifyObservers(null, "AbViewInitDone", null);
}

function composeToSelected()
{
  AbNewMessage();
}

function clearStack()
{
   var stack = document.getElementById("CardsStack");
   var child = stack.firstChild;
   var oldChild;
   
   while (child) {
      oldChild = child;
      child = child.nextSibling;

      if (oldChild.tagName == 'vcard')
      {
        // Re-Position it at the top, to avoid blank white spaces beneath the cards.
        oldChild.setAttribute("top", 0);
        oldChild.setAttribute("left", 0);
        oldChild.setAttribute("collapsed", "true");
      }
      else
      {
        oldChild = stack.removeChild(oldChild);
        delete oldChild;
      }
   }
}

function copyEmailAddresses() 
{
  var listStr = null;
  for each (var item in gCardSelection.selected)
  {
    if (!listStr)
      listStr = item.card.primaryEmail;
    else
      listStr += ", " + item.card.primaryEmail;
  }
  var gClipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"]
                           .getService(Components.interfaces.nsIClipboardHelper); 
  gClipboardHelper.copyString(listStr);
}

var selectionDragInProgress = false;
var dragCausedClick = false;

var dragStartLoc = null;
var dragEndLoc = null;

function cardsPaneClick(aEvent)
{
  // If the click event is raised as a result of a drag that ended,
  // don't clear selection.
  if (dragCausedClick) {
    dragCausedClick = false;
    return;
  }
  gCardSelection.clear();
  aEvent.currentTarget.focus();
}

function cardsPaneMouseUp(aEvent) 
{
  var target = aEvent.target;
  if (!selectionDragInProgress)
    return;
  if (target.tagName == "vcard")
    dragEndLoc = { target: aEvent.target.parentNode, clientX: aEvent.clientX, clientY: aEvent.clientY };
  else
    dragEndLoc = aEvent;

  selectionDragInProgress = false;

  selectCardsInRegion(dragStartLoc, dragEndLoc);
  if (aEvent.target == dragStartLoc.target ) // A click event is fired in this case
    dragCausedClick = true;                  // in which case we shouldn't be clearing selection
}

function cardsPaneMouseDown(aEvent) 
{
  if(aEvent.target.tagName != "vcard") {
    selectionDragInProgress = true;
    dragStartLoc = aEvent;
  }
}

var dragUpdateQueue = new Array();

function cardsPaneMouseMove(aEvent) 
{
  if (!selectionDragInProgress)
    return;

  var scrollPane = document.getElementById("CardScroll");
  // If mouse moved close to the splitter, scroll
  if (aEvent.screenX - scrollPane.boxObject.screenX < 20 ) 
  {
    var marginDist = aEvent.screenX - scrollPane.boxObject.screenX;
    gScrollBoxObj.scrollBy(marginDist-40, 0); // Scroll more if mouse is close to the endge
  }
  else if (scrollPane.boxObject.screenX + scrollPane.boxObject.width -  aEvent.screenX < 20)
  {
    var marginDist = scrollPane.boxObject.screenX + scrollPane.boxObject.width - aEvent.screenX;
    gScrollBoxObj.scrollBy(40-marginDist, 0);
  }

  dragUpdateQueue.push(aEvent);
  setTimeout(processDragUpdateQueue, 0);
}

function processDragUpdateQueue()
{
  var event = dragUpdateQueue.pop();
  if (!event) // It is possible that the processDragUpdateQueue is called in
    return;   // bursts. So, dragUpdateQueue will be empty for subsequent calls
  dragUpdateQueue = new Array();
  // Process only the most recent event.
  updateDragSelection(event);
}

function updateDragSelection(aEvent)
{
  var dragEndLoc;
  if (aEvent.target.tagName == "vcard") 
    dragEndLoc = { target: aEvent.target.parentNode, clientX: aEvent.clientX, clientY: aEvent.clientY };
  else
    dragEndLoc = aEvent;

  selectCardsInRegion(dragStartLoc, dragEndLoc );
}

function selectCardsInRegion (aStartEvent, aEndEvent)
{
  var startEvent = aStartEvent.clientX < aEndEvent.clientX ? aStartEvent : aEndEvent;
  var endEvent = aStartEvent.clientX < aEndEvent.clientX ? aEndEvent : aStartEvent;

  var minY = aStartEvent.clientY < aEndEvent.clientY ? aStartEvent.clientY : aEndEvent.clientY;
  var maxY = aStartEvent.clientY > aEndEvent.clientY ? aStartEvent.clientY : aEndEvent.clientY;

  var cardsVbox = startEvent.target;
  gCardSelection.startBatch();
  gCardSelection.clear();
  while(cardsVbox && cardsVbox != endEvent.target.nextSibling) 
  {
    var vcard = cardsVbox.firstChild;
    if (vcard && vcard.tagName != "vcard")
      vcard = vcard.nextSibling;
    while(vcard) 
    {
      if (vcard.boxObject.y + vcard.boxObject.height > minY && vcard.boxObject.y < maxY)
        gCardSelection.add(vcard);
      vcard = getCardSibling(vcard);
    }
    cardsVbox = cardsVbox.nextSibling;
  }
  gCardSelection.endBatch();
}

function getCardSibling(aCard) 
{
  var item = aCard.nextSibling;
  while (item && (item.tagName != "vcard" || item.getAttribute("collapsed") == "true"))
    item = item.nextSibling;
  return item;
}
