#!/usr/bin/env python

try:
	import os
	import commands
	import sys
	import string
	import pygtk
	pygtk.require("2.0")
except Exception, detail:
	print detail
	pass
try:
	import gtk
	import gtk.glade
	import gettext
except Exception, detail:
	print detail
	sys.exit(1)
from subprocess import Popen, PIPE

# i18n
gettext.install("messages", "/usr/lib/linuxmint/xfcemintDesktop/locale") 
class MintDesktop:
	"""MintDesktop"""

	def __init__(self):
		# vars
		self.gladefile = '/usr/lib/linuxmint/xfcemintDesktop/mplayer/mplayer.glade'

		self.appName = "XFCE 4 mintDesktop"
		self.appVersion = "1.2"
		
		gtk.glade.bindtextdomain(APPDOMAIN, LANGDIR)
		gtk.glade.textdomain(APPDOMAIN)

		# setup glade widget tree
		self.wTree = gtk.glade.XML(self.gladefile, domain='mintDesktop') 
		
		# create signal dictionary and connect
		self.wTree.get_widget("main_window").connect("destroy", gtk.main_quit)
		self.wTree.get_widget("button1").connect("clicked", gtk.main_quit)
		self.wTree.get_widget("button2").connect("clicked", self.install_mplayer, "mplayer")
		
		# i18n
		self.wTree.get_widget("mplayer_label1").set_text(_("<big><b>Install Mplayer for thumbnails?</b></big>"))
		self.wTree.get_widget("mplayer_label1").set_use_markup(True)

	def install_mplayer(self, widget, application):				
		if (application == "mplayer"):
			os.system("mintInstall /usr/lib/linuxmint/xfcemintDesktop/mplayer/mplayer.mint ")			
			gtk.main_quit()
		        sys.exit(0)

	def exitApp(self):
		gtk.main_quit()
		sys.exit(0)			

# ---------- MAIN ----------

if __name__ == "__main__":
	APPDOMAIN='mintDesktop'
	LANGDIR='lang'
	# locale
	gtk.glade.bindtextdomain(APPDOMAIN, LANGDIR)
	gtk.glade.textdomain(APPDOMAIN)
	rec = MintDesktop()
	# run gui
	gtk.main()

