# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
# Frame class definitions, used to generate FrameIdList.h and FrameTypeList.h

from FrameClass import Frame, AbstractFrame, LEAF, NOT_LEAF, DYNAMIC_LEAF

FRAME_CLASSES = [
    Frame("BRFrame", "Br", LEAF),
    Frame("DetailsFrame", "Details", NOT_LEAF),
    Frame("nsBCTableCellFrame", "TableCell", NOT_LEAF),
    Frame("nsBackdropFrame", "Backdrop", LEAF),
    Frame("nsBlockFrame", "Block", NOT_LEAF),
    Frame("nsBox", "None", NOT_LEAF),
    Frame("nsBoxFrame", "Box", NOT_LEAF),
    Frame("nsBulletFrame", "Bullet", LEAF),
    Frame("nsButtonBoxFrame", "Box", NOT_LEAF),
    Frame("nsCanvasFrame", "Canvas", NOT_LEAF),
    Frame("nsCheckboxRadioFrame", "CheckboxRadio", LEAF),
    Frame("nsColorControlFrame", "ColorControl", LEAF),
    Frame("nsColumnSetFrame", "ColumnSet", NOT_LEAF),
    Frame("ColumnSetWrapperFrame", "ColumnSetWrapper", NOT_LEAF),
    Frame("nsComboboxControlFrame", "ComboboxControl", NOT_LEAF),
    Frame("nsComboboxDisplayFrame", "ComboboxDisplay", NOT_LEAF),
    Frame("nsContinuingTextFrame", "Text", LEAF),
    Frame("nsDateTimeControlFrame", "DateTimeControl", NOT_LEAF),
    Frame("nsDeckFrame", "Deck", NOT_LEAF),
    Frame("nsDocElementBoxFrame", "DocElementBox", NOT_LEAF),
    Frame("nsFieldSetFrame", "FieldSet", NOT_LEAF),
    Frame("nsFileControlFrame", "Block", LEAF),
    Frame("nsFirstLetterFrame", "Letter", NOT_LEAF),
    Frame("nsFirstLineFrame", "Line", NOT_LEAF),
    Frame("nsFlexContainerFrame", "FlexContainer", NOT_LEAF),
    Frame("nsIFrame", "None", NOT_LEAF),
    Frame("nsGfxButtonControlFrame", "GfxButtonControl", LEAF),
    Frame("nsGridContainerFrame", "GridContainer", NOT_LEAF),
    Frame("nsHTMLButtonControlFrame", "HTMLButtonControl", NOT_LEAF),
    Frame("nsHTMLCanvasFrame", "HTMLCanvas", NOT_LEAF),
    Frame("nsHTMLFramesetBlankFrame", "None", LEAF),
    Frame("nsHTMLFramesetBorderFrame", "None", LEAF),
    Frame("nsHTMLFramesetFrame", "FrameSet", LEAF),
    Frame("nsHTMLScrollFrame", "Scroll", NOT_LEAF),
    Frame("nsImageBoxFrame", "ImageBox", LEAF),
    Frame("nsImageControlFrame", "ImageControl", LEAF),
    Frame("nsImageFrame", "Image", LEAF),
    Frame("nsInlineFrame", "Inline", NOT_LEAF),
    Frame("nsLeafBoxFrame", "LeafBox", LEAF),
    Frame("nsListControlFrame", "ListControl", NOT_LEAF),
    Frame("nsMathMLFrame", "None", NOT_LEAF),
    Frame("nsMathMLmactionFrame", "None", NOT_LEAF),
    Frame("nsMathMLmathBlockFrame", "Block", NOT_LEAF),
    Frame("nsMathMLmathInlineFrame", "Inline", NOT_LEAF),
    Frame("nsMathMLmencloseFrame", "None", NOT_LEAF),
    Frame("nsMathMLmfracFrame", "None", NOT_LEAF),
    Frame("nsMathMLmmultiscriptsFrame", "None", NOT_LEAF),
    Frame("nsMathMLmoFrame", "None", NOT_LEAF),
    Frame("nsMathMLmpaddedFrame", "None", NOT_LEAF),
    Frame("nsMathMLmrootFrame", "None", NOT_LEAF),
    Frame("nsMathMLmrowFrame", "None", NOT_LEAF),
    Frame("nsMathMLmspaceFrame", "None", LEAF),
    Frame("nsMathMLmsqrtFrame", "None", NOT_LEAF),
    Frame("nsMathMLmtableFrame", "Table", NOT_LEAF),
    Frame("nsMathMLmtableWrapperFrame", "TableWrapper", NOT_LEAF),
    Frame("nsMathMLmtdFrame", "TableCell", NOT_LEAF),
    Frame("nsMathMLmtdInnerFrame", "Block", NOT_LEAF),
    Frame("nsMathMLmtrFrame", "TableRow", NOT_LEAF),
    Frame("nsMathMLmunderoverFrame", "None", NOT_LEAF),
    Frame("nsMathMLsemanticsFrame", "None", NOT_LEAF),
    Frame("nsMathMLTokenFrame", "None", NOT_LEAF),
    Frame("nsMenuBarFrame", "Box", NOT_LEAF),
    Frame("nsMenuFrame", "Menu", NOT_LEAF),
    Frame("nsMenuPopupFrame", "MenuPopup", DYNAMIC_LEAF),
    Frame("nsMeterFrame", "Meter", LEAF),
    Frame("nsNumberControlFrame", "TextInput", LEAF),
    Frame("nsPageBreakFrame", "PageBreak", LEAF),
    Frame("nsPageContentFrame", "PageContent", NOT_LEAF),
    Frame("nsPageFrame", "Page", NOT_LEAF),
    Frame("nsPlaceholderFrame", "Placeholder", LEAF),
    Frame("nsPopupSetFrame", "PopupSet", NOT_LEAF),
    Frame("nsProgressFrame", "Progress", LEAF),
    Frame("nsRangeFrame", "Range", LEAF),
    Frame("nsResizerFrame", "Box", NOT_LEAF),
    Frame("nsRootBoxFrame", "XULRoot", NOT_LEAF),
    Frame("nsRubyBaseContainerFrame", "RubyBaseContainer", NOT_LEAF),
    Frame("nsRubyBaseFrame", "RubyBase", NOT_LEAF),
    Frame("nsRubyFrame", "Ruby", NOT_LEAF),
    Frame("nsRubyTextContainerFrame", "RubyTextContainer", NOT_LEAF),
    Frame("nsRubyTextFrame", "RubyText", NOT_LEAF),
    Frame("nsScrollbarButtonFrame", "Box", NOT_LEAF),
    Frame("nsScrollbarFrame", "Scrollbar", NOT_LEAF),
    Frame("nsSearchControlFrame", "SearchControl", LEAF),
    Frame("nsSelectsAreaFrame", "Block", NOT_LEAF),
    Frame("nsPageSequenceFrame", "PageSequence", NOT_LEAF),
    Frame("nsSliderFrame", "Slider", NOT_LEAF),
    Frame("nsSplitterFrame", "Box", NOT_LEAF),
    Frame("nsStackFrame", "Box", NOT_LEAF),
    Frame("nsSubDocumentFrame", "SubDocument", LEAF),
    Frame("PrintedSheetFrame", "PrintedSheet", NOT_LEAF),
    Frame("SVGAFrame", "SVGA", NOT_LEAF),
    Frame("SVGClipPathFrame", "SVGClipPath", NOT_LEAF),
    Frame("SVGContainerFrame", "None", NOT_LEAF),
    Frame("SVGFEContainerFrame", "SVGFEContainer", NOT_LEAF),
    Frame("SVGFEImageFrame", "SVGFEImage", LEAF),
    Frame("SVGFELeafFrame", "SVGFELeaf", LEAF),
    Frame("SVGFEUnstyledLeafFrame", "SVGFEUnstyledLeaf", LEAF),
    Frame("SVGFilterFrame", "SVGFilter", NOT_LEAF),
    Frame("SVGForeignObjectFrame", "SVGForeignObject", NOT_LEAF),
    Frame("SVGGenericContainerFrame", "SVGGenericContainer", NOT_LEAF),
    Frame("SVGGeometryFrame", "SVGGeometry", LEAF),
    Frame("SVGGFrame", "SVGG", NOT_LEAF),
    Frame("SVGImageFrame", "SVGImage", LEAF),
    Frame("SVGInnerSVGFrame", "SVGInnerSVG", NOT_LEAF),
    Frame("SVGLinearGradientFrame", "SVGLinearGradient", NOT_LEAF),
    Frame("SVGMarkerFrame", "SVGMarker", NOT_LEAF),
    Frame("SVGMarkerAnonChildFrame", "SVGMarkerAnonChild", NOT_LEAF),
    Frame("SVGMaskFrame", "SVGMask", NOT_LEAF),
    Frame("SVGOuterSVGFrame", "SVGOuterSVG", NOT_LEAF),
    Frame("SVGOuterSVGAnonChildFrame", "SVGOuterSVGAnonChild", NOT_LEAF),
    Frame("SVGPatternFrame", "SVGPattern", NOT_LEAF),
    Frame("SVGRadialGradientFrame", "SVGRadialGradient", NOT_LEAF),
    Frame("SVGStopFrame", "SVGStop", LEAF),
    Frame("SVGSwitchFrame", "SVGSwitch", NOT_LEAF),
    Frame("SVGSymbolFrame", "SVGSymbol", NOT_LEAF),
    Frame("SVGTextFrame", "SVGText", NOT_LEAF),
    # Not a leaf, though it always has a ShadowRoot, so in practice light DOM
    # children never render.
    Frame("SVGUseFrame", "SVGUse", NOT_LEAF),
    Frame("SVGViewFrame", "SVGView", LEAF),
    Frame("nsTableCellFrame", "TableCell", NOT_LEAF),
    Frame("nsTableColFrame", "TableCol", LEAF),
    Frame("nsTableColGroupFrame", "TableColGroup", NOT_LEAF),
    Frame("nsTableFrame", "Table", NOT_LEAF),
    Frame("nsTableWrapperFrame", "TableWrapper", NOT_LEAF),
    Frame("nsTableRowFrame", "TableRow", NOT_LEAF),
    Frame("nsTableRowGroupFrame", "TableRowGroup", NOT_LEAF),
    Frame("nsTextBoxFrame", "LeafBox", LEAF),
    Frame("nsTextControlFrame", "TextInput", LEAF),
    Frame("nsTextFrame", "Text", LEAF),
    Frame("nsTitleBarFrame", "Box", NOT_LEAF),
    Frame("nsTreeBodyFrame", "LeafBox", LEAF),
    Frame("nsTreeColFrame", "Box", NOT_LEAF),
    Frame("nsVideoFrame", "HTMLVideo", NOT_LEAF),
    Frame("nsXULScrollFrame", "Scroll", NOT_LEAF),
    Frame("ViewportFrame", "Viewport", NOT_LEAF),
    Frame("WBRFrame", "Wbr", LEAF),
    # Non-concrete classes (for FrameIID use)
    AbstractFrame("nsContainerFrame"),
    AbstractFrame("nsLeafFrame"),
    AbstractFrame("nsMathMLContainerFrame"),
    AbstractFrame("nsRubyContentFrame"),
    AbstractFrame("nsSplittableFrame"),
    AbstractFrame("SVGDisplayContainerFrame"),
    AbstractFrame("SVGGradientFrame"),
    AbstractFrame("SVGPaintServerFrame"),
    # Interfaces (for FrameIID use)
    AbstractFrame("nsIAnonymousContentCreator"),
    AbstractFrame("nsIComboboxControlFrame"),
    AbstractFrame("nsIFormControlFrame"),
    AbstractFrame("nsIFrameFrame"),
    AbstractFrame("nsIListControlFrame"),
    AbstractFrame("nsIMathMLFrame"),
    AbstractFrame("nsIMenuFrame"),
    AbstractFrame("nsIPercentBSizeObserver"),
    AbstractFrame("nsIPopupContainer"),
    AbstractFrame("nsIScrollableFrame"),
    AbstractFrame("nsIScrollbarMediator"),
    AbstractFrame("nsISelectControlFrame"),
    AbstractFrame("nsIStatefulFrame"),
    AbstractFrame("ISVGDisplayableFrame"),
    AbstractFrame("ISVGSVGFrame"),
    AbstractFrame("nsITableCellLayout"),
    AbstractFrame("nsITableLayout"),
    AbstractFrame("nsITextControlFrame"),
]
