/* cli.c generated by valac 0.56.17, the Vala compiler
 * generated from cli.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2019-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <pamac.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-unix.h>
#include <signal.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <unistd.h>
#include <sys/types.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <locale.h>

#define VERSION "11.7.3"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAMAC_TYPE_CLI (pamac_cli_get_type ())
#define PAMAC_CLI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_CLI, PamacCli))
#define PAMAC_CLI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_CLI, PamacCliClass))
#define PAMAC_IS_CLI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_CLI))
#define PAMAC_IS_CLI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_CLI))
#define PAMAC_CLI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_CLI, PamacCliClass))

typedef struct _PamacCli PamacCli;
typedef struct _PamacCliClass PamacCliClass;
typedef struct _PamacCliPrivate PamacCliPrivate;

#define PAMAC_TYPE_TRANSACTION_CLI (pamac_transaction_cli_get_type ())
#define PAMAC_TRANSACTION_CLI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_TRANSACTION_CLI, PamacTransactionCli))
#define PAMAC_TRANSACTION_CLI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_TRANSACTION_CLI, PamacTransactionCliClass))
#define PAMAC_IS_TRANSACTION_CLI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_TRANSACTION_CLI))
#define PAMAC_IS_TRANSACTION_CLI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_TRANSACTION_CLI))
#define PAMAC_TRANSACTION_CLI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_TRANSACTION_CLI, PamacTransactionCliClass))

typedef struct _PamacTransactionCli PamacTransactionCli;
typedef struct _PamacTransactionCliClass PamacTransactionCliClass;
enum  {
	PAMAC_CLI_0_PROPERTY,
	PAMAC_CLI_NUM_PROPERTIES
};
static GParamSpec* pamac_cli_properties[PAMAC_CLI_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block6Data Block6Data;

struct _PamacCli {
	GObject parent_instance;
	PamacCliPrivate * priv;
	gint exit_status;
	PamacTransactionCli* transaction;
	GSubprocess* pkttyagent;
};

struct _PamacCliClass {
	GObjectClass parent_class;
};

struct _PamacCliPrivate {
	PamacDatabase* database;
	gboolean trans_cancellable;
	gboolean cloning;
	GCancellable* cancellable;
	GHashTable* already_checked_aur_dep;
	gint term_width;
};

struct _Block2Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

struct _Block3Data {
	int _ref_count_;
	PamacCli* self;
	GMainLoop* loop;
};

struct _Block4Data {
	int _ref_count_;
	PamacCli* self;
	GMainLoop* loop;
};

struct _Block5Data {
	int _ref_count_;
	PamacCli* self;
	GMainLoop* loop;
};

struct _Block6Data {
	int _ref_count_;
	PamacCli* self;
	GMainLoop* loop;
};

static gint PamacCli_private_offset;
static gpointer pamac_cli_parent_class = NULL;
VALA_EXTERN gchar* pamac_search_string;
gchar* pamac_search_string = NULL;

VALA_EXTERN GType pamac_cli_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacCli, g_object_unref)
VALA_EXTERN GType pamac_transaction_cli_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PamacTransactionCli, g_object_unref)
VALA_EXTERN PamacCli* pamac_cli_new (void);
VALA_EXTERN PamacCli* pamac_cli_construct (GType object_type);
static gint pamac_cli_get_term_width (PamacCli* self);
static gboolean pamac_cli_trans_cancel (PamacCli* self);
static gboolean _pamac_cli_trans_cancel_gsource_func (gpointer self);
VALA_EXTERN void pamac_cli_parse_command_line (PamacCli* self,
                                   gchar** args,
                                   gint args_length1);
static void pamac_cli_display_help (PamacCli* self);
static void pamac_cli_display_search_help (PamacCli* self);
static void pamac_cli_display_info_help (PamacCli* self);
static void pamac_cli_display_list_help (PamacCli* self);
static void pamac_cli_display_clone_help (PamacCli* self);
static void pamac_cli_display_build_help (PamacCli* self);
static void pamac_cli_display_install_help (PamacCli* self);
static void pamac_cli_display_reinstall_help (PamacCli* self);
static void pamac_cli_display_remove_help (PamacCli* self);
static void pamac_cli_display_checkupdates_help (PamacCli* self);
static void pamac_cli_display_upgrade_help (PamacCli* self);
static void pamac_cli_display_clean_help (PamacCli* self);
static void pamac_cli_display_version (PamacCli* self);
static void pamac_cli_init_transaction (PamacCli* self);
static void pamac_cli_search_files (PamacCli* self,
                             gchar** files,
                             gint files_length1,
                             gboolean quiet);
static gchar* pamac_cli_concatenate_strings (PamacCli* self,
                                      gchar** list,
                                      gint list_length1);
static void pamac_cli_search_installed_pkgs (PamacCli* self,
                                      gboolean quiet);
static void pamac_cli_search_repos_pkgs (PamacCli* self,
                                  gboolean quiet);
static void pamac_cli_search_pkgs (PamacCli* self,
                            gboolean quiet);
static void pamac_cli_display_pkgs_infos (PamacCli* self,
                                   gchar** pkgnames,
                                   gint pkgnames_length1);
static void pamac_cli_list_orphans (PamacCli* self,
                             gboolean quiet);
static void pamac_cli_list_installed (PamacCli* self,
                               gboolean quiet);
static void pamac_cli_list_explicitly_installed (PamacCli* self,
                                          gboolean quiet);
static void pamac_cli_list_foreign (PamacCli* self,
                             gboolean quiet);
static void pamac_cli_list_groups (PamacCli* self,
                            gchar** names,
                            gint names_length1,
                            gboolean quiet);
static void pamac_cli_list_repos (PamacCli* self,
                           gchar** names,
                           gint names_length1,
                           gboolean quiet);
static void pamac_cli_list_files (PamacCli* self,
                           gchar** names,
                           gint names_length1,
                           gboolean quiet);
static void pamac_cli_init_database (PamacCli* self);
static void pamac_cli_get_aur_dest_variable (PamacCli* self);
static void pamac_cli_clone_build_files (PamacCli* self,
                                  gchar** pkgnames,
                                  gint pkgnames_length1,
                                  gboolean overwrite,
                                  gboolean recurse,
                                  gboolean quiet);
VALA_EXTERN void pamac_transaction_cli_set_no_confirm (PamacTransactionCli* self,
                                           gboolean value);
static void _g_free0_ (gpointer var);
static void pamac_cli_build_pkgs (PamacCli* self,
                           gchar** names,
                           gint names_length1,
                           gboolean clone_build_files,
                           gboolean clone_deps_build_files);
static gboolean pamac_cli_check_build_pkgs (PamacCli* self,
                                     gchar** targets,
                                     gint targets_length1,
                                     gboolean no_confirm,
                                     GPtrArray** checked_targets);
static void pamac_cli_install_pkgs (PamacCli* self,
                             gchar** targets,
                             gint targets_length1);
static void pamac_cli_reinstall_pkgs (PamacCli* self,
                               gchar** names,
                               gint names_length1);
static void pamac_cli_remove_orphans (PamacCli* self);
static void pamac_cli_remove_pkgs (PamacCli* self,
                            gchar** names,
                            gint names_length1);
static void pamac_cli_checkupdates (PamacCli* self,
                             gboolean quiet,
                             gboolean refresh_tmp_files_dbs,
                             gboolean download_updates);
static void pamac_cli_run_sysupgrade (PamacCli* self,
                               gboolean force_refresh);
static void pamac_cli_clean_build_files (PamacCli* self,
                                  gboolean dry_run,
                                  gboolean verbose,
                                  gboolean no_confirm);
static void pamac_cli_clean_cache (PamacCli* self,
                            gboolean dry_run,
                            gboolean verbose,
                            gboolean no_confirm);
VALA_EXTERN PamacTransactionCli* pamac_transaction_cli_new (PamacDatabase* database);
VALA_EXTERN PamacTransactionCli* pamac_transaction_cli_construct (GType object_type,
                                                      PamacDatabase* database);
static void __lambda5_ (PamacCli* self);
static void ___lambda5__pamac_transaction_start_waiting (PamacTransaction* _sender,
                                                  gpointer self);
static void __lambda6_ (PamacCli* self);
static void ___lambda6__pamac_transaction_stop_waiting (PamacTransaction* _sender,
                                                 gpointer self);
static void __lambda7_ (PamacCli* self);
static void ___lambda7__pamac_transaction_start_downloading (PamacTransaction* _sender,
                                                      gpointer self);
static void __lambda8_ (PamacCli* self);
static void ___lambda8__pamac_transaction_stop_downloading (PamacTransaction* _sender,
                                                     gpointer self);
static void __lambda9_ (PamacCli* self);
static void ___lambda9__pamac_transaction_start_building (PamacTransaction* _sender,
                                                   gpointer self);
static void __lambda10_ (PamacCli* self);
static void ___lambda10__pamac_transaction_stop_building (PamacTransaction* _sender,
                                                   gpointer self);
static gchar* pamac_cli_concatenate_strings_list (PamacCli* self,
                                           GPtrArray* list);
static GPtrArray* pamac_cli_split_string (PamacCli* self,
                                   const gchar* str,
                                   gint margin,
                                   gint width);
static void pamac_cli_print_aligned (PamacCli* self,
                              const gchar* str1,
                              const gchar* str2,
                              gint width);
static void pamac_cli_print_property (PamacCli* self,
                               const gchar* property,
                               const gchar* val,
                               gint width);
static void pamac_cli_print_property_list (PamacCli* self,
                                    const gchar* property,
                                    GPtrArray* list,
                                    gint width);
static void pamac_cli_print_error (PamacCli* self,
                            const gchar* message);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint ___lambda1__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
VALA_EXTERN gint pamac_sort_search_pkgs_by_relevance (PamacPackage* pkg_a,
                                          PamacPackage* pkg_b);
static gint _pamac_sort_search_pkgs_by_relevance_gcompare_func (gconstpointer a,
                                                         gconstpointer b);
static void pamac_cli_print_search_pkgs (PamacCli* self,
                                  GPtrArray* pkgs,
                                  gboolean print_installed,
                                  gboolean quiet);
static void pamac_cli_display_pkg_infos (PamacCli* self,
                                  PamacAlpmPackage* pkg,
                                  PamacAURPackage* aur_pkg,
                                  gchar** properties,
                                  gint properties_length1,
                                  gint max_length);
static void pamac_cli_print_pkgs (PamacCli* self,
                           GPtrArray* pkgs,
                           gboolean print_installed,
                           gboolean quiet);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ____lambda14_ (Block3Data* _data3_);
static void _____lambda14__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static guint64* _uint64_dup (guint64* self);
VALA_EXTERN gboolean pamac_transaction_cli_ask_user (PamacTransactionCli* self,
                                         const gchar* question);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ____lambda16_ (Block4Data* _data4_);
static void _____lambda16__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ____lambda15_ (Block5Data* _data5_);
static void _____lambda15__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void pamac_cli_ask_group_confirmation (PamacCli* self,
                                       const gchar* grpname,
                                       GPtrArray** to_install);
static void pamac_cli_run_transaction (PamacCli* self);
VALA_EXTERN gboolean pamac_transaction_cli_get_no_confirm (PamacTransactionCli* self);
static void pamac_cli_clone_build_files_real (PamacCli* self,
                                       GPtrArray* pkgnames,
                                       gboolean overwrite,
                                       gboolean recurse,
                                       gboolean quiet);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean ___lambda11_ (Block6Data* _data6_);
static void __lambda12_ (Block6Data* _data6_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda12__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean ____lambda11__gsource_func (gpointer self);
static void ___lambda13_ (Block6Data* _data6_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda13__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gint pamac_cli_main (gchar** args,
                     gint args_length1);
static void pamac_cli_finalize (GObject * obj);
static GType pamac_cli_get_type_once (void);
VALA_EXTERN gint pamac_sort_pkgs_by_relevance (PamacPackage* pkg_a,
                                   PamacPackage* pkg_b);
VALA_EXTERN gint pamac_sort_pkgs_by_name (PamacPackage* pkg_a,
                              PamacPackage* pkg_b);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
pamac_cli_get_instance_private (PamacCli* self)
{
	return G_STRUCT_MEMBER_P (self, PamacCli_private_offset);
}

static gboolean
_pamac_cli_trans_cancel_gsource_func (gpointer self)
{
	gboolean result;
	result = pamac_cli_trans_cancel ((PamacCli*) self);
	return result;
}

PamacCli*
pamac_cli_construct (GType object_type)
{
	PamacCli * self = NULL;
	GCancellable* _tmp0_;
	self = (PamacCli*) g_object_new (object_type, NULL);
	self->exit_status = 0;
	self->priv->trans_cancellable = FALSE;
	self->priv->cloning = FALSE;
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	self->priv->term_width = pamac_cli_get_term_width (self);
	g_unix_signal_add_full (G_PRIORITY_HIGH, (gint) SIGINT, _pamac_cli_trans_cancel_gsource_func, g_object_ref (self), g_object_unref);
	return self;
}

PamacCli*
pamac_cli_new (void)
{
	return pamac_cli_construct (PAMAC_TYPE_CLI);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
pamac_cli_parse_command_line (PamacCli* self,
                              gchar** args,
                              gint args_length1)
{
	gboolean help = FALSE;
	gboolean version = FALSE;
	const gchar* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (args_length1 == 1) {
		pamac_cli_display_help (self);
		return;
	}
	help = FALSE;
	version = FALSE;
	{
		GOptionEntry* options = NULL;
		GOptionEntry* _tmp0_;
		gint options_length1;
		gint _options_size_;
		GOptionEntry* _tmp1_;
		gint _tmp1__length1;
		GOptionEntry _tmp2_ = {0};
		GOptionEntry* _tmp3_;
		gint _tmp3__length1;
		GOptionEntry _tmp4_ = {0};
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp5_;
		GOptionContext* _tmp6_;
		GOptionContext* _tmp7_;
		GOptionContext* _tmp8_;
		GOptionEntry* _tmp9_;
		gint _tmp9__length1;
		GOptionContext* _tmp10_;
		_tmp0_ = g_new0 (GOptionEntry, 2);
		options = _tmp0_;
		options_length1 = 2;
		_options_size_ = options_length1;
		_tmp1_ = options;
		_tmp1__length1 = options_length1;
		_tmp2_.long_name = "version";
		_tmp2_.short_name = 'V';
		_tmp2_.flags = (gint) 0;
		_tmp2_.arg = G_OPTION_ARG_NONE;
		_tmp2_.arg_data = &version;
		_tmp2_.description = NULL;
		_tmp2_.arg_description = NULL;
		_tmp1_[0] = _tmp2_;
		_tmp3_ = options;
		_tmp3__length1 = options_length1;
		_tmp4_.long_name = "help";
		_tmp4_.short_name = 'h';
		_tmp4_.flags = (gint) 0;
		_tmp4_.arg = G_OPTION_ARG_NONE;
		_tmp4_.arg_data = &help;
		_tmp4_.description = NULL;
		_tmp4_.arg_description = NULL;
		_tmp3_[1] = _tmp4_;
		_tmp5_ = g_option_context_new (NULL);
		opt_context = _tmp5_;
		_tmp6_ = opt_context;
		g_option_context_set_help_enabled (_tmp6_, FALSE);
		_tmp7_ = opt_context;
		g_option_context_set_strict_posix (_tmp7_, TRUE);
		_tmp8_ = opt_context;
		_tmp9_ = options;
		_tmp9__length1 = options_length1;
		g_option_context_add_main_entries (_tmp8_, _tmp9_, NULL);
		_tmp10_ = opt_context;
		g_option_context_parse (_tmp10_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_option_context_free0 (opt_context);
			options = (g_free (options), NULL);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_option_context_free0 (opt_context);
		options = (g_free (options), NULL);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		g_clear_error (&_inner_error0_);
		pamac_cli_display_help (self);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (help) {
		if (args_length1 == 2) {
			const gchar* _tmp11_;
			_tmp11_ = args[1];
			if (g_strcmp0 (_tmp11_, "search") == 0) {
				pamac_cli_display_search_help (self);
			} else {
				const gchar* _tmp12_;
				_tmp12_ = args[1];
				if (g_strcmp0 (_tmp12_, "info") == 0) {
					pamac_cli_display_info_help (self);
				} else {
					const gchar* _tmp13_;
					_tmp13_ = args[1];
					if (g_strcmp0 (_tmp13_, "list") == 0) {
						pamac_cli_display_list_help (self);
					} else {
						const gchar* _tmp14_;
						_tmp14_ = args[1];
						if (g_strcmp0 (_tmp14_, "clone") == 0) {
							pamac_cli_display_clone_help (self);
						} else {
							const gchar* _tmp15_;
							_tmp15_ = args[1];
							if (g_strcmp0 (_tmp15_, "build") == 0) {
								pamac_cli_display_build_help (self);
							} else {
								const gchar* _tmp16_;
								_tmp16_ = args[1];
								if (g_strcmp0 (_tmp16_, "install") == 0) {
									pamac_cli_display_install_help (self);
								} else {
									const gchar* _tmp17_;
									_tmp17_ = args[1];
									if (g_strcmp0 (_tmp17_, "reinstall") == 0) {
										pamac_cli_display_reinstall_help (self);
									} else {
										const gchar* _tmp18_;
										_tmp18_ = args[1];
										if (g_strcmp0 (_tmp18_, "remove") == 0) {
											pamac_cli_display_remove_help (self);
										} else {
											const gchar* _tmp19_;
											_tmp19_ = args[1];
											if (g_strcmp0 (_tmp19_, "checkupdates") == 0) {
												pamac_cli_display_checkupdates_help (self);
											} else {
												gboolean _tmp20_ = FALSE;
												const gchar* _tmp21_;
												_tmp21_ = args[1];
												if (g_strcmp0 (_tmp21_, "upgrade") == 0) {
													_tmp20_ = TRUE;
												} else {
													const gchar* _tmp22_;
													_tmp22_ = args[2];
													_tmp20_ = g_strcmp0 (_tmp22_, "update") == 0;
												}
												if (_tmp20_) {
													pamac_cli_display_upgrade_help (self);
												} else {
													const gchar* _tmp23_;
													_tmp23_ = args[1];
													if (g_strcmp0 (_tmp23_, "clean") == 0) {
														pamac_cli_display_clean_help (self);
													} else {
														pamac_cli_display_help (self);
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		} else {
			pamac_cli_display_help (self);
		}
		return;
	}
	if (version) {
		pamac_cli_display_version (self);
		return;
	}
	_tmp24_ = args[1];
	if (g_strcmp0 (_tmp24_, "search") == 0) {
		if (args_length1 > 2) {
			gboolean installed = FALSE;
			gboolean repos = FALSE;
			gboolean aur = FALSE;
			gboolean no_aur = FALSE;
			gboolean files = FALSE;
			gboolean quiet = FALSE;
			installed = FALSE;
			repos = FALSE;
			aur = FALSE;
			no_aur = FALSE;
			files = FALSE;
			quiet = FALSE;
			{
				GOptionEntry* options = NULL;
				GOptionEntry* _tmp25_;
				gint options_length1;
				gint _options_size_;
				GOptionEntry* _tmp26_;
				gint _tmp26__length1;
				GOptionEntry _tmp27_ = {0};
				GOptionEntry* _tmp28_;
				gint _tmp28__length1;
				GOptionEntry _tmp29_ = {0};
				GOptionEntry* _tmp30_;
				gint _tmp30__length1;
				GOptionEntry _tmp31_ = {0};
				GOptionEntry* _tmp32_;
				gint _tmp32__length1;
				GOptionEntry _tmp33_ = {0};
				GOptionEntry* _tmp34_;
				gint _tmp34__length1;
				GOptionEntry _tmp35_ = {0};
				GOptionEntry* _tmp36_;
				gint _tmp36__length1;
				GOptionEntry _tmp37_ = {0};
				GOptionEntry* _tmp38_;
				gint _tmp38__length1;
				GOptionEntry _tmp39_ = {0};
				GOptionContext* opt_context = NULL;
				GOptionContext* _tmp40_;
				GOptionContext* _tmp41_;
				GOptionContext* _tmp42_;
				GOptionEntry* _tmp43_;
				gint _tmp43__length1;
				GOptionContext* _tmp44_;
				_tmp25_ = g_new0 (GOptionEntry, 7);
				options = _tmp25_;
				options_length1 = 7;
				_options_size_ = options_length1;
				_tmp26_ = options;
				_tmp26__length1 = options_length1;
				_tmp27_.long_name = "help";
				_tmp27_.short_name = 'h';
				_tmp27_.flags = (gint) 0;
				_tmp27_.arg = G_OPTION_ARG_NONE;
				_tmp27_.arg_data = &help;
				_tmp27_.description = NULL;
				_tmp27_.arg_description = NULL;
				_tmp26_[0] = _tmp27_;
				_tmp28_ = options;
				_tmp28__length1 = options_length1;
				_tmp29_.long_name = "installed";
				_tmp29_.short_name = 'i';
				_tmp29_.flags = (gint) 0;
				_tmp29_.arg = G_OPTION_ARG_NONE;
				_tmp29_.arg_data = &installed;
				_tmp29_.description = NULL;
				_tmp29_.arg_description = NULL;
				_tmp28_[1] = _tmp29_;
				_tmp30_ = options;
				_tmp30__length1 = options_length1;
				_tmp31_.long_name = "repos";
				_tmp31_.short_name = 'r';
				_tmp31_.flags = (gint) 0;
				_tmp31_.arg = G_OPTION_ARG_NONE;
				_tmp31_.arg_data = &repos;
				_tmp31_.description = NULL;
				_tmp31_.arg_description = NULL;
				_tmp30_[2] = _tmp31_;
				_tmp32_ = options;
				_tmp32__length1 = options_length1;
				_tmp33_.long_name = "aur";
				_tmp33_.short_name = 'a';
				_tmp33_.flags = (gint) 0;
				_tmp33_.arg = G_OPTION_ARG_NONE;
				_tmp33_.arg_data = &aur;
				_tmp33_.description = NULL;
				_tmp33_.arg_description = NULL;
				_tmp32_[3] = _tmp33_;
				_tmp34_ = options;
				_tmp34__length1 = options_length1;
				_tmp35_.long_name = "no-aur";
				_tmp35_.short_name = (gchar) 0;
				_tmp35_.flags = (gint) 0;
				_tmp35_.arg = G_OPTION_ARG_NONE;
				_tmp35_.arg_data = &no_aur;
				_tmp35_.description = NULL;
				_tmp35_.arg_description = NULL;
				_tmp34_[4] = _tmp35_;
				_tmp36_ = options;
				_tmp36__length1 = options_length1;
				_tmp37_.long_name = "files";
				_tmp37_.short_name = 'f';
				_tmp37_.flags = (gint) 0;
				_tmp37_.arg = G_OPTION_ARG_NONE;
				_tmp37_.arg_data = &files;
				_tmp37_.description = NULL;
				_tmp37_.arg_description = NULL;
				_tmp36_[5] = _tmp37_;
				_tmp38_ = options;
				_tmp38__length1 = options_length1;
				_tmp39_.long_name = "quiet";
				_tmp39_.short_name = 'q';
				_tmp39_.flags = (gint) 0;
				_tmp39_.arg = G_OPTION_ARG_NONE;
				_tmp39_.arg_data = &quiet;
				_tmp39_.description = NULL;
				_tmp39_.arg_description = NULL;
				_tmp38_[6] = _tmp39_;
				_tmp40_ = g_option_context_new (NULL);
				opt_context = _tmp40_;
				_tmp41_ = opt_context;
				g_option_context_set_help_enabled (_tmp41_, FALSE);
				_tmp42_ = opt_context;
				_tmp43_ = options;
				_tmp43__length1 = options_length1;
				g_option_context_add_main_entries (_tmp42_, _tmp43_, NULL);
				_tmp44_ = opt_context;
				g_option_context_parse (_tmp44_, (gint*) (&args_length1), &args, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_option_context_free0 (opt_context);
					options = (g_free (options), NULL);
					if (_inner_error0_->domain == G_OPTION_ERROR) {
						goto __catch1_g_option_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_option_context_free0 (opt_context);
				options = (g_free (options), NULL);
			}
			goto __finally1;
			__catch1_g_option_error:
			{
				g_clear_error (&_inner_error0_);
				pamac_cli_display_search_help (self);
				return;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (help) {
				pamac_cli_display_search_help (self);
				return;
			}
			if (args_length1 == 2) {
				pamac_cli_display_search_help (self);
				return;
			}
			pamac_cli_init_transaction (self);
			if (files) {
				pamac_cli_search_files (self, args + 2, (gint) (args_length1 - 2), quiet);
				return;
			}
			if (aur) {
				PamacDatabase* _tmp45_;
				PamacConfig* _tmp46_;
				PamacConfig* _tmp47_;
				gboolean _tmp48_;
				gboolean _tmp49_;
				if (no_aur) {
					pamac_cli_display_search_help (self);
					return;
				}
				_tmp45_ = self->priv->database;
				_tmp46_ = pamac_database_get_config (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = pamac_config_get_support_aur (_tmp47_);
				_tmp49_ = _tmp48_;
				if (!_tmp49_) {
					g_warning ("cli.vala:143: AUR not supported");
				} else {
					PamacDatabase* _tmp50_;
					PamacConfig* _tmp51_;
					PamacConfig* _tmp52_;
					_tmp50_ = self->priv->database;
					_tmp51_ = pamac_database_get_config (_tmp50_);
					_tmp52_ = _tmp51_;
					pamac_config_set_enable_aur (_tmp52_, TRUE);
				}
			}
			if (no_aur) {
				PamacDatabase* _tmp53_;
				PamacConfig* _tmp54_;
				PamacConfig* _tmp55_;
				_tmp53_ = self->priv->database;
				_tmp54_ = pamac_database_get_config (_tmp53_);
				_tmp55_ = _tmp54_;
				pamac_config_set_enable_aur (_tmp55_, FALSE);
			}
			if (installed) {
				if (repos) {
					pamac_cli_display_search_help (self);
					return;
				} else {
					gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					_tmp56_ = pamac_cli_concatenate_strings (self, args + 2, (gint) (args_length1 - 2));
					_tmp57_ = _tmp56_;
					_tmp58_ = g_utf8_strdown (_tmp57_, (gssize) -1);
					_g_free0 (pamac_search_string);
					pamac_search_string = _tmp58_;
					_g_free0 (_tmp57_);
					pamac_cli_search_installed_pkgs (self, quiet);
				}
			} else {
				if (repos) {
					if (installed) {
						pamac_cli_display_search_help (self);
						return;
					} else {
						gchar* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						_tmp59_ = pamac_cli_concatenate_strings (self, args + 2, (gint) (args_length1 - 2));
						_tmp60_ = _tmp59_;
						_tmp61_ = g_utf8_strdown (_tmp60_, (gssize) -1);
						_g_free0 (pamac_search_string);
						pamac_search_string = _tmp61_;
						_g_free0 (_tmp60_);
						pamac_cli_search_repos_pkgs (self, quiet);
					}
				} else {
					gchar* _tmp62_;
					gchar* _tmp63_;
					gchar* _tmp64_;
					_tmp62_ = pamac_cli_concatenate_strings (self, args + 2, (gint) (args_length1 - 2));
					_tmp63_ = _tmp62_;
					_tmp64_ = g_utf8_strdown (_tmp63_, (gssize) -1);
					_g_free0 (pamac_search_string);
					pamac_search_string = _tmp64_;
					_g_free0 (_tmp63_);
					pamac_cli_search_pkgs (self, quiet);
				}
			}
		} else {
			pamac_cli_display_search_help (self);
		}
	} else {
		const gchar* _tmp65_;
		_tmp65_ = args[1];
		if (g_strcmp0 (_tmp65_, "info") == 0) {
			if (args_length1 > 2) {
				gboolean aur = FALSE;
				gboolean no_aur = FALSE;
				aur = FALSE;
				no_aur = FALSE;
				{
					GOptionEntry* options = NULL;
					GOptionEntry* _tmp66_;
					gint options_length1;
					gint _options_size_;
					GOptionEntry* _tmp67_;
					gint _tmp67__length1;
					GOptionEntry _tmp68_ = {0};
					GOptionEntry* _tmp69_;
					gint _tmp69__length1;
					GOptionEntry _tmp70_ = {0};
					GOptionEntry* _tmp71_;
					gint _tmp71__length1;
					GOptionEntry _tmp72_ = {0};
					GOptionContext* opt_context = NULL;
					GOptionContext* _tmp73_;
					GOptionContext* _tmp74_;
					GOptionContext* _tmp75_;
					GOptionEntry* _tmp76_;
					gint _tmp76__length1;
					GOptionContext* _tmp77_;
					_tmp66_ = g_new0 (GOptionEntry, 3);
					options = _tmp66_;
					options_length1 = 3;
					_options_size_ = options_length1;
					_tmp67_ = options;
					_tmp67__length1 = options_length1;
					_tmp68_.long_name = "help";
					_tmp68_.short_name = 'h';
					_tmp68_.flags = (gint) 0;
					_tmp68_.arg = G_OPTION_ARG_NONE;
					_tmp68_.arg_data = &help;
					_tmp68_.description = NULL;
					_tmp68_.arg_description = NULL;
					_tmp67_[0] = _tmp68_;
					_tmp69_ = options;
					_tmp69__length1 = options_length1;
					_tmp70_.long_name = "aur";
					_tmp70_.short_name = 'a';
					_tmp70_.flags = (gint) 0;
					_tmp70_.arg = G_OPTION_ARG_NONE;
					_tmp70_.arg_data = &aur;
					_tmp70_.description = NULL;
					_tmp70_.arg_description = NULL;
					_tmp69_[1] = _tmp70_;
					_tmp71_ = options;
					_tmp71__length1 = options_length1;
					_tmp72_.long_name = "no-aur";
					_tmp72_.short_name = (gchar) 0;
					_tmp72_.flags = (gint) 0;
					_tmp72_.arg = G_OPTION_ARG_NONE;
					_tmp72_.arg_data = &no_aur;
					_tmp72_.description = NULL;
					_tmp72_.arg_description = NULL;
					_tmp71_[2] = _tmp72_;
					_tmp73_ = g_option_context_new (NULL);
					opt_context = _tmp73_;
					_tmp74_ = opt_context;
					g_option_context_set_help_enabled (_tmp74_, FALSE);
					_tmp75_ = opt_context;
					_tmp76_ = options;
					_tmp76__length1 = options_length1;
					g_option_context_add_main_entries (_tmp75_, _tmp76_, NULL);
					_tmp77_ = opt_context;
					g_option_context_parse (_tmp77_, (gint*) (&args_length1), &args, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_option_context_free0 (opt_context);
						options = (g_free (options), NULL);
						if (_inner_error0_->domain == G_OPTION_ERROR) {
							goto __catch2_g_option_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_g_option_context_free0 (opt_context);
					options = (g_free (options), NULL);
				}
				goto __finally2;
				__catch2_g_option_error:
				{
					g_clear_error (&_inner_error0_);
					pamac_cli_display_info_help (self);
					return;
				}
				__finally2:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				if (help) {
					pamac_cli_display_info_help (self);
					return;
				}
				if (args_length1 == 2) {
					pamac_cli_display_info_help (self);
					return;
				}
				pamac_cli_init_transaction (self);
				if (aur) {
					PamacDatabase* _tmp78_;
					PamacConfig* _tmp79_;
					PamacConfig* _tmp80_;
					gboolean _tmp81_;
					gboolean _tmp82_;
					if (no_aur) {
						pamac_cli_display_info_help (self);
						return;
					}
					_tmp78_ = self->priv->database;
					_tmp79_ = pamac_database_get_config (_tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = pamac_config_get_support_aur (_tmp80_);
					_tmp82_ = _tmp81_;
					if (!_tmp82_) {
						g_warning ("cli.vala:207: AUR not supported");
					} else {
						PamacDatabase* _tmp83_;
						PamacConfig* _tmp84_;
						PamacConfig* _tmp85_;
						_tmp83_ = self->priv->database;
						_tmp84_ = pamac_database_get_config (_tmp83_);
						_tmp85_ = _tmp84_;
						pamac_config_set_enable_aur (_tmp85_, TRUE);
					}
				}
				if (no_aur) {
					PamacDatabase* _tmp86_;
					PamacConfig* _tmp87_;
					PamacConfig* _tmp88_;
					_tmp86_ = self->priv->database;
					_tmp87_ = pamac_database_get_config (_tmp86_);
					_tmp88_ = _tmp87_;
					pamac_config_set_enable_aur (_tmp88_, FALSE);
				}
				pamac_cli_display_pkgs_infos (self, args + 2, (gint) (args_length1 - 2));
			} else {
				pamac_cli_display_info_help (self);
			}
		} else {
			const gchar* _tmp89_;
			_tmp89_ = args[1];
			if (g_strcmp0 (_tmp89_, "list") == 0) {
				if (args_length1 > 2) {
					gboolean installed = FALSE;
					gboolean explicitly_installed = FALSE;
					gboolean orphans = FALSE;
					gboolean foreign = FALSE;
					gboolean groups = FALSE;
					gboolean repos = FALSE;
					gboolean files = FALSE;
					gboolean quiet = FALSE;
					installed = FALSE;
					explicitly_installed = FALSE;
					orphans = FALSE;
					foreign = FALSE;
					groups = FALSE;
					repos = FALSE;
					files = FALSE;
					quiet = FALSE;
					{
						GOptionEntry* options = NULL;
						GOptionEntry* _tmp90_;
						gint options_length1;
						gint _options_size_;
						GOptionEntry* _tmp91_;
						gint _tmp91__length1;
						GOptionEntry _tmp92_ = {0};
						GOptionEntry* _tmp93_;
						gint _tmp93__length1;
						GOptionEntry _tmp94_ = {0};
						GOptionEntry* _tmp95_;
						gint _tmp95__length1;
						GOptionEntry _tmp96_ = {0};
						GOptionEntry* _tmp97_;
						gint _tmp97__length1;
						GOptionEntry _tmp98_ = {0};
						GOptionEntry* _tmp99_;
						gint _tmp99__length1;
						GOptionEntry _tmp100_ = {0};
						GOptionEntry* _tmp101_;
						gint _tmp101__length1;
						GOptionEntry _tmp102_ = {0};
						GOptionEntry* _tmp103_;
						gint _tmp103__length1;
						GOptionEntry _tmp104_ = {0};
						GOptionEntry* _tmp105_;
						gint _tmp105__length1;
						GOptionEntry _tmp106_ = {0};
						GOptionEntry* _tmp107_;
						gint _tmp107__length1;
						GOptionEntry _tmp108_ = {0};
						GOptionContext* opt_context = NULL;
						GOptionContext* _tmp109_;
						GOptionContext* _tmp110_;
						GOptionContext* _tmp111_;
						GOptionEntry* _tmp112_;
						gint _tmp112__length1;
						GOptionContext* _tmp113_;
						_tmp90_ = g_new0 (GOptionEntry, 9);
						options = _tmp90_;
						options_length1 = 9;
						_options_size_ = options_length1;
						_tmp91_ = options;
						_tmp91__length1 = options_length1;
						_tmp92_.long_name = "help";
						_tmp92_.short_name = 'h';
						_tmp92_.flags = (gint) 0;
						_tmp92_.arg = G_OPTION_ARG_NONE;
						_tmp92_.arg_data = &help;
						_tmp92_.description = NULL;
						_tmp92_.arg_description = NULL;
						_tmp91_[0] = _tmp92_;
						_tmp93_ = options;
						_tmp93__length1 = options_length1;
						_tmp94_.long_name = "installed";
						_tmp94_.short_name = 'i';
						_tmp94_.flags = (gint) 0;
						_tmp94_.arg = G_OPTION_ARG_NONE;
						_tmp94_.arg_data = &installed;
						_tmp94_.description = NULL;
						_tmp94_.arg_description = NULL;
						_tmp93_[1] = _tmp94_;
						_tmp95_ = options;
						_tmp95__length1 = options_length1;
						_tmp96_.long_name = "explicitly-installed";
						_tmp96_.short_name = 'e';
						_tmp96_.flags = (gint) 0;
						_tmp96_.arg = G_OPTION_ARG_NONE;
						_tmp96_.arg_data = &explicitly_installed;
						_tmp96_.description = NULL;
						_tmp96_.arg_description = NULL;
						_tmp95_[2] = _tmp96_;
						_tmp97_ = options;
						_tmp97__length1 = options_length1;
						_tmp98_.long_name = "orphans";
						_tmp98_.short_name = 'o';
						_tmp98_.flags = (gint) 0;
						_tmp98_.arg = G_OPTION_ARG_NONE;
						_tmp98_.arg_data = &orphans;
						_tmp98_.description = NULL;
						_tmp98_.arg_description = NULL;
						_tmp97_[3] = _tmp98_;
						_tmp99_ = options;
						_tmp99__length1 = options_length1;
						_tmp100_.long_name = "foreign";
						_tmp100_.short_name = 'm';
						_tmp100_.flags = (gint) 0;
						_tmp100_.arg = G_OPTION_ARG_NONE;
						_tmp100_.arg_data = &foreign;
						_tmp100_.description = NULL;
						_tmp100_.arg_description = NULL;
						_tmp99_[4] = _tmp100_;
						_tmp101_ = options;
						_tmp101__length1 = options_length1;
						_tmp102_.long_name = "groups";
						_tmp102_.short_name = 'g';
						_tmp102_.flags = (gint) 0;
						_tmp102_.arg = G_OPTION_ARG_NONE;
						_tmp102_.arg_data = &groups;
						_tmp102_.description = NULL;
						_tmp102_.arg_description = NULL;
						_tmp101_[5] = _tmp102_;
						_tmp103_ = options;
						_tmp103__length1 = options_length1;
						_tmp104_.long_name = "repos";
						_tmp104_.short_name = 'r';
						_tmp104_.flags = (gint) 0;
						_tmp104_.arg = G_OPTION_ARG_NONE;
						_tmp104_.arg_data = &repos;
						_tmp104_.description = NULL;
						_tmp104_.arg_description = NULL;
						_tmp103_[6] = _tmp104_;
						_tmp105_ = options;
						_tmp105__length1 = options_length1;
						_tmp106_.long_name = "files";
						_tmp106_.short_name = 'f';
						_tmp106_.flags = (gint) 0;
						_tmp106_.arg = G_OPTION_ARG_NONE;
						_tmp106_.arg_data = &files;
						_tmp106_.description = NULL;
						_tmp106_.arg_description = NULL;
						_tmp105_[7] = _tmp106_;
						_tmp107_ = options;
						_tmp107__length1 = options_length1;
						_tmp108_.long_name = "quiet";
						_tmp108_.short_name = 'q';
						_tmp108_.flags = (gint) 0;
						_tmp108_.arg = G_OPTION_ARG_NONE;
						_tmp108_.arg_data = &quiet;
						_tmp108_.description = NULL;
						_tmp108_.arg_description = NULL;
						_tmp107_[8] = _tmp108_;
						_tmp109_ = g_option_context_new (NULL);
						opt_context = _tmp109_;
						_tmp110_ = opt_context;
						g_option_context_set_help_enabled (_tmp110_, FALSE);
						_tmp111_ = opt_context;
						_tmp112_ = options;
						_tmp112__length1 = options_length1;
						g_option_context_add_main_entries (_tmp111_, _tmp112_, NULL);
						_tmp113_ = opt_context;
						g_option_context_parse (_tmp113_, (gint*) (&args_length1), &args, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_option_context_free0 (opt_context);
							options = (g_free (options), NULL);
							if (_inner_error0_->domain == G_OPTION_ERROR) {
								goto __catch3_g_option_error;
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						_g_option_context_free0 (opt_context);
						options = (g_free (options), NULL);
					}
					goto __finally3;
					__catch3_g_option_error:
					{
						g_clear_error (&_inner_error0_);
						pamac_cli_display_list_help (self);
						return;
					}
					__finally3:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					if (help) {
						pamac_cli_display_list_help (self);
						return;
					}
					pamac_cli_init_transaction (self);
					if (installed) {
						if (orphans) {
							pamac_cli_list_orphans (self, quiet);
						} else {
							gboolean _tmp114_ = FALSE;
							gboolean _tmp115_ = FALSE;
							gboolean _tmp116_ = FALSE;
							if (foreign) {
								_tmp116_ = TRUE;
							} else {
								_tmp116_ = groups;
							}
							if (_tmp116_) {
								_tmp115_ = TRUE;
							} else {
								_tmp115_ = repos;
							}
							if (_tmp115_) {
								_tmp114_ = TRUE;
							} else {
								_tmp114_ = files;
							}
							if (_tmp114_) {
								pamac_cli_display_list_help (self);
							} else {
								pamac_cli_list_installed (self, quiet);
							}
						}
					} else {
						if (explicitly_installed) {
							gboolean _tmp117_ = FALSE;
							gboolean _tmp118_ = FALSE;
							gboolean _tmp119_ = FALSE;
							gboolean _tmp120_ = FALSE;
							if (orphans) {
								_tmp120_ = TRUE;
							} else {
								_tmp120_ = foreign;
							}
							if (_tmp120_) {
								_tmp119_ = TRUE;
							} else {
								_tmp119_ = groups;
							}
							if (_tmp119_) {
								_tmp118_ = TRUE;
							} else {
								_tmp118_ = repos;
							}
							if (_tmp118_) {
								_tmp117_ = TRUE;
							} else {
								_tmp117_ = files;
							}
							if (_tmp117_) {
								pamac_cli_display_list_help (self);
							} else {
								pamac_cli_list_explicitly_installed (self, quiet);
							}
						} else {
							if (orphans) {
								gboolean _tmp121_ = FALSE;
								gboolean _tmp122_ = FALSE;
								gboolean _tmp123_ = FALSE;
								if (foreign) {
									_tmp123_ = TRUE;
								} else {
									_tmp123_ = groups;
								}
								if (_tmp123_) {
									_tmp122_ = TRUE;
								} else {
									_tmp122_ = repos;
								}
								if (_tmp122_) {
									_tmp121_ = TRUE;
								} else {
									_tmp121_ = files;
								}
								if (_tmp121_) {
									pamac_cli_display_list_help (self);
								} else {
									pamac_cli_list_orphans (self, quiet);
								}
							} else {
								if (foreign) {
									gboolean _tmp124_ = FALSE;
									gboolean _tmp125_ = FALSE;
									gboolean _tmp126_ = FALSE;
									if (orphans) {
										_tmp126_ = TRUE;
									} else {
										_tmp126_ = groups;
									}
									if (_tmp126_) {
										_tmp125_ = TRUE;
									} else {
										_tmp125_ = repos;
									}
									if (_tmp125_) {
										_tmp124_ = TRUE;
									} else {
										_tmp124_ = files;
									}
									if (_tmp124_) {
										pamac_cli_display_list_help (self);
									} else {
										pamac_cli_list_foreign (self, quiet);
									}
								} else {
									if (groups) {
										gboolean _tmp127_ = FALSE;
										gboolean _tmp128_ = FALSE;
										gboolean _tmp129_ = FALSE;
										gboolean _tmp130_ = FALSE;
										if (installed) {
											_tmp130_ = TRUE;
										} else {
											_tmp130_ = orphans;
										}
										if (_tmp130_) {
											_tmp129_ = TRUE;
										} else {
											_tmp129_ = foreign;
										}
										if (_tmp129_) {
											_tmp128_ = TRUE;
										} else {
											_tmp128_ = repos;
										}
										if (_tmp128_) {
											_tmp127_ = TRUE;
										} else {
											_tmp127_ = files;
										}
										if (_tmp127_) {
											pamac_cli_display_list_help (self);
										} else {
											if (args_length1 > 2) {
												pamac_cli_list_groups (self, args + 2, (gint) (args_length1 - 2), quiet);
											} else {
												gchar** _tmp131_;
												gchar** _tmp132_;
												gint _tmp132__length1;
												_tmp131_ = g_new0 (gchar*, 0 + 1);
												_tmp132_ = _tmp131_;
												_tmp132__length1 = 0;
												pamac_cli_list_groups (self, _tmp132_, (gint) 0, quiet);
												_tmp132_ = (_vala_array_free (_tmp132_, _tmp132__length1, (GDestroyNotify) g_free), NULL);
											}
										}
									} else {
										if (repos) {
											gboolean _tmp133_ = FALSE;
											gboolean _tmp134_ = FALSE;
											gboolean _tmp135_ = FALSE;
											gboolean _tmp136_ = FALSE;
											if (installed) {
												_tmp136_ = TRUE;
											} else {
												_tmp136_ = orphans;
											}
											if (_tmp136_) {
												_tmp135_ = TRUE;
											} else {
												_tmp135_ = foreign;
											}
											if (_tmp135_) {
												_tmp134_ = TRUE;
											} else {
												_tmp134_ = groups;
											}
											if (_tmp134_) {
												_tmp133_ = TRUE;
											} else {
												_tmp133_ = files;
											}
											if (_tmp133_) {
												pamac_cli_display_list_help (self);
											} else {
												if (args_length1 > 2) {
													pamac_cli_list_repos (self, args + 2, (gint) (args_length1 - 2), quiet);
												} else {
													gchar** _tmp137_;
													gchar** _tmp138_;
													gint _tmp138__length1;
													_tmp137_ = g_new0 (gchar*, 0 + 1);
													_tmp138_ = _tmp137_;
													_tmp138__length1 = 0;
													pamac_cli_list_repos (self, _tmp138_, (gint) 0, quiet);
													_tmp138_ = (_vala_array_free (_tmp138_, _tmp138__length1, (GDestroyNotify) g_free), NULL);
												}
											}
										} else {
											if (files) {
												gboolean _tmp139_ = FALSE;
												gboolean _tmp140_ = FALSE;
												gboolean _tmp141_ = FALSE;
												gboolean _tmp142_ = FALSE;
												if (installed) {
													_tmp142_ = TRUE;
												} else {
													_tmp142_ = orphans;
												}
												if (_tmp142_) {
													_tmp141_ = TRUE;
												} else {
													_tmp141_ = foreign;
												}
												if (_tmp141_) {
													_tmp140_ = TRUE;
												} else {
													_tmp140_ = groups;
												}
												if (_tmp140_) {
													_tmp139_ = TRUE;
												} else {
													_tmp139_ = repos;
												}
												if (_tmp139_) {
													pamac_cli_display_list_help (self);
												} else {
													if (args_length1 > 2) {
														pamac_cli_list_files (self, args + 2, (gint) (args_length1 - 2), quiet);
													} else {
														pamac_cli_display_list_help (self);
													}
												}
											} else {
												FILE* _tmp143_;
												_tmp143_ = stdout;
												fprintf (_tmp143_, "%s\n", g_dgettext (NULL, "Error"));
												pamac_cli_display_list_help (self);
											}
										}
									}
								}
							}
						}
					}
				} else {
					pamac_cli_init_transaction (self);
					pamac_cli_list_installed (self, FALSE);
				}
			} else {
				const gchar* _tmp144_;
				_tmp144_ = args[1];
				if (g_strcmp0 (_tmp144_, "clone") == 0) {
					PamacDatabase* _tmp145_;
					PamacConfig* _tmp146_;
					PamacConfig* _tmp147_;
					gboolean _tmp148_;
					gboolean _tmp149_;
					pamac_cli_init_database (self);
					_tmp145_ = self->priv->database;
					_tmp146_ = pamac_database_get_config (_tmp145_);
					_tmp147_ = _tmp146_;
					_tmp148_ = pamac_config_get_support_aur (_tmp147_);
					_tmp149_ = _tmp148_;
					if (!_tmp149_) {
						g_warning ("cli.vala:314: AUR not supported");
						return;
					}
					if (args_length1 > 2) {
						gboolean overwrite = FALSE;
						gboolean recurse = FALSE;
						gboolean quiet = FALSE;
						gchar* builddir = NULL;
						PamacDatabase* _tmp166_;
						PamacConfig* _tmp167_;
						PamacConfig* _tmp168_;
						const gchar* _tmp169_;
						overwrite = FALSE;
						recurse = FALSE;
						quiet = FALSE;
						builddir = NULL;
						{
							GOptionEntry* options = NULL;
							GOptionEntry* _tmp150_;
							gint options_length1;
							gint _options_size_;
							GOptionEntry* _tmp151_;
							gint _tmp151__length1;
							GOptionEntry _tmp152_ = {0};
							GOptionEntry* _tmp153_;
							gint _tmp153__length1;
							GOptionEntry _tmp154_ = {0};
							GOptionEntry* _tmp155_;
							gint _tmp155__length1;
							GOptionEntry _tmp156_ = {0};
							GOptionEntry* _tmp157_;
							gint _tmp157__length1;
							GOptionEntry _tmp158_ = {0};
							GOptionEntry* _tmp159_;
							gint _tmp159__length1;
							GOptionEntry _tmp160_ = {0};
							GOptionContext* opt_context = NULL;
							GOptionContext* _tmp161_;
							GOptionContext* _tmp162_;
							GOptionContext* _tmp163_;
							GOptionEntry* _tmp164_;
							gint _tmp164__length1;
							GOptionContext* _tmp165_;
							_tmp150_ = g_new0 (GOptionEntry, 5);
							options = _tmp150_;
							options_length1 = 5;
							_options_size_ = options_length1;
							_tmp151_ = options;
							_tmp151__length1 = options_length1;
							_tmp152_.long_name = "help";
							_tmp152_.short_name = 'h';
							_tmp152_.flags = (gint) 0;
							_tmp152_.arg = G_OPTION_ARG_NONE;
							_tmp152_.arg_data = &help;
							_tmp152_.description = NULL;
							_tmp152_.arg_description = NULL;
							_tmp151_[0] = _tmp152_;
							_tmp153_ = options;
							_tmp153__length1 = options_length1;
							_tmp154_.long_name = "overwrite";
							_tmp154_.short_name = (gchar) 0;
							_tmp154_.flags = (gint) 0;
							_tmp154_.arg = G_OPTION_ARG_NONE;
							_tmp154_.arg_data = &overwrite;
							_tmp154_.description = NULL;
							_tmp154_.arg_description = NULL;
							_tmp153_[1] = _tmp154_;
							_tmp155_ = options;
							_tmp155__length1 = options_length1;
							_tmp156_.long_name = "recurse";
							_tmp156_.short_name = 'r';
							_tmp156_.flags = (gint) 0;
							_tmp156_.arg = G_OPTION_ARG_NONE;
							_tmp156_.arg_data = &recurse;
							_tmp156_.description = NULL;
							_tmp156_.arg_description = NULL;
							_tmp155_[2] = _tmp156_;
							_tmp157_ = options;
							_tmp157__length1 = options_length1;
							_tmp158_.long_name = "builddir";
							_tmp158_.short_name = (gchar) 0;
							_tmp158_.flags = (gint) 0;
							_tmp158_.arg = G_OPTION_ARG_STRING;
							_tmp158_.arg_data = &builddir;
							_tmp158_.description = NULL;
							_tmp158_.arg_description = NULL;
							_tmp157_[3] = _tmp158_;
							_tmp159_ = options;
							_tmp159__length1 = options_length1;
							_tmp160_.long_name = "quiet";
							_tmp160_.short_name = 'q';
							_tmp160_.flags = (gint) 0;
							_tmp160_.arg = G_OPTION_ARG_NONE;
							_tmp160_.arg_data = &quiet;
							_tmp160_.description = NULL;
							_tmp160_.arg_description = NULL;
							_tmp159_[4] = _tmp160_;
							_tmp161_ = g_option_context_new (NULL);
							opt_context = _tmp161_;
							_tmp162_ = opt_context;
							g_option_context_set_help_enabled (_tmp162_, FALSE);
							_tmp163_ = opt_context;
							_tmp164_ = options;
							_tmp164__length1 = options_length1;
							g_option_context_add_main_entries (_tmp163_, _tmp164_, NULL);
							_tmp165_ = opt_context;
							g_option_context_parse (_tmp165_, (gint*) (&args_length1), &args, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_option_context_free0 (opt_context);
								options = (g_free (options), NULL);
								if (_inner_error0_->domain == G_OPTION_ERROR) {
									goto __catch4_g_option_error;
								}
								_g_free0 (builddir);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
							_g_option_context_free0 (opt_context);
							options = (g_free (options), NULL);
						}
						goto __finally4;
						__catch4_g_option_error:
						{
							g_clear_error (&_inner_error0_);
							pamac_cli_display_clone_help (self);
							_g_free0 (builddir);
							return;
						}
						__finally4:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (builddir);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						if (help) {
							pamac_cli_display_clone_help (self);
							_g_free0 (builddir);
							return;
						}
						if (args_length1 == 2) {
							pamac_cli_display_clone_help (self);
							_g_free0 (builddir);
							return;
						}
						pamac_cli_init_transaction (self);
						_tmp166_ = self->priv->database;
						_tmp167_ = pamac_database_get_config (_tmp166_);
						_tmp168_ = _tmp167_;
						pamac_config_set_enable_aur (_tmp168_, TRUE);
						pamac_cli_get_aur_dest_variable (self);
						_tmp169_ = builddir;
						if (_tmp169_ != NULL) {
							PamacDatabase* _tmp170_;
							PamacConfig* _tmp171_;
							PamacConfig* _tmp172_;
							const gchar* _tmp173_;
							_tmp170_ = self->priv->database;
							_tmp171_ = pamac_database_get_config (_tmp170_);
							_tmp172_ = _tmp171_;
							_tmp173_ = builddir;
							pamac_config_set_aur_build_dir (_tmp172_, _tmp173_);
						}
						pamac_cli_clone_build_files (self, args + 2, (gint) (args_length1 - 2), overwrite, recurse, quiet);
						_g_free0 (builddir);
					} else {
						pamac_cli_display_clone_help (self);
					}
				} else {
					const gchar* _tmp174_;
					_tmp174_ = args[1];
					if (g_strcmp0 (_tmp174_, "build") == 0) {
						PamacDatabase* _tmp175_;
						PamacConfig* _tmp176_;
						PamacConfig* _tmp177_;
						gboolean _tmp178_;
						gboolean _tmp179_;
						gboolean no_clone = FALSE;
						gboolean no_confirm = FALSE;
						gboolean keep = FALSE;
						gboolean no_keep = FALSE;
						gboolean dry_run = FALSE;
						gchar* builddir = NULL;
						PamacDatabase* _tmp200_;
						PamacConfig* _tmp201_;
						PamacConfig* _tmp202_;
						pamac_cli_init_database (self);
						_tmp175_ = self->priv->database;
						_tmp176_ = pamac_database_get_config (_tmp175_);
						_tmp177_ = _tmp176_;
						_tmp178_ = pamac_config_get_support_aur (_tmp177_);
						_tmp179_ = _tmp178_;
						if (!_tmp179_) {
							g_warning ("cli.vala:359: AUR not supported");
							return;
						}
						no_clone = FALSE;
						no_confirm = FALSE;
						keep = FALSE;
						no_keep = FALSE;
						dry_run = FALSE;
						builddir = NULL;
						if (args_length1 > 2) {
							{
								GOptionEntry* options = NULL;
								GOptionEntry* _tmp180_;
								gint options_length1;
								gint _options_size_;
								GOptionEntry* _tmp181_;
								gint _tmp181__length1;
								GOptionEntry _tmp182_ = {0};
								GOptionEntry* _tmp183_;
								gint _tmp183__length1;
								GOptionEntry _tmp184_ = {0};
								GOptionEntry* _tmp185_;
								gint _tmp185__length1;
								GOptionEntry _tmp186_ = {0};
								GOptionEntry* _tmp187_;
								gint _tmp187__length1;
								GOptionEntry _tmp188_ = {0};
								GOptionEntry* _tmp189_;
								gint _tmp189__length1;
								GOptionEntry _tmp190_ = {0};
								GOptionEntry* _tmp191_;
								gint _tmp191__length1;
								GOptionEntry _tmp192_ = {0};
								GOptionEntry* _tmp193_;
								gint _tmp193__length1;
								GOptionEntry _tmp194_ = {0};
								GOptionContext* opt_context = NULL;
								GOptionContext* _tmp195_;
								GOptionContext* _tmp196_;
								GOptionContext* _tmp197_;
								GOptionEntry* _tmp198_;
								gint _tmp198__length1;
								GOptionContext* _tmp199_;
								_tmp180_ = g_new0 (GOptionEntry, 7);
								options = _tmp180_;
								options_length1 = 7;
								_options_size_ = options_length1;
								_tmp181_ = options;
								_tmp181__length1 = options_length1;
								_tmp182_.long_name = "help";
								_tmp182_.short_name = 'h';
								_tmp182_.flags = (gint) 0;
								_tmp182_.arg = G_OPTION_ARG_NONE;
								_tmp182_.arg_data = &help;
								_tmp182_.description = NULL;
								_tmp182_.arg_description = NULL;
								_tmp181_[0] = _tmp182_;
								_tmp183_ = options;
								_tmp183__length1 = options_length1;
								_tmp184_.long_name = "no-clone";
								_tmp184_.short_name = (gchar) 0;
								_tmp184_.flags = (gint) 0;
								_tmp184_.arg = G_OPTION_ARG_NONE;
								_tmp184_.arg_data = &no_clone;
								_tmp184_.description = NULL;
								_tmp184_.arg_description = NULL;
								_tmp183_[1] = _tmp184_;
								_tmp185_ = options;
								_tmp185__length1 = options_length1;
								_tmp186_.long_name = "no-confirm";
								_tmp186_.short_name = (gchar) 0;
								_tmp186_.flags = (gint) 0;
								_tmp186_.arg = G_OPTION_ARG_NONE;
								_tmp186_.arg_data = &no_confirm;
								_tmp186_.description = NULL;
								_tmp186_.arg_description = NULL;
								_tmp185_[2] = _tmp186_;
								_tmp187_ = options;
								_tmp187__length1 = options_length1;
								_tmp188_.long_name = "keep";
								_tmp188_.short_name = 'k';
								_tmp188_.flags = (gint) 0;
								_tmp188_.arg = G_OPTION_ARG_NONE;
								_tmp188_.arg_data = &keep;
								_tmp188_.description = NULL;
								_tmp188_.arg_description = NULL;
								_tmp187_[3] = _tmp188_;
								_tmp189_ = options;
								_tmp189__length1 = options_length1;
								_tmp190_.long_name = "no-keep";
								_tmp190_.short_name = (gchar) 0;
								_tmp190_.flags = (gint) 0;
								_tmp190_.arg = G_OPTION_ARG_NONE;
								_tmp190_.arg_data = &no_keep;
								_tmp190_.description = NULL;
								_tmp190_.arg_description = NULL;
								_tmp189_[4] = _tmp190_;
								_tmp191_ = options;
								_tmp191__length1 = options_length1;
								_tmp192_.long_name = "builddir";
								_tmp192_.short_name = (gchar) 0;
								_tmp192_.flags = (gint) 0;
								_tmp192_.arg = G_OPTION_ARG_STRING;
								_tmp192_.arg_data = &builddir;
								_tmp192_.description = NULL;
								_tmp192_.arg_description = NULL;
								_tmp191_[5] = _tmp192_;
								_tmp193_ = options;
								_tmp193__length1 = options_length1;
								_tmp194_.long_name = "dry-run";
								_tmp194_.short_name = 'd';
								_tmp194_.flags = (gint) 0;
								_tmp194_.arg = G_OPTION_ARG_NONE;
								_tmp194_.arg_data = &dry_run;
								_tmp194_.description = NULL;
								_tmp194_.arg_description = NULL;
								_tmp193_[6] = _tmp194_;
								_tmp195_ = g_option_context_new (NULL);
								opt_context = _tmp195_;
								_tmp196_ = opt_context;
								g_option_context_set_help_enabled (_tmp196_, FALSE);
								_tmp197_ = opt_context;
								_tmp198_ = options;
								_tmp198__length1 = options_length1;
								g_option_context_add_main_entries (_tmp197_, _tmp198_, NULL);
								_tmp199_ = opt_context;
								g_option_context_parse (_tmp199_, (gint*) (&args_length1), &args, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									_g_option_context_free0 (opt_context);
									options = (g_free (options), NULL);
									if (_inner_error0_->domain == G_OPTION_ERROR) {
										goto __catch5_g_option_error;
									}
									_g_free0 (builddir);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return;
								}
								_g_option_context_free0 (opt_context);
								options = (g_free (options), NULL);
							}
							goto __finally5;
							__catch5_g_option_error:
							{
								g_clear_error (&_inner_error0_);
								pamac_cli_display_build_help (self);
								_g_free0 (builddir);
								return;
							}
							__finally5:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_free0 (builddir);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
							if (help) {
								pamac_cli_display_build_help (self);
								_g_free0 (builddir);
								return;
							}
						}
						pamac_cli_init_transaction (self);
						_tmp200_ = self->priv->database;
						_tmp201_ = pamac_database_get_config (_tmp200_);
						_tmp202_ = _tmp201_;
						pamac_config_set_enable_aur (_tmp202_, TRUE);
						if (no_confirm) {
							PamacTransactionCli* _tmp203_;
							_tmp203_ = self->transaction;
							pamac_transaction_cli_set_no_confirm (_tmp203_, TRUE);
						}
						if (dry_run) {
							PamacTransactionCli* _tmp204_;
							_tmp204_ = self->transaction;
							pamac_transaction_set_dry_run ((PamacTransaction*) _tmp204_, TRUE);
						}
						if (keep) {
							PamacDatabase* _tmp205_;
							PamacConfig* _tmp206_;
							PamacConfig* _tmp207_;
							if (no_keep) {
								pamac_cli_display_build_help (self);
								_g_free0 (builddir);
								return;
							}
							_tmp205_ = self->priv->database;
							_tmp206_ = pamac_database_get_config (_tmp205_);
							_tmp207_ = _tmp206_;
							pamac_config_set_keep_built_pkgs (_tmp207_, TRUE);
						}
						if (no_keep) {
							PamacDatabase* _tmp208_;
							PamacConfig* _tmp209_;
							PamacConfig* _tmp210_;
							_tmp208_ = self->priv->database;
							_tmp209_ = pamac_database_get_config (_tmp208_);
							_tmp210_ = _tmp209_;
							pamac_config_set_keep_built_pkgs (_tmp210_, FALSE);
						}
						if (geteuid () == ((uid_t) 0)) {
							FILE* _tmp211_;
							FILE* _tmp212_;
							gchar* _tmp213_;
							gchar* _tmp214_;
							_tmp211_ = stdout;
							fprintf (_tmp211_, "%s: %s\n", g_dgettext (NULL, "Warning"), g_dgettext (NULL, "Building packages as dynamic user"));
							_tmp212_ = stdout;
							_tmp213_ = g_strdup_printf (g_dgettext (NULL, "Setting build directory to %s"), "/var/cache/pamac");
							_tmp214_ = _tmp213_;
							fprintf (_tmp212_, "%s: %s\n", g_dgettext (NULL, "Warning"), _tmp214_);
							_g_free0 (_tmp214_);
						} else {
							const gchar* _tmp215_;
							pamac_cli_get_aur_dest_variable (self);
							_tmp215_ = builddir;
							if (_tmp215_ != NULL) {
								PamacDatabase* _tmp216_;
								PamacConfig* _tmp217_;
								PamacConfig* _tmp218_;
								const gchar* _tmp219_;
								PamacDatabase* _tmp220_;
								PamacConfig* _tmp221_;
								PamacConfig* _tmp222_;
								_tmp216_ = self->priv->database;
								_tmp217_ = pamac_database_get_config (_tmp216_);
								_tmp218_ = _tmp217_;
								_tmp219_ = builddir;
								pamac_config_set_aur_build_dir (_tmp218_, _tmp219_);
								_tmp220_ = self->priv->database;
								_tmp221_ = pamac_database_get_config (_tmp220_);
								_tmp222_ = _tmp221_;
								pamac_config_set_keep_built_pkgs (_tmp222_, TRUE);
							}
						}
						if (args_length1 == 2) {
							GPtrArray* targets = NULL;
							GPtrArray* _tmp223_;
							GFile* current_dir = NULL;
							gchar* _tmp224_;
							gchar* _tmp225_;
							GFile* _tmp226_;
							GFile* _tmp227_;
							GFile* pkgbuild = NULL;
							GFile* _tmp228_;
							GFile* _tmp229_;
							GFile* _tmp230_;
							GFile* parent = NULL;
							GFile* _tmp233_;
							GFile* _tmp234_;
							GFile* _tmp235_;
							gchar* pkgbase = NULL;
							GFile* _tmp245_;
							gchar* _tmp246_;
							const gchar* _tmp247_;
							_tmp223_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
							targets = _tmp223_;
							_tmp224_ = g_get_current_dir ();
							_tmp225_ = _tmp224_;
							_tmp226_ = g_file_new_for_path (_tmp225_);
							_tmp227_ = _tmp226_;
							_g_free0 (_tmp225_);
							current_dir = _tmp227_;
							_tmp228_ = current_dir;
							_tmp229_ = g_file_get_child (_tmp228_, "PKGBUILD");
							pkgbuild = _tmp229_;
							_tmp230_ = pkgbuild;
							if (!g_file_query_exists (_tmp230_, NULL)) {
								FILE* _tmp231_;
								FILE* _tmp232_;
								_tmp231_ = stdout;
								fprintf (_tmp231_, "%s", g_dgettext (NULL, "No PKGBUILD file found in current directory"));
								_tmp232_ = stdout;
								fprintf (_tmp232_, "\n");
								_g_object_unref0 (pkgbuild);
								_g_object_unref0 (current_dir);
								_g_ptr_array_unref0 (targets);
								_g_free0 (builddir);
								return;
							}
							_tmp233_ = current_dir;
							_tmp234_ = g_file_get_parent (_tmp233_);
							parent = _tmp234_;
							_tmp235_ = parent;
							if (_tmp235_ != NULL) {
								PamacDatabase* _tmp236_;
								PamacConfig* _tmp237_;
								PamacConfig* _tmp238_;
								GFile* _tmp239_;
								gchar* _tmp240_;
								gchar* _tmp241_;
								PamacDatabase* _tmp242_;
								PamacConfig* _tmp243_;
								PamacConfig* _tmp244_;
								_tmp236_ = self->priv->database;
								_tmp237_ = pamac_database_get_config (_tmp236_);
								_tmp238_ = _tmp237_;
								_tmp239_ = parent;
								_tmp240_ = g_file_get_path (_tmp239_);
								_tmp241_ = _tmp240_;
								pamac_config_set_aur_build_dir (_tmp238_, _tmp241_);
								_g_free0 (_tmp241_);
								_tmp242_ = self->priv->database;
								_tmp243_ = pamac_database_get_config (_tmp242_);
								_tmp244_ = _tmp243_;
								pamac_config_set_keep_built_pkgs (_tmp244_, TRUE);
							}
							_tmp245_ = current_dir;
							_tmp246_ = g_file_get_basename (_tmp245_);
							pkgbase = _tmp246_;
							_tmp247_ = pkgbase;
							if (_tmp247_ != NULL) {
								gboolean success = FALSE;
								PamacDatabase* _tmp248_;
								const gchar* _tmp249_;
								_tmp248_ = self->priv->database;
								_tmp249_ = pkgbase;
								success = pamac_database_regenerate_srcinfo (_tmp248_, _tmp249_, NULL);
								if (success) {
									GPtrArray* pkgnames = NULL;
									GPtrArray* _tmp250_;
									GFile* srcinfo = NULL;
									GFile* _tmp251_;
									GFile* _tmp252_;
									_tmp250_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
									pkgnames = _tmp250_;
									_tmp251_ = current_dir;
									_tmp252_ = g_file_get_child (_tmp251_, ".SRCINFO");
									srcinfo = _tmp252_;
									{
										GFileInputStream* _tmp253_ = NULL;
										GFile* _tmp254_;
										GFileInputStream* _tmp255_;
										GDataInputStream* dis = NULL;
										GDataInputStream* _tmp256_;
										gchar* line = NULL;
										GPtrArray* _tmp272_;
										GPtrArray* _tmp276_;
										gpointer* _tmp277_;
										gint _tmp277__length1;
										_tmp254_ = srcinfo;
										_tmp255_ = g_file_read (_tmp254_, NULL, &_inner_error0_);
										_tmp253_ = _tmp255_;
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											goto __catch6_g_error;
										}
										_tmp256_ = g_data_input_stream_new ((GInputStream*) _tmp253_);
										dis = _tmp256_;
										while (TRUE) {
											gchar* _tmp257_ = NULL;
											GDataInputStream* _tmp258_;
											gchar* _tmp259_;
											gchar* _tmp260_;
											const gchar* _tmp261_;
											const gchar* _tmp262_;
											_tmp258_ = dis;
											_tmp259_ = g_data_input_stream_read_line (_tmp258_, NULL, NULL, &_inner_error0_);
											_tmp257_ = _tmp259_;
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
												_g_free0 (line);
												_g_object_unref0 (dis);
												_g_object_unref0 (_tmp253_);
												goto __catch6_g_error;
											}
											_tmp260_ = _tmp257_;
											_tmp257_ = NULL;
											_g_free0 (line);
											line = _tmp260_;
											_tmp261_ = line;
											if (!(_tmp261_ != NULL)) {
												_g_free0 (_tmp257_);
												break;
											}
											_tmp262_ = line;
											if (string_contains (_tmp262_, "pkgname = ")) {
												gchar* pkgname = NULL;
												const gchar* _tmp263_;
												gchar** _tmp264_;
												gchar** _tmp265_;
												gchar** _tmp266_;
												gint _tmp266__length1;
												const gchar* _tmp267_;
												gchar* _tmp268_;
												gchar* _tmp269_;
												GPtrArray* _tmp270_;
												gchar* _tmp271_;
												_tmp263_ = line;
												_tmp265_ = _tmp264_ = g_strsplit (_tmp263_, " = ", 2);
												_tmp266_ = _tmp265_;
												_tmp266__length1 = _vala_array_length (_tmp264_);
												_tmp267_ = _tmp266_[1];
												_tmp268_ = g_strdup (_tmp267_);
												_tmp269_ = _tmp268_;
												_tmp266_ = (_vala_array_free (_tmp266_, _tmp266__length1, (GDestroyNotify) g_free), NULL);
												pkgname = _tmp269_;
												_tmp270_ = pkgnames;
												_tmp271_ = pkgname;
												pkgname = NULL;
												g_ptr_array_add (_tmp270_, _tmp271_);
												_g_free0 (pkgname);
											}
											_g_free0 (_tmp257_);
										}
										_tmp272_ = pkgnames;
										{
											GPtrArray* name_collection = NULL;
											guint name_index = 0U;
											name_collection = _tmp272_;
											for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
												const gchar* name = NULL;
												name = (const gchar*) g_ptr_array_index (name_collection, name_index);
												{
													GPtrArray* _tmp273_;
													const gchar* _tmp274_;
													gchar* _tmp275_;
													_tmp273_ = targets;
													_tmp274_ = name;
													_tmp275_ = g_strdup (_tmp274_);
													g_ptr_array_add (_tmp273_, _tmp275_);
												}
											}
										}
										_tmp276_ = targets;
										_tmp277_ = _tmp276_->pdata;
										_tmp277__length1 = _tmp276_->len;
										pamac_cli_build_pkgs (self, _tmp277_, (gint) _tmp277__length1, FALSE, !no_clone);
										_g_free0 (line);
										_g_object_unref0 (dis);
										_g_object_unref0 (_tmp253_);
									}
									goto __finally6;
									__catch6_g_error:
									{
										GError* e = NULL;
										GError* _tmp278_;
										const gchar* _tmp279_;
										e = _inner_error0_;
										_inner_error0_ = NULL;
										_tmp278_ = e;
										_tmp279_ = _tmp278_->message;
										g_warning ("cli.vala:460: %s", _tmp279_);
										_g_error_free0 (e);
									}
									__finally6:
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_object_unref0 (srcinfo);
										_g_ptr_array_unref0 (pkgnames);
										_g_free0 (pkgbase);
										_g_object_unref0 (parent);
										_g_object_unref0 (pkgbuild);
										_g_object_unref0 (current_dir);
										_g_ptr_array_unref0 (targets);
										_g_free0 (builddir);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
									_g_object_unref0 (srcinfo);
									_g_ptr_array_unref0 (pkgnames);
								}
							}
							_g_free0 (pkgbase);
							_g_object_unref0 (parent);
							_g_object_unref0 (pkgbuild);
							_g_object_unref0 (current_dir);
							_g_ptr_array_unref0 (targets);
						} else {
							if (!no_clone) {
								GPtrArray* checked_targets = NULL;
								GPtrArray* _tmp280_;
								gboolean success = FALSE;
								gboolean _tmp281_;
								_tmp280_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
								checked_targets = _tmp280_;
								_tmp281_ = pamac_cli_check_build_pkgs (self, args + 2, (gint) (args_length1 - 2), no_confirm, &checked_targets);
								success = _tmp281_;
								if (success) {
									GPtrArray* _tmp282_;
									gpointer* _tmp283_;
									gint _tmp283__length1;
									_tmp282_ = checked_targets;
									_tmp283_ = _tmp282_->pdata;
									_tmp283__length1 = _tmp282_->len;
									pamac_cli_build_pkgs (self, _tmp283_, (gint) _tmp283__length1, TRUE, TRUE);
								}
								_g_ptr_array_unref0 (checked_targets);
							} else {
								pamac_cli_build_pkgs (self, args + 2, (gint) (args_length1 - 2), FALSE, FALSE);
							}
						}
						_g_free0 (builddir);
					} else {
						const gchar* _tmp284_;
						_tmp284_ = args[1];
						if (g_strcmp0 (_tmp284_, "install") == 0) {
							if (args_length1 > 2) {
								gboolean no_confirm = FALSE;
								gboolean upgrade = FALSE;
								gboolean no_upgrade = FALSE;
								gboolean download_only = FALSE;
								gboolean as_deps = FALSE;
								gboolean as_explicit = FALSE;
								gboolean dry_run = FALSE;
								gchar* overwrite = NULL;
								gchar* ignore = NULL;
								gboolean _tmp311_ = FALSE;
								const gchar* _tmp312_;
								const gchar* _tmp318_;
								no_confirm = FALSE;
								upgrade = FALSE;
								no_upgrade = FALSE;
								download_only = FALSE;
								as_deps = FALSE;
								as_explicit = FALSE;
								dry_run = FALSE;
								overwrite = NULL;
								ignore = NULL;
								{
									GOptionEntry* options = NULL;
									GOptionEntry* _tmp285_;
									gint options_length1;
									gint _options_size_;
									GOptionEntry* _tmp286_;
									gint _tmp286__length1;
									GOptionEntry _tmp287_ = {0};
									GOptionEntry* _tmp288_;
									gint _tmp288__length1;
									GOptionEntry _tmp289_ = {0};
									GOptionEntry* _tmp290_;
									gint _tmp290__length1;
									GOptionEntry _tmp291_ = {0};
									GOptionEntry* _tmp292_;
									gint _tmp292__length1;
									GOptionEntry _tmp293_ = {0};
									GOptionEntry* _tmp294_;
									gint _tmp294__length1;
									GOptionEntry _tmp295_ = {0};
									GOptionEntry* _tmp296_;
									gint _tmp296__length1;
									GOptionEntry _tmp297_ = {0};
									GOptionEntry* _tmp298_;
									gint _tmp298__length1;
									GOptionEntry _tmp299_ = {0};
									GOptionEntry* _tmp300_;
									gint _tmp300__length1;
									GOptionEntry _tmp301_ = {0};
									GOptionEntry* _tmp302_;
									gint _tmp302__length1;
									GOptionEntry _tmp303_ = {0};
									GOptionEntry* _tmp304_;
									gint _tmp304__length1;
									GOptionEntry _tmp305_ = {0};
									GOptionContext* opt_context = NULL;
									GOptionContext* _tmp306_;
									GOptionContext* _tmp307_;
									GOptionContext* _tmp308_;
									GOptionEntry* _tmp309_;
									gint _tmp309__length1;
									GOptionContext* _tmp310_;
									_tmp285_ = g_new0 (GOptionEntry, 10);
									options = _tmp285_;
									options_length1 = 10;
									_options_size_ = options_length1;
									_tmp286_ = options;
									_tmp286__length1 = options_length1;
									_tmp287_.long_name = "help";
									_tmp287_.short_name = 'h';
									_tmp287_.flags = (gint) 0;
									_tmp287_.arg = G_OPTION_ARG_NONE;
									_tmp287_.arg_data = &help;
									_tmp287_.description = NULL;
									_tmp287_.arg_description = NULL;
									_tmp286_[0] = _tmp287_;
									_tmp288_ = options;
									_tmp288__length1 = options_length1;
									_tmp289_.long_name = "no-confirm";
									_tmp289_.short_name = (gchar) 0;
									_tmp289_.flags = (gint) 0;
									_tmp289_.arg = G_OPTION_ARG_NONE;
									_tmp289_.arg_data = &no_confirm;
									_tmp289_.description = NULL;
									_tmp289_.arg_description = NULL;
									_tmp288_[1] = _tmp289_;
									_tmp290_ = options;
									_tmp290__length1 = options_length1;
									_tmp291_.long_name = "upgrade";
									_tmp291_.short_name = (gchar) 0;
									_tmp291_.flags = (gint) 0;
									_tmp291_.arg = G_OPTION_ARG_NONE;
									_tmp291_.arg_data = &upgrade;
									_tmp291_.description = NULL;
									_tmp291_.arg_description = NULL;
									_tmp290_[2] = _tmp291_;
									_tmp292_ = options;
									_tmp292__length1 = options_length1;
									_tmp293_.long_name = "no-upgrade";
									_tmp293_.short_name = (gchar) 0;
									_tmp293_.flags = (gint) 0;
									_tmp293_.arg = G_OPTION_ARG_NONE;
									_tmp293_.arg_data = &no_upgrade;
									_tmp293_.description = NULL;
									_tmp293_.arg_description = NULL;
									_tmp292_[3] = _tmp293_;
									_tmp294_ = options;
									_tmp294__length1 = options_length1;
									_tmp295_.long_name = "download-only";
									_tmp295_.short_name = 'w';
									_tmp295_.flags = (gint) 0;
									_tmp295_.arg = G_OPTION_ARG_NONE;
									_tmp295_.arg_data = &download_only;
									_tmp295_.description = NULL;
									_tmp295_.arg_description = NULL;
									_tmp294_[4] = _tmp295_;
									_tmp296_ = options;
									_tmp296__length1 = options_length1;
									_tmp297_.long_name = "as-deps";
									_tmp297_.short_name = (gchar) 0;
									_tmp297_.flags = (gint) 0;
									_tmp297_.arg = G_OPTION_ARG_NONE;
									_tmp297_.arg_data = &as_deps;
									_tmp297_.description = NULL;
									_tmp297_.arg_description = NULL;
									_tmp296_[5] = _tmp297_;
									_tmp298_ = options;
									_tmp298__length1 = options_length1;
									_tmp299_.long_name = "as-explicit";
									_tmp299_.short_name = (gchar) 0;
									_tmp299_.flags = (gint) 0;
									_tmp299_.arg = G_OPTION_ARG_NONE;
									_tmp299_.arg_data = &as_explicit;
									_tmp299_.description = NULL;
									_tmp299_.arg_description = NULL;
									_tmp298_[6] = _tmp299_;
									_tmp300_ = options;
									_tmp300__length1 = options_length1;
									_tmp301_.long_name = "overwrite";
									_tmp301_.short_name = (gchar) 0;
									_tmp301_.flags = (gint) 0;
									_tmp301_.arg = G_OPTION_ARG_STRING;
									_tmp301_.arg_data = &overwrite;
									_tmp301_.description = NULL;
									_tmp301_.arg_description = NULL;
									_tmp300_[7] = _tmp301_;
									_tmp302_ = options;
									_tmp302__length1 = options_length1;
									_tmp303_.long_name = "ignore";
									_tmp303_.short_name = (gchar) 0;
									_tmp303_.flags = (gint) 0;
									_tmp303_.arg = G_OPTION_ARG_STRING;
									_tmp303_.arg_data = &ignore;
									_tmp303_.description = NULL;
									_tmp303_.arg_description = NULL;
									_tmp302_[8] = _tmp303_;
									_tmp304_ = options;
									_tmp304__length1 = options_length1;
									_tmp305_.long_name = "dry-run";
									_tmp305_.short_name = 'd';
									_tmp305_.flags = (gint) 0;
									_tmp305_.arg = G_OPTION_ARG_NONE;
									_tmp305_.arg_data = &dry_run;
									_tmp305_.description = NULL;
									_tmp305_.arg_description = NULL;
									_tmp304_[9] = _tmp305_;
									_tmp306_ = g_option_context_new (NULL);
									opt_context = _tmp306_;
									_tmp307_ = opt_context;
									g_option_context_set_help_enabled (_tmp307_, FALSE);
									_tmp308_ = opt_context;
									_tmp309_ = options;
									_tmp309__length1 = options_length1;
									g_option_context_add_main_entries (_tmp308_, _tmp309_, NULL);
									_tmp310_ = opt_context;
									g_option_context_parse (_tmp310_, (gint*) (&args_length1), &args, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_option_context_free0 (opt_context);
										options = (g_free (options), NULL);
										if (_inner_error0_->domain == G_OPTION_ERROR) {
											goto __catch7_g_option_error;
										}
										_g_free0 (ignore);
										_g_free0 (overwrite);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
									_g_option_context_free0 (opt_context);
									options = (g_free (options), NULL);
								}
								goto __finally7;
								__catch7_g_option_error:
								{
									g_clear_error (&_inner_error0_);
									pamac_cli_display_install_help (self);
									_g_free0 (ignore);
									_g_free0 (overwrite);
									return;
								}
								__finally7:
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									_g_free0 (ignore);
									_g_free0 (overwrite);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return;
								}
								if (help) {
									pamac_cli_display_install_help (self);
									_g_free0 (ignore);
									_g_free0 (overwrite);
									return;
								}
								if (as_deps) {
									_tmp311_ = as_explicit;
								} else {
									_tmp311_ = FALSE;
								}
								if (_tmp311_) {
									pamac_cli_display_install_help (self);
									_g_free0 (ignore);
									_g_free0 (overwrite);
									return;
								}
								if (args_length1 == 2) {
									pamac_cli_display_install_help (self);
									_g_free0 (ignore);
									_g_free0 (overwrite);
									return;
								}
								pamac_cli_init_transaction (self);
								pamac_cli_get_aur_dest_variable (self);
								_tmp312_ = overwrite;
								if (_tmp312_ != NULL) {
									const gchar* _tmp313_;
									gchar** _tmp314_;
									gchar** _tmp315_;
									_tmp313_ = overwrite;
									_tmp315_ = _tmp314_ = g_strsplit (_tmp313_, ",", 0);
									{
										gchar** glob_collection = NULL;
										gint glob_collection_length1 = 0;
										gint _glob_collection_size_ = 0;
										gint glob_it = 0;
										glob_collection = _tmp315_;
										glob_collection_length1 = _vala_array_length (_tmp314_);
										for (glob_it = 0; glob_it < glob_collection_length1; glob_it = glob_it + 1) {
											const gchar* glob = NULL;
											glob = glob_collection[glob_it];
											{
												PamacTransactionCli* _tmp316_;
												const gchar* _tmp317_;
												_tmp316_ = self->transaction;
												_tmp317_ = glob;
												pamac_transaction_add_overwrite_file ((PamacTransaction*) _tmp316_, _tmp317_);
											}
										}
										glob_collection = (_vala_array_free (glob_collection, glob_collection_length1, (GDestroyNotify) g_free), NULL);
									}
								}
								_tmp318_ = ignore;
								if (_tmp318_ != NULL) {
									const gchar* _tmp319_;
									gchar** _tmp320_;
									gchar** _tmp321_;
									_tmp319_ = ignore;
									_tmp321_ = _tmp320_ = g_strsplit (_tmp319_, ",", 0);
									{
										gchar** name_collection = NULL;
										gint name_collection_length1 = 0;
										gint _name_collection_size_ = 0;
										gint name_it = 0;
										name_collection = _tmp321_;
										name_collection_length1 = _vala_array_length (_tmp320_);
										for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
											const gchar* name = NULL;
											name = name_collection[name_it];
											{
												PamacTransactionCli* _tmp322_;
												const gchar* _tmp323_;
												_tmp322_ = self->transaction;
												_tmp323_ = name;
												pamac_transaction_add_temporary_ignore_pkg ((PamacTransaction*) _tmp322_, _tmp323_);
											}
										}
										name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
									}
								}
								if (no_confirm) {
									PamacTransactionCli* _tmp324_;
									_tmp324_ = self->transaction;
									pamac_transaction_cli_set_no_confirm (_tmp324_, TRUE);
								}
								if (dry_run) {
									PamacTransactionCli* _tmp325_;
									_tmp325_ = self->transaction;
									pamac_transaction_set_dry_run ((PamacTransaction*) _tmp325_, TRUE);
								}
								if (upgrade) {
									PamacTransactionCli* _tmp326_;
									PamacDatabase* _tmp327_;
									PamacDatabase* _tmp328_;
									PamacConfig* _tmp329_;
									PamacConfig* _tmp330_;
									if (no_upgrade) {
										pamac_cli_display_install_help (self);
										_g_free0 (ignore);
										_g_free0 (overwrite);
										return;
									}
									_tmp326_ = self->transaction;
									_tmp327_ = pamac_transaction_get_database ((PamacTransaction*) _tmp326_);
									_tmp328_ = _tmp327_;
									_tmp329_ = pamac_database_get_config (_tmp328_);
									_tmp330_ = _tmp329_;
									pamac_config_set_simple_install (_tmp330_, FALSE);
								}
								if (no_upgrade) {
									PamacTransactionCli* _tmp331_;
									PamacDatabase* _tmp332_;
									PamacDatabase* _tmp333_;
									PamacConfig* _tmp334_;
									PamacConfig* _tmp335_;
									_tmp331_ = self->transaction;
									_tmp332_ = pamac_transaction_get_database ((PamacTransaction*) _tmp331_);
									_tmp333_ = _tmp332_;
									_tmp334_ = pamac_database_get_config (_tmp333_);
									_tmp335_ = _tmp334_;
									pamac_config_set_simple_install (_tmp335_, TRUE);
								}
								if (download_only) {
									PamacTransactionCli* _tmp336_;
									_tmp336_ = self->transaction;
									pamac_transaction_set_download_only ((PamacTransaction*) _tmp336_, TRUE);
								}
								if (as_deps) {
									PamacTransactionCli* _tmp337_;
									_tmp337_ = self->transaction;
									pamac_transaction_set_install_as_dep ((PamacTransaction*) _tmp337_, TRUE);
								}
								if (as_explicit) {
									PamacTransactionCli* _tmp338_;
									_tmp338_ = self->transaction;
									pamac_transaction_set_install_as_explicit ((PamacTransaction*) _tmp338_, TRUE);
								}
								pamac_cli_install_pkgs (self, args + 2, (gint) (args_length1 - 2));
								_g_free0 (ignore);
								_g_free0 (overwrite);
							} else {
								pamac_cli_display_install_help (self);
							}
						} else {
							const gchar* _tmp339_;
							_tmp339_ = args[1];
							if (g_strcmp0 (_tmp339_, "reinstall") == 0) {
								if (args_length1 > 2) {
									gboolean no_confirm = FALSE;
									gboolean download_only = FALSE;
									gboolean as_deps = FALSE;
									gboolean as_explicit = FALSE;
									gchar* overwrite = NULL;
									gboolean _tmp358_ = FALSE;
									const gchar* _tmp359_;
									PamacTransactionCli* _tmp369_;
									PamacDatabase* _tmp370_;
									PamacDatabase* _tmp371_;
									PamacConfig* _tmp372_;
									PamacConfig* _tmp373_;
									no_confirm = FALSE;
									download_only = FALSE;
									as_deps = FALSE;
									as_explicit = FALSE;
									overwrite = NULL;
									{
										GOptionEntry* options = NULL;
										GOptionEntry* _tmp340_;
										gint options_length1;
										gint _options_size_;
										GOptionEntry* _tmp341_;
										gint _tmp341__length1;
										GOptionEntry _tmp342_ = {0};
										GOptionEntry* _tmp343_;
										gint _tmp343__length1;
										GOptionEntry _tmp344_ = {0};
										GOptionEntry* _tmp345_;
										gint _tmp345__length1;
										GOptionEntry _tmp346_ = {0};
										GOptionEntry* _tmp347_;
										gint _tmp347__length1;
										GOptionEntry _tmp348_ = {0};
										GOptionEntry* _tmp349_;
										gint _tmp349__length1;
										GOptionEntry _tmp350_ = {0};
										GOptionEntry* _tmp351_;
										gint _tmp351__length1;
										GOptionEntry _tmp352_ = {0};
										GOptionContext* opt_context = NULL;
										GOptionContext* _tmp353_;
										GOptionContext* _tmp354_;
										GOptionContext* _tmp355_;
										GOptionEntry* _tmp356_;
										gint _tmp356__length1;
										GOptionContext* _tmp357_;
										_tmp340_ = g_new0 (GOptionEntry, 6);
										options = _tmp340_;
										options_length1 = 6;
										_options_size_ = options_length1;
										_tmp341_ = options;
										_tmp341__length1 = options_length1;
										_tmp342_.long_name = "help";
										_tmp342_.short_name = 'h';
										_tmp342_.flags = (gint) 0;
										_tmp342_.arg = G_OPTION_ARG_NONE;
										_tmp342_.arg_data = &help;
										_tmp342_.description = NULL;
										_tmp342_.arg_description = NULL;
										_tmp341_[0] = _tmp342_;
										_tmp343_ = options;
										_tmp343__length1 = options_length1;
										_tmp344_.long_name = "no-confirm";
										_tmp344_.short_name = (gchar) 0;
										_tmp344_.flags = (gint) 0;
										_tmp344_.arg = G_OPTION_ARG_NONE;
										_tmp344_.arg_data = &no_confirm;
										_tmp344_.description = NULL;
										_tmp344_.arg_description = NULL;
										_tmp343_[1] = _tmp344_;
										_tmp345_ = options;
										_tmp345__length1 = options_length1;
										_tmp346_.long_name = "download-only";
										_tmp346_.short_name = 'w';
										_tmp346_.flags = (gint) 0;
										_tmp346_.arg = G_OPTION_ARG_NONE;
										_tmp346_.arg_data = &download_only;
										_tmp346_.description = NULL;
										_tmp346_.arg_description = NULL;
										_tmp345_[2] = _tmp346_;
										_tmp347_ = options;
										_tmp347__length1 = options_length1;
										_tmp348_.long_name = "as-deps";
										_tmp348_.short_name = (gchar) 0;
										_tmp348_.flags = (gint) 0;
										_tmp348_.arg = G_OPTION_ARG_NONE;
										_tmp348_.arg_data = &as_deps;
										_tmp348_.description = NULL;
										_tmp348_.arg_description = NULL;
										_tmp347_[3] = _tmp348_;
										_tmp349_ = options;
										_tmp349__length1 = options_length1;
										_tmp350_.long_name = "as-explicit";
										_tmp350_.short_name = (gchar) 0;
										_tmp350_.flags = (gint) 0;
										_tmp350_.arg = G_OPTION_ARG_NONE;
										_tmp350_.arg_data = &as_explicit;
										_tmp350_.description = NULL;
										_tmp350_.arg_description = NULL;
										_tmp349_[4] = _tmp350_;
										_tmp351_ = options;
										_tmp351__length1 = options_length1;
										_tmp352_.long_name = "overwrite";
										_tmp352_.short_name = (gchar) 0;
										_tmp352_.flags = (gint) 0;
										_tmp352_.arg = G_OPTION_ARG_STRING;
										_tmp352_.arg_data = &overwrite;
										_tmp352_.description = NULL;
										_tmp352_.arg_description = NULL;
										_tmp351_[5] = _tmp352_;
										_tmp353_ = g_option_context_new (NULL);
										opt_context = _tmp353_;
										_tmp354_ = opt_context;
										g_option_context_set_help_enabled (_tmp354_, FALSE);
										_tmp355_ = opt_context;
										_tmp356_ = options;
										_tmp356__length1 = options_length1;
										g_option_context_add_main_entries (_tmp355_, _tmp356_, NULL);
										_tmp357_ = opt_context;
										g_option_context_parse (_tmp357_, (gint*) (&args_length1), &args, &_inner_error0_);
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											_g_option_context_free0 (opt_context);
											options = (g_free (options), NULL);
											if (_inner_error0_->domain == G_OPTION_ERROR) {
												goto __catch8_g_option_error;
											}
											_g_free0 (overwrite);
											g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
										_g_option_context_free0 (opt_context);
										options = (g_free (options), NULL);
									}
									goto __finally8;
									__catch8_g_option_error:
									{
										g_clear_error (&_inner_error0_);
										pamac_cli_display_reinstall_help (self);
										_g_free0 (overwrite);
										return;
									}
									__finally8:
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_free0 (overwrite);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
									if (help) {
										pamac_cli_display_reinstall_help (self);
										_g_free0 (overwrite);
										return;
									}
									if (as_deps) {
										_tmp358_ = as_explicit;
									} else {
										_tmp358_ = FALSE;
									}
									if (_tmp358_) {
										pamac_cli_display_reinstall_help (self);
										_g_free0 (overwrite);
										return;
									}
									if (args_length1 == 2) {
										pamac_cli_display_reinstall_help (self);
										_g_free0 (overwrite);
										return;
									}
									pamac_cli_init_transaction (self);
									_tmp359_ = overwrite;
									if (_tmp359_ != NULL) {
										const gchar* _tmp360_;
										gchar** _tmp361_;
										gchar** _tmp362_;
										_tmp360_ = overwrite;
										_tmp362_ = _tmp361_ = g_strsplit (_tmp360_, ",", 0);
										{
											gchar** glob_collection = NULL;
											gint glob_collection_length1 = 0;
											gint _glob_collection_size_ = 0;
											gint glob_it = 0;
											glob_collection = _tmp362_;
											glob_collection_length1 = _vala_array_length (_tmp361_);
											for (glob_it = 0; glob_it < glob_collection_length1; glob_it = glob_it + 1) {
												const gchar* glob = NULL;
												glob = glob_collection[glob_it];
												{
													PamacTransactionCli* _tmp363_;
													const gchar* _tmp364_;
													_tmp363_ = self->transaction;
													_tmp364_ = glob;
													pamac_transaction_add_overwrite_file ((PamacTransaction*) _tmp363_, _tmp364_);
												}
											}
											glob_collection = (_vala_array_free (glob_collection, glob_collection_length1, (GDestroyNotify) g_free), NULL);
										}
									}
									if (no_confirm) {
										PamacTransactionCli* _tmp365_;
										_tmp365_ = self->transaction;
										pamac_transaction_cli_set_no_confirm (_tmp365_, TRUE);
									}
									if (download_only) {
										PamacTransactionCli* _tmp366_;
										_tmp366_ = self->transaction;
										pamac_transaction_set_download_only ((PamacTransaction*) _tmp366_, TRUE);
									}
									if (as_deps) {
										PamacTransactionCli* _tmp367_;
										_tmp367_ = self->transaction;
										pamac_transaction_set_install_as_dep ((PamacTransaction*) _tmp367_, TRUE);
									}
									if (as_explicit) {
										PamacTransactionCli* _tmp368_;
										_tmp368_ = self->transaction;
										pamac_transaction_set_install_as_explicit ((PamacTransaction*) _tmp368_, TRUE);
									}
									_tmp369_ = self->transaction;
									_tmp370_ = pamac_transaction_get_database ((PamacTransaction*) _tmp369_);
									_tmp371_ = _tmp370_;
									_tmp372_ = pamac_database_get_config (_tmp371_);
									_tmp373_ = _tmp372_;
									pamac_config_set_simple_install (_tmp373_, TRUE);
									pamac_cli_reinstall_pkgs (self, args + 2, (gint) (args_length1 - 2));
									_g_free0 (overwrite);
								} else {
									pamac_cli_display_reinstall_help (self);
								}
							} else {
								const gchar* _tmp374_;
								_tmp374_ = args[1];
								if (g_strcmp0 (_tmp374_, "remove") == 0) {
									if (args_length1 > 2) {
										gboolean no_confirm = FALSE;
										gboolean no_save = FALSE;
										gboolean orphans = FALSE;
										gboolean no_orphans = FALSE;
										gboolean unneeded = FALSE;
										gboolean dry_run = FALSE;
										gboolean cascade = FALSE;
										no_confirm = FALSE;
										no_save = FALSE;
										orphans = FALSE;
										no_orphans = FALSE;
										unneeded = FALSE;
										dry_run = FALSE;
										cascade = FALSE;
										{
											GOptionEntry* options = NULL;
											GOptionEntry* _tmp375_;
											gint options_length1;
											gint _options_size_;
											GOptionEntry* _tmp376_;
											gint _tmp376__length1;
											GOptionEntry _tmp377_ = {0};
											GOptionEntry* _tmp378_;
											gint _tmp378__length1;
											GOptionEntry _tmp379_ = {0};
											GOptionEntry* _tmp380_;
											gint _tmp380__length1;
											GOptionEntry _tmp381_ = {0};
											GOptionEntry* _tmp382_;
											gint _tmp382__length1;
											GOptionEntry _tmp383_ = {0};
											GOptionEntry* _tmp384_;
											gint _tmp384__length1;
											GOptionEntry _tmp385_ = {0};
											GOptionEntry* _tmp386_;
											gint _tmp386__length1;
											GOptionEntry _tmp387_ = {0};
											GOptionEntry* _tmp388_;
											gint _tmp388__length1;
											GOptionEntry _tmp389_ = {0};
											GOptionEntry* _tmp390_;
											gint _tmp390__length1;
											GOptionEntry _tmp391_ = {0};
											GOptionContext* opt_context = NULL;
											GOptionContext* _tmp392_;
											GOptionContext* _tmp393_;
											GOptionContext* _tmp394_;
											GOptionEntry* _tmp395_;
											gint _tmp395__length1;
											GOptionContext* _tmp396_;
											_tmp375_ = g_new0 (GOptionEntry, 8);
											options = _tmp375_;
											options_length1 = 8;
											_options_size_ = options_length1;
											_tmp376_ = options;
											_tmp376__length1 = options_length1;
											_tmp377_.long_name = "help";
											_tmp377_.short_name = 'h';
											_tmp377_.flags = (gint) 0;
											_tmp377_.arg = G_OPTION_ARG_NONE;
											_tmp377_.arg_data = &help;
											_tmp377_.description = NULL;
											_tmp377_.arg_description = NULL;
											_tmp376_[0] = _tmp377_;
											_tmp378_ = options;
											_tmp378__length1 = options_length1;
											_tmp379_.long_name = "no-confirm";
											_tmp379_.short_name = (gchar) 0;
											_tmp379_.flags = (gint) 0;
											_tmp379_.arg = G_OPTION_ARG_NONE;
											_tmp379_.arg_data = &no_confirm;
											_tmp379_.description = NULL;
											_tmp379_.arg_description = NULL;
											_tmp378_[1] = _tmp379_;
											_tmp380_ = options;
											_tmp380__length1 = options_length1;
											_tmp381_.long_name = "orphans";
											_tmp381_.short_name = 'o';
											_tmp381_.flags = (gint) 0;
											_tmp381_.arg = G_OPTION_ARG_NONE;
											_tmp381_.arg_data = &orphans;
											_tmp381_.description = NULL;
											_tmp381_.arg_description = NULL;
											_tmp380_[2] = _tmp381_;
											_tmp382_ = options;
											_tmp382__length1 = options_length1;
											_tmp383_.long_name = "no-orphans";
											_tmp383_.short_name = (gchar) 0;
											_tmp383_.flags = (gint) 0;
											_tmp383_.arg = G_OPTION_ARG_NONE;
											_tmp383_.arg_data = &no_orphans;
											_tmp383_.description = NULL;
											_tmp383_.arg_description = NULL;
											_tmp382_[3] = _tmp383_;
											_tmp384_ = options;
											_tmp384__length1 = options_length1;
											_tmp385_.long_name = "unneeded";
											_tmp385_.short_name = 'u';
											_tmp385_.flags = (gint) 0;
											_tmp385_.arg = G_OPTION_ARG_NONE;
											_tmp385_.arg_data = &unneeded;
											_tmp385_.description = NULL;
											_tmp385_.arg_description = NULL;
											_tmp384_[4] = _tmp385_;
											_tmp386_ = options;
											_tmp386__length1 = options_length1;
											_tmp387_.long_name = "no-save";
											_tmp387_.short_name = 'n';
											_tmp387_.flags = (gint) 0;
											_tmp387_.arg = G_OPTION_ARG_NONE;
											_tmp387_.arg_data = &no_save;
											_tmp387_.description = NULL;
											_tmp387_.arg_description = NULL;
											_tmp386_[5] = _tmp387_;
											_tmp388_ = options;
											_tmp388__length1 = options_length1;
											_tmp389_.long_name = "dry-run";
											_tmp389_.short_name = 'd';
											_tmp389_.flags = (gint) 0;
											_tmp389_.arg = G_OPTION_ARG_NONE;
											_tmp389_.arg_data = &dry_run;
											_tmp389_.description = NULL;
											_tmp389_.arg_description = NULL;
											_tmp388_[6] = _tmp389_;
											_tmp390_ = options;
											_tmp390__length1 = options_length1;
											_tmp391_.long_name = "cascade";
											_tmp391_.short_name = 'c';
											_tmp391_.flags = (gint) 0;
											_tmp391_.arg = G_OPTION_ARG_NONE;
											_tmp391_.arg_data = &cascade;
											_tmp391_.description = NULL;
											_tmp391_.arg_description = NULL;
											_tmp390_[7] = _tmp391_;
											_tmp392_ = g_option_context_new (NULL);
											opt_context = _tmp392_;
											_tmp393_ = opt_context;
											g_option_context_set_help_enabled (_tmp393_, FALSE);
											_tmp394_ = opt_context;
											_tmp395_ = options;
											_tmp395__length1 = options_length1;
											g_option_context_add_main_entries (_tmp394_, _tmp395_, NULL);
											_tmp396_ = opt_context;
											g_option_context_parse (_tmp396_, (gint*) (&args_length1), &args, &_inner_error0_);
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
												_g_option_context_free0 (opt_context);
												options = (g_free (options), NULL);
												if (_inner_error0_->domain == G_OPTION_ERROR) {
													goto __catch9_g_option_error;
												}
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
												g_clear_error (&_inner_error0_);
												return;
											}
											_g_option_context_free0 (opt_context);
											options = (g_free (options), NULL);
										}
										goto __finally9;
										__catch9_g_option_error:
										{
											g_clear_error (&_inner_error0_);
											pamac_cli_display_remove_help (self);
											return;
										}
										__finally9:
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
										if (help) {
											pamac_cli_display_remove_help (self);
											return;
										}
										if (args_length1 == 2) {
											if (orphans) {
												if (no_orphans) {
													pamac_cli_display_remove_help (self);
													return;
												}
											} else {
												pamac_cli_display_remove_help (self);
												return;
											}
										}
										pamac_cli_init_transaction (self);
										if (no_confirm) {
											PamacTransactionCli* _tmp397_;
											_tmp397_ = self->transaction;
											pamac_transaction_cli_set_no_confirm (_tmp397_, TRUE);
										}
										if (dry_run) {
											PamacTransactionCli* _tmp398_;
											_tmp398_ = self->transaction;
											pamac_transaction_set_dry_run ((PamacTransaction*) _tmp398_, TRUE);
										}
										if (orphans) {
											PamacDatabase* _tmp399_;
											PamacConfig* _tmp400_;
											PamacConfig* _tmp401_;
											if (no_orphans) {
												pamac_cli_display_remove_help (self);
												return;
											}
											_tmp399_ = self->priv->database;
											_tmp400_ = pamac_database_get_config (_tmp399_);
											_tmp401_ = _tmp400_;
											pamac_config_set_recurse (_tmp401_, TRUE);
										}
										if (no_orphans) {
											PamacDatabase* _tmp402_;
											PamacConfig* _tmp403_;
											PamacConfig* _tmp404_;
											if (orphans) {
												pamac_cli_display_remove_help (self);
												return;
											}
											_tmp402_ = self->priv->database;
											_tmp403_ = pamac_database_get_config (_tmp402_);
											_tmp404_ = _tmp403_;
											pamac_config_set_recurse (_tmp404_, FALSE);
										}
										if (unneeded) {
											PamacTransactionCli* _tmp405_;
											_tmp405_ = self->transaction;
											pamac_transaction_set_remove_if_unneeded ((PamacTransaction*) _tmp405_, TRUE);
										}
										if (cascade) {
											PamacTransactionCli* _tmp406_;
											_tmp406_ = self->transaction;
											pamac_transaction_set_cascade ((PamacTransaction*) _tmp406_, TRUE);
										}
										if (no_save) {
											PamacTransactionCli* _tmp407_;
											_tmp407_ = self->transaction;
											pamac_transaction_set_keep_config_files ((PamacTransaction*) _tmp407_, FALSE);
										}
										if (args_length1 == 2) {
											pamac_cli_remove_orphans (self);
										} else {
											pamac_cli_remove_pkgs (self, args + 2, (gint) (args_length1 - 2));
										}
									} else {
										pamac_cli_display_remove_help (self);
									}
								} else {
									const gchar* _tmp408_;
									_tmp408_ = args[1];
									if (g_strcmp0 (_tmp408_, "checkupdates") == 0) {
										gboolean quiet = FALSE;
										gboolean aur = FALSE;
										gboolean no_aur = FALSE;
										gboolean devel = FALSE;
										gboolean no_devel = FALSE;
										gboolean refresh_tmp_files_dbs = FALSE;
										gboolean download_updates = FALSE;
										gchar* builddir = NULL;
										PamacDatabase* _tmp453_;
										PamacConfig* _tmp454_;
										PamacConfig* _tmp455_;
										gboolean _tmp456_;
										gboolean _tmp457_;
										quiet = FALSE;
										aur = FALSE;
										no_aur = FALSE;
										devel = FALSE;
										no_devel = FALSE;
										refresh_tmp_files_dbs = FALSE;
										download_updates = FALSE;
										builddir = NULL;
										{
											GOptionEntry* options = NULL;
											GOptionEntry* _tmp409_;
											gint options_length1;
											gint _options_size_;
											GOptionEntry* _tmp410_;
											gint _tmp410__length1;
											GOptionEntry _tmp411_ = {0};
											GOptionEntry* _tmp412_;
											gint _tmp412__length1;
											GOptionEntry _tmp413_ = {0};
											GOptionEntry* _tmp414_;
											gint _tmp414__length1;
											GOptionEntry _tmp415_ = {0};
											GOptionEntry* _tmp416_;
											gint _tmp416__length1;
											GOptionEntry _tmp417_ = {0};
											GOptionEntry* _tmp418_;
											gint _tmp418__length1;
											GOptionEntry _tmp419_ = {0};
											GOptionEntry* _tmp420_;
											gint _tmp420__length1;
											GOptionEntry _tmp421_ = {0};
											GOptionEntry* _tmp422_;
											gint _tmp422__length1;
											GOptionEntry _tmp423_ = {0};
											GOptionEntry* _tmp424_;
											gint _tmp424__length1;
											GOptionEntry _tmp425_ = {0};
											GOptionEntry* _tmp426_;
											gint _tmp426__length1;
											GOptionEntry _tmp427_ = {0};
											GOptionContext* opt_context = NULL;
											GOptionContext* _tmp428_;
											GOptionContext* _tmp429_;
											GOptionContext* _tmp430_;
											GOptionEntry* _tmp431_;
											gint _tmp431__length1;
											GOptionContext* _tmp432_;
											_tmp409_ = g_new0 (GOptionEntry, 10);
											options = _tmp409_;
											options_length1 = 10;
											_options_size_ = options_length1;
											_tmp410_ = options;
											_tmp410__length1 = options_length1;
											_tmp411_.long_name = "help";
											_tmp411_.short_name = 'h';
											_tmp411_.flags = (gint) 0;
											_tmp411_.arg = G_OPTION_ARG_NONE;
											_tmp411_.arg_data = &help;
											_tmp411_.description = NULL;
											_tmp411_.arg_description = NULL;
											_tmp410_[0] = _tmp411_;
											_tmp412_ = options;
											_tmp412__length1 = options_length1;
											_tmp413_.long_name = "quiet";
											_tmp413_.short_name = 'q';
											_tmp413_.flags = (gint) 0;
											_tmp413_.arg = G_OPTION_ARG_NONE;
											_tmp413_.arg_data = &quiet;
											_tmp413_.description = NULL;
											_tmp413_.arg_description = NULL;
											_tmp412_[1] = _tmp413_;
											_tmp414_ = options;
											_tmp414__length1 = options_length1;
											_tmp415_.long_name = "aur";
											_tmp415_.short_name = 'a';
											_tmp415_.flags = (gint) 0;
											_tmp415_.arg = G_OPTION_ARG_NONE;
											_tmp415_.arg_data = &aur;
											_tmp415_.description = NULL;
											_tmp415_.arg_description = NULL;
											_tmp414_[2] = _tmp415_;
											_tmp416_ = options;
											_tmp416__length1 = options_length1;
											_tmp417_.long_name = "no-aur";
											_tmp417_.short_name = (gchar) 0;
											_tmp417_.flags = (gint) 0;
											_tmp417_.arg = G_OPTION_ARG_NONE;
											_tmp417_.arg_data = &no_aur;
											_tmp417_.description = NULL;
											_tmp417_.arg_description = NULL;
											_tmp416_[3] = _tmp417_;
											_tmp418_ = options;
											_tmp418__length1 = options_length1;
											_tmp419_.long_name = "devel";
											_tmp419_.short_name = (gchar) 0;
											_tmp419_.flags = (gint) 0;
											_tmp419_.arg = G_OPTION_ARG_NONE;
											_tmp419_.arg_data = &devel;
											_tmp419_.description = NULL;
											_tmp419_.arg_description = NULL;
											_tmp418_[4] = _tmp419_;
											_tmp420_ = options;
											_tmp420__length1 = options_length1;
											_tmp421_.long_name = "no-devel";
											_tmp421_.short_name = (gchar) 0;
											_tmp421_.flags = (gint) 0;
											_tmp421_.arg = G_OPTION_ARG_NONE;
											_tmp421_.arg_data = &no_devel;
											_tmp421_.description = NULL;
											_tmp421_.arg_description = NULL;
											_tmp420_[5] = _tmp421_;
											_tmp422_ = options;
											_tmp422__length1 = options_length1;
											_tmp423_.long_name = "builddir";
											_tmp423_.short_name = (gchar) 0;
											_tmp423_.flags = (gint) 0;
											_tmp423_.arg = G_OPTION_ARG_STRING;
											_tmp423_.arg_data = &builddir;
											_tmp423_.description = NULL;
											_tmp423_.arg_description = NULL;
											_tmp422_[6] = _tmp423_;
											_tmp424_ = options;
											_tmp424__length1 = options_length1;
											_tmp425_.long_name = "refresh-tmp-files-dbs";
											_tmp425_.short_name = (gchar) 0;
											_tmp425_.flags = (gint) 0;
											_tmp425_.arg = G_OPTION_ARG_NONE;
											_tmp425_.arg_data = &refresh_tmp_files_dbs;
											_tmp425_.description = NULL;
											_tmp425_.arg_description = NULL;
											_tmp424_[7] = _tmp425_;
											_tmp426_ = options;
											_tmp426__length1 = options_length1;
											_tmp427_.long_name = "download-updates";
											_tmp427_.short_name = (gchar) 0;
											_tmp427_.flags = (gint) 0;
											_tmp427_.arg = G_OPTION_ARG_NONE;
											_tmp427_.arg_data = &download_updates;
											_tmp427_.description = NULL;
											_tmp427_.arg_description = NULL;
											_tmp426_[8] = _tmp427_;
											_tmp428_ = g_option_context_new (NULL);
											opt_context = _tmp428_;
											_tmp429_ = opt_context;
											g_option_context_set_help_enabled (_tmp429_, FALSE);
											_tmp430_ = opt_context;
											_tmp431_ = options;
											_tmp431__length1 = options_length1;
											g_option_context_add_main_entries (_tmp430_, _tmp431_, NULL);
											_tmp432_ = opt_context;
											g_option_context_parse (_tmp432_, (gint*) (&args_length1), &args, &_inner_error0_);
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
												_g_option_context_free0 (opt_context);
												options = (g_free (options), NULL);
												if (_inner_error0_->domain == G_OPTION_ERROR) {
													goto __catch10_g_option_error;
												}
												_g_free0 (builddir);
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
												g_clear_error (&_inner_error0_);
												return;
											}
											_g_option_context_free0 (opt_context);
											options = (g_free (options), NULL);
										}
										goto __finally10;
										__catch10_g_option_error:
										{
											g_clear_error (&_inner_error0_);
											pamac_cli_display_checkupdates_help (self);
											_g_free0 (builddir);
											return;
										}
										__finally10:
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											_g_free0 (builddir);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
										if (help) {
											pamac_cli_display_checkupdates_help (self);
											_g_free0 (builddir);
											return;
										}
										pamac_cli_init_transaction (self);
										if (aur) {
											PamacDatabase* _tmp433_;
											PamacConfig* _tmp434_;
											PamacConfig* _tmp435_;
											gboolean _tmp436_;
											gboolean _tmp437_;
											if (no_aur) {
												pamac_cli_display_checkupdates_help (self);
												_g_free0 (builddir);
												return;
											}
											_tmp433_ = self->priv->database;
											_tmp434_ = pamac_database_get_config (_tmp433_);
											_tmp435_ = _tmp434_;
											_tmp436_ = pamac_config_get_support_aur (_tmp435_);
											_tmp437_ = _tmp436_;
											if (!_tmp437_) {
												g_warning ("cli.vala:739: AUR not supported");
											} else {
												PamacDatabase* _tmp438_;
												PamacConfig* _tmp439_;
												PamacConfig* _tmp440_;
												PamacDatabase* _tmp441_;
												PamacConfig* _tmp442_;
												PamacConfig* _tmp443_;
												_tmp438_ = self->priv->database;
												_tmp439_ = pamac_database_get_config (_tmp438_);
												_tmp440_ = _tmp439_;
												pamac_config_set_enable_aur (_tmp440_, TRUE);
												_tmp441_ = self->priv->database;
												_tmp442_ = pamac_database_get_config (_tmp441_);
												_tmp443_ = _tmp442_;
												pamac_config_set_check_aur_updates (_tmp443_, TRUE);
											}
										}
										if (no_aur) {
											PamacDatabase* _tmp444_;
											PamacConfig* _tmp445_;
											PamacConfig* _tmp446_;
											if (devel) {
												pamac_cli_display_checkupdates_help (self);
												_g_free0 (builddir);
												return;
											}
											_tmp444_ = self->priv->database;
											_tmp445_ = pamac_database_get_config (_tmp444_);
											_tmp446_ = _tmp445_;
											pamac_config_set_enable_aur (_tmp446_, FALSE);
										}
										if (devel) {
											PamacDatabase* _tmp447_;
											PamacConfig* _tmp448_;
											PamacConfig* _tmp449_;
											if (no_devel) {
												pamac_cli_display_checkupdates_help (self);
												_g_free0 (builddir);
												return;
											}
											_tmp447_ = self->priv->database;
											_tmp448_ = pamac_database_get_config (_tmp447_);
											_tmp449_ = _tmp448_;
											pamac_config_set_check_aur_vcs_updates (_tmp449_, TRUE);
										}
										if (no_devel) {
											PamacDatabase* _tmp450_;
											PamacConfig* _tmp451_;
											PamacConfig* _tmp452_;
											_tmp450_ = self->priv->database;
											_tmp451_ = pamac_database_get_config (_tmp450_);
											_tmp452_ = _tmp451_;
											pamac_config_set_check_aur_vcs_updates (_tmp452_, FALSE);
										}
										_tmp453_ = self->priv->database;
										_tmp454_ = pamac_database_get_config (_tmp453_);
										_tmp455_ = _tmp454_;
										_tmp456_ = pamac_config_get_check_aur_vcs_updates (_tmp455_);
										_tmp457_ = _tmp456_;
										if (_tmp457_) {
											if (geteuid () == ((uid_t) 0)) {
												FILE* _tmp458_;
												FILE* _tmp459_;
												gchar* _tmp460_;
												gchar* _tmp461_;
												_tmp458_ = stdout;
												fprintf (_tmp458_, "%s: %s\n", g_dgettext (NULL, "Warning"), g_dgettext (NULL, "Checking development packages updates as root"));
												_tmp459_ = stdout;
												_tmp460_ = g_strdup_printf (g_dgettext (NULL, "Setting build directory to %s"), "/var/cache/pamac");
												_tmp461_ = _tmp460_;
												fprintf (_tmp459_, "%s: %s\n", g_dgettext (NULL, "Warning"), _tmp461_);
												_g_free0 (_tmp461_);
											} else {
												const gchar* _tmp462_;
												pamac_cli_get_aur_dest_variable (self);
												_tmp462_ = builddir;
												if (_tmp462_ != NULL) {
													PamacDatabase* _tmp463_;
													PamacConfig* _tmp464_;
													PamacConfig* _tmp465_;
													const gchar* _tmp466_;
													_tmp463_ = self->priv->database;
													_tmp464_ = pamac_database_get_config (_tmp463_);
													_tmp465_ = _tmp464_;
													_tmp466_ = builddir;
													pamac_config_set_aur_build_dir (_tmp465_, _tmp466_);
												}
											}
										}
										pamac_cli_checkupdates (self, quiet, refresh_tmp_files_dbs, download_updates);
										_g_free0 (builddir);
									} else {
										gboolean _tmp467_ = FALSE;
										const gchar* _tmp468_;
										_tmp468_ = args[1];
										if (g_strcmp0 (_tmp468_, "update") == 0) {
											_tmp467_ = TRUE;
										} else {
											const gchar* _tmp469_;
											_tmp469_ = args[1];
											_tmp467_ = g_strcmp0 (_tmp469_, "upgrade") == 0;
										}
										if (_tmp467_) {
											gboolean aur = FALSE;
											gboolean no_aur = FALSE;
											gboolean devel = FALSE;
											gboolean no_devel = FALSE;
											gboolean no_confirm = FALSE;
											gboolean download_only = FALSE;
											gboolean force_refresh = FALSE;
											gboolean enable_downgrade = FALSE;
											gboolean disable_downgrade = FALSE;
											gchar* builddir = NULL;
											gchar* overwrite = NULL;
											gchar* ignore = NULL;
											gboolean dry_run = FALSE;
											gboolean no_refresh = FALSE;
											gboolean _tmp527_ = FALSE;
											PamacDatabase* _tmp528_;
											PamacConfig* _tmp529_;
											PamacConfig* _tmp530_;
											gboolean _tmp531_;
											gboolean _tmp532_;
											const gchar* _tmp553_;
											const gchar* _tmp559_;
											aur = FALSE;
											no_aur = FALSE;
											devel = FALSE;
											no_devel = FALSE;
											no_confirm = FALSE;
											download_only = FALSE;
											force_refresh = FALSE;
											enable_downgrade = FALSE;
											disable_downgrade = FALSE;
											builddir = NULL;
											overwrite = NULL;
											ignore = NULL;
											dry_run = FALSE;
											no_refresh = FALSE;
											{
												GOptionEntry* options = NULL;
												GOptionEntry* _tmp470_;
												gint options_length1;
												gint _options_size_;
												GOptionEntry* _tmp471_;
												gint _tmp471__length1;
												GOptionEntry _tmp472_ = {0};
												GOptionEntry* _tmp473_;
												gint _tmp473__length1;
												GOptionEntry _tmp474_ = {0};
												GOptionEntry* _tmp475_;
												gint _tmp475__length1;
												GOptionEntry _tmp476_ = {0};
												GOptionEntry* _tmp477_;
												gint _tmp477__length1;
												GOptionEntry _tmp478_ = {0};
												GOptionEntry* _tmp479_;
												gint _tmp479__length1;
												GOptionEntry _tmp480_ = {0};
												GOptionEntry* _tmp481_;
												gint _tmp481__length1;
												GOptionEntry _tmp482_ = {0};
												GOptionEntry* _tmp483_;
												gint _tmp483__length1;
												GOptionEntry _tmp484_ = {0};
												GOptionEntry* _tmp485_;
												gint _tmp485__length1;
												GOptionEntry _tmp486_ = {0};
												GOptionEntry* _tmp487_;
												gint _tmp487__length1;
												GOptionEntry _tmp488_ = {0};
												GOptionEntry* _tmp489_;
												gint _tmp489__length1;
												GOptionEntry _tmp490_ = {0};
												GOptionEntry* _tmp491_;
												gint _tmp491__length1;
												GOptionEntry _tmp492_ = {0};
												GOptionEntry* _tmp493_;
												gint _tmp493__length1;
												GOptionEntry _tmp494_ = {0};
												GOptionEntry* _tmp495_;
												gint _tmp495__length1;
												GOptionEntry _tmp496_ = {0};
												GOptionEntry* _tmp497_;
												gint _tmp497__length1;
												GOptionEntry _tmp498_ = {0};
												GOptionEntry* _tmp499_;
												gint _tmp499__length1;
												GOptionEntry _tmp500_ = {0};
												GOptionContext* opt_context = NULL;
												GOptionContext* _tmp501_;
												GOptionContext* _tmp502_;
												GOptionContext* _tmp503_;
												GOptionEntry* _tmp504_;
												gint _tmp504__length1;
												GOptionContext* _tmp505_;
												_tmp470_ = g_new0 (GOptionEntry, 15);
												options = _tmp470_;
												options_length1 = 15;
												_options_size_ = options_length1;
												_tmp471_ = options;
												_tmp471__length1 = options_length1;
												_tmp472_.long_name = "help";
												_tmp472_.short_name = 'h';
												_tmp472_.flags = (gint) 0;
												_tmp472_.arg = G_OPTION_ARG_NONE;
												_tmp472_.arg_data = &help;
												_tmp472_.description = NULL;
												_tmp472_.arg_description = NULL;
												_tmp471_[0] = _tmp472_;
												_tmp473_ = options;
												_tmp473__length1 = options_length1;
												_tmp474_.long_name = "aur";
												_tmp474_.short_name = 'a';
												_tmp474_.flags = (gint) 0;
												_tmp474_.arg = G_OPTION_ARG_NONE;
												_tmp474_.arg_data = &aur;
												_tmp474_.description = NULL;
												_tmp474_.arg_description = NULL;
												_tmp473_[1] = _tmp474_;
												_tmp475_ = options;
												_tmp475__length1 = options_length1;
												_tmp476_.long_name = "no-aur";
												_tmp476_.short_name = (gchar) 0;
												_tmp476_.flags = (gint) 0;
												_tmp476_.arg = G_OPTION_ARG_NONE;
												_tmp476_.arg_data = &no_aur;
												_tmp476_.description = NULL;
												_tmp476_.arg_description = NULL;
												_tmp475_[2] = _tmp476_;
												_tmp477_ = options;
												_tmp477__length1 = options_length1;
												_tmp478_.long_name = "devel";
												_tmp478_.short_name = (gchar) 0;
												_tmp478_.flags = (gint) 0;
												_tmp478_.arg = G_OPTION_ARG_NONE;
												_tmp478_.arg_data = &devel;
												_tmp478_.description = NULL;
												_tmp478_.arg_description = NULL;
												_tmp477_[3] = _tmp478_;
												_tmp479_ = options;
												_tmp479__length1 = options_length1;
												_tmp480_.long_name = "no-devel";
												_tmp480_.short_name = (gchar) 0;
												_tmp480_.flags = (gint) 0;
												_tmp480_.arg = G_OPTION_ARG_NONE;
												_tmp480_.arg_data = &no_devel;
												_tmp480_.description = NULL;
												_tmp480_.arg_description = NULL;
												_tmp479_[4] = _tmp480_;
												_tmp481_ = options;
												_tmp481__length1 = options_length1;
												_tmp482_.long_name = "builddir";
												_tmp482_.short_name = (gchar) 0;
												_tmp482_.flags = (gint) 0;
												_tmp482_.arg = G_OPTION_ARG_STRING;
												_tmp482_.arg_data = &builddir;
												_tmp482_.description = NULL;
												_tmp482_.arg_description = NULL;
												_tmp481_[5] = _tmp482_;
												_tmp483_ = options;
												_tmp483__length1 = options_length1;
												_tmp484_.long_name = "no-confirm";
												_tmp484_.short_name = (gchar) 0;
												_tmp484_.flags = (gint) 0;
												_tmp484_.arg = G_OPTION_ARG_NONE;
												_tmp484_.arg_data = &no_confirm;
												_tmp484_.description = NULL;
												_tmp484_.arg_description = NULL;
												_tmp483_[6] = _tmp484_;
												_tmp485_ = options;
												_tmp485__length1 = options_length1;
												_tmp486_.long_name = "force-refresh";
												_tmp486_.short_name = (gchar) 0;
												_tmp486_.flags = (gint) 0;
												_tmp486_.arg = G_OPTION_ARG_NONE;
												_tmp486_.arg_data = &force_refresh;
												_tmp486_.description = NULL;
												_tmp486_.arg_description = NULL;
												_tmp485_[7] = _tmp486_;
												_tmp487_ = options;
												_tmp487__length1 = options_length1;
												_tmp488_.long_name = "enable-downgrade";
												_tmp488_.short_name = (gchar) 0;
												_tmp488_.flags = (gint) 0;
												_tmp488_.arg = G_OPTION_ARG_NONE;
												_tmp488_.arg_data = &enable_downgrade;
												_tmp488_.description = NULL;
												_tmp488_.arg_description = NULL;
												_tmp487_[8] = _tmp488_;
												_tmp489_ = options;
												_tmp489__length1 = options_length1;
												_tmp490_.long_name = "disable-downgrade";
												_tmp490_.short_name = (gchar) 0;
												_tmp490_.flags = (gint) 0;
												_tmp490_.arg = G_OPTION_ARG_NONE;
												_tmp490_.arg_data = &disable_downgrade;
												_tmp490_.description = NULL;
												_tmp490_.arg_description = NULL;
												_tmp489_[9] = _tmp490_;
												_tmp491_ = options;
												_tmp491__length1 = options_length1;
												_tmp492_.long_name = "overwrite";
												_tmp492_.short_name = (gchar) 0;
												_tmp492_.flags = (gint) 0;
												_tmp492_.arg = G_OPTION_ARG_STRING;
												_tmp492_.arg_data = &overwrite;
												_tmp492_.description = NULL;
												_tmp492_.arg_description = NULL;
												_tmp491_[10] = _tmp492_;
												_tmp493_ = options;
												_tmp493__length1 = options_length1;
												_tmp494_.long_name = "ignore";
												_tmp494_.short_name = (gchar) 0;
												_tmp494_.flags = (gint) 0;
												_tmp494_.arg = G_OPTION_ARG_STRING;
												_tmp494_.arg_data = &ignore;
												_tmp494_.description = NULL;
												_tmp494_.arg_description = NULL;
												_tmp493_[11] = _tmp494_;
												_tmp495_ = options;
												_tmp495__length1 = options_length1;
												_tmp496_.long_name = "download-only";
												_tmp496_.short_name = 'w';
												_tmp496_.flags = (gint) 0;
												_tmp496_.arg = G_OPTION_ARG_NONE;
												_tmp496_.arg_data = &download_only;
												_tmp496_.description = NULL;
												_tmp496_.arg_description = NULL;
												_tmp495_[12] = _tmp496_;
												_tmp497_ = options;
												_tmp497__length1 = options_length1;
												_tmp498_.long_name = "dry-run";
												_tmp498_.short_name = 'd';
												_tmp498_.flags = (gint) 0;
												_tmp498_.arg = G_OPTION_ARG_NONE;
												_tmp498_.arg_data = &dry_run;
												_tmp498_.description = NULL;
												_tmp498_.arg_description = NULL;
												_tmp497_[13] = _tmp498_;
												_tmp499_ = options;
												_tmp499__length1 = options_length1;
												_tmp500_.long_name = "no-refresh";
												_tmp500_.short_name = (gchar) 0;
												_tmp500_.flags = (gint) 0;
												_tmp500_.arg = G_OPTION_ARG_NONE;
												_tmp500_.arg_data = &no_refresh;
												_tmp500_.description = NULL;
												_tmp500_.arg_description = NULL;
												_tmp499_[14] = _tmp500_;
												_tmp501_ = g_option_context_new (NULL);
												opt_context = _tmp501_;
												_tmp502_ = opt_context;
												g_option_context_set_help_enabled (_tmp502_, FALSE);
												_tmp503_ = opt_context;
												_tmp504_ = options;
												_tmp504__length1 = options_length1;
												g_option_context_add_main_entries (_tmp503_, _tmp504_, NULL);
												_tmp505_ = opt_context;
												g_option_context_parse (_tmp505_, (gint*) (&args_length1), &args, &_inner_error0_);
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
													_g_option_context_free0 (opt_context);
													options = (g_free (options), NULL);
													if (_inner_error0_->domain == G_OPTION_ERROR) {
														goto __catch11_g_option_error;
													}
													_g_free0 (ignore);
													_g_free0 (overwrite);
													_g_free0 (builddir);
													g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
													g_clear_error (&_inner_error0_);
													return;
												}
												_g_option_context_free0 (opt_context);
												options = (g_free (options), NULL);
											}
											goto __finally11;
											__catch11_g_option_error:
											{
												g_clear_error (&_inner_error0_);
												pamac_cli_display_upgrade_help (self);
												_g_free0 (ignore);
												_g_free0 (overwrite);
												_g_free0 (builddir);
												return;
											}
											__finally11:
											if (G_UNLIKELY (_inner_error0_ != NULL)) {
												_g_free0 (ignore);
												_g_free0 (overwrite);
												_g_free0 (builddir);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
												g_clear_error (&_inner_error0_);
												return;
											}
											if (help) {
												pamac_cli_display_upgrade_help (self);
												_g_free0 (ignore);
												_g_free0 (overwrite);
												_g_free0 (builddir);
												return;
											}
											pamac_cli_init_transaction (self);
											if (dry_run) {
												PamacTransactionCli* _tmp506_;
												_tmp506_ = self->transaction;
												pamac_transaction_set_dry_run ((PamacTransaction*) _tmp506_, TRUE);
											}
											if (aur) {
												PamacDatabase* _tmp507_;
												PamacConfig* _tmp508_;
												PamacConfig* _tmp509_;
												gboolean _tmp510_;
												gboolean _tmp511_;
												if (no_aur) {
													pamac_cli_display_upgrade_help (self);
													_g_free0 (ignore);
													_g_free0 (overwrite);
													_g_free0 (builddir);
													return;
												}
												_tmp507_ = self->priv->database;
												_tmp508_ = pamac_database_get_config (_tmp507_);
												_tmp509_ = _tmp508_;
												_tmp510_ = pamac_config_get_support_aur (_tmp509_);
												_tmp511_ = _tmp510_;
												if (!_tmp511_) {
													g_warning ("cli.vala:829: AUR not supported");
												} else {
													PamacDatabase* _tmp512_;
													PamacConfig* _tmp513_;
													PamacConfig* _tmp514_;
													PamacDatabase* _tmp515_;
													PamacConfig* _tmp516_;
													PamacConfig* _tmp517_;
													_tmp512_ = self->priv->database;
													_tmp513_ = pamac_database_get_config (_tmp512_);
													_tmp514_ = _tmp513_;
													pamac_config_set_enable_aur (_tmp514_, TRUE);
													_tmp515_ = self->priv->database;
													_tmp516_ = pamac_database_get_config (_tmp515_);
													_tmp517_ = _tmp516_;
													pamac_config_set_check_aur_updates (_tmp517_, TRUE);
												}
											}
											if (no_aur) {
												PamacDatabase* _tmp518_;
												PamacConfig* _tmp519_;
												PamacConfig* _tmp520_;
												if (devel) {
													pamac_cli_display_upgrade_help (self);
													_g_free0 (ignore);
													_g_free0 (overwrite);
													_g_free0 (builddir);
													return;
												}
												_tmp518_ = self->priv->database;
												_tmp519_ = pamac_database_get_config (_tmp518_);
												_tmp520_ = _tmp519_;
												pamac_config_set_enable_aur (_tmp520_, FALSE);
											}
											if (devel) {
												PamacDatabase* _tmp521_;
												PamacConfig* _tmp522_;
												PamacConfig* _tmp523_;
												if (no_devel) {
													pamac_cli_display_upgrade_help (self);
													_g_free0 (ignore);
													_g_free0 (overwrite);
													_g_free0 (builddir);
													return;
												}
												_tmp521_ = self->priv->database;
												_tmp522_ = pamac_database_get_config (_tmp521_);
												_tmp523_ = _tmp522_;
												pamac_config_set_check_aur_vcs_updates (_tmp523_, TRUE);
											}
											if (no_devel) {
												PamacDatabase* _tmp524_;
												PamacConfig* _tmp525_;
												PamacConfig* _tmp526_;
												_tmp524_ = self->priv->database;
												_tmp525_ = pamac_database_get_config (_tmp524_);
												_tmp526_ = _tmp525_;
												pamac_config_set_check_aur_vcs_updates (_tmp526_, FALSE);
											}
											_tmp528_ = self->priv->database;
											_tmp529_ = pamac_database_get_config (_tmp528_);
											_tmp530_ = _tmp529_;
											_tmp531_ = pamac_config_get_support_aur (_tmp530_);
											_tmp532_ = _tmp531_;
											if (_tmp532_) {
												PamacDatabase* _tmp533_;
												PamacConfig* _tmp534_;
												PamacConfig* _tmp535_;
												gboolean _tmp536_;
												gboolean _tmp537_;
												_tmp533_ = self->priv->database;
												_tmp534_ = pamac_database_get_config (_tmp533_);
												_tmp535_ = _tmp534_;
												_tmp536_ = pamac_config_get_check_aur_updates (_tmp535_);
												_tmp537_ = _tmp536_;
												_tmp527_ = _tmp537_;
											} else {
												_tmp527_ = FALSE;
											}
											if (_tmp527_) {
												if (geteuid () == ((uid_t) 0)) {
													FILE* _tmp538_;
													FILE* _tmp539_;
													gchar* _tmp540_;
													gchar* _tmp541_;
													_tmp538_ = stdout;
													fprintf (_tmp538_, "%s: %s\n", g_dgettext (NULL, "Warning"), g_dgettext (NULL, "Building packages as dynamic user"));
													_tmp539_ = stdout;
													_tmp540_ = g_strdup_printf (g_dgettext (NULL, "Setting build directory to %s"), "/var/cache/pamac");
													_tmp541_ = _tmp540_;
													fprintf (_tmp539_, "%s: %s\n", g_dgettext (NULL, "Warning"), _tmp541_);
													_g_free0 (_tmp541_);
												} else {
													const gchar* _tmp542_;
													pamac_cli_get_aur_dest_variable (self);
													_tmp542_ = builddir;
													if (_tmp542_ != NULL) {
														PamacDatabase* _tmp543_;
														PamacConfig* _tmp544_;
														PamacConfig* _tmp545_;
														const gchar* _tmp546_;
														_tmp543_ = self->priv->database;
														_tmp544_ = pamac_database_get_config (_tmp543_);
														_tmp545_ = _tmp544_;
														_tmp546_ = builddir;
														pamac_config_set_aur_build_dir (_tmp545_, _tmp546_);
													}
												}
											}
											if (enable_downgrade) {
												PamacDatabase* _tmp547_;
												PamacConfig* _tmp548_;
												PamacConfig* _tmp549_;
												if (disable_downgrade) {
													pamac_cli_display_upgrade_help (self);
													_g_free0 (ignore);
													_g_free0 (overwrite);
													_g_free0 (builddir);
													return;
												}
												_tmp547_ = self->priv->database;
												_tmp548_ = pamac_database_get_config (_tmp547_);
												_tmp549_ = _tmp548_;
												pamac_config_set_enable_downgrade (_tmp549_, TRUE);
											}
											if (disable_downgrade) {
												PamacDatabase* _tmp550_;
												PamacConfig* _tmp551_;
												PamacConfig* _tmp552_;
												_tmp550_ = self->priv->database;
												_tmp551_ = pamac_database_get_config (_tmp550_);
												_tmp552_ = _tmp551_;
												pamac_config_set_enable_downgrade (_tmp552_, FALSE);
											}
											_tmp553_ = ignore;
											if (_tmp553_ != NULL) {
												const gchar* _tmp554_;
												gchar** _tmp555_;
												gchar** _tmp556_;
												_tmp554_ = ignore;
												_tmp556_ = _tmp555_ = g_strsplit (_tmp554_, ",", 0);
												{
													gchar** name_collection = NULL;
													gint name_collection_length1 = 0;
													gint _name_collection_size_ = 0;
													gint name_it = 0;
													name_collection = _tmp556_;
													name_collection_length1 = _vala_array_length (_tmp555_);
													for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
														const gchar* name = NULL;
														name = name_collection[name_it];
														{
															PamacTransactionCli* _tmp557_;
															const gchar* _tmp558_;
															_tmp557_ = self->transaction;
															_tmp558_ = name;
															pamac_transaction_add_temporary_ignore_pkg ((PamacTransaction*) _tmp557_, _tmp558_);
														}
													}
													name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
												}
											}
											_tmp559_ = overwrite;
											if (_tmp559_ != NULL) {
												const gchar* _tmp560_;
												gchar** _tmp561_;
												gchar** _tmp562_;
												_tmp560_ = overwrite;
												_tmp562_ = _tmp561_ = g_strsplit (_tmp560_, ",", 0);
												{
													gchar** glob_collection = NULL;
													gint glob_collection_length1 = 0;
													gint _glob_collection_size_ = 0;
													gint glob_it = 0;
													glob_collection = _tmp562_;
													glob_collection_length1 = _vala_array_length (_tmp561_);
													for (glob_it = 0; glob_it < glob_collection_length1; glob_it = glob_it + 1) {
														const gchar* glob = NULL;
														glob = glob_collection[glob_it];
														{
															PamacTransactionCli* _tmp563_;
															const gchar* _tmp564_;
															_tmp563_ = self->transaction;
															_tmp564_ = glob;
															pamac_transaction_add_overwrite_file ((PamacTransaction*) _tmp563_, _tmp564_);
														}
													}
													glob_collection = (_vala_array_free (glob_collection, glob_collection_length1, (GDestroyNotify) g_free), NULL);
												}
											}
											if (no_confirm) {
												PamacTransactionCli* _tmp565_;
												_tmp565_ = self->transaction;
												pamac_transaction_cli_set_no_confirm (_tmp565_, TRUE);
											}
											if (download_only) {
												PamacTransactionCli* _tmp566_;
												_tmp566_ = self->transaction;
												pamac_transaction_set_download_only ((PamacTransaction*) _tmp566_, TRUE);
											}
											if (no_refresh) {
												PamacTransactionCli* _tmp567_;
												if (force_refresh) {
													pamac_cli_display_upgrade_help (self);
													_g_free0 (ignore);
													_g_free0 (overwrite);
													_g_free0 (builddir);
													return;
												}
												_tmp567_ = self->transaction;
												pamac_transaction_set_no_refresh ((PamacTransaction*) _tmp567_, TRUE);
											}
											pamac_cli_run_sysupgrade (self, force_refresh);
											_g_free0 (ignore);
											_g_free0 (overwrite);
											_g_free0 (builddir);
										} else {
											const gchar* _tmp568_;
											_tmp568_ = args[1];
											if (g_strcmp0 (_tmp568_, "clean") == 0) {
												gboolean verbose = FALSE;
												gboolean build_files = FALSE;
												gboolean uninstalled = FALSE;
												gboolean dry_run = FALSE;
												gboolean no_confirm = FALSE;
												gint64 keep = 0LL;
												verbose = FALSE;
												build_files = FALSE;
												uninstalled = FALSE;
												dry_run = FALSE;
												no_confirm = FALSE;
												keep = (gint64) -1;
												{
													GOptionEntry* options = NULL;
													GOptionEntry* _tmp569_;
													gint options_length1;
													gint _options_size_;
													GOptionEntry* _tmp570_;
													gint _tmp570__length1;
													GOptionEntry _tmp571_ = {0};
													GOptionEntry* _tmp572_;
													gint _tmp572__length1;
													GOptionEntry _tmp573_ = {0};
													GOptionEntry* _tmp574_;
													gint _tmp574__length1;
													GOptionEntry _tmp575_ = {0};
													GOptionEntry* _tmp576_;
													gint _tmp576__length1;
													GOptionEntry _tmp577_ = {0};
													GOptionEntry* _tmp578_;
													gint _tmp578__length1;
													GOptionEntry _tmp579_ = {0};
													GOptionEntry* _tmp580_;
													gint _tmp580__length1;
													GOptionEntry _tmp581_ = {0};
													GOptionEntry* _tmp582_;
													gint _tmp582__length1;
													GOptionEntry _tmp583_ = {0};
													GOptionContext* opt_context = NULL;
													GOptionContext* _tmp584_;
													GOptionContext* _tmp585_;
													GOptionContext* _tmp586_;
													GOptionEntry* _tmp587_;
													gint _tmp587__length1;
													GOptionContext* _tmp588_;
													_tmp569_ = g_new0 (GOptionEntry, 7);
													options = _tmp569_;
													options_length1 = 7;
													_options_size_ = options_length1;
													_tmp570_ = options;
													_tmp570__length1 = options_length1;
													_tmp571_.long_name = "help";
													_tmp571_.short_name = 'h';
													_tmp571_.flags = (gint) 0;
													_tmp571_.arg = G_OPTION_ARG_NONE;
													_tmp571_.arg_data = &help;
													_tmp571_.description = NULL;
													_tmp571_.arg_description = NULL;
													_tmp570_[0] = _tmp571_;
													_tmp572_ = options;
													_tmp572__length1 = options_length1;
													_tmp573_.long_name = "verbose";
													_tmp573_.short_name = 'v';
													_tmp573_.flags = (gint) 0;
													_tmp573_.arg = G_OPTION_ARG_NONE;
													_tmp573_.arg_data = &verbose;
													_tmp573_.description = NULL;
													_tmp573_.arg_description = NULL;
													_tmp572_[1] = _tmp573_;
													_tmp574_ = options;
													_tmp574__length1 = options_length1;
													_tmp575_.long_name = "build-files";
													_tmp575_.short_name = 'b';
													_tmp575_.flags = (gint) 0;
													_tmp575_.arg = G_OPTION_ARG_NONE;
													_tmp575_.arg_data = &build_files;
													_tmp575_.description = NULL;
													_tmp575_.arg_description = NULL;
													_tmp574_[2] = _tmp575_;
													_tmp576_ = options;
													_tmp576__length1 = options_length1;
													_tmp577_.long_name = "no-confirm";
													_tmp577_.short_name = (gchar) 0;
													_tmp577_.flags = (gint) 0;
													_tmp577_.arg = G_OPTION_ARG_NONE;
													_tmp577_.arg_data = &no_confirm;
													_tmp577_.description = NULL;
													_tmp577_.arg_description = NULL;
													_tmp576_[3] = _tmp577_;
													_tmp578_ = options;
													_tmp578__length1 = options_length1;
													_tmp579_.long_name = "uninstalled";
													_tmp579_.short_name = 'u';
													_tmp579_.flags = (gint) 0;
													_tmp579_.arg = G_OPTION_ARG_NONE;
													_tmp579_.arg_data = &uninstalled;
													_tmp579_.description = NULL;
													_tmp579_.arg_description = NULL;
													_tmp578_[4] = _tmp579_;
													_tmp580_ = options;
													_tmp580__length1 = options_length1;
													_tmp581_.long_name = "dry-run";
													_tmp581_.short_name = 'd';
													_tmp581_.flags = (gint) 0;
													_tmp581_.arg = G_OPTION_ARG_NONE;
													_tmp581_.arg_data = &dry_run;
													_tmp581_.description = NULL;
													_tmp581_.arg_description = NULL;
													_tmp580_[5] = _tmp581_;
													_tmp582_ = options;
													_tmp582__length1 = options_length1;
													_tmp583_.long_name = "keep";
													_tmp583_.short_name = 'k';
													_tmp583_.flags = (gint) 0;
													_tmp583_.arg = G_OPTION_ARG_INT64;
													_tmp583_.arg_data = &keep;
													_tmp583_.description = NULL;
													_tmp583_.arg_description = NULL;
													_tmp582_[6] = _tmp583_;
													_tmp584_ = g_option_context_new (NULL);
													opt_context = _tmp584_;
													_tmp585_ = opt_context;
													g_option_context_set_help_enabled (_tmp585_, FALSE);
													_tmp586_ = opt_context;
													_tmp587_ = options;
													_tmp587__length1 = options_length1;
													g_option_context_add_main_entries (_tmp586_, _tmp587_, NULL);
													_tmp588_ = opt_context;
													g_option_context_parse (_tmp588_, (gint*) (&args_length1), &args, &_inner_error0_);
													if (G_UNLIKELY (_inner_error0_ != NULL)) {
														_g_option_context_free0 (opt_context);
														options = (g_free (options), NULL);
														if (_inner_error0_->domain == G_OPTION_ERROR) {
															goto __catch12_g_option_error;
														}
														g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
														g_clear_error (&_inner_error0_);
														return;
													}
													_g_option_context_free0 (opt_context);
													options = (g_free (options), NULL);
												}
												goto __finally12;
												__catch12_g_option_error:
												{
													g_clear_error (&_inner_error0_);
													pamac_cli_display_clean_help (self);
													return;
												}
												__finally12:
												if (G_UNLIKELY (_inner_error0_ != NULL)) {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
													g_clear_error (&_inner_error0_);
													return;
												}
												if (help) {
													pamac_cli_display_clean_help (self);
													return;
												}
												pamac_cli_init_transaction (self);
												pamac_cli_get_aur_dest_variable (self);
												if (keep >= ((gint64) 0)) {
													PamacDatabase* _tmp589_;
													PamacConfig* _tmp590_;
													PamacConfig* _tmp591_;
													_tmp589_ = self->priv->database;
													_tmp590_ = pamac_database_get_config (_tmp589_);
													_tmp591_ = _tmp590_;
													pamac_config_set_clean_keep_num_pkgs (_tmp591_, (guint64) keep);
												}
												if (uninstalled) {
													PamacDatabase* _tmp592_;
													PamacConfig* _tmp593_;
													PamacConfig* _tmp594_;
													_tmp592_ = self->priv->database;
													_tmp593_ = pamac_database_get_config (_tmp592_);
													_tmp594_ = _tmp593_;
													pamac_config_set_clean_rm_only_uninstalled (_tmp594_, TRUE);
												}
												if (build_files) {
													pamac_cli_clean_build_files (self, dry_run, verbose, no_confirm);
												} else {
													pamac_cli_clean_cache (self, dry_run, verbose, no_confirm);
												}
											} else {
												pamac_cli_display_help (self);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

static void
pamac_cli_init_database (PamacCli* self)
{
	PamacConfig* config = NULL;
	PamacConfig* _tmp0_;
	PamacDatabase* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pamac_config_new ("/etc/pamac.conf");
	config = _tmp0_;
	pamac_config_set_enable_appstream (config, FALSE);
	pamac_config_set_enable_snap (config, FALSE);
	pamac_config_set_enable_flatpak (config, FALSE);
	_tmp1_ = pamac_database_new (config);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp1_;
	_g_object_unref0 (config);
}

static void
pamac_cli_get_aur_dest_variable (PamacCli* self)
{
	const gchar* aurdest = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_getenv ("AURDEST");
	aurdest = _tmp0_;
	_tmp1_ = aurdest;
	if (_tmp1_ != NULL) {
		GFile* aurdest_file = NULL;
		const gchar* _tmp2_;
		GFile* _tmp3_;
		PamacDatabase* _tmp4_;
		PamacConfig* _tmp5_;
		PamacConfig* _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		PamacDatabase* _tmp10_;
		PamacConfig* _tmp11_;
		PamacConfig* _tmp12_;
		_tmp2_ = aurdest;
		_tmp3_ = g_file_new_for_path (_tmp2_);
		aurdest_file = _tmp3_;
		_tmp4_ = self->priv->database;
		_tmp5_ = pamac_database_get_config (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = aurdest_file;
		_tmp8_ = g_file_get_path (_tmp7_);
		_tmp9_ = _tmp8_;
		pamac_config_set_aur_build_dir (_tmp6_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->database;
		_tmp11_ = pamac_database_get_config (_tmp10_);
		_tmp12_ = _tmp11_;
		pamac_config_set_keep_built_pkgs (_tmp12_, TRUE);
		_g_object_unref0 (aurdest_file);
	}
}

static void
__lambda5_ (PamacCli* self)
{
	self->priv->trans_cancellable = TRUE;
}

static void
___lambda5__pamac_transaction_start_waiting (PamacTransaction* _sender,
                                             gpointer self)
{
	__lambda5_ ((PamacCli*) self);
}

static void
__lambda6_ (PamacCli* self)
{
	self->priv->trans_cancellable = FALSE;
}

static void
___lambda6__pamac_transaction_stop_waiting (PamacTransaction* _sender,
                                            gpointer self)
{
	__lambda6_ ((PamacCli*) self);
}

static void
__lambda7_ (PamacCli* self)
{
	self->priv->trans_cancellable = TRUE;
}

static void
___lambda7__pamac_transaction_start_downloading (PamacTransaction* _sender,
                                                 gpointer self)
{
	__lambda7_ ((PamacCli*) self);
}

static void
__lambda8_ (PamacCli* self)
{
	self->priv->trans_cancellable = FALSE;
}

static void
___lambda8__pamac_transaction_stop_downloading (PamacTransaction* _sender,
                                                gpointer self)
{
	__lambda8_ ((PamacCli*) self);
}

static void
__lambda9_ (PamacCli* self)
{
	self->priv->trans_cancellable = TRUE;
}

static void
___lambda9__pamac_transaction_start_building (PamacTransaction* _sender,
                                              gpointer self)
{
	__lambda9_ ((PamacCli*) self);
}

static void
__lambda10_ (PamacCli* self)
{
	self->priv->trans_cancellable = FALSE;
}

static void
___lambda10__pamac_transaction_stop_building (PamacTransaction* _sender,
                                              gpointer self)
{
	__lambda10_ ((PamacCli*) self);
}

static void
pamac_cli_init_transaction (PamacCli* self)
{
	PamacDatabase* _tmp0_;
	PamacDatabase* _tmp1_;
	PamacTransactionCli* _tmp2_;
	PamacTransactionCli* _tmp3_;
	PamacTransactionCli* _tmp4_;
	PamacTransactionCli* _tmp5_;
	PamacTransactionCli* _tmp6_;
	PamacTransactionCli* _tmp7_;
	PamacTransactionCli* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	if (_tmp0_ == NULL) {
		pamac_cli_init_database (self);
	}
	_tmp1_ = self->priv->database;
	_tmp2_ = pamac_transaction_cli_new (_tmp1_);
	_g_object_unref0 (self->transaction);
	self->transaction = _tmp2_;
	_tmp3_ = self->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp3_, "start-waiting", (GCallback) ___lambda5__pamac_transaction_start_waiting, self, 0);
	_tmp4_ = self->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp4_, "stop-waiting", (GCallback) ___lambda6__pamac_transaction_stop_waiting, self, 0);
	_tmp5_ = self->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp5_, "start-downloading", (GCallback) ___lambda7__pamac_transaction_start_downloading, self, 0);
	_tmp6_ = self->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp6_, "stop-downloading", (GCallback) ___lambda8__pamac_transaction_stop_downloading, self, 0);
	_tmp7_ = self->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp7_, "start-building", (GCallback) ___lambda9__pamac_transaction_start_building, self, 0);
	_tmp8_ = self->transaction;
	g_signal_connect_object ((PamacTransaction*) _tmp8_, "stop-building", (GCallback) ___lambda10__pamac_transaction_stop_building, self, 0);
	if (geteuid () != ((uid_t) 0)) {
		{
			GSubprocess* _tmp9_ = NULL;
			gchar* _tmp10_;
			gchar** _tmp11_;
			gchar** _tmp12_;
			gint _tmp12__length1;
			GSubprocess* _tmp13_;
			GSubprocess* _tmp14_;
			GSubprocess* _tmp15_;
			_tmp10_ = g_strdup ("pkttyagent");
			_tmp11_ = g_new0 (gchar*, 1 + 1);
			_tmp11_[0] = _tmp10_;
			_tmp12_ = _tmp11_;
			_tmp12__length1 = 1;
			_tmp13_ = g_subprocess_newv (_tmp12_, G_SUBPROCESS_FLAGS_NONE, &_inner_error0_);
			_tmp14_ = _tmp13_;
			_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
			_tmp9_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp15_ = _tmp9_;
			_tmp9_ = NULL;
			_g_object_unref0 (self->pkttyagent);
			self->pkttyagent = _tmp15_;
			_g_object_unref0 (_tmp9_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			FILE* _tmp16_;
			GError* _tmp17_;
			const gchar* _tmp18_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = stdout;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			fprintf (_tmp16_, "%s: %s\n", g_dgettext (NULL, "Error"), _tmp18_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gboolean
pamac_cli_trans_cancel (PamacCli* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->cloning) {
		GCancellable* _tmp0_;
		FILE* _tmp1_;
		self->priv->cloning = FALSE;
		_tmp0_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp0_);
		_tmp1_ = stdout;
		fprintf (_tmp1_, "\n");
	} else {
		if (self->priv->trans_cancellable) {
			PamacTransactionCli* _tmp2_;
			_tmp2_ = self->transaction;
			pamac_transaction_cancel ((PamacTransaction*) _tmp2_);
		} else {
			FILE* _tmp3_;
			_tmp3_ = stdout;
			fprintf (_tmp3_, "\n");
		}
	}
	result = TRUE;
	return result;
}

static gint
pamac_cli_get_term_width (PamacCli* self)
{
	gint width = 0;
	struct winsize win = {0};
	struct winsize _tmp0_ = {0};
	gint _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	width = 80;
	_tmp1_ = ioctl (STDOUT_FILENO, TIOCGWINSZ, &_tmp0_);
	 (&win);
	win = _tmp0_;
	if (_tmp1_ == 0) {
		struct winsize _tmp2_;
		_tmp2_ = win;
		width = (gint) _tmp2_.ws_col;
	}
	result = width;
	 (&win);
	return result;
}

static gchar*
pamac_cli_concatenate_strings_list (PamacCli* self,
                                    GPtrArray* list)
{
	GString* str_builder = NULL;
	GString* _tmp0_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (list != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str_builder = _tmp0_;
	{
		GPtrArray* name_collection = NULL;
		guint name_index = 0U;
		name_collection = list;
		for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
			const gchar* name = NULL;
			name = (const gchar*) g_ptr_array_index (name_collection, name_index);
			{
				GString* _tmp1_;
				GString* _tmp3_;
				const gchar* _tmp4_;
				_tmp1_ = str_builder;
				if (_tmp1_->len > ((gssize) 0)) {
					GString* _tmp2_;
					_tmp2_ = str_builder;
					g_string_append (_tmp2_, " ");
				}
				_tmp3_ = str_builder;
				_tmp4_ = name;
				g_string_append (_tmp3_, _tmp4_);
			}
		}
	}
	_tmp5_ = str_builder;
	_tmp6_ = _tmp5_->str;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	_g_string_free0 (str_builder);
	return result;
}

static gchar*
pamac_cli_concatenate_strings (PamacCli* self,
                               gchar** list,
                               gint list_length1)
{
	GString* str_builder = NULL;
	GString* _tmp0_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str_builder = _tmp0_;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = list;
		str_collection_length1 = list_length1;
		for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
			const gchar* str = NULL;
			str = str_collection[str_it];
			{
				GString* _tmp1_;
				GString* _tmp3_;
				const gchar* _tmp4_;
				_tmp1_ = str_builder;
				if (_tmp1_->len > ((gssize) 0)) {
					GString* _tmp2_;
					_tmp2_ = str_builder;
					g_string_append (_tmp2_, " ");
				}
				_tmp3_ = str_builder;
				_tmp4_ = str;
				g_string_append (_tmp3_, _tmp4_);
			}
		}
	}
	_tmp5_ = str_builder;
	_tmp6_ = _tmp5_->str;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	_g_string_free0 (str_builder);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static GPtrArray*
pamac_cli_split_string (PamacCli* self,
                        const gchar* str,
                        gint margin,
                        gint width)
{
	GPtrArray* splitted = NULL;
	GPtrArray* _tmp0_;
	gint str_length = 0;
	gint _tmp1_;
	gint _tmp2_;
	gint available_width = 0;
	gint remain_length = 0;
	gint offset = 0;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	splitted = _tmp0_;
	if (str == NULL) {
		result = splitted;
		return result;
	}
	if (width == 0) {
		width = self->priv->term_width;
	}
	if (width > self->priv->term_width) {
		width = self->priv->term_width;
	}
	_tmp1_ = strlen (str);
	_tmp2_ = _tmp1_;
	str_length = _tmp2_;
	available_width = width - margin;
	if (available_width < 10) {
		available_width = 10;
	}
	if (available_width >= str_length) {
		GPtrArray* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = splitted;
		_tmp4_ = g_strdup (str);
		g_ptr_array_add (_tmp3_, _tmp4_);
		result = splitted;
		return result;
	}
	remain_length = str_length;
	offset = 0;
	while (TRUE) {
		gchar* remain_string = NULL;
		gchar* _tmp5_;
		gchar* cutted_string = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gint cut_length = 0;
		gint i = 0;
		const gchar* _tmp8_;
		GPtrArray* _tmp11_;
		gchar* _tmp12_;
		if (!(remain_length >= available_width)) {
			break;
		}
		_tmp5_ = string_substring (str, (glong) offset, (glong) remain_length);
		remain_string = _tmp5_;
		_tmp6_ = remain_string;
		_tmp7_ = string_substring (_tmp6_, (glong) 0, (glong) available_width);
		cutted_string = _tmp7_;
		cut_length = available_width;
		_tmp8_ = cutted_string;
		i = string_last_index_of_char (_tmp8_, (gunichar) ' ', 0);
		if (i != -1) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			cut_length = i;
			_tmp9_ = remain_string;
			_tmp10_ = string_substring (_tmp9_, (glong) 0, (glong) i);
			_g_free0 (cutted_string);
			cutted_string = _tmp10_;
		}
		_tmp11_ = splitted;
		_tmp12_ = cutted_string;
		cutted_string = NULL;
		g_ptr_array_add (_tmp11_, _tmp12_);
		offset += cut_length + 1;
		remain_length -= cut_length + 1;
		_g_free0 (cutted_string);
		_g_free0 (remain_string);
	}
	if (remain_length > 0) {
		GPtrArray* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = splitted;
		_tmp14_ = string_substring (str, (glong) offset, (glong) remain_length);
		g_ptr_array_add (_tmp13_, _tmp14_);
	}
	result = splitted;
	return result;
}

static void
pamac_cli_print_aligned (PamacCli* self,
                         const gchar* str1,
                         const gchar* str2,
                         gint width)
{
	GString* str_builder = NULL;
	GString* _tmp0_;
	gint diff = 0;
	GString* _tmp3_;
	FILE* _tmp4_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str1 != NULL);
	g_return_if_fail (str2 != NULL);
	_tmp0_ = g_string_new (str1);
	str_builder = _tmp0_;
	diff = width - g_utf8_strlen (str1, (gssize) -1);
	if (diff > 0) {
		while (TRUE) {
			GString* _tmp1_;
			gint _tmp2_;
			if (!(diff > 0)) {
				break;
			}
			_tmp1_ = str_builder;
			g_string_append (_tmp1_, " ");
			_tmp2_ = diff;
			diff = _tmp2_ - 1;
		}
	}
	_tmp3_ = str_builder;
	g_string_append (_tmp3_, str2);
	_tmp4_ = stdout;
	_tmp5_ = str_builder;
	_tmp6_ = _tmp5_->str;
	fprintf (_tmp4_, "%s\n", _tmp6_);
	_g_string_free0 (str_builder);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
pamac_cli_print_property (PamacCli* self,
                          const gchar* property,
                          const gchar* val,
                          gint width)
{
	GPtrArray* cuts = NULL;
	GPtrArray* _tmp2_;
	guint length = 0U;
	GPtrArray* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (property != NULL);
	if (val == NULL) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf (" : %s", g_dgettext (NULL, "None"));
		_tmp1_ = _tmp0_;
		pamac_cli_print_aligned (self, property, _tmp1_, width);
		_g_free0 (_tmp1_);
		return;
	}
	_tmp2_ = pamac_cli_split_string (self, val, width + 3, 0);
	cuts = _tmp2_;
	_tmp3_ = cuts;
	_tmp4_ = vala_g_ptr_array_get_length (_tmp3_);
	_tmp5_ = _tmp4_;
	length = (guint) _tmp5_;
	if (length > ((guint) 0)) {
		GPtrArray* _tmp6_;
		gconstpointer _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		guint i = 0U;
		_tmp6_ = cuts;
		_tmp7_ = g_ptr_array_index (_tmp6_, (guint) 0);
		_tmp8_ = g_strdup_printf (" : %s", (const gchar*) _tmp7_);
		_tmp9_ = _tmp8_;
		pamac_cli_print_aligned (self, property, _tmp9_, width);
		_g_free0 (_tmp9_);
		i = (guint) 1;
		while (TRUE) {
			GPtrArray* _tmp10_;
			gconstpointer _tmp11_;
			guint _tmp12_;
			if (!(i < length)) {
				break;
			}
			_tmp10_ = cuts;
			_tmp11_ = g_ptr_array_index (_tmp10_, i);
			pamac_cli_print_aligned (self, "", (const gchar*) _tmp11_, width + 3);
			_tmp12_ = i;
			i = _tmp12_ + 1;
		}
	}
	_g_ptr_array_unref0 (cuts);
}

static void
pamac_cli_print_property_list (PamacCli* self,
                               const gchar* property,
                               GPtrArray* list,
                               gint width)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (property != NULL);
	g_return_if_fail (list != NULL);
	_tmp0_ = vala_g_ptr_array_get_length (list);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > 0) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = pamac_cli_concatenate_strings_list (self, list);
		_tmp3_ = _tmp2_;
		pamac_cli_print_property (self, property, _tmp3_, width);
		_g_free0 (_tmp3_);
	} else {
		pamac_cli_print_property (self, property, "--", width);
	}
}

static void
pamac_cli_print_error (PamacCli* self,
                       const gchar* message)
{
	FILE* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s: %s\n", g_dgettext (NULL, "Error"), message);
	self->exit_status = 1;
}

static void
pamac_cli_display_version (PamacCli* self)
{
	FILE* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	FILE* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	_tmp1_ = pamac_get_version ();
	_tmp2_ = _tmp1_;
	fprintf (_tmp0_, "pamac-cli %s  -  libpamac %s\n", VERSION, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Copyright © 2019-2024 Guillaume Benoit\n");
	_tmp4_ = stdout;
	fprintf (_tmp4_, "This program is free software, you can redistribute it under the terms" \
" of the GNU GPL.\n");
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
pamac_cli_display_help (PamacCli* self)
{
	gchar** actions = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint actions_length1;
	gint _actions_size_;
	gchar** options_actions = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gint options_actions_length1;
	gint _options_actions_size_;
	gchar** targets_actions = NULL;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gint targets_actions_length1;
	gint _targets_actions_size_;
	FILE* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("--version");
	_tmp1_ = g_strdup ("--help, -h");
	_tmp2_ = g_strdup ("search");
	_tmp3_ = g_strdup ("list");
	_tmp4_ = g_strdup ("info");
	_tmp5_ = g_strdup ("install");
	_tmp6_ = g_strdup ("reinstall");
	_tmp7_ = g_strdup ("remove");
	_tmp8_ = g_strdup ("checkupdates");
	_tmp9_ = g_strdup ("update,upgrade");
	_tmp10_ = g_strdup ("clone");
	_tmp11_ = g_strdup ("build");
	_tmp12_ = g_strdup ("clean");
	_tmp13_ = g_new0 (gchar*, 13 + 1);
	_tmp13_[0] = _tmp0_;
	_tmp13_[1] = _tmp1_;
	_tmp13_[2] = _tmp2_;
	_tmp13_[3] = _tmp3_;
	_tmp13_[4] = _tmp4_;
	_tmp13_[5] = _tmp5_;
	_tmp13_[6] = _tmp6_;
	_tmp13_[7] = _tmp7_;
	_tmp13_[8] = _tmp8_;
	_tmp13_[9] = _tmp9_;
	_tmp13_[10] = _tmp10_;
	_tmp13_[11] = _tmp11_;
	_tmp13_[12] = _tmp12_;
	actions = _tmp13_;
	actions_length1 = 13;
	_actions_size_ = actions_length1;
	_tmp14_ = g_strdup ("clean");
	_tmp15_ = g_strdup ("checkupdates");
	_tmp16_ = g_strdup ("update,upgrade");
	_tmp17_ = g_strdup ("search");
	_tmp18_ = g_strdup ("info");
	_tmp19_ = g_strdup ("list");
	_tmp20_ = g_strdup ("install");
	_tmp21_ = g_strdup ("reinstall");
	_tmp22_ = g_strdup ("build");
	_tmp23_ = g_strdup ("clone");
	_tmp24_ = g_strdup ("remove");
	_tmp25_ = g_new0 (gchar*, 11 + 1);
	_tmp25_[0] = _tmp14_;
	_tmp25_[1] = _tmp15_;
	_tmp25_[2] = _tmp16_;
	_tmp25_[3] = _tmp17_;
	_tmp25_[4] = _tmp18_;
	_tmp25_[5] = _tmp19_;
	_tmp25_[6] = _tmp20_;
	_tmp25_[7] = _tmp21_;
	_tmp25_[8] = _tmp22_;
	_tmp25_[9] = _tmp23_;
	_tmp25_[10] = _tmp24_;
	options_actions = _tmp25_;
	options_actions_length1 = 11;
	_options_actions_size_ = options_actions_length1;
	_tmp26_ = g_strdup ("search");
	_tmp27_ = g_strdup ("info");
	_tmp28_ = g_strdup ("install");
	_tmp29_ = g_strdup ("reinstall");
	_tmp30_ = g_strdup ("build");
	_tmp31_ = g_strdup ("clone");
	_tmp32_ = g_strdup ("remove");
	_tmp33_ = g_new0 (gchar*, 7 + 1);
	_tmp33_[0] = _tmp26_;
	_tmp33_[1] = _tmp27_;
	_tmp33_[2] = _tmp28_;
	_tmp33_[3] = _tmp29_;
	_tmp33_[4] = _tmp30_;
	_tmp33_[5] = _tmp31_;
	_tmp33_[6] = _tmp32_;
	targets_actions = _tmp33_;
	targets_actions_length1 = 7;
	_targets_actions_size_ = targets_actions_length1;
	_tmp34_ = stdout;
	_tmp35_ = g_strconcat (g_dgettext (NULL, "Available actions"), ":\n", NULL);
	_tmp36_ = _tmp35_;
	fprintf (_tmp34_, "%s", _tmp36_);
	_g_free0 (_tmp36_);
	_tmp37_ = actions;
	_tmp37__length1 = actions_length1;
	{
		gchar** action_collection = NULL;
		gint action_collection_length1 = 0;
		gint _action_collection_size_ = 0;
		gint action_it = 0;
		action_collection = _tmp37_;
		action_collection_length1 = _tmp37__length1;
		for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
			const gchar* action = NULL;
			action = action_collection[action_it];
			{
				FILE* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp46_;
				gchar** _tmp47_;
				gint _tmp47__length1;
				const gchar* _tmp51_;
				gchar** _tmp52_;
				gint _tmp52__length1;
				FILE* _tmp62_;
				_tmp38_ = stdout;
				_tmp39_ = action;
				_tmp40_ = g_strdup_printf ("  pamac %-14s", _tmp39_);
				_tmp41_ = _tmp40_;
				fprintf (_tmp38_, "%s", _tmp41_);
				_g_free0 (_tmp41_);
				_tmp42_ = action;
				if (g_strcmp0 (_tmp42_, "--help, -h") == 0) {
					FILE* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					_tmp43_ = stdout;
					_tmp44_ = g_strdup_printf (" [%s]", g_dgettext (NULL, "action"));
					_tmp45_ = _tmp44_;
					fprintf (_tmp43_, "%s", _tmp45_);
					_g_free0 (_tmp45_);
				}
				_tmp46_ = action;
				_tmp47_ = options_actions;
				_tmp47__length1 = options_actions_length1;
				if (_vala_string_array_contains (_tmp47_, _tmp47__length1, _tmp46_)) {
					FILE* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					_tmp48_ = stdout;
					_tmp49_ = g_strdup_printf (" [%s]", g_dgettext (NULL, "options"));
					_tmp50_ = _tmp49_;
					fprintf (_tmp48_, "%s", _tmp50_);
					_g_free0 (_tmp50_);
				}
				_tmp51_ = action;
				_tmp52_ = targets_actions;
				_tmp52__length1 = targets_actions_length1;
				if (_vala_string_array_contains (_tmp52_, _tmp52__length1, _tmp51_)) {
					gboolean _tmp53_ = FALSE;
					const gchar* _tmp54_;
					_tmp54_ = action;
					if (g_strcmp0 (_tmp54_, "remove") == 0) {
						_tmp53_ = TRUE;
					} else {
						const gchar* _tmp55_;
						_tmp55_ = action;
						_tmp53_ = g_strcmp0 (_tmp55_, "build") == 0;
					}
					if (_tmp53_) {
						FILE* _tmp56_;
						gchar* _tmp57_;
						gchar* _tmp58_;
						_tmp56_ = stdout;
						_tmp57_ = g_strdup_printf (" [%s]", g_dgettext (NULL, "package(s)"));
						_tmp58_ = _tmp57_;
						fprintf (_tmp56_, "%s", _tmp58_);
						_g_free0 (_tmp58_);
					} else {
						FILE* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						_tmp59_ = stdout;
						_tmp60_ = g_strdup_printf (" <%s>", g_dgettext (NULL, "package(s)"));
						_tmp61_ = _tmp60_;
						fprintf (_tmp59_, "%s", _tmp61_);
						_g_free0 (_tmp61_);
					}
				}
				_tmp62_ = stdout;
				fprintf (_tmp62_, "\n");
			}
		}
	}
	targets_actions = (_vala_array_free (targets_actions, targets_actions_length1, (GDestroyNotify) g_free), NULL);
	options_actions = (_vala_array_free (options_actions, options_actions_length1, (GDestroyNotify) g_free), NULL);
	actions = (_vala_array_free (actions, actions_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_search_help (PamacCli* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FILE* _tmp7_;
	FILE* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gint max_length = 0;
	gchar** options = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** details = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gint details_length1;
	gint _details_size_;
	gint i = 0;
	gchar** _tmp27_;
	gint _tmp27__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "Search for packages or files, multiple search terms can be specified"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n\n");
	_tmp2_ = stdout;
	_tmp3_ = g_strdup_printf ("%s/%s", g_dgettext (NULL, "package(s)"), g_dgettext (NULL, "file(s)"));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("pamac search [%s] <%s>", g_dgettext (NULL, "options"), _tmp4_);
	_tmp6_ = _tmp5_;
	fprintf (_tmp2_, "%s", _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = stdout;
	fprintf (_tmp7_, "\n\n");
	_tmp8_ = stdout;
	_tmp9_ = g_strconcat (g_dgettext (NULL, "options"), ":\n", NULL);
	_tmp10_ = _tmp9_;
	fprintf (_tmp8_, "%s", _tmp10_);
	_g_free0 (_tmp10_);
	max_length = 0;
	_tmp11_ = g_strdup ("  --installed, -i");
	_tmp12_ = g_strdup ("  --repos, -r");
	_tmp13_ = g_strdup ("  --aur, -a");
	_tmp14_ = g_strdup ("  --no-aur");
	_tmp15_ = g_strdup ("  --files, -f");
	_tmp16_ = g_strdup ("  --quiet, -q");
	_tmp17_ = g_new0 (gchar*, 6 + 1);
	_tmp17_[0] = _tmp11_;
	_tmp17_[1] = _tmp12_;
	_tmp17_[2] = _tmp13_;
	_tmp17_[3] = _tmp14_;
	_tmp17_[4] = _tmp15_;
	_tmp17_[5] = _tmp16_;
	options = _tmp17_;
	options_length1 = 6;
	_options_size_ = options_length1;
	_tmp18_ = options;
	_tmp18__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp18_;
		option_collection_length1 = _tmp18__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				gint length = 0;
				const gchar* _tmp19_;
				_tmp19_ = option;
				length = g_utf8_strlen (_tmp19_, (gssize) -1);
				if (length > max_length) {
					max_length = length;
				}
			}
		}
	}
	_tmp20_ = g_strdup (g_dgettext (NULL, "only search for installed packages"));
	_tmp21_ = g_strdup (g_dgettext (NULL, "only search for packages in repositories"));
	_tmp22_ = g_strdup (g_dgettext (NULL, "also search in AUR"));
	_tmp23_ = g_strdup (g_dgettext (NULL, "do not search in AUR"));
	_tmp24_ = g_strdup (g_dgettext (NULL, "search for packages which own the given filenames (filenames can be pa" \
"rtial)"));
	_tmp25_ = g_strdup (g_dgettext (NULL, "only print names"));
	_tmp26_ = g_new0 (gchar*, 6 + 1);
	_tmp26_[0] = _tmp20_;
	_tmp26_[1] = _tmp21_;
	_tmp26_[2] = _tmp22_;
	_tmp26_[3] = _tmp23_;
	_tmp26_[4] = _tmp24_;
	_tmp26_[5] = _tmp25_;
	details = _tmp26_;
	details_length1 = 6;
	_details_size_ = details_length1;
	i = 0;
	_tmp27_ = options;
	_tmp27__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp27_;
		option_collection_length1 = _tmp27__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp28_;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp30_;
				gint _tmp31_;
				_tmp28_ = option;
				_tmp29_ = details;
				_tmp29__length1 = details_length1;
				_tmp30_ = _tmp29_[i];
				pamac_cli_print_property (self, _tmp28_, _tmp30_, max_length);
				_tmp31_ = i;
				i = _tmp31_ + 1;
			}
		}
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_info_help (PamacCli* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint max_length = 0;
	gchar** options = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** details = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint details_length1;
	gint _details_size_;
	gint i = 0;
	gchar** _tmp17_;
	gint _tmp17__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "Display package details, multiple packages can be specified"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n\n");
	_tmp2_ = stdout;
	_tmp3_ = g_strdup_printf ("pamac info [%s] <%s>", g_dgettext (NULL, "options"), g_dgettext (NULL, "package(s)"));
	_tmp4_ = _tmp3_;
	fprintf (_tmp2_, "%s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = stdout;
	fprintf (_tmp5_, "\n\n");
	_tmp6_ = stdout;
	_tmp7_ = g_strconcat (g_dgettext (NULL, "options"), ":\n", NULL);
	_tmp8_ = _tmp7_;
	fprintf (_tmp6_, "%s", _tmp8_);
	_g_free0 (_tmp8_);
	max_length = 0;
	_tmp9_ = g_strdup ("  --aur, -a");
	_tmp10_ = g_strdup ("  --no-aur");
	_tmp11_ = g_new0 (gchar*, 2 + 1);
	_tmp11_[0] = _tmp9_;
	_tmp11_[1] = _tmp10_;
	options = _tmp11_;
	options_length1 = 2;
	_options_size_ = options_length1;
	_tmp12_ = options;
	_tmp12__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp12_;
		option_collection_length1 = _tmp12__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				gint length = 0;
				const gchar* _tmp13_;
				_tmp13_ = option;
				length = g_utf8_strlen (_tmp13_, (gssize) -1);
				if (length > max_length) {
					max_length = length;
				}
			}
		}
	}
	_tmp14_ = g_strdup (g_dgettext (NULL, "also search in AUR"));
	_tmp15_ = g_strdup (g_dgettext (NULL, "do not search in AUR"));
	_tmp16_ = g_new0 (gchar*, 2 + 1);
	_tmp16_[0] = _tmp14_;
	_tmp16_[1] = _tmp15_;
	details = _tmp16_;
	details_length1 = 2;
	_details_size_ = details_length1;
	i = 0;
	_tmp17_ = options;
	_tmp17__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp17_;
		option_collection_length1 = _tmp17__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				gint _tmp21_;
				_tmp18_ = option;
				_tmp19_ = details;
				_tmp19__length1 = details_length1;
				_tmp20_ = _tmp19_[i];
				pamac_cli_print_property (self, _tmp18_, _tmp20_, max_length);
				_tmp21_ = i;
				i = _tmp21_ + 1;
			}
		}
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_list_help (PamacCli* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint max_length = 0;
	gchar** options = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** details = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gint details_length1;
	gint _details_size_;
	gint i = 0;
	gchar** _tmp29_;
	gint _tmp29__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "List packages, groups, repositories or files"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n\n");
	_tmp2_ = stdout;
	_tmp3_ = g_strdup_printf ("pamac list [%s]", g_dgettext (NULL, "options"));
	_tmp4_ = _tmp3_;
	fprintf (_tmp2_, "%s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = stdout;
	fprintf (_tmp5_, "\n\n");
	_tmp6_ = stdout;
	_tmp7_ = g_strconcat (g_dgettext (NULL, "options"), ":\n", NULL);
	_tmp8_ = _tmp7_;
	fprintf (_tmp6_, "%s", _tmp8_);
	_g_free0 (_tmp8_);
	max_length = 0;
	_tmp9_ = g_strdup ("  --installed, -i");
	_tmp10_ = g_strdup ("  --explicitly-installed, -e");
	_tmp11_ = g_strdup ("  --orphans, -o");
	_tmp12_ = g_strdup ("  --foreign, -m");
	_tmp13_ = g_strdup_printf ("  --groups, -g [%s]", g_dgettext (NULL, "group(s)"));
	_tmp14_ = g_strdup_printf ("  --repos, -r [%s]", g_dgettext (NULL, "repo(s)"));
	_tmp15_ = g_strdup_printf ("  --files, -f <%s>", g_dgettext (NULL, "package(s)"));
	_tmp16_ = g_strdup ("  --quiet, -q");
	_tmp17_ = g_new0 (gchar*, 8 + 1);
	_tmp17_[0] = _tmp9_;
	_tmp17_[1] = _tmp10_;
	_tmp17_[2] = _tmp11_;
	_tmp17_[3] = _tmp12_;
	_tmp17_[4] = _tmp13_;
	_tmp17_[5] = _tmp14_;
	_tmp17_[6] = _tmp15_;
	_tmp17_[7] = _tmp16_;
	options = _tmp17_;
	options_length1 = 8;
	_options_size_ = options_length1;
	_tmp18_ = options;
	_tmp18__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp18_;
		option_collection_length1 = _tmp18__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				gint length = 0;
				const gchar* _tmp19_;
				_tmp19_ = option;
				length = g_utf8_strlen (_tmp19_, (gssize) -1);
				if (length > max_length) {
					max_length = length;
				}
			}
		}
	}
	_tmp20_ = g_strdup (g_dgettext (NULL, "list installed packages"));
	_tmp21_ = g_strdup (g_dgettext (NULL, "list explicitly installed packages"));
	_tmp22_ = g_strdup (g_dgettext (NULL, "list packages that were installed as dependencies but are no longer re" \
"quired by any installed package"));
	_tmp23_ = g_strdup (g_dgettext (NULL, "list packages that were not found in the repositories"));
	_tmp24_ = g_strdup (g_dgettext (NULL, "list all packages that are members of the given groups, if no group is" \
" given list all groups"));
	_tmp25_ = g_strdup (g_dgettext (NULL, "list all packages available in the given repos, if no repo is given li" \
"st all repos"));
	_tmp26_ = g_strdup (g_dgettext (NULL, "list files owned by the given packages"));
	_tmp27_ = g_strdup (g_dgettext (NULL, "only print names"));
	_tmp28_ = g_new0 (gchar*, 8 + 1);
	_tmp28_[0] = _tmp20_;
	_tmp28_[1] = _tmp21_;
	_tmp28_[2] = _tmp22_;
	_tmp28_[3] = _tmp23_;
	_tmp28_[4] = _tmp24_;
	_tmp28_[5] = _tmp25_;
	_tmp28_[6] = _tmp26_;
	_tmp28_[7] = _tmp27_;
	details = _tmp28_;
	details_length1 = 8;
	_details_size_ = details_length1;
	i = 0;
	_tmp29_ = options;
	_tmp29__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp29_;
		option_collection_length1 = _tmp29__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp30_;
				gchar** _tmp31_;
				gint _tmp31__length1;
				const gchar* _tmp32_;
				gint _tmp33_;
				_tmp30_ = option;
				_tmp31_ = details;
				_tmp31__length1 = details_length1;
				_tmp32_ = _tmp31_[i];
				pamac_cli_print_property (self, _tmp30_, _tmp32_, max_length);
				_tmp33_ = i;
				i = _tmp33_ + 1;
			}
		}
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_clone_help (PamacCli* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint max_length = 0;
	gchar** options = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** details = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gint details_length1;
	gint _details_size_;
	gint i = 0;
	gchar** _tmp21_;
	gint _tmp21__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "Clone or sync packages build files from AUR"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n\n");
	_tmp2_ = stdout;
	_tmp3_ = g_strdup_printf ("pamac clone [%s] <%s>", g_dgettext (NULL, "options"), g_dgettext (NULL, "package(s)"));
	_tmp4_ = _tmp3_;
	fprintf (_tmp2_, "%s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = stdout;
	fprintf (_tmp5_, "\n\n");
	_tmp6_ = stdout;
	_tmp7_ = g_strconcat (g_dgettext (NULL, "options"), ":\n", NULL);
	_tmp8_ = _tmp7_;
	fprintf (_tmp6_, "%s", _tmp8_);
	_g_free0 (_tmp8_);
	max_length = 0;
	_tmp9_ = g_strdup_printf ("  --builddir <%s>", g_dgettext (NULL, "dir"));
	_tmp10_ = g_strdup ("  --recurse, -r");
	_tmp11_ = g_strdup ("  --quiet, -q");
	_tmp12_ = g_strdup ("  --overwrite");
	_tmp13_ = g_new0 (gchar*, 4 + 1);
	_tmp13_[0] = _tmp9_;
	_tmp13_[1] = _tmp10_;
	_tmp13_[2] = _tmp11_;
	_tmp13_[3] = _tmp12_;
	options = _tmp13_;
	options_length1 = 4;
	_options_size_ = options_length1;
	_tmp14_ = options;
	_tmp14__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp14_;
		option_collection_length1 = _tmp14__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				gint length = 0;
				const gchar* _tmp15_;
				_tmp15_ = option;
				length = g_utf8_strlen (_tmp15_, (gssize) -1);
				if (length > max_length) {
					max_length = length;
				}
			}
		}
	}
	_tmp16_ = g_strdup (g_dgettext (NULL, "build directory, if no directory is given the one specified in pamac.c" \
"onf file is used"));
	_tmp17_ = g_strdup (g_dgettext (NULL, "also clone needed dependencies"));
	_tmp18_ = g_strdup (g_dgettext (NULL, "do not print any output"));
	_tmp19_ = g_strdup (g_dgettext (NULL, "overwrite existing files"));
	_tmp20_ = g_new0 (gchar*, 4 + 1);
	_tmp20_[0] = _tmp16_;
	_tmp20_[1] = _tmp17_;
	_tmp20_[2] = _tmp18_;
	_tmp20_[3] = _tmp19_;
	details = _tmp20_;
	details_length1 = 4;
	_details_size_ = details_length1;
	i = 0;
	_tmp21_ = options;
	_tmp21__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp21_;
		option_collection_length1 = _tmp21__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				gint _tmp25_;
				_tmp22_ = option;
				_tmp23_ = details;
				_tmp23__length1 = details_length1;
				_tmp24_ = _tmp23_[i];
				pamac_cli_print_property (self, _tmp22_, _tmp24_, max_length);
				_tmp25_ = i;
				i = _tmp25_ + 1;
			}
		}
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_build_help (PamacCli* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	FILE* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	FILE* _tmp7_;
	FILE* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	FILE* _tmp11_;
	FILE* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint max_length = 0;
	gchar** options = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** details = NULL;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gint details_length1;
	gint _details_size_;
	gint i = 0;
	gchar** _tmp31_;
	gint _tmp31__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "Build packages from AUR and install them with their dependencies"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n\n");
	_tmp2_ = stdout;
	fprintf (_tmp2_, "%s", g_dgettext (NULL, "If no package name is given, use the PKGBUILD file in the current dire" \
"ctory"));
	_tmp3_ = stdout;
	fprintf (_tmp3_, "\n");
	_tmp4_ = stdout;
	fprintf (_tmp4_, "%s", g_dgettext (NULL, "The build directory will be the parent directory, --builddir option wi" \
"ll be ignored"));
	_tmp5_ = stdout;
	fprintf (_tmp5_, "\n");
	_tmp6_ = stdout;
	fprintf (_tmp6_, "%s", g_dgettext (NULL, "and --no-clone option will be enforced"));
	_tmp7_ = stdout;
	fprintf (_tmp7_, "\n\n");
	_tmp8_ = stdout;
	_tmp9_ = g_strdup_printf ("pamac build [%s] [%s]", g_dgettext (NULL, "options"), g_dgettext (NULL, "package(s)"));
	_tmp10_ = _tmp9_;
	fprintf (_tmp8_, "%s", _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = stdout;
	fprintf (_tmp11_, "\n\n");
	_tmp12_ = stdout;
	_tmp13_ = g_strconcat (g_dgettext (NULL, "options"), ":\n", NULL);
	_tmp14_ = _tmp13_;
	fprintf (_tmp12_, "%s", _tmp14_);
	_g_free0 (_tmp14_);
	max_length = 0;
	_tmp15_ = g_strdup_printf ("  --builddir <%s>", g_dgettext (NULL, "dir"));
	_tmp16_ = g_strdup ("  --keep, -k");
	_tmp17_ = g_strdup ("  --no-keep");
	_tmp18_ = g_strdup ("  --dry-run, -d");
	_tmp19_ = g_strdup ("  --no-clone");
	_tmp20_ = g_strdup ("  --no-confirm");
	_tmp21_ = g_new0 (gchar*, 6 + 1);
	_tmp21_[0] = _tmp15_;
	_tmp21_[1] = _tmp16_;
	_tmp21_[2] = _tmp17_;
	_tmp21_[3] = _tmp18_;
	_tmp21_[4] = _tmp19_;
	_tmp21_[5] = _tmp20_;
	options = _tmp21_;
	options_length1 = 6;
	_options_size_ = options_length1;
	_tmp22_ = options;
	_tmp22__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp22_;
		option_collection_length1 = _tmp22__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				gint length = 0;
				const gchar* _tmp23_;
				_tmp23_ = option;
				length = g_utf8_strlen (_tmp23_, (gssize) -1);
				if (length > max_length) {
					max_length = length;
				}
			}
		}
	}
	_tmp24_ = g_strdup (g_dgettext (NULL, "build directory, if no directory is given the one specified in pamac.c" \
"onf file is used"));
	_tmp25_ = g_strdup (g_dgettext (NULL, "keep built packages in cache after installation"));
	_tmp26_ = g_strdup (g_dgettext (NULL, "do not keep built packages in cache after installation"));
	_tmp27_ = g_strdup (g_dgettext (NULL, "only print what would be done but do not run the transaction"));
	_tmp28_ = g_strdup (g_dgettext (NULL, "do not clone build files from AUR, only use local files"));
	_tmp29_ = g_strdup (g_dgettext (NULL, "bypass any and all confirmation messages"));
	_tmp30_ = g_new0 (gchar*, 6 + 1);
	_tmp30_[0] = _tmp24_;
	_tmp30_[1] = _tmp25_;
	_tmp30_[2] = _tmp26_;
	_tmp30_[3] = _tmp27_;
	_tmp30_[4] = _tmp28_;
	_tmp30_[5] = _tmp29_;
	details = _tmp30_;
	details_length1 = 6;
	_details_size_ = details_length1;
	i = 0;
	_tmp31_ = options;
	_tmp31__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp31_;
		option_collection_length1 = _tmp31__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp32_;
				gchar** _tmp33_;
				gint _tmp33__length1;
				const gchar* _tmp34_;
				gint _tmp35_;
				_tmp32_ = option;
				_tmp33_ = details;
				_tmp33__length1 = details_length1;
				_tmp34_ = _tmp33_[i];
				pamac_cli_print_property (self, _tmp32_, _tmp34_, max_length);
				_tmp35_ = i;
				i = _tmp35_ + 1;
			}
		}
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_install_help (PamacCli* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FILE* _tmp7_;
	FILE* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gint max_length = 0;
	gchar** options = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar** details = NULL;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gint details_length1;
	gint _details_size_;
	gint i = 0;
	gchar** _tmp33_;
	gint _tmp33__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "Install packages from repositories, path or url"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n\n");
	_tmp2_ = stdout;
	_tmp3_ = g_strdup_printf ("%s,%s", g_dgettext (NULL, "package(s)"), g_dgettext (NULL, "group(s)"));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("pamac install [%s] <%s>", g_dgettext (NULL, "options"), _tmp4_);
	_tmp6_ = _tmp5_;
	fprintf (_tmp2_, "%s", _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = stdout;
	fprintf (_tmp7_, "\n\n");
	_tmp8_ = stdout;
	_tmp9_ = g_strconcat (g_dgettext (NULL, "options"), ":\n", NULL);
	_tmp10_ = _tmp9_;
	fprintf (_tmp8_, "%s", _tmp10_);
	_g_free0 (_tmp10_);
	max_length = 0;
	_tmp11_ = g_strdup_printf ("  --ignore <%s>", g_dgettext (NULL, "package(s)"));
	_tmp12_ = g_strdup_printf ("  --overwrite <%s>", g_dgettext (NULL, "glob"));
	_tmp13_ = g_strdup ("  --download-only, -w");
	_tmp14_ = g_strdup ("  --dry-run, -d");
	_tmp15_ = g_strdup ("  --as-deps");
	_tmp16_ = g_strdup ("  --as-explicit");
	_tmp17_ = g_strdup ("  --upgrade");
	_tmp18_ = g_strdup ("  --no-upgrade");
	_tmp19_ = g_strdup ("  --no-confirm");
	_tmp20_ = g_new0 (gchar*, 9 + 1);
	_tmp20_[0] = _tmp11_;
	_tmp20_[1] = _tmp12_;
	_tmp20_[2] = _tmp13_;
	_tmp20_[3] = _tmp14_;
	_tmp20_[4] = _tmp15_;
	_tmp20_[5] = _tmp16_;
	_tmp20_[6] = _tmp17_;
	_tmp20_[7] = _tmp18_;
	_tmp20_[8] = _tmp19_;
	options = _tmp20_;
	options_length1 = 9;
	_options_size_ = options_length1;
	_tmp21_ = options;
	_tmp21__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp21_;
		option_collection_length1 = _tmp21__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				gint length = 0;
				const gchar* _tmp22_;
				_tmp22_ = option;
				length = g_utf8_strlen (_tmp22_, (gssize) -1);
				if (length > max_length) {
					max_length = length;
				}
			}
		}
	}
	_tmp23_ = g_strdup (g_dgettext (NULL, "ignore a package upgrade, multiple packages can be specified by separa" \
"ting them with a comma"));
	_tmp24_ = g_strdup (g_dgettext (NULL, "overwrite conflicting files, multiple patterns can be specified by sep" \
"arating them with a comma"));
	_tmp25_ = g_strdup (g_dgettext (NULL, "download all packages but do not install/upgrade anything"));
	_tmp26_ = g_strdup (g_dgettext (NULL, "only print what would be done but do not run the transaction"));
	_tmp27_ = g_strdup (g_dgettext (NULL, "mark all packages installed as a dependency"));
	_tmp28_ = g_strdup (g_dgettext (NULL, "mark all packages explicitly installed"));
	_tmp29_ = g_strdup (g_dgettext (NULL, "check for updates"));
	_tmp30_ = g_strdup (g_dgettext (NULL, "do not check for updates"));
	_tmp31_ = g_strdup (g_dgettext (NULL, "bypass any and all confirmation messages"));
	_tmp32_ = g_new0 (gchar*, 9 + 1);
	_tmp32_[0] = _tmp23_;
	_tmp32_[1] = _tmp24_;
	_tmp32_[2] = _tmp25_;
	_tmp32_[3] = _tmp26_;
	_tmp32_[4] = _tmp27_;
	_tmp32_[5] = _tmp28_;
	_tmp32_[6] = _tmp29_;
	_tmp32_[7] = _tmp30_;
	_tmp32_[8] = _tmp31_;
	details = _tmp32_;
	details_length1 = 9;
	_details_size_ = details_length1;
	i = 0;
	_tmp33_ = options;
	_tmp33__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp33_;
		option_collection_length1 = _tmp33__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				const gchar* _tmp36_;
				gint _tmp37_;
				_tmp34_ = option;
				_tmp35_ = details;
				_tmp35__length1 = details_length1;
				_tmp36_ = _tmp35_[i];
				pamac_cli_print_property (self, _tmp34_, _tmp36_, max_length);
				_tmp37_ = i;
				i = _tmp37_ + 1;
			}
		}
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_reinstall_help (PamacCli* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FILE* _tmp7_;
	FILE* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gint max_length = 0;
	gchar** options = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** details = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gint details_length1;
	gint _details_size_;
	gint i = 0;
	gchar** _tmp25_;
	gint _tmp25__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "Reinstall packages"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n\n");
	_tmp2_ = stdout;
	_tmp3_ = g_strdup_printf ("%s,%s", g_dgettext (NULL, "package(s)"), g_dgettext (NULL, "group(s)"));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("pamac reinstall <%s>", _tmp4_);
	_tmp6_ = _tmp5_;
	fprintf (_tmp2_, "%s", _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = stdout;
	fprintf (_tmp7_, "\n\n");
	_tmp8_ = stdout;
	_tmp9_ = g_strconcat (g_dgettext (NULL, "options"), ":\n", NULL);
	_tmp10_ = _tmp9_;
	fprintf (_tmp8_, "%s", _tmp10_);
	_g_free0 (_tmp10_);
	max_length = 0;
	_tmp11_ = g_strdup_printf ("  --overwrite <%s>", g_dgettext (NULL, "glob"));
	_tmp12_ = g_strdup ("  --download-only, -w");
	_tmp13_ = g_strdup ("  --as-deps");
	_tmp14_ = g_strdup ("  --as-explicit");
	_tmp15_ = g_strdup ("  --no-confirm");
	_tmp16_ = g_new0 (gchar*, 5 + 1);
	_tmp16_[0] = _tmp11_;
	_tmp16_[1] = _tmp12_;
	_tmp16_[2] = _tmp13_;
	_tmp16_[3] = _tmp14_;
	_tmp16_[4] = _tmp15_;
	options = _tmp16_;
	options_length1 = 5;
	_options_size_ = options_length1;
	_tmp17_ = options;
	_tmp17__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp17_;
		option_collection_length1 = _tmp17__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				gint length = 0;
				const gchar* _tmp18_;
				_tmp18_ = option;
				length = g_utf8_strlen (_tmp18_, (gssize) -1);
				if (length > max_length) {
					max_length = length;
				}
			}
		}
	}
	_tmp19_ = g_strdup (g_dgettext (NULL, "overwrite conflicting files, multiple patterns can be specified by sep" \
"arating them with a comma"));
	_tmp20_ = g_strdup (g_dgettext (NULL, "download all packages but do not install/upgrade anything"));
	_tmp21_ = g_strdup (g_dgettext (NULL, "mark all packages installed as a dependency"));
	_tmp22_ = g_strdup (g_dgettext (NULL, "mark all packages explicitly installed"));
	_tmp23_ = g_strdup (g_dgettext (NULL, "bypass any and all confirmation messages"));
	_tmp24_ = g_new0 (gchar*, 5 + 1);
	_tmp24_[0] = _tmp19_;
	_tmp24_[1] = _tmp20_;
	_tmp24_[2] = _tmp21_;
	_tmp24_[3] = _tmp22_;
	_tmp24_[4] = _tmp23_;
	details = _tmp24_;
	details_length1 = 5;
	_details_size_ = details_length1;
	i = 0;
	_tmp25_ = options;
	_tmp25__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp25_;
		option_collection_length1 = _tmp25__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp26_;
				gchar** _tmp27_;
				gint _tmp27__length1;
				const gchar* _tmp28_;
				gint _tmp29_;
				_tmp26_ = option;
				_tmp27_ = details;
				_tmp27__length1 = details_length1;
				_tmp28_ = _tmp27_[i];
				pamac_cli_print_property (self, _tmp26_, _tmp28_, max_length);
				_tmp29_ = i;
				i = _tmp29_ + 1;
			}
		}
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_remove_help (PamacCli* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FILE* _tmp7_;
	FILE* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gint max_length = 0;
	gchar** options = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar** details = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gint details_length1;
	gint _details_size_;
	gint i = 0;
	gchar** _tmp29_;
	gint _tmp29__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "Remove packages"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n\n");
	_tmp2_ = stdout;
	_tmp3_ = g_strdup_printf ("%s,%s", g_dgettext (NULL, "package(s)"), g_dgettext (NULL, "group(s)"));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("pamac remove [%s] [%s]", g_dgettext (NULL, "options"), _tmp4_);
	_tmp6_ = _tmp5_;
	fprintf (_tmp2_, "%s", _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = stdout;
	fprintf (_tmp7_, "\n\n");
	_tmp8_ = stdout;
	_tmp9_ = g_strconcat (g_dgettext (NULL, "options"), ":\n", NULL);
	_tmp10_ = _tmp9_;
	fprintf (_tmp8_, "%s", _tmp10_);
	_g_free0 (_tmp10_);
	max_length = 0;
	_tmp11_ = g_strdup ("  --unneeded, -u");
	_tmp12_ = g_strdup ("  --cascade, -c");
	_tmp13_ = g_strdup ("  --orphans, -o");
	_tmp14_ = g_strdup ("  --no-orphans");
	_tmp15_ = g_strdup ("  --no-save, -n");
	_tmp16_ = g_strdup ("  --dry-run, -d");
	_tmp17_ = g_strdup ("  --no-confirm");
	_tmp18_ = g_new0 (gchar*, 7 + 1);
	_tmp18_[0] = _tmp11_;
	_tmp18_[1] = _tmp12_;
	_tmp18_[2] = _tmp13_;
	_tmp18_[3] = _tmp14_;
	_tmp18_[4] = _tmp15_;
	_tmp18_[5] = _tmp16_;
	_tmp18_[6] = _tmp17_;
	options = _tmp18_;
	options_length1 = 7;
	_options_size_ = options_length1;
	_tmp19_ = options;
	_tmp19__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp19_;
		option_collection_length1 = _tmp19__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				gint length = 0;
				const gchar* _tmp20_;
				_tmp20_ = option;
				length = g_utf8_strlen (_tmp20_, (gssize) -1);
				if (length > max_length) {
					max_length = length;
				}
			}
		}
	}
	_tmp21_ = g_strdup (g_dgettext (NULL, "remove packages only if they are not required by any other packages"));
	_tmp22_ = g_strdup (g_dgettext (NULL, "remove all target packages, as well as all packages that depend on one" \
" or more target packages"));
	_tmp23_ = g_strdup (g_dgettext (NULL, "remove dependencies that are not required by other packages, if this o" \
"ption is used without package name remove all orphans"));
	_tmp24_ = g_strdup (g_dgettext (NULL, "do not remove dependencies that are not required by other packages"));
	_tmp25_ = g_strdup (g_dgettext (NULL, "ignore files backup"));
	_tmp26_ = g_strdup (g_dgettext (NULL, "only print what would be done but do not run the transaction"));
	_tmp27_ = g_strdup (g_dgettext (NULL, "bypass any and all confirmation messages"));
	_tmp28_ = g_new0 (gchar*, 7 + 1);
	_tmp28_[0] = _tmp21_;
	_tmp28_[1] = _tmp22_;
	_tmp28_[2] = _tmp23_;
	_tmp28_[3] = _tmp24_;
	_tmp28_[4] = _tmp25_;
	_tmp28_[5] = _tmp26_;
	_tmp28_[6] = _tmp27_;
	details = _tmp28_;
	details_length1 = 7;
	_details_size_ = details_length1;
	i = 0;
	_tmp29_ = options;
	_tmp29__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp29_;
		option_collection_length1 = _tmp29__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp30_;
				gchar** _tmp31_;
				gint _tmp31__length1;
				const gchar* _tmp32_;
				gint _tmp33_;
				_tmp30_ = option;
				_tmp31_ = details;
				_tmp31__length1 = details_length1;
				_tmp32_ = _tmp31_[i];
				pamac_cli_print_property (self, _tmp30_, _tmp32_, max_length);
				_tmp33_ = i;
				i = _tmp33_ + 1;
			}
		}
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_checkupdates_help (PamacCli* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	FILE* _tmp9_;
	FILE* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gint max_length = 0;
	gchar** options = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar** details = NULL;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gint details_length1;
	gint _details_size_;
	gint i = 0;
	gchar** _tmp29_;
	gint _tmp29__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "Safely check for updates without modifiying the databases"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n");
	_tmp2_ = stdout;
	_tmp3_ = g_strdup_printf ("(%s)", g_dgettext (NULL, "Exit code is 100 if updates are available"));
	_tmp4_ = _tmp3_;
	fprintf (_tmp2_, "%s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = stdout;
	fprintf (_tmp5_, "\n\n");
	_tmp6_ = stdout;
	_tmp7_ = g_strdup_printf ("pamac checkupdates [%s]", g_dgettext (NULL, "options"));
	_tmp8_ = _tmp7_;
	fprintf (_tmp6_, "%s", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = stdout;
	fprintf (_tmp9_, "\n\n");
	_tmp10_ = stdout;
	_tmp11_ = g_strconcat (g_dgettext (NULL, "options"), ":\n", NULL);
	_tmp12_ = _tmp11_;
	fprintf (_tmp10_, "%s", _tmp12_);
	_g_free0 (_tmp12_);
	max_length = 0;
	_tmp13_ = g_strdup_printf ("  --builddir <%s>", g_dgettext (NULL, "dir"));
	_tmp14_ = g_strdup ("  --aur, -a");
	_tmp15_ = g_strdup ("  --no-aur");
	_tmp16_ = g_strdup ("  --quiet, -q");
	_tmp17_ = g_strdup ("  --devel");
	_tmp18_ = g_strdup ("  --no-devel");
	_tmp19_ = g_new0 (gchar*, 6 + 1);
	_tmp19_[0] = _tmp13_;
	_tmp19_[1] = _tmp14_;
	_tmp19_[2] = _tmp15_;
	_tmp19_[3] = _tmp16_;
	_tmp19_[4] = _tmp17_;
	_tmp19_[5] = _tmp18_;
	options = _tmp19_;
	options_length1 = 6;
	_options_size_ = options_length1;
	_tmp20_ = options;
	_tmp20__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp20_;
		option_collection_length1 = _tmp20__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				gint length = 0;
				const gchar* _tmp21_;
				_tmp21_ = option;
				length = g_utf8_strlen (_tmp21_, (gssize) -1);
				if (length > max_length) {
					max_length = length;
				}
			}
		}
	}
	_tmp22_ = g_strdup (g_dgettext (NULL, "build directory (use with --devel), if no directory is given the one s" \
"pecified in pamac.conf file is used"));
	_tmp23_ = g_strdup (g_dgettext (NULL, "also check updates in AUR"));
	_tmp24_ = g_strdup (g_dgettext (NULL, "do not check updates in AUR"));
	_tmp25_ = g_strdup (g_dgettext (NULL, "only print one line per update"));
	_tmp26_ = g_strdup (g_dgettext (NULL, "also check development packages updates (use with --aur)"));
	_tmp27_ = g_strdup (g_dgettext (NULL, "do not check development packages updates"));
	_tmp28_ = g_new0 (gchar*, 6 + 1);
	_tmp28_[0] = _tmp22_;
	_tmp28_[1] = _tmp23_;
	_tmp28_[2] = _tmp24_;
	_tmp28_[3] = _tmp25_;
	_tmp28_[4] = _tmp26_;
	_tmp28_[5] = _tmp27_;
	details = _tmp28_;
	details_length1 = 6;
	_details_size_ = details_length1;
	i = 0;
	_tmp29_ = options;
	_tmp29__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp29_;
		option_collection_length1 = _tmp29__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp30_;
				gchar** _tmp31_;
				gint _tmp31__length1;
				const gchar* _tmp32_;
				gint _tmp33_;
				_tmp30_ = option;
				_tmp31_ = details;
				_tmp31__length1 = details_length1;
				_tmp32_ = _tmp31_[i];
				pamac_cli_print_property (self, _tmp30_, _tmp32_, max_length);
				_tmp33_ = i;
				i = _tmp33_ + 1;
			}
		}
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_upgrade_help (PamacCli* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint max_length = 0;
	gchar** options = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar** details = NULL;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar** _tmp40_;
	gint details_length1;
	gint _details_size_;
	gint i = 0;
	gchar** _tmp41_;
	gint _tmp41__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "Upgrade your system"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n\n");
	_tmp2_ = stdout;
	_tmp3_ = g_strdup_printf ("pamac upgrade,update [%s]", g_dgettext (NULL, "options"));
	_tmp4_ = _tmp3_;
	fprintf (_tmp2_, "%s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = stdout;
	fprintf (_tmp5_, "\n\n");
	_tmp6_ = stdout;
	_tmp7_ = g_strconcat (g_dgettext (NULL, "options"), ":\n", NULL);
	_tmp8_ = _tmp7_;
	fprintf (_tmp6_, "%s", _tmp8_);
	_g_free0 (_tmp8_);
	max_length = 0;
	_tmp9_ = g_strdup ("  --force-refresh");
	_tmp10_ = g_strdup ("  --no-refresh");
	_tmp11_ = g_strdup ("  --enable-downgrade");
	_tmp12_ = g_strdup ("  --disable-downgrade");
	_tmp13_ = g_strdup ("  --download-only, -w");
	_tmp14_ = g_strdup ("  --dry-run, -d");
	_tmp15_ = g_strdup_printf ("  --ignore <%s>", g_dgettext (NULL, "package(s)"));
	_tmp16_ = g_strdup_printf ("  --overwrite <%s>", g_dgettext (NULL, "glob"));
	_tmp17_ = g_strdup ("  --no-confirm");
	_tmp18_ = g_strdup ("  --aur, -a");
	_tmp19_ = g_strdup ("  --no-aur");
	_tmp20_ = g_strdup ("  --devel");
	_tmp21_ = g_strdup ("  --no-devel");
	_tmp22_ = g_strdup_printf ("  --builddir <%s>", g_dgettext (NULL, "dir"));
	_tmp23_ = g_new0 (gchar*, 14 + 1);
	_tmp23_[0] = _tmp9_;
	_tmp23_[1] = _tmp10_;
	_tmp23_[2] = _tmp11_;
	_tmp23_[3] = _tmp12_;
	_tmp23_[4] = _tmp13_;
	_tmp23_[5] = _tmp14_;
	_tmp23_[6] = _tmp15_;
	_tmp23_[7] = _tmp16_;
	_tmp23_[8] = _tmp17_;
	_tmp23_[9] = _tmp18_;
	_tmp23_[10] = _tmp19_;
	_tmp23_[11] = _tmp20_;
	_tmp23_[12] = _tmp21_;
	_tmp23_[13] = _tmp22_;
	options = _tmp23_;
	options_length1 = 14;
	_options_size_ = options_length1;
	_tmp24_ = options;
	_tmp24__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp24_;
		option_collection_length1 = _tmp24__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				gint length = 0;
				const gchar* _tmp25_;
				_tmp25_ = option;
				length = g_utf8_strlen (_tmp25_, (gssize) -1);
				if (length > max_length) {
					max_length = length;
				}
			}
		}
	}
	_tmp26_ = g_strdup (g_dgettext (NULL, "force the refresh of the databases"));
	_tmp27_ = g_strdup (g_dgettext (NULL, "do not refresh the databases"));
	_tmp28_ = g_strdup (g_dgettext (NULL, "enable package downgrades"));
	_tmp29_ = g_strdup (g_dgettext (NULL, "disable package downgrades"));
	_tmp30_ = g_strdup (g_dgettext (NULL, "download all packages but do not install/upgrade anything"));
	_tmp31_ = g_strdup (g_dgettext (NULL, "only print what would be done but do not run the transaction"));
	_tmp32_ = g_strdup (g_dgettext (NULL, "ignore a package upgrade, multiple packages can be specified by separa" \
"ting them with a comma"));
	_tmp33_ = g_strdup (g_dgettext (NULL, "overwrite conflicting files, multiple patterns can be specified by sep" \
"arating them with a comma"));
	_tmp34_ = g_strdup (g_dgettext (NULL, "bypass any and all confirmation messages"));
	_tmp35_ = g_strdup (g_dgettext (NULL, "also upgrade packages installed from AUR"));
	_tmp36_ = g_strdup (g_dgettext (NULL, "do not upgrade packages installed from AUR"));
	_tmp37_ = g_strdup (g_dgettext (NULL, "also upgrade development packages (use with --aur)"));
	_tmp38_ = g_strdup (g_dgettext (NULL, "do not upgrade development packages"));
	_tmp39_ = g_strdup (g_dgettext (NULL, "build directory (use with --aur), if no directory is given the one spe" \
"cified in pamac.conf file is used"));
	_tmp40_ = g_new0 (gchar*, 14 + 1);
	_tmp40_[0] = _tmp26_;
	_tmp40_[1] = _tmp27_;
	_tmp40_[2] = _tmp28_;
	_tmp40_[3] = _tmp29_;
	_tmp40_[4] = _tmp30_;
	_tmp40_[5] = _tmp31_;
	_tmp40_[6] = _tmp32_;
	_tmp40_[7] = _tmp33_;
	_tmp40_[8] = _tmp34_;
	_tmp40_[9] = _tmp35_;
	_tmp40_[10] = _tmp36_;
	_tmp40_[11] = _tmp37_;
	_tmp40_[12] = _tmp38_;
	_tmp40_[13] = _tmp39_;
	details = _tmp40_;
	details_length1 = 14;
	_details_size_ = details_length1;
	i = 0;
	_tmp41_ = options;
	_tmp41__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp41_;
		option_collection_length1 = _tmp41__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp42_;
				gchar** _tmp43_;
				gint _tmp43__length1;
				const gchar* _tmp44_;
				gint _tmp45_;
				_tmp42_ = option;
				_tmp43_ = details;
				_tmp43__length1 = details_length1;
				_tmp44_ = _tmp43_[i];
				pamac_cli_print_property (self, _tmp42_, _tmp44_, max_length);
				_tmp45_ = i;
				i = _tmp45_ + 1;
			}
		}
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_clean_help (PamacCli* self)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint max_length = 0;
	gchar** options = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint options_length1;
	gint _options_size_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** details = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gint details_length1;
	gint _details_size_;
	gint i = 0;
	gchar** _tmp25_;
	gint _tmp25__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "%s", g_dgettext (NULL, "Clean packages cache or build files"));
	_tmp1_ = stdout;
	fprintf (_tmp1_, "\n\n");
	_tmp2_ = stdout;
	_tmp3_ = g_strdup_printf ("pamac clean [%s]", g_dgettext (NULL, "options"));
	_tmp4_ = _tmp3_;
	fprintf (_tmp2_, "%s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = stdout;
	fprintf (_tmp5_, "\n\n");
	_tmp6_ = stdout;
	_tmp7_ = g_strconcat (g_dgettext (NULL, "options"), ":\n", NULL);
	_tmp8_ = _tmp7_;
	fprintf (_tmp6_, "%s", _tmp8_);
	_g_free0 (_tmp8_);
	max_length = 0;
	_tmp9_ = g_strdup_printf ("  --keep, -k <%s>", g_dgettext (NULL, "number"));
	_tmp10_ = g_strdup ("  --uninstalled, -u");
	_tmp11_ = g_strdup ("  --build-files, -b");
	_tmp12_ = g_strdup ("  --dry-run, -d");
	_tmp13_ = g_strdup ("  --verbose, -v");
	_tmp14_ = g_strdup ("  --no-confirm");
	_tmp15_ = g_new0 (gchar*, 6 + 1);
	_tmp15_[0] = _tmp9_;
	_tmp15_[1] = _tmp10_;
	_tmp15_[2] = _tmp11_;
	_tmp15_[3] = _tmp12_;
	_tmp15_[4] = _tmp13_;
	_tmp15_[5] = _tmp14_;
	options = _tmp15_;
	options_length1 = 6;
	_options_size_ = options_length1;
	_tmp16_ = options;
	_tmp16__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp16_;
		option_collection_length1 = _tmp16__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				gint length = 0;
				const gchar* _tmp17_;
				_tmp17_ = option;
				length = g_utf8_strlen (_tmp17_, (gssize) -1);
				if (length > max_length) {
					max_length = length;
				}
			}
		}
	}
	_tmp18_ = g_strdup (g_dgettext (NULL, "specify how many versions of each package are kept in the cache direct" \
"ory"));
	_tmp19_ = g_strdup (g_dgettext (NULL, "only target uninstalled packages"));
	_tmp20_ = g_strdup (g_dgettext (NULL, "remove all build files, the build directory is the one specified in pa" \
"mac.conf"));
	_tmp21_ = g_strdup (g_dgettext (NULL, "do not remove files, only find candidate packages"));
	_tmp22_ = g_strdup (g_dgettext (NULL, "also display all files names"));
	_tmp23_ = g_strdup (g_dgettext (NULL, "bypass any and all confirmation messages"));
	_tmp24_ = g_new0 (gchar*, 6 + 1);
	_tmp24_[0] = _tmp18_;
	_tmp24_[1] = _tmp19_;
	_tmp24_[2] = _tmp20_;
	_tmp24_[3] = _tmp21_;
	_tmp24_[4] = _tmp22_;
	_tmp24_[5] = _tmp23_;
	details = _tmp24_;
	details_length1 = 6;
	_details_size_ = details_length1;
	i = 0;
	_tmp25_ = options;
	_tmp25__length1 = options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp25_;
		option_collection_length1 = _tmp25__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp26_;
				gchar** _tmp27_;
				gint _tmp27__length1;
				const gchar* _tmp28_;
				gint _tmp29_;
				_tmp26_ = option;
				_tmp27_ = details;
				_tmp27__length1 = details_length1;
				_tmp28_ = _tmp27_[i];
				pamac_cli_print_property (self, _tmp26_, _tmp28_, max_length);
				_tmp29_ = i;
				i = _tmp29_ + 1;
			}
		}
	}
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GPtrArray* self;
		self = _data2_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gint
__lambda1_ (Block2Data* _data2_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data2_->self;
	result = _data2_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda1__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda1_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block2Data* _data2_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_ptr_array_ref (self);
	_data2_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda1__gcompare_data_func, _data2_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static gint
_pamac_sort_search_pkgs_by_relevance_gcompare_func (gconstpointer a,
                                                    gconstpointer b)
{
	gint result;
	result = pamac_sort_search_pkgs_by_relevance ((PamacPackage*) a, (PamacPackage*) b);
	return result;
}

static void
pamac_cli_search_pkgs (PamacCli* self,
                       gboolean quiet)
{
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	const gchar* _tmp1_;
	GPtrArray* _tmp2_;
	PamacDatabase* _tmp3_;
	PamacConfig* _tmp4_;
	PamacConfig* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GPtrArray* _tmp17_;
	GPtrArray* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_search_string;
	_tmp2_ = pamac_database_search_pkgs (_tmp0_, _tmp1_);
	pkgs = _tmp2_;
	_tmp3_ = self->priv->database;
	_tmp4_ = pamac_database_get_config (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = pamac_config_get_enable_aur (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GPtrArray* aur_pkgs = NULL;
		PamacDatabase* _tmp8_;
		const gchar* _tmp9_;
		GPtrArray* _tmp10_;
		GPtrArray* _tmp11_;
		_tmp8_ = self->priv->database;
		_tmp9_ = pamac_search_string;
		_tmp10_ = pamac_database_search_aur_pkgs (_tmp8_, _tmp9_);
		aur_pkgs = _tmp10_;
		_tmp11_ = aur_pkgs;
		{
			GPtrArray* aur_pkg_collection = NULL;
			guint aur_pkg_index = 0U;
			aur_pkg_collection = _tmp11_;
			for (aur_pkg_index = 0; aur_pkg_index < aur_pkg_collection->len; aur_pkg_index = aur_pkg_index + 1) {
				PamacAURPackage* aur_pkg = NULL;
				aur_pkg = (PamacAURPackage*) g_ptr_array_index (aur_pkg_collection, aur_pkg_index);
				{
					PamacAURPackage* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp12_ = aur_pkg;
					_tmp13_ = pamac_package_get_installed_version ((PamacPackage*) _tmp12_);
					_tmp14_ = _tmp13_;
					if (_tmp14_ == NULL) {
						GPtrArray* _tmp15_;
						PamacAURPackage* _tmp16_;
						_tmp15_ = pkgs;
						_tmp16_ = aur_pkg;
						g_ptr_array_add (_tmp15_, (PamacAlpmPackage*) _tmp16_);
					}
				}
			}
		}
		_g_ptr_array_unref0 (aur_pkgs);
	}
	_tmp17_ = pkgs;
	vala_g_ptr_array_sort (_tmp17_, _pamac_sort_search_pkgs_by_relevance_gcompare_func);
	_tmp18_ = pkgs;
	pamac_cli_print_search_pkgs (self, _tmp18_, TRUE, quiet);
	_g_ptr_array_unref0 (pkgs);
}

static void
pamac_cli_search_installed_pkgs (PamacCli* self,
                                 gboolean quiet)
{
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	const gchar* _tmp1_;
	GPtrArray* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_search_string;
	_tmp2_ = pamac_database_search_installed_pkgs (_tmp0_, _tmp1_);
	pkgs = _tmp2_;
	vala_g_ptr_array_sort (pkgs, _pamac_sort_search_pkgs_by_relevance_gcompare_func);
	pamac_cli_print_search_pkgs (self, pkgs, FALSE, quiet);
	_g_ptr_array_unref0 (pkgs);
}

static void
pamac_cli_search_repos_pkgs (PamacCli* self,
                             gboolean quiet)
{
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	const gchar* _tmp1_;
	GPtrArray* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_search_string;
	_tmp2_ = pamac_database_search_repos_pkgs (_tmp0_, _tmp1_);
	pkgs = _tmp2_;
	vala_g_ptr_array_sort (pkgs, _pamac_sort_search_pkgs_by_relevance_gcompare_func);
	pamac_cli_print_search_pkgs (self, pkgs, TRUE, quiet);
	_g_ptr_array_unref0 (pkgs);
}

static void
pamac_cli_print_search_pkgs (PamacCli* self,
                             GPtrArray* pkgs,
                             gboolean print_installed,
                             gboolean quiet)
{
	gint installed_width = 0;
	gchar* installed = NULL;
	gint length = 0;
	gint _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkgs != NULL);
	if (quiet) {
		guint length = 0U;
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = vala_g_ptr_array_get_length (pkgs);
		_tmp1_ = _tmp0_;
		length = (guint) _tmp1_;
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					PamacAlpmPackage* pkg = NULL;
					gconstpointer _tmp4_;
					FILE* _tmp5_;
					PamacAlpmPackage* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					if (!_tmp2_) {
						guint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					if (!(i < length)) {
						break;
					}
					_tmp4_ = g_ptr_array_index (pkgs, i);
					pkg = (PamacAlpmPackage*) _tmp4_;
					_tmp5_ = stdout;
					_tmp6_ = pkg;
					_tmp7_ = pamac_package_get_name ((PamacPackage*) _tmp6_);
					_tmp8_ = _tmp7_;
					fprintf (_tmp5_, "%s\n", _tmp8_);
				}
			}
		}
		return;
	}
	installed_width = 0;
	installed = NULL;
	if (print_installed) {
		gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = g_strdup_printf ("[%s]", g_dgettext (NULL, "Installed"));
		_g_free0 (installed);
		installed = _tmp9_;
		_tmp10_ = installed;
		installed_width = g_utf8_strlen (_tmp10_, (gssize) -1) + 1;
	}
	_tmp11_ = vala_g_ptr_array_get_length (pkgs);
	_tmp12_ = _tmp11_;
	length = _tmp12_;
	{
		gint i = 0;
		i = length - 1;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				PamacAlpmPackage* pkg = NULL;
				gconstpointer _tmp15_;
				const gchar* pkg_name = NULL;
				PamacAlpmPackage* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				const gchar* pkg_version = NULL;
				PamacAlpmPackage* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_ = NULL;
				PamacAlpmPackage* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* repo = NULL;
				gchar* _tmp26_;
				gint available_width = 0;
				const gchar* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				const gchar* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				GString* str_builder = NULL;
				const gchar* _tmp33_;
				GString* _tmp34_;
				GString* _tmp35_;
				GString* _tmp36_;
				const gchar* _tmp37_;
				GString* _tmp38_;
				gboolean _tmp39_ = FALSE;
				GString* _tmp46_;
				gint diff = 0;
				const gchar* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				GString* _tmp52_;
				const gchar* _tmp53_;
				GString* _tmp54_;
				FILE* _tmp55_;
				GString* _tmp56_;
				const gchar* _tmp57_;
				GPtrArray* cuts = NULL;
				PamacAlpmPackage* _tmp58_;
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				GPtrArray* _tmp61_;
				GPtrArray* _tmp62_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ - 1;
				}
				_tmp13_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp15_ = g_ptr_array_index (pkgs, (guint) i);
				pkg = (PamacAlpmPackage*) _tmp15_;
				_tmp16_ = pkg;
				_tmp17_ = pamac_package_get_name ((PamacPackage*) _tmp16_);
				_tmp18_ = _tmp17_;
				pkg_name = _tmp18_;
				_tmp19_ = pkg;
				_tmp20_ = pamac_package_get_version ((PamacPackage*) _tmp19_);
				_tmp21_ = _tmp20_;
				pkg_version = _tmp21_;
				_tmp23_ = pkg;
				_tmp24_ = pamac_package_get_repo ((PamacPackage*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp22_ = _tmp25_;
				if (_tmp22_ == NULL) {
					_tmp22_ = "";
				}
				_tmp26_ = g_strdup (_tmp22_);
				repo = _tmp26_;
				_tmp27_ = pkg_name;
				_tmp28_ = strlen (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = pkg_version;
				_tmp31_ = strlen (_tmp30_);
				_tmp32_ = _tmp31_;
				available_width = self->priv->term_width - ((_tmp29_ + _tmp32_) + 4);
				_tmp33_ = pkg_name;
				_tmp34_ = g_string_new (_tmp33_);
				str_builder = _tmp34_;
				_tmp35_ = str_builder;
				g_string_append (_tmp35_, "  ");
				_tmp36_ = str_builder;
				_tmp37_ = pkg_version;
				g_string_append (_tmp36_, _tmp37_);
				_tmp38_ = str_builder;
				g_string_append (_tmp38_, " ");
				if (print_installed) {
					PamacAlpmPackage* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					_tmp40_ = pkg;
					_tmp41_ = pamac_package_get_installed_version ((PamacPackage*) _tmp40_);
					_tmp42_ = _tmp41_;
					_tmp39_ = _tmp42_ != NULL;
				} else {
					_tmp39_ = FALSE;
				}
				if (_tmp39_) {
					GString* _tmp43_;
					const gchar* _tmp44_;
					GString* _tmp45_;
					available_width = available_width - installed_width;
					_tmp43_ = str_builder;
					_tmp44_ = installed;
					g_string_append (_tmp43_, _tmp44_);
					_tmp45_ = str_builder;
					g_string_append (_tmp45_, " ");
				}
				_tmp46_ = str_builder;
				g_string_append (_tmp46_, " ");
				_tmp47_ = repo;
				_tmp48_ = strlen (_tmp47_);
				_tmp49_ = _tmp48_;
				diff = available_width - _tmp49_;
				if (diff > 0) {
					while (TRUE) {
						GString* _tmp50_;
						gint _tmp51_;
						if (!(diff > 0)) {
							break;
						}
						_tmp50_ = str_builder;
						g_string_append (_tmp50_, " ");
						_tmp51_ = diff;
						diff = _tmp51_ - 1;
					}
				}
				_tmp52_ = str_builder;
				_tmp53_ = repo;
				g_string_append (_tmp52_, _tmp53_);
				_tmp54_ = str_builder;
				g_string_append (_tmp54_, "\n");
				_tmp55_ = stdout;
				_tmp56_ = str_builder;
				_tmp57_ = _tmp56_->str;
				fprintf (_tmp55_, "%s", _tmp57_);
				_tmp58_ = pkg;
				_tmp59_ = pamac_package_get_desc ((PamacPackage*) _tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = pamac_cli_split_string (self, _tmp60_, 4, self->priv->term_width - 4);
				cuts = _tmp61_;
				_tmp62_ = cuts;
				{
					GPtrArray* cut_collection = NULL;
					guint cut_index = 0U;
					cut_collection = _tmp62_;
					for (cut_index = 0; cut_index < cut_collection->len; cut_index = cut_index + 1) {
						const gchar* cut = NULL;
						cut = (const gchar*) g_ptr_array_index (cut_collection, cut_index);
						{
							const gchar* _tmp63_;
							_tmp63_ = cut;
							pamac_cli_print_aligned (self, "", _tmp63_, 4);
						}
					}
				}
				_g_ptr_array_unref0 (cuts);
				_g_string_free0 (str_builder);
				_g_free0 (repo);
			}
		}
	}
	_g_free0 (installed);
}

static void
pamac_cli_display_pkgs_infos (PamacCli* self,
                              gchar** pkgnames,
                              gint pkgnames_length1)
{
	gchar** properties = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gint properties_length1;
	gint _properties_size_;
	gint max_length = 0;
	gchar** _tmp30_;
	gint _tmp30__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (g_dgettext (NULL, "Name"));
	_tmp1_ = g_strdup (g_dgettext (NULL, "Version"));
	_tmp2_ = g_strdup (g_dgettext (NULL, "Description"));
	_tmp3_ = g_strdup (g_dgettext (NULL, "URL"));
	_tmp4_ = g_strdup (g_dgettext (NULL, "Licenses"));
	_tmp5_ = g_strdup (g_dgettext (NULL, "Repository"));
	_tmp6_ = g_strdup (g_dgettext (NULL, "Installed Size"));
	_tmp7_ = g_strdup (g_dgettext (NULL, "Groups"));
	_tmp8_ = g_strdup (g_dgettext (NULL, "Depends On"));
	_tmp9_ = g_strdup (g_dgettext (NULL, "Optional Dependencies"));
	_tmp10_ = g_strdup (g_dgettext (NULL, "Make Dependencies"));
	_tmp11_ = g_strdup (g_dgettext (NULL, "Check Dependencies"));
	_tmp12_ = g_strdup (g_dgettext (NULL, "Required By"));
	_tmp13_ = g_strdup (g_dgettext (NULL, "Optional For"));
	_tmp14_ = g_strdup (g_dgettext (NULL, "Provides"));
	_tmp15_ = g_strdup (g_dgettext (NULL, "Replaces"));
	_tmp16_ = g_strdup (g_dgettext (NULL, "Conflicts With"));
	_tmp17_ = g_strdup (g_dgettext (NULL, "Packager"));
	_tmp18_ = g_strdup (g_dgettext (NULL, "Build Date"));
	_tmp19_ = g_strdup (g_dgettext (NULL, "Install Date"));
	_tmp20_ = g_strdup (g_dgettext (NULL, "Install Reason"));
	_tmp21_ = g_strdup (g_dgettext (NULL, "Validated By"));
	_tmp22_ = g_strdup (g_dgettext (NULL, "Backup files"));
	_tmp23_ = g_strdup (g_dgettext (NULL, "Package Base"));
	_tmp24_ = g_strdup (g_dgettext (NULL, "Maintainer"));
	_tmp25_ = g_strdup (g_dgettext (NULL, "First Submitted"));
	_tmp26_ = g_strdup (g_dgettext (NULL, "Last Modified"));
	_tmp27_ = g_strdup (g_dgettext (NULL, "Votes"));
	_tmp28_ = g_strdup (g_dgettext (NULL, "Out of Date"));
	_tmp29_ = g_new0 (gchar*, 29 + 1);
	_tmp29_[0] = _tmp0_;
	_tmp29_[1] = _tmp1_;
	_tmp29_[2] = _tmp2_;
	_tmp29_[3] = _tmp3_;
	_tmp29_[4] = _tmp4_;
	_tmp29_[5] = _tmp5_;
	_tmp29_[6] = _tmp6_;
	_tmp29_[7] = _tmp7_;
	_tmp29_[8] = _tmp8_;
	_tmp29_[9] = _tmp9_;
	_tmp29_[10] = _tmp10_;
	_tmp29_[11] = _tmp11_;
	_tmp29_[12] = _tmp12_;
	_tmp29_[13] = _tmp13_;
	_tmp29_[14] = _tmp14_;
	_tmp29_[15] = _tmp15_;
	_tmp29_[16] = _tmp16_;
	_tmp29_[17] = _tmp17_;
	_tmp29_[18] = _tmp18_;
	_tmp29_[19] = _tmp19_;
	_tmp29_[20] = _tmp20_;
	_tmp29_[21] = _tmp21_;
	_tmp29_[22] = _tmp22_;
	_tmp29_[23] = _tmp23_;
	_tmp29_[24] = _tmp24_;
	_tmp29_[25] = _tmp25_;
	_tmp29_[26] = _tmp26_;
	_tmp29_[27] = _tmp27_;
	_tmp29_[28] = _tmp28_;
	properties = _tmp29_;
	properties_length1 = 29;
	_properties_size_ = properties_length1;
	max_length = 0;
	_tmp30_ = properties;
	_tmp30__length1 = properties_length1;
	{
		gchar** prop_collection = NULL;
		gint prop_collection_length1 = 0;
		gint _prop_collection_size_ = 0;
		gint prop_it = 0;
		prop_collection = _tmp30_;
		prop_collection_length1 = _tmp30__length1;
		for (prop_it = 0; prop_it < prop_collection_length1; prop_it = prop_it + 1) {
			const gchar* prop = NULL;
			prop = prop_collection[prop_it];
			{
				gint char_count = 0;
				const gchar* _tmp31_;
				_tmp31_ = prop;
				char_count = g_utf8_strlen (_tmp31_, (gssize) -1);
				if (char_count > max_length) {
					max_length = char_count;
				}
			}
		}
	}
	{
		gchar** pkgname_collection = NULL;
		gint pkgname_collection_length1 = 0;
		gint _pkgname_collection_size_ = 0;
		gint pkgname_it = 0;
		pkgname_collection = pkgnames;
		pkgname_collection_length1 = pkgnames_length1;
		for (pkgname_it = 0; pkgname_it < pkgname_collection_length1; pkgname_it = pkgname_it + 1) {
			const gchar* pkgname = NULL;
			pkgname = pkgname_collection[pkgname_it];
			{
				PamacAURPackage* aur_pkg = NULL;
				PamacDatabase* _tmp32_;
				const gchar* _tmp33_;
				PamacAURPackage* _tmp34_;
				PamacAlpmPackage* pkg = NULL;
				PamacAURPackage* _tmp35_;
				_tmp32_ = self->priv->database;
				_tmp33_ = pkgname;
				_tmp34_ = pamac_database_get_aur_pkg (_tmp32_, _tmp33_);
				aur_pkg = _tmp34_;
				_tmp35_ = aur_pkg;
				if (_tmp35_ == NULL) {
					PamacDatabase* _tmp36_;
					const gchar* _tmp37_;
					PamacAlpmPackage* _tmp38_;
					PamacAlpmPackage* _tmp39_;
					_tmp36_ = self->priv->database;
					_tmp37_ = pkgname;
					_tmp38_ = pamac_database_get_pkg (_tmp36_, _tmp37_);
					pkg = _tmp38_;
					_tmp39_ = pkg;
					if (_tmp39_ == NULL) {
						const gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp40_ = pkgname;
						_tmp41_ = g_strdup_printf (g_dgettext (NULL, "target not found: %s"), _tmp40_);
						_tmp42_ = _tmp41_;
						pamac_cli_print_error (self, _tmp42_);
						_g_free0 (_tmp42_);
					} else {
						PamacAlpmPackage* _tmp43_;
						gchar** _tmp44_;
						gint _tmp44__length1;
						_tmp43_ = pkg;
						_tmp44_ = properties;
						_tmp44__length1 = properties_length1;
						pamac_cli_display_pkg_infos (self, _tmp43_, NULL, _tmp44_, (gint) _tmp44__length1, max_length);
					}
				} else {
					PamacAURPackage* _tmp45_;
					const gchar* _tmp46_;
					const gchar* _tmp47_;
					_tmp45_ = aur_pkg;
					_tmp46_ = pamac_package_get_installed_version ((PamacPackage*) _tmp45_);
					_tmp47_ = _tmp46_;
					if (_tmp47_ == NULL) {
						PamacDatabase* _tmp48_;
						const gchar* _tmp49_;
						PamacAlpmPackage* _tmp50_;
						PamacAlpmPackage* _tmp51_;
						PamacAURPackage* _tmp54_;
						PamacAlpmPackage* _tmp55_;
						PamacAURPackage* _tmp56_;
						gchar** _tmp57_;
						gint _tmp57__length1;
						_tmp48_ = self->priv->database;
						_tmp49_ = pkgname;
						_tmp50_ = pamac_database_get_sync_pkg (_tmp48_, _tmp49_);
						pkg = _tmp50_;
						_tmp51_ = pkg;
						if (_tmp51_ != NULL) {
							PamacAlpmPackage* _tmp52_;
							gchar** _tmp53_;
							gint _tmp53__length1;
							_tmp52_ = pkg;
							_tmp53_ = properties;
							_tmp53__length1 = properties_length1;
							pamac_cli_display_pkg_infos (self, _tmp52_, NULL, _tmp53_, (gint) _tmp53__length1, max_length);
						}
						_tmp54_ = aur_pkg;
						pkg = G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, PAMAC_TYPE_ALPM_PACKAGE) ? ((PamacAlpmPackage*) _tmp54_) : NULL;
						_tmp55_ = pkg;
						_tmp56_ = aur_pkg;
						_tmp57_ = properties;
						_tmp57__length1 = properties_length1;
						pamac_cli_display_pkg_infos (self, _tmp55_, _tmp56_, _tmp57_, (gint) _tmp57__length1, max_length);
					} else {
						PamacDatabase* _tmp58_;
						const gchar* _tmp59_;
						_tmp58_ = self->priv->database;
						_tmp59_ = pkgname;
						if (pamac_database_is_sync_pkg (_tmp58_, _tmp59_)) {
							PamacDatabase* _tmp60_;
							const gchar* _tmp61_;
							PamacAlpmPackage* _tmp62_;
							PamacAlpmPackage* _tmp63_;
							gchar** _tmp64_;
							gint _tmp64__length1;
							_tmp60_ = self->priv->database;
							_tmp61_ = pkgname;
							_tmp62_ = pamac_database_get_pkg (_tmp60_, _tmp61_);
							pkg = _tmp62_;
							_tmp63_ = pkg;
							_tmp64_ = properties;
							_tmp64__length1 = properties_length1;
							pamac_cli_display_pkg_infos (self, _tmp63_, NULL, _tmp64_, (gint) _tmp64__length1, max_length);
						} else {
							PamacAURPackage* _tmp65_;
							PamacAlpmPackage* _tmp66_;
							PamacAURPackage* _tmp67_;
							gchar** _tmp68_;
							gint _tmp68__length1;
							_tmp65_ = aur_pkg;
							pkg = G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, PAMAC_TYPE_ALPM_PACKAGE) ? ((PamacAlpmPackage*) _tmp65_) : NULL;
							_tmp66_ = pkg;
							_tmp67_ = aur_pkg;
							_tmp68_ = properties;
							_tmp68__length1 = properties_length1;
							pamac_cli_display_pkg_infos (self, _tmp66_, _tmp67_, _tmp68_, (gint) _tmp68__length1, max_length);
						}
					}
				}
			}
		}
	}
	properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_free), NULL);
}

static void
pamac_cli_display_pkg_infos (PamacCli* self,
                             PamacAlpmPackage* pkg,
                             PamacAURPackage* aur_pkg,
                             gchar** properties,
                             gint properties_length1,
                             gint max_length)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* installed_version = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	guint64 _tmp33_;
	guint64 _tmp34_;
	const gchar* _tmp40_;
	GPtrArray* _tmp41_;
	GPtrArray* _tmp42_;
	const gchar* _tmp43_;
	GPtrArray* _tmp44_;
	GPtrArray* _tmp45_;
	GPtrArray* list = NULL;
	GPtrArray* _tmp46_;
	GPtrArray* _tmp47_;
	guint list_length = 0U;
	GPtrArray* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	const gchar* _tmp78_;
	const gchar* _tmp85_;
	GPtrArray* _tmp86_;
	GPtrArray* _tmp87_;
	const gchar* _tmp88_;
	GPtrArray* _tmp89_;
	GPtrArray* _tmp90_;
	const gchar* _tmp91_;
	GPtrArray* _tmp92_;
	GPtrArray* _tmp93_;
	gboolean _tmp94_ = FALSE;
	const gchar* _tmp95_;
	gboolean _tmp134_ = FALSE;
	const gchar* _tmp135_;
	const gchar* _tmp144_;
	gboolean _tmp159_ = FALSE;
	const gchar* _tmp160_;
	const gchar* _tmp176_;
	FILE* _tmp180_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkg != NULL);
	_tmp0_ = properties[0];
	_tmp1_ = pamac_package_get_name ((PamacPackage*) pkg);
	_tmp2_ = _tmp1_;
	pamac_cli_print_property (self, _tmp0_, _tmp2_, max_length);
	if (aur_pkg != NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = pamac_aur_package_get_packagebase (aur_pkg);
		_tmp4_ = _tmp3_;
		_tmp5_ = pamac_package_get_name ((PamacPackage*) pkg);
		_tmp6_ = _tmp5_;
		if (g_strcmp0 (_tmp4_, _tmp6_) != 0) {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = properties[23];
			_tmp8_ = pamac_aur_package_get_packagebase (aur_pkg);
			_tmp9_ = _tmp8_;
			pamac_cli_print_property (self, _tmp7_, _tmp9_, max_length);
		}
	}
	_tmp10_ = pamac_package_get_installed_version ((PamacPackage*) pkg);
	_tmp11_ = _tmp10_;
	installed_version = _tmp11_;
	_tmp12_ = installed_version;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = properties[1];
		_tmp14_ = installed_version;
		pamac_cli_print_property (self, _tmp13_, _tmp14_, max_length);
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp15_ = properties[1];
		_tmp16_ = pamac_package_get_version ((PamacPackage*) pkg);
		_tmp17_ = _tmp16_;
		pamac_cli_print_property (self, _tmp15_, _tmp17_, max_length);
	}
	_tmp18_ = properties[2];
	_tmp19_ = pamac_package_get_desc ((PamacPackage*) pkg);
	_tmp20_ = _tmp19_;
	pamac_cli_print_property (self, _tmp18_, _tmp20_, max_length);
	_tmp21_ = properties[3];
	_tmp22_ = pamac_package_get_url ((PamacPackage*) pkg);
	_tmp23_ = _tmp22_;
	pamac_cli_print_property (self, _tmp21_, _tmp23_, max_length);
	_tmp24_ = pamac_package_get_license ((PamacPackage*) pkg);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		_tmp26_ = properties[4];
		_tmp27_ = pamac_package_get_license ((PamacPackage*) pkg);
		_tmp28_ = _tmp27_;
		pamac_cli_print_property (self, _tmp26_, _tmp28_, max_length);
	} else {
		const gchar* _tmp29_;
		_tmp29_ = properties[4];
		pamac_cli_print_property (self, _tmp29_, g_dgettext (NULL, "Unknown"), max_length);
	}
	_tmp30_ = properties[5];
	_tmp31_ = pamac_package_get_repo ((PamacPackage*) pkg);
	_tmp32_ = _tmp31_;
	pamac_cli_print_property (self, _tmp30_, _tmp32_, max_length);
	_tmp33_ = pamac_package_get_installed_size ((PamacPackage*) pkg);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != ((guint64) 0)) {
		const gchar* _tmp35_;
		guint64 _tmp36_;
		guint64 _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp35_ = properties[6];
		_tmp36_ = pamac_package_get_installed_size ((PamacPackage*) pkg);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_format_size_full (_tmp37_, G_FORMAT_SIZE_DEFAULT);
		_tmp39_ = _tmp38_;
		pamac_cli_print_property (self, _tmp35_, _tmp39_, max_length);
		_g_free0 (_tmp39_);
	}
	_tmp40_ = properties[7];
	_tmp41_ = pamac_alpm_package_get_groups (pkg);
	_tmp42_ = _tmp41_;
	pamac_cli_print_property_list (self, _tmp40_, _tmp42_, max_length);
	_tmp43_ = properties[8];
	_tmp44_ = pamac_alpm_package_get_depends (pkg);
	_tmp45_ = _tmp44_;
	pamac_cli_print_property_list (self, _tmp43_, _tmp45_, max_length);
	_tmp46_ = pamac_alpm_package_get_optdepends (pkg);
	_tmp47_ = _tmp46_;
	list = _tmp47_;
	_tmp48_ = list;
	_tmp49_ = vala_g_ptr_array_get_length (_tmp48_);
	_tmp50_ = _tmp49_;
	list_length = (guint) _tmp50_;
	if (list_length != ((guint) 0)) {
		gchar* depstring = NULL;
		GPtrArray* _tmp51_;
		gconstpointer _tmp52_;
		gchar* _tmp53_;
		PamacDatabase* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp58_;
		const gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		guint i = 0U;
		_tmp51_ = list;
		_tmp52_ = g_ptr_array_index (_tmp51_, (guint) 0);
		_tmp53_ = g_strdup ((const gchar*) _tmp52_);
		depstring = _tmp53_;
		_tmp54_ = self->priv->database;
		_tmp55_ = depstring;
		if (pamac_database_has_installed_satisfier (_tmp54_, _tmp55_)) {
			const gchar* _tmp56_;
			gchar* _tmp57_;
			_tmp56_ = depstring;
			_tmp57_ = g_strdup_printf ("%s [%s]", _tmp56_, g_dgettext (NULL, "Installed"));
			_g_free0 (depstring);
			depstring = _tmp57_;
		}
		_tmp58_ = properties[9];
		_tmp59_ = depstring;
		_tmp60_ = g_strdup_printf (" : %s", _tmp59_);
		_tmp61_ = _tmp60_;
		pamac_cli_print_aligned (self, _tmp58_, _tmp61_, max_length);
		_g_free0 (_tmp61_);
		i = (guint) 1;
		while (TRUE) {
			GPtrArray* _tmp62_;
			gconstpointer _tmp63_;
			gchar* _tmp64_;
			PamacDatabase* _tmp65_;
			const gchar* _tmp66_;
			const gchar* _tmp69_;
			guint _tmp70_;
			if (!(i < list_length)) {
				break;
			}
			_tmp62_ = list;
			_tmp63_ = g_ptr_array_index (_tmp62_, i);
			_tmp64_ = g_strdup ((const gchar*) _tmp63_);
			_g_free0 (depstring);
			depstring = _tmp64_;
			_tmp65_ = self->priv->database;
			_tmp66_ = depstring;
			if (pamac_database_has_installed_satisfier (_tmp65_, _tmp66_)) {
				const gchar* _tmp67_;
				gchar* _tmp68_;
				_tmp67_ = depstring;
				_tmp68_ = g_strdup_printf ("%s [%s]", _tmp67_, g_dgettext (NULL, "Installed"));
				_g_free0 (depstring);
				depstring = _tmp68_;
			}
			_tmp69_ = depstring;
			pamac_cli_print_aligned (self, "", _tmp69_, max_length + 3);
			_tmp70_ = i;
			i = _tmp70_ + 1;
		}
		_g_free0 (depstring);
	} else {
		const gchar* _tmp71_;
		_tmp71_ = properties[9];
		pamac_cli_print_property (self, _tmp71_, "--", max_length);
	}
	if (aur_pkg != NULL) {
		const gchar* _tmp72_;
		GPtrArray* _tmp73_;
		GPtrArray* _tmp74_;
		_tmp72_ = properties[10];
		_tmp73_ = pamac_alpm_package_get_makedepends ((PamacAlpmPackage*) aur_pkg);
		_tmp74_ = _tmp73_;
		pamac_cli_print_property_list (self, _tmp72_, _tmp74_, max_length);
	}
	if (aur_pkg != NULL) {
		const gchar* _tmp75_;
		GPtrArray* _tmp76_;
		GPtrArray* _tmp77_;
		_tmp75_ = properties[11];
		_tmp76_ = pamac_alpm_package_get_checkdepends ((PamacAlpmPackage*) aur_pkg);
		_tmp77_ = _tmp76_;
		pamac_cli_print_property_list (self, _tmp75_, _tmp77_, max_length);
	}
	_tmp78_ = installed_version;
	if (_tmp78_ != NULL) {
		const gchar* _tmp79_;
		GPtrArray* _tmp80_;
		GPtrArray* _tmp81_;
		const gchar* _tmp82_;
		GPtrArray* _tmp83_;
		GPtrArray* _tmp84_;
		_tmp79_ = properties[12];
		_tmp80_ = pamac_alpm_package_get_requiredby (pkg);
		_tmp81_ = _tmp80_;
		pamac_cli_print_property_list (self, _tmp79_, _tmp81_, max_length);
		_tmp82_ = properties[13];
		_tmp83_ = pamac_alpm_package_get_optionalfor (pkg);
		_tmp84_ = _tmp83_;
		pamac_cli_print_property_list (self, _tmp82_, _tmp84_, max_length);
	}
	_tmp85_ = properties[14];
	_tmp86_ = pamac_alpm_package_get_provides (pkg);
	_tmp87_ = _tmp86_;
	pamac_cli_print_property_list (self, _tmp85_, _tmp87_, max_length);
	_tmp88_ = properties[15];
	_tmp89_ = pamac_alpm_package_get_replaces (pkg);
	_tmp90_ = _tmp89_;
	pamac_cli_print_property_list (self, _tmp88_, _tmp90_, max_length);
	_tmp91_ = properties[16];
	_tmp92_ = pamac_alpm_package_get_conflicts (pkg);
	_tmp93_ = _tmp92_;
	pamac_cli_print_property_list (self, _tmp91_, _tmp93_, max_length);
	_tmp95_ = installed_version;
	if (_tmp95_ != NULL) {
		_tmp94_ = TRUE;
	} else {
		_tmp94_ = aur_pkg == NULL;
	}
	if (_tmp94_) {
		const gchar* _tmp96_;
		const gchar* _tmp97_;
		_tmp96_ = pamac_alpm_package_get_packager (pkg);
		_tmp97_ = _tmp96_;
		if (_tmp97_ != NULL) {
			const gchar* _tmp98_;
			const gchar* _tmp99_;
			const gchar* _tmp100_;
			_tmp98_ = properties[17];
			_tmp99_ = pamac_alpm_package_get_packager (pkg);
			_tmp100_ = _tmp99_;
			pamac_cli_print_property (self, _tmp98_, _tmp100_, max_length);
		} else {
			const gchar* _tmp101_;
			_tmp101_ = properties[17];
			pamac_cli_print_property (self, _tmp101_, g_dgettext (NULL, "Unknown"), max_length);
		}
	}
	if (aur_pkg != NULL) {
		const gchar* _tmp102_;
		const gchar* _tmp103_;
		const gchar* _tmp104_;
		GDateTime* _tmp105_;
		GDateTime* _tmp106_;
		GDateTime* _tmp113_;
		GDateTime* _tmp114_;
		const gchar* _tmp121_;
		guint64 _tmp122_;
		guint64 _tmp123_;
		gchar* _tmp124_;
		gchar* _tmp125_;
		GDateTime* _tmp126_;
		GDateTime* _tmp127_;
		_tmp102_ = properties[24];
		_tmp103_ = pamac_aur_package_get_maintainer (aur_pkg);
		_tmp104_ = _tmp103_;
		pamac_cli_print_property (self, _tmp102_, _tmp104_, max_length);
		_tmp105_ = pamac_aur_package_get_firstsubmitted (aur_pkg);
		_tmp106_ = _tmp105_;
		if (_tmp106_ != NULL) {
			const gchar* _tmp107_;
			GDateTime* _tmp108_;
			GDateTime* _tmp109_;
			gchar* _tmp110_;
			gchar* _tmp111_;
			_tmp107_ = properties[25];
			_tmp108_ = pamac_aur_package_get_firstsubmitted (aur_pkg);
			_tmp109_ = _tmp108_;
			_tmp110_ = g_date_time_format (_tmp109_, "%c");
			_tmp111_ = _tmp110_;
			pamac_cli_print_property (self, _tmp107_, _tmp111_, max_length);
			_g_free0 (_tmp111_);
		} else {
			const gchar* _tmp112_;
			_tmp112_ = properties[25];
			pamac_cli_print_property (self, _tmp112_, g_dgettext (NULL, "Unknown"), max_length);
		}
		_tmp113_ = pamac_aur_package_get_lastmodified (aur_pkg);
		_tmp114_ = _tmp113_;
		if (_tmp114_ != NULL) {
			const gchar* _tmp115_;
			GDateTime* _tmp116_;
			GDateTime* _tmp117_;
			gchar* _tmp118_;
			gchar* _tmp119_;
			_tmp115_ = properties[26];
			_tmp116_ = pamac_aur_package_get_lastmodified (aur_pkg);
			_tmp117_ = _tmp116_;
			_tmp118_ = g_date_time_format (_tmp117_, "%c");
			_tmp119_ = _tmp118_;
			pamac_cli_print_property (self, _tmp115_, _tmp119_, max_length);
			_g_free0 (_tmp119_);
		} else {
			const gchar* _tmp120_;
			_tmp120_ = properties[26];
			pamac_cli_print_property (self, _tmp120_, g_dgettext (NULL, "Unknown"), max_length);
		}
		_tmp121_ = properties[27];
		_tmp122_ = pamac_aur_package_get_numvotes (aur_pkg);
		_tmp123_ = _tmp122_;
		_tmp124_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp123_);
		_tmp125_ = _tmp124_;
		pamac_cli_print_property (self, _tmp121_, _tmp125_, max_length);
		_g_free0 (_tmp125_);
		_tmp126_ = pamac_aur_package_get_outofdate (aur_pkg);
		_tmp127_ = _tmp126_;
		if (_tmp127_ != NULL) {
			const gchar* _tmp128_;
			GDateTime* _tmp129_;
			GDateTime* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			_tmp128_ = properties[28];
			_tmp129_ = pamac_aur_package_get_outofdate (aur_pkg);
			_tmp130_ = _tmp129_;
			_tmp131_ = g_date_time_format (_tmp130_, "%c");
			_tmp132_ = _tmp131_;
			pamac_cli_print_property (self, _tmp128_, _tmp132_, max_length);
			_g_free0 (_tmp132_);
		} else {
			const gchar* _tmp133_;
			_tmp133_ = properties[28];
			pamac_cli_print_property (self, _tmp133_, "--", max_length);
		}
	}
	_tmp135_ = installed_version;
	if (_tmp135_ != NULL) {
		_tmp134_ = TRUE;
	} else {
		_tmp134_ = aur_pkg == NULL;
	}
	if (_tmp134_) {
		GDateTime* _tmp136_;
		GDateTime* _tmp137_;
		_tmp136_ = pamac_alpm_package_get_build_date (pkg);
		_tmp137_ = _tmp136_;
		if (_tmp137_ != NULL) {
			const gchar* _tmp138_;
			GDateTime* _tmp139_;
			GDateTime* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			_tmp138_ = properties[18];
			_tmp139_ = pamac_alpm_package_get_build_date (pkg);
			_tmp140_ = _tmp139_;
			_tmp141_ = g_date_time_format (_tmp140_, "%c");
			_tmp142_ = _tmp141_;
			pamac_cli_print_property (self, _tmp138_, _tmp142_, max_length);
			_g_free0 (_tmp142_);
		} else {
			const gchar* _tmp143_;
			_tmp143_ = properties[18];
			pamac_cli_print_property (self, _tmp143_, g_dgettext (NULL, "Unknown"), max_length);
		}
	}
	_tmp144_ = installed_version;
	if (_tmp144_ != NULL) {
		GDateTime* _tmp145_;
		GDateTime* _tmp146_;
		const gchar* _tmp153_;
		const gchar* _tmp154_;
		_tmp145_ = pamac_package_get_install_date ((PamacPackage*) pkg);
		_tmp146_ = _tmp145_;
		if (_tmp146_ != NULL) {
			const gchar* _tmp147_;
			GDateTime* _tmp148_;
			GDateTime* _tmp149_;
			gchar* _tmp150_;
			gchar* _tmp151_;
			_tmp147_ = properties[19];
			_tmp148_ = pamac_package_get_install_date ((PamacPackage*) pkg);
			_tmp149_ = _tmp148_;
			_tmp150_ = g_date_time_format (_tmp149_, "%c");
			_tmp151_ = _tmp150_;
			pamac_cli_print_property (self, _tmp147_, _tmp151_, max_length);
			_g_free0 (_tmp151_);
		} else {
			const gchar* _tmp152_;
			_tmp152_ = properties[19];
			pamac_cli_print_property (self, _tmp152_, g_dgettext (NULL, "Unknown"), max_length);
		}
		_tmp153_ = pamac_alpm_package_get_reason (pkg);
		_tmp154_ = _tmp153_;
		if (_tmp154_ != NULL) {
			const gchar* _tmp155_;
			const gchar* _tmp156_;
			const gchar* _tmp157_;
			_tmp155_ = properties[20];
			_tmp156_ = pamac_alpm_package_get_reason (pkg);
			_tmp157_ = _tmp156_;
			pamac_cli_print_property (self, _tmp155_, _tmp157_, max_length);
		} else {
			const gchar* _tmp158_;
			_tmp158_ = properties[20];
			pamac_cli_print_property (self, _tmp158_, g_dgettext (NULL, "Unknown"), max_length);
		}
	}
	_tmp160_ = installed_version;
	if (_tmp160_ != NULL) {
		_tmp159_ = TRUE;
	} else {
		_tmp159_ = aur_pkg == NULL;
	}
	if (_tmp159_) {
		GPtrArray* _tmp161_;
		GPtrArray* _tmp162_;
		gint _tmp163_;
		gint _tmp164_;
		_tmp161_ = pamac_alpm_package_get_validations (pkg);
		_tmp162_ = _tmp161_;
		_tmp163_ = vala_g_ptr_array_get_length (_tmp162_);
		_tmp164_ = _tmp163_;
		if (_tmp164_ > 0) {
			GString* str_builder = NULL;
			GString* _tmp165_;
			GPtrArray* _tmp166_;
			GPtrArray* _tmp167_;
			const gchar* _tmp172_;
			GString* _tmp173_;
			const gchar* _tmp174_;
			_tmp165_ = g_string_new ("");
			str_builder = _tmp165_;
			_tmp166_ = pamac_alpm_package_get_validations (pkg);
			_tmp167_ = _tmp166_;
			{
				GPtrArray* name_collection = NULL;
				guint name_index = 0U;
				name_collection = _tmp167_;
				for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
					const gchar* name = NULL;
					name = (const gchar*) g_ptr_array_index (name_collection, name_index);
					{
						GString* _tmp168_;
						GString* _tmp170_;
						const gchar* _tmp171_;
						_tmp168_ = str_builder;
						if (_tmp168_->len > ((gssize) 0)) {
							GString* _tmp169_;
							_tmp169_ = str_builder;
							g_string_append (_tmp169_, "  ");
						}
						_tmp170_ = str_builder;
						_tmp171_ = name;
						g_string_append (_tmp170_, _tmp171_);
					}
				}
			}
			_tmp172_ = properties[21];
			_tmp173_ = str_builder;
			_tmp174_ = _tmp173_->str;
			pamac_cli_print_property (self, _tmp172_, _tmp174_, max_length);
			_g_string_free0 (str_builder);
		} else {
			const gchar* _tmp175_;
			_tmp175_ = properties[21];
			pamac_cli_print_property (self, _tmp175_, g_dgettext (NULL, "Unknown"), max_length);
		}
	}
	_tmp176_ = installed_version;
	if (_tmp176_ != NULL) {
		const gchar* _tmp177_;
		GPtrArray* _tmp178_;
		GPtrArray* _tmp179_;
		_tmp177_ = properties[22];
		_tmp178_ = pamac_alpm_package_get_backups (pkg);
		_tmp179_ = _tmp178_;
		pamac_cli_print_property_list (self, _tmp177_, _tmp179_, max_length);
	}
	_tmp180_ = stdout;
	fprintf (_tmp180_, "\n");
}

static void
pamac_cli_print_pkgs (PamacCli* self,
                      GPtrArray* pkgs,
                      gboolean print_installed,
                      gboolean quiet)
{
	gint name_length = 0;
	gint version_length = 0;
	gint repo_length = 0;
	gint installed_width = 0;
	gchar* installed = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkgs != NULL);
	if (quiet) {
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = pkgs;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacAlpmPackage* pkg = NULL;
				pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					FILE* _tmp0_;
					PamacAlpmPackage* _tmp1_;
					const gchar* _tmp2_;
					const gchar* _tmp3_;
					_tmp0_ = stdout;
					_tmp1_ = pkg;
					_tmp2_ = pamac_package_get_name ((PamacPackage*) _tmp1_);
					_tmp3_ = _tmp2_;
					fprintf (_tmp0_, "%s\n", _tmp3_);
				}
			}
		}
		return;
	}
	name_length = 0;
	version_length = 0;
	repo_length = 0;
	{
		GPtrArray* pkg_collection = NULL;
		guint pkg_index = 0U;
		pkg_collection = pkgs;
		for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
			PamacAlpmPackage* pkg = NULL;
			pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
			{
				gint pkg_name_length = 0;
				PamacAlpmPackage* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gint pkg_version_length = 0;
				PamacAlpmPackage* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				const gchar* repo = NULL;
				PamacAlpmPackage* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp4_ = pkg;
				_tmp5_ = pamac_package_get_name ((PamacPackage*) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = strlen (_tmp6_);
				_tmp8_ = _tmp7_;
				pkg_name_length = _tmp8_;
				if (pkg_name_length > name_length) {
					name_length = pkg_name_length;
				}
				_tmp9_ = pkg;
				_tmp10_ = pamac_package_get_version ((PamacPackage*) _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = strlen (_tmp11_);
				_tmp13_ = _tmp12_;
				pkg_version_length = _tmp13_;
				if (pkg_version_length > version_length) {
					version_length = pkg_version_length;
				}
				_tmp14_ = pkg;
				_tmp15_ = pamac_package_get_repo ((PamacPackage*) _tmp14_);
				_tmp16_ = _tmp15_;
				repo = _tmp16_;
				_tmp17_ = repo;
				if (_tmp17_ != NULL) {
					gint pkg_repo_length = 0;
					const gchar* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					_tmp18_ = repo;
					_tmp19_ = strlen (_tmp18_);
					_tmp20_ = _tmp19_;
					pkg_repo_length = _tmp20_;
					if (pkg_repo_length > repo_length) {
						repo_length = pkg_repo_length;
					}
				}
			}
		}
	}
	installed_width = 0;
	installed = NULL;
	if (print_installed) {
		gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = g_strdup_printf ("[%s]", g_dgettext (NULL, "Installed"));
		_g_free0 (installed);
		installed = _tmp21_;
		_tmp22_ = installed;
		installed_width = g_utf8_strlen (_tmp22_, (gssize) -1) + 1;
	}
	{
		GPtrArray* pkg_collection = NULL;
		guint pkg_index = 0U;
		pkg_collection = pkgs;
		for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
			PamacAlpmPackage* pkg = NULL;
			pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
			{
				GString* str_builder = NULL;
				PamacAlpmPackage* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				GString* _tmp26_;
				GString* _tmp27_;
				gint diff = 0;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp44_ = FALSE;
				const gchar* _tmp51_ = NULL;
				PamacAlpmPackage* _tmp52_;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				gchar* repo = NULL;
				gchar* _tmp55_;
				gchar* installed_size = NULL;
				PamacAlpmPackage* _tmp56_;
				guint64 _tmp57_;
				guint64 _tmp58_;
				GString* _tmp64_;
				PamacAlpmPackage* _tmp65_;
				const gchar* _tmp66_;
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				const gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				FILE* _tmp72_;
				GString* _tmp73_;
				const gchar* _tmp74_;
				_tmp23_ = pkg;
				_tmp24_ = pamac_package_get_name ((PamacPackage*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_string_new (_tmp25_);
				str_builder = _tmp26_;
				_tmp27_ = str_builder;
				g_string_append (_tmp27_, " ");
				diff = 0;
				if (print_installed) {
					PamacAlpmPackage* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					_tmp29_ = pkg;
					_tmp30_ = pamac_package_get_installed_version ((PamacPackage*) _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp28_ = _tmp31_ == NULL;
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					PamacAlpmPackage* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					_tmp32_ = pkg;
					_tmp33_ = pamac_package_get_name ((PamacPackage*) _tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = strlen (_tmp34_);
					_tmp36_ = _tmp35_;
					diff = (name_length + installed_width) - _tmp36_;
				} else {
					PamacAlpmPackage* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					_tmp37_ = pkg;
					_tmp38_ = pamac_package_get_name ((PamacPackage*) _tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = strlen (_tmp39_);
					_tmp41_ = _tmp40_;
					diff = name_length - _tmp41_;
				}
				if (diff > 0) {
					while (TRUE) {
						GString* _tmp42_;
						gint _tmp43_;
						if (!(diff > 0)) {
							break;
						}
						_tmp42_ = str_builder;
						g_string_append (_tmp42_, " ");
						_tmp43_ = diff;
						diff = _tmp43_ - 1;
					}
				}
				if (print_installed) {
					PamacAlpmPackage* _tmp45_;
					const gchar* _tmp46_;
					const gchar* _tmp47_;
					_tmp45_ = pkg;
					_tmp46_ = pamac_package_get_installed_version ((PamacPackage*) _tmp45_);
					_tmp47_ = _tmp46_;
					_tmp44_ = _tmp47_ != NULL;
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					GString* _tmp48_;
					const gchar* _tmp49_;
					GString* _tmp50_;
					_tmp48_ = str_builder;
					_tmp49_ = installed;
					g_string_append (_tmp48_, _tmp49_);
					_tmp50_ = str_builder;
					g_string_append (_tmp50_, " ");
				}
				_tmp52_ = pkg;
				_tmp53_ = pamac_package_get_repo ((PamacPackage*) _tmp52_);
				_tmp54_ = _tmp53_;
				_tmp51_ = _tmp54_;
				if (_tmp51_ == NULL) {
					_tmp51_ = "";
				}
				_tmp55_ = g_strdup (_tmp51_);
				repo = _tmp55_;
				_tmp56_ = pkg;
				_tmp57_ = pamac_package_get_installed_size ((PamacPackage*) _tmp56_);
				_tmp58_ = _tmp57_;
				if (_tmp58_ == ((guint64) 0)) {
					gchar* _tmp59_;
					_tmp59_ = g_strdup ("");
					_g_free0 (installed_size);
					installed_size = _tmp59_;
				} else {
					PamacAlpmPackage* _tmp60_;
					guint64 _tmp61_;
					guint64 _tmp62_;
					gchar* _tmp63_;
					_tmp60_ = pkg;
					_tmp61_ = pamac_package_get_installed_size ((PamacPackage*) _tmp60_);
					_tmp62_ = _tmp61_;
					_tmp63_ = g_format_size_full (_tmp62_, G_FORMAT_SIZE_DEFAULT);
					_g_free0 (installed_size);
					installed_size = _tmp63_;
				}
				_tmp64_ = str_builder;
				_tmp65_ = pkg;
				_tmp66_ = pamac_package_get_version ((PamacPackage*) _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = repo;
				_tmp69_ = installed_size;
				_tmp70_ = g_strdup_printf ("%-*s  %-*s  %s\n", version_length, _tmp67_, repo_length, _tmp68_, _tmp69_);
				_tmp71_ = _tmp70_;
				g_string_append (_tmp64_, _tmp71_);
				_g_free0 (_tmp71_);
				_tmp72_ = stdout;
				_tmp73_ = str_builder;
				_tmp74_ = _tmp73_->str;
				fprintf (_tmp72_, "%s", _tmp74_);
				_g_free0 (installed_size);
				_g_free0 (repo);
				_g_string_free0 (str_builder);
			}
		}
	}
	_g_free0 (installed);
}

static void
pamac_cli_list_installed (PamacCli* self,
                          gboolean quiet)
{
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_installed_pkgs (_tmp0_);
	pkgs = _tmp1_;
	pamac_cli_print_pkgs (self, pkgs, FALSE, quiet);
	_g_ptr_array_unref0 (pkgs);
}

static void
pamac_cli_list_explicitly_installed (PamacCli* self,
                                     gboolean quiet)
{
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_explicitly_installed_pkgs (_tmp0_);
	pkgs = _tmp1_;
	pamac_cli_print_pkgs (self, pkgs, FALSE, quiet);
	_g_ptr_array_unref0 (pkgs);
}

static void
pamac_cli_list_orphans (PamacCli* self,
                        gboolean quiet)
{
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_orphans (_tmp0_);
	pkgs = _tmp1_;
	pamac_cli_print_pkgs (self, pkgs, FALSE, quiet);
	_g_ptr_array_unref0 (pkgs);
}

static void
pamac_cli_list_foreign (PamacCli* self,
                        gboolean quiet)
{
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_foreign_pkgs (_tmp0_);
	pkgs = _tmp1_;
	pamac_cli_print_pkgs (self, pkgs, FALSE, quiet);
	_g_ptr_array_unref0 (pkgs);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
pamac_cli_list_groups (PamacCli* self,
                       gchar** names,
                       gint names_length1,
                       gboolean quiet)
{
	g_return_if_fail (self != NULL);
	if (names_length1 == 0) {
		GPtrArray* group_names = NULL;
		PamacDatabase* _tmp0_;
		GPtrArray* _tmp1_;
		GPtrArray* _tmp2_;
		GPtrArray* _tmp3_;
		_tmp0_ = self->priv->database;
		_tmp1_ = pamac_database_get_groups_names (_tmp0_);
		_tmp2_ = _g_ptr_array_ref0 (_tmp1_);
		group_names = _tmp2_;
		_tmp3_ = group_names;
		{
			GPtrArray* name_collection = NULL;
			guint name_index = 0U;
			name_collection = _tmp3_;
			for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
				const gchar* name = NULL;
				name = (const gchar*) g_ptr_array_index (name_collection, name_index);
				{
					FILE* _tmp4_;
					const gchar* _tmp5_;
					_tmp4_ = stdout;
					_tmp5_ = name;
					fprintf (_tmp4_, "%s\n", _tmp5_);
				}
			}
		}
		_g_ptr_array_unref0 (group_names);
		return;
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = names;
		name_collection_length1 = names_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GPtrArray* pkgs = NULL;
				PamacDatabase* _tmp6_;
				const gchar* _tmp7_;
				GPtrArray* _tmp8_;
				GPtrArray* _tmp9_;
				FILE* _tmp14_;
				_tmp6_ = self->priv->database;
				_tmp7_ = name;
				_tmp8_ = pamac_database_get_group_pkgs (_tmp6_, _tmp7_);
				pkgs = _tmp8_;
				_tmp9_ = pkgs;
				if (_tmp9_ == NULL) {
					if (!quiet) {
						const gchar* _tmp10_;
						gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp10_ = name;
						_tmp11_ = g_strdup_printf (g_dgettext (NULL, "target not found: %s"), _tmp10_);
						_tmp12_ = _tmp11_;
						pamac_cli_print_error (self, _tmp12_);
						_g_free0 (_tmp12_);
					}
				} else {
					GPtrArray* _tmp13_;
					_tmp13_ = pkgs;
					pamac_cli_print_pkgs (self, _tmp13_, TRUE, quiet);
				}
				_tmp14_ = stdout;
				fprintf (_tmp14_, "\n");
				_g_ptr_array_unref0 (pkgs);
			}
		}
	}
}

static void
pamac_cli_list_repos (PamacCli* self,
                      gchar** names,
                      gint names_length1,
                      gboolean quiet)
{
	g_return_if_fail (self != NULL);
	if (names_length1 == 0) {
		GPtrArray* repos_names = NULL;
		PamacDatabase* _tmp0_;
		GPtrArray* _tmp1_;
		GPtrArray* _tmp2_;
		GPtrArray* _tmp3_;
		_tmp0_ = self->priv->database;
		_tmp1_ = pamac_database_get_repos_names (_tmp0_);
		_tmp2_ = _g_ptr_array_ref0 (_tmp1_);
		repos_names = _tmp2_;
		_tmp3_ = repos_names;
		{
			GPtrArray* name_collection = NULL;
			guint name_index = 0U;
			name_collection = _tmp3_;
			for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
				const gchar* name = NULL;
				name = (const gchar*) g_ptr_array_index (name_collection, name_index);
				{
					FILE* _tmp4_;
					const gchar* _tmp5_;
					_tmp4_ = stdout;
					_tmp5_ = name;
					fprintf (_tmp4_, "%s\n", _tmp5_);
				}
			}
		}
		_g_ptr_array_unref0 (repos_names);
		return;
	}
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = names;
		name_collection_length1 = names_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GPtrArray* pkgs = NULL;
				PamacDatabase* _tmp6_;
				const gchar* _tmp7_;
				GPtrArray* _tmp8_;
				GPtrArray* _tmp9_;
				FILE* _tmp14_;
				_tmp6_ = self->priv->database;
				_tmp7_ = name;
				_tmp8_ = pamac_database_get_repo_pkgs (_tmp6_, _tmp7_);
				pkgs = _tmp8_;
				_tmp9_ = pkgs;
				if (_tmp9_ == NULL) {
					if (!quiet) {
						const gchar* _tmp10_;
						gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp10_ = name;
						_tmp11_ = g_strdup_printf (g_dgettext (NULL, "target not found: %s"), _tmp10_);
						_tmp12_ = _tmp11_;
						pamac_cli_print_error (self, _tmp12_);
						_g_free0 (_tmp12_);
					}
				} else {
					GPtrArray* _tmp13_;
					_tmp13_ = pkgs;
					pamac_cli_print_pkgs (self, _tmp13_, TRUE, quiet);
				}
				_tmp14_ = stdout;
				fprintf (_tmp14_, "\n");
				_g_ptr_array_unref0 (pkgs);
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pamac_cli_list_files (PamacCli* self,
                      gchar** names,
                      gint names_length1,
                      gboolean quiet)
{
	g_return_if_fail (self != NULL);
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = names;
		name_collection_length1 = names_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				PamacAlpmPackage* pkg = NULL;
				PamacDatabase* _tmp0_;
				const gchar* _tmp1_;
				PamacAlpmPackage* _tmp2_;
				PamacAlpmPackage* _tmp3_;
				PamacAlpmPackage* _tmp4_;
				_tmp0_ = self->priv->database;
				_tmp1_ = name;
				_tmp2_ = pamac_database_get_pkg (_tmp0_, _tmp1_);
				_tmp3_ = _g_object_ref0 (_tmp2_);
				pkg = _tmp3_;
				_tmp4_ = pkg;
				if (_tmp4_ == NULL) {
					if (!quiet) {
						const gchar* _tmp5_;
						gchar* _tmp6_;
						gchar* _tmp7_;
						_tmp5_ = name;
						_tmp6_ = g_strdup_printf (g_dgettext (NULL, "target not found: %s"), _tmp5_);
						_tmp7_ = _tmp6_;
						pamac_cli_print_error (self, _tmp7_);
						_g_free0 (_tmp7_);
					}
				} else {
					GPtrArray* files = NULL;
					PamacAlpmPackage* _tmp8_;
					GPtrArray* _tmp9_;
					GPtrArray* _tmp10_;
					GPtrArray* _tmp11_;
					FILE* _tmp14_;
					_tmp8_ = pkg;
					_tmp9_ = pamac_alpm_package_get_files (_tmp8_);
					_tmp10_ = _g_ptr_array_ref0 (_tmp9_);
					files = _tmp10_;
					_tmp11_ = files;
					{
						GPtrArray* path_collection = NULL;
						guint path_index = 0U;
						path_collection = _tmp11_;
						for (path_index = 0; path_index < path_collection->len; path_index = path_index + 1) {
							const gchar* path = NULL;
							path = (const gchar*) g_ptr_array_index (path_collection, path_index);
							{
								FILE* _tmp12_;
								const gchar* _tmp13_;
								_tmp12_ = stdout;
								_tmp13_ = path;
								fprintf (_tmp12_, "%s\n", _tmp13_);
							}
						}
					}
					_tmp14_ = stdout;
					fprintf (_tmp14_, "\n");
					_g_ptr_array_unref0 (files);
				}
				_g_object_unref0 (pkg);
			}
		}
	}
}

static void
pamac_cli_search_files (PamacCli* self,
                        gchar** files,
                        gint files_length1,
                        gboolean quiet)
{
	GPtrArray* files_array = NULL;
	GPtrArray* _tmp0_;
	GHashTable* _result_ = NULL;
	PamacDatabase* _tmp4_;
	GPtrArray* _tmp5_;
	GHashTable* _tmp6_;
	GHashTable* _tmp7_;
	GHashTableIter iter = {0};
	GHashTable* _tmp12_;
	const gchar* pkgname = NULL;
	GPtrArray* files_list = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	files_array = _tmp0_;
	{
		gchar** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			const gchar* file = NULL;
			file = file_collection[file_it];
			{
				GPtrArray* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				_tmp1_ = files_array;
				_tmp2_ = file;
				_tmp3_ = g_strdup (_tmp2_);
				g_ptr_array_add (_tmp1_, _tmp3_);
			}
		}
	}
	_tmp4_ = self->priv->database;
	_tmp5_ = files_array;
	_tmp6_ = pamac_database_search_files (_tmp4_, _tmp5_);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	if (g_hash_table_size (_tmp7_) == ((guint) 0)) {
		if (!quiet) {
			{
				gchar** file_collection = NULL;
				gint file_collection_length1 = 0;
				gint _file_collection_size_ = 0;
				gint file_it = 0;
				file_collection = files;
				file_collection_length1 = files_length1;
				for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
					const gchar* file = NULL;
					file = file_collection[file_it];
					{
						FILE* _tmp8_;
						const gchar* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
						_tmp8_ = stdout;
						_tmp9_ = file;
						_tmp10_ = g_strdup_printf (g_dgettext (NULL, "No package owns %s"), _tmp9_);
						_tmp11_ = _tmp10_;
						fprintf (_tmp8_, "%s\n", _tmp11_);
						_g_free0 (_tmp11_);
					}
				}
			}
		}
		self->exit_status = 1;
		_g_hash_table_unref0 (_result_);
		_g_ptr_array_unref0 (files_array);
		return;
	}
	_tmp12_ = _result_;
	g_hash_table_iter_init (&iter, _tmp12_);
	while (TRUE) {
		gconstpointer _tmp13_ = NULL;
		gconstpointer _tmp14_ = NULL;
		gboolean _tmp15_;
		_tmp15_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp13_), (gpointer*) (&_tmp14_));
		pkgname = (const gchar*) _tmp13_;
		files_list = (GPtrArray*) _tmp14_;
		if (!_tmp15_) {
			break;
		}
		if (quiet) {
			FILE* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = stdout;
			_tmp17_ = pkgname;
			fprintf (_tmp16_, "%s\n", _tmp17_);
		} else {
			GPtrArray* _tmp18_;
			_tmp18_ = files_list;
			{
				GPtrArray* file_collection = NULL;
				guint file_index = 0U;
				file_collection = _tmp18_;
				for (file_index = 0; file_index < file_collection->len; file_index = file_index + 1) {
					const gchar* file = NULL;
					file = (const gchar*) g_ptr_array_index (file_collection, file_index);
					{
						FILE* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						_tmp19_ = stdout;
						_tmp20_ = file;
						_tmp21_ = pkgname;
						_tmp22_ = g_strdup_printf (g_dgettext (NULL, "%s is owned by %s"), _tmp20_, _tmp21_);
						_tmp23_ = _tmp22_;
						fprintf (_tmp19_, "%s\n", _tmp23_);
						_g_free0 (_tmp23_);
					}
				}
			}
		}
	}
	_g_hash_table_unref0 (_result_);
	_g_ptr_array_unref0 (files_array);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PamacCli* self;
		self = _data3_->self;
		_g_main_loop_unref0 (_data3_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
____lambda14_ (Block3Data* _data3_)
{
	PamacCli* self;
	GMainLoop* _tmp0_;
	self = _data3_->self;
	_tmp0_ = _data3_->loop;
	g_main_loop_quit (_tmp0_);
}

static void
_____lambda14__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda14_ (self);
	block3_data_unref (self);
}

static void
pamac_cli_checkupdates (PamacCli* self,
                        gboolean quiet,
                        gboolean refresh_tmp_files_dbs,
                        gboolean download_updates)
{
	PamacUpdates* updates = NULL;
	PamacDatabase* _tmp0_;
	PamacUpdates* _tmp1_;
	guint updates_nb = 0U;
	PamacUpdates* _tmp2_;
	GPtrArray* _tmp3_;
	GPtrArray* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	PamacUpdates* _tmp7_;
	GPtrArray* _tmp8_;
	GPtrArray* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	PamacUpdates* _tmp12_;
	GPtrArray* _tmp13_;
	GPtrArray* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_updates (_tmp0_);
	updates = _tmp1_;
	_tmp2_ = updates;
	_tmp3_ = pamac_updates_get_repos_updates (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_g_ptr_array_get_length (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = updates;
	_tmp8_ = pamac_updates_get_aur_updates (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_g_ptr_array_get_length (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = updates;
	_tmp13_ = pamac_updates_get_flatpak_updates (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_g_ptr_array_get_length (_tmp14_);
	_tmp16_ = _tmp15_;
	updates_nb = (guint) ((_tmp6_ + _tmp11_) + _tmp16_);
	if (updates_nb == ((guint) 0)) {
		FILE* _tmp17_;
		guint ignored_updates_nb = 0U;
		PamacUpdates* _tmp18_;
		GPtrArray* _tmp19_;
		GPtrArray* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		PamacUpdates* _tmp23_;
		GPtrArray* _tmp24_;
		GPtrArray* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gboolean _tmp28_ = FALSE;
		if (quiet) {
			_g_object_unref0 (updates);
			return;
		}
		_tmp17_ = stdout;
		fprintf (_tmp17_, "%s.\n", g_dgettext (NULL, "Your system is up to date"));
		_tmp18_ = updates;
		_tmp19_ = pamac_updates_get_ignored_repos_updates (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_g_ptr_array_get_length (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = updates;
		_tmp24_ = pamac_updates_get_ignored_aur_updates (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_g_ptr_array_get_length (_tmp25_);
		_tmp27_ = _tmp26_;
		ignored_updates_nb = (guint) (_tmp22_ + _tmp27_);
		if (ignored_updates_nb > ((guint) 0)) {
			_tmp28_ = TRUE;
		} else {
			PamacUpdates* _tmp29_;
			GPtrArray* _tmp30_;
			GPtrArray* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			_tmp29_ = updates;
			_tmp30_ = pamac_updates_get_outofdate (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_g_ptr_array_get_length (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp28_ = _tmp33_ != 0;
		}
		if (_tmp28_) {
			gint name_length = 0;
			gint installed_version_length = 0;
			gint version_length = 0;
			PamacUpdates* _tmp34_;
			GPtrArray* _tmp35_;
			GPtrArray* _tmp36_;
			PamacUpdates* _tmp52_;
			GPtrArray* _tmp53_;
			GPtrArray* _tmp54_;
			PamacUpdates* _tmp70_;
			GPtrArray* _tmp71_;
			GPtrArray* _tmp72_;
			PamacUpdates* _tmp118_;
			GPtrArray* _tmp119_;
			GPtrArray* _tmp120_;
			gint _tmp121_;
			gint _tmp122_;
			name_length = 0;
			installed_version_length = 0;
			version_length = 0;
			_tmp34_ = updates;
			_tmp35_ = pamac_updates_get_ignored_repos_updates (_tmp34_);
			_tmp36_ = _tmp35_;
			{
				GPtrArray* pkg_collection = NULL;
				guint pkg_index = 0U;
				pkg_collection = _tmp36_;
				for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
					PamacAlpmPackage* pkg = NULL;
					pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
					{
						gint pkg_name_length = 0;
						PamacAlpmPackage* _tmp37_;
						const gchar* _tmp38_;
						const gchar* _tmp39_;
						gint _tmp40_;
						gint _tmp41_;
						gint pkg_installed_version_length = 0;
						PamacAlpmPackage* _tmp42_;
						const gchar* _tmp43_;
						const gchar* _tmp44_;
						gint _tmp45_;
						gint _tmp46_;
						gint pkg_version_length = 0;
						PamacAlpmPackage* _tmp47_;
						const gchar* _tmp48_;
						const gchar* _tmp49_;
						gint _tmp50_;
						gint _tmp51_;
						_tmp37_ = pkg;
						_tmp38_ = pamac_package_get_name ((PamacPackage*) _tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = strlen (_tmp39_);
						_tmp41_ = _tmp40_;
						pkg_name_length = _tmp41_;
						if (pkg_name_length > name_length) {
							name_length = pkg_name_length;
						}
						_tmp42_ = pkg;
						_tmp43_ = pamac_package_get_installed_version ((PamacPackage*) _tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = strlen (_tmp44_);
						_tmp46_ = _tmp45_;
						pkg_installed_version_length = _tmp46_;
						if (pkg_installed_version_length > installed_version_length) {
							installed_version_length = pkg_installed_version_length;
						}
						_tmp47_ = pkg;
						_tmp48_ = pamac_package_get_version ((PamacPackage*) _tmp47_);
						_tmp49_ = _tmp48_;
						_tmp50_ = strlen (_tmp49_);
						_tmp51_ = _tmp50_;
						pkg_version_length = _tmp51_;
						if (pkg_version_length > version_length) {
							version_length = pkg_version_length;
						}
					}
				}
			}
			_tmp52_ = updates;
			_tmp53_ = pamac_updates_get_ignored_aur_updates (_tmp52_);
			_tmp54_ = _tmp53_;
			{
				GPtrArray* pkg_collection = NULL;
				guint pkg_index = 0U;
				pkg_collection = _tmp54_;
				for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
					PamacAURPackage* pkg = NULL;
					pkg = (PamacAURPackage*) g_ptr_array_index (pkg_collection, pkg_index);
					{
						gint pkg_name_length = 0;
						PamacAURPackage* _tmp55_;
						const gchar* _tmp56_;
						const gchar* _tmp57_;
						gint _tmp58_;
						gint _tmp59_;
						gint pkg_installed_version_length = 0;
						PamacAURPackage* _tmp60_;
						const gchar* _tmp61_;
						const gchar* _tmp62_;
						gint _tmp63_;
						gint _tmp64_;
						gint pkg_version_length = 0;
						PamacAURPackage* _tmp65_;
						const gchar* _tmp66_;
						const gchar* _tmp67_;
						gint _tmp68_;
						gint _tmp69_;
						_tmp55_ = pkg;
						_tmp56_ = pamac_package_get_name ((PamacPackage*) _tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = strlen (_tmp57_);
						_tmp59_ = _tmp58_;
						pkg_name_length = _tmp59_;
						if (pkg_name_length > name_length) {
							name_length = pkg_name_length;
						}
						_tmp60_ = pkg;
						_tmp61_ = pamac_package_get_installed_version ((PamacPackage*) _tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = strlen (_tmp62_);
						_tmp64_ = _tmp63_;
						pkg_installed_version_length = _tmp64_;
						if (pkg_installed_version_length > installed_version_length) {
							installed_version_length = pkg_installed_version_length;
						}
						_tmp65_ = pkg;
						_tmp66_ = pamac_package_get_version ((PamacPackage*) _tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = strlen (_tmp67_);
						_tmp69_ = _tmp68_;
						pkg_version_length = _tmp69_;
						if (pkg_version_length > version_length) {
							version_length = pkg_version_length;
						}
					}
				}
			}
			_tmp70_ = updates;
			_tmp71_ = pamac_updates_get_outofdate (_tmp70_);
			_tmp72_ = _tmp71_;
			{
				GPtrArray* pkg_collection = NULL;
				guint pkg_index = 0U;
				pkg_collection = _tmp72_;
				for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
					PamacAURPackage* pkg = NULL;
					pkg = (PamacAURPackage*) g_ptr_array_index (pkg_collection, pkg_index);
					{
						gint pkg_name_length = 0;
						PamacAURPackage* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
						gint _tmp76_;
						gint _tmp77_;
						gint pkg_version_length = 0;
						PamacAURPackage* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						gint _tmp81_;
						gint _tmp82_;
						_tmp73_ = pkg;
						_tmp74_ = pamac_package_get_name ((PamacPackage*) _tmp73_);
						_tmp75_ = _tmp74_;
						_tmp76_ = strlen (_tmp75_);
						_tmp77_ = _tmp76_;
						pkg_name_length = _tmp77_;
						if (pkg_name_length > name_length) {
							name_length = pkg_name_length;
						}
						_tmp78_ = pkg;
						_tmp79_ = pamac_package_get_version ((PamacPackage*) _tmp78_);
						_tmp80_ = _tmp79_;
						_tmp81_ = strlen (_tmp80_);
						_tmp82_ = _tmp81_;
						pkg_version_length = _tmp82_;
						if (pkg_version_length > version_length) {
							version_length = pkg_version_length;
						}
					}
				}
			}
			if (ignored_updates_nb > ((guint) 0)) {
				gchar* info = NULL;
				gchar* _tmp83_;
				FILE* _tmp84_;
				const gchar* _tmp85_;
				PamacUpdates* _tmp86_;
				GPtrArray* _tmp87_;
				GPtrArray* _tmp88_;
				PamacUpdates* _tmp102_;
				GPtrArray* _tmp103_;
				GPtrArray* _tmp104_;
				_tmp83_ = g_strdup_printf (ngettext ("%u ignored update", "%u ignored updates", (gulong) ignored_updates_nb), ignored_updates_nb);
				info = _tmp83_;
				_tmp84_ = stdout;
				_tmp85_ = info;
				fprintf (_tmp84_, "\n%s:\n", _tmp85_);
				_tmp86_ = updates;
				_tmp87_ = pamac_updates_get_ignored_repos_updates (_tmp86_);
				_tmp88_ = _tmp87_;
				{
					GPtrArray* pkg_collection = NULL;
					guint pkg_index = 0U;
					pkg_collection = _tmp88_;
					for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
						PamacAlpmPackage* pkg = NULL;
						pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
						{
							FILE* _tmp89_;
							PamacAlpmPackage* _tmp90_;
							const gchar* _tmp91_;
							const gchar* _tmp92_;
							PamacAlpmPackage* _tmp93_;
							const gchar* _tmp94_;
							const gchar* _tmp95_;
							PamacAlpmPackage* _tmp96_;
							const gchar* _tmp97_;
							const gchar* _tmp98_;
							PamacAlpmPackage* _tmp99_;
							const gchar* _tmp100_;
							const gchar* _tmp101_;
							_tmp89_ = stdout;
							_tmp90_ = pkg;
							_tmp91_ = pamac_package_get_name ((PamacPackage*) _tmp90_);
							_tmp92_ = _tmp91_;
							_tmp93_ = pkg;
							_tmp94_ = pamac_package_get_installed_version ((PamacPackage*) _tmp93_);
							_tmp95_ = _tmp94_;
							_tmp96_ = pkg;
							_tmp97_ = pamac_package_get_version ((PamacPackage*) _tmp96_);
							_tmp98_ = _tmp97_;
							_tmp99_ = pkg;
							_tmp100_ = pamac_package_get_repo ((PamacPackage*) _tmp99_);
							_tmp101_ = _tmp100_;
							fprintf (_tmp89_, "%-*s  %-*s -> %-*s  %s\n", name_length, _tmp92_, installed_version_length, _tmp95_, version_length, _tmp98_, _tmp101_);
						}
					}
				}
				_tmp102_ = updates;
				_tmp103_ = pamac_updates_get_ignored_aur_updates (_tmp102_);
				_tmp104_ = _tmp103_;
				{
					GPtrArray* pkg_collection = NULL;
					guint pkg_index = 0U;
					pkg_collection = _tmp104_;
					for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
						PamacAURPackage* pkg = NULL;
						pkg = (PamacAURPackage*) g_ptr_array_index (pkg_collection, pkg_index);
						{
							FILE* _tmp105_;
							PamacAURPackage* _tmp106_;
							const gchar* _tmp107_;
							const gchar* _tmp108_;
							PamacAURPackage* _tmp109_;
							const gchar* _tmp110_;
							const gchar* _tmp111_;
							PamacAURPackage* _tmp112_;
							const gchar* _tmp113_;
							const gchar* _tmp114_;
							PamacAURPackage* _tmp115_;
							const gchar* _tmp116_;
							const gchar* _tmp117_;
							_tmp105_ = stdout;
							_tmp106_ = pkg;
							_tmp107_ = pamac_package_get_name ((PamacPackage*) _tmp106_);
							_tmp108_ = _tmp107_;
							_tmp109_ = pkg;
							_tmp110_ = pamac_package_get_installed_version ((PamacPackage*) _tmp109_);
							_tmp111_ = _tmp110_;
							_tmp112_ = pkg;
							_tmp113_ = pamac_package_get_version ((PamacPackage*) _tmp112_);
							_tmp114_ = _tmp113_;
							_tmp115_ = pkg;
							_tmp116_ = pamac_package_get_repo ((PamacPackage*) _tmp115_);
							_tmp117_ = _tmp116_;
							fprintf (_tmp105_, "%-*s  %-*s -> %-*s  %s\n", name_length, _tmp108_, installed_version_length, _tmp111_, version_length, _tmp114_, _tmp117_);
						}
					}
				}
				_g_free0 (info);
			}
			_tmp118_ = updates;
			_tmp119_ = pamac_updates_get_outofdate (_tmp118_);
			_tmp120_ = _tmp119_;
			_tmp121_ = vala_g_ptr_array_get_length (_tmp120_);
			_tmp122_ = _tmp121_;
			if (_tmp122_ != 0) {
				FILE* _tmp123_;
				PamacUpdates* _tmp124_;
				GPtrArray* _tmp125_;
				GPtrArray* _tmp126_;
				_tmp123_ = stdout;
				fprintf (_tmp123_, "\n%s:\n", g_dgettext (NULL, "Out of Date"));
				_tmp124_ = updates;
				_tmp125_ = pamac_updates_get_outofdate (_tmp124_);
				_tmp126_ = _tmp125_;
				{
					GPtrArray* pkg_collection = NULL;
					guint pkg_index = 0U;
					pkg_collection = _tmp126_;
					for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
						PamacAURPackage* pkg = NULL;
						pkg = (PamacAURPackage*) g_ptr_array_index (pkg_collection, pkg_index);
						{
							FILE* _tmp127_;
							PamacAURPackage* _tmp128_;
							const gchar* _tmp129_;
							const gchar* _tmp130_;
							PamacAURPackage* _tmp131_;
							const gchar* _tmp132_;
							const gchar* _tmp133_;
							_tmp127_ = stdout;
							_tmp128_ = pkg;
							_tmp129_ = pamac_package_get_name ((PamacPackage*) _tmp128_);
							_tmp130_ = _tmp129_;
							_tmp131_ = pkg;
							_tmp132_ = pamac_package_get_version ((PamacPackage*) _tmp131_);
							_tmp133_ = _tmp132_;
							fprintf (_tmp127_, "%-*s  %-*s  %s\n", name_length, _tmp130_, version_length, _tmp133_, g_dgettext (NULL, "AUR"));
						}
					}
				}
			}
		}
	} else {
		gint name_length = 0;
		gint installed_version_length = 0;
		gint version_length = 0;
		PamacUpdates* _tmp195_;
		GPtrArray* _tmp196_;
		GPtrArray* _tmp197_;
		PamacUpdates* _tmp213_;
		GPtrArray* _tmp214_;
		GPtrArray* _tmp215_;
		PamacUpdates* _tmp231_;
		GPtrArray* _tmp232_;
		GPtrArray* _tmp233_;
		PamacUpdates* _tmp249_;
		GPtrArray* _tmp250_;
		GPtrArray* _tmp251_;
		PamacUpdates* _tmp267_;
		GPtrArray* _tmp268_;
		GPtrArray* _tmp269_;
		PamacUpdates* _tmp280_;
		GPtrArray* _tmp281_;
		GPtrArray* _tmp282_;
		gchar* info = NULL;
		gchar* _tmp302_;
		FILE* _tmp303_;
		const gchar* _tmp304_;
		PamacUpdates* _tmp305_;
		GPtrArray* _tmp306_;
		GPtrArray* _tmp307_;
		PamacUpdates* _tmp321_;
		GPtrArray* _tmp322_;
		GPtrArray* _tmp323_;
		PamacUpdates* _tmp334_;
		GPtrArray* _tmp335_;
		GPtrArray* _tmp336_;
		guint ignored_updates_nb = 0U;
		PamacUpdates* _tmp354_;
		GPtrArray* _tmp355_;
		GPtrArray* _tmp356_;
		gint _tmp357_;
		gint _tmp358_;
		PamacUpdates* _tmp359_;
		GPtrArray* _tmp360_;
		GPtrArray* _tmp361_;
		gint _tmp362_;
		gint _tmp363_;
		PamacUpdates* _tmp399_;
		GPtrArray* _tmp400_;
		GPtrArray* _tmp401_;
		gint _tmp402_;
		gint _tmp403_;
		self->exit_status = 100;
		if (refresh_tmp_files_dbs) {
			PamacDatabase* _tmp134_;
			_tmp134_ = self->priv->database;
			pamac_database_refresh_tmp_files_dbs (_tmp134_);
		}
		if (download_updates) {
			Block3Data* _data3_;
			PamacDatabase* _tmp135_;
			PamacTransactionCli* _tmp136_;
			GMainLoop* _tmp137_;
			PamacTransactionCli* _tmp138_;
			GMainLoop* _tmp139_;
			_data3_ = g_slice_new0 (Block3Data);
			_data3_->_ref_count_ = 1;
			_data3_->self = g_object_ref (self);
			_tmp135_ = self->priv->database;
			_tmp136_ = pamac_transaction_cli_new (_tmp135_);
			_g_object_unref0 (self->transaction);
			self->transaction = _tmp136_;
			_tmp137_ = g_main_loop_new (NULL, FALSE);
			_data3_->loop = _tmp137_;
			_tmp138_ = self->transaction;
			pamac_transaction_download_updates_async ((PamacTransaction*) _tmp138_, _____lambda14__gasync_ready_callback, block3_data_ref (_data3_));
			_tmp139_ = _data3_->loop;
			g_main_loop_run (_tmp139_);
			block3_data_unref (_data3_);
			_data3_ = NULL;
		}
		if (quiet) {
			PamacUpdates* _tmp140_;
			GPtrArray* _tmp141_;
			GPtrArray* _tmp142_;
			PamacUpdates* _tmp163_;
			GPtrArray* _tmp164_;
			GPtrArray* _tmp165_;
			PamacUpdates* _tmp176_;
			GPtrArray* _tmp177_;
			GPtrArray* _tmp178_;
			_tmp140_ = updates;
			_tmp141_ = pamac_updates_get_repos_updates (_tmp140_);
			_tmp142_ = _tmp141_;
			{
				GPtrArray* pkg_collection = NULL;
				guint pkg_index = 0U;
				pkg_collection = _tmp142_;
				for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
					PamacAlpmPackage* pkg = NULL;
					pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
					{
						PamacAlpmPackage* _tmp143_;
						const gchar* _tmp144_;
						const gchar* _tmp145_;
						_tmp143_ = pkg;
						_tmp144_ = pamac_package_get_installed_version ((PamacPackage*) _tmp143_);
						_tmp145_ = _tmp144_;
						if (_tmp145_ != NULL) {
							FILE* _tmp146_;
							PamacAlpmPackage* _tmp147_;
							const gchar* _tmp148_;
							const gchar* _tmp149_;
							PamacAlpmPackage* _tmp150_;
							const gchar* _tmp151_;
							const gchar* _tmp152_;
							PamacAlpmPackage* _tmp153_;
							const gchar* _tmp154_;
							const gchar* _tmp155_;
							_tmp146_ = stdout;
							_tmp147_ = pkg;
							_tmp148_ = pamac_package_get_name ((PamacPackage*) _tmp147_);
							_tmp149_ = _tmp148_;
							_tmp150_ = pkg;
							_tmp151_ = pamac_package_get_installed_version ((PamacPackage*) _tmp150_);
							_tmp152_ = _tmp151_;
							_tmp153_ = pkg;
							_tmp154_ = pamac_package_get_version ((PamacPackage*) _tmp153_);
							_tmp155_ = _tmp154_;
							fprintf (_tmp146_, "%s  %s -> %s\n", _tmp149_, _tmp152_, _tmp155_);
						} else {
							FILE* _tmp156_;
							PamacAlpmPackage* _tmp157_;
							const gchar* _tmp158_;
							const gchar* _tmp159_;
							PamacAlpmPackage* _tmp160_;
							const gchar* _tmp161_;
							const gchar* _tmp162_;
							_tmp156_ = stdout;
							_tmp157_ = pkg;
							_tmp158_ = pamac_package_get_name ((PamacPackage*) _tmp157_);
							_tmp159_ = _tmp158_;
							_tmp160_ = pkg;
							_tmp161_ = pamac_package_get_version ((PamacPackage*) _tmp160_);
							_tmp162_ = _tmp161_;
							fprintf (_tmp156_, "%s  %s\n", _tmp159_, _tmp162_);
						}
					}
				}
			}
			_tmp163_ = updates;
			_tmp164_ = pamac_updates_get_aur_updates (_tmp163_);
			_tmp165_ = _tmp164_;
			{
				GPtrArray* pkg_collection = NULL;
				guint pkg_index = 0U;
				pkg_collection = _tmp165_;
				for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
					PamacAURPackage* pkg = NULL;
					pkg = (PamacAURPackage*) g_ptr_array_index (pkg_collection, pkg_index);
					{
						FILE* _tmp166_;
						PamacAURPackage* _tmp167_;
						const gchar* _tmp168_;
						const gchar* _tmp169_;
						PamacAURPackage* _tmp170_;
						const gchar* _tmp171_;
						const gchar* _tmp172_;
						PamacAURPackage* _tmp173_;
						const gchar* _tmp174_;
						const gchar* _tmp175_;
						_tmp166_ = stdout;
						_tmp167_ = pkg;
						_tmp168_ = pamac_package_get_name ((PamacPackage*) _tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = pkg;
						_tmp171_ = pamac_package_get_installed_version ((PamacPackage*) _tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = pkg;
						_tmp174_ = pamac_package_get_version ((PamacPackage*) _tmp173_);
						_tmp175_ = _tmp174_;
						fprintf (_tmp166_, "%s  %s -> %s\n", _tmp169_, _tmp172_, _tmp175_);
					}
				}
			}
			_tmp176_ = updates;
			_tmp177_ = pamac_updates_get_flatpak_updates (_tmp176_);
			_tmp178_ = _tmp177_;
			{
				GPtrArray* pkg_collection = NULL;
				guint pkg_index = 0U;
				pkg_collection = _tmp178_;
				for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
					PamacFlatpakPackage* pkg = NULL;
					pkg = (PamacFlatpakPackage*) g_ptr_array_index (pkg_collection, pkg_index);
					{
						const gchar* app_name = NULL;
						PamacFlatpakPackage* _tmp179_;
						const gchar* _tmp180_;
						const gchar* _tmp181_;
						const gchar* _tmp182_;
						_tmp179_ = pkg;
						_tmp180_ = pamac_package_get_app_name ((PamacPackage*) _tmp179_);
						_tmp181_ = _tmp180_;
						app_name = _tmp181_;
						_tmp182_ = app_name;
						if (_tmp182_ == NULL) {
							FILE* _tmp183_;
							PamacFlatpakPackage* _tmp184_;
							const gchar* _tmp185_;
							const gchar* _tmp186_;
							PamacFlatpakPackage* _tmp187_;
							const gchar* _tmp188_;
							const gchar* _tmp189_;
							_tmp183_ = stdout;
							_tmp184_ = pkg;
							_tmp185_ = pamac_package_get_name ((PamacPackage*) _tmp184_);
							_tmp186_ = _tmp185_;
							_tmp187_ = pkg;
							_tmp188_ = pamac_package_get_version ((PamacPackage*) _tmp187_);
							_tmp189_ = _tmp188_;
							fprintf (_tmp183_, "%s  %s\n", _tmp186_, _tmp189_);
						} else {
							FILE* _tmp190_;
							const gchar* _tmp191_;
							PamacFlatpakPackage* _tmp192_;
							const gchar* _tmp193_;
							const gchar* _tmp194_;
							_tmp190_ = stdout;
							_tmp191_ = app_name;
							_tmp192_ = pkg;
							_tmp193_ = pamac_package_get_version ((PamacPackage*) _tmp192_);
							_tmp194_ = _tmp193_;
							fprintf (_tmp190_, "%s  %s\n", _tmp191_, _tmp194_);
						}
					}
				}
			}
			_g_object_unref0 (updates);
			return;
		}
		name_length = 0;
		installed_version_length = 0;
		version_length = 0;
		_tmp195_ = updates;
		_tmp196_ = pamac_updates_get_repos_updates (_tmp195_);
		_tmp197_ = _tmp196_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp197_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacAlpmPackage* pkg = NULL;
				pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					gint pkg_name_length = 0;
					PamacAlpmPackage* _tmp198_;
					const gchar* _tmp199_;
					const gchar* _tmp200_;
					gint _tmp201_;
					gint _tmp202_;
					gint pkg_installed_version_length = 0;
					PamacAlpmPackage* _tmp203_;
					const gchar* _tmp204_;
					const gchar* _tmp205_;
					gint _tmp206_;
					gint _tmp207_;
					gint pkg_version_length = 0;
					PamacAlpmPackage* _tmp208_;
					const gchar* _tmp209_;
					const gchar* _tmp210_;
					gint _tmp211_;
					gint _tmp212_;
					_tmp198_ = pkg;
					_tmp199_ = pamac_package_get_name ((PamacPackage*) _tmp198_);
					_tmp200_ = _tmp199_;
					_tmp201_ = strlen (_tmp200_);
					_tmp202_ = _tmp201_;
					pkg_name_length = _tmp202_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp203_ = pkg;
					_tmp204_ = pamac_package_get_installed_version ((PamacPackage*) _tmp203_);
					_tmp205_ = _tmp204_;
					_tmp206_ = strlen (_tmp205_);
					_tmp207_ = _tmp206_;
					pkg_installed_version_length = _tmp207_;
					if (pkg_installed_version_length > installed_version_length) {
						installed_version_length = pkg_installed_version_length;
					}
					_tmp208_ = pkg;
					_tmp209_ = pamac_package_get_version ((PamacPackage*) _tmp208_);
					_tmp210_ = _tmp209_;
					_tmp211_ = strlen (_tmp210_);
					_tmp212_ = _tmp211_;
					pkg_version_length = _tmp212_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
				}
			}
		}
		_tmp213_ = updates;
		_tmp214_ = pamac_updates_get_ignored_repos_updates (_tmp213_);
		_tmp215_ = _tmp214_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp215_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacAlpmPackage* pkg = NULL;
				pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					gint pkg_name_length = 0;
					PamacAlpmPackage* _tmp216_;
					const gchar* _tmp217_;
					const gchar* _tmp218_;
					gint _tmp219_;
					gint _tmp220_;
					gint pkg_installed_version_length = 0;
					PamacAlpmPackage* _tmp221_;
					const gchar* _tmp222_;
					const gchar* _tmp223_;
					gint _tmp224_;
					gint _tmp225_;
					gint pkg_version_length = 0;
					PamacAlpmPackage* _tmp226_;
					const gchar* _tmp227_;
					const gchar* _tmp228_;
					gint _tmp229_;
					gint _tmp230_;
					_tmp216_ = pkg;
					_tmp217_ = pamac_package_get_name ((PamacPackage*) _tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = strlen (_tmp218_);
					_tmp220_ = _tmp219_;
					pkg_name_length = _tmp220_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp221_ = pkg;
					_tmp222_ = pamac_package_get_installed_version ((PamacPackage*) _tmp221_);
					_tmp223_ = _tmp222_;
					_tmp224_ = strlen (_tmp223_);
					_tmp225_ = _tmp224_;
					pkg_installed_version_length = _tmp225_;
					if (pkg_installed_version_length > installed_version_length) {
						installed_version_length = pkg_installed_version_length;
					}
					_tmp226_ = pkg;
					_tmp227_ = pamac_package_get_version ((PamacPackage*) _tmp226_);
					_tmp228_ = _tmp227_;
					_tmp229_ = strlen (_tmp228_);
					_tmp230_ = _tmp229_;
					pkg_version_length = _tmp230_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
				}
			}
		}
		_tmp231_ = updates;
		_tmp232_ = pamac_updates_get_aur_updates (_tmp231_);
		_tmp233_ = _tmp232_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp233_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacAURPackage* pkg = NULL;
				pkg = (PamacAURPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					gint pkg_name_length = 0;
					PamacAURPackage* _tmp234_;
					const gchar* _tmp235_;
					const gchar* _tmp236_;
					gint _tmp237_;
					gint _tmp238_;
					gint pkg_installed_version_length = 0;
					PamacAURPackage* _tmp239_;
					const gchar* _tmp240_;
					const gchar* _tmp241_;
					gint _tmp242_;
					gint _tmp243_;
					gint pkg_version_length = 0;
					PamacAURPackage* _tmp244_;
					const gchar* _tmp245_;
					const gchar* _tmp246_;
					gint _tmp247_;
					gint _tmp248_;
					_tmp234_ = pkg;
					_tmp235_ = pamac_package_get_name ((PamacPackage*) _tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = strlen (_tmp236_);
					_tmp238_ = _tmp237_;
					pkg_name_length = _tmp238_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp239_ = pkg;
					_tmp240_ = pamac_package_get_installed_version ((PamacPackage*) _tmp239_);
					_tmp241_ = _tmp240_;
					_tmp242_ = strlen (_tmp241_);
					_tmp243_ = _tmp242_;
					pkg_installed_version_length = _tmp243_;
					if (pkg_installed_version_length > installed_version_length) {
						installed_version_length = pkg_installed_version_length;
					}
					_tmp244_ = pkg;
					_tmp245_ = pamac_package_get_version ((PamacPackage*) _tmp244_);
					_tmp246_ = _tmp245_;
					_tmp247_ = strlen (_tmp246_);
					_tmp248_ = _tmp247_;
					pkg_version_length = _tmp248_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
				}
			}
		}
		_tmp249_ = updates;
		_tmp250_ = pamac_updates_get_ignored_aur_updates (_tmp249_);
		_tmp251_ = _tmp250_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp251_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacAURPackage* pkg = NULL;
				pkg = (PamacAURPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					gint pkg_name_length = 0;
					PamacAURPackage* _tmp252_;
					const gchar* _tmp253_;
					const gchar* _tmp254_;
					gint _tmp255_;
					gint _tmp256_;
					gint pkg_installed_version_length = 0;
					PamacAURPackage* _tmp257_;
					const gchar* _tmp258_;
					const gchar* _tmp259_;
					gint _tmp260_;
					gint _tmp261_;
					gint pkg_version_length = 0;
					PamacAURPackage* _tmp262_;
					const gchar* _tmp263_;
					const gchar* _tmp264_;
					gint _tmp265_;
					gint _tmp266_;
					_tmp252_ = pkg;
					_tmp253_ = pamac_package_get_name ((PamacPackage*) _tmp252_);
					_tmp254_ = _tmp253_;
					_tmp255_ = strlen (_tmp254_);
					_tmp256_ = _tmp255_;
					pkg_name_length = _tmp256_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp257_ = pkg;
					_tmp258_ = pamac_package_get_installed_version ((PamacPackage*) _tmp257_);
					_tmp259_ = _tmp258_;
					_tmp260_ = strlen (_tmp259_);
					_tmp261_ = _tmp260_;
					pkg_installed_version_length = _tmp261_;
					if (pkg_installed_version_length > installed_version_length) {
						installed_version_length = pkg_installed_version_length;
					}
					_tmp262_ = pkg;
					_tmp263_ = pamac_package_get_version ((PamacPackage*) _tmp262_);
					_tmp264_ = _tmp263_;
					_tmp265_ = strlen (_tmp264_);
					_tmp266_ = _tmp265_;
					pkg_version_length = _tmp266_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
				}
			}
		}
		_tmp267_ = updates;
		_tmp268_ = pamac_updates_get_outofdate (_tmp267_);
		_tmp269_ = _tmp268_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp269_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacAURPackage* pkg = NULL;
				pkg = (PamacAURPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					gint pkg_name_length = 0;
					PamacAURPackage* _tmp270_;
					const gchar* _tmp271_;
					const gchar* _tmp272_;
					gint _tmp273_;
					gint _tmp274_;
					gint pkg_version_length = 0;
					PamacAURPackage* _tmp275_;
					const gchar* _tmp276_;
					const gchar* _tmp277_;
					gint _tmp278_;
					gint _tmp279_;
					_tmp270_ = pkg;
					_tmp271_ = pamac_package_get_name ((PamacPackage*) _tmp270_);
					_tmp272_ = _tmp271_;
					_tmp273_ = strlen (_tmp272_);
					_tmp274_ = _tmp273_;
					pkg_name_length = _tmp274_;
					if (pkg_name_length > name_length) {
						name_length = pkg_name_length;
					}
					_tmp275_ = pkg;
					_tmp276_ = pamac_package_get_version ((PamacPackage*) _tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = strlen (_tmp277_);
					_tmp279_ = _tmp278_;
					pkg_version_length = _tmp279_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
				}
			}
		}
		_tmp280_ = updates;
		_tmp281_ = pamac_updates_get_flatpak_updates (_tmp280_);
		_tmp282_ = _tmp281_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp282_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacFlatpakPackage* pkg = NULL;
				pkg = (PamacFlatpakPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					gint pkg_app_name_length = 0;
					const gchar* app_name = NULL;
					PamacFlatpakPackage* _tmp283_;
					const gchar* _tmp284_;
					const gchar* _tmp285_;
					const gchar* _tmp286_;
					gint pkg_version_length = 0;
					PamacFlatpakPackage* _tmp297_;
					const gchar* _tmp298_;
					const gchar* _tmp299_;
					gint _tmp300_;
					gint _tmp301_;
					_tmp283_ = pkg;
					_tmp284_ = pamac_package_get_app_name ((PamacPackage*) _tmp283_);
					_tmp285_ = _tmp284_;
					app_name = _tmp285_;
					_tmp286_ = app_name;
					if (_tmp286_ == NULL) {
						PamacFlatpakPackage* _tmp287_;
						const gchar* _tmp288_;
						const gchar* _tmp289_;
						gint _tmp290_;
						gint _tmp291_;
						_tmp287_ = pkg;
						_tmp288_ = pamac_package_get_name ((PamacPackage*) _tmp287_);
						_tmp289_ = _tmp288_;
						_tmp290_ = strlen (_tmp289_);
						_tmp291_ = _tmp290_;
						pkg_app_name_length = _tmp291_;
					} else {
						PamacFlatpakPackage* _tmp292_;
						const gchar* _tmp293_;
						const gchar* _tmp294_;
						gint _tmp295_;
						gint _tmp296_;
						_tmp292_ = pkg;
						_tmp293_ = pamac_package_get_app_name ((PamacPackage*) _tmp292_);
						_tmp294_ = _tmp293_;
						_tmp295_ = strlen (_tmp294_);
						_tmp296_ = _tmp295_;
						pkg_app_name_length = _tmp296_;
					}
					if (pkg_app_name_length > name_length) {
						name_length = pkg_app_name_length;
					}
					_tmp297_ = pkg;
					_tmp298_ = pamac_package_get_version ((PamacPackage*) _tmp297_);
					_tmp299_ = _tmp298_;
					_tmp300_ = strlen (_tmp299_);
					_tmp301_ = _tmp300_;
					pkg_version_length = _tmp301_;
					if (pkg_version_length > version_length) {
						version_length = pkg_version_length;
					}
				}
			}
		}
		_tmp302_ = g_strdup_printf (ngettext ("%u available update", "%u available updates", (gulong) updates_nb), updates_nb);
		info = _tmp302_;
		_tmp303_ = stdout;
		_tmp304_ = info;
		fprintf (_tmp303_, "%s:\n", _tmp304_);
		_tmp305_ = updates;
		_tmp306_ = pamac_updates_get_repos_updates (_tmp305_);
		_tmp307_ = _tmp306_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp307_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacAlpmPackage* pkg = NULL;
				pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					FILE* _tmp308_;
					PamacAlpmPackage* _tmp309_;
					const gchar* _tmp310_;
					const gchar* _tmp311_;
					PamacAlpmPackage* _tmp312_;
					const gchar* _tmp313_;
					const gchar* _tmp314_;
					PamacAlpmPackage* _tmp315_;
					const gchar* _tmp316_;
					const gchar* _tmp317_;
					PamacAlpmPackage* _tmp318_;
					const gchar* _tmp319_;
					const gchar* _tmp320_;
					_tmp308_ = stdout;
					_tmp309_ = pkg;
					_tmp310_ = pamac_package_get_name ((PamacPackage*) _tmp309_);
					_tmp311_ = _tmp310_;
					_tmp312_ = pkg;
					_tmp313_ = pamac_package_get_installed_version ((PamacPackage*) _tmp312_);
					_tmp314_ = _tmp313_;
					_tmp315_ = pkg;
					_tmp316_ = pamac_package_get_version ((PamacPackage*) _tmp315_);
					_tmp317_ = _tmp316_;
					_tmp318_ = pkg;
					_tmp319_ = pamac_package_get_repo ((PamacPackage*) _tmp318_);
					_tmp320_ = _tmp319_;
					fprintf (_tmp308_, "%-*s  %-*s -> %-*s  %s\n", name_length, _tmp311_, installed_version_length, _tmp314_, version_length, _tmp317_, _tmp320_);
				}
			}
		}
		_tmp321_ = updates;
		_tmp322_ = pamac_updates_get_aur_updates (_tmp321_);
		_tmp323_ = _tmp322_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp323_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacAURPackage* pkg = NULL;
				pkg = (PamacAURPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					FILE* _tmp324_;
					PamacAURPackage* _tmp325_;
					const gchar* _tmp326_;
					const gchar* _tmp327_;
					PamacAURPackage* _tmp328_;
					const gchar* _tmp329_;
					const gchar* _tmp330_;
					PamacAURPackage* _tmp331_;
					const gchar* _tmp332_;
					const gchar* _tmp333_;
					_tmp324_ = stdout;
					_tmp325_ = pkg;
					_tmp326_ = pamac_package_get_name ((PamacPackage*) _tmp325_);
					_tmp327_ = _tmp326_;
					_tmp328_ = pkg;
					_tmp329_ = pamac_package_get_installed_version ((PamacPackage*) _tmp328_);
					_tmp330_ = _tmp329_;
					_tmp331_ = pkg;
					_tmp332_ = pamac_package_get_version ((PamacPackage*) _tmp331_);
					_tmp333_ = _tmp332_;
					fprintf (_tmp324_, "%-*s  %-*s -> %-*s  %s\n", name_length, _tmp327_, installed_version_length, _tmp330_, version_length, _tmp333_, g_dgettext (NULL, "AUR"));
				}
			}
		}
		_tmp334_ = updates;
		_tmp335_ = pamac_updates_get_flatpak_updates (_tmp334_);
		_tmp336_ = _tmp335_;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp336_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacFlatpakPackage* pkg = NULL;
				pkg = (PamacFlatpakPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					const gchar* app_name = NULL;
					PamacFlatpakPackage* _tmp337_;
					const gchar* _tmp338_;
					const gchar* _tmp339_;
					const gchar* _tmp340_;
					FILE* _tmp344_;
					PamacFlatpakPackage* _tmp345_;
					const gchar* _tmp346_;
					const gchar* _tmp347_;
					PamacFlatpakPackage* _tmp348_;
					const gchar* _tmp349_;
					const gchar* _tmp350_;
					PamacFlatpakPackage* _tmp351_;
					const gchar* _tmp352_;
					const gchar* _tmp353_;
					_tmp337_ = pkg;
					_tmp338_ = pamac_package_get_app_name ((PamacPackage*) _tmp337_);
					_tmp339_ = _tmp338_;
					app_name = _tmp339_;
					_tmp340_ = app_name;
					if (_tmp340_ == NULL) {
						PamacFlatpakPackage* _tmp341_;
						const gchar* _tmp342_;
						const gchar* _tmp343_;
						_tmp341_ = pkg;
						_tmp342_ = pamac_package_get_name ((PamacPackage*) _tmp341_);
						_tmp343_ = _tmp342_;
						app_name = _tmp343_;
					}
					_tmp344_ = stdout;
					_tmp345_ = pkg;
					_tmp346_ = pamac_package_get_app_name ((PamacPackage*) _tmp345_);
					_tmp347_ = _tmp346_;
					_tmp348_ = pkg;
					_tmp349_ = pamac_package_get_version ((PamacPackage*) _tmp348_);
					_tmp350_ = _tmp349_;
					_tmp351_ = pkg;
					_tmp352_ = pamac_package_get_repo ((PamacPackage*) _tmp351_);
					_tmp353_ = _tmp352_;
					fprintf (_tmp344_, "%-*s  %-*s    %-*s  %s\n", name_length, _tmp347_, installed_version_length, "", version_length, _tmp350_, _tmp353_);
				}
			}
		}
		_tmp354_ = updates;
		_tmp355_ = pamac_updates_get_ignored_repos_updates (_tmp354_);
		_tmp356_ = _tmp355_;
		_tmp357_ = vala_g_ptr_array_get_length (_tmp356_);
		_tmp358_ = _tmp357_;
		_tmp359_ = updates;
		_tmp360_ = pamac_updates_get_ignored_aur_updates (_tmp359_);
		_tmp361_ = _tmp360_;
		_tmp362_ = vala_g_ptr_array_get_length (_tmp361_);
		_tmp363_ = _tmp362_;
		ignored_updates_nb = (guint) (_tmp358_ + _tmp363_);
		if (ignored_updates_nb > ((guint) 0)) {
			gchar* _tmp364_;
			FILE* _tmp365_;
			const gchar* _tmp366_;
			PamacUpdates* _tmp367_;
			GPtrArray* _tmp368_;
			GPtrArray* _tmp369_;
			PamacUpdates* _tmp383_;
			GPtrArray* _tmp384_;
			GPtrArray* _tmp385_;
			_tmp364_ = g_strdup_printf (ngettext ("%u ignored update", "%u ignored updates", (gulong) ignored_updates_nb), ignored_updates_nb);
			_g_free0 (info);
			info = _tmp364_;
			_tmp365_ = stdout;
			_tmp366_ = info;
			fprintf (_tmp365_, "\n%s:\n", _tmp366_);
			_tmp367_ = updates;
			_tmp368_ = pamac_updates_get_ignored_repos_updates (_tmp367_);
			_tmp369_ = _tmp368_;
			{
				GPtrArray* pkg_collection = NULL;
				guint pkg_index = 0U;
				pkg_collection = _tmp369_;
				for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
					PamacAlpmPackage* pkg = NULL;
					pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
					{
						FILE* _tmp370_;
						PamacAlpmPackage* _tmp371_;
						const gchar* _tmp372_;
						const gchar* _tmp373_;
						PamacAlpmPackage* _tmp374_;
						const gchar* _tmp375_;
						const gchar* _tmp376_;
						PamacAlpmPackage* _tmp377_;
						const gchar* _tmp378_;
						const gchar* _tmp379_;
						PamacAlpmPackage* _tmp380_;
						const gchar* _tmp381_;
						const gchar* _tmp382_;
						_tmp370_ = stdout;
						_tmp371_ = pkg;
						_tmp372_ = pamac_package_get_name ((PamacPackage*) _tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = pkg;
						_tmp375_ = pamac_package_get_installed_version ((PamacPackage*) _tmp374_);
						_tmp376_ = _tmp375_;
						_tmp377_ = pkg;
						_tmp378_ = pamac_package_get_version ((PamacPackage*) _tmp377_);
						_tmp379_ = _tmp378_;
						_tmp380_ = pkg;
						_tmp381_ = pamac_package_get_repo ((PamacPackage*) _tmp380_);
						_tmp382_ = _tmp381_;
						fprintf (_tmp370_, "%-*s  %-*s -> %-*s  %s\n", name_length, _tmp373_, installed_version_length, _tmp376_, version_length, _tmp379_, _tmp382_);
					}
				}
			}
			_tmp383_ = updates;
			_tmp384_ = pamac_updates_get_ignored_aur_updates (_tmp383_);
			_tmp385_ = _tmp384_;
			{
				GPtrArray* pkg_collection = NULL;
				guint pkg_index = 0U;
				pkg_collection = _tmp385_;
				for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
					PamacAURPackage* pkg = NULL;
					pkg = (PamacAURPackage*) g_ptr_array_index (pkg_collection, pkg_index);
					{
						FILE* _tmp386_;
						PamacAURPackage* _tmp387_;
						const gchar* _tmp388_;
						const gchar* _tmp389_;
						PamacAURPackage* _tmp390_;
						const gchar* _tmp391_;
						const gchar* _tmp392_;
						PamacAURPackage* _tmp393_;
						const gchar* _tmp394_;
						const gchar* _tmp395_;
						PamacAURPackage* _tmp396_;
						const gchar* _tmp397_;
						const gchar* _tmp398_;
						_tmp386_ = stdout;
						_tmp387_ = pkg;
						_tmp388_ = pamac_package_get_name ((PamacPackage*) _tmp387_);
						_tmp389_ = _tmp388_;
						_tmp390_ = pkg;
						_tmp391_ = pamac_package_get_installed_version ((PamacPackage*) _tmp390_);
						_tmp392_ = _tmp391_;
						_tmp393_ = pkg;
						_tmp394_ = pamac_package_get_version ((PamacPackage*) _tmp393_);
						_tmp395_ = _tmp394_;
						_tmp396_ = pkg;
						_tmp397_ = pamac_package_get_repo ((PamacPackage*) _tmp396_);
						_tmp398_ = _tmp397_;
						fprintf (_tmp386_, "%-*s  %-*s -> %-*s  %s\n", name_length, _tmp389_, installed_version_length, _tmp392_, version_length, _tmp395_, _tmp398_);
					}
				}
			}
		}
		_tmp399_ = updates;
		_tmp400_ = pamac_updates_get_outofdate (_tmp399_);
		_tmp401_ = _tmp400_;
		_tmp402_ = vala_g_ptr_array_get_length (_tmp401_);
		_tmp403_ = _tmp402_;
		if (_tmp403_ != 0) {
			FILE* _tmp404_;
			PamacUpdates* _tmp405_;
			GPtrArray* _tmp406_;
			GPtrArray* _tmp407_;
			_tmp404_ = stdout;
			fprintf (_tmp404_, "\n%s:\n", g_dgettext (NULL, "Out of Date"));
			_tmp405_ = updates;
			_tmp406_ = pamac_updates_get_outofdate (_tmp405_);
			_tmp407_ = _tmp406_;
			{
				GPtrArray* pkg_collection = NULL;
				guint pkg_index = 0U;
				pkg_collection = _tmp407_;
				for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
					PamacAURPackage* pkg = NULL;
					pkg = (PamacAURPackage*) g_ptr_array_index (pkg_collection, pkg_index);
					{
						FILE* _tmp408_;
						PamacAURPackage* _tmp409_;
						const gchar* _tmp410_;
						const gchar* _tmp411_;
						PamacAURPackage* _tmp412_;
						const gchar* _tmp413_;
						const gchar* _tmp414_;
						_tmp408_ = stdout;
						_tmp409_ = pkg;
						_tmp410_ = pamac_package_get_name ((PamacPackage*) _tmp409_);
						_tmp411_ = _tmp410_;
						_tmp412_ = pkg;
						_tmp413_ = pamac_package_get_version ((PamacPackage*) _tmp412_);
						_tmp414_ = _tmp413_;
						fprintf (_tmp408_, "%-*s  %-*s  %s\n", name_length, _tmp411_, version_length, _tmp414_, g_dgettext (NULL, "AUR"));
					}
				}
			}
		}
		_g_free0 (info);
	}
	_g_object_unref0 (updates);
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gpointer
__uint64_dup0 (gpointer self)
{
	return self ? _uint64_dup (self) : NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PamacCli* self;
		self = _data4_->self;
		_g_main_loop_unref0 (_data4_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
____lambda16_ (Block4Data* _data4_)
{
	PamacCli* self;
	GMainLoop* _tmp0_;
	self = _data4_->self;
	_tmp0_ = _data4_->loop;
	g_main_loop_quit (_tmp0_);
}

static void
_____lambda16__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda16_ (self);
	block4_data_unref (self);
}

static void
pamac_cli_clean_cache (PamacCli* self,
                       gboolean dry_run,
                       gboolean verbose,
                       gboolean no_confirm)
{
	GHashTable* details = NULL;
	PamacDatabase* _tmp0_;
	GHashTable* _tmp1_;
	guint length = 0U;
	GHashTable* _tmp2_;
	PamacDatabase* _tmp3_;
	PamacConfig* _tmp4_;
	PamacConfig* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	FILE* _tmp9_;
	PamacDatabase* _tmp10_;
	PamacConfig* _tmp11_;
	PamacConfig* _tmp12_;
	guint64 _tmp13_;
	guint64 _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_clean_cache_details (_tmp0_);
	details = _tmp1_;
	_tmp2_ = details;
	length = g_hash_table_size (_tmp2_);
	_tmp3_ = self->priv->database;
	_tmp4_ = pamac_database_get_config (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = pamac_config_get_clean_rm_only_uninstalled (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		FILE* _tmp8_;
		_tmp8_ = stdout;
		fprintf (_tmp8_, "%s\n", g_dgettext (NULL, "Remove only the versions of uninstalled packages"));
	}
	_tmp9_ = stdout;
	_tmp10_ = self->priv->database;
	_tmp11_ = pamac_database_get_config (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = pamac_config_get_clean_keep_num_pkgs (_tmp12_);
	_tmp14_ = _tmp13_;
	fprintf (_tmp9_, "%s: %llu\n\n", g_dgettext (NULL, "Number of versions of each package to keep in the cache"), _tmp14_);
	if (length == ((guint) 0)) {
		FILE* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp15_ = stdout;
		_tmp16_ = g_strdup_printf (g_dngettext (NULL, "%u file", "%u files", (gulong) length), length);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("%s: %s\n", g_dgettext (NULL, "To delete"), _tmp17_);
		_tmp19_ = _tmp18_;
		fprintf (_tmp15_, "%s", _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
	} else {
		guint64 total_size = 0ULL;
		GPtrArray* filenames = NULL;
		GPtrArray* _tmp20_;
		GHashTableIter iter = {0};
		GHashTable* _tmp21_;
		const gchar* filename = NULL;
		guint64* size = NULL;
		FILE* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gboolean _tmp43_ = FALSE;
		total_size = (guint64) 0;
		_tmp20_ = g_ptr_array_new_full ((guint) 0, NULL);
		filenames = _tmp20_;
		_tmp21_ = details;
		g_hash_table_iter_init (&iter, _tmp21_);
		while (TRUE) {
			gconstpointer _tmp22_ = NULL;
			gconstpointer _tmp23_ = NULL;
			gboolean _tmp24_;
			guint64* _tmp25_;
			guint64* _tmp26_;
			_tmp24_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp22_), (gpointer*) (&_tmp23_));
			filename = (const gchar*) _tmp22_;
			_g_free0 (size);
			_tmp25_ = __uint64_dup0 ((guint64*) _tmp23_);
			size = _tmp25_;
			if (!_tmp24_) {
				break;
			}
			_tmp26_ = size;
			total_size += *_tmp26_;
			if (verbose) {
				GPtrArray* _tmp27_;
				const gchar* _tmp28_;
				_tmp27_ = filenames;
				_tmp28_ = filename;
				g_ptr_array_add (_tmp27_, _tmp28_);
			}
		}
		if (verbose) {
			GPtrArray* _tmp29_;
			PamacDatabase* _tmp30_;
			GCompareFunc _tmp31_;
			GPtrArray* _tmp32_;
			FILE* _tmp35_;
			_tmp29_ = filenames;
			_tmp30_ = self->priv->database;
			_tmp31_ = _tmp30_->vercmp;
			vala_g_ptr_array_sort (_tmp29_, _tmp31_);
			_tmp32_ = filenames;
			{
				GPtrArray* name_collection = NULL;
				guint name_index = 0U;
				name_collection = _tmp32_;
				for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
					const gchar* name = NULL;
					name = (const gchar*) g_ptr_array_index (name_collection, name_index);
					{
						FILE* _tmp33_;
						const gchar* _tmp34_;
						_tmp33_ = stdout;
						_tmp34_ = name;
						fprintf (_tmp33_, "%s\n", _tmp34_);
					}
				}
			}
			_tmp35_ = stdout;
			fprintf (_tmp35_, "\n");
		}
		_tmp36_ = stdout;
		_tmp37_ = g_strdup_printf (g_dngettext (NULL, "%u file", "%u files", (gulong) length), length);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_format_size_full (total_size, G_FORMAT_SIZE_DEFAULT);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strdup_printf ("%s: %s  (%s)\n", g_dgettext (NULL, "To delete"), _tmp38_, _tmp40_);
		_tmp42_ = _tmp41_;
		fprintf (_tmp36_, "%s", _tmp42_);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		if (dry_run) {
			_g_free0 (size);
			_g_ptr_array_unref0 (filenames);
			_g_hash_table_unref0 (details);
			return;
		}
		if (no_confirm) {
			_tmp43_ = TRUE;
		} else {
			PamacTransactionCli* _tmp44_;
			_tmp44_ = self->transaction;
			_tmp43_ = pamac_transaction_cli_ask_user (_tmp44_, g_dgettext (NULL, "Clean cache"));
		}
		if (_tmp43_) {
			Block4Data* _data4_;
			GMainLoop* _tmp45_;
			PamacTransactionCli* _tmp46_;
			GMainLoop* _tmp47_;
			_data4_ = g_slice_new0 (Block4Data);
			_data4_->_ref_count_ = 1;
			_data4_->self = g_object_ref (self);
			_tmp45_ = g_main_loop_new (NULL, FALSE);
			_data4_->loop = _tmp45_;
			_tmp46_ = self->transaction;
			pamac_transaction_clean_cache_async ((PamacTransaction*) _tmp46_, _____lambda16__gasync_ready_callback, block4_data_ref (_data4_));
			_tmp47_ = _data4_->loop;
			g_main_loop_run (_tmp47_);
			block4_data_unref (_data4_);
			_data4_ = NULL;
		}
		_g_free0 (size);
		_g_ptr_array_unref0 (filenames);
	}
	_g_hash_table_unref0 (details);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PamacCli* self;
		self = _data5_->self;
		_g_main_loop_unref0 (_data5_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
____lambda15_ (Block5Data* _data5_)
{
	PamacCli* self;
	GMainLoop* _tmp0_;
	self = _data5_->self;
	_tmp0_ = _data5_->loop;
	g_main_loop_quit (_tmp0_);
}

static void
_____lambda15__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda15_ (self);
	block5_data_unref (self);
}

static void
pamac_cli_clean_build_files (PamacCli* self,
                             gboolean dry_run,
                             gboolean verbose,
                             gboolean no_confirm)
{
	GHashTable* details = NULL;
	PamacDatabase* _tmp0_;
	GHashTable* _tmp1_;
	guint length = 0U;
	GHashTable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_build_files_details (_tmp0_);
	details = _tmp1_;
	_tmp2_ = details;
	length = g_hash_table_size (_tmp2_);
	if (length == ((guint) 0)) {
		FILE* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = stdout;
		_tmp4_ = g_strdup_printf (g_dngettext (NULL, "%u file", "%u files", (gulong) length), length);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%s: %s\n", g_dgettext (NULL, "To delete"), _tmp5_);
		_tmp7_ = _tmp6_;
		fprintf (_tmp3_, "%s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
	} else {
		guint64 total_size = 0ULL;
		GPtrArray* filenames = NULL;
		GPtrArray* _tmp8_;
		GHashTableIter iter = {0};
		GHashTable* _tmp9_;
		const gchar* filename = NULL;
		guint64* size = NULL;
		FILE* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gboolean _tmp31_ = FALSE;
		total_size = (guint64) 0;
		_tmp8_ = g_ptr_array_new_full ((guint) 0, NULL);
		filenames = _tmp8_;
		_tmp9_ = details;
		g_hash_table_iter_init (&iter, _tmp9_);
		while (TRUE) {
			gconstpointer _tmp10_ = NULL;
			gconstpointer _tmp11_ = NULL;
			gboolean _tmp12_;
			guint64* _tmp13_;
			guint64* _tmp14_;
			_tmp12_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp10_), (gpointer*) (&_tmp11_));
			filename = (const gchar*) _tmp10_;
			_g_free0 (size);
			_tmp13_ = __uint64_dup0 ((guint64*) _tmp11_);
			size = _tmp13_;
			if (!_tmp12_) {
				break;
			}
			_tmp14_ = size;
			total_size += *_tmp14_;
			if (verbose) {
				GPtrArray* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = filenames;
				_tmp16_ = filename;
				g_ptr_array_add (_tmp15_, _tmp16_);
			}
		}
		if (verbose) {
			GPtrArray* _tmp17_;
			PamacDatabase* _tmp18_;
			GCompareFunc _tmp19_;
			GPtrArray* _tmp20_;
			FILE* _tmp23_;
			_tmp17_ = filenames;
			_tmp18_ = self->priv->database;
			_tmp19_ = _tmp18_->vercmp;
			vala_g_ptr_array_sort (_tmp17_, _tmp19_);
			_tmp20_ = filenames;
			{
				GPtrArray* name_collection = NULL;
				guint name_index = 0U;
				name_collection = _tmp20_;
				for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
					const gchar* name = NULL;
					name = (const gchar*) g_ptr_array_index (name_collection, name_index);
					{
						FILE* _tmp21_;
						const gchar* _tmp22_;
						_tmp21_ = stdout;
						_tmp22_ = name;
						fprintf (_tmp21_, "%s\n", _tmp22_);
					}
				}
			}
			_tmp23_ = stdout;
			fprintf (_tmp23_, "\n");
		}
		_tmp24_ = stdout;
		_tmp25_ = g_strdup_printf (g_dngettext (NULL, "%u file", "%u files", (gulong) length), length);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_format_size_full (total_size, G_FORMAT_SIZE_DEFAULT);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strdup_printf ("%s: %s  (%s)\n", g_dgettext (NULL, "To delete"), _tmp26_, _tmp28_);
		_tmp30_ = _tmp29_;
		fprintf (_tmp24_, "%s", _tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		if (dry_run) {
			_g_free0 (size);
			_g_ptr_array_unref0 (filenames);
			_g_hash_table_unref0 (details);
			return;
		}
		if (no_confirm) {
			_tmp31_ = TRUE;
		} else {
			PamacTransactionCli* _tmp32_;
			_tmp32_ = self->transaction;
			_tmp31_ = pamac_transaction_cli_ask_user (_tmp32_, g_dgettext (NULL, "Clean build files"));
		}
		if (_tmp31_) {
			Block5Data* _data5_;
			GMainLoop* _tmp33_;
			PamacTransactionCli* _tmp34_;
			GMainLoop* _tmp35_;
			_data5_ = g_slice_new0 (Block5Data);
			_data5_->_ref_count_ = 1;
			_data5_->self = g_object_ref (self);
			_tmp33_ = g_main_loop_new (NULL, FALSE);
			_data5_->loop = _tmp33_;
			_tmp34_ = self->transaction;
			pamac_transaction_clean_build_files_async ((PamacTransaction*) _tmp34_, _____lambda15__gasync_ready_callback, block5_data_ref (_data5_));
			_tmp35_ = _data5_->loop;
			g_main_loop_run (_tmp35_);
			block5_data_unref (_data5_);
			_data5_ = NULL;
		}
		_g_free0 (size);
		_g_ptr_array_unref0 (filenames);
	}
	_g_hash_table_unref0 (details);
}

static void
pamac_cli_install_pkgs (PamacCli* self,
                        gchar** targets,
                        gint targets_length1)
{
	GPtrArray* to_install = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* to_load = NULL;
	GPtrArray* _tmp1_;
	GPtrArray* to_build = NULL;
	GPtrArray* _tmp2_;
	guint to_install_length = 0U;
	GPtrArray* _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	guint to_load_length = 0U;
	GPtrArray* _tmp73_;
	gint _tmp74_;
	gint _tmp75_;
	guint to_build_length = 0U;
	GPtrArray* _tmp76_;
	gint _tmp77_;
	gint _tmp78_;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	GPtrArray* _tmp84_;
	GPtrArray* _tmp87_;
	GPtrArray* _tmp90_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	to_install = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	to_load = _tmp1_;
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	to_build = _tmp2_;
	{
		gchar** target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
		target_collection = targets;
		target_collection_length1 = targets_length1;
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
			const gchar* target = NULL;
			target = target_collection[target_it];
			{
				gboolean found = FALSE;
				const gchar* _tmp3_;
				found = FALSE;
				_tmp3_ = target;
				if (string_contains (_tmp3_, ".pkg.tar")) {
					const gchar* _tmp4_;
					_tmp4_ = target;
					if (string_contains (_tmp4_, "://")) {
						const gchar* _tmp5_;
						_tmp5_ = target;
						if (string_contains (_tmp5_, "file://")) {
							GFile* file = NULL;
							const gchar* _tmp6_;
							GFile* _tmp7_;
							gchar* absolute_path = NULL;
							GFile* _tmp8_;
							gchar* _tmp9_;
							const gchar* _tmp10_;
							_tmp6_ = target;
							_tmp7_ = g_file_new_for_uri (_tmp6_);
							file = _tmp7_;
							_tmp8_ = file;
							_tmp9_ = g_file_get_path (_tmp8_);
							absolute_path = _tmp9_;
							_tmp10_ = absolute_path;
							if (_tmp10_ != NULL) {
								GPtrArray* _tmp11_;
								gchar* _tmp12_;
								_tmp11_ = to_load;
								_tmp12_ = absolute_path;
								absolute_path = NULL;
								g_ptr_array_add (_tmp11_, _tmp12_);
								found = TRUE;
							}
							_g_free0 (absolute_path);
							_g_object_unref0 (file);
						} else {
							GPtrArray* _tmp13_;
							const gchar* _tmp14_;
							gchar* _tmp15_;
							_tmp13_ = to_load;
							_tmp14_ = target;
							_tmp15_ = g_strdup (_tmp14_);
							g_ptr_array_add (_tmp13_, _tmp15_);
							found = TRUE;
						}
					} else {
						GFile* file = NULL;
						const gchar* _tmp16_;
						GFile* _tmp17_;
						gchar* absolute_path = NULL;
						GFile* _tmp18_;
						gchar* _tmp19_;
						const gchar* _tmp20_;
						_tmp16_ = target;
						_tmp17_ = g_file_new_for_path (_tmp16_);
						file = _tmp17_;
						_tmp18_ = file;
						_tmp19_ = g_file_get_path (_tmp18_);
						absolute_path = _tmp19_;
						_tmp20_ = absolute_path;
						if (_tmp20_ != NULL) {
							GPtrArray* _tmp21_;
							gchar* _tmp22_;
							_tmp21_ = to_load;
							_tmp22_ = absolute_path;
							absolute_path = NULL;
							g_ptr_array_add (_tmp21_, _tmp22_);
							found = TRUE;
						}
						_g_free0 (absolute_path);
						_g_object_unref0 (file);
					}
				} else {
					PamacDatabase* _tmp23_;
					const gchar* _tmp24_;
					_tmp23_ = self->priv->database;
					_tmp24_ = target;
					if (pamac_database_has_sync_satisfier (_tmp23_, _tmp24_)) {
						GPtrArray* _tmp25_;
						const gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp25_ = to_install;
						_tmp26_ = target;
						_tmp27_ = g_strdup (_tmp26_);
						g_ptr_array_add (_tmp25_, _tmp27_);
						found = TRUE;
					} else {
						GPtrArray* groupnames = NULL;
						PamacDatabase* _tmp28_;
						GPtrArray* _tmp29_;
						GPtrArray* _tmp30_;
						GPtrArray* _tmp31_;
						const gchar* _tmp32_;
						GEqualFunc _tmp33_;
						_tmp28_ = self->priv->database;
						_tmp29_ = pamac_database_get_groups_names (_tmp28_);
						_tmp30_ = _g_ptr_array_ref0 (_tmp29_);
						groupnames = _tmp30_;
						_tmp31_ = groupnames;
						_tmp32_ = target;
						_tmp33_ = g_str_equal;
						if (g_ptr_array_find_with_equal_func (_tmp31_, _tmp32_, _tmp33_, NULL)) {
							const gchar* _tmp34_;
							_tmp34_ = target;
							pamac_cli_ask_group_confirmation (self, _tmp34_, &to_install);
							found = TRUE;
						} else {
							GPtrArray* pkgs = NULL;
							PamacDatabase* _tmp35_;
							const gchar* _tmp36_;
							GPtrArray* _tmp37_;
							GPtrArray* _tmp38_;
							gint _tmp39_;
							gint _tmp40_;
							_tmp35_ = self->priv->database;
							_tmp36_ = target;
							_tmp37_ = pamac_database_get_sync_pkgs_by_glob (_tmp35_, _tmp36_);
							pkgs = _tmp37_;
							_tmp38_ = pkgs;
							_tmp39_ = vala_g_ptr_array_get_length (_tmp38_);
							_tmp40_ = _tmp39_;
							if (_tmp40_ != 0) {
								GPtrArray* _tmp41_;
								found = TRUE;
								_tmp41_ = pkgs;
								{
									GPtrArray* pkg_collection = NULL;
									guint pkg_index = 0U;
									pkg_collection = _tmp41_;
									for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
										PamacAlpmPackage* pkg = NULL;
										pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
										{
											FILE* _tmp42_;
											PamacAlpmPackage* _tmp43_;
											const gchar* _tmp44_;
											const gchar* _tmp45_;
											gchar* _tmp46_;
											gchar* _tmp47_;
											gchar* _tmp48_;
											gchar* _tmp49_;
											GPtrArray* _tmp50_;
											PamacAlpmPackage* _tmp51_;
											const gchar* _tmp52_;
											const gchar* _tmp53_;
											gchar* _tmp54_;
											_tmp42_ = stdout;
											_tmp43_ = pkg;
											_tmp44_ = pamac_package_get_name ((PamacPackage*) _tmp43_);
											_tmp45_ = _tmp44_;
											_tmp46_ = g_strdup_printf (g_dgettext (NULL, "Add %s to install"), _tmp45_);
											_tmp47_ = _tmp46_;
											_tmp48_ = g_strdup_printf ("%s\n", _tmp47_);
											_tmp49_ = _tmp48_;
											fprintf (_tmp42_, "%s", _tmp49_);
											_g_free0 (_tmp49_);
											_g_free0 (_tmp47_);
											_tmp50_ = to_install;
											_tmp51_ = pkg;
											_tmp52_ = pamac_package_get_name ((PamacPackage*) _tmp51_);
											_tmp53_ = _tmp52_;
											_tmp54_ = g_strdup (_tmp53_);
											g_ptr_array_add (_tmp50_, _tmp54_);
										}
									}
								}
							}
							_g_ptr_array_unref0 (pkgs);
						}
						_g_ptr_array_unref0 (groupnames);
					}
				}
				if (!found) {
					PamacAURPackage* aur_pkg = NULL;
					PamacDatabase* _tmp55_;
					const gchar* _tmp56_;
					PamacAURPackage* _tmp57_;
					PamacAURPackage* _tmp58_;
					PamacAURPackage* _tmp59_;
					_tmp55_ = self->priv->database;
					_tmp56_ = target;
					_tmp57_ = pamac_database_get_aur_pkg (_tmp55_, _tmp56_);
					_tmp58_ = _g_object_ref0 (_tmp57_);
					aur_pkg = _tmp58_;
					_tmp59_ = aur_pkg;
					if (_tmp59_ != NULL) {
						FILE* _tmp60_;
						const gchar* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
						GPtrArray* _tmp64_;
						const gchar* _tmp65_;
						gchar* _tmp66_;
						_tmp60_ = stdout;
						_tmp61_ = target;
						_tmp62_ = g_strdup_printf (g_dgettext (NULL, "%s is only available from AUR"), _tmp61_);
						_tmp63_ = _tmp62_;
						fprintf (_tmp60_, "%s: %s\n", g_dgettext (NULL, "Warning"), _tmp63_);
						_g_free0 (_tmp63_);
						_tmp64_ = to_build;
						_tmp65_ = target;
						_tmp66_ = g_strdup (_tmp65_);
						g_ptr_array_add (_tmp64_, _tmp66_);
						found = TRUE;
					}
					_g_object_unref0 (aur_pkg);
				}
				if (!found) {
					const gchar* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					_tmp67_ = target;
					_tmp68_ = g_strdup_printf (g_dgettext (NULL, "target not found: %s"), _tmp67_);
					_tmp69_ = _tmp68_;
					pamac_cli_print_error (self, _tmp69_);
					_g_free0 (_tmp69_);
					_g_ptr_array_unref0 (to_build);
					_g_ptr_array_unref0 (to_load);
					_g_ptr_array_unref0 (to_install);
					return;
				}
			}
		}
	}
	_tmp70_ = to_install;
	_tmp71_ = vala_g_ptr_array_get_length (_tmp70_);
	_tmp72_ = _tmp71_;
	to_install_length = (guint) _tmp72_;
	_tmp73_ = to_load;
	_tmp74_ = vala_g_ptr_array_get_length (_tmp73_);
	_tmp75_ = _tmp74_;
	to_load_length = (guint) _tmp75_;
	_tmp76_ = to_build;
	_tmp77_ = vala_g_ptr_array_get_length (_tmp76_);
	_tmp78_ = _tmp77_;
	to_build_length = (guint) _tmp78_;
	if (to_install_length == ((guint) 0)) {
		_tmp80_ = to_load_length == ((guint) 0);
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		_tmp79_ = to_build_length == ((guint) 0);
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		FILE* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		_tmp81_ = stdout;
		_tmp82_ = g_strconcat (g_dgettext (NULL, "Nothing to do"), ".\n", NULL);
		_tmp83_ = _tmp82_;
		fprintf (_tmp81_, "%s", _tmp83_);
		_g_free0 (_tmp83_);
		_g_ptr_array_unref0 (to_build);
		_g_ptr_array_unref0 (to_load);
		_g_ptr_array_unref0 (to_install);
		return;
	}
	_tmp84_ = to_install;
	{
		GPtrArray* name_collection = NULL;
		guint name_index = 0U;
		name_collection = _tmp84_;
		for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
			const gchar* name = NULL;
			name = (const gchar*) g_ptr_array_index (name_collection, name_index);
			{
				PamacTransactionCli* _tmp85_;
				const gchar* _tmp86_;
				_tmp85_ = self->transaction;
				_tmp86_ = name;
				pamac_transaction_add_pkg_to_install ((PamacTransaction*) _tmp85_, _tmp86_);
			}
		}
	}
	_tmp87_ = to_load;
	{
		GPtrArray* path_collection = NULL;
		guint path_index = 0U;
		path_collection = _tmp87_;
		for (path_index = 0; path_index < path_collection->len; path_index = path_index + 1) {
			const gchar* path = NULL;
			path = (const gchar*) g_ptr_array_index (path_collection, path_index);
			{
				PamacTransactionCli* _tmp88_;
				const gchar* _tmp89_;
				_tmp88_ = self->transaction;
				_tmp89_ = path;
				pamac_transaction_add_path_to_load ((PamacTransaction*) _tmp88_, _tmp89_);
			}
		}
	}
	_tmp90_ = to_build;
	{
		GPtrArray* name_collection = NULL;
		guint name_index = 0U;
		name_collection = _tmp90_;
		for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
			const gchar* name = NULL;
			name = (const gchar*) g_ptr_array_index (name_collection, name_index);
			{
				PamacTransactionCli* _tmp91_;
				const gchar* _tmp92_;
				_tmp91_ = self->transaction;
				_tmp92_ = name;
				pamac_transaction_add_pkg_to_build ((PamacTransaction*) _tmp91_, _tmp92_, TRUE, TRUE);
			}
		}
	}
	pamac_cli_run_transaction (self);
	_g_ptr_array_unref0 (to_build);
	_g_ptr_array_unref0 (to_load);
	_g_ptr_array_unref0 (to_install);
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_string_free0 (ret);
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
uint_try_parse (const gchar* str,
                guint* _result_,
                const gchar** unparsed,
                guint _base)
{
	guint _vala__result_ = 0U;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gulong ulong_result = 0UL;
	gchar* _tmp0_ = NULL;
	gulong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gulong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtoul (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	ulong_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = ulong_result;
	if ((((gulong) 0) <= _tmp6_) && (_tmp6_ <= ((gulong) G_MAXUINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (guint) ulong_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXUINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static void
pamac_cli_ask_group_confirmation (PamacCli* self,
                                  const gchar* grpname,
                                  GPtrArray** to_install)
{
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	GPtrArray* _tmp1_;
	PamacTransactionCli* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gint name_length = 0;
	gint version_length = 0;
	GPtrArray* _tmp10_;
	guint pkgs_length = 0U;
	GPtrArray* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint num_length = 0;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	FILE* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gint num = 0;
	GPtrArray* _tmp34_;
	FILE* _tmp99_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (grpname != NULL);
	g_return_if_fail (*to_install != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_group_pkgs (_tmp0_, grpname);
	pkgs = _tmp1_;
	_tmp2_ = self->transaction;
	_tmp3_ = pamac_transaction_cli_get_no_confirm (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GPtrArray* _tmp5_;
		_tmp5_ = pkgs;
		{
			GPtrArray* pkg_collection = NULL;
			guint pkg_index = 0U;
			pkg_collection = _tmp5_;
			for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
				PamacAlpmPackage* pkg = NULL;
				pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
				{
					PamacAlpmPackage* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp6_ = pkg;
					_tmp7_ = pamac_package_get_name ((PamacPackage*) _tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = g_strdup (_tmp8_);
					g_ptr_array_add (*to_install, _tmp9_);
				}
			}
		}
		_g_ptr_array_unref0 (pkgs);
		return;
	}
	name_length = 0;
	version_length = 0;
	_tmp10_ = pkgs;
	{
		GPtrArray* pkg_collection = NULL;
		guint pkg_index = 0U;
		pkg_collection = _tmp10_;
		for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
			PamacAlpmPackage* pkg = NULL;
			pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
			{
				gint pkg_name_length = 0;
				PamacAlpmPackage* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint pkg_version_length = 0;
				PamacAlpmPackage* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				_tmp11_ = pkg;
				_tmp12_ = pamac_package_get_name ((PamacPackage*) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = strlen (_tmp13_);
				_tmp15_ = _tmp14_;
				pkg_name_length = _tmp15_;
				if (pkg_name_length > name_length) {
					name_length = pkg_name_length;
				}
				_tmp16_ = pkg;
				_tmp17_ = pamac_package_get_version ((PamacPackage*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = strlen (_tmp18_);
				_tmp20_ = _tmp19_;
				pkg_version_length = _tmp20_;
				if (pkg_version_length > version_length) {
					version_length = pkg_version_length;
				}
			}
		}
	}
	_tmp21_ = pkgs;
	_tmp22_ = vala_g_ptr_array_get_length (_tmp21_);
	_tmp23_ = _tmp22_;
	pkgs_length = (guint) _tmp23_;
	_tmp24_ = g_strdup_printf ("%u", pkgs_length);
	_tmp25_ = _tmp24_;
	_tmp26_ = strlen (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _tmp27_ + 1;
	_g_free0 (_tmp25_);
	num_length = _tmp28_;
	_tmp29_ = stdout;
	_tmp30_ = g_strdup_printf (g_dngettext (NULL, "There is %1$u member in group %2$s", "There are %1$u members in group %2$s", (gulong) pkgs_length), pkgs_length, grpname);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strdup_printf ("%s:\n", _tmp31_);
	_tmp33_ = _tmp32_;
	fprintf (_tmp29_, "%s", _tmp33_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	num = 1;
	_tmp34_ = pkgs;
	{
		GPtrArray* pkg_collection = NULL;
		guint pkg_index = 0U;
		pkg_collection = _tmp34_;
		for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
			PamacAlpmPackage* pkg = NULL;
			pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
			{
				FILE* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				PamacAlpmPackage* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				PamacAlpmPackage* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				PamacAlpmPackage* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				gint _tmp47_;
				_tmp35_ = stdout;
				_tmp36_ = g_strdup_printf ("%i:", num);
				_tmp37_ = _tmp36_;
				_tmp38_ = pkg;
				_tmp39_ = pamac_package_get_name ((PamacPackage*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = pkg;
				_tmp42_ = pamac_package_get_version ((PamacPackage*) _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = pkg;
				_tmp45_ = pamac_package_get_repo ((PamacPackage*) _tmp44_);
				_tmp46_ = _tmp45_;
				fprintf (_tmp35_, "%*s  %-*s  %-*s  %s\n", num_length, _tmp37_, name_length, _tmp40_, version_length, _tmp43_, _tmp46_);
				_g_free0 (_tmp37_);
				_tmp47_ = num;
				num = _tmp47_ + 1;
			}
		}
	}
	while (TRUE) {
		FILE* _tmp48_;
		FILE* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		FILE* _tmp52_;
		FILE* _tmp53_;
		gchar* ans = NULL;
		FILE* _tmp54_;
		gchar* _tmp55_;
		const gchar* _tmp56_;
		guint nb = 0U;
		GPtrArray* numbers = NULL;
		GPtrArray* _tmp57_;
		const gchar* _tmp58_;
		gchar* _tmp59_;
		const gchar* _tmp60_;
		GPtrArray* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		_tmp48_ = stdout;
		fprintf (_tmp48_, "\n");
		_tmp49_ = stdout;
		_tmp50_ = g_strdup_printf (g_dgettext (NULL, "Enter a selection (default=%s)"), g_dgettext (NULL, "all"));
		_tmp51_ = _tmp50_;
		fprintf (_tmp49_, "%s: ", _tmp51_);
		_g_free0 (_tmp51_);
		_tmp52_ = stdout;
		fflush (_tmp52_);
		_tmp53_ = stdin;
		tcflush (fileno (_tmp53_), TCIFLUSH);
		_tmp54_ = stdin;
		_tmp55_ = g_file_stream_read_line (_tmp54_);
		ans = _tmp55_;
		_tmp56_ = ans;
		if (_tmp56_ == NULL) {
			_g_free0 (ans);
			break;
		}
		_tmp57_ = g_ptr_array_new_full ((guint) 0, NULL);
		numbers = _tmp57_;
		_tmp58_ = ans;
		_tmp59_ = string_replace (_tmp58_, "\n", "");
		_g_free0 (ans);
		ans = _tmp59_;
		_tmp60_ = ans;
		if (g_strcmp0 (_tmp60_, "") == 0) {
			GPtrArray* _tmp61_;
			_tmp61_ = pkgs;
			{
				GPtrArray* pkg_collection = NULL;
				guint pkg_index = 0U;
				pkg_collection = _tmp61_;
				for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
					PamacAlpmPackage* pkg = NULL;
					pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
					{
						PamacAlpmPackage* _tmp62_;
						const gchar* _tmp63_;
						const gchar* _tmp64_;
						gchar* _tmp65_;
						_tmp62_ = pkg;
						_tmp63_ = pamac_package_get_name ((PamacPackage*) _tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = g_strdup (_tmp64_);
						g_ptr_array_add (*to_install, _tmp65_);
					}
				}
			}
			_g_ptr_array_unref0 (numbers);
			_g_free0 (ans);
			break;
		} else {
			gchar** splitted = NULL;
			const gchar* _tmp66_;
			gchar** _tmp67_;
			gchar** _tmp68_;
			gint splitted_length1;
			gint _splitted_size_;
			gchar** _tmp69_;
			gint _tmp69__length1;
			_tmp66_ = ans;
			_tmp68_ = _tmp67_ = g_strsplit (_tmp66_, ",", 0);
			splitted = _tmp68_;
			splitted_length1 = _vala_array_length (_tmp67_);
			_splitted_size_ = splitted_length1;
			_tmp69_ = splitted;
			_tmp69__length1 = splitted_length1;
			{
				gchar** part_collection = NULL;
				gint part_collection_length1 = 0;
				gint _part_collection_size_ = 0;
				gint part_it = 0;
				part_collection = _tmp69_;
				part_collection_length1 = _tmp69__length1;
				for (part_it = 0; part_it < part_collection_length1; part_it = part_it + 1) {
					const gchar* part = NULL;
					part = part_collection[part_it];
					{
						const gchar* _tmp70_;
						_tmp70_ = part;
						if (string_contains (_tmp70_, "-")) {
							gchar** splitted2 = NULL;
							const gchar* _tmp71_;
							gchar** _tmp72_;
							gchar** _tmp73_;
							gint splitted2_length1;
							gint _splitted2_size_;
							guint beg_num = 0U;
							guint end_num = 0U;
							gchar** _tmp74_;
							gint _tmp74__length1;
							const gchar* _tmp75_;
							guint _tmp76_ = 0U;
							gboolean _tmp77_;
							_tmp71_ = part;
							_tmp73_ = _tmp72_ = g_strsplit (_tmp71_, "-", 2);
							splitted2 = _tmp73_;
							splitted2_length1 = _vala_array_length (_tmp72_);
							_splitted2_size_ = splitted2_length1;
							_tmp74_ = splitted2;
							_tmp74__length1 = splitted2_length1;
							_tmp75_ = _tmp74_[0];
							_tmp77_ = uint_try_parse (_tmp75_, &_tmp76_, NULL, (guint) 0);
							beg_num = _tmp76_;
							if (_tmp77_) {
								gchar** _tmp78_;
								gint _tmp78__length1;
								const gchar* _tmp79_;
								guint _tmp80_ = 0U;
								gboolean _tmp81_;
								_tmp78_ = splitted2;
								_tmp78__length1 = splitted2_length1;
								_tmp79_ = _tmp78_[1];
								_tmp81_ = uint_try_parse (_tmp79_, &_tmp80_, NULL, (guint) 0);
								end_num = _tmp80_;
								if (_tmp81_) {
									nb = beg_num;
									while (TRUE) {
										gboolean _tmp82_ = FALSE;
										guint _tmp84_;
										if (!(nb <= end_num)) {
											break;
										}
										if (nb >= ((guint) 1)) {
											_tmp82_ = nb <= pkgs_length;
										} else {
											_tmp82_ = FALSE;
										}
										if (_tmp82_) {
											GPtrArray* _tmp83_;
											_tmp83_ = numbers;
											g_ptr_array_add (_tmp83_, (gpointer) ((guintptr) nb));
										}
										_tmp84_ = nb;
										nb = _tmp84_ + 1;
									}
								}
							}
							splitted2 = (_vala_array_free (splitted2, splitted2_length1, (GDestroyNotify) g_free), NULL);
						} else {
							const gchar* _tmp85_;
							guint _tmp86_ = 0U;
							gboolean _tmp87_;
							_tmp85_ = part;
							_tmp87_ = uint_try_parse (_tmp85_, &_tmp86_, NULL, (guint) 0);
							nb = _tmp86_;
							if (_tmp87_) {
								gboolean _tmp88_ = FALSE;
								if (nb >= ((guint) 1)) {
									_tmp88_ = nb <= pkgs_length;
								} else {
									_tmp88_ = FALSE;
								}
								if (_tmp88_) {
									GPtrArray* _tmp89_;
									_tmp89_ = numbers;
									g_ptr_array_add (_tmp89_, (gpointer) ((guintptr) nb));
								}
							}
						}
					}
				}
			}
			splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp90_ = numbers;
		_tmp91_ = vala_g_ptr_array_get_length (_tmp90_);
		_tmp92_ = _tmp91_;
		if (_tmp92_ > 0) {
			GPtrArray* _tmp93_;
			_tmp93_ = numbers;
			{
				GPtrArray* number_collection = NULL;
				guint number_index = 0U;
				number_collection = _tmp93_;
				for (number_index = 0; number_index < number_collection->len; number_index = number_index + 1) {
					guint number = 0U;
					number = (guint) ((guintptr) g_ptr_array_index (number_collection, number_index));
					{
						GPtrArray* _tmp94_;
						gconstpointer _tmp95_;
						const gchar* _tmp96_;
						const gchar* _tmp97_;
						gchar* _tmp98_;
						_tmp94_ = pkgs;
						_tmp95_ = g_ptr_array_index (_tmp94_, number - 1);
						_tmp96_ = pamac_package_get_name ((PamacPackage*) ((PamacAlpmPackage*) _tmp95_));
						_tmp97_ = _tmp96_;
						_tmp98_ = g_strdup (_tmp97_);
						g_ptr_array_add (*to_install, _tmp98_);
					}
				}
			}
			_g_ptr_array_unref0 (numbers);
			_g_free0 (ans);
			break;
		}
		_g_ptr_array_unref0 (numbers);
		_g_free0 (ans);
	}
	_tmp99_ = stdout;
	fprintf (_tmp99_, "\n");
	_g_ptr_array_unref0 (pkgs);
}

static void
pamac_cli_reinstall_pkgs (PamacCli* self,
                          gchar** names,
                          gint names_length1)
{
	GPtrArray* to_install = NULL;
	GPtrArray* _tmp0_;
	guint to_install_length = 0U;
	GPtrArray* _tmp89_;
	gint _tmp90_;
	gint _tmp91_;
	GPtrArray* _tmp95_;
	PamacTransactionCli* _tmp98_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	to_install = _tmp0_;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = names;
		name_collection_length1 = names_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				gboolean found = FALSE;
				const gchar* version = NULL;
				PamacAlpmPackage* local_pkg = NULL;
				PamacDatabase* _tmp1_;
				const gchar* _tmp2_;
				PamacAlpmPackage* _tmp3_;
				PamacAlpmPackage* _tmp4_;
				PamacAlpmPackage* _tmp5_;
				found = FALSE;
				version = NULL;
				_tmp1_ = self->priv->database;
				_tmp2_ = name;
				_tmp3_ = pamac_database_get_installed_pkg (_tmp1_, _tmp2_);
				_tmp4_ = _g_object_ref0 (_tmp3_);
				local_pkg = _tmp4_;
				_tmp5_ = local_pkg;
				if (_tmp5_ != NULL) {
					PamacAlpmPackage* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					PamacAlpmPackage* sync_pkg = NULL;
					PamacDatabase* _tmp9_;
					const gchar* _tmp10_;
					PamacAlpmPackage* _tmp11_;
					PamacAlpmPackage* _tmp12_;
					PamacAlpmPackage* _tmp13_;
					_tmp6_ = local_pkg;
					_tmp7_ = pamac_package_get_version ((PamacPackage*) _tmp6_);
					_tmp8_ = _tmp7_;
					version = _tmp8_;
					_tmp9_ = self->priv->database;
					_tmp10_ = name;
					_tmp11_ = pamac_database_get_sync_pkg (_tmp9_, _tmp10_);
					_tmp12_ = _g_object_ref0 (_tmp11_);
					sync_pkg = _tmp12_;
					_tmp13_ = sync_pkg;
					if (_tmp13_ != NULL) {
						PamacAlpmPackage* _tmp14_;
						const gchar* _tmp15_;
						const gchar* _tmp16_;
						PamacAlpmPackage* _tmp17_;
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						_tmp14_ = local_pkg;
						_tmp15_ = pamac_package_get_version ((PamacPackage*) _tmp14_);
						_tmp16_ = _tmp15_;
						_tmp17_ = sync_pkg;
						_tmp18_ = pamac_package_get_version ((PamacPackage*) _tmp17_);
						_tmp19_ = _tmp18_;
						if (g_strcmp0 (_tmp16_, _tmp19_) == 0) {
							GPtrArray* _tmp20_;
							const gchar* _tmp21_;
							gchar* _tmp22_;
							_tmp20_ = to_install;
							_tmp21_ = name;
							_tmp22_ = g_strdup (_tmp21_);
							g_ptr_array_add (_tmp20_, _tmp22_);
							found = TRUE;
						}
					}
					_g_object_unref0 (sync_pkg);
				} else {
					GPtrArray* groupnames = NULL;
					PamacDatabase* _tmp23_;
					GPtrArray* _tmp24_;
					GPtrArray* _tmp25_;
					GPtrArray* _tmp26_;
					const gchar* _tmp27_;
					GEqualFunc _tmp28_;
					_tmp23_ = self->priv->database;
					_tmp24_ = pamac_database_get_groups_names (_tmp23_);
					_tmp25_ = _g_ptr_array_ref0 (_tmp24_);
					groupnames = _tmp25_;
					_tmp26_ = groupnames;
					_tmp27_ = name;
					_tmp28_ = g_str_equal;
					if (g_ptr_array_find_with_equal_func (_tmp26_, _tmp27_, _tmp28_, NULL)) {
						GPtrArray* pkgs = NULL;
						PamacDatabase* _tmp29_;
						const gchar* _tmp30_;
						GPtrArray* _tmp31_;
						GPtrArray* _tmp32_;
						found = TRUE;
						_tmp29_ = self->priv->database;
						_tmp30_ = name;
						_tmp31_ = pamac_database_get_group_pkgs (_tmp29_, _tmp30_);
						pkgs = _tmp31_;
						_tmp32_ = pkgs;
						{
							GPtrArray* pkg_collection = NULL;
							guint pkg_index = 0U;
							pkg_collection = _tmp32_;
							for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
								PamacAlpmPackage* pkg = NULL;
								pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
								{
									PamacAlpmPackage* _tmp33_;
									const gchar* _tmp34_;
									const gchar* _tmp35_;
									PamacAlpmPackage* _tmp36_;
									const gchar* _tmp37_;
									const gchar* _tmp38_;
									_tmp33_ = pkg;
									_tmp34_ = pamac_package_get_version ((PamacPackage*) _tmp33_);
									_tmp35_ = _tmp34_;
									_tmp36_ = pkg;
									_tmp37_ = pamac_package_get_installed_version ((PamacPackage*) _tmp36_);
									_tmp38_ = _tmp37_;
									if (g_strcmp0 (_tmp35_, _tmp38_) == 0) {
										GPtrArray* _tmp39_;
										PamacAlpmPackage* _tmp40_;
										const gchar* _tmp41_;
										const gchar* _tmp42_;
										gchar* _tmp43_;
										_tmp39_ = to_install;
										_tmp40_ = pkg;
										_tmp41_ = pamac_package_get_name ((PamacPackage*) _tmp40_);
										_tmp42_ = _tmp41_;
										_tmp43_ = g_strdup (_tmp42_);
										g_ptr_array_add (_tmp39_, _tmp43_);
									}
								}
							}
						}
						_g_ptr_array_unref0 (pkgs);
					} else {
						GPtrArray* pkgs = NULL;
						PamacDatabase* _tmp44_;
						const gchar* _tmp45_;
						GPtrArray* _tmp46_;
						GPtrArray* _tmp47_;
						gint _tmp48_;
						gint _tmp49_;
						_tmp44_ = self->priv->database;
						_tmp45_ = name;
						_tmp46_ = pamac_database_get_installed_pkgs_by_glob (_tmp44_, _tmp45_);
						pkgs = _tmp46_;
						_tmp47_ = pkgs;
						_tmp48_ = vala_g_ptr_array_get_length (_tmp47_);
						_tmp49_ = _tmp48_;
						if (_tmp49_ != 0) {
							GPtrArray* _tmp50_;
							found = TRUE;
							_tmp50_ = pkgs;
							{
								GPtrArray* pkg_collection = NULL;
								guint pkg_index = 0U;
								pkg_collection = _tmp50_;
								for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
									PamacAlpmPackage* pkg = NULL;
									pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
									{
										PamacAlpmPackage* sync_pkg = NULL;
										PamacDatabase* _tmp51_;
										PamacAlpmPackage* _tmp52_;
										const gchar* _tmp53_;
										const gchar* _tmp54_;
										PamacAlpmPackage* _tmp55_;
										PamacAlpmPackage* _tmp56_;
										PamacAlpmPackage* _tmp57_;
										_tmp51_ = self->priv->database;
										_tmp52_ = pkg;
										_tmp53_ = pamac_package_get_name ((PamacPackage*) _tmp52_);
										_tmp54_ = _tmp53_;
										_tmp55_ = pamac_database_get_sync_pkg (_tmp51_, _tmp54_);
										_tmp56_ = _g_object_ref0 (_tmp55_);
										sync_pkg = _tmp56_;
										_tmp57_ = sync_pkg;
										if (_tmp57_ != NULL) {
											PamacAlpmPackage* _tmp58_;
											const gchar* _tmp59_;
											const gchar* _tmp60_;
											PamacAlpmPackage* _tmp61_;
											const gchar* _tmp62_;
											const gchar* _tmp63_;
											_tmp58_ = pkg;
											_tmp59_ = pamac_package_get_version ((PamacPackage*) _tmp58_);
											_tmp60_ = _tmp59_;
											_tmp61_ = sync_pkg;
											_tmp62_ = pamac_package_get_version ((PamacPackage*) _tmp61_);
											_tmp63_ = _tmp62_;
											if (g_strcmp0 (_tmp60_, _tmp63_) == 0) {
												FILE* _tmp64_;
												PamacAlpmPackage* _tmp65_;
												const gchar* _tmp66_;
												const gchar* _tmp67_;
												gchar* _tmp68_;
												gchar* _tmp69_;
												gchar* _tmp70_;
												gchar* _tmp71_;
												GPtrArray* _tmp72_;
												PamacAlpmPackage* _tmp73_;
												const gchar* _tmp74_;
												const gchar* _tmp75_;
												gchar* _tmp76_;
												_tmp64_ = stdout;
												_tmp65_ = pkg;
												_tmp66_ = pamac_package_get_name ((PamacPackage*) _tmp65_);
												_tmp67_ = _tmp66_;
												_tmp68_ = g_strdup_printf (g_dgettext (NULL, "Add %s to reinstall"), _tmp67_);
												_tmp69_ = _tmp68_;
												_tmp70_ = g_strdup_printf ("%s\n", _tmp69_);
												_tmp71_ = _tmp70_;
												fprintf (_tmp64_, "%s", _tmp71_);
												_g_free0 (_tmp71_);
												_g_free0 (_tmp69_);
												_tmp72_ = to_install;
												_tmp73_ = pkg;
												_tmp74_ = pamac_package_get_name ((PamacPackage*) _tmp73_);
												_tmp75_ = _tmp74_;
												_tmp76_ = g_strdup (_tmp75_);
												g_ptr_array_add (_tmp72_, _tmp76_);
												found = TRUE;
											}
										}
										_g_object_unref0 (sync_pkg);
									}
								}
							}
						}
						_g_ptr_array_unref0 (pkgs);
					}
					_g_ptr_array_unref0 (groupnames);
				}
				if (!found) {
					const gchar* _tmp77_;
					_tmp77_ = version;
					if (_tmp77_ == NULL) {
						const gchar* _tmp78_;
						gchar* _tmp79_;
						gchar* _tmp80_;
						_tmp78_ = name;
						_tmp79_ = g_strdup_printf (g_dgettext (NULL, "target not found: %s"), _tmp78_);
						_tmp80_ = _tmp79_;
						pamac_cli_print_error (self, _tmp80_);
						_g_free0 (_tmp80_);
					} else {
						const gchar* _tmp81_;
						gchar* _tmp82_;
						gchar* _tmp83_;
						const gchar* _tmp84_;
						gchar* _tmp85_;
						gchar* _tmp86_;
						gchar* _tmp87_;
						gchar* _tmp88_;
						_tmp81_ = name;
						_tmp82_ = g_strconcat (_tmp81_, "-", NULL);
						_tmp83_ = _tmp82_;
						_tmp84_ = version;
						_tmp85_ = g_strconcat (_tmp83_, _tmp84_, NULL);
						_tmp86_ = _tmp85_;
						_tmp87_ = g_strdup_printf (g_dgettext (NULL, "target not found: %s"), _tmp86_);
						_tmp88_ = _tmp87_;
						pamac_cli_print_error (self, _tmp88_);
						_g_free0 (_tmp88_);
						_g_free0 (_tmp86_);
						_g_free0 (_tmp83_);
					}
					_g_object_unref0 (local_pkg);
					_g_ptr_array_unref0 (to_install);
					return;
				}
				_g_object_unref0 (local_pkg);
			}
		}
	}
	_tmp89_ = to_install;
	_tmp90_ = vala_g_ptr_array_get_length (_tmp89_);
	_tmp91_ = _tmp90_;
	to_install_length = (guint) _tmp91_;
	if (to_install_length == ((guint) 0)) {
		FILE* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		_tmp92_ = stdout;
		_tmp93_ = g_strconcat (g_dgettext (NULL, "Nothing to do"), ".\n", NULL);
		_tmp94_ = _tmp93_;
		fprintf (_tmp92_, "%s", _tmp94_);
		_g_free0 (_tmp94_);
		_g_ptr_array_unref0 (to_install);
		return;
	}
	_tmp95_ = to_install;
	{
		GPtrArray* name_collection = NULL;
		guint name_index = 0U;
		name_collection = _tmp95_;
		for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
			const gchar* name = NULL;
			name = (const gchar*) g_ptr_array_index (name_collection, name_index);
			{
				PamacTransactionCli* _tmp96_;
				const gchar* _tmp97_;
				_tmp96_ = self->transaction;
				_tmp97_ = name;
				pamac_transaction_add_pkg_to_install ((PamacTransaction*) _tmp96_, _tmp97_);
			}
		}
	}
	_tmp98_ = self->transaction;
	pamac_transaction_set_install_if_needed ((PamacTransaction*) _tmp98_, FALSE);
	pamac_cli_run_transaction (self);
	_g_ptr_array_unref0 (to_install);
}

static void
pamac_cli_remove_pkgs (PamacCli* self,
                       gchar** names,
                       gint names_length1)
{
	GPtrArray* to_remove = NULL;
	GPtrArray* _tmp0_;
	gboolean group_found = FALSE;
	guint to_remove_length = 0U;
	GPtrArray* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	GPtrArray* _tmp57_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	to_remove = _tmp0_;
	group_found = FALSE;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = names;
		name_collection_length1 = names_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				gboolean found = FALSE;
				PamacDatabase* _tmp1_;
				const gchar* _tmp2_;
				found = FALSE;
				_tmp1_ = self->priv->database;
				_tmp2_ = name;
				if (pamac_database_is_installed_pkg (_tmp1_, _tmp2_)) {
					GPtrArray* _tmp3_;
					const gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp3_ = to_remove;
					_tmp4_ = name;
					_tmp5_ = g_strdup (_tmp4_);
					g_ptr_array_add (_tmp3_, _tmp5_);
					found = TRUE;
				} else {
					GPtrArray* groupnames = NULL;
					PamacDatabase* _tmp6_;
					GPtrArray* _tmp7_;
					GPtrArray* _tmp8_;
					GPtrArray* _tmp9_;
					const gchar* _tmp10_;
					GEqualFunc _tmp11_;
					_tmp6_ = self->priv->database;
					_tmp7_ = pamac_database_get_groups_names (_tmp6_);
					_tmp8_ = _g_ptr_array_ref0 (_tmp7_);
					groupnames = _tmp8_;
					_tmp9_ = groupnames;
					_tmp10_ = name;
					_tmp11_ = g_str_equal;
					if (g_ptr_array_find_with_equal_func (_tmp9_, _tmp10_, _tmp11_, NULL)) {
						GPtrArray* pkgs = NULL;
						PamacDatabase* _tmp12_;
						const gchar* _tmp13_;
						GPtrArray* _tmp14_;
						GPtrArray* _tmp15_;
						found = TRUE;
						_tmp12_ = self->priv->database;
						_tmp13_ = name;
						_tmp14_ = pamac_database_get_group_pkgs (_tmp12_, _tmp13_);
						pkgs = _tmp14_;
						_tmp15_ = pkgs;
						{
							GPtrArray* pkg_collection = NULL;
							guint pkg_index = 0U;
							pkg_collection = _tmp15_;
							for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
								PamacAlpmPackage* pkg = NULL;
								pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
								{
									PamacAlpmPackage* _tmp16_;
									const gchar* _tmp17_;
									const gchar* _tmp18_;
									PamacAlpmPackage* _tmp19_;
									const gchar* _tmp20_;
									const gchar* _tmp21_;
									_tmp16_ = pkg;
									_tmp17_ = pamac_package_get_version ((PamacPackage*) _tmp16_);
									_tmp18_ = _tmp17_;
									_tmp19_ = pkg;
									_tmp20_ = pamac_package_get_installed_version ((PamacPackage*) _tmp19_);
									_tmp21_ = _tmp20_;
									if (g_strcmp0 (_tmp18_, _tmp21_) == 0) {
										GPtrArray* _tmp22_;
										PamacAlpmPackage* _tmp23_;
										const gchar* _tmp24_;
										const gchar* _tmp25_;
										gchar* _tmp26_;
										_tmp22_ = to_remove;
										_tmp23_ = pkg;
										_tmp24_ = pamac_package_get_name ((PamacPackage*) _tmp23_);
										_tmp25_ = _tmp24_;
										_tmp26_ = g_strdup (_tmp25_);
										g_ptr_array_add (_tmp22_, _tmp26_);
										group_found = TRUE;
									}
								}
							}
						}
						_g_ptr_array_unref0 (pkgs);
					} else {
						GPtrArray* pkgs = NULL;
						PamacDatabase* _tmp27_;
						const gchar* _tmp28_;
						GPtrArray* _tmp29_;
						GPtrArray* _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
						_tmp27_ = self->priv->database;
						_tmp28_ = name;
						_tmp29_ = pamac_database_get_installed_pkgs_by_glob (_tmp27_, _tmp28_);
						pkgs = _tmp29_;
						_tmp30_ = pkgs;
						_tmp31_ = vala_g_ptr_array_get_length (_tmp30_);
						_tmp32_ = _tmp31_;
						if (_tmp32_ != 0) {
							GPtrArray* _tmp33_;
							found = TRUE;
							_tmp33_ = pkgs;
							{
								GPtrArray* pkg_collection = NULL;
								guint pkg_index = 0U;
								pkg_collection = _tmp33_;
								for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
									PamacAlpmPackage* pkg = NULL;
									pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
									{
										FILE* _tmp34_;
										PamacAlpmPackage* _tmp35_;
										const gchar* _tmp36_;
										const gchar* _tmp37_;
										gchar* _tmp38_;
										gchar* _tmp39_;
										gchar* _tmp40_;
										gchar* _tmp41_;
										GPtrArray* _tmp42_;
										PamacAlpmPackage* _tmp43_;
										const gchar* _tmp44_;
										const gchar* _tmp45_;
										gchar* _tmp46_;
										_tmp34_ = stdout;
										_tmp35_ = pkg;
										_tmp36_ = pamac_package_get_name ((PamacPackage*) _tmp35_);
										_tmp37_ = _tmp36_;
										_tmp38_ = g_strdup_printf (g_dgettext (NULL, "Add %s to remove"), _tmp37_);
										_tmp39_ = _tmp38_;
										_tmp40_ = g_strdup_printf ("%s\n", _tmp39_);
										_tmp41_ = _tmp40_;
										fprintf (_tmp34_, "%s", _tmp41_);
										_g_free0 (_tmp41_);
										_g_free0 (_tmp39_);
										_tmp42_ = to_remove;
										_tmp43_ = pkg;
										_tmp44_ = pamac_package_get_name ((PamacPackage*) _tmp43_);
										_tmp45_ = _tmp44_;
										_tmp46_ = g_strdup (_tmp45_);
										g_ptr_array_add (_tmp42_, _tmp46_);
									}
								}
							}
						}
						_g_ptr_array_unref0 (pkgs);
					}
					_g_ptr_array_unref0 (groupnames);
				}
				if (!found) {
					const gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					_tmp47_ = name;
					_tmp48_ = g_strdup_printf (g_dgettext (NULL, "target not found: %s"), _tmp47_);
					_tmp49_ = _tmp48_;
					pamac_cli_print_error (self, _tmp49_);
					_g_free0 (_tmp49_);
					_g_ptr_array_unref0 (to_remove);
					return;
				}
			}
		}
	}
	_tmp50_ = to_remove;
	_tmp51_ = vala_g_ptr_array_get_length (_tmp50_);
	_tmp52_ = _tmp51_;
	to_remove_length = (guint) _tmp52_;
	if (to_remove_length == ((guint) 0)) {
		FILE* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp53_ = stdout;
		_tmp54_ = g_strconcat (g_dgettext (NULL, "Nothing to do"), ".\n", NULL);
		_tmp55_ = _tmp54_;
		fprintf (_tmp53_, "%s", _tmp55_);
		_g_free0 (_tmp55_);
		_g_ptr_array_unref0 (to_remove);
		return;
	}
	if (group_found) {
		PamacTransactionCli* _tmp56_;
		_tmp56_ = self->transaction;
		pamac_transaction_set_remove_if_unneeded ((PamacTransaction*) _tmp56_, TRUE);
	}
	_tmp57_ = to_remove;
	{
		GPtrArray* name_collection = NULL;
		guint name_index = 0U;
		name_collection = _tmp57_;
		for (name_index = 0; name_index < name_collection->len; name_index = name_index + 1) {
			const gchar* name = NULL;
			name = (const gchar*) g_ptr_array_index (name_collection, name_index);
			{
				PamacTransactionCli* _tmp58_;
				const gchar* _tmp59_;
				_tmp58_ = self->transaction;
				_tmp59_ = name;
				pamac_transaction_add_pkg_to_remove ((PamacTransaction*) _tmp58_, _tmp59_);
			}
		}
	}
	pamac_cli_run_transaction (self);
	_g_ptr_array_unref0 (to_remove);
}

static void
pamac_cli_remove_orphans (PamacCli* self)
{
	GPtrArray* pkgs = NULL;
	PamacDatabase* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	PamacDatabase* _tmp7_;
	PamacConfig* _tmp8_;
	PamacConfig* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = pamac_database_get_orphans (_tmp0_);
	pkgs = _tmp1_;
	_tmp2_ = pkgs;
	{
		GPtrArray* pkg_collection = NULL;
		guint pkg_index = 0U;
		pkg_collection = _tmp2_;
		for (pkg_index = 0; pkg_index < pkg_collection->len; pkg_index = pkg_index + 1) {
			PamacAlpmPackage* pkg = NULL;
			pkg = (PamacAlpmPackage*) g_ptr_array_index (pkg_collection, pkg_index);
			{
				PamacTransactionCli* _tmp3_;
				PamacAlpmPackage* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = self->transaction;
				_tmp4_ = pkg;
				_tmp5_ = pamac_package_get_name ((PamacPackage*) _tmp4_);
				_tmp6_ = _tmp5_;
				pamac_transaction_add_pkg_to_remove ((PamacTransaction*) _tmp3_, _tmp6_);
			}
		}
	}
	_tmp7_ = self->priv->database;
	_tmp8_ = pamac_database_get_config (_tmp7_);
	_tmp9_ = _tmp8_;
	pamac_config_set_recurse (_tmp9_, TRUE);
	pamac_cli_run_transaction (self);
	_g_ptr_array_unref0 (pkgs);
}

static void
pamac_cli_clone_build_files (PamacCli* self,
                             gchar** pkgnames,
                             gint pkgnames_length1,
                             gboolean overwrite,
                             gboolean recurse,
                             gboolean quiet)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GPtrArray* pkgnames_array = NULL;
	GPtrArray* _tmp3_;
	GPtrArray* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->already_checked_aur_dep);
	self->priv->already_checked_aur_dep = _tmp2_;
	_tmp3_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	pkgnames_array = _tmp3_;
	{
		gchar** pkgname_collection = NULL;
		gint pkgname_collection_length1 = 0;
		gint _pkgname_collection_size_ = 0;
		gint pkgname_it = 0;
		pkgname_collection = pkgnames;
		pkgname_collection_length1 = pkgnames_length1;
		for (pkgname_it = 0; pkgname_it < pkgname_collection_length1; pkgname_it = pkgname_it + 1) {
			const gchar* pkgname = NULL;
			pkgname = pkgname_collection[pkgname_it];
			{
				GPtrArray* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp4_ = pkgnames_array;
				_tmp5_ = pkgname;
				_tmp6_ = g_strdup (_tmp5_);
				g_ptr_array_add (_tmp4_, _tmp6_);
			}
		}
	}
	self->priv->cloning = TRUE;
	_tmp7_ = pkgnames_array;
	pamac_cli_clone_build_files_real (self, _tmp7_, overwrite, recurse, quiet);
	self->priv->cloning = FALSE;
	_g_ptr_array_unref0 (pkgnames_array);
}

static void
pamac_cli_clone_build_files_real (PamacCli* self,
                                  GPtrArray* pkgnames,
                                  gboolean overwrite,
                                  gboolean recurse,
                                  gboolean quiet)
{
	GPtrArray* dep_to_check = NULL;
	GPtrArray* _tmp0_;
	GHashTable* aur_pkgs = NULL;
	PamacDatabase* _tmp1_;
	GHashTable* _tmp2_;
	GHashTableIter iter = {0};
	GHashTable* _tmp3_;
	const gchar* pkgname = NULL;
	PamacAURPackage* aur_pkg = NULL;
	GCancellable* _tmp103_;
	GPtrArray* _tmp104_;
	gint _tmp105_;
	gint _tmp106_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkgnames != NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	dep_to_check = _tmp0_;
	_tmp1_ = self->priv->database;
	_tmp2_ = pamac_database_get_aur_pkgs (_tmp1_, pkgnames);
	aur_pkgs = _tmp2_;
	_tmp3_ = aur_pkgs;
	g_hash_table_iter_init (&iter, _tmp3_);
	while (TRUE) {
		gconstpointer _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		gboolean _tmp6_;
		PamacAURPackage* _tmp7_;
		_tmp6_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp4_), (gpointer*) (&_tmp5_));
		pkgname = (const gchar*) _tmp4_;
		aur_pkg = (PamacAURPackage*) _tmp5_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = aur_pkg;
		if (_tmp7_ == NULL) {
			if (!quiet) {
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = pkgname;
				_tmp9_ = g_strdup_printf (g_dgettext (NULL, "target not found: %s"), _tmp8_);
				_tmp10_ = _tmp9_;
				pamac_cli_print_error (self, _tmp10_);
				_g_free0 (_tmp10_);
			}
			continue;
		} else {
			GFile* clone_dir = NULL;
			PamacDatabase* _tmp17_;
			PamacAURPackage* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			GCancellable* _tmp21_;
			GFile* _tmp22_;
			GFile* _tmp23_;
			if (!quiet) {
				FILE* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp11_ = stdout;
				_tmp12_ = pkgname;
				_tmp13_ = g_strdup_printf ("Cloning %s build files", _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat (g_dgettext (NULL, _tmp14_), "...\n", NULL);
				_tmp16_ = _tmp15_;
				fprintf (_tmp11_, "%s", _tmp16_);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp14_);
			}
			_tmp17_ = self->priv->database;
			_tmp18_ = aur_pkg;
			_tmp19_ = pamac_aur_package_get_packagebase (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = self->priv->cancellable;
			_tmp22_ = pamac_database_clone_build_files (_tmp17_, _tmp20_, overwrite, _tmp21_);
			clone_dir = _tmp22_;
			_tmp23_ = clone_dir;
			if (_tmp23_ == NULL) {
				_g_object_unref0 (clone_dir);
				_g_hash_table_unref0 (aur_pkgs);
				_g_ptr_array_unref0 (dep_to_check);
				return;
			} else {
				GCancellable* _tmp24_;
				_tmp24_ = self->priv->cancellable;
				if (g_cancellable_is_cancelled (_tmp24_)) {
					_g_object_unref0 (clone_dir);
					_g_hash_table_unref0 (aur_pkgs);
					_g_ptr_array_unref0 (dep_to_check);
					return;
				} else {
					if (recurse) {
						PamacAURPackage* _tmp25_;
						GPtrArray* _tmp26_;
						GPtrArray* _tmp27_;
						PamacAURPackage* _tmp51_;
						GPtrArray* _tmp52_;
						GPtrArray* _tmp53_;
						PamacAURPackage* _tmp77_;
						GPtrArray* _tmp78_;
						GPtrArray* _tmp79_;
						_tmp25_ = aur_pkg;
						_tmp26_ = pamac_alpm_package_get_depends ((PamacAlpmPackage*) _tmp25_);
						_tmp27_ = _tmp26_;
						{
							GPtrArray* dep_string_collection = NULL;
							guint dep_string_index = 0U;
							dep_string_collection = _tmp27_;
							for (dep_string_index = 0; dep_string_index < dep_string_collection->len; dep_string_index = dep_string_index + 1) {
								const gchar* dep_string = NULL;
								dep_string = (const gchar*) g_ptr_array_index (dep_string_collection, dep_string_index);
								{
									PamacAlpmPackage* pkg = NULL;
									PamacDatabase* _tmp28_;
									const gchar* _tmp29_;
									PamacAlpmPackage* _tmp40_;
									pkg = NULL;
									_tmp28_ = self->priv->database;
									_tmp29_ = dep_string;
									if (pamac_database_has_installed_satisfier (_tmp28_, _tmp29_)) {
										PamacDatabase* _tmp30_;
										const gchar* _tmp31_;
										PamacAlpmPackage* _tmp32_;
										PamacAlpmPackage* _tmp33_;
										_tmp30_ = self->priv->database;
										_tmp31_ = dep_string;
										_tmp32_ = pamac_database_get_installed_satisfier (_tmp30_, _tmp31_);
										_tmp33_ = _g_object_ref0 (_tmp32_);
										_g_object_unref0 (pkg);
										pkg = _tmp33_;
									} else {
										PamacDatabase* _tmp34_;
										const gchar* _tmp35_;
										_tmp34_ = self->priv->database;
										_tmp35_ = dep_string;
										if (pamac_database_has_sync_satisfier (_tmp34_, _tmp35_)) {
											PamacDatabase* _tmp36_;
											const gchar* _tmp37_;
											PamacAlpmPackage* _tmp38_;
											PamacAlpmPackage* _tmp39_;
											_tmp36_ = self->priv->database;
											_tmp37_ = dep_string;
											_tmp38_ = pamac_database_get_sync_satisfier (_tmp36_, _tmp37_);
											_tmp39_ = _g_object_ref0 (_tmp38_);
											_g_object_unref0 (pkg);
											pkg = _tmp39_;
										}
									}
									_tmp40_ = pkg;
									if (_tmp40_ == NULL) {
										gchar* dep_name = NULL;
										PamacDatabase* _tmp41_;
										const gchar* _tmp42_;
										gchar* _tmp43_;
										GHashTable* _tmp44_;
										const gchar* _tmp45_;
										_tmp41_ = self->priv->database;
										_tmp42_ = dep_string;
										_tmp43_ = pamac_database_get_alpm_dep_name (_tmp41_, _tmp42_);
										dep_name = _tmp43_;
										_tmp44_ = self->priv->already_checked_aur_dep;
										_tmp45_ = dep_name;
										if (!g_hash_table_contains (_tmp44_, _tmp45_)) {
											GHashTable* _tmp46_;
											const gchar* _tmp47_;
											gchar* _tmp48_;
											GPtrArray* _tmp49_;
											gchar* _tmp50_;
											_tmp46_ = self->priv->already_checked_aur_dep;
											_tmp47_ = dep_name;
											_tmp48_ = g_strdup (_tmp47_);
											g_hash_table_add (_tmp46_, _tmp48_);
											_tmp49_ = dep_to_check;
											_tmp50_ = dep_name;
											dep_name = NULL;
											g_ptr_array_add (_tmp49_, _tmp50_);
										}
										_g_free0 (dep_name);
									}
									_g_object_unref0 (pkg);
								}
							}
						}
						_tmp51_ = aur_pkg;
						_tmp52_ = pamac_alpm_package_get_makedepends ((PamacAlpmPackage*) _tmp51_);
						_tmp53_ = _tmp52_;
						{
							GPtrArray* dep_string_collection = NULL;
							guint dep_string_index = 0U;
							dep_string_collection = _tmp53_;
							for (dep_string_index = 0; dep_string_index < dep_string_collection->len; dep_string_index = dep_string_index + 1) {
								const gchar* dep_string = NULL;
								dep_string = (const gchar*) g_ptr_array_index (dep_string_collection, dep_string_index);
								{
									PamacAlpmPackage* pkg = NULL;
									PamacDatabase* _tmp54_;
									const gchar* _tmp55_;
									PamacAlpmPackage* _tmp66_;
									pkg = NULL;
									_tmp54_ = self->priv->database;
									_tmp55_ = dep_string;
									if (pamac_database_has_installed_satisfier (_tmp54_, _tmp55_)) {
										PamacDatabase* _tmp56_;
										const gchar* _tmp57_;
										PamacAlpmPackage* _tmp58_;
										PamacAlpmPackage* _tmp59_;
										_tmp56_ = self->priv->database;
										_tmp57_ = dep_string;
										_tmp58_ = pamac_database_get_installed_satisfier (_tmp56_, _tmp57_);
										_tmp59_ = _g_object_ref0 (_tmp58_);
										_g_object_unref0 (pkg);
										pkg = _tmp59_;
									} else {
										PamacDatabase* _tmp60_;
										const gchar* _tmp61_;
										_tmp60_ = self->priv->database;
										_tmp61_ = dep_string;
										if (pamac_database_has_sync_satisfier (_tmp60_, _tmp61_)) {
											PamacDatabase* _tmp62_;
											const gchar* _tmp63_;
											PamacAlpmPackage* _tmp64_;
											PamacAlpmPackage* _tmp65_;
											_tmp62_ = self->priv->database;
											_tmp63_ = dep_string;
											_tmp64_ = pamac_database_get_sync_satisfier (_tmp62_, _tmp63_);
											_tmp65_ = _g_object_ref0 (_tmp64_);
											_g_object_unref0 (pkg);
											pkg = _tmp65_;
										}
									}
									_tmp66_ = pkg;
									if (_tmp66_ == NULL) {
										gchar* dep_name = NULL;
										PamacDatabase* _tmp67_;
										const gchar* _tmp68_;
										gchar* _tmp69_;
										GHashTable* _tmp70_;
										const gchar* _tmp71_;
										_tmp67_ = self->priv->database;
										_tmp68_ = dep_string;
										_tmp69_ = pamac_database_get_alpm_dep_name (_tmp67_, _tmp68_);
										dep_name = _tmp69_;
										_tmp70_ = self->priv->already_checked_aur_dep;
										_tmp71_ = dep_name;
										if (!g_hash_table_contains (_tmp70_, _tmp71_)) {
											GHashTable* _tmp72_;
											const gchar* _tmp73_;
											gchar* _tmp74_;
											GPtrArray* _tmp75_;
											gchar* _tmp76_;
											_tmp72_ = self->priv->already_checked_aur_dep;
											_tmp73_ = dep_name;
											_tmp74_ = g_strdup (_tmp73_);
											g_hash_table_add (_tmp72_, _tmp74_);
											_tmp75_ = dep_to_check;
											_tmp76_ = dep_name;
											dep_name = NULL;
											g_ptr_array_add (_tmp75_, _tmp76_);
										}
										_g_free0 (dep_name);
									}
									_g_object_unref0 (pkg);
								}
							}
						}
						_tmp77_ = aur_pkg;
						_tmp78_ = pamac_alpm_package_get_checkdepends ((PamacAlpmPackage*) _tmp77_);
						_tmp79_ = _tmp78_;
						{
							GPtrArray* dep_string_collection = NULL;
							guint dep_string_index = 0U;
							dep_string_collection = _tmp79_;
							for (dep_string_index = 0; dep_string_index < dep_string_collection->len; dep_string_index = dep_string_index + 1) {
								const gchar* dep_string = NULL;
								dep_string = (const gchar*) g_ptr_array_index (dep_string_collection, dep_string_index);
								{
									PamacAlpmPackage* pkg = NULL;
									PamacDatabase* _tmp80_;
									const gchar* _tmp81_;
									PamacAlpmPackage* _tmp92_;
									pkg = NULL;
									_tmp80_ = self->priv->database;
									_tmp81_ = dep_string;
									if (pamac_database_has_installed_satisfier (_tmp80_, _tmp81_)) {
										PamacDatabase* _tmp82_;
										const gchar* _tmp83_;
										PamacAlpmPackage* _tmp84_;
										PamacAlpmPackage* _tmp85_;
										_tmp82_ = self->priv->database;
										_tmp83_ = dep_string;
										_tmp84_ = pamac_database_get_installed_satisfier (_tmp82_, _tmp83_);
										_tmp85_ = _g_object_ref0 (_tmp84_);
										_g_object_unref0 (pkg);
										pkg = _tmp85_;
									} else {
										PamacDatabase* _tmp86_;
										const gchar* _tmp87_;
										_tmp86_ = self->priv->database;
										_tmp87_ = dep_string;
										if (pamac_database_has_sync_satisfier (_tmp86_, _tmp87_)) {
											PamacDatabase* _tmp88_;
											const gchar* _tmp89_;
											PamacAlpmPackage* _tmp90_;
											PamacAlpmPackage* _tmp91_;
											_tmp88_ = self->priv->database;
											_tmp89_ = dep_string;
											_tmp90_ = pamac_database_get_sync_satisfier (_tmp88_, _tmp89_);
											_tmp91_ = _g_object_ref0 (_tmp90_);
											_g_object_unref0 (pkg);
											pkg = _tmp91_;
										}
									}
									_tmp92_ = pkg;
									if (_tmp92_ == NULL) {
										gchar* dep_name = NULL;
										PamacDatabase* _tmp93_;
										const gchar* _tmp94_;
										gchar* _tmp95_;
										GHashTable* _tmp96_;
										const gchar* _tmp97_;
										_tmp93_ = self->priv->database;
										_tmp94_ = dep_string;
										_tmp95_ = pamac_database_get_alpm_dep_name (_tmp93_, _tmp94_);
										dep_name = _tmp95_;
										_tmp96_ = self->priv->already_checked_aur_dep;
										_tmp97_ = dep_name;
										if (!g_hash_table_contains (_tmp96_, _tmp97_)) {
											GHashTable* _tmp98_;
											const gchar* _tmp99_;
											gchar* _tmp100_;
											GPtrArray* _tmp101_;
											gchar* _tmp102_;
											_tmp98_ = self->priv->already_checked_aur_dep;
											_tmp99_ = dep_name;
											_tmp100_ = g_strdup (_tmp99_);
											g_hash_table_add (_tmp98_, _tmp100_);
											_tmp101_ = dep_to_check;
											_tmp102_ = dep_name;
											dep_name = NULL;
											g_ptr_array_add (_tmp101_, _tmp102_);
										}
										_g_free0 (dep_name);
									}
									_g_object_unref0 (pkg);
								}
							}
						}
					}
				}
			}
			_g_object_unref0 (clone_dir);
		}
	}
	_tmp103_ = self->priv->cancellable;
	if (g_cancellable_is_cancelled (_tmp103_)) {
		_g_hash_table_unref0 (aur_pkgs);
		_g_ptr_array_unref0 (dep_to_check);
		return;
	}
	_tmp104_ = dep_to_check;
	_tmp105_ = vala_g_ptr_array_get_length (_tmp104_);
	_tmp106_ = _tmp105_;
	if (_tmp106_ > 0) {
		GPtrArray* _tmp107_;
		_tmp107_ = dep_to_check;
		pamac_cli_clone_build_files_real (self, _tmp107_, overwrite, recurse, quiet);
	}
	_g_hash_table_unref0 (aur_pkgs);
	_g_ptr_array_unref0 (dep_to_check);
}

static gboolean
pamac_cli_check_build_pkgs (PamacCli* self,
                            gchar** targets,
                            gint targets_length1,
                            gboolean no_confirm,
                            GPtrArray** checked_targets)
{
	GPtrArray* real_targets = NULL;
	GPtrArray* _tmp0_;
	GHashTable* not_found = NULL;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* aur_pkgs = NULL;
	PamacDatabase* _tmp27_;
	GPtrArray* _tmp28_;
	GHashTable* _tmp29_;
	GHashTableIter aur_pkgs_iter = {0};
	GHashTable* _tmp30_;
	const gchar* pkgname = NULL;
	PamacAURPackage* aur_pkg = NULL;
	GHashTable* _tmp39_;
	guint _tmp40_;
	guint _tmp41_;
	GHashTable* _tmp59_;
	guint _tmp60_;
	guint _tmp61_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (*checked_targets != NULL, FALSE);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	real_targets = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, NULL);
	not_found = _tmp3_;
	{
		gchar** target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
		target_collection = targets;
		target_collection_length1 = targets_length1;
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
			const gchar* target = NULL;
			target = target_collection[target_it];
			{
				GPtrArray* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				GHashTable* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				if (!no_confirm) {
					PamacAlpmPackage* sync_pkg = NULL;
					PamacDatabase* _tmp4_;
					const gchar* _tmp5_;
					PamacAlpmPackage* _tmp6_;
					PamacAlpmPackage* _tmp7_;
					PamacAlpmPackage* _tmp8_;
					_tmp4_ = self->priv->database;
					_tmp5_ = target;
					_tmp6_ = pamac_database_get_sync_pkg (_tmp4_, _tmp5_);
					_tmp7_ = _g_object_ref0 (_tmp6_);
					sync_pkg = _tmp7_;
					_tmp8_ = sync_pkg;
					if (_tmp8_ != NULL) {
						PamacTransactionCli* _tmp9_;
						const gchar* _tmp10_;
						PamacAlpmPackage* _tmp11_;
						const gchar* _tmp12_;
						const gchar* _tmp13_;
						gchar* _tmp14_;
						gchar* _tmp15_;
						gboolean _tmp16_;
						_tmp9_ = self->transaction;
						_tmp10_ = target;
						_tmp11_ = sync_pkg;
						_tmp12_ = pamac_package_get_repo ((PamacPackage*) _tmp11_);
						_tmp13_ = _tmp12_;
						_tmp14_ = g_strdup_printf (g_dgettext (NULL, "Install %1$s from %2$s"), _tmp10_, _tmp13_);
						_tmp15_ = _tmp14_;
						_tmp16_ = pamac_transaction_cli_ask_user (_tmp9_, _tmp15_);
						_g_free0 (_tmp15_);
						if (_tmp16_) {
							PamacTransactionCli* _tmp17_;
							PamacAlpmPackage* _tmp18_;
							const gchar* _tmp19_;
							const gchar* _tmp20_;
							_tmp17_ = self->transaction;
							_tmp18_ = sync_pkg;
							_tmp19_ = pamac_package_get_name ((PamacPackage*) _tmp18_);
							_tmp20_ = _tmp19_;
							pamac_transaction_add_pkg_to_install ((PamacTransaction*) _tmp17_, _tmp20_);
							_g_object_unref0 (sync_pkg);
							continue;
						}
					}
					_g_object_unref0 (sync_pkg);
				}
				_tmp21_ = real_targets;
				_tmp22_ = target;
				_tmp23_ = g_strdup (_tmp22_);
				g_ptr_array_add (_tmp21_, _tmp23_);
				_tmp24_ = not_found;
				_tmp25_ = target;
				_tmp26_ = target;
				g_hash_table_replace (_tmp24_, _tmp25_, _tmp26_);
			}
		}
	}
	_tmp27_ = self->priv->database;
	_tmp28_ = real_targets;
	_tmp29_ = pamac_database_get_aur_pkgs (_tmp27_, _tmp28_);
	aur_pkgs = _tmp29_;
	_tmp30_ = aur_pkgs;
	g_hash_table_iter_init (&aur_pkgs_iter, _tmp30_);
	while (TRUE) {
		gconstpointer _tmp31_ = NULL;
		gconstpointer _tmp32_ = NULL;
		gboolean _tmp33_;
		PamacAURPackage* _tmp34_;
		_tmp33_ = g_hash_table_iter_next (&aur_pkgs_iter, (gpointer*) (&_tmp31_), (gpointer*) (&_tmp32_));
		pkgname = (const gchar*) _tmp31_;
		aur_pkg = (PamacAURPackage*) _tmp32_;
		if (!_tmp33_) {
			break;
		}
		_tmp34_ = aur_pkg;
		if (_tmp34_ != NULL) {
			const gchar* _tmp35_;
			gchar* _tmp36_;
			GHashTable* _tmp37_;
			const gchar* _tmp38_;
			_tmp35_ = pkgname;
			_tmp36_ = g_strdup (_tmp35_);
			g_ptr_array_add (*checked_targets, _tmp36_);
			_tmp37_ = not_found;
			_tmp38_ = pkgname;
			g_hash_table_remove (_tmp37_, _tmp38_);
		}
	}
	_tmp39_ = not_found;
	_tmp40_ = g_hash_table_size (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ > ((guint) 0)) {
		GHashTableIter not_found_iter = {0};
		GHashTable* _tmp42_;
		const gchar* target = NULL;
		_tmp42_ = not_found;
		g_hash_table_iter_init (&not_found_iter, _tmp42_);
		while (TRUE) {
			gconstpointer _tmp43_ = NULL;
			gboolean _tmp44_;
			GPtrArray* search_aur_pkgs = NULL;
			PamacDatabase* _tmp45_;
			const gchar* _tmp46_;
			GPtrArray* _tmp47_;
			gboolean iter_removed = FALSE;
			GPtrArray* _tmp48_;
			_tmp44_ = g_hash_table_iter_next (&not_found_iter, (gpointer*) (&_tmp43_), (gpointer*) NULL);
			target = (const gchar*) _tmp43_;
			if (!_tmp44_) {
				break;
			}
			_tmp45_ = self->priv->database;
			_tmp46_ = target;
			_tmp47_ = pamac_database_search_aur_pkgs (_tmp45_, _tmp46_);
			search_aur_pkgs = _tmp47_;
			iter_removed = FALSE;
			_tmp48_ = search_aur_pkgs;
			{
				GPtrArray* found_pkg_collection = NULL;
				guint found_pkg_index = 0U;
				found_pkg_collection = _tmp48_;
				for (found_pkg_index = 0; found_pkg_index < found_pkg_collection->len; found_pkg_index = found_pkg_index + 1) {
					PamacAURPackage* found_pkg = NULL;
					found_pkg = (PamacAURPackage*) g_ptr_array_index (found_pkg_collection, found_pkg_index);
					{
						PamacAURPackage* _tmp49_;
						GPtrArray* _tmp50_;
						GPtrArray* _tmp51_;
						_tmp49_ = found_pkg;
						_tmp50_ = pamac_alpm_package_get_provides ((PamacAlpmPackage*) _tmp49_);
						_tmp51_ = _tmp50_;
						{
							GPtrArray* dep_string_collection = NULL;
							guint dep_string_index = 0U;
							dep_string_collection = _tmp51_;
							for (dep_string_index = 0; dep_string_index < dep_string_collection->len; dep_string_index = dep_string_index + 1) {
								const gchar* dep_string = NULL;
								dep_string = (const gchar*) g_ptr_array_index (dep_string_collection, dep_string_index);
								{
									gchar* dep_name = NULL;
									PamacDatabase* _tmp52_;
									const gchar* _tmp53_;
									gchar* _tmp54_;
									const gchar* _tmp55_;
									const gchar* _tmp56_;
									_tmp52_ = self->priv->database;
									_tmp53_ = dep_string;
									_tmp54_ = pamac_database_get_alpm_dep_name (_tmp52_, _tmp53_);
									dep_name = _tmp54_;
									_tmp55_ = dep_name;
									_tmp56_ = target;
									if (g_strcmp0 (_tmp55_, _tmp56_) == 0) {
										const gchar* _tmp57_;
										gchar* _tmp58_;
										_tmp57_ = target;
										_tmp58_ = g_strdup (_tmp57_);
										g_ptr_array_add (*checked_targets, _tmp58_);
										if (!iter_removed) {
											g_hash_table_iter_remove (&not_found_iter);
											iter_removed = TRUE;
										}
									}
									_g_free0 (dep_name);
									break;
								}
							}
						}
					}
				}
			}
			_g_ptr_array_unref0 (search_aur_pkgs);
		}
	}
	_tmp59_ = not_found;
	_tmp60_ = g_hash_table_size (_tmp59_);
	_tmp61_ = _tmp60_;
	if (_tmp61_ > ((guint) 0)) {
		GHashTableIter not_found_iter = {0};
		GHashTable* _tmp62_;
		const gchar* target = NULL;
		_tmp62_ = not_found;
		g_hash_table_iter_init (&not_found_iter, _tmp62_);
		while (TRUE) {
			gconstpointer _tmp63_ = NULL;
			gboolean _tmp64_;
			const gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			_tmp64_ = g_hash_table_iter_next (&not_found_iter, (gpointer*) (&_tmp63_), (gpointer*) NULL);
			target = (const gchar*) _tmp63_;
			if (!_tmp64_) {
				break;
			}
			_tmp65_ = target;
			_tmp66_ = g_strdup_printf (g_dgettext (NULL, "target not found: %s"), _tmp65_);
			_tmp67_ = _tmp66_;
			pamac_cli_print_error (self, _tmp67_);
			_g_free0 (_tmp67_);
		}
		result = FALSE;
		_g_hash_table_unref0 (aur_pkgs);
		_g_hash_table_unref0 (not_found);
		_g_ptr_array_unref0 (real_targets);
		return result;
	}
	result = TRUE;
	_g_hash_table_unref0 (aur_pkgs);
	_g_hash_table_unref0 (not_found);
	_g_ptr_array_unref0 (real_targets);
	return result;
}

static void
pamac_cli_build_pkgs (PamacCli* self,
                      gchar** names,
                      gint names_length1,
                      gboolean clone_build_files,
                      gboolean clone_deps_build_files)
{
	PamacTransactionCli* _tmp2_;
	g_return_if_fail (self != NULL);
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = names;
		name_collection_length1 = names_length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				PamacTransactionCli* _tmp0_;
				const gchar* _tmp1_;
				_tmp0_ = self->transaction;
				_tmp1_ = name;
				pamac_transaction_add_pkg_to_build ((PamacTransaction*) _tmp0_, _tmp1_, clone_build_files, clone_deps_build_files);
			}
		}
	}
	_tmp2_ = self->transaction;
	pamac_transaction_set_install_if_needed ((PamacTransaction*) _tmp2_, FALSE);
	pamac_cli_run_transaction (self);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		PamacCli* self;
		self = _data6_->self;
		_g_main_loop_unref0 (_data6_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda12_ (Block6Data* _data6_,
             GObject* obj,
             GAsyncResult* res)
{
	PamacCli* self;
	gboolean success = FALSE;
	PamacTransactionCli* _tmp0_;
	GMainLoop* _tmp1_;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->transaction;
	success = pamac_transaction_run_finish ((PamacTransaction*) _tmp0_, res);
	if (!success) {
		self->exit_status = 1;
	}
	_tmp1_ = _data6_->loop;
	g_main_loop_quit (_tmp1_);
}

static void
___lambda12__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda12_ (self, source_object, res);
	block6_data_unref (self);
}

static gboolean
___lambda11_ (Block6Data* _data6_)
{
	PamacCli* self;
	PamacTransactionCli* _tmp0_;
	gboolean result;
	self = _data6_->self;
	_tmp0_ = self->transaction;
	pamac_transaction_run_async ((PamacTransaction*) _tmp0_, ___lambda12__gasync_ready_callback, block6_data_ref (_data6_));
	result = FALSE;
	return result;
}

static gboolean
____lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda11_ (self);
	return result;
}

static void
___lambda13_ (Block6Data* _data6_,
              GObject* obj,
              GAsyncResult* res)
{
	PamacCli* self;
	gboolean success = FALSE;
	PamacTransactionCli* _tmp0_;
	GMainLoop* _tmp1_;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->transaction;
	success = pamac_transaction_run_finish ((PamacTransaction*) _tmp0_, res);
	if (!success) {
		self->exit_status = 1;
	}
	_tmp1_ = _data6_->loop;
	g_main_loop_quit (_tmp1_);
}

static void
____lambda13__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda13_ (self, source_object, res);
	block6_data_unref (self);
}

static void
pamac_cli_run_transaction (PamacCli* self)
{
	Block6Data* _data6_;
	GMainLoop* _tmp0_;
	GMainLoop* _tmp2_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data6_->loop = _tmp0_;
	if (geteuid () != ((uid_t) 0)) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ____lambda11__gsource_func, block6_data_ref (_data6_), block6_data_unref);
	} else {
		PamacTransactionCli* _tmp1_;
		_tmp1_ = self->transaction;
		pamac_transaction_run_async ((PamacTransaction*) _tmp1_, ____lambda13__gasync_ready_callback, block6_data_ref (_data6_));
	}
	_tmp2_ = _data6_->loop;
	g_main_loop_run (_tmp2_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
pamac_cli_run_sysupgrade (PamacCli* self,
                          gboolean force_refresh)
{
	PamacTransactionCli* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->transaction;
	pamac_transaction_add_pkgs_to_upgrade ((PamacTransaction*) _tmp0_, force_refresh);
	pamac_cli_run_transaction (self);
}

static gint
pamac_cli_main (gchar** args,
                gint args_length1)
{
	PamacCli* cli = NULL;
	PamacCli* _tmp0_;
	PamacCli* _tmp1_;
	PamacCli* _tmp2_;
	PamacTransactionCli* _tmp3_;
	PamacCli* _tmp6_;
	GSubprocess* _tmp7_;
	PamacCli* _tmp10_;
	gint result;
	textdomain ("pamac");
	setlocale (LC_ALL, "");
	_tmp0_ = pamac_cli_new ();
	cli = _tmp0_;
	_tmp1_ = cli;
	pamac_cli_parse_command_line (_tmp1_, args, (gint) args_length1);
	_tmp2_ = cli;
	_tmp3_ = _tmp2_->transaction;
	if (_tmp3_ != NULL) {
		PamacCli* _tmp4_;
		PamacTransactionCli* _tmp5_;
		_tmp4_ = cli;
		_tmp5_ = _tmp4_->transaction;
		pamac_transaction_quit_daemon ((PamacTransaction*) _tmp5_);
	}
	_tmp6_ = cli;
	_tmp7_ = _tmp6_->pkttyagent;
	if (_tmp7_ != NULL) {
		PamacCli* _tmp8_;
		GSubprocess* _tmp9_;
		_tmp8_ = cli;
		_tmp9_ = _tmp8_->pkttyagent;
		g_subprocess_force_exit (_tmp9_);
	}
	_tmp10_ = cli;
	result = _tmp10_->exit_status;
	_g_object_unref0 (cli);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return pamac_cli_main (argv, argc);
}

static void
pamac_cli_class_init (PamacCliClass * klass,
                      gpointer klass_data)
{
	pamac_cli_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacCli_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pamac_cli_finalize;
}

static void
pamac_cli_instance_init (PamacCli * self,
                         gpointer klass)
{
	self->priv = pamac_cli_get_instance_private (self);
}

static void
pamac_cli_finalize (GObject * obj)
{
	PamacCli * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_CLI, PamacCli);
	_g_object_unref0 (self->transaction);
	_g_object_unref0 (self->priv->database);
	_g_object_unref0 (self->priv->cancellable);
	_g_hash_table_unref0 (self->priv->already_checked_aur_dep);
	_g_object_unref0 (self->pkttyagent);
	G_OBJECT_CLASS (pamac_cli_parent_class)->finalize (obj);
}

static GType
pamac_cli_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacCliClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_cli_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacCli), 0, (GInstanceInitFunc) pamac_cli_instance_init, NULL };
	GType pamac_cli_type_id;
	pamac_cli_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacCli", &g_define_type_info, 0);
	PamacCli_private_offset = g_type_add_instance_private (pamac_cli_type_id, sizeof (PamacCliPrivate));
	return pamac_cli_type_id;
}

GType
pamac_cli_get_type (void)
{
	static volatile gsize pamac_cli_type_id__once = 0;
	if (g_once_init_enter (&pamac_cli_type_id__once)) {
		GType pamac_cli_type_id;
		pamac_cli_type_id = pamac_cli_get_type_once ();
		g_once_init_leave (&pamac_cli_type_id__once, pamac_cli_type_id);
	}
	return pamac_cli_type_id__once;
}

gint
pamac_sort_search_pkgs_by_relevance (PamacPackage* pkg_a,
                                     PamacPackage* pkg_b)
{
	const gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (pkg_a != NULL, 0);
	g_return_val_if_fail (pkg_b != NULL, 0);
	_tmp0_ = pamac_search_string;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* search_string_prefix = NULL;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp1_ = pamac_package_get_name (pkg_a);
		_tmp2_ = _tmp1_;
		_tmp3_ = pamac_search_string;
		if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp4_ = pamac_package_get_name (pkg_b);
			_tmp5_ = _tmp4_;
			_tmp6_ = pamac_search_string;
			if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
				result = pamac_sort_pkgs_by_relevance (pkg_a, pkg_b);
				return result;
			}
			result = -1;
			return result;
		}
		_tmp7_ = pamac_package_get_name (pkg_b);
		_tmp8_ = _tmp7_;
		_tmp9_ = pamac_search_string;
		if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
			result = 1;
			return result;
		}
		_tmp10_ = pamac_search_string;
		_tmp11_ = g_strconcat (_tmp10_, "-", NULL);
		search_string_prefix = _tmp11_;
		_tmp12_ = pamac_package_get_name (pkg_a);
		_tmp13_ = _tmp12_;
		_tmp14_ = search_string_prefix;
		if (g_str_has_prefix (_tmp13_, _tmp14_)) {
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = pamac_package_get_name (pkg_b);
			_tmp16_ = _tmp15_;
			_tmp17_ = search_string_prefix;
			if (g_str_has_prefix (_tmp16_, _tmp17_)) {
				result = pamac_sort_pkgs_by_relevance (pkg_a, pkg_b);
				_g_free0 (search_string_prefix);
				return result;
			}
			result = -1;
			_g_free0 (search_string_prefix);
			return result;
		}
		_tmp18_ = pamac_package_get_name (pkg_b);
		_tmp19_ = _tmp18_;
		_tmp20_ = search_string_prefix;
		if (g_str_has_prefix (_tmp19_, _tmp20_)) {
			result = 1;
			_g_free0 (search_string_prefix);
			return result;
		}
		_tmp21_ = pamac_package_get_name (pkg_a);
		_tmp22_ = _tmp21_;
		_tmp23_ = pamac_search_string;
		if (g_str_has_prefix (_tmp22_, _tmp23_)) {
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			_tmp24_ = pamac_package_get_name (pkg_b);
			_tmp25_ = _tmp24_;
			_tmp26_ = pamac_search_string;
			if (g_str_has_prefix (_tmp25_, _tmp26_)) {
				result = pamac_sort_pkgs_by_relevance (pkg_a, pkg_b);
				_g_free0 (search_string_prefix);
				return result;
			}
			result = -1;
			_g_free0 (search_string_prefix);
			return result;
		}
		_tmp27_ = pamac_package_get_name (pkg_b);
		_tmp28_ = _tmp27_;
		_tmp29_ = pamac_search_string;
		if (g_str_has_prefix (_tmp28_, _tmp29_)) {
			result = 1;
			_g_free0 (search_string_prefix);
			return result;
		}
		_tmp30_ = pamac_package_get_name (pkg_a);
		_tmp31_ = _tmp30_;
		_tmp32_ = pamac_search_string;
		if (string_contains (_tmp31_, _tmp32_)) {
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			_tmp33_ = pamac_package_get_name (pkg_b);
			_tmp34_ = _tmp33_;
			_tmp35_ = pamac_search_string;
			if (string_contains (_tmp34_, _tmp35_)) {
				result = pamac_sort_pkgs_by_relevance (pkg_a, pkg_b);
				_g_free0 (search_string_prefix);
				return result;
			}
			result = -1;
			_g_free0 (search_string_prefix);
			return result;
		}
		_tmp36_ = pamac_package_get_name (pkg_b);
		_tmp37_ = _tmp36_;
		_tmp38_ = pamac_search_string;
		if (string_contains (_tmp37_, _tmp38_)) {
			result = 1;
			_g_free0 (search_string_prefix);
			return result;
		}
		_g_free0 (search_string_prefix);
	}
	result = pamac_sort_pkgs_by_relevance (pkg_a, pkg_b);
	return result;
}

gint
pamac_sort_pkgs_by_relevance (PamacPackage* pkg_a,
                              PamacPackage* pkg_b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint result;
	g_return_val_if_fail (pkg_a != NULL, 0);
	g_return_val_if_fail (pkg_b != NULL, 0);
	_tmp0_ = pamac_package_get_installed_version (pkg_a);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = pamac_package_get_installed_version (pkg_b);
		_tmp3_ = _tmp2_;
		if (_tmp3_ == NULL) {
			result = pamac_sort_pkgs_by_name (pkg_a, pkg_b);
			return result;
		}
		result = 1;
		return result;
	}
	_tmp4_ = pamac_package_get_installed_version (pkg_b);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		result = -1;
		return result;
	}
	result = pamac_sort_pkgs_by_name (pkg_a, pkg_b);
	return result;
}

gint
pamac_sort_pkgs_by_name (PamacPackage* pkg_a,
                         PamacPackage* pkg_b)
{
	gchar* str_a = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* str_b = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GCompareFunc _tmp6_;
	gint result;
	g_return_val_if_fail (pkg_a != NULL, 0);
	g_return_val_if_fail (pkg_b != NULL, 0);
	_tmp0_ = pamac_package_get_name (pkg_a);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_collate_key (_tmp1_, (gssize) -1);
	str_a = _tmp2_;
	_tmp3_ = pamac_package_get_name (pkg_b);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_collate_key (_tmp4_, (gssize) -1);
	str_b = _tmp5_;
	_tmp6_ = ((GCompareFunc) g_strcmp0);
	result = _tmp6_ (str_a, str_b);
	_g_free0 (str_b);
	_g_free0 (str_a);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

