/**
 * ./src/classes/ovary.d/bind-live-fs.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
// packages
import path from 'node:path';
import Utils from '../utils.js';
// _dirname
const __dirname = path.dirname(new URL(import.meta.url).pathname);
/**
   * bind dei virtual file system
   */
export async function bindVfs() {
    if (this.verbose) {
        console.log('Ovary: bindVfs');
    }
    const cmds = [];
    cmds.push(`mount -o bind /dev ${this.settings.work_dir.merged}/dev`, `mount -o bind /dev/pts ${this.settings.work_dir.merged}/dev/pts`, `mount -o bind /proc ${this.settings.work_dir.merged}/proc`, `mount -o bind /sys ${this.settings.work_dir.merged}/sys`, `mount -o bind /run ${this.settings.work_dir.merged}/run`);
    // Utils.writeXs(`${this.settings.config.snapshot_dir}bindvfs`, cmds)
    Utils.writeXs(`${this.settings.work_dir.ovarium}bindvfs`, cmds);
}
/**
 *
 * @param verbose
 */
export async function ubindVfs() {
    if (this.verbose) {
        console.log('Ovary: ubindVfs');
    }
    const cmds = [];
    cmds.push(`umount ${this.settings.work_dir.merged}/dev/pts`, `umount ${this.settings.work_dir.merged}/dev`, `umount ${this.settings.work_dir.merged}/proc`, `umount ${this.settings.work_dir.merged}/run`, `umount ${this.settings.work_dir.merged}/sys`);
    // Utils.writeXs(`${this.settings.config.snapshot_dir}ubindvfs`, cmds)
    Utils.writeXs(`${this.settings.work_dir.ovarium}ubindvfs`, cmds);
}
