/**
 * ./src/classes/ovary.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import path from 'node:path';
import CliAutologin from './cli-autologin.js';
// Methods
import { fertilization } from './ovary.d/fertilization.js';
import { produce } from './ovary.d/produce.js';
import { bindLiveFs, uBindLiveFs } from './ovary.d/bind-live-fs.js';
import { bindVfs, ubindVfs } from './ovary.d/bind-vfs.js';
import { editLiveFs } from './ovary.d/edit-live-fs.js';
import { makeSquashfs, addExclusion } from './ovary.d/make-squashfs.js';
import { makeEfi } from './ovary.d/make-efi.js';
import { xorrisoCommand } from './ovary.d/xorriso-commend.js';
import { createXdgAutostart } from './ovary.d/create-xdg-autostart.js';
import { copied, merged, mergedAndOverlay } from './ovary.d/merged.js';
import { makeIso } from './ovary.d/make-iso.js';
import { initrdAlpine, initrdArch, initrdDebian, initrdDracut } from './ovary.d/initrd.js';
import { userCreateLive } from './ovary.d/user-create-live.js';
import { syslinux } from './ovary.d/syslinux.js';
import { usersRemove } from './ovary.d/users-remove.js';
import { makeDotDisk } from './ovary.d/make-dot-disk.js';
import { kernelCopy } from './ovary.d/kernel-copy.js';
import { liveCreateStructure } from './ovary.d/live-create-structure.js';
import { finished } from './ovary.d/finished.js';
// _dirname
const __dirname = path.dirname(new URL(import.meta.url).pathname);
/**
 * Ovary:
 */
export default class Ovary {
    cliAutologin = new CliAutologin();
    clone = false;
    compression = '';
    cryptedclone = false;
    echo = {};
    familyId = '';
    distroId = '';
    genisoimage = false;
    incubator = {};
    nest = '';
    settings = {};
    snapshot_basename = '';
    snapshot_prefix = '';
    theme = '';
    toNull = '';
    verbose = false;
    volid = '';
    uuid = '';
    kernel = '';
    initrd = '';
    vmlinuz = '';
    // I put all methods on ovary.d
    fertilization = fertilization;
    produce = produce;
    // called only inside Ovary
    bindLiveFs = bindLiveFs;
    bindVfs = bindVfs;
    editLiveFs = editLiveFs;
    makeEfi = makeEfi;
    makeSquashfs = makeSquashfs;
    addExclusion = addExclusion;
    xorrisoCommand = xorrisoCommand;
    createXdgAutostart = createXdgAutostart;
    copied = copied;
    merged = merged;
    mergedAndOverlay = mergedAndOverlay;
    makeIso = makeIso;
    initrdAlpine = initrdAlpine;
    initrdArch = initrdArch;
    initrdDebian = initrdDebian;
    initrdDracut = initrdDracut;
    userCreateLive = userCreateLive;
    syslinux = syslinux;
    uBindLiveFs = uBindLiveFs;
    ubindVfs = ubindVfs;
    usersRemove = usersRemove;
    makeDotDisk = makeDotDisk;
    kernelCopy = kernelCopy;
    liveCreateStructure = liveCreateStructure;
    finished = finished;
}
