/**
 * ./src/classes/utils.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 *
 * Refactored Utils class - imports from modular utilities
 */
import System from './utils.d/system.js';
import PackageInfo from './utils.d/package-info.js';
import Network from './utils.d/network.js';
import Filesystem from './utils.d/filesystem.js';
import Snapshot from './utils.d/snapshot.js';
import Architecture from './utils.d/architecture.js';
import UserInteraction from './utils.d/user-interaction.js';
import ConsoleOutput from './utils.d/console-output.js';
import Formatters from './utils.d/formatters.js';
import Kernel from './utils.d/kernel.js';
/**
 * Utils: general purpose utils
 * @remarks all the utilities - refactored into modular structure
 */
export default class Utils {
    static isContainer: typeof System.isContainer;
    static isSystemd: typeof System.isSystemd;
    static isSysvinit: typeof System.isSysvinit;
    static isOpenRc: typeof System.isOpenRc;
    static isLive: typeof System.isLive;
    static isMountpoint: typeof System.isMountpoint;
    static isBlockDevice: typeof System.isBlockDevice;
    static isRoot: typeof System.isRoot;
    static machineId: typeof System.machineId;
    static getDebianVersion: typeof System.getDebianVersion;
    static getLiveRootSpace: typeof System.getLiveRootSpace;
    static getPackageName: typeof PackageInfo.getPackageName;
    static getFriendName: typeof PackageInfo.getFriendName;
    static getPackageVersion: typeof PackageInfo.getPackageVersion;
    static getAuthorName: typeof PackageInfo.getAuthorName;
    static isPackage: typeof PackageInfo.isPackage;
    static isSources: typeof PackageInfo.isSources;
    static isNpmPackage: typeof PackageInfo.isNpmPackage;
    static rootPenguin: typeof PackageInfo.rootPenguin;
    static wardrobe: typeof PackageInfo.wardrobe;
    static getPrimaryUser: typeof PackageInfo.getPrimaryUser;
    static iface: typeof Network.iface;
    static address: typeof Network.address;
    static netmask: typeof Network.netmask;
    static cidr: typeof Network.cidr;
    static broadcast: typeof Network.broadcast;
    static getDns: typeof Network.getDns;
    static getDomain: typeof Network.getDomain;
    static gateway: typeof Network.gateway;
    static searchOnFile: typeof Filesystem.searchOnFile;
    static uuid: typeof Filesystem.uuid;
    static uuidGen: typeof Filesystem.uuidGen;
    static getUsedSpace: typeof Filesystem.getUsedSpace;
    static write: typeof Filesystem.write;
    static writeX: typeof Filesystem.writeX;
    static writeXs: typeof Filesystem.writeXs;
    static getOsRelease: typeof Filesystem.getOsRelease;
    static snapshotPrefix: typeof Snapshot.snapshotPrefix;
    static getSnapshotCount: typeof Snapshot.getSnapshotCount;
    static getSnapshotSize: typeof Snapshot.getSnapshotSize;
    static getPrefix: typeof Snapshot.getPrefix;
    static getVolid: typeof Snapshot.getVolid;
    static getPostfix: typeof Snapshot.getPostfix;
    static isi686: typeof Architecture.isi686;
    static uefiArch: typeof Architecture.uefiArch;
    static uefiFormat: typeof Architecture.uefiFormat;
    static usrLibPath: typeof Architecture.usrLibPath;
    static kernelVersion: typeof Architecture.kernelVersion;
    static customConfirm: typeof UserInteraction.customConfirm;
    static customConfirmCompanion: typeof UserInteraction.customConfirmCompanion;
    static customConfirmAbort: typeof UserInteraction.customConfirmAbort;
    static pressKeyToExit: typeof UserInteraction.pressKeyToExit;
    static useRoot: typeof UserInteraction.useRoot;
    static setEcho: typeof UserInteraction.setEcho;
    static warning: typeof ConsoleOutput.warning;
    static error: typeof ConsoleOutput.error;
    static titles: typeof ConsoleOutput.titles;
    static flag: typeof ConsoleOutput.flag;
    static sortObjectKeys: typeof Formatters.sortObjectKeys;
    static formatDate: typeof Formatters.formatDate;
    static formatBytes: typeof Formatters.formatBytes;
    /**
     * @deprecated Use Kernel.vmlinuz() instead
     */
    static vmlinuz(kernel?: string): string;
    /**
     * @deprecated Use Kernel.initramfs() instead
     */
    static initrdImg(kernel?: string): string;
}
export { System, PackageInfo, Network, Filesystem, Snapshot, Architecture, UserInteraction, ConsoleOutput, Formatters, Kernel };
