/**
 * ./src/classes/utils.d/filesystem.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * Filesystem operations utilities - files, UUID, disk space
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import IOsRelease from '../../interfaces/i-os-release.js';
export default class Filesystem {
    /**
     *
     * @param file
     * @param search
     * @returns value
     */
    static searchOnFile(file?: string, search?: string): string;
    /**
     * restituisce uuid
     * @param device
     */
    static uuid(device: string): string;
    /**
     *
     * @param device
     * @returns
     */
    static uuidGen(): string;
    /**
     * Calculate the space used on the disk
     * @return {void}
     */
    static getUsedSpace(): number;
    /**
     * write a file
     * @param file
     * @param text
     */
    static write(file: string, text: string): void;
    /**
     *
     * @param file
     * @param cmd
     */
    static writeX(file: string, cmd: string): void;
    /**
     *
     * @param file
     * @param cmd
     */
    static writeXs(file: string, cmds: string[]): void;
    static getOsRelease(): IOsRelease;
}
