/**
 * ./src/classes/utils.d/network.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * Network configuration utilities - IP, DNS, gateway detection
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
export default class Network {
    /**
     * return the name of network device
     */
    static iface(): Promise<string>;
    /**
     * address
     */
    static address(): string;
    /**
     * netmask
     */
    static netmask(): string;
    /**
     * cidr
     */
    static cidr(): string;
    /**
     *
     * broadcast
    */
    static broadcast(): string;
    /**
     * dns
     */
    static getDns(): string[];
    /**
     * getDomain
     */
    static getDomain(): string;
    /**
     * @returns gateway
     */
    static gateway(): string;
}
