/**
 * ./src/components/summary.tsx
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import React from 'react';
import Title from './title.js';
import Steps from './steps.js';
import yaml from 'js-yaml';
import fs from 'fs';
import { Text, Box } from 'ink';
export default function Summary({ username = '', password = '', rootPassword = '', hostname = '', region = '', zone = '', language = '', keyboardModel = '', keyboardLayout = '', installationDevice = '', filesystemType, message = '', erase = '' }) {
    let productName = 'unknown';
    let version = 'x.x.x';
    let configRoot = '/etc/penguins-eggs.d/krill/';
    if (fs.existsSync('/etc/calamares/settings.conf')) {
        configRoot = '/etc/calamares/';
    }
    const settings = yaml.load(fs.readFileSync(configRoot + 'settings.conf', 'utf-8'));
    const branding = settings.branding;
    const calamares = yaml.load(fs.readFileSync(configRoot + 'branding/' + branding + '/branding.desc', 'utf-8'));
    productName = calamares.strings.productName;
    version = calamares.strings.version;
    /**
    * totale width=75
    * step width=15
    * finestra with=59
    */
    return (React.createElement(React.Fragment, null,
        React.createElement(Title, null),
        React.createElement(Box, { width: 75, height: 11, borderStyle: "round", flexDirection: "column" },
            React.createElement(Box, { flexDirection: "column" },
                React.createElement(Box, { flexDirection: "row" },
                    React.createElement(Steps, { step: 7 }),
                    React.createElement(Box, { flexDirection: "column" },
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Installing "),
                            React.createElement(Text, { color: "green" }, productName)),
                        React.createElement(Box, null,
                            React.createElement(Text, null),
                            React.createElement(Text, { color: "green" }, username),
                            React.createElement(Text, null, "/"),
                            React.createElement(Text, { color: "green" },
                                password,
                                " "),
                            React.createElement(Text, null, "pwd root "),
                            React.createElement(Text, { color: "green" },
                                rootPassword,
                                " "),
                            React.createElement(Text, null, "hostname "),
                            React.createElement(Text, { color: "green" }, hostname)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Set timezone to "),
                            React.createElement(Text, { color: "green" },
                                region,
                                "/",
                                zone)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "The system language will be set to "),
                            React.createElement(Text, { color: "green" }, language)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Numbers and date locale will be set to "),
                            React.createElement(Text, { color: "green" }, language)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Set keyboard model to "),
                            React.createElement(Text, { color: "green" },
                                keyboardModel,
                                " "),
                            React.createElement(Text, null, "layout "),
                            React.createElement(Text, { color: "green" }, keyboardLayout)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, erase)),
                        React.createElement(Box, null,
                            React.createElement(Text, { color: "white", backgroundColor: "red" }, message))))))));
}
