/**
 * ./src/lib/select_user_swap_choice.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import inquirer from 'inquirer';
import yaml from 'js-yaml';
import fs from 'node:fs';
import { SwapChoice } from '../classes/krill_enums.js';
export default async function selectUserSwapChoice(initialSwapChoice = SwapChoice.Small) {
    let partitions = {};
    if (fs.existsSync('/etc/calamares/modules/partition.conf')) {
        partitions = yaml.load(fs.readFileSync('/etc/calamares/modules/partition.conf', 'utf8'));
    }
    else {
        partitions.userSwapChoices = Object.values(SwapChoice);
        partitions.initialSwapChoice = initialSwapChoice;
    }
    const questions = [
        {
            choices: partitions.userSwapChoices,
            default: partitions.initialSwapChoice,
            message: 'Select the swap choice',
            name: 'userSwapChoices',
            type: 'list'
        }
    ];
    return new Promise((resolve) => {
        inquirer.prompt(questions).then((options) => {
            resolve(options.userSwapChoices);
        });
    });
}
