import { isArray } from '../predicate/isArray.mjs';
import { isArrayLike } from '../predicate/isArrayLike.mjs';
import { iteratee } from '../util/iteratee.mjs';

function filter(source, predicate) {
    if (!source) {
        return [];
    }
    const collection = isArray(source) ? source : Object.values(source);
    predicate = iteratee(predicate);
    if (!Array.isArray(source)) {
        const result = [];
        const keys = Object.keys(source);
        const length = isArrayLike(source) ? source.length : keys.length;
        for (let i = 0; i < length; i++) {
            const key = keys[i];
            const value = source[key];
            if (predicate(value, key, source)) {
                result.push(value);
            }
        }
        return result;
    }
    return collection.filter(predicate);
}

export { filter };
