'use strict'
Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' })
const isNewlinesBetweenOption = require('./is-newlines-between-option.js')
const getGroupNumber = require('./get-group-number.js')
let getNewlinesBetweenOption = ({ nextSortingNode, sortingNode, options }) => {
  let nodeGroupNumber = getGroupNumber.getGroupNumber(
    options.groups,
    sortingNode,
  )
  let nextNodeGroupNumber = getGroupNumber.getGroupNumber(
    options.groups,
    nextSortingNode,
  )
  let globalNewlinesBetweenOption = getGlobalNewlinesBetweenOption({
    newlinesBetween: options.newlinesBetween,
    nextNodeGroupNumber,
    nodeGroupNumber,
  })
  let nodeGroup = options.groups[nodeGroupNumber]
  let nextNodeGroup = options.groups[nextNodeGroupNumber]
  if (
    Array.isArray(options.customGroups) &&
    typeof nodeGroup === 'string' &&
    typeof nextNodeGroup === 'string' &&
    nodeGroup === nextNodeGroup
  ) {
    let nodeCustomGroup = options.customGroups.find(
      customGroup => customGroup.groupName === nodeGroup,
    )
    let nextNodeCustomGroup = options.customGroups.find(
      customGroup => customGroup.groupName === nextNodeGroup,
    )
    if (
      nodeCustomGroup &&
      nextNodeCustomGroup &&
      nodeCustomGroup.groupName === nextNodeCustomGroup.groupName
    ) {
      return nodeCustomGroup.newlinesInside ?? globalNewlinesBetweenOption
    }
  }
  if (nextNodeGroupNumber >= nodeGroupNumber + 2) {
    if (nextNodeGroupNumber === nodeGroupNumber + 2) {
      let groupBetween = options.groups[nodeGroupNumber + 1]
      if (isNewlinesBetweenOption.isNewlinesBetweenOption(groupBetween)) {
        return groupBetween.newlinesBetween
      }
    } else {
      let relevantGroups = options.groups.slice(
        nodeGroupNumber,
        nextNodeGroupNumber + 1,
      )
      let groupsWithAllNewlinesBetween = buildGroupsWithAllNewlinesBetween(
        relevantGroups,
        globalNewlinesBetweenOption,
      )
      let newlinesBetweenOptions = new Set(
        groupsWithAllNewlinesBetween
          .filter(isNewlinesBetweenOption.isNewlinesBetweenOption)
          .map(group => group.newlinesBetween),
      )
      if (newlinesBetweenOptions.has('always')) {
        return 'always'
      }
      if (newlinesBetweenOptions.has('ignore')) {
        return 'ignore'
      }
      if (newlinesBetweenOptions.has('never')) {
        return 'never'
      }
    }
  }
  return globalNewlinesBetweenOption
}
let getGlobalNewlinesBetweenOption = ({
  nextNodeGroupNumber,
  newlinesBetween,
  nodeGroupNumber,
}) => {
  if (newlinesBetween === 'ignore') {
    return 'ignore'
  }
  if (newlinesBetween === 'never') {
    return 'never'
  }
  return nodeGroupNumber === nextNodeGroupNumber ? 'never' : 'always'
}
let buildGroupsWithAllNewlinesBetween = (
  groups,
  globalNewlinesBetweenOption,
) => {
  let returnValue = []
  for (let i = 0; i < groups.length; i++) {
    let group = groups[i]
    if (!isNewlinesBetweenOption.isNewlinesBetweenOption(group)) {
      let previousGroup = groups[i - 1]
      if (
        previousGroup &&
        !isNewlinesBetweenOption.isNewlinesBetweenOption(previousGroup)
      ) {
        returnValue.push({ newlinesBetween: globalNewlinesBetweenOption })
      }
    }
    returnValue.push(group)
  }
  return returnValue
}
exports.getNewlinesBetweenOption = getNewlinesBetweenOption
