'use strict'
Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' })
const computeNodesInCircularDependencies = require('./compute-nodes-in-circular-dependencies.js')
const isNodeDependentOnOtherNode = require('./is-node-dependent-on-other-node.js')
const createNodeIndexMap = require('./create-node-index-map.js')
const getNewlinesErrors = require('./get-newlines-errors.js')
const getGroupNumber = require('./get-group-number.js')
const reportErrors = require('./report-errors.js')
const pairwise = require('./pairwise.js')
let reportAllErrors = ({
  ignoreFirstNodeHighestBlockComment,
  sortNodesExcludingEslintDisabled,
  newlinesBetweenValueGetter,
  availableMessageIds,
  sourceCode,
  context,
  options,
  nodes,
}) => {
  let sortedNodes = sortNodesExcludingEslintDisabled(false)
  let sortedNodesExcludingEslintDisabled =
    sortNodesExcludingEslintDisabled(true)
  let nodeIndexMap = createNodeIndexMap.createNodeIndexMap(sortedNodes)
  let nodesInCircularDependencies =
    availableMessageIds.unexpectedDependencyOrder
      ? computeNodesInCircularDependencies.computeNodesInCircularDependencies(
          nodes,
        )
      : /* @__PURE__ */ new Set()
  pairwise.pairwise(nodes, (left, right) => {
    let leftNumber = getGroupNumber.getGroupNumber(options.groups, left)
    let rightNumber = getGroupNumber.getGroupNumber(options.groups, right)
    let leftIndex = nodeIndexMap.get(left)
    let rightIndex = nodeIndexMap.get(right)
    let indexOfRightExcludingEslintDisabled =
      sortedNodesExcludingEslintDisabled.indexOf(right)
    let messageIds = []
    let firstUnorderedNodeDependentOnRight
    if (availableMessageIds.unexpectedDependencyOrder) {
      firstUnorderedNodeDependentOnRight = getFirstUnorderedNodeDependentOn({
        nodes,
        node: right,
        nodesInCircularDependencies,
      })
    }
    if (
      firstUnorderedNodeDependentOnRight ||
      leftIndex > rightIndex ||
      (left.isEslintDisabled &&
        leftIndex >= indexOfRightExcludingEslintDisabled)
    ) {
      if (firstUnorderedNodeDependentOnRight) {
        messageIds.push(availableMessageIds.unexpectedDependencyOrder)
      } else {
        messageIds.push(
          leftNumber === rightNumber ||
            !availableMessageIds.unexpectedGroupOrder
            ? availableMessageIds.unexpectedOrder
            : availableMessageIds.unexpectedGroupOrder,
        )
      }
    }
    if (
      options.newlinesBetween &&
      availableMessageIds.missedSpacingBetweenMembers &&
      availableMessageIds.extraSpacingBetweenMembers
    ) {
      messageIds = [
        ...messageIds,
        ...getNewlinesErrors.getNewlinesErrors({
          options: {
            ...options,
            newlinesBetween: options.newlinesBetween,
          },
          missedSpacingError: availableMessageIds.missedSpacingBetweenMembers,
          extraSpacingError: availableMessageIds.extraSpacingBetweenMembers,
          newlinesBetweenValueGetter,
          rightNum: rightNumber,
          leftNum: leftNumber,
          sourceCode,
          right,
          left,
        }),
      ]
    }
    reportErrors.reportErrors({
      sortedNodes: sortedNodesExcludingEslintDisabled,
      ignoreFirstNodeHighestBlockComment,
      firstUnorderedNodeDependentOnRight,
      newlinesBetweenValueGetter,
      messageIds,
      sourceCode,
      options,
      context,
      nodes,
      right,
      left,
    })
  })
}
let getFirstUnorderedNodeDependentOn = ({
  nodesInCircularDependencies,
  nodes,
  node,
}) => {
  let nodesDependentOnNode = nodes.filter(
    currentlyOrderedNode =>
      !nodesInCircularDependencies.has(currentlyOrderedNode) &&
      isNodeDependentOnOtherNode.isNodeDependentOnOtherNode(
        node,
        currentlyOrderedNode,
      ),
  )
  return nodesDependentOnNode.find(firstNodeDependentOnNode => {
    let currentIndexOfNode = nodes.indexOf(node)
    let currentIndexOfFirstNodeDependentOnNode = nodes.indexOf(
      firstNodeDependentOnNode,
    )
    return currentIndexOfFirstNodeDependentOnNode < currentIndexOfNode
  })
}
exports.reportAllErrors = reportAllErrors
