"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const chalk_1 = __importDefault(require("chalk"));
const fs = __importStar(require("fs-extra"));
const promises_1 = require("node:fs/promises");
const node_path_1 = require("node:path");
const generator_1 = require("../../generator");
const util_1 = require("../../util");
class GenerateHook extends generator_1.GeneratorCommand {
    static args = {
        name: core_1.Args.string({ description: 'Name of hook (snake_case).', required: true }),
    };
    static description = 'Add a hook to an existing CLI or plugin.';
    static flags = {
        event: core_1.Flags.string({
            default: 'init',
            description: 'Event to run hook on.',
        }),
        force: core_1.Flags.boolean({
            description: 'Overwrite existing files.',
        }),
    };
    async run() {
        const packageJSON = await (0, generator_1.readPJSON)(process.cwd());
        if (!packageJSON)
            throw new core_1.Errors.CLIError('not in a project directory');
        this.log(`Adding a ${chalk_1.default.dim(this.flags.event)} hook to ${packageJSON.name}!`);
        const source = (0, node_path_1.join)(this.templatesDir, 'src', 'hook.ts.ejs');
        const dest = (0, node_path_1.join)(process.cwd(), 'src', 'hooks', this.flags.event, `${this.args.name}.ts`);
        await this.template(source, dest, { event: this.flags.event });
        if (packageJSON.devDependencies?.mocha) {
            const testSource = (0, node_path_1.join)(this.templatesDir, 'test', 'hook.test.ts.ejs');
            const testDest = (0, node_path_1.join)(process.cwd(), 'test', 'hooks', this.flags.event, `${this.args.name}.test.ts`);
            await this.template(testSource, testDest);
        }
        const tsConfigPath = (0, node_path_1.resolve)(process.cwd(), 'tsconfig.json');
        const tsConfig = await fs.readJSON(tsConfigPath).catch(() => ({}));
        const outDir = tsConfig.compilerOptions?.outDir ?? 'dist';
        const hooks = packageJSON.oclif?.hooks ?? {};
        hooks[this.flags.event] = hooks[this.flags.event]
            ? (0, util_1.uniq)([...(0, util_1.castArray)(hooks[this.flags.event]), `./${outDir}/hooks/${this.flags.event}/${this.args.name}`]).sort()
            : `./${outDir}/hooks/${this.flags.event}/${this.args.name}`;
        const updatedPackageJSON = {
            ...packageJSON,
            oclif: {
                ...packageJSON.oclif,
                hooks,
            },
        };
        await (0, promises_1.writeFile)((0, node_path_1.resolve)(process.cwd(), 'package.json'), JSON.stringify(updatedPackageJSON, null, 2));
    }
}
exports.default = GenerateHook;
