"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const Tarballs = __importStar(require("../../tarballs"));
class PackTarballs extends core_1.Command {
    static description = `This can be used to create oclif CLIs that use the system node or that come preloaded with a node binary.

Add a pretarball script to your package.json if you need to run any scripts before the tarball is created.`;
    static flags = {
        parallel: core_1.Flags.boolean({ description: 'Build tarballs in parallel.' }),
        'prune-lockfiles': core_1.Flags.boolean({ description: 'remove lockfiles in the tarball.' }),
        root: core_1.Flags.string({ char: 'r', default: '.', description: 'Path to oclif CLI root.', required: true }),
        tarball: core_1.Flags.string({
            char: 'l',
            description: 'Optionally specify a path to a tarball already generated by NPM.',
            required: false,
        }),
        targets: core_1.Flags.string({ char: 't', description: 'Comma-separated targets to pack (e.g.: linux-arm,win32-x64).' }),
        xz: core_1.Flags.boolean({ allowNo: true, description: 'Also build xz.' }),
    };
    static summary = 'Package oclif CLI into tarballs.';
    async run() {
        const { flags } = await this.parse(PackTarballs);
        const buildConfig = await Tarballs.buildConfig(flags.root, { targets: flags?.targets?.split(','), xz: flags.xz });
        if (buildConfig.targets.length === 0) {
            throw new Error('Please specify one or more valid targets.');
        }
        await Tarballs.build(buildConfig, {
            parallel: flags.parallel,
            ...(process.platform === 'win32' ? { platform: 'win32' } : {}),
            pruneLockfiles: flags['prune-lockfiles'],
            tarball: flags.tarball,
        });
    }
}
exports.default = PackTarballs;
