# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_alpm_pkginfo_global_optspecs
	string join \n h/help V/version
end

function __fish_alpm_pkginfo_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_alpm_pkginfo_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_alpm_pkginfo_using_subcommand
	set -l cmd (__fish_alpm_pkginfo_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_needs_command" -s h -l help -d 'Print help'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_needs_command" -s V -l version -d 'Print version'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_needs_command" -f -a "create" -d 'Create a PKGINFO file according to a schema'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_needs_command" -f -a "validate" -d 'Validate a PKGINFO file'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_needs_command" -f -a "format" -d 'Parse a PKGINFO file and output it in a different file format'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -f -a "v1" -d 'Create a PKGINFO version 1 file'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -f -a "v2" -d 'Create a PKGINFO version 2 file'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and not __fish_seen_subcommand_from v1 v2 help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l pkgname -d 'The pkgname to use in the PKGINFO' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l pkgbase -d 'The pkgbase to use in the PKGINFO' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l pkgver -d 'The pkgver to use in the PKGINFO' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l pkgdesc -d 'The package description to use in the PKGINFO' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l url -d 'Provide a url' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l builddate -d 'Provide a builddate' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l packager -d 'Provide a packager' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l size -d 'Provide a size' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l arch -d 'Provide a architecture' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l license -d 'Provide one or more licenses' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l replaces -d 'Provide one or more replaces' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l group -d 'Provide one or more groups' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l conflict -d 'Provide one or more conflicts' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l provides -d 'Provide one or more provides' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l backup -d 'Provide one or more backups' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l depend -d 'Provide one or more depends' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l optdepend -d 'Provide one or more optdepend' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l makedepend -d 'Provide one or more makedepend' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -l checkdepend -d 'Provide one or more checkdepend' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v1" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l pkgname -d 'The pkgname to use in the PKGINFO' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l pkgbase -d 'The pkgbase to use in the PKGINFO' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l pkgver -d 'The pkgver to use in the PKGINFO' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l pkgdesc -d 'The package description to use in the PKGINFO' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l url -d 'Provide a url' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l builddate -d 'Provide a builddate' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l packager -d 'Provide a packager' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l size -d 'Provide a size' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l arch -d 'Provide a architecture' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l license -d 'Provide one or more licenses' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l replaces -d 'Provide one or more replaces' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l group -d 'Provide one or more groups' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l conflict -d 'Provide one or more conflicts' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l provides -d 'Provide one or more provides' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l backup -d 'Provide one or more backups' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l depend -d 'Provide one or more depends' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l optdepend -d 'Provide one or more optdepend' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l makedepend -d 'Provide one or more makedepend' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l checkdepend -d 'Provide one or more checkdepend' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -l xdata -d 'Provide one or more Xdata' -r
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from v2" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from help" -f -a "v1" -d 'Create a PKGINFO version 1 file'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from help" -f -a "v2" -d 'Create a PKGINFO version 2 file'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand create; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand validate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand format" -s o -l output-format -d 'The output format to use' -r -f -a "json\t''"
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand format" -s p -l pretty -d 'Pretty-print the output'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand format" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "create" -d 'Create a PKGINFO file according to a schema'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "validate" -d 'Validate a PKGINFO file'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "format" -d 'Parse a PKGINFO file and output it in a different file format'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand help; and not __fish_seen_subcommand_from create validate format help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand help; and __fish_seen_subcommand_from create" -f -a "v1" -d 'Create a PKGINFO version 1 file'
complete -c alpm-pkginfo -n "__fish_alpm_pkginfo_using_subcommand help; and __fish_seen_subcommand_from create" -f -a "v2" -d 'Create a PKGINFO version 2 file'
