// Copyright 2021-2024 The Khronos Group
// SPDX-License-Identifier: Apache-2.0

// This file was generated by generate_extension_utility.py
// Don't make changes to this directly

#pragma once
#include <anari/anari.h>
typedef struct {
   int ANARI_KHR_LIGHT_DIRECTIONAL;
   int ANARI_KHR_LIGHT_POINT;
   int ANARI_KHR_LIGHT_RING;
   int ANARI_KHR_LIGHT_QUAD;
   int ANARI_KHR_LIGHT_HDRI;
   int ANARI_KHR_CAMERA_SHUTTER;
   int ANARI_KHR_INSTANCE_MOTION_SCALE_ROTATION_TRANSLATION;
   int ANARI_KHR_INSTANCE_MOTION_TRANSFORM;
   int ANARI_KHR_INSTANCE_TRANSFORM;
   int ANARI_KHR_VOLUME_TRANSFER_FUNCTION1D;
   int ANARI_KHR_AREA_LIGHTS;
   int ANARI_KHR_ARRAY1D_REGION;
   int ANARI_KHR_CAMERA_DEPTH_OF_FIELD;
   int ANARI_KHR_CAMERA_MOTION_TRANSFORMATION;
   int ANARI_KHR_CAMERA_OMNIDIRECTIONAL;
   int ANARI_KHR_CAMERA_ORTHOGRAPHIC;
   int ANARI_KHR_CAMERA_PERSPECTIVE;
   int ANARI_KHR_CAMERA_STEREO;
   int ANARI_KHR_DEVICE_SYNCHRONIZATION;
   int ANARI_KHR_FRAME_ACCUMULATION;
   int ANARI_KHR_FRAME_CHANNEL_ALBEDO;
   int ANARI_KHR_FRAME_CHANNEL_INSTANCE_ID;
   int ANARI_KHR_FRAME_CHANNEL_NORMAL;
   int ANARI_KHR_FRAME_CHANNEL_OBJECT_ID;
   int ANARI_KHR_FRAME_CHANNEL_PRIMITIVE_ID;
   int ANARI_KHR_FRAME_COMPLETION_CALLBACK;
   int ANARI_KHR_GEOMETRY_CONE;
   int ANARI_KHR_GEOMETRY_CURVE;
   int ANARI_KHR_GEOMETRY_CYLINDER;
   int ANARI_KHR_GEOMETRY_QUAD;
   int ANARI_KHR_GEOMETRY_QUAD_MOTION_DEFORMATION;
   int ANARI_KHR_GEOMETRY_SPHERE;
   int ANARI_KHR_GEOMETRY_TRIANGLE;
   int ANARI_KHR_GEOMETRY_TRIANGLE_MOTION_DEFORMATION;
   int ANARI_KHR_LIGHT_SPOT;
   int ANARI_KHR_MATERIAL_MATTE;
   int ANARI_KHR_MATERIAL_PHYSICALLY_BASED;
   int ANARI_KHR_RENDERER_AMBIENT_LIGHT;
   int ANARI_KHR_RENDERER_BACKGROUND_COLOR;
   int ANARI_KHR_RENDERER_BACKGROUND_IMAGE;
   int ANARI_KHR_SAMPLER_IMAGE1D;
   int ANARI_KHR_SAMPLER_IMAGE2D;
   int ANARI_KHR_SAMPLER_IMAGE3D;
   int ANARI_KHR_SAMPLER_PRIMITIVE;
   int ANARI_KHR_SAMPLER_TRANSFORM;
   int ANARI_KHR_SPATIAL_FIELD_STRUCTURED_REGULAR;
   int ANARI_EXP_VOLUME_SAMPLE_RATE;
} ANARIExtensions;
int anariGetDeviceExtensionStruct(ANARIExtensions *extensions, ANARILibrary library, const char *deviceName);
int anariGetObjectExtensionStruct(ANARIExtensions *extensions, ANARIDevice device, ANARIDataType objectType, const char *objectName);
int anariGetInstanceExtensionStruct(ANARIExtensions *extensions, ANARIDevice device, ANARIObject object);
#ifdef ANARI_EXTENSION_UTILITY_IMPL
#include <string.h>
static int extension_hash(const char *str) {
   static const uint32_t table[] = {0x4f4e0001u,0x42410002u,0x53520003u,0x4a490004u,0x605f0005u,0x4c450006u,0x5958000du,0x0u,0x0u,0x0u,0x0u,0x0u,0x49480023u,0x5150000eu,0x605f000fu,0x57560010u,0x504f0011u,0x4d4c0012u,0x56550013u,0x4e4d0014u,0x46450015u,0x605f0016u,0x54530017u,0x42410018u,0x4e4d0019u,0x5150001au,0x4d4c001bu,0x4645001cu,0x605f001du,0x5352001eu,0x4241001fu,0x55540020u,0x46450021u,0x1000022u,0x8000002eu,0x53520024u,0x605f0025u,0x57410026u,0x5352003cu,0x0u,0x42410060u,0x464500dbu,0x0u,0x535200f1u,0x46450161u,0x0u,0x4f4e028au,0x0u,0x0u,0x4a4902ceu,0x42410303u,0x0u,0x0u,0x0u,0x0u,0x46450324u,0x51410356u,0x0u,0x0u,0x504f03b6u,0x5345003du,0x4241004bu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x42410054u,0x605f004cu,0x4d4c004du,0x4a49004eu,0x4847004fu,0x49480050u,0x55540051u,0x54530052u,0x1000053u,0x8000000au,0x5a590055u,0x32310056u,0x45440057u,0x605f0058u,0x53520059u,0x4645005au,0x4847005bu,0x4a49005cu,0x504f005du,0x4f4e005eu,0x100005fu,0x8000000bu,0x4e4d0061u,0x46450062u,0x53520063u,0x42410064u,0x605f0065u,0x54440066u,0x46450076u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x504f0084u,0x0u,0x534d0099u,0x464500b8u,0x0u,0x0u,0x554800c3u,0x51500077u,0x55540078u,0x49480079u,0x605f007au,0x504f007bu,0x4746007cu,0x605f007du,0x4746007eu,0x4a49007fu,0x46450080u,0x4d4c0081u,0x45440082u,0x1000083u,0x8000000cu,0x55540085u,0x4a490086u,0x504f0087u,0x4f4e0088u,0x605f0089u,0x5554008au,0x5352008bu,0x4241008cu,0x4f4e008du,0x5453008eu,0x4746008fu,0x504f0090u,0x53520091u,0x4e4d0092u,0x42410093u,0x55540094u,0x4a490095u,0x504f0096u,0x4f4e0097u,0x1000098u,0x8000000du,0x4f4e009fu,0x0u,0x0u,0x0u,0x0u,0x555400adu,0x4a4900a0u,0x454400a1u,0x4a4900a2u,0x535200a3u,0x464500a4u,0x444300a5u,0x555400a6u,0x4a4900a7u,0x504f00a8u,0x4f4e00a9u,0x424100aau,0x4d4c00abu,0x10000acu,0x8000000eu,0x494800aeu,0x504f00afu,0x484700b0u,0x535200b1u,0x424100b2u,0x515000b3u,0x494800b4u,0x4a4900b5u,0x444300b6u,0x10000b7u,0x8000000fu,0x535200b9u,0x545300bau,0x515000bbu,0x464500bcu,0x444300bdu,0x555400beu,0x4a4900bfu,0x575600c0u,0x464500c1u,0x10000c2u,0x80000010u,0x565500d0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x464500d6u,0x555400d1u,0x555400d2u,0x464500d3u,0x535200d4u,0x10000d5u,0x80000005u,0x535200d7u,0x464500d8u,0x504f00d9u,0x10000dau,0x80000011u,0x575600dcu,0x4a4900ddu,0x444300deu,0x464500dfu,0x605f00e0u,0x545300e1u,0x5a5900e2u,0x4f4e00e3u,0x444300e4u,0x494800e5u,0x535200e6u,0x504f00e7u,0x4f4e00e8u,0x4a4900e9u,0x5b5a00eau,0x424100ebu,0x555400ecu,0x4a4900edu,0x504f00eeu,0x4f4e00efu,0x10000f0u,0x80000012u,0x424100f2u,0x4e4d00f3u,0x464500f4u,0x605f00f5u,0x444100f6u,0x444300f9u,0x0u,0x50480105u,0x444300fau,0x565500fbu,0x4e4d00fcu,0x565500fdu,0x4d4c00feu,0x424100ffu,0x55540100u,0x4a490101u,0x504f0102u,0x4f4e0103u,0x1000104u,0x80000013u,0x4241010du,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x4e4d014fu,0x4f4e010eu,0x4f4e010fu,0x46450110u,0x4d4c0111u,0x605f0112u,0x51410113u,0x4d4c0123u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x4f4e0129u,0x0u,0x0u,0x0u,0x0u,0x504f0134u,0x4342013au,0x53520143u,0x43420124u,0x46450125u,0x45440126u,0x504f0127u,0x1000128u,0x80000014u,0x5453012au,0x5554012bu,0x4241012cu,0x4f4e012du,0x4443012eu,0x4645012fu,0x605f0130u,0x4a490131u,0x45440132u,0x1000133u,0x80000015u,0x53520135u,0x4e4d0136u,0x42410137u,0x4d4c0138u,0x1000139u,0x80000016u,0x4b4a013bu,0x4645013cu,0x4443013du,0x5554013eu,0x605f013fu,0x4a490140u,0x45440141u,0x1000142u,0x80000017u,0x4a490144u,0x4e4d0145u,0x4a490146u,0x55540147u,0x4a490148u,0x57560149u,0x4645014au,0x605f014bu,0x4a49014cu,0x4544014du,0x100014eu,0x80000018u,0x51500150u,0x4d4c0151u,0x46450152u,0x55540153u,0x4a490154u,0x504f0155u,0x4f4e0156u,0x605f0157u,0x44430158u,0x42410159u,0x4d4c015au,0x4d4c015bu,0x4342015cu,0x4241015du,0x4443015eu,0x4c4b015fu,0x1000160u,0x80000019u,0x504f0162u,0x4e4d0163u,0x46450164u,0x55540165u,0x53520166u,0x5a590167u,0x605f0168u,0x55430169u,0x5a4f017bu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x56550194u,0x0u,0x5150020au,0x53520210u,0x4f4e0186u,0x0u,0x0u,0x0u,0x0u,0x0u,0x53520189u,0x0u,0x0u,0x0u,0x4d4c018du,0x46450187u,0x1000188u,0x8000001au,0x5756018au,0x4645018bu,0x100018cu,0x8000001bu,0x4a49018eu,0x4f4e018fu,0x45440190u,0x46450191u,0x53520192u,0x1000193u,0x8000001cu,0x42410195u,0x45440196u,0x60000197u,0x8000001du,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x4e4d01f7u,0x504f01f8u,0x555401f9u,0x4a4901fau,0x504f01fbu,0x4f4e01fcu,0x605f01fdu,0x454401feu,0x464501ffu,0x47460200u,0x504f0201u,0x53520202u,0x4e4d0203u,0x42410204u,0x55540205u,0x4a490206u,0x504f0207u,0x4f4e0208u,0x1000209u,0x8000001eu,0x4948020bu,0x4645020cu,0x5352020du,0x4645020eu,0x100020fu,0x8000001fu,0x4a490211u,0x42410212u,0x4f4e0213u,0x48470214u,0x4d4c0215u,0x46450216u,0x60000217u,0x80000020u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x4e4d0277u,0x504f0278u,0x55540279u,0x4a49027au,0x504f027bu,0x4f4e027cu,0x605f027du,0x4544027eu,0x4645027fu,0x47460280u,0x504f0281u,0x53520282u,0x4e4d0283u,0x42410284u,0x55540285u,0x4a490286u,0x504f0287u,0x4f4e0288u,0x1000289u,0x80000021u,0x5453028bu,0x5554028cu,0x4241028du,0x4f4e028eu,0x4443028fu,0x46450290u,0x605f0291u,0x554d0292u,0x504f029au,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x535202c5u,0x5554029bu,0x4a49029cu,0x504f029du,0x4f4e029eu,0x605f029fu,0x555302a0u,0x444302a2u,0x535202bcu,0x424102a3u,0x4d4c02a4u,0x464502a5u,0x605f02a6u,0x535202a7u,0x504f02a8u,0x555402a9u,0x424102aau,0x555402abu,0x4a4902acu,0x504f02adu,0x4f4e02aeu,0x605f02afu,0x555402b0u,0x535202b1u,0x424102b2u,0x4f4e02b3u,0x545302b4u,0x4d4c02b5u,0x424102b6u,0x555402b7u,0x4a4902b8u,0x504f02b9u,0x4f4e02bau,0x10002bbu,0x80000006u,0x424102bdu,0x4f4e02beu,0x545302bfu,0x474602c0u,0x504f02c1u,0x535202c2u,0x4e4d02c3u,0x10002c4u,0x80000007u,0x424102c6u,0x4f4e02c7u,0x545302c8u,0x474602c9u,0x504f02cau,0x535202cbu,0x4e4d02ccu,0x10002cdu,0x80000008u,0x484702cfu,0x494802d0u,0x555402d1u,0x605f02d2u,0x544402d3u,0x4a4902e3u,0x0u,0x0u,0x0u,0x454402eeu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x504f02f2u,0x565502f7u,0x4a4902fbu,0x515002ffu,0x535202e4u,0x464502e5u,0x444302e6u,0x555402e7u,0x4a4902e8u,0x504f02e9u,0x4f4e02eau,0x424102ebu,0x4d4c02ecu,0x10002edu,0x80000000u,0x535202efu,0x4a4902f0u,0x10002f1u,0x80000004u,0x4a4902f3u,0x4f4e02f4u,0x555402f5u,0x10002f6u,0x80000001u,0x424102f8u,0x454402f9u,0x10002fau,0x80000003u,0x4f4e02fcu,0x484702fdu,0x10002feu,0x80000002u,0x504f0300u,0x55540301u,0x1000302u,0x80000022u,0x55540304u,0x46450305u,0x53520306u,0x4a490307u,0x42410308u,0x4d4c0309u,0x605f030au,0x514d030bu,0x4241030fu,0x0u,0x0u,0x49480314u,0x55540310u,0x55540311u,0x46450312u,0x1000313u,0x80000023u,0x5a590315u,0x54530316u,0x4a490317u,0x44430318u,0x42410319u,0x4d4c031au,0x4d4c031bu,0x5a59031cu,0x605f031du,0x4342031eu,0x4241031fu,0x54530320u,0x46450321u,0x45440322u,0x1000323u,0x80000024u,0x4f4e0325u,0x45440326u,0x46450327u,0x53520328u,0x46450329u,0x5352032au,0x605f032bu,0x4341032cu,0x4e4d032eu,0x4241033bu,0x4342032fu,0x4a490330u,0x46450331u,0x4f4e0332u,0x55540333u,0x605f0334u,0x4d4c0335u,0x4a490336u,0x48470337u,0x49480338u,0x55540339u,0x100033au,0x80000025u,0x4443033cu,0x4c4b033du,0x4847033eu,0x5352033fu,0x504f0340u,0x56550341u,0x4f4e0342u,0x45440343u,0x605f0344u,0x4a430345u,0x504f034cu,0x0u,0x0u,0x0u,0x0u,0x0u,0x4e4d0351u,0x4d4c034du,0x504f034eu,0x5352034fu,0x1000350u,0x80000026u,0x42410352u,0x48470353u,0x46450354u,0x1000355u,0x80000027u,0x4e4d0366u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x42410397u,0x51500367u,0x4d4c0368u,0x46450369u,0x5352036au,0x605f036bu,0x5549036cu,0x4e4d0378u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x53520385u,0x0u,0x0u,0x0u,0x5352038eu,0x42410379u,0x4847037au,0x4645037bu,0x3431037cu,0x4544037fu,0x45440381u,0x45440383u,0x1000380u,0x80000028u,0x1000382u,0x80000029u,0x1000384u,0x8000002au,0x4a490386u,0x4e4d0387u,0x4a490388u,0x55540389u,0x4a49038au,0x5756038bu,0x4645038cu,0x100038du,0x8000002bu,0x4241038fu,0x4f4e0390u,0x54530391u,0x47460392u,0x504f0393u,0x53520394u,0x4e4d0395u,0x1000396u,0x8000002cu,0x55540398u,0x4a490399u,0x4241039au,0x4d4c039bu,0x605f039cu,0x4746039du,0x4a49039eu,0x4645039fu,0x4d4c03a0u,0x454403a1u,0x605f03a2u,0x545303a3u,0x555403a4u,0x535203a5u,0x565503a6u,0x444303a7u,0x555403a8u,0x565503a9u,0x535203aau,0x464503abu,0x454403acu,0x605f03adu,0x535203aeu,0x464503afu,0x484703b0u,0x565503b1u,0x4d4c03b2u,0x424103b3u,0x535203b4u,0x10003b5u,0x8000002du,0x4d4c03b7u,0x565503b8u,0x4e4d03b9u,0x464503bau,0x605f03bbu,0x555403bcu,0x535203bdu,0x424103beu,0x4f4e03bfu,0x545303c0u,0x474603c1u,0x464503c2u,0x535203c3u,0x605f03c4u,0x474603c5u,0x565503c6u,0x4f4e03c7u,0x444303c8u,0x555403c9u,0x4a4903cau,0x504f03cbu,0x4f4e03ccu,0x323103cdu,0x454403ceu,0x10003cfu,0x80000009u};
   uint32_t cur = 0x42410000u;
   for(int i = 0;cur!=0;++i) {
      uint32_t idx = cur&0xFFFFu;
      uint32_t low = (cur>>16u)&0xFFu;
      uint32_t high = (cur>>24u)&0xFFu;
      uint32_t c = (uint32_t)str[i];
      if(c>=low && c<high) {
         cur = table[idx+c-low];
      } else {
         break;
      }
      if(cur&0x80000000u) {
         return cur&0xFFFFu;
      }
      if(str[i]==0) {
         break;
      }
   }
   return -1;
}
static void fillExtensionStruct(ANARIExtensions *extensions, const char *const *list) {
    memset(extensions, 0, sizeof(ANARIExtensions));
    for(const char *const *i = list;*i!=NULL;++i) {
        switch(extension_hash(*i)) {
            case 0: extensions->ANARI_KHR_LIGHT_DIRECTIONAL = 1; break;
            case 1: extensions->ANARI_KHR_LIGHT_POINT = 1; break;
            case 2: extensions->ANARI_KHR_LIGHT_RING = 1; break;
            case 3: extensions->ANARI_KHR_LIGHT_QUAD = 1; break;
            case 4: extensions->ANARI_KHR_LIGHT_HDRI = 1; break;
            case 5: extensions->ANARI_KHR_CAMERA_SHUTTER = 1; break;
            case 6: extensions->ANARI_KHR_INSTANCE_MOTION_SCALE_ROTATION_TRANSLATION = 1; break;
            case 7: extensions->ANARI_KHR_INSTANCE_MOTION_TRANSFORM = 1; break;
            case 8: extensions->ANARI_KHR_INSTANCE_TRANSFORM = 1; break;
            case 9: extensions->ANARI_KHR_VOLUME_TRANSFER_FUNCTION1D = 1; break;
            case 10: extensions->ANARI_KHR_AREA_LIGHTS = 1; break;
            case 11: extensions->ANARI_KHR_ARRAY1D_REGION = 1; break;
            case 12: extensions->ANARI_KHR_CAMERA_DEPTH_OF_FIELD = 1; break;
            case 13: extensions->ANARI_KHR_CAMERA_MOTION_TRANSFORMATION = 1; break;
            case 14: extensions->ANARI_KHR_CAMERA_OMNIDIRECTIONAL = 1; break;
            case 15: extensions->ANARI_KHR_CAMERA_ORTHOGRAPHIC = 1; break;
            case 16: extensions->ANARI_KHR_CAMERA_PERSPECTIVE = 1; break;
            case 17: extensions->ANARI_KHR_CAMERA_STEREO = 1; break;
            case 18: extensions->ANARI_KHR_DEVICE_SYNCHRONIZATION = 1; break;
            case 19: extensions->ANARI_KHR_FRAME_ACCUMULATION = 1; break;
            case 20: extensions->ANARI_KHR_FRAME_CHANNEL_ALBEDO = 1; break;
            case 21: extensions->ANARI_KHR_FRAME_CHANNEL_INSTANCE_ID = 1; break;
            case 22: extensions->ANARI_KHR_FRAME_CHANNEL_NORMAL = 1; break;
            case 23: extensions->ANARI_KHR_FRAME_CHANNEL_OBJECT_ID = 1; break;
            case 24: extensions->ANARI_KHR_FRAME_CHANNEL_PRIMITIVE_ID = 1; break;
            case 25: extensions->ANARI_KHR_FRAME_COMPLETION_CALLBACK = 1; break;
            case 26: extensions->ANARI_KHR_GEOMETRY_CONE = 1; break;
            case 27: extensions->ANARI_KHR_GEOMETRY_CURVE = 1; break;
            case 28: extensions->ANARI_KHR_GEOMETRY_CYLINDER = 1; break;
            case 29: extensions->ANARI_KHR_GEOMETRY_QUAD = 1; break;
            case 30: extensions->ANARI_KHR_GEOMETRY_QUAD_MOTION_DEFORMATION = 1; break;
            case 31: extensions->ANARI_KHR_GEOMETRY_SPHERE = 1; break;
            case 32: extensions->ANARI_KHR_GEOMETRY_TRIANGLE = 1; break;
            case 33: extensions->ANARI_KHR_GEOMETRY_TRIANGLE_MOTION_DEFORMATION = 1; break;
            case 34: extensions->ANARI_KHR_LIGHT_SPOT = 1; break;
            case 35: extensions->ANARI_KHR_MATERIAL_MATTE = 1; break;
            case 36: extensions->ANARI_KHR_MATERIAL_PHYSICALLY_BASED = 1; break;
            case 37: extensions->ANARI_KHR_RENDERER_AMBIENT_LIGHT = 1; break;
            case 38: extensions->ANARI_KHR_RENDERER_BACKGROUND_COLOR = 1; break;
            case 39: extensions->ANARI_KHR_RENDERER_BACKGROUND_IMAGE = 1; break;
            case 40: extensions->ANARI_KHR_SAMPLER_IMAGE1D = 1; break;
            case 41: extensions->ANARI_KHR_SAMPLER_IMAGE2D = 1; break;
            case 42: extensions->ANARI_KHR_SAMPLER_IMAGE3D = 1; break;
            case 43: extensions->ANARI_KHR_SAMPLER_PRIMITIVE = 1; break;
            case 44: extensions->ANARI_KHR_SAMPLER_TRANSFORM = 1; break;
            case 45: extensions->ANARI_KHR_SPATIAL_FIELD_STRUCTURED_REGULAR = 1; break;
            case 46: extensions->ANARI_EXP_VOLUME_SAMPLE_RATE = 1; break;
            default: break;
        }
    }
}
int anariGetDeviceExtensionStruct(ANARIExtensions *extensions, ANARILibrary library, const char *deviceName) {
    const char *const *list = (const char *const *)anariGetDeviceExtensions(library, deviceName);
    if(list) {
        fillExtensionStruct(extensions, list);
        return 0;
    } else {
        return 1;
    }
}
int anariGetObjectExtensionStruct(ANARIExtensions *extensions, ANARIDevice device, ANARIDataType objectType, const char *objectName) {
    const char *const *list = (const char *const *)anariGetObjectInfo(device, objectType, objectName, "extension", ANARI_STRING_LIST);
    if(list) {
        fillExtensionStruct(extensions, list);
        return 0;
    } else {
        return 1;
    }
}
int anariGetInstanceExtensionStruct(ANARIExtensions *extensions, ANARIDevice device, ANARIObject object) {
    const char *const *list = NULL;
    anariGetProperty(device, object, "extension", ANARI_STRING_LIST, &list, sizeof(list), ANARI_WAIT);
    if(list) {
        fillExtensionStruct(extensions, list);
        return 0;
    } else {
        return 1;
    }
}
#endif
