/* Generated file, don't edit */
/*=====================================================================*/
/*    serrano/prgm/project/bigloo/autoconf/bigloo_gc.h.in              */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Oct 12 08:22:13 2004                          */
/*    Last change :  Fri Feb  9 09:10:02 2007 (serrano)                */
/*    Copyright   :  2004-07 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The Bigloo garbage collector configuration                       */
/*=====================================================================*/
#ifndef BIGLOO_GC_H 
#define BIGLOO_GC_H

/*---------------------------------------------------------------------*/
/*    The BGL_HEAP_DEBUG requires the GC backpointers allocation       */
/*---------------------------------------------------------------------*/
#define BGL_HEAP_DEBUG_MARK_OBJ(x) x
#define BGL_HEAP_DEBUG_MARK_STR(x) x

/*---------------------------------------------------------------------*/
/*    Allocation procedures                                            */
/*---------------------------------------------------------------------*/
#if (BGL_GC == BGL_BOEHM_GC || BGL_GC == BGL_SAW_GC)
#  if (!defined(GC_PRIVATE_H))
     BGL_RUNTIME_DECL obj_t GC_malloc(size_t);
     BGL_RUNTIME_DECL obj_t GC_realloc(obj_t, size_t);
     BGL_RUNTIME_DECL void GC_free(obj_t);
     BGL_RUNTIME_DECL void GC_gcollect();
     BGL_RUNTIME_DECL void GC_gcollect_and_unmap();
     extern obj_t GC_malloc_atomic(size_t);
     extern obj_t GC_malloc_uncollectable(size_t);
#if (BGL_GC_VERSION < 700)
     extern obj_t GC_local_malloc(size_t);
     extern obj_t GC_local_malloc_atomic(size_t);
     extern obj_t GC_local_malloc_uncollectable(size_t);
#endif
     extern obj_t GC_debug_malloc(size_t, char *, long);
     extern obj_t GC_debug_malloc_atomic(size_t, char *, long);
     extern int GC_gc_no;
     extern size_t GC_size(void *);
     extern void GC_init();
     extern void bgl_gc_init();
     extern void GC_expand_hp(size_t);
     extern void GC_register_displacement(size_t);
     extern void GC_debug_register_displacement(size_t);
     extern void* GC_base(void*);
     extern int GC_invoke_finalizers();
     extern int GC_general_register_disappearing_link(obj_t * , obj_t);
     extern int GC_unregister_disappearing_link(obj_t *);
     typedef obj_t (*GC_fn_type) (obj_t client_data);
     extern obj_t GC_call_with_alloc_lock(GC_fn_type fn, obj_t client_data);
     typedef void (*GC_finalization_proc)(void *obj, void *client_data);
     extern void GC_register_finalizer(void *obj, 
                                        GC_finalization_proc fn, void *d,
                                        GC_finalization_proc *ofn, void **od);
     extern void GC_add_roots(void *, void *);
#    if (defined(PROFILE))
       extern void GC_profile_start();
#    endif
#  endif

#if (BGL_GC_ISCUSTOM) 
#  if (BGL_GC_VERSION < 740)
#    define BGL_GC_INIT() GC_init()
#  else
#    define BGL_GC_INIT() bgl_gc_init()
#  endif
#else
#  define BGL_GC_INIT() 1
#endif

#if (BGL_GC_VERSION < 720)
#  if (BGL_GC_BUMP_ALLOC)
#    define BGL_GC_INTERIOR_POINTERS() GC_all_interior_pointers=1
#  else
#    define BGL_GC_INTERIOR_POINTERS() GC_all_interior_pointers=0
#  endif
#else
#  if (BGL_GC_BUMP_ALLOC)
#    define BGL_GC_INTERIOR_POINTERS() GC_set_all_interior_pointers(1)
#  else
#    define BGL_GC_INTERIOR_POINTERS() GC_set_all_interior_pointers(0)
#  endif
#endif

#  undef GC_MALLOC
#  undef GC_MALLOC_ATOMIC
#  undef GC_MALLOC_UNCOLLECTABLE
#  undef GC_THREAD_MALLOC
#  undef GC_THREAD_MALLOC_ATOMIC
#  undef GC_THREAD_MALLOC_UNCOLLECTABLE
#  undef GC_REALLOC
#  undef GC_FREE
#  define GC_MALLOC(sz_) (obj_t)GC_malloc(sz_)
#  define GC_MALLOC_ATOMIC(sz_) (obj_t)GC_malloc_atomic(sz_)
#  define GC_MALLOC_UNCOLLECTABLE(sz_) (obj_t)GC_malloc_uncollectable(sz_)

#if (BGL_GC_VERSION < 700 && THREAD_LOCAL_ALLOC)
#  define GC_THREAD_MALLOC(sz_) (obj_t)GC_local_malloc(sz_)
#  define GC_THREAD_MALLOC_ATOMIC(sz_) (obj_t)GC_local_malloc_atomic(sz_)
#  define GC_THREAD_MALLOC_UNCOLLECTABLE(sz_) (obj_t)GC_local_malloc_uncollectable(sz_)
#endif

#  define GC_REALLOC GC_realloc
#  define GC_FREE GC_free
#  define GC_COLLECT() GC_gcollect()
#  define GC_COLLECT_AND_UNMAP() GC_gcollect_and_unmap()

#  if (!defined(GC_REGISTER_DISPLACEMENT))
#    define GC_REGISTER_DISPLACEMENT(o) GC_register_displacement(o)
#  endif

#  if (defined(TAG_STRUCT) && (TAG_STRUCT != 0) && !BGL_NAN_TAGGING)
#    define STRUCT_DISPLACEMENT() GC_REGISTER_DISPLACEMENT(TAG_STRUCT) 
#  else
#    define STRUCT_DISPLACEMENT() 0
#  endif
#  if (defined(TAG_PAIR) && (TAG_PAIR != 0) && !BGL_NAN_TAGGING)
#    define PAIR_DISPLACEMENT() GC_REGISTER_DISPLACEMENT(TAG_PAIR) 
#  else
#    define PAIR_DISPLACEMENT() 0
#  endif
#  if (defined(TAG_VECTOR) && (TAG_VECTOR != 0) && !BGL_NAN_TAGGING)
#    define VECTOR_DISPLACEMENT() GC_REGISTER_DISPLACEMENT(TAG_VECTOR) 
#  else
#    define VECTOR_DISPLACEMENT() 0
#  endif
#  if (defined(TAG_CELL) && (TAG_CELL != 0) && !BGL_NAN_TAGGING)
#    define CELL_DISPLACEMENT() GC_REGISTER_DISPLACEMENT(TAG_CELL) 
#  else
#    define CELL_DISPLACEMENT() 0
#  endif
#  if (defined(TAG_STRUCTURE) && (TAG_STRUCTURE != 0) && !BGL_NAN_TAGGING)
#    define STRUCTURE_DISPLACEMENT() GC_REGISTER_DISPLACEMENT(TAG_STRUCTURE) 
#   else
#    define STRUCTURE_DISPLACEMENT() 0
#  endif
#  if (defined(TAG_STRING) && (TAG_STRING != 0) && !BGL_NAN_TAGGING)
#    define STRING_DISPLACEMENT() GC_REGISTER_DISPLACEMENT(TAG_STRING) 
#  else
#    define STRING_DISPLACEMENT() 0
#  endif
#  if (defined(TAG_SYMBOL) && (TAG_SYMBOL != 0) && !BGL_NAN_TAGGING)
#    define SYMBOL_DISPLACEMENT() GC_REGISTER_DISPLACEMENT(TAG_SYMBOL) 
#  else
#    define SYMBOL_DISPLACEMENT() 0
#  endif
#  if (defined(TAG_REAL) && (TAG_REAL != 0) && !BGL_NAN_TAGGING)
#    define REAL_DISPLACEMENT() GC_REGISTER_DISPLACEMENT(TAG_REAL) 
#  else
#    define REAL_DISPLACEMENT() 0
#  endif
#  if (defined(TAG_OBJECT) && (TAG_OBJECT != 0) && !BGL_NAN_TAGGING)
#    define OBJECT_DISPLACEMENT() GC_REGISTER_DISPLACEMENT(TAG_OBJECT) 
#  else
#    define OBJECT_DISPLACEMENT() 0
#  endif

#  define INIT_ALLOCATION(size) \
     (BGL_GC_INTERIOR_POINTERS(), \
       BGL_GC_INIT(), \
       (size > 0 ? GC_expand_hp(size) : 0), \
       STRUCT_DISPLACEMENT(), \
       PAIR_DISPLACEMENT(), \
       VECTOR_DISPLACEMENT(), \
       CELL_DISPLACEMENT(), \
       STRUCTURE_DISPLACEMENT(), \
       STRING_DISPLACEMENT(), \
       SYMBOL_DISPLACEMENT(), \
       REAL_DISPLACEMENT(), \
       OBJECT_DISPLACEMENT(), \
       1)
#  define FREE_ALLOCATION() \
     (GC_invoke_finalizers())
#else
#  if (THE_GC == NO_GC)
#    undef GC_MALLOC
#    define GC_MALLOC(size) heap_alloc(size)
#    undef GC_MALLOC_ATOMIC
#    undef GC_MALLOC_UNCOLLECTABLE
#    define GC_MALLOC_ATOMIC(size) GC_MALLOC(size)
#    define GC_MALLOC_UNCOLLECTABLE(size) GC_MALLOC(size)
#    define INIT_ALLOCATION(size) init_heap(size)
#    define FREE_ALLOCATION() free_heap()
#    define GC_COLLECT() 
#    define GC_COLLECT_AND_UNMAP() 
#  else
     --> error "Unknown garbage collector type"
#  endif                
#endif          

#if (!defined(GC_THREAD_MALLOC))
#  define GC_THREAD_MALLOC GC_MALLOC
#  define GC_THREAD_MALLOC_ATOMIC GC_MALLOC_ATOMIC
#  define GC_THREAD_MALLOC_UNCOLLECTABLE GC_MALLOC_UNCOLLECTABLE
#endif

#endif
