/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.util.Comparator;
import org.jkiss.code.NotNull;

public class AlphanumericComparator
implements Comparator<CharSequence> {
    private static final AlphanumericComparator INSTANCE = new AlphanumericComparator();

    private AlphanumericComparator() {
    }

    @NotNull
    public static AlphanumericComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(CharSequence o1, CharSequence o2) {
        int len1 = o1.length();
        int len2 = o2.length();
        int i = 0;
        int j = 0;
        while (i < len1 && j < len2) {
            char ch1 = Character.toUpperCase(o1.charAt(i));
            char ch2 = Character.toUpperCase(o2.charAt(j));
            if (Character.isDigit(ch1) && Character.isDigit(ch2)) {
                int num1 = 0;
                int num2 = 0;
                while (i < len1 && Character.isDigit(o1.charAt(i))) {
                    num1 = num1 * 10 + Character.digit(o1.charAt(i), 10);
                    ++i;
                }
                while (j < len2 && Character.isDigit(o2.charAt(j))) {
                    num2 = num2 * 10 + Character.digit(o2.charAt(j), 10);
                    ++j;
                }
                if (num1 == num2) continue;
                return num1 - num2;
            }
            if (ch1 != ch2) {
                return ch1 - ch2;
            }
            ++i;
            ++j;
        }
        return len1 - len2;
    }
}

