/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.ghost;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.ghost.TextRenderingUtils;

public class SuggestionTextPainter
implements IPainter,
PaintListener,
LineBackgroundListener {
    public static final String HINT_CATEGORY = "suggestion";
    private final ITextViewer viewerComponent;
    private Color fontColor;
    private RenderState currentState;
    private final Semaphore lockObject;
    private boolean isEnabled;
    private HintContent activeHint;
    private IPositionUpdater updater;
    private boolean standaloneOperation = false;

    public SuggestionTextPainter(ITextViewer viewer) {
        this.viewerComponent = viewer;
        this.currentState = RenderState.IDLE;
        this.lockObject = new Semaphore(1);
        this.activeHint = HintContent.initialize(0, "");
        UIUtils.asyncExec(() -> ((ITextViewerExtension2)this.viewerComponent).addPainter((IPainter)this));
    }

    public void setHintColor(Color color) {
        this.fontColor = color;
    }

    public void removeHint() {
        if (!this.tryLock()) {
            return;
        }
        this.currentState = RenderState.REMOVING;
        UIUtils.asyncExec(this::executeRemove);
    }

    public void showHint(String content, boolean removeExisting) {
        if (!this.tryLock()) {
            return;
        }
        this.currentState = RenderState.SHOWING;
        UIUtils.asyncExec(() -> {
            if (removeExisting) {
                this.executeRemove();
            }
            this.executeShow(content);
        });
    }

    public boolean isProcessing() {
        return this.currentState != RenderState.IDLE;
    }

    public void enable() {
        if (!this.isEnabled) {
            this.isEnabled = true;
            StyledText textWidget = this.getTextWidget();
            textWidget.addPaintListener((PaintListener)this);
            textWidget.addLineBackgroundListener((LineBackgroundListener)this);
            this.viewerComponent.getDocument().addPositionCategory(HINT_CATEGORY);
            this.updater = new DefaultPositionUpdater(HINT_CATEGORY);
            this.viewerComponent.getDocument().addPositionUpdater(this.updater);
        }
    }

    public void deactivate(boolean redraw) {
        this.disable(redraw);
    }

    public void disable(boolean clearContent) {
        if (!this.isEnabled) {
            return;
        }
        if (clearContent) {
            this.removeHint();
        }
        StyledText textWidget = this.getTextWidget();
        textWidget.removePaintListener((PaintListener)this);
        textWidget.removeLineBackgroundListener((LineBackgroundListener)this);
        this.viewerComponent.getDocument().removePositionUpdater(this.updater);
        try {
            this.viewerComponent.getDocument().removePositionCategory(HINT_CATEGORY);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        this.currentState = RenderState.IDLE;
        this.isEnabled = false;
    }

    public void setPositionManager(IPaintPositionManager manager) {
    }

    public void dispose() {
    }

    public void paint(int reason) {
        if (!this.isEnabled) {
            this.enable();
        }
    }

    public void paintControl(PaintEvent event) {
        if (this.standaloneOperation && this.currentState == RenderState.SHOWING) {
            this.drawHintContent(event.gc);
            return;
        }
        if (!this.hasContentToShow()) {
            this.resetState();
            return;
        }
        switch (this.currentState) {
            case SHOWING: {
                this.drawHintContent(event.gc);
                break;
            }
            case REMOVING: {
                this.resetState();
                this.drawHintContent(event.gc);
                break;
            }
            default: {
                this.drawHintContent(event.gc);
            }
        }
    }

    public void lineGetBackground(LineBackgroundEvent event) {
    }

    public void applyHint() {
        if (!this.hasContentToShow()) {
            return;
        }
        this.insertTextAtCursor(this.activeHint.getContent());
        this.removeHint();
    }

    public boolean hasContentToShow() {
        return this.activeHint != null && !this.activeHint.isEmpty();
    }

    public int getCurrentPosition() {
        return this.activeHint != null ? this.activeHint.getPosition() : -1;
    }

    private void drawHintContent(GC gc) {
        this.configureGraphicsContext(gc);
        int position = this.activeHint.getPosition();
        String[] textLines = this.activeHint.getTextLines();
        if (textLines.length > 0) {
            TextRenderingUtils.drawFirstLine(textLines[0], gc, this.getTextWidget(), position);
            this.configureGraphicsContext(gc);
            if (textLines.length > 1) {
                TextRenderingUtils.drawNextLines(textLines[1], gc, this.getTextWidget(), position);
            }
        }
        this.resetState();
    }

    private void executeShow(String text) {
        int cursorPosition = this.getCursorPosition();
        String wordPrefix = this.extractCurrentWord();
        String fragment = text;
        if (!wordPrefix.isEmpty() && fragment.toLowerCase().startsWith(wordPrefix.toLowerCase())) {
            fragment = fragment.substring(wordPrefix.length());
        }
        this.activeHint = HintContent.initialize(cursorPosition, fragment);
        this.getTextWidget().redraw();
    }

    private void executeRemove() {
        this.activeHint = HintContent.initialize(this.activeHint.getPosition(), "");
        this.getTextWidget().redraw();
    }

    private void insertTextAtCursor(String text) {
        try {
            IDocument document = this.viewerComponent.getDocument();
            int modelPosition = TextRenderingUtils.widgetOffset2ModelOffset(this.viewerComponent, this.activeHint.getPosition());
            document.replace(modelPosition, 0, text);
            this.getTextWidget().setCaretOffset(this.activeHint.getPosition() + text.length());
        }
        catch (Exception exception) {}
    }

    private boolean tryLock() {
        try {
            return this.lockObject.tryAcquire(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private void resetState() {
        this.currentState = RenderState.IDLE;
        if (this.lockObject.availablePermits() == 0) {
            this.lockObject.release();
        }
    }

    private void configureGraphicsContext(GC gc) {
        if (this.fontColor != null) {
            gc.setForeground(this.fontColor);
        }
        gc.setBackground(this.getTextWidget().getBackground());
    }

    private int getCursorPosition() {
        return this.getTextWidget().getCaretOffset();
    }

    private String extractCurrentWord() {
        StyledText widget = this.getTextWidget();
        int position = this.getCursorPosition();
        String lineContent = widget.getText().substring(0, position);
        int separator = Math.max(lineContent.lastIndexOf(32), lineContent.lastIndexOf(9));
        return separator >= 0 ? lineContent.substring(separator + 1) : lineContent;
    }

    private StyledText getTextWidget() {
        return this.viewerComponent.getTextWidget();
    }

    private static class HintContent {
        private final int position;
        private final String content;

        private HintContent(int position, String content) {
            this.position = position;
            this.content = content == null ? "" : content;
        }

        static HintContent initialize(int position, String content) {
            return new HintContent(position, content);
        }

        int getPosition() {
            return this.position;
        }

        String getContent() {
            return this.content;
        }

        boolean isEmpty() {
            return this.content.isEmpty();
        }

        String[] getTextLines() {
            return this.content.split("\\R", 2);
        }
    }

    private static enum RenderState {
        IDLE,
        SHOWING,
        REMOVING;

    }
}

