/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.tipoftheday;

import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IWorkbenchWindowInitializer;
import org.jkiss.dbeaver.ui.app.standalone.tipoftheday.ShowTipOfTheDayHandler;
import org.jkiss.utils.CommonUtils;

public class TipOfTheDayInitializer
implements IWorkbenchWindowInitializer {
    private static final String PROP_NOT_FIRST_RUN = "tipOfTheDayInitializer.notFirstRun";

    public void initializeWorkbenchWindow(@NotNull IWorkbenchWindowConfigurer configurer) {
        IWorkbenchWindow window = configurer.getWindow();
        if (!TipOfTheDayInitializer.isTipsEnabled() || window.getWorkbench().getWorkbenchWindowCount() > 1) {
            return;
        }
        ShowTipOfTheDayHandler.showTipOfTheDay(window);
    }

    private static boolean isTipsEnabled() {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean(PROP_NOT_FIRST_RUN)) {
            DBWorkbench.getPlatform().getPreferenceStore().setValue(PROP_NOT_FIRST_RUN, true);
            return false;
        }
        String tipsEnabledStr = DBWorkbench.getPlatform().getPreferenceStore().getString("ui.show.tip.of.the.day.on.startup");
        if (CommonUtils.isEmpty((String)tipsEnabledStr)) {
            return true;
        }
        return CommonUtils.toBoolean((Object)tipsEnabledStr);
    }
}

