/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.Pair;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.eval.ScriptVariablesResolver;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLCommandModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModel;
import org.jkiss.dbeaver.model.stm.LSMInspections;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeRuleNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SQLCommandModelRecognizer {
    private static STMTreeTermNode makeNode(int start, int length) {
        return new STMTreeTermNode((Token)new CommonToken(new Pair(null, null), -1, 0, start, start + length - 1));
    }

    private static SQLQuerySymbolEntry makeSymbol(int start, int length, @NotNull String name, @NotNull SQLQuerySymbolClass symbolClass) {
        SQLQuerySymbolEntry symbol = new SQLQuerySymbolEntry((STMTreeNode)SQLCommandModelRecognizer.makeNode(start, length), name, name, null);
        symbol.getSymbol().setSymbolClass(symbolClass);
        return symbol;
    }

    public static SQLQueryModel recognizeCommand(@NotNull SQLQueryRecognitionContext recognitionContext, @NotNull String text, @NotNull SQLScriptContext scriptContext) {
        int end;
        int start;
        HashSet<SQLQuerySymbolEntry> symbolEntries = new HashSet<SQLQuerySymbolEntry>();
        String cmdPrefix = recognitionContext.getSyntaxManager().getControlCommandPrefix();
        String multilinePrefix = cmdPrefix.repeat(2);
        if (text.startsWith(multilinePrefix)) {
            start = multilinePrefix.length();
            symbolEntries.add(SQLCommandModelRecognizer.makeSymbol(0, multilinePrefix.length(), multilinePrefix, SQLQuerySymbolClass.DBEAVER_COMMAND));
            if (text.endsWith(multilinePrefix)) {
                end = text.length() - multilinePrefix.length();
                symbolEntries.add(SQLCommandModelRecognizer.makeSymbol(end, multilinePrefix.length(), multilinePrefix, SQLQuerySymbolClass.DBEAVER_COMMAND));
            } else {
                end = text.length();
            }
        } else if (text.startsWith(cmdPrefix)) {
            start = cmdPrefix.length();
            end = text.length();
            symbolEntries.add(SQLCommandModelRecognizer.makeSymbol(0, cmdPrefix.length(), cmdPrefix, SQLQuerySymbolClass.DBEAVER_COMMAND));
        } else {
            start = 0;
            end = text.length();
        }
        String cmdText = text.substring(start, end);
        Interval nameInterval = LSMInspections.matchAnyWordHead((String)cmdText);
        if (nameInterval != null) {
            symbolEntries.add(SQLCommandModelRecognizer.makeSymbol(start, nameInterval.length(), cmdText.substring(nameInterval.a, nameInterval.b + 1), SQLQuerySymbolClass.DBEAVER_COMMAND));
        }
        STMTreeRuleNode fakeTree = new STMTreeRuleNode();
        SQLCommandModel cmdModel = new SQLCommandModel((STMTreeNode)fakeTree, text);
        SQLCommandModelRecognizer.registerVariables(scriptContext, cmdText, start, symbolEntries, cmdModel);
        SQLCommandModelRecognizer.registerCommandParameter(text, symbolEntries);
        return new SQLQueryModel((STMTreeNode)fakeTree, cmdModel, symbolEntries, Collections.emptyList());
    }

    private static void registerVariables(@NotNull SQLScriptContext scriptContext, @NotNull String cmdText, int start, @NotNull Set<SQLQuerySymbolEntry> symbolEntries, @NotNull SQLCommandModel cmdModel) {
        ScriptVariablesResolver variablesResolver = scriptContext.getExecutionContext() == null ? null : new ScriptVariablesResolver(scriptContext);
        List vars = GeneralUtils.findAllVariableEntries((String)cmdText);
        for (GeneralUtils.VariableEntryInfo varEntry : vars) {
            SQLQuerySymbolEntry symbolEntry = SQLCommandModelRecognizer.makeSymbol(start + varEntry.start(), varEntry.end() - varEntry.start(), cmdText.substring(varEntry.start(), varEntry.end()), SQLQuerySymbolClass.DBEAVER_VARIABLE);
            symbolEntries.add(symbolEntry);
            scriptContext.getVariable(varEntry.name().toUpperCase(Locale.ENGLISH));
            cmdModel.addVariable(symbolEntry, variablesResolver == null ? "?" : variablesResolver.get(varEntry.name()));
        }
    }

    private static void registerCommandParameter(@NotNull String text, @NotNull Set<SQLQuerySymbolEntry> symbolEntries) {
        List<SQLQuerySymbolEntry> alreadyHighlighted = symbolEntries.stream().sorted(Comparator.comparingInt(e -> e.getInterval().a)).toList();
        int prevPos = 0;
        for (SQLQuerySymbolEntry entry : alreadyHighlighted) {
            int entryPos = entry.getInterval().a;
            if (prevPos < entryPos) {
                symbolEntries.add(SQLCommandModelRecognizer.makeSymbol(prevPos, entryPos - prevPos, text.substring(prevPos, entryPos), SQLQuerySymbolClass.UNKNOWN));
            }
            prevPos = entry.getInterval().b + 1;
        }
        if (prevPos < text.length()) {
            symbolEntries.add(SQLCommandModelRecognizer.makeSymbol(prevPos, text.length() - prevPos, text.substring(prevPos), SQLQuerySymbolClass.UNKNOWN));
        }
    }
}

