/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetCorrespondingOperationKind;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetOperationModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsSetCorrespondingOperationModel
extends SQLQueryRowsSetOperationModel
implements SQLQueryNodeModel.NodeSubtreeTraverseControl {
    @NotNull
    private final List<SQLQuerySymbolEntry> correspondingColumnNames;
    @NotNull
    private final SQLQueryRowsSetCorrespondingOperationKind kind;

    public SQLQueryRowsSetCorrespondingOperationModel(@NotNull Interval range, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryRowsSourceModel left, @NotNull SQLQueryRowsSourceModel right, @NotNull List<SQLQuerySymbolEntry> correspondingColumnNames, @NotNull SQLQueryRowsSetCorrespondingOperationKind kind) {
        super(range, syntaxNode, left, right);
        this.correspondingColumnNames = correspondingColumnNames;
        this.kind = kind;
    }

    @NotNull
    public SQLQueryRowsSetCorrespondingOperationKind getKind() {
        return this.kind;
    }

    @NotNull
    private SQLQueryExprType obtainCommonType(@Nullable SQLQueryResultColumn leftDef, @Nullable SQLQueryResultColumn rightDef) {
        SQLQueryExprType type;
        if (leftDef == null && rightDef == null) {
            type = SQLQueryExprType.UNKNOWN;
        } else if (leftDef == null) {
            type = rightDef.type;
        } else if (rightDef == null) {
            type = leftDef.type;
        } else {
            type = SQLQueryExprType.tryCombineIfMatches(leftDef.type, rightDef.type);
            if (type == null) {
                type = SQLQueryExprType.UNKNOWN;
            }
        }
        return type;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        ArrayList<SQLQueryResultColumn> resultColumns;
        SQLQueryDataContext left = this.left.propagateContext(context, statistics);
        SQLQueryDataContext right = this.right.propagateContext(context, statistics);
        boolean nonMatchingColumnSets = false;
        if (this.correspondingColumnNames.isEmpty()) {
            List<SQLQueryResultColumn> leftColumns = left.getColumnsList();
            List<SQLQueryResultColumn> rightColumns = right.getColumnsList();
            int resultColumnsCount = Math.max(leftColumns.size(), rightColumns.size());
            resultColumns = new ArrayList(resultColumnsCount);
            int i = 0;
            while (i < resultColumnsCount) {
                if (i >= leftColumns.size()) {
                    resultColumns.add(rightColumns.get(i));
                    nonMatchingColumnSets = true;
                } else if (i >= rightColumns.size()) {
                    resultColumns.add(leftColumns.get(i));
                    nonMatchingColumnSets = true;
                } else {
                    SQLQuerySymbol symbol;
                    SQLQueryResultColumn leftColumn = leftColumns.get(i);
                    SQLQueryResultColumn rightColumn = rightColumns.get(i);
                    SQLQueryExprType type = this.obtainCommonType(leftColumn, rightColumn);
                    if (leftColumn.symbol.getName().equalsIgnoreCase(rightColumn.symbol.getName())) {
                        SQLQuerySymbolClass leftClass = leftColumn.symbol.getSymbolClass();
                        SQLQuerySymbolDefinition leftDef = leftColumn.symbol.getDefinition();
                        symbol = leftColumn.symbol.merge(rightColumn.symbol);
                        symbol.setDefinition(leftDef);
                        if (symbol.getSymbolClass() == SQLQuerySymbolClass.UNKNOWN) {
                            symbol.setSymbolClass(leftClass);
                        }
                    } else {
                        symbol = leftColumn.symbol;
                    }
                    resultColumns.add(new SQLQueryResultColumn(i, symbol, this, null, null, type));
                }
                ++i;
            }
        } else {
            SQLQuerySymbolOrigin.ColumnNameFromContext columnNameOrigin = new SQLQuerySymbolOrigin.ColumnNameFromContext(left.combine(right));
            int resultColumnsCount = this.correspondingColumnNames.size();
            resultColumns = new ArrayList<SQLQueryResultColumn>(resultColumnsCount);
            int i = 0;
            while (i < resultColumnsCount) {
                SQLQuerySymbolEntry column = this.correspondingColumnNames.get(i);
                if (column.isNotClassified()) {
                    SQLQueryResultColumn leftDef = left.resolveColumn(statistics.getMonitor(), column.getName());
                    SQLQueryResultColumn rightDef = right.resolveColumn(statistics.getMonitor(), column.getName());
                    if (leftDef == null || rightDef == null) {
                        nonMatchingColumnSets = true;
                    }
                    SQLQueryExprType type = this.obtainCommonType(leftDef, rightDef);
                    column.getSymbol().setDefinition(column);
                    column.setOrigin(columnNameOrigin);
                    resultColumns.add(new SQLQueryResultColumn(i, column.getSymbol(), this, null, null, type));
                }
                ++i;
            }
        }
        if (nonMatchingColumnSets) {
            statistics.appendError(this.getSyntaxNode(), "UNION, EXCEPT and INTERSECT require subsets column tuples to match");
        }
        return context.overrideResultTuple(this, resultColumns, Collections.emptyList());
    }

    @Override
    @NotNull
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        this.left.resolveRowSources(context, statistics);
        this.right.resolveRowSources(context, statistics);
        return context.reset();
    }

    @Override
    public boolean delayRestChildren() {
        return true;
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        return this.left.getRowsDataContext();
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsSetCorrespondingOp(this, arg);
    }
}

