/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableManagerBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablePolicy;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionAtomic;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreTableManager
extends PostgreTableManagerBase
implements DBEObjectRenamer<PostgreTableBase> {
    private static final Class<? extends DBSObject>[] CHILD_TYPES = (Class[])CommonUtils.array((Object[])new Class[]{PostgreTableColumn.class, PostgreTableConstraint.class, PostgreTableForeignKey.class, PostgreTablePolicy.class, PostgreIndex.class});

    @Nullable
    public DBSObjectCache<PostgreTableContainer, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreTableContainer)object.getContainer()).getSchema().getTableCache();
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return super.getMakerOptions(dataSource) | 0x10L;
    }

    public Collection<? extends DBSObject> getChildObjects(DBRProgressMonitor monitor, PostgreTableBase object, Class<? extends DBSObject> childType) throws DBException {
        if (childType == PostgreTableColumn.class) {
            return object.getAttributes(monitor);
        }
        if (childType == PostgreTableConstraint.class) {
            return object.getConstraints(monitor);
        }
        if (childType == PostgreTableForeign.class) {
            return object.getAssociations(monitor);
        }
        if (childType == PostgreIndex.class) {
            return object.getIndexes(monitor);
        }
        return null;
    }

    protected String beginCreateTableStatement(DBRProgressMonitor monitor, PostgreTableBase table, String tableName, Map<String, Object> options) throws DBException {
        String statement = "CREATE " + this.getCreateTableType(table) + " ";
        if (table.isPartition() && table instanceof PostgreTable) {
            PostgreTable postgreTable = (PostgreTable)table;
            List<PostgreTableBase> superTables = postgreTable.getSuperTables(monitor);
            if (superTables == null || superTables.size() != 1) {
                log.error((Object)("Cant't read partition parent table name for table " + table.getFullyQualifiedName(DBPEvaluationContext.DDL)));
            } else {
                String parent = superTables.get(0).getFullyQualifiedName(DBPEvaluationContext.DDL);
                String range = postgreTable.getPartitionRange(monitor);
                return statement + tableName + " PARTITION OF " + parent + " " + range;
            }
        }
        return statement + tableName + " (" + GeneralUtils.getDefaultLineSeparator();
    }

    protected boolean hasAttrDeclarations(PostgreTableBase table) {
        return !table.isPartition();
    }

    protected String getCreateTableType(PostgreTableBase table) {
        if (table instanceof PostgreTableForeign) {
            return "FOREIGN TABLE";
        }
        return table.getPersistence().getTableTypeClause();
    }

    protected PostgreTableBase createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        PostgreSchema schema = (PostgreSchema)container;
        PostgreTableBase table = schema.getDataSource().getServerType().createNewRelation(monitor, schema, PostgreClass.RelKind.r, copyFrom);
        if (CommonUtils.isEmpty((String)table.getName())) {
            this.setNewObjectName(monitor, schema, table);
        } else {
            table.setName(this.getNewChildName(monitor, schema, table.getName()));
        }
        return table;
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        String tableDDL;
        PostgreTableBase tableBase = (PostgreTableBase)command.getObject();
        if (tableBase.isPersisted() && (tableDDL = ((PostgreDataSource)tableBase.getDataSource()).getServerType().readTableDDL(monitor, tableBase)) != null) {
            actions.add(0, (DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table, tableDDL));
            return;
        }
        super.addStructObjectCreateActions(monitor, executionContext, actions, command, options);
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        if ((command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) && command.getObject() instanceof PostgreTable) {
            try {
                this.generateAlterActions(monitor, actionList, command);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    private void generateAlterActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        PostgreTable table = (PostgreTable)command.getObject();
        String alterPrefix = "ALTER " + table.getTableTypeName() + " " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ";
        if (command.hasProperty((Object)"partitionKey")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(alterPrefix + "PARTITION BY " + table.getPartitionKey()));
        }
        if (command.hasProperty((Object)"hasOids") && ((PostgreDataSource)table.getDataSource()).getServerType().supportsHasOidsColumn()) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(alterPrefix + (table.isHasOids() ? "SET WITH OIDS" : "SET WITHOUT OIDS")));
        }
        if (command.hasProperty((Object)"hasRowLevelSecurity") && ((PostgreDataSource)table.getDataSource()).getServerType().supportsRowLevelSecurity()) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(alterPrefix + (table.isHasRowLevelSecurity() ? "ENABLE" : "DISABLE") + " ROW LEVEL SECURITY"));
        }
        if (command.hasProperty((Object)"tablespace")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(alterPrefix + "SET TABLESPACE " + table.getTablespace(monitor).getName()));
        }
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, PostgreTableBase tableBase, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
        ddl.append(((PostgreDataSource)tableBase.getDataSource()).getServerType().getTableModifiers(monitor, tableBase, alter));
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        PostgreTableBase table = (PostgreTableBase)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER " + table.getTableTypeName() + " " + DBUtils.getQuotedIdentifier((DBSObject)table.getSchema()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)table.getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)table.getDataSource(), (String)command.getNewName())));
    }

    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreTableBase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        PostgreTableBase table = (PostgreTableBase)command.getObject();
        String tableName = DBUtils.getEntityScriptName((DBSObject)table, options);
        String script = "DROP " + table.getTableTypeName() + " " + tableName + (CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "");
        SQLDatabasePersistActionAtomic action = table.getSchema().isExternal() ? new SQLDatabasePersistActionAtomic(ModelMessages.model_jdbc_drop_table, script) : new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, script);
        actions.add((DBEPersistAction)action);
    }
}

