/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreRule
implements PostgreObject,
PostgreScriptObject,
DBPQualifiedObject {
    private static final Log log = Log.getLog(PostgreRule.class);
    private PostgreTableBase table;
    private long objectId;
    protected String name;
    private boolean persisted;
    private String type;
    private String enabled;
    private boolean instead;
    private String definition;
    public String body;
    protected String description;

    public PostgreRule(DBRProgressMonitor monitor, PostgreTableReal table, ResultSet dbResult) throws DBException {
        this.table = table;
        this.persisted = true;
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"rulename");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ev_type");
        this.enabled = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ev_enabled");
        this.instead = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_instead");
        this.definition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"definition");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public PostgreTableBase getTable() {
        return this.table;
    }

    @Property(viewable=true, order=10)
    public long getObjectId() {
        return this.objectId;
    }

    @Property(viewable=true, order=20)
    public String getType() {
        return this.type;
    }

    @Property(viewable=true, order=21)
    public String getEnabled() {
        return this.enabled;
    }

    @Property(viewable=true, order=22)
    public boolean isInstead() {
        return this.instead;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PostgreTableBase getParentObject() {
        return this.table;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)this.table.getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.table.getDatabase();
    }

    @Property(hidden=true, order=80)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.body == null) {
            StringBuilder ddl = new StringBuilder();
            ddl.append("-- DROP RULE ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(" ON ").append(this.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL)).append(";\n\n");
            ddl.append(this.definition);
            this.body = ddl.toString();
        }
        return this.body;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.definition = sourceText;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getParentObject(), this});
    }
}

