/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class PrefUtils {
    private static final Log log = Log.getLog(PrefUtils.class);

    public static void savePreferenceStore(DBPPreferenceStore store) {
        try {
            store.save();
        }
        catch (IOException e) {
            log.warn(e);
        }
    }

    public static void setDefaultPreferenceValue(DBPPreferenceStore store, String name, Object value) {
        if (CommonUtils.isEmpty((String)store.getDefaultString(name))) {
            store.setDefault(name, value.toString());
        }
    }

    public static Object getPreferenceValue(DBPPreferenceStore store, String propName, Class<?> valueType) {
        String str;
        block11: {
            str = store.getString(propName);
            if (str != null) break block11;
            return null;
        }
        try {
            if (valueType == null || CharSequence.class.isAssignableFrom(valueType)) {
                return CommonUtils.isEmpty((String)str) ? null : str;
            }
            if (valueType == Boolean.class || valueType == Boolean.TYPE) {
                return CommonUtils.toBoolean((Object)str);
            }
            if (valueType == Long.class || valueType == Long.TYPE) {
                return CommonUtils.toLong((Object)str);
            }
            if (valueType == Integer.class || valueType == Integer.TYPE || valueType == Short.class || valueType == Short.TYPE || valueType == Byte.class || valueType == Byte.TYPE) {
                return CommonUtils.toInt((Object)str);
            }
            if (valueType == Double.class || valueType == Double.TYPE) {
                return CommonUtils.toDouble((Object)str);
            }
            if (valueType == Float.class || valueType == Float.TYPE) {
                return Float.valueOf(CommonUtils.toFloat((Object)store));
            }
            if (valueType == BigInteger.class) {
                return new BigInteger(str);
            }
            if (valueType == BigDecimal.class) {
                return new BigDecimal(str);
            }
        }
        catch (RuntimeException e) {
            log.error(e);
        }
        String string = store.getString(propName);
        return CommonUtils.isEmpty((String)string) ? null : string;
    }

    public static void setPreferenceValue(DBPPreferenceStore store, String propName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof CharSequence) {
            store.setValue(propName, value.toString());
        } else if (value instanceof Boolean) {
            store.setValue(propName, (Boolean)value);
        } else if (value instanceof Long) {
            store.setValue(propName, (Long)value);
        } else if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            store.setValue(propName, ((Number)value).intValue());
        } else if (value instanceof Double) {
            store.setValue(propName, (Double)value);
        } else if (value instanceof Float) {
            store.setValue(propName, ((Float)value).floatValue());
        } else {
            store.setValue(propName, value.toString());
        }
    }

    public static void setPreferenceDefaultValue(DBPPreferenceStore store, String propName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof CharSequence) {
            store.setDefault(propName, value.toString());
        } else if (value instanceof Boolean) {
            store.setDefault(propName, (Boolean)value);
        } else if (value instanceof Long) {
            store.setDefault(propName, (Long)value);
        } else if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            store.setDefault(propName, ((Number)value).intValue());
        } else if (value instanceof Double) {
            store.setDefault(propName, (Double)value);
        } else if (value instanceof Float) {
            store.setDefault(propName, ((Float)value).floatValue());
        } else {
            store.setDefault(propName, value.toString());
        }
    }

    public static String collectSingleConnectionDrivers() {
        return DBWorkbench.getPlatform().getDataSourceProviderRegistry().getDataSourceProviders().stream().flatMap(pr -> pr.getDrivers().stream()).filter(d -> d.isSingleConnection() || d.isEmbedded()).sorted(Comparator.comparing(DBPNamedObject::getName)).map(d -> " - " + d.getName()).distinct().collect(Collectors.joining("\n"));
    }
}

