/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.ApplicationInstanceController;
import org.jkiss.dbeaver.model.cli.CmdProcessResult;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ApplicationCommandLine<T extends ApplicationInstanceController> {
    private static final Log log = Log.getLog(ApplicationCommandLine.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.commandLine";
    public static final String PARAM_HELP = "help";
    public static final String PARAM_THREAD_DUMP = "dump";
    public static final String PARAM_DB_LIST = "databaseList";
    private static final String PARAM_VERSION = "version";
    public static final Options ALL_OPTIONS = new Options().addOption("help", "help", false, "Help").addOption("databaseList", "database-driver-list", true, "Show list of supported database drivers in json format").addOption("dump", "thread-dump", false, "Print instance thread dump").addOption("version", "version", false, "Displays the app name, edition, and version in Major.Minor.Micro.Timestamp format");

    protected ApplicationCommandLine() {
    }

    /*
     * Loose catch block
     */
    public CmdProcessResult executeCommandLineCommands(@Nullable CommandLine commandLine, @Nullable T controller, boolean uiActivated) throws Exception {
        if (commandLine == null || ArrayUtils.isEmpty((Object[])commandLine.getArgs()) && ArrayUtils.isEmpty((Object[])commandLine.getOptions())) {
            return new CmdProcessResult(CmdProcessResult.PostAction.START_INSTANCE);
        }
        if (controller == null) {
            log.debug((Object)"Can't process commands because no running instance is present");
            return new CmdProcessResult(CmdProcessResult.PostAction.START_INSTANCE);
        }
        if (commandLine.hasOption(PARAM_HELP)) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.setWidth(120);
            helpFormatter.setOptionComparator((o1, o2) -> 0);
            helpFormatter.printHelp("dbeaver", GeneralUtils.getProductTitle(), ALL_OPTIONS, "(C) 2010-2025 DBeaver Corp", true);
            try {
                Throwable throwable = null;
                Object var6_10 = null;
                try {
                    CmdProcessResult cmdProcessResult;
                    PrintWriter print;
                    StringWriter out;
                    block23: {
                        out = new StringWriter();
                        print = new PrintWriter(out);
                        helpFormatter.printHelp(print, 100, "dbeaver", GeneralUtils.getProductTitle(), ALL_OPTIONS, 4, 4, "(C) 2010-2025 DBeaver Corp", true);
                        cmdProcessResult = new CmdProcessResult(CmdProcessResult.PostAction.SHUTDOWN, out.toString());
                        if (print != null) {
                            print.close();
                        }
                        if (out == null) break block23;
                        out.close();
                    }
                    return cmdProcessResult;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (print != null) {
                                    print.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (out != null) {
                                    out.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)("Error handling command line: " + e.getMessage()));
                return new CmdProcessResult(CmdProcessResult.PostAction.ERROR, e.getMessage());
            }
        }
        if (!uiActivated && commandLine.hasOption(PARAM_THREAD_DUMP)) {
            String threadDump = controller.getThreadDump();
            System.out.println(threadDump);
            return new CmdProcessResult(CmdProcessResult.PostAction.SHUTDOWN, threadDump);
        }
        if (commandLine.hasOption(PARAM_VERSION)) {
            String version = GeneralUtils.getLongProductTitle();
            System.out.println(version);
            return new CmdProcessResult(CmdProcessResult.PostAction.SHUTDOWN, version);
        }
        return new CmdProcessResult(CmdProcessResult.PostAction.UNKNOWN_COMMAND);
    }

    @Nullable
    public CommandLine getCommandLine() {
        return this.getCommandLine(Platform.getApplicationArgs());
    }

    @Nullable
    public CommandLine getCommandLine(@NotNull String[] args) {
        try {
            List<String> applicationArgs = Arrays.stream(args).collect(Collectors.toList());
            Iterator iterator = applicationArgs.iterator();
            boolean removeArgs = false;
            while (iterator.hasNext()) {
                String arg = (String)iterator.next();
                if (CommonUtils.isEmpty((String)arg)) continue;
                if (arg.startsWith("-")) {
                    boolean argSupported = ALL_OPTIONS.hasOption(arg);
                    if (argSupported) {
                        removeArgs = false;
                        continue;
                    }
                    iterator.remove();
                    removeArgs = true;
                    continue;
                }
                if (!removeArgs) continue;
                iterator.remove();
            }
            return new DefaultParser().parse(ALL_OPTIONS, applicationArgs.toArray(new String[0]), false);
        }
        catch (Exception e) {
            log.warn((Object)("Error parsing command line: " + e.getMessage()));
            return null;
        }
    }
}

