/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.merge.MergeDelete;
import net.sf.jsqlparser.statement.merge.MergeInsert;
import net.sf.jsqlparser.statement.merge.MergeOperation;
import net.sf.jsqlparser.statement.merge.MergeOperationVisitor;
import net.sf.jsqlparser.statement.merge.MergeUpdate;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;

public class MergeDeParser
extends AbstractDeParser<Merge>
implements MergeOperationVisitor<StringBuilder> {
    private final ExpressionDeParser expressionDeParser;
    private final SelectDeParser selectDeParser;

    public MergeDeParser(ExpressionDeParser expressionDeParser, SelectDeParser selectDeParser, StringBuilder buffer) {
        super(buffer);
        this.expressionDeParser = expressionDeParser;
        this.selectDeParser = selectDeParser;
    }

    @Override
    public void deParse(Merge merge) {
        List<WithItem<?>> withItemsList = merge.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem<?>> iter = withItemsList.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this.selectDeParser, null);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("MERGE ");
        if (merge.getOracleHint() != null) {
            this.buffer.append(merge.getOracleHint()).append(" ");
        }
        this.buffer.append("INTO ");
        merge.getTable().accept(this.selectDeParser, null);
        this.buffer.append(" USING ");
        merge.getFromItem().accept(this.selectDeParser, null);
        this.buffer.append(" ON ");
        merge.getOnCondition().accept(this.expressionDeParser, null);
        List<MergeOperation> operations = merge.getOperations();
        if (operations != null && !operations.isEmpty()) {
            operations.forEach(operation -> operation.accept(this, null));
        }
        if (merge.getOutputClause() != null) {
            merge.getOutputClause().appendTo(this.buffer);
        }
    }

    @Override
    public <S> StringBuilder visit(MergeDelete mergeDelete, S context) {
        this.buffer.append(" WHEN MATCHED");
        if (mergeDelete.getAndPredicate() != null) {
            this.buffer.append(" AND ");
            mergeDelete.getAndPredicate().accept(this.expressionDeParser, context);
        }
        this.buffer.append(" THEN DELETE");
        return this.buffer;
    }

    public void visit(MergeDelete mergeDelete) {
        this.visit(mergeDelete, (Object)null);
    }

    @Override
    public <S> StringBuilder visit(MergeUpdate mergeUpdate, S context) {
        this.buffer.append(" WHEN MATCHED");
        if (mergeUpdate.getAndPredicate() != null) {
            this.buffer.append(" AND ");
            mergeUpdate.getAndPredicate().accept(this.expressionDeParser, context);
        }
        this.buffer.append(" THEN UPDATE SET ");
        MergeDeParser.deparseUpdateSets(mergeUpdate.getUpdateSets(), this.buffer, this.expressionDeParser);
        if (mergeUpdate.getWhereCondition() != null) {
            this.buffer.append(" WHERE ");
            mergeUpdate.getWhereCondition().accept(this.expressionDeParser, context);
        }
        if (mergeUpdate.getDeleteWhereCondition() != null) {
            this.buffer.append(" DELETE WHERE ");
            mergeUpdate.getDeleteWhereCondition().accept(this.expressionDeParser, context);
        }
        return this.buffer;
    }

    public void visit(MergeUpdate mergeUpdate) {
        this.visit(mergeUpdate, (Object)null);
    }

    @Override
    public <S> StringBuilder visit(MergeInsert mergeInsert, S context) {
        this.buffer.append(" WHEN NOT MATCHED");
        if (mergeInsert.getAndPredicate() != null) {
            this.buffer.append(" AND ");
            mergeInsert.getAndPredicate().accept(this.expressionDeParser, context);
        }
        this.buffer.append(" THEN INSERT ");
        if (mergeInsert.getColumns() != null) {
            mergeInsert.getColumns().accept(this.expressionDeParser, context);
        }
        this.buffer.append(" VALUES ");
        mergeInsert.getValues().accept(this.expressionDeParser, context);
        if (mergeInsert.getWhereCondition() != null) {
            this.buffer.append(" WHERE ");
            mergeInsert.getWhereCondition().accept(this.expressionDeParser, context);
        }
        return this.buffer;
    }

    public void visit(MergeInsert mergeInsert) {
        this.visit(mergeInsert, (Object)null);
    }

    public ExpressionDeParser getExpressionDeParser() {
        return this.expressionDeParser;
    }

    public SelectDeParser getSelectDeParser() {
        return this.selectDeParser;
    }
}

