/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.rest;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.HttpTransportInvocationHandler;
import org.jkiss.utils.rest.RequestMapping;
import org.jkiss.utils.rest.RestEndpointResolver;
import org.jkiss.utils.rest.RpcClient;
import org.jkiss.utils.rest.RpcConstants;
import org.jkiss.utils.rest.RpcException;

public class RestClient
extends RpcClient {
    private static final String DEFAULT_USER_AGENT = "DBeaver RPC Client";

    @NotNull
    public static <T> Builder<T> builder(@NotNull URI uri, @NotNull Class<T> cls) {
        return new Builder<T>(uri, cls);
    }

    public static final class Builder<T> {
        private final URI uri;
        private final Class<T> cls;
        private Gson gson;
        private RestEndpointResolver resolver;
        private String userAgent;

        private Builder(@NotNull URI uri, @NotNull Class<T> cls) {
            this.uri = uri;
            this.cls = cls;
            this.gson = RpcConstants.DEFAULT_GSON;
            this.resolver = methodName -> methodName;
            this.userAgent = RestClient.DEFAULT_USER_AGENT;
        }

        @NotNull
        public Builder<T> setGson(@NotNull Gson gson) {
            this.gson = gson;
            return this;
        }

        public Builder<T> setEndpointResolver(@NotNull RestEndpointResolver resolver) {
            this.resolver = resolver;
            return this;
        }

        public Builder<T> setUserAgent(@NotNull String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @NotNull
        public T create() {
            return RestClient.createProxy(this.cls, new RestInvocationHandler(this.cls, this.uri, this.gson, this.resolver, this.userAgent));
        }
    }

    static class RestInvocationHandler
    extends HttpTransportInvocationHandler {
        private final RestEndpointResolver resolver;

        RestInvocationHandler(@NotNull Class<?> clientClass, @NotNull URI uri, @NotNull Gson gson, @NotNull RestEndpointResolver resolver, @NotNull String userAgent) {
            super(clientClass, uri, gson, userAgent);
            this.resolver = resolver;
        }

        @Override
        protected String invokeRemoteMethod(@NotNull Method method, @Nullable RequestMapping mapping, @NotNull Map<String, JsonElement> values) {
            try {
                String endpoint;
                String string = endpoint = mapping == null ? null : mapping.value();
                if (CommonUtils.isEmpty(endpoint)) {
                    endpoint = this.resolver.generateEndpointName(method.getName());
                }
                StringBuilder url = new StringBuilder();
                url.append(this.uri);
                if (url.charAt(url.length() - 1) != '/') {
                    url.append('/');
                }
                url.append(endpoint);
                String requestString = this.gson.toJson(values);
                return super.invokeRemoteMethodOverHttp(URI.create(url.toString()), requestString, mapping);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RpcException(e);
            }
        }
    }
}

