/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSVisibilityScopeProvider;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public class SQLQueryDataSourceContext
extends SQLQueryDataContext {
    private static final Log log = Log.getLog(SQLQueryDataSourceContext.class);
    @NotNull
    private final SQLDialect dialect;
    @NotNull
    private final DBCExecutionContext executionContext;
    @NotNull
    private final SQLIdentifierDetector identifierDetector;
    @NotNull
    private final Map<String, SQLQueryResultPseudoColumn> globalPseudoColumnsByCanonicalName;
    @NotNull
    private final Function<SQLQueryRowsSourceModel, List<SQLQueryResultPseudoColumn>> rowsetPseudoColumnsProvider;

    public SQLQueryDataSourceContext(@NotNull SQLDialect dialect, @NotNull DBCExecutionContext executionContext, @NotNull Map<String, SQLQueryResultPseudoColumn> globalPseudoColumns, @NotNull Function<SQLQueryRowsSourceModel, List<SQLQueryResultPseudoColumn>> rowsetPseudoColumnsProvider) {
        this.dialect = dialect;
        this.executionContext = executionContext;
        this.identifierDetector = new SQLIdentifierDetector(dialect);
        this.globalPseudoColumnsByCanonicalName = globalPseudoColumns;
        this.rowsetPseudoColumnsProvider = rowsetPseudoColumnsProvider;
    }

    @Override
    @NotNull
    public List<SQLQueryResultColumn> getColumnsList() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasUnresolvedSource() {
        return false;
    }

    @Override
    @NotNull
    public List<SQLQueryResultPseudoColumn> getPseudoColumnsList() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public DBSEntity findRealTable(@NotNull DBRProgressMonitor monitor, @NotNull List<String> tableName) {
        DBSTable dBSTable;
        DBSObject obj = SQLQueryDataSourceContext.expandAliases(monitor, this.findRealObjectImpl(monitor, tableName));
        if (obj instanceof DBSTable) {
            DBSTable table;
            dBSTable = table = (DBSTable)obj;
        } else if (obj instanceof DBSView) {
            DBSView view = (DBSView)obj;
            dBSTable = view;
        } else {
            dBSTable = null;
        }
        return dBSTable;
    }

    @Override
    @Nullable
    public DBSObject findRealObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectType objectType, @NotNull List<String> objectName) {
        DBSObject obj = this.findRealObjectImpl(monitor, objectName);
        return obj != null && objectType.getTypeClass().isInstance(obj) ? obj : null;
    }

    @Nullable
    private DBSObject findRealObjectImpl(@NotNull DBRProgressMonitor monitor, @NotNull List<String> objectName) {
        DBPDataSource dBPDataSource = this.executionContext.getDataSource();
        if (dBPDataSource instanceof DBSObjectContainer) {
            DBSObjectContainer container = (DBSObjectContainer)dBPDataSource;
            DBSObject obj = SQLSearchUtils.findObjectByFQN(monitor, container, this.executionContext, objectName, false, this.identifierDetector);
            if (obj == null) {
                DBSVisibilityScopeProvider contextScope;
                DBPDataSource dBPDataSource2;
                DBSVisibilityScopeProvider scopeProvider;
                DBSVisibilityScopeProvider currentScope;
                DBSObject dBSObject = DBUtils.getSelectedObject((DBCExecutionContext)this.executionContext);
                Object object = dBSObject instanceof DBSVisibilityScopeProvider ? (currentScope = (DBSVisibilityScopeProvider)dBSObject) : (scopeProvider = (dBPDataSource2 = this.executionContext.getDataSource()) instanceof DBSVisibilityScopeProvider ? (contextScope = (DBSVisibilityScopeProvider)dBPDataSource2) : null);
                if (scopeProvider != null) {
                    try {
                        for (DBSObjectContainer scope : scopeProvider.getPublicScopes(monitor)) {
                            obj = SQLSearchUtils.findObjectByFQN(monitor, scope, this.executionContext, objectName, false, this.identifierDetector);
                            if (obj == null) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (DBException e) {
                        String name = String.join((CharSequence)Character.toString(this.executionContext.getDataSource().getSQLDialect().getStructSeparator()), objectName);
                        log.error((Object)("Failed to resolve real database object " + name), (Throwable)e);
                    }
                }
            }
            return obj;
        }
        throw new UnsupportedOperationException("Semantic analyser should never be used for databases, which doesn't support table lookup");
    }

    @Nullable
    public static DBSObject expandAliases(@NotNull DBRProgressMonitor monitor, @Nullable DBSObject obj) {
        while (obj instanceof DBSAlias) {
            DBSAlias aliasObject = (DBSAlias)obj;
            try {
                obj = aliasObject.getTargetObject(monitor);
            }
            catch (DBException e) {
                obj = null;
                log.debug((Object)("Can't resolve target object for alias '" + aliasObject.getName() + "'"), (Throwable)e);
            }
        }
        return obj;
    }

    @Override
    @Nullable
    public SQLQueryRowsSourceModel findRealSource(@NotNull DBSEntity table) {
        return null;
    }

    @Override
    @Nullable
    public SQLQueryResultColumn resolveColumn(@NotNull DBRProgressMonitor monitor, @NotNull String simpleName) {
        return null;
    }

    @Override
    @Nullable
    public SQLQueryResultPseudoColumn resolvePseudoColumn(@NotNull DBRProgressMonitor monitor, @NotNull String name) {
        return null;
    }

    @Override
    @Nullable
    public SQLQueryResultPseudoColumn resolveGlobalPseudoColumn(@NotNull DBRProgressMonitor monitor, @NotNull String name) {
        return this.globalPseudoColumnsByCanonicalName.get(name);
    }

    @Override
    @NotNull
    public SQLDialect getDialect() {
        return this.dialect;
    }

    @Override
    protected void collectKnownSourcesImpl(@NotNull SQLQueryDataContext.KnownSourcesInfo result) {
    }

    @Override
    protected List<SQLQueryResultPseudoColumn> prepareRowsetPseudoColumns(@NotNull SQLQueryRowsSourceModel source) {
        return this.rowsetPseudoColumnsProvider.apply(source);
    }
}

