/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnConstraintKind;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnConstraintSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryColumnSpec
extends SQLQueryNodeModel {
    private static final Map<String, SQLQueryColumnConstraintKind> constraintKindByNodeName = Map.of(STMKnownRuleNames.columnConstraintNotNull, SQLQueryColumnConstraintKind.NOT_NULL, STMKnownRuleNames.columnConstraintUnique, SQLQueryColumnConstraintKind.UNIQUE, STMKnownRuleNames.columnConstraintPrimaryKey, SQLQueryColumnConstraintKind.PRIMARY_KEY, STMKnownRuleNames.referencesSpecification, SQLQueryColumnConstraintKind.REFERENCES, STMKnownRuleNames.checkConstraintDefinition, SQLQueryColumnConstraintKind.CHECK);
    @Nullable
    private final SQLQuerySymbolEntry columnName;
    @Nullable
    private final String typeName;
    @Nullable
    private final SQLQueryValueExpression defaultValueExpression;
    @NotNull
    private final List<SQLQueryColumnConstraintSpec> constraints;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$semantics$model$ddl$SQLQueryColumnConstraintKind;

    public SQLQueryColumnSpec(@NotNull STMTreeNode syntaxNode, @Nullable SQLQuerySymbolEntry columnName, @Nullable String typeName, @Nullable SQLQueryValueExpression defaultValueExpression, @NotNull List<SQLQueryColumnConstraintSpec> constraints) {
        super(syntaxNode.getRealInterval(), syntaxNode, defaultValueExpression);
        this.columnName = columnName;
        this.typeName = typeName;
        this.defaultValueExpression = defaultValueExpression;
        this.constraints = List.copyOf(constraints);
        this.constraints.forEach(this::registerSubnode);
    }

    @Nullable
    public SQLQuerySymbolEntry getColumnName() {
        return this.columnName;
    }

    @Nullable
    public String getTypeName() {
        return this.typeName;
    }

    public SQLQueryExprType getDeclaredColumnType() {
        return this.typeName != null ? SQLQueryExprType.forExplicitTypeRef(this.typeName) : SQLQueryExprType.UNKNOWN;
    }

    @Nullable
    public SQLQueryValueExpression getDefaultValueExpression() {
        return this.defaultValueExpression;
    }

    @NotNull
    public List<SQLQueryColumnConstraintSpec> getConstraints() {
        return this.constraints;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, T arg) {
        return visitor.visitColumnSpec(this, arg);
    }

    @Override
    @Nullable
    public SQLQueryDataContext getGivenDataContext() {
        return null;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getResultDataContext() {
        return null;
    }

    public void propagateContext(@NotNull SQLQueryDataContext dataContext, @Nullable SQLQueryDataContext tableContext, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.defaultValueExpression != null && tableContext != null) {
            this.defaultValueExpression.propagateContext(tableContext, statistics);
        }
        for (SQLQueryColumnConstraintSpec constraintSpec : this.constraints) {
            constraintSpec.propagateContext(dataContext, tableContext, statistics);
        }
    }

    public static SQLQueryColumnSpec recognize(SQLQueryModelRecognizer recognizer, STMTreeNode node) {
        SQLQuerySymbolEntry columnName = Optional.ofNullable(node.findFirstChildOfName(STMKnownRuleNames.columnName)).map(n -> recognizer.collectIdentifier((STMTreeNode)n, null)).orElse(null);
        String typeName = Optional.ofNullable(node.findFirstChildOfName(STMKnownRuleNames.dataType)).map(STMTreeNode::getTextContent).orElse(null);
        STMTreeNode defaultValueNode = node.findFirstChildOfName(STMKnownRuleNames.defaultClause);
        SQLQueryValueExpression defaultValueExpr = defaultValueNode == null ? null : recognizer.collectValueExpression(defaultValueNode);
        LinkedList<SQLQueryColumnConstraintSpec> constraints = new LinkedList<SQLQueryColumnConstraintSpec>();
        for (STMTreeNode subnode : node.findChildrenOfName(STMKnownRuleNames.columnConstraintDefinition)) {
            SQLQueryColumnConstraintKind constraintKind;
            SQLQueryValueExpression checkExpression;
            List<SQLQuerySymbolEntry> referencedColumns;
            SQLQueryRowsTableDataModel referencedTable;
            SQLQueryQualifiedName constraintName;
            block8: {
                block7: {
                    constraintName = Optional.ofNullable(subnode.findFirstChildOfName(STMKnownRuleNames.constraintNameDefinition)).map(n -> n.findFirstChildOfName(STMKnownRuleNames.constraintName)).map(recognizer::collectQualifiedName).orElse(null);
                    STMTreeNode constraintNode = Optional.ofNullable(subnode.findFirstChildOfName(STMKnownRuleNames.columnConstraint)).map(STMTreeNode::findFirstNonErrorChild).orElse(null);
                    referencedTable = null;
                    referencedColumns = null;
                    checkExpression = null;
                    if (constraintNode == null) break block7;
                    constraintKind = constraintKindByNodeName.get(constraintNode.getNodeName());
                    switch (SQLQueryColumnSpec.$SWITCH_TABLE$org$jkiss$dbeaver$model$sql$semantics$model$ddl$SQLQueryColumnConstraintKind()[constraintKind.ordinal()]) {
                        case 6: {
                            checkExpression = recognizer.collectValueExpression(constraintNode);
                            break;
                        }
                        case 5: {
                            STMTreeNode refNode = constraintNode.findFirstChildOfName(STMKnownRuleNames.referencedTableAndColumns);
                            if (refNode == null) break block8;
                            referencedTable = recognizer.collectTableReference(refNode, true);
                            referencedColumns = recognizer.collectColumnNameList(refNode);
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block8;
                }
                constraintKind = SQLQueryColumnConstraintKind.UNKNOWN;
            }
            constraints.addLast(new SQLQueryColumnConstraintSpec(subnode, constraintName, constraintKind, referencedTable, referencedColumns, checkExpression));
        }
        return new SQLQueryColumnSpec(node, columnName, typeName, defaultValueExpr, constraints);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$semantics$model$ddl$SQLQueryColumnConstraintKind() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$model$sql$semantics$model$ddl$SQLQueryColumnConstraintKind != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$semantics$model$ddl$SQLQueryColumnConstraintKind;
        }
        int[] nArray = new int[SQLQueryColumnConstraintKind.values().length];
        try {
            nArray[SQLQueryColumnConstraintKind.CHECK.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLQueryColumnConstraintKind.NOT_NULL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLQueryColumnConstraintKind.PRIMARY_KEY.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLQueryColumnConstraintKind.REFERENCES.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLQueryColumnConstraintKind.UNIQUE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLQueryColumnConstraintKind.UNKNOWN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$semantics$model$ddl$SQLQueryColumnConstraintKind = nArray;
        return nArray;
    }
}

