/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.ui.views;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.db2.ui.internal.DB2Messages;
import org.jkiss.dbeaver.ext.db2.ui.views.DB2ConnectionTracePage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class DB2ConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private Text urlText;
    private Text hostText;
    private Text portText;
    private Text dbText;
    private Image logoImage = this.createImage("icons/db2_logo.png");
    private boolean activated = false;

    public void dispose() {
        super.dispose();
        UIUtils.dispose((Resource)this.logoImage);
    }

    public Image getImage() {
        return this.logoImage;
    }

    public void createControl(Composite composite) {
        Composite control = new Composite(composite, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.updateUrl();
                this.site.updateButtons();
            }
        };
        Group addrGroup = UIUtils.createControlGroup((Composite)control, (String)DB2Messages.db2_connection_page_tab_database, (int)4, (int)0, (int)0);
        GridData gd = new GridData(768);
        addrGroup.setLayoutData((Object)gd);
        SelectionAdapter typeSwitcher = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DB2ConnectionPage.this.setupConnectionModeSelection(DB2ConnectionPage.this.urlText, DB2ConnectionPage.this.typeURLRadio.getSelection(), GROUP_CONNECTION_ARR);
                DB2ConnectionPage.this.updateUrl();
            }
        };
        this.createConnectionModeSwitcher((Composite)addrGroup, (SelectionListener)typeSwitcher);
        UIUtils.createControlLabel((Composite)addrGroup, (String)UIConnectionMessages.dialog_connection_url_label);
        this.urlText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 355;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(e -> this.site.updateButtons());
        Label hostLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)DB2Messages.dialog_connection_host);
        hostLabel.setLayoutData((Object)new GridData(128));
        this.addControlToGroup("connection", new Control[]{hostLabel});
        this.hostText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        this.addControlToGroup("connection", new Control[]{this.hostText});
        Label portLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)DB2Messages.dialog_connection_port);
        gd = new GridData(128);
        portLabel.setLayoutData((Object)gd);
        this.addControlToGroup("connection", new Control[]{portLabel});
        this.portText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 7;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        this.addControlToGroup("connection", new Control[]{this.portText});
        Label dbLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)DB2Messages.dialog_connection_database);
        dbLabel.setLayoutData((Object)new GridData(128));
        this.addControlToGroup("connection", new Control[]{dbLabel});
        this.dbText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gd);
        this.dbText.addModifyListener(textListener);
        this.addControlToGroup("connection", new Control[]{this.dbText});
        this.createAuthPanel(control, 1);
        this.createDriverPanel(control);
        this.setControl((Control)control);
    }

    private void updateUrl() {
        DBPDataSourceContainer dataSourceContainer = this.site.getActiveDataSource();
        this.saveSettings(dataSourceContainer);
        if (this.typeURLRadio != null && this.typeURLRadio.getSelection()) {
            this.urlText.setText(dataSourceContainer.getConnectionConfiguration().getUrl());
        } else {
            this.urlText.setText(dataSourceContainer.getDriver().getConnectionURL(this.site.getActiveDataSource().getConnectionConfiguration()));
        }
    }

    public boolean isComplete() {
        if (this.isCustomURL()) {
            return !CommonUtils.isEmpty((String)this.urlText.getText());
        }
        return super.isComplete() && this.hostText != null && this.portText != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && !CommonUtils.isEmpty((String)this.portText.getText());
    }

    public void loadSettings() {
        boolean useURL;
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            this.dbText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        }
        boolean bl = useURL = connectionInfo.getConfigurationType() == DBPDriverConfigurationType.URL;
        if (useURL) {
            this.urlText.setText(connectionInfo.getUrl());
        }
        this.setupConnectionModeSelection(this.urlText, useURL, GROUP_CONNECTION_ARR);
        this.updateUrl();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.typeURLRadio != null) {
            connectionInfo.setConfigurationType(this.typeURLRadio.getSelection() ? DBPDriverConfigurationType.URL : DBPDriverConfigurationType.MANUAL);
        }
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.typeURLRadio != null && this.typeURLRadio.getSelection()) {
            connectionInfo.setUrl(this.urlText.getText());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DB2ConnectionTracePage(), new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

