#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.1
visibility:           public
id:                   dhall-1.42.1-ENQZU5dKM836nOYKzh8Y6r
key:                  dhall-1.42.1-ENQZU5dKM836nOYKzh8Y6r
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  2d1d856fa129a967cc9c15e99ed39345
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.1-ENQZU5dKM836nOYKzh8Y6r
depends:
    Diff-0.4.1-JbQUqnXfeqaHNgX8BS5WU4
    aeson-2.1.2.1-GOr0sGsn8HVJzt9KhewtB0
    aeson-pretty-0.8.10-D5Th2sszhWWBt58oyBlAJB
    ansi-terminal-1.0.2-D46JaHr1BfPBLAK7nuv4I
    atomic-write-0.2.1.1-FNgLWz4aKbuFPyQmRP1Vbz base-4.17.2.1
    base16-bytestring-1.0.2.0-48ZRmm275Sv4uBxPoXHzXc
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-9695IAuXzI9BpRD3yNxY1D
    cborg-0.2.9.0-2ftoRnkyfN9DucT8CXe52r
    cborg-json-0.2.6.0-EpXnJZ6IVF4Ig4HRW4tWF containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-LxkqDAWqoenIwR9LbNlmYw
    data-fix-0.3.3-5pLCRgeyFsi655zIxn2R2V deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.2-6pxn4ZHF0O12s0wetU12Eh exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.2-J5HquvW2LnR2EpOpKNsOXP
    hashable-1.4.4.0-HA5jWeGkLE053htWZjUgjX haskeline-0.8.2
    http-client-0.7.18-16GRXSx1Un6FZdK2reCcpV
    http-client-tls-0.3.6.4-Cju796GoKjr7Bhv1tci6Mi
    http-types-0.12.4-8b2vqk4ytrNGMVbZZ8fq7J
    indexed-traversable-0.1.4-6KK4zTGU8Qr6m89IZg6q2E
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-747qApo3GKN165PbKLSk2e
    mmorph-1.2.0-3nIz0RIlBAUER45blfkK28 mtl-2.2.2
    network-uri-2.6.4.2-2Sr7Eg9Bhz3KcJ8Mdx9CYP
    optparse-applicative-0.17.1.0-CKO7Hv5HIMoIThZFruc57S
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-DfRfqmZz0sv2HVy3TA2skx
    pretty-simple-4.1.3.0-LbgWnolD8n2JAsBmbFK90v
    prettyprinter-1.7.1-2SyS45w2YIjHD6NDr8Zx1B
    prettyprinter-ansi-terminal-1.1.3-1dwjtSDumlJADFnP6ZWFZ
    profunctors-5.6.2-8zaE9IJQG71fFASFxR2Ae
    repline-0.4.2.0-KVntTSpWnVfIRYxV1mly8a
    scientific-0.3.7.0-6O6FbUTzbTcBhAh2dckDIt
    serialise-0.2.6.1-JWhZNJz9bNEkSiqEdk12Q template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-90c57sbTt4xFNfqIldCX7D
    text-short-0.1.6-DFy7kIIkCnA3mhKjYr8Fzb
    th-lift-instances-0.1.20-1OWXekdNbvTIRn0Qsm884a time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.3-GKrDUqCOM7qIZhM6rNxdwj
    unordered-containers-0.2.20-Jl6TkouWI2i1D1jczNV0uv
    vector-0.13.2.0-F0gUvA5SUIr11j4RVHYOTP

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

