/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.factory;

import java.awt.Component;
import java.awt.Font;
import java.net.URL;
import java.util.WeakHashMap;
import javax.swing.Icon;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.svgicons.FreeplaneIconFactory;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconFactory;
import org.freeplane.features.icon.factory.WeakValueCache;

class GraphicIconFactory
implements IconFactory {
    private static final String SVG_EXT = ".svg";
    private static final String SVG_EXT_WITH_QUERY = ".svg?useAccentColor=true";
    private static final String DEFAULT_IMAGE_PATH = "/images/";
    static final IconFactory FACTORY = new GraphicIconFactory();
    private static final Icon ICON_NOT_FOUND = FACTORY.getIcon(ResourceController.getResourceController().getResource("/images/IconNotFound.svg"));
    private final WeakValueCache<String, Icon> ICON_CACHE = new WeakValueCache();
    private final WeakHashMap<Icon, URL> ICON_URLS = new WeakHashMap();

    private GraphicIconFactory() {
    }

    @Override
    public Icon getIcon(UIIcon uiIcon) {
        return this.getIcon(uiIcon.getUrl(), (Quantity<LengthUnit>)DEFAULT_UI_ICON_HEIGTH);
    }

    @Override
    public Icon getIcon(URL url) {
        return this.getIcon(url, (Quantity<LengthUnit>)DEFAULT_UI_ICON_HEIGTH);
    }

    private String createCacheKey(URL url, int heightPixels) {
        return url.toString() + "#" + heightPixels;
    }

    @Override
    public Icon getIcon(UIIcon uiIcon, Quantity<LengthUnit> iconHeight) {
        return this.getIcon(uiIcon.getUrl(), iconHeight);
    }

    @Override
    public Icon getIcon(URL url, Quantity<LengthUnit> iconHeight) {
        Icon result = ICON_NOT_FOUND;
        if (url != null) {
            int heightPixels = iconHeight.toBaseUnitsRounded();
            String cacheKey = this.createCacheKey(url, heightPixels);
            if (this.ICON_CACHE.containsKey(cacheKey)) {
                result = this.ICON_CACHE.get(cacheKey);
            } else {
                String path = url.getPath();
                result = path.endsWith(SVG_EXT) || path.endsWith(SVG_EXT_WITH_QUERY) ? FreeplaneIconFactory.createSVGIcon(url, heightPixels) : FreeplaneIconFactory.createIconPrivileged(url);
                this.ICON_CACHE.put(cacheKey, result);
                this.registerIcon(result, url);
            }
        }
        return result;
    }

    @Override
    public void registerIcon(Icon icon, URL url) {
        this.ICON_URLS.put(icon, url);
    }

    @Override
    public boolean canScaleIcon(Icon icon) {
        return this.ICON_URLS.containsKey(icon);
    }

    @Override
    public Icon getScaledIcon(Icon icon, Quantity<LengthUnit> iconHeight) {
        if (iconHeight.toBaseUnitsRounded() == icon.getIconHeight()) {
            return icon;
        }
        URL iconUrl = this.ICON_URLS.get(icon);
        if (iconUrl != null) {
            return this.getIcon(iconUrl, iconHeight);
        }
        throw new IllegalArgumentException("unknown icon");
    }

    @Override
    public Icon getScaledIcon(Icon icon, Component component) {
        if (!this.canScaleIcon(icon)) {
            return icon;
        }
        Font font = component.getFont();
        int fontHeight = component.getFontMetrics(font).getHeight();
        Quantity iconHeight = new Quantity((double)fontHeight, (Enum)LengthUnit.px);
        Icon scaledIcon = this.getScaledIcon(icon, (Quantity<LengthUnit>)iconHeight);
        return scaledIcon;
    }
}

