/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.ui;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatLaf;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.ContainerComboBoxEditor;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.resizer.UIComponentVisibilityDispatcher;
import org.freeplane.core.ui.flatlaf.NonSelectingFlatEditorPaneUI;
import org.freeplane.core.util.ClassLoaderFactory;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.format.FormattedObject;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.StyleString;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.features.time.TimeComboBoxEditor;
import org.freeplane.features.ui.CheckIconWithBorder;
import org.freeplane.features.ui.EventQueueExecutorServiceAdapter;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.OSKeyBindingManager;
import org.freeplane.features.ui.ToggleFullScreenAction;
import org.freeplane.features.ui.ToggleMapOverviewAction;
import org.freeplane.features.ui.ToggleMenubarAction;
import org.freeplane.features.ui.ToggleScrollbarsAction;
import org.freeplane.features.ui.ToggleToolbarAction;
import org.freeplane.features.ui.ViewController;

public abstract class FrameController
implements ViewController {
    public static final String VAQUA_LAF_NAME = "VAqua";
    public static final String VAQUA_LAF_CLASS_NAME = "org.violetlib.aqua.AquaLookAndFeel";
    private static final String DARCULA_LAF_CLASS_NAME = "com.bulenkov.darcula.DarculaLaf";
    private static final double DEFAULT_SCALING_FACTOR = 0.8;
    private static final String MENU_ITEM_FONT_SIZE_PROPERTY = "menuItemFontSize";
    protected final Controller controller;
    private final JLabel status;
    private final Map<String, Component> statusInfos;
    private final JPanel statusPanel;
    private final JComponent[] toolbarPanel;
    private final String propertyKeyPrefix;
    private static boolean uiResourcesInitialized = false;
    private static Icon textIcon;
    private static Icon numberIcon;
    private static Icon dateIcon;
    private static Icon dateTimeIcon;
    private static Icon linkIcon;
    private static Icon unknownTypeIcon;
    private final IMapViewManager mapViewManager;
    private final Timer statusTextCleaner;

    private static void initializeUiResources() {
        if (!uiResourcesInitialized) {
            uiResourcesInitialized = true;
            ResourceController resourceController = ResourceController.getResourceController();
            textIcon = resourceController.getIcon("text_icon");
            numberIcon = resourceController.getIcon("number_icon");
            dateIcon = resourceController.getIcon("date_icon");
            dateTimeIcon = resourceController.getIcon("date_time_icon");
            linkIcon = resourceController.getIcon("link_icon");
            unknownTypeIcon = resourceController.getIcon("unknown_type_icon");
        }
    }

    public FrameController(Controller controller, IMapViewManager mapViewManager, String propertyKeyPrefix) {
        this.controller = controller;
        this.mapViewManager = mapViewManager;
        this.propertyKeyPrefix = propertyKeyPrefix;
        this.statusPanel = new JPanel(new FlowLayout(0, 3, 0));
        UIComponentVisibilityDispatcher.install(this.statusPanel, propertyKeyPrefix + "statusVisible");
        this.status = new JLabel();
        this.status.setBorder(BorderFactory.createEtchedBorder());
        this.statusPanel.add(this.status);
        this.statusInfos = new HashMap<String, Component>();
        this.statusInfos.put("standard", this.status);
        this.statusTextCleaner = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameController.this.status.setVisible(false);
                FrameController.this.status.setText(null);
            }
        });
        this.statusTextCleaner.setRepeats(false);
        controller.setViewController(this);
        controller.addAction(new ToggleFullScreenAction(this));
        controller.addAction(new ToggleMenubarAction(this));
        controller.addAction(new ToggleScrollbarsAction(this));
        controller.addAction(new ToggleMapOverviewAction(this));
        controller.addAction(new ToggleToolbarAction("ToggleToolbarAction", "/main_toolbar"));
        controller.addAction(new ToggleToolbarAction("ToggleStatusAction", "/status"));
        this.addStatusInfo("ObjectType", null, null);
        this.toolbarPanel = new JComponent[4];
        this.toolbarPanel[0] = new HorizontalToolbarPanel(new FlowLayout(0, 0, 0));
        this.toolbarPanel[3] = Box.createVerticalBox();
        this.toolbarPanel[1] = Box.createHorizontalBox();
        this.toolbarPanel[2] = Box.createVerticalBox();
    }

    @Override
    public void changeNoteWindowLocation() {
    }

    @Override
    public void err(String msg) {
        this.status.setText(msg);
    }

    protected Controller getController() {
        return Controller.getCurrentController();
    }

    @Override
    public abstract FreeplaneMenuBar getFreeplaneMenuBar();

    @Override
    public JComponent getStatusBar() {
        return this.statusPanel;
    }

    @Override
    public void init(Controller controller) {
        FrameController.initializeUiResources();
        JComponent mainContentPane = this.getMainContentPane();
        mainContentPane.add((Component)this.toolbarPanel[0], "North");
        mainContentPane.add((Component)this.toolbarPanel[1], "West");
        mainContentPane.add((Component)this.toolbarPanel[2], "East");
        mainContentPane.add((Component)this.toolbarPanel[3], "South");
        this.status.setText("");
        this.status.setVisible(false);
        mainContentPane.getRootPane().putClientProperty(Controller.class, controller);
    }

    private JComponent getMainContentPane() {
        return (JComponent)((RootPaneContainer)((Object)this.getMenuComponent())).getContentPane();
    }

    @Override
    public abstract void insertComponentIntoSplitPane(JComponent var1);

    @Override
    public boolean isMenubarVisible() {
        return this.isComponentVisible("menubar");
    }

    @Override
    public boolean isMapOverviewVisible() {
        return this.isComponentVisible("mapOverview");
    }

    @Override
    public boolean areScrollbarsVisible() {
        return this.isComponentVisible("scrollbars");
    }

    private boolean isComponentVisible(String component) {
        String property = this.isMenuComponentInFullScreenMode() ? component + "Visible.fullscreen" : component + "Visible";
        boolean booleanProperty = ResourceController.getResourceController().getBooleanProperty(this.propertyKeyPrefix + property);
        return booleanProperty;
    }

    protected boolean isMenuComponentInFullScreenMode() {
        return this.isFullScreenEnabled(this.getMenuComponent());
    }

    @Override
    public boolean isFullScreenEnabled() {
        return this.isFullScreenEnabled(this.getCurrentRootComponent());
    }

    boolean isFullScreenEnabled(Component component) {
        if (component instanceof JFrame) {
            JRootPane rootPane = ((JFrame)component).getRootPane();
            return rootPane != null && Boolean.TRUE.equals(rootPane.getClientProperty("fullscreen_enabled"));
        }
        return false;
    }

    @Override
    public abstract void openDocument(Hyperlink var1) throws IOException;

    @Override
    public abstract void openDocument(URL var1) throws Exception;

    @Override
    public void out(String msg) {
        this.status.setText(msg);
        this.status.setVisible(msg != null && !msg.isEmpty());
        this.statusTextCleaner.restart();
    }

    @Override
    public void addStatusInfo(String key, String info) {
        this.addStatusInfo(key, info, null, null);
    }

    @Override
    public void addStatusInfo(String key, Icon icon) {
        this.addStatusInfo(key, null, icon, null);
    }

    @Override
    public void addStatusInfo(String key, String info, Icon icon) {
        this.addStatusInfo(key, info, icon, null);
    }

    @Override
    public void addStatusInfo(String key, String info, Icon icon, String tooltip) {
        JLabel label = (JLabel)this.statusInfos.get(key);
        if (label == null) {
            label = new JLabel(info);
            label.setBorder(BorderFactory.createEtchedBorder());
            this.statusInfos.put(key, label);
            this.statusPanel.add((Component)label, this.statusPanel.getComponentCount() - 1);
        } else {
            label.setText(info);
            label.revalidate();
            label.repaint();
        }
        label.setIcon(icon);
        label.setToolTipText(tooltip);
        label.setVisible(info != null && !info.isEmpty() || icon != null);
    }

    @Override
    public void addStatusComponent(String key, Component component) {
        Component oldComponent = this.statusInfos.put(key, component);
        if (oldComponent == null) {
            this.statusPanel.add(component, this.statusPanel.getComponentCount() - 1);
        } else {
            int index = UITools.getComponentIndex(oldComponent);
            this.transferFocusFrom(oldComponent);
            this.statusPanel.remove(index);
            this.statusPanel.add(component, index);
        }
        this.statusPanel.revalidate();
        this.statusPanel.repaint();
    }

    private void transferFocusFrom(Component oldComponent) {
        Component selectedComponent;
        if (oldComponent.hasFocus() && (selectedComponent = this.mapViewManager.getSelectedComponent()) != null) {
            selectedComponent.requestFocusInWindow();
        }
    }

    @Override
    public void removeStatus(String key) {
        Component oldComponent = this.statusInfos.remove(key);
        if (oldComponent == null) {
            return;
        }
        this.transferFocusFrom(oldComponent);
        this.statusPanel.remove(oldComponent);
        this.statusPanel.revalidate();
        this.statusPanel.repaint();
    }

    @Override
    public abstract void removeSplitPane();

    @Override
    public void saveProperties() {
    }

    @Override
    public void selectMode(ModeController oldModeController, ModeController newModeController) {
        int j;
        if (oldModeController == newModeController) {
            return;
        }
        if (oldModeController != null) {
            IUserInputListenerFactory userInputListenerFactory = oldModeController.getUserInputListenerFactory();
            for (j = 0; j < 4; ++j) {
                Iterable<JComponent> modeToolBars = userInputListenerFactory.getToolBars(j);
                if (modeToolBars == null) continue;
                for (Component component : modeToolBars) {
                    this.toolbarPanel[j].remove(component);
                }
                this.toolbarPanel[j].revalidate();
            }
        }
        IUserInputListenerFactory newUserInputListenerFactory = newModeController.getUserInputListenerFactory();
        for (j = 0; j < 4; ++j) {
            Iterable<JComponent> newToolBars = newUserInputListenerFactory.getToolBars(j);
            if (newToolBars == null) continue;
            int i = 0;
            for (JComponent toolBar : newToolBars) {
                UIComponentVisibilityDispatcher dispatcher = UIComponentVisibilityDispatcher.of(toolBar);
                if (dispatcher != null) {
                    dispatcher.resetVisible();
                }
                this.toolbarPanel[j].add((Component)toolBar, i++);
            }
            this.toolbarPanel[j].revalidate();
            this.toolbarPanel[j].repaint();
        }
        this.setFreeplaneMenuBar(newUserInputListenerFactory.getMenuBar());
        this.setUIComponentsVisible(newModeController.getController().getMapViewManager(), this.isMenubarVisible());
    }

    private void setUIComponentsVisible(IMapViewManager iMapViewManager, boolean visible) {
        this.setMenubarVisible(visible);
    }

    protected abstract void setFreeplaneMenuBar(FreeplaneMenuBar var1);

    @Override
    public void setMenubarVisible(boolean visible) {
        this.setComponentVisibleProperty("menubar", visible);
        FreeplaneMenuBar freeplaneMenuBar = this.getFreeplaneMenuBar();
        ((Component)freeplaneMenuBar).setVisible(visible);
    }

    @Override
    public void setMapOverviewVisible(boolean visible) {
        this.setComponentVisibleProperty("mapOverview", visible);
    }

    @Override
    public void setScrollbarsVisible(boolean visible) {
        this.setComponentVisibleProperty("scrollbars", visible);
    }

    private void setComponentVisibleProperty(String componentName, boolean visible) {
        String property = this.isMenuComponentInFullScreenMode() ? componentName + "Visible.fullscreen" : componentName + "Visible";
        ResourceController.getResourceController().setProperty(this.propertyKeyPrefix + property, visible);
    }

    @Override
    public abstract void setTitle(String var1);

    @Override
    public abstract void setWaitingCursor(boolean var1);

    @Override
    public void viewNumberChanged(int number) {
    }

    public void setFullScreen(boolean fullScreen) {
        if (fullScreen == this.isFullScreenEnabled()) {
            return;
        }
        JFrame frame = (JFrame)this.getCurrentRootComponent();
        if (Compat.isMacOsX()) {
            this.setFullScreenOnMac(fullScreen, frame);
        } else {
            this.setFullScreenOnNonMac(frame, fullScreen);
        }
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    private void setFullScreenOnMac(boolean fullScreen, JFrame frame) {
        Compat.setFullScreenOnMac(frame, fullScreen);
        if (Boolean.valueOf(fullScreen).equals(frame.getRootPane().getClientProperty("fullscreen_enabled"))) {
            ResourceController.getResourceController().firePropertyChanged("fullscreen_enabled", Boolean.toString(fullScreen), Boolean.toString(!fullScreen));
            Controller controller = this.getController();
            for (int j = 0; j < 4; ++j) {
                Iterable<JComponent> toolBars = controller.getModeController().getUserInputListenerFactory().getToolBars(j);
                for (JComponent toolBar : toolBars) {
                    UIComponentVisibilityDispatcher.of(toolBar).resetVisible();
                }
            }
        }
    }

    private void setFullScreenOnNonMac(JFrame frame, boolean fullScreen) {
        frame.getRootPane().putClientProperty("fullscreen_enabled", fullScreen);
        ResourceController.getResourceController().firePropertyChanged("fullscreen_enabled", Boolean.toString(!fullScreen), Boolean.toString(fullScreen));
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        ToolTipManager.sharedInstance().setEnabled(false);
        Controller controller = this.getController();
        Collection<Window> visibleFrames = this.collectVisibleFrames(frame);
        if (fullScreen) {
            GraphicsConfiguration graphicsConfiguration = frame.getGraphicsConfiguration();
            Rectangle bounds = graphicsConfiguration.getBounds();
            frame.getRootPane().putClientProperty(FrameState.class, new FrameState(frame.getBounds(), frame.getExtendedState()));
            frame.getExtendedState();
            frame.dispose();
            frame.setExtendedState(6);
            frame.setBounds(bounds);
            frame.setUndecorated(true);
            if (Compat.isWindowsOS()) {
                frame.setResizable(false);
            }
            this.setUIComponentsVisible(controller.getMapViewManager(), this.isMenubarVisible());
            for (int j = 0; j < 4; ++j) {
                Iterable<JComponent> toolBars = controller.getModeController().getUserInputListenerFactory().getToolBars(j);
                for (JComponent toolBar : toolBars) {
                    UIComponentVisibilityDispatcher.of(toolBar).resetVisible();
                }
            }
            this.showWindows(visibleFrames);
        } else {
            frame.dispose();
            frame.setUndecorated(false);
            if (Compat.isWindowsOS()) {
                frame.setResizable(false);
            }
            frame.setResizable(true);
            FrameState frameState = (FrameState)frame.getRootPane().getClientProperty(FrameState.class);
            frame.setBounds(frameState.bounds);
            frame.setExtendedState(frameState.winState);
            this.setUIComponentsVisible(controller.getMapViewManager(), this.isMenubarVisible());
            for (int j = 0; j < 4; ++j) {
                Iterable<JComponent> toolBars = controller.getModeController().getUserInputListenerFactory().getToolBars(j);
                for (JComponent toolBar : toolBars) {
                    UIComponentVisibilityDispatcher.of(toolBar).resetVisible();
                }
            }
            this.showWindows(visibleFrames);
        }
        if (focusOwner != null) {
            focusOwner.requestFocus();
        }
    }

    private Collection<Window> collectVisibleFrames(Window window) {
        if (!window.isVisible()) {
            return Collections.emptyList();
        }
        Window[] ownedWindows = window.getOwnedWindows();
        ArrayList<Window> visibleWindows = new ArrayList<Window>(ownedWindows.length + 1);
        visibleWindows.add(window);
        for (Window child : ownedWindows) {
            visibleWindows.addAll(this.collectVisibleFrames(child));
        }
        return visibleWindows;
    }

    protected void showWindows(Iterable<Window> windows) {
        for (Window child : windows) {
            child.setVisible(true);
        }
    }

    public static void setLookAndFeel(String lookAndFeel) {
        block11: {
            if (DARCULA_LAF_CLASS_NAME.equals(lookAndFeel)) {
                FrameController.setLookAndFeel(FlatDarculaLaf.class.getName());
                return;
            }
            try {
                if (Compat.isMacOsX()) {
                    try {
                        FrameController.class.getClassLoader().loadClass(VAQUA_LAF_CLASS_NAME);
                        UIManager.installLookAndFeel(VAQUA_LAF_NAME, VAQUA_LAF_CLASS_NAME);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (lookAndFeel.equals("default")) {
                    String lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
                    UIManager.setLookAndFeel(lookAndFeelClassName);
                    break block11;
                }
                UIManager.LookAndFeelInfo[] lafInfos = UIManager.getInstalledLookAndFeels();
                boolean lookAndFeelSet = false;
                for (UIManager.LookAndFeelInfo lafInfo : lafInfos) {
                    if (!lafInfo.getName().equalsIgnoreCase(lookAndFeel) && !lafInfo.getClassName().equalsIgnoreCase(lookAndFeel)) continue;
                    String lookAndFeelClassName = lafInfo.getClassName();
                    lookAndFeelSet = FrameController.tryToSetLookAndFeel(lookAndFeelClassName);
                    break;
                }
                if (lookAndFeelSet) break block11;
                URLClassLoader userLibClassLoader = ClassLoaderFactory.getClassLoaderForUserLib();
                try {
                    Class<?> lookAndFeelClass = userLibClassLoader.loadClass(lookAndFeel);
                    ClassLoader uiClassLoader = lookAndFeelClass.getClassLoader();
                    UIManager.getDefaults().put("ClassLoader", uiClassLoader);
                    UIManager.setLookAndFeel((LookAndFeel)lookAndFeelClass.newInstance());
                    if (userLibClassLoader != uiClassLoader) {
                        userLibClassLoader.close();
                    }
                }
                catch (ClassCastException | ClassNotFoundException | InstantiationException e) {
                    LogUtils.warn("Error while setting Look&Feel" + lookAndFeel + ", reverted to default");
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    Controller.getCurrentController().getResourceController().setProperty("lookandfeel", "default");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LogUtils.warn("Error while setting Look&Feel" + lookAndFeel);
            }
        }
    }

    private static void fixLookAndFeelUI() {
        OSKeyBindingManager.applyToCurrentLookAndFeel();
        FrameController.configureFlatLookAndFeel();
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        UIManager.put("ComboBox.squareButton", Boolean.FALSE);
        ResourceController resourceController = ResourceController.getResourceController();
        if (!resourceController.getBooleanProperty("hugeFontsFixed2", false)) {
            resourceController.getProperties().remove("hugeFontsFixed");
            if ("100".equals(resourceController.getProperties().get(MENU_ITEM_FONT_SIZE_PROPERTY))) {
                resourceController.getProperties().remove(MENU_ITEM_FONT_SIZE_PROPERTY);
            }
            resourceController.setProperty("hugeFontsFixed2", true);
            resourceController.saveProperties();
        }
        int lookAndFeelDefaultMenuItemFontSize = FrameController.obtainLookAndFeelDefaultMenuItemFontSize();
        int defaultMenuItemSize = (int)Math.round((double)lookAndFeelDefaultMenuItemFontSize * 0.8);
        resourceController.setDefaultProperty(MENU_ITEM_FONT_SIZE_PROPERTY, Long.toString(defaultMenuItemSize));
        int userDefinedMenuItemFontSize = resourceController.getIntProperty(MENU_ITEM_FONT_SIZE_PROPERTY, defaultMenuItemSize);
        double scalingFactor = (double)userDefinedMenuItemFontSize / (double)lookAndFeelDefaultMenuItemFontSize;
        FrameController.scaleDefaultUIFonts(scalingFactor);
        Object checkIcon = UIManager.getDefaults().get("CheckBoxMenuItem.checkIcon");
        if (checkIcon instanceof Icon) {
            int checkIconHeight = new Quantity((double)(userDefinedMenuItemFontSize * 2 / 3), (Enum)LengthUnit.pt).toBaseUnitsRounded();
            UIManager.getDefaults().remove("CheckBoxMenuItem.checkIcon");
            UIManager.put("CheckBoxMenuItem.checkIcon", new CheckIconWithBorder((Icon)checkIcon, checkIconHeight, (int)(0.5 + 1.5 * (double)UITools.FONT_SCALE_FACTOR)));
        }
        Dimension minimumThumbSize = new Dimension(30, 30);
        UIManager.getDefaults().put("ScrollBar.minimumThumbSize", minimumThumbSize);
        UIManager.put("ScrollBar.minimumThumbSize", minimumThumbSize);
        UIManager.put("FileChooser.useSystemExtensionHiding", false);
        Color color = UIManager.getColor("control");
        if (color != null && color.getAlpha() < 255) {
            UIManager.getDefaults().put("control", Color.LIGHT_GRAY);
        }
    }

    private static int obtainLookAndFeelDefaultMenuItemFontSize() {
        String[] fontsProperties;
        for (String fontProperty : fontsProperties = new String[]{"MenuItem.font", "defaultFont"}) {
            UIManager.put(fontProperty, null);
            Font font = UIManager.getDefaults().getFont(fontProperty);
            if (font == null) continue;
            return font.getSize();
        }
        return 12;
    }

    private static boolean tryToSetLookAndFeel(String lafClassName) {
        try {
            UIManager.setLookAndFeel(lafClassName);
            return true;
        }
        catch (Exception exception) {
            try {
                Class<?> lookAndFeelClass = FrameController.class.getClassLoader().loadClass(lafClassName);
                LookAndFeel lookAndFeelInstance = (LookAndFeel)lookAndFeelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                UIManager.setLookAndFeel(lookAndFeelInstance);
                return true;
            }
            catch (Exception exception2) {
                return false;
            }
        }
    }

    private static void configureFlatLookAndFeel() {
        if (Compat.isApplet()) {
            return;
        }
        if (UIManager.getLookAndFeel() instanceof FlatLaf) {
            UIManager.put("TableHeader.height", 2);
            UIManager.put("Table.showHorizontalLines", true);
            UIManager.put("Table.showVerticalLines", true);
            UIManager.put("ComboBox.minimumWidth", 2);
            UIManager.put("TabbedPane.tabsOverlapBorder", false);
            UIManager.put("TabbedPane.rotateTabRuns", false);
            UIManager.put("EditorPaneUI", NonSelectingFlatEditorPaneUI.class.getName());
        } else if (NonSelectingFlatEditorPaneUI.class.getName().equals(UIManager.get("EditorPaneUI"))) {
            UIManager.put("EditorPaneUI", BasicEditorPaneUI.class.getName());
        }
    }

    private static void scaleDefaultUIFonts(double scalingFactor) {
        Object[] keys;
        UIDefaults uiDefaults = UIManager.getDefaults();
        UIDefaults lookAndFeelDefaults = UIManager.getLookAndFeel().getDefaults();
        boolean shouldUseWorkaroundForJava11 = Compat.isJavaVersionLessThan("15.");
        Set keySet = (shouldUseWorkaroundForJava11 ? lookAndFeelDefaults : uiDefaults).keySet();
        IdentityHashMap scaledFonts = new IdentityHashMap();
        for (Object key : keys = keySet.toArray(new Object[keySet.size()])) {
            if (!FrameController.isFontKey(key)) continue;
            UIManager.put(key, null);
            Font font = uiDefaults.getFont(key);
            if (font == null || scaledFonts.containsKey(font)) continue;
            font = UITools.scaleFontInt(font, scalingFactor);
            lookAndFeelDefaults.put(key, font);
            uiDefaults.put(key, font);
            UIManager.put(key, font);
            scaledFonts.put(font, null);
        }
    }

    private static boolean isFontKey(Object key) {
        return key != null && key.toString().toLowerCase().endsWith("font");
    }

    @Override
    public void addObjectTypeInfo(Object value) {
        if (value instanceof FormattedObject) {
            value = ((FormattedObject)value).getObject();
        }
        if (value instanceof String || value instanceof StyleTranslatedObject || value instanceof StyleString) {
            this.addStatusInfo("ObjectType", null, textIcon);
        } else if (value instanceof FormattedDate) {
            FormattedDate fd = (FormattedDate)value;
            if (fd.containsTime()) {
                this.addStatusInfo("ObjectType", null, dateTimeIcon);
            } else {
                this.addStatusInfo("ObjectType", null, dateIcon);
            }
        } else if (value instanceof Number) {
            this.addStatusInfo("ObjectType", null, numberIcon);
        } else if (value instanceof Hyperlink || value instanceof URI) {
            this.addStatusInfo("ObjectType", null, linkIcon);
        } else {
            this.addStatusInfo("ObjectType", null, unknownTypeIcon);
        }
    }

    public static ComboBoxEditor getTextDateTimeEditor() {
        ContainerComboBoxEditor editor = new ContainerComboBoxEditor();
        TranslatedObject keyText = new TranslatedObject("text", "1Ab");
        FixedBasicComboBoxEditor textEditor = new FixedBasicComboBoxEditor(){
            private Object oldItem;

            @Override
            public void setItem(Object object) {
                this.oldItem = object;
                if (object instanceof FormattedDate) {
                    super.setItem("");
                } else {
                    super.setItem(object);
                }
            }

            @Override
            public Object getItem() {
                Object item = super.getItem();
                Object oldItem = this.oldItem;
                this.oldItem = null;
                if (item != null && oldItem != null && item.toString().equals(oldItem.toString())) {
                    return oldItem;
                }
                if (ResourceController.getResourceController().getBooleanProperty("parse_data") && item instanceof String) {
                    Object scannedObject = ScannerController.getController().parse((String)item);
                    return scannedObject;
                }
                return item;
            }
        };
        editor.put(keyText, textEditor);
        TranslatedObject keyDate = new TranslatedObject("date", "");
        keyDate.setIcon(dateIcon);
        TimeComboBoxEditor dateComboBoxEditor = new TimeComboBoxEditor(false){

            @Override
            public void setItem(Object object) {
                if (object instanceof FormattedDate && !((FormattedDate)object).containsTime()) {
                    super.setItem(object);
                } else {
                    super.setItem(null);
                }
            }
        };
        dateComboBoxEditor.setItem();
        editor.put(keyDate, dateComboBoxEditor);
        TranslatedObject keyDateTime = new TranslatedObject("date_time", "");
        keyDateTime.setIcon(dateTimeIcon);
        TimeComboBoxEditor dateTimeComboBoxEditor = new TimeComboBoxEditor(true){

            @Override
            public void setItem(Object object) {
                if (object instanceof FormattedDate && ((FormattedDate)object).containsTime()) {
                    super.setItem(object);
                } else {
                    super.setItem(null);
                }
            }
        };
        dateTimeComboBoxEditor.setItem();
        editor.put(keyDateTime, dateTimeComboBoxEditor);
        return editor;
    }

    @Override
    public boolean quit() {
        JComponent mapViewComponent = this.mapViewManager.getMapViewComponent();
        boolean allMapsSaved = this.mapViewManager.saveAllModifiedMaps();
        this.mapViewManager.changeToMapView(mapViewComponent);
        return allMapsSaved;
    }

    @Override
    public boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public ExecutorService getMainThreadExecutorService() {
        return EventQueueExecutorServiceAdapter.INSTANCE;
    }

    @Override
    public void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    @Override
    public void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        StaticInvoker.invokeAndWait(runnable);
    }

    @Override
    public List<? extends Component> getMapViewVector() {
        return this.mapViewManager.getMapViews();
    }

    static {
        UIManager.getInstalledLookAndFeels();
        OSKeyBindingManager.initialize();
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("lookAndFeel")) {
                    FrameController.fixLookAndFeelUI();
                }
            }
        });
    }

    private final class HorizontalToolbarPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private HorizontalToolbarPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public void validateTree() {
            if (!this.isValid()) {
                super.validateTree();
                this.resizeToolbarPane();
            }
        }

        private void resizeToolbarPane() {
            if (this.getWidth() == 0) {
                return;
            }
            Dimension oldPreferredSize = this.getPreferredSize();
            int maxHeight = 0;
            for (Component component : this.getComponents()) {
                if (!component.isVisible()) continue;
                maxHeight = Math.max(maxHeight, component.getY() + component.getHeight());
            }
            Dimension preferredSize = maxHeight > 0 ? new Dimension(this.getWidth(), maxHeight) : new Dimension(0, 0);
            if (oldPreferredSize.height != preferredSize.height) {
                this.setPreferredSize(preferredSize);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HorizontalToolbarPanel.this.getParent().invalidate();
                        FrameController.this.getMainContentPane().revalidate();
                    }
                });
            }
        }
    }

    static class FrameState {
        final Rectangle bounds;
        final int winState;

        public FrameState(Rectangle bounds, int winState) {
            this.bounds = bounds;
            this.winState = winState;
        }
    }

    private static class StaticInvoker {
        private StaticInvoker() {
        }

        private static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
    }
}

