/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import org.freeplane.api.ChildNodesAlignment;
import org.freeplane.api.ChildrenSides;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryLevels;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.view.swing.map.CloudHeightCalculator;
import org.freeplane.view.swing.map.ContentSizeCalculator;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.NodeViewLayoutHelper;

class VerticalNodeViewLayoutStrategy {
    private static boolean wrongChildComponentsReported = false;
    private int childViewCount;
    private final int spaceAround;
    private final NodeViewLayoutHelper view;
    private final int[] xCoordinates;
    private final int[] yCoordinates;
    private final boolean[] isChildFreeNode;
    private SummaryLevels viewLevels;
    private int top;
    private boolean rightSideCoordinatesAreSet;
    private boolean leftSideCoordinaresAreSet;
    private final boolean allowsCompactLayout;
    private final int defaultVGap;
    private final Dimension contentSize;

    public VerticalNodeViewLayoutStrategy(NodeView view, boolean allowsCompactLayout) {
        NodeViewLayoutHelper layoutHelper;
        this.view = layoutHelper = view.getLayoutHelper();
        this.contentSize = ContentSizeCalculator.INSTANCE.calculateContentSize(layoutHelper);
        this.childViewCount = view.getComponentCount() - 1;
        this.layoutChildViews(view);
        this.top = 0;
        this.rightSideCoordinatesAreSet = false;
        this.leftSideCoordinaresAreSet = false;
        this.xCoordinates = new int[this.childViewCount];
        this.yCoordinates = new int[this.childViewCount];
        this.isChildFreeNode = new boolean[this.childViewCount];
        this.spaceAround = view.getSpaceAround();
        this.defaultVGap = view.getMap().getZoomed(LocationModel.DEFAULT_VGAP.toBaseUnits());
        this.allowsCompactLayout = allowsCompactLayout;
    }

    private void layoutChildViews(NodeView view) {
        for (int i = 0; i < this.childViewCount; ++i) {
            Component component = view.getComponent(i);
            if (component instanceof NodeView) {
                ((NodeView)component).validateTree();
                continue;
            }
            this.childViewCount = i;
            if (wrongChildComponentsReported) continue;
            wrongChildComponentsReported = true;
            String wrongChildComponents = Arrays.toString(view.getComponents());
            LogUtils.severe("Unexpected child components:" + wrongChildComponents, new Exception());
        }
    }

    private void setFreeChildNodes(boolean laysOutLeftSide) {
        for (int i = 0; i < this.childViewCount; ++i) {
            NodeViewLayoutHelper child = this.view.getComponent(i);
            if (child.isLeft() != laysOutLeftSide) continue;
            this.isChildFreeNode[i] = child.isFree();
        }
    }

    public void calculateLayoutData() {
        NodeModel node = this.view.getNode();
        MapView map = this.view.getMap();
        Filter filter = map.getFilter();
        NodeModel selectionRoot = map.getRoot().getNode();
        this.viewLevels = this.childViewCount == 0 ? SummaryLevels.ignoringChildNodes(selectionRoot, node, filter) : SummaryLevels.of(selectionRoot, node, filter);
        for (boolean isLeft : this.viewLevels.sides) {
            this.calculateLayoutData(isLeft);
        }
        this.applyLayoutToChildComponents();
    }

    private void calculateLayoutData(boolean isLeft) {
        this.setFreeChildNodes(isLeft);
        this.calculateLayoutY(isLeft);
        this.calculateLayoutX(isLeft);
    }

    private void calculateLayoutY(boolean laysOutLeftSide) {
        int minimalDistanceBetweenChildren = this.view.getMinimalDistanceBetweenChildren();
        ChildNodesAlignment childNodesAlignment = this.view.getChildNodesAlignment();
        int childContentHeightSum = 0;
        int top = 0;
        int level = this.viewLevels.highestSummaryLevel + 1;
        int y = 0;
        int vGap = 0;
        boolean isFirstVisibleLaidOutChild = true;
        int[] groupStartIndex = new int[level];
        int[] contentHeightSumAtGroupStart = new int[level];
        int[] groupUpperYCoordinate = new int[level];
        int[] groupLowerYCoordinate = new int[level];
        NodeViewLayoutHelper alignedChild = null;
        for (int childViewIndex = 0; childViewIndex < this.childViewCount; ++childViewIndex) {
            int childCloudHeigth;
            NodeViewLayoutHelper child = this.view.getComponent(childViewIndex);
            if (child.isLeft() != laysOutLeftSide) continue;
            int childHeight = child.getHeight() - 2 * this.spaceAround;
            int oldLevel = level;
            if (childViewIndex >= this.viewLevels.summaryLevels.length) {
                String errorMessage = "Bad node view child components: missing node for component " + childViewIndex;
                UITools.errorMessage(errorMessage);
                System.err.println(errorMessage);
                for (int i = 0; i < this.view.getComponentCount(); ++i) {
                    String component = this.view.describeComponent(i);
                    System.err.println(component);
                }
            }
            level = this.viewLevels.summaryLevels[childViewIndex];
            boolean isFreeNode = child.isFree();
            boolean isItem = level == 0;
            int childShiftY = this.calculateDistance(child, NodeViewLayoutHelper::getShift);
            if (isItem) {
                if (isFreeNode) {
                    this.yCoordinates[childViewIndex] = childShiftY - child.getContentY();
                } else {
                    int missingWidth;
                    int missingWidth2;
                    alignedChild = child;
                    int extraVGap = 0;
                    childCloudHeigth = CloudHeightCalculator.INSTANCE.getAdditionalCloudHeigth(child);
                    if (childHeight != 0) {
                        int childChildrenExtraHeight = childHeight - (child.getContentHeight() + childCloudHeigth);
                        if (childChildrenExtraHeight > 0) {
                            extraVGap = Math.min(childChildrenExtraHeight, this.calculateExtraGapForChildren(minimalDistanceBetweenChildren));
                        }
                        childContentHeightSum += vGap;
                        if (isFirstVisibleLaidOutChild && childNodesAlignment == ChildNodesAlignment.AFTER_PARENT && this.contentSize.height > 0) {
                            y += this.calculateAddedDistanceFromParentToChildren(minimalDistanceBetweenChildren, this.contentSize);
                        }
                    }
                    if (!isFirstVisibleLaidOutChild && child.paintsChildrenOnTheLeft() && this.view.usesHorizontalLayout() && (missingWidth2 = child.getMinimumDistanceConsideringHandles() - vGap - extraVGap) > 0) {
                        top -= missingWidth2;
                        y += missingWidth2;
                        childContentHeightSum += missingWidth2;
                    }
                    if ((childShiftY < 0 || isFirstVisibleLaidOutChild) && !this.allowsCompactLayout) {
                        top += childShiftY;
                    }
                    if (childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT || childNodesAlignment == ChildNodesAlignment.LAST_CHILD_BY_PARENT) {
                        top += -child.getHeight() + childCloudHeigth + 2 * this.spaceAround + child.getBottomOverlap() + child.getContentHeight();
                    } else if (childNodesAlignment == ChildNodesAlignment.BY_CENTER) {
                        top += -child.getHeight() / 2 + childCloudHeigth / 2 + this.spaceAround + child.getBottomOverlap() / 2 + child.getContentHeight() / 2;
                    } else if (childNodesAlignment == ChildNodesAlignment.FIRST_CHILD_BY_PARENT && isFirstVisibleLaidOutChild) {
                        top += -(child.getContentY() - this.spaceAround);
                    } else if (childNodesAlignment != ChildNodesAlignment.AFTER_PARENT && childNodesAlignment != ChildNodesAlignment.FIRST_CHILD_BY_PARENT) {
                        top += -(child.getContentY() - childCloudHeigth / 2 - this.spaceAround);
                    }
                    top += child.getTopOverlap();
                    y -= child.getTopOverlap();
                    int upperGap = this.align(extraVGap);
                    if (!isFirstVisibleLaidOutChild) {
                        top -= upperGap;
                        y += upperGap;
                    }
                    if (childShiftY < 0 && !this.allowsCompactLayout) {
                        this.yCoordinates[childViewIndex] = y;
                        y -= childShiftY;
                    } else {
                        if (!isFirstVisibleLaidOutChild || this.allowsCompactLayout) {
                            y += childShiftY;
                        }
                        this.yCoordinates[childViewIndex] = y;
                    }
                    int summaryNodeIndex = this.viewLevels.findSummaryNodeIndex(childViewIndex);
                    if (summaryNodeIndex == -1 || summaryNodeIndex - 1 == childViewIndex) {
                        vGap = minimalDistanceBetweenChildren;
                    } else if (childHeight != 0) {
                        vGap = this.summarizedNodeDistance(minimalDistanceBetweenChildren);
                    }
                    if (!child.paintsChildrenOnTheLeft() && this.view.usesHorizontalLayout() && (missingWidth = child.getMinimumDistanceConsideringHandles() - vGap - extraVGap) > 0) {
                        y += missingWidth;
                        if (!isFirstVisibleLaidOutChild) {
                            childContentHeightSum += missingWidth;
                        }
                    }
                    y += extraVGap - upperGap;
                    if (childHeight != 0) {
                        y += childHeight + vGap - child.getBottomOverlap();
                    }
                    childContentHeightSum += child.getContentHeight() + childCloudHeigth;
                    if (oldLevel > 0) {
                        for (int j = 0; j < oldLevel; ++j) {
                            groupStartIndex[j] = childViewIndex;
                            groupUpperYCoordinate[j] = Integer.MAX_VALUE;
                            groupLowerYCoordinate[j] = Integer.MIN_VALUE;
                            contentHeightSumAtGroupStart[j] = childContentHeightSum;
                        }
                    } else if (child.isFirstGroupNode()) {
                        contentHeightSumAtGroupStart[0] = childContentHeightSum;
                        groupStartIndex[0] = childViewIndex;
                    }
                    if (childHeight != 0) {
                        isFirstVisibleLaidOutChild = false;
                    }
                }
            } else {
                int summaryY;
                int itemLevel = level - 1;
                if (child.isFirstGroupNode()) {
                    contentHeightSumAtGroupStart[level] = contentHeightSumAtGroupStart[itemLevel];
                    groupStartIndex[level] = groupStartIndex[itemLevel];
                }
                if (groupUpperYCoordinate[itemLevel] == Integer.MAX_VALUE) {
                    groupUpperYCoordinate[itemLevel] = y;
                    groupLowerYCoordinate[itemLevel] = y;
                }
                childCloudHeigth = CloudHeightCalculator.INSTANCE.getAdditionalCloudHeigth(child);
                int childContentHeight = child.getContentHeight() + childCloudHeigth;
                this.yCoordinates[childViewIndex] = summaryY = (groupUpperYCoordinate[itemLevel] + groupLowerYCoordinate[itemLevel]) / 2 - childContentHeight / 2 + childShiftY - (child.getContentYForSummary() - childCloudHeigth / 2 - this.spaceAround);
                if (!isFreeNode) {
                    int deltaY = summaryY - groupUpperYCoordinate[itemLevel] + child.getTopOverlap();
                    if (deltaY < 0) {
                        top += deltaY;
                        y -= deltaY;
                        summaryY -= deltaY;
                        for (int j = groupStartIndex[itemLevel]; j <= childViewIndex; ++j) {
                            NodeViewLayoutHelper groupItem = this.view.getComponent(j);
                            if (groupItem.isLeft() != laysOutLeftSide || this.viewLevels.summaryLevels[j] <= 0 && this.isChildFreeNode[j]) continue;
                            int n = j;
                            this.yCoordinates[n] = this.yCoordinates[n] - deltaY;
                        }
                    }
                    if (childHeight != 0) {
                        summaryY += childHeight + minimalDistanceBetweenChildren - child.getBottomOverlap();
                    }
                    y = Math.max(y, summaryY);
                }
            }
            if (isItem && isFreeNode) continue;
            int childUpperCoordinate = this.yCoordinates[childViewIndex] + child.getTopOverlap();
            int childBottomCoordinate = this.yCoordinates[childViewIndex] + childHeight - child.getBottomOverlap();
            if (child.isFirstGroupNode()) {
                if (isItem) {
                    groupUpperYCoordinate[level] = Integer.MAX_VALUE;
                    groupLowerYCoordinate[level] = Integer.MIN_VALUE;
                    continue;
                }
                groupUpperYCoordinate[level] = childUpperCoordinate;
                groupLowerYCoordinate[level] = childBottomCoordinate;
                continue;
            }
            if (childHeight == 0 && !this.isNextNodeSummaryNode(childViewIndex)) continue;
            groupUpperYCoordinate[level] = Math.min(groupUpperYCoordinate[level], childUpperCoordinate);
            groupLowerYCoordinate[level] = Math.max(childBottomCoordinate, groupLowerYCoordinate[level]);
        }
        if (childNodesAlignment == ChildNodesAlignment.LAST_CHILD_BY_PARENT && alignedChild != null) {
            top += alignedChild.getHeight() - (alignedChild.getContentY() + alignedChild.getContentHeight() + this.spaceAround + alignedChild.getBottomOverlap());
        }
        top += this.align(this.contentSize.height - childContentHeightSum);
        if (childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT && this.contentSize.height > 0 && !isFirstVisibleLaidOutChild) {
            top -= this.calculateAddedDistanceFromParentToChildren(minimalDistanceBetweenChildren, this.contentSize);
        }
        this.calculateRelativeCoordinatesForContentAndBothSides(laysOutLeftSide, top);
    }

    private int calculateAddedDistanceFromParentToChildren(int minimalDistance, Dimension contentSize) {
        boolean usesHorizontalLayout = this.view.usesHorizontalLayout();
        int distance = Math.max(this.view.getMap().getZoomed(usesHorizontalLayout ? LocationModel.DEFAULT_VGAP_PX * 2 : LocationModel.DEFAULT_VGAP_PX), minimalDistance);
        return contentSize.height + distance;
    }

    private int calculateExtraGapForChildren(int minimalDistanceBetweenChildren) {
        if (3 * this.defaultVGap > minimalDistanceBetweenChildren) {
            return minimalDistanceBetweenChildren + 2 * this.defaultVGap;
        }
        return (minimalDistanceBetweenChildren + 22 * this.defaultVGap) / 6;
    }

    private int align(int height) {
        ChildNodesAlignment childNodesAlignment = this.view.getChildNodesAlignment();
        int deltaTop = this.view.isSummary() || childNodesAlignment == ChildNodesAlignment.NOT_SET || childNodesAlignment == ChildNodesAlignment.BY_CENTER || childNodesAlignment == ChildNodesAlignment.FLOW ? height / 2 : (childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT || childNodesAlignment == ChildNodesAlignment.LAST_CHILD_BY_PARENT ? height : 0);
        return deltaTop;
    }

    private int calculateDistance(NodeViewLayoutHelper child, ToIntFunction<NodeViewLayoutHelper> nodeDistance) {
        if (!child.isContentVisible()) {
            return 0;
        }
        int shift = nodeDistance.applyAsInt(child);
        for (NodeViewLayoutHelper ancestor = child.getParentView(); ancestor != null && !ancestor.isContentVisible(); ancestor = ancestor.getParentView()) {
            if (!ancestor.isFree()) continue;
            shift += nodeDistance.applyAsInt(ancestor);
        }
        return shift;
    }

    private boolean isNextNodeSummaryNode(int childViewIndex) {
        return childViewIndex + 1 < this.viewLevels.summaryLevels.length && this.viewLevels.summaryLevels[childViewIndex + 1] > 0;
    }

    private int summarizedNodeDistance(int distance) {
        if (this.defaultVGap >= distance) {
            return distance;
        }
        return this.defaultVGap + (distance - this.defaultVGap) / 6;
    }

    private void calculateLayoutX(boolean laysOutLeftSide) {
        int baseDistanceToChildren = this.view.getBaseDistanceToChildren();
        int level = this.viewLevels.highestSummaryLevel + 1;
        int[] summaryBaseX = new int[level];
        ChildNodesAlignment childNodesAlignment = this.view.getChildNodesAlignment();
        boolean areChildrenSeparatedByY = childNodesAlignment.isStacked();
        for (int i = 0; i < this.childViewCount; ++i) {
            int x;
            boolean isItem;
            NodeViewLayoutHelper child = this.view.getComponent(i);
            if (child.isLeft() != laysOutLeftSide) continue;
            int oldLevel = level;
            level = this.viewLevels.summaryLevels[i];
            boolean isFreeNode = child.isFree();
            boolean bl = isItem = level == 0;
            int childHGap = child.isContentVisible() ? this.calculateDistance(child, NodeViewLayoutHelper::getHGap) : (child.isSummary() ? child.getZoomed(LocationModel.DEFAULT_HGAP_PX * 7 / 12) : 0);
            if (this.view.getNode().isHiddenSummary() && !child.getNode().isHiddenSummary()) {
                childHGap -= child.getZoomed(LocationModel.DEFAULT_HGAP_PX * 7 / 12);
            }
            if (isItem && !isFreeNode && child.isSubtreeVisible()) {
                childHGap += baseDistanceToChildren;
            }
            if (isItem) {
                if (!isFreeNode && (oldLevel > 0 || child.isFirstGroupNode())) {
                    summaryBaseX[0] = 0;
                }
            } else if (child.isFirstGroupNode()) {
                summaryBaseX[level] = 0;
            }
            int baseX = level > 0 ? summaryBaseX[level - 1] : (isItem && areChildrenSeparatedByY && this.view.childrenSides() == ChildrenSides.BOTH_SIDES ? this.contentSize.width / 2 : (child.isLeft() != (isItem && (isFreeNode || areChildrenSeparatedByY)) ? 0 : this.contentSize.width));
            if (child.isLeft()) {
                x = baseX - childHGap - child.getContentX() - child.getContentWidth();
                summaryBaseX[level] = Math.min(summaryBaseX[level], x + this.spaceAround);
            } else {
                x = baseX + childHGap - child.getContentX();
                summaryBaseX[level] = Math.max(summaryBaseX[level], x + child.getWidth() - this.spaceAround);
            }
            this.xCoordinates[i] = x;
        }
    }

    private void calculateRelativeCoordinatesForContentAndBothSides(boolean isLeft, int topOnSide) {
        if (!this.leftSideCoordinaresAreSet && !this.rightSideCoordinatesAreSet) {
            this.top = topOnSide;
        } else {
            boolean changeLeft;
            int deltaTop = topOnSide - this.top;
            if (deltaTop < 0) {
                this.top = topOnSide;
                changeLeft = !isLeft;
                deltaTop = -deltaTop;
            } else {
                changeLeft = isLeft;
            }
            for (int i = 0; i < this.childViewCount; ++i) {
                NodeViewLayoutHelper child = this.view.getComponent(i);
                if (child.isLeft() != changeLeft || this.viewLevels.summaryLevels[i] <= 0 && this.isChildFreeNode[i]) continue;
                int n = i;
                this.yCoordinates[n] = this.yCoordinates[n] + deltaTop;
            }
        }
        if (isLeft) {
            this.leftSideCoordinaresAreSet = true;
        } else {
            this.rightSideCoordinatesAreSet = true;
        }
    }

    private void applyLayoutToChildComponents() {
        int spaceAround = this.view.getSpaceAround();
        int left = IntStream.of(this.xCoordinates).min().orElse(0);
        int contentX = Math.max(spaceAround, -left);
        int cloudHeight = CloudHeightCalculator.INSTANCE.getAdditionalCloudHeigth(this.view);
        int contentY = spaceAround + cloudHeight / 2 - Math.min(0, this.top);
        this.view.setContentVisible(this.view.isContentVisible());
        int baseY = contentY - spaceAround + this.top;
        int minY = 0;
        for (int i = 0; i < this.childViewCount; ++i) {
            minY = this.viewLevels.summaryLevels[i] == 0 && this.isChildFreeNode[i] ? Math.min(minY, contentY + this.yCoordinates[i] - cloudHeight / 2) : Math.min(minY, baseY + this.yCoordinates[i]);
        }
        if (minY < 0) {
            contentY -= minY;
            baseY -= minY;
        }
        int width = contentX + this.contentSize.width + spaceAround;
        int height = contentY + this.contentSize.height + cloudHeight / 2 + spaceAround;
        this.view.setContentBounds(contentX, contentY, this.contentSize.width, this.contentSize.height);
        int topOverlap = -minY;
        int heigthWithoutOverlap = height;
        for (int i = 0; i < this.childViewCount; ++i) {
            int y;
            NodeViewLayoutHelper child = this.view.getComponent(i);
            boolean isChildFreeNode = this.isChildFreeNode[i];
            if (this.viewLevels.summaryLevels[i] == 0 && isChildFreeNode) {
                y = contentY + this.yCoordinates[i];
            } else {
                y = baseY + this.yCoordinates[i];
                if (!this.isChildFreeNode[i]) {
                    heigthWithoutOverlap = Math.max(heigthWithoutOverlap, y + child.getHeight() + cloudHeight / 2 - child.getBottomOverlap());
                }
            }
            int x = contentX + this.xCoordinates[i];
            child.setLocation(x, y);
            width = Math.max(width, x + child.getWidth());
            height = Math.max(height, y + child.getHeight() + cloudHeight / 2);
        }
        this.view.setSize(width, height);
        this.view.setTopOverlap(topOverlap);
        this.view.setBottomOverlap(height - heigthWithoutOverlap);
    }
}

