/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.api.TextWritingDirection;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.TypedListCellRenderer;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeTableLayoutModel;
import org.freeplane.features.attribute.ColumnWidthChangeEvent;
import org.freeplane.features.attribute.IColumnWidthChangeListener;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.format.FormattedObject;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.ViewController;
import org.freeplane.view.swing.map.FreeplaneTooltip;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeTooltipManager;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.attribute.AttributeSelectionChangeListener;
import org.freeplane.view.swing.map.attribute.AttributeTableCellRenderer;
import org.freeplane.view.swing.map.attribute.AttributeTableModel;
import org.freeplane.view.swing.map.attribute.AttributeView;
import org.freeplane.view.swing.map.attribute.CursorUpdater;
import org.freeplane.view.swing.map.attribute.ExtendedAttributeTableModelDecorator;

class AttributeTable
extends JTable
implements IColumnWidthChangeListener {
    private static final String EDITING_STOPPED = AttributeTable.class.getName() + ".editingStopped";
    private static int CLICK_COUNT_TO_START = 2;
    private static AttributeSelectionChangeListener globalFocusChangeListener = new AttributeSelectionChangeListener();
    private static MouseListener componentListener;
    private static ComboBoxModel defaultComboBoxModel;
    private static AttributeTableCellRenderer dtcr;
    private static final int EXTRA_HEIGHT = 4;
    private static CursorUpdater cursorUpdater;
    private static final int MAX_HEIGTH = 600;
    private static final long serialVersionUID = 1L;
    private static final int CURSOR_WIDTH = 2;
    private final AttributeView attributeView;
    private int highRowIndex = 0;
    private static DefaultCellEditor dce;
    private static final Set<String> editingActions;
    private Color gridColor = null;
    private static ActionMap defaultParentActionMap;
    private static ActionMap newDefaultParentActionMap;

    public static AttributeTable getSelectedTable() {
        return AttributeTable.globalFocusChangeListener.selectedTable;
    }

    static ComboBoxModel getDefaultComboBoxModel() {
        if (defaultComboBoxModel == null) {
            defaultComboBoxModel = new DefaultComboBoxModel();
        }
        return defaultComboBoxModel;
    }

    AttributeTable(AttributeView attributeView) {
        this.attributeView = attributeView;
        this.initializeTooltipManager(attributeView);
        this.addMouseListener(cursorUpdater);
        this.addMouseMotionListener(cursorUpdater);
        if (attributeView.getMapView().getModeController().canEdit()) {
            this.tableHeader.addMouseListener(componentListener);
        } else {
            this.tableHeader.setResizingAllowed(false);
        }
        this.setModel(attributeView.getCurrentAttributeTableModel());
        this.setAutoResizeMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setCellSelectionEnabled(true);
        this.getSelectionModel().setSelectionMode(2);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        AttributeTable.adaptActionMap(this);
        this.setShowGrid(true);
    }

    private static void adaptActionMap(AttributeTable table) {
        InputMap ancestorInputMap = table.getInputMap(1);
        KeyStroke f2 = KeyStroke.getKeyStroke(113, 0);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        InputMap focusedComponentInputMap = table.getInputMap(0);
        Object editKey = ancestorInputMap.get(f2);
        focusedComponentInputMap.put(enter, editKey);
        ActionMap actionMap = table.getActionMap();
        if (defaultParentActionMap == null || defaultParentActionMap != actionMap.getParent()) {
            defaultParentActionMap = actionMap.getParent();
            newDefaultParentActionMap = new ActionMap(){

                @Override
                public Action get(Object key) {
                    if (editingActions.contains(key)) {
                        return null;
                    }
                    return super.get(key);
                }
            };
            newDefaultParentActionMap.setParent(defaultParentActionMap);
            EditCellAction action = new EditCellAction();
            newDefaultParentActionMap.put(editKey, action);
        }
        actionMap.setParent(newDefaultParentActionMap);
    }

    private void initializeTooltipManager(AttributeView attributeView) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.unregisterComponent(this);
        NodeTooltipManager.getSharedInstance(attributeView.getMapView().getModeController()).registerComponent(this);
    }

    @Override
    public void addNotify() {
        this.updateComponentFontAndColors(this);
        super.addNotify();
        this.adjustColumnWidthsIfItTableFitsContent();
    }

    private void adjustColumnWidthsIfItTableFitsContent() {
        NodeView nodeView = this.getNodeViewAncestor();
        if (nodeView == null) {
            return;
        }
        MapView mapView = nodeView.getMap();
        boolean attributeTableWidthFitsContent = this.attributeViewFitsContent(mapView);
        if (!attributeTableWidthFitsContent) {
            return;
        }
        this.adjustColumnWidths();
    }

    void adjustColumnWidths() {
        this.setOptimalColumnWidths(false);
    }

    private boolean attributeViewFitsContent(MapView mapView) {
        return MapStyleModel.getExtension(mapView.getMap()).getBooleanProperty("attribute_table_width_fits_content");
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new TableHeader(this.columnModel);
    }

    private void changeSelectedRowHeight(int rowIndex) {
        this.highRowIndex = rowIndex;
        this.updateRowHeights();
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return;
        }
        if (rowIndex >= rowCount) {
            rowIndex = 0;
            columnIndex = 0;
        }
        this.changeSelectedRowHeight(rowIndex);
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    @Override
    public void columnWidthChanged(ColumnWidthChangeEvent event) {
        float zoom = this.getZoom();
        int col = event.getColumnNumber();
        AttributeTableLayoutModel layoutModel = (AttributeTableLayoutModel)event.getSource();
        int width = layoutModel.getColumnWidth(col).toBaseUnitsRounded();
        this.getColumnModel().getColumn(col).setPreferredWidth((int)((float)width * zoom));
        MapView map = this.attributeView.getMapView();
        NodeModel node = this.attributeView.getNode();
        map.getModeController().getMapController().nodeChanged(node);
    }

    public AttributeTableModel getAttributeTableModel() {
        return (AttributeTableModel)this.getModel();
    }

    public AttributeView getAttributeView() {
        return this.attributeView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (this.isEditing() && this.getCellEditor() instanceof DialogTableCellEditor || !this.isCellEditable(e)) {
            return false;
        }
        if (column == 1 && e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            Object value = this.getValueAt(row, column);
            Hyperlink link = this.toHyperlink(value);
            if (link != null) {
                Icon linkIcon = this.getLinkIcon(link);
                int xmax = linkIcon != null ? linkIcon.getIconWidth() : 0;
                int x = me.getX() - this.getColumnModel().getColumn(0).getWidth();
                if (x < xmax) {
                    ModeController modeController = this.getModeController();
                    if (me.isShiftDown()) {
                        modeController.getMapController().forceViewChange(() -> LinkController.getController(modeController).loadURL(this.attributeView.getNode(), new ActionEvent(me.getSource(), me.getID(), null), link));
                    } else {
                        LinkController.getController(modeController).loadURL(this.attributeView.getNode(), new ActionEvent(me.getSource(), me.getID(), null), link);
                    }
                    return false;
                }
            }
        }
        this.putClientProperty("AttributeTable.EditEvent", e);
        try {
            if (super.editCellAt(row, column, e)) {
                TableCellEditor cellEditor = this.getCellEditor();
                if (this.isEditing() && cellEditor instanceof DialogTableCellEditor) {
                    ((JComponent)this.editorComp).paintImmediately(0, 0, this.editorComp.getWidth(), this.editorComp.getHeight());
                    ((DialogTableCellEditor)cellEditor).startEditing();
                } else {
                    Component editorComponent = this.getEditorComponent();
                    if (editorComponent instanceof JComboBox) {
                        this.startEditing(e, (JComboBox)editorComponent);
                    }
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.putClientProperty("AttributeTable.EditEvent", null);
        }
    }

    Hyperlink toHyperlink(Object value) {
        NodeModel node = this.attributeView.getNode();
        return this.getModeController().getExtension(TextController.class).toLink(value, node, NodeAttributeTableModel.getModel(node));
    }

    ModeController getModeController() {
        return this.attributeView.getMapView().getModeController();
    }

    private void startEditing(EventObject e, final JComboBox comboBox) {
        ComboBoxEditor editor = comboBox.getEditor();
        if (comboBox.isEditable()) {
            KeyEvent keyEvent;
            char keyChar;
            editor.selectAll();
            if (e instanceof KeyEvent && (keyChar = (keyEvent = (KeyEvent)e).getKeyChar()) != '\uffff') {
                KeyEvent keyTypedEvent = new KeyEvent(editor.getEditorComponent(), 400, keyEvent.getWhen(), keyEvent.getModifiers(), 0, keyChar, 0);
                SwingUtilities.processKeyBindings(keyTypedEvent);
            }
        } else {
            comboBox.requestFocusInWindow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    comboBox.showPopup();
                }
            });
        }
    }

    Icon getLinkIcon(Hyperlink link) {
        NodeModel nodeModel = ((AttributeTableModel)this.getModel()).getNode();
        Icon linkIcon = this.getAttributeView().getMapView().getModeController().getExtension(LinkController.class).getLinkIcon(link, nodeModel);
        return linkIcon;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        return this.getCellEditor(row, col, (EventObject)this.getClientProperty("AttributeTable.EditEvent"));
    }

    private boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= CLICK_COUNT_TO_START;
        }
        return true;
    }

    public TableCellEditor getCellEditor(int row, int col, EventObject e) {
        if (dce != null) {
            dce.stopCellEditing();
        }
        String valueForEdit = this.getValueForEdit(row, col);
        if (col == 1) {
            MTextController textController = (MTextController)TextController.getController(this.getModeController());
            textController.getEventQueue().setFirstEvent((InputEvent)(e instanceof KeyEvent ? (KeyEvent)e : null));
            AttributeTableModel model = (AttributeTableModel)this.getModel();
            DialogTableCellEditor dialogTableCellEditor = new DialogTableCellEditor();
            EditNodeBase base = textController.createContentSpecificEditor(model.getNode(), (Object)valueForEdit, (Object)model.getNodeAttributeModel(), dialogTableCellEditor.getEditControl(), false);
            if (base != null) {
                dialogTableCellEditor.setEditBase(base);
                return dialogTableCellEditor;
            }
        }
        if (valueForEdit.indexOf(10) >= 0) {
            return null;
        }
        if (dce == null) {
            JComboBox comboBox = new JComboBox(){
                private boolean layingOut;
                {
                    this.setMaximumRowCount(10);
                    this.layingOut = false;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e != null && e.getSource() == dce) {
                        super.actionPerformed(new ActionEvent(this.getEditor(), e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
                    } else {
                        super.actionPerformed(e);
                    }
                }

                @Override
                public void doLayout() {
                    try {
                        this.layingOut = true;
                        super.doLayout();
                    }
                    finally {
                        this.layingOut = false;
                    }
                }

                @Override
                public Dimension getSize() {
                    Dimension dim = super.getSize();
                    if (!this.layingOut) {
                        dim.width = Math.max(dim.width, this.getPreferredSize().width);
                    }
                    return dim;
                }
            };
            TypedListCellRenderer editorValueRenderer = new TypedListCellRenderer();
            editorValueRenderer.setCanRenderHeader(false);
            comboBox.setRenderer(editorValueRenderer);
            Component editorComponent = comboBox.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField) {
                BasicTextFieldUI textFieldUI = new BasicTextFieldUI();
                ((JTextField)editorComponent).setUI(textFieldUI);
            }
            dce = new DefaultCellEditor(comboBox){

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
                    return super.getTableCellEditorComponent(table, ((AttributeTable)table).getValueForEdit(row, col), isSelected, row, col);
                }
            };
            dce.setClickCountToStart(CLICK_COUNT_TO_START);
        }
        return dce;
    }

    private String getValueForEdit(int row, int col) {
        Object value = this.getValueAt(row, col);
        Object object = value instanceof IFormattedObject ? ((IFormattedObject)value).getObject() : value;
        return object == null ? "" : object.toString();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return dtcr;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (!this.isValid()) {
            this.validate();
        }
        Dimension dimension = super.getPreferredSize();
        NodeView nodeView = this.getNodeViewAncestor();
        if (nodeView != null) {
            MapView map = nodeView.getMap();
            ModeController modeController = map.getModeController();
            NodeStyleController nsc = NodeStyleController.getController(modeController);
            dimension.width = Math.min(map.getZoomed(nsc.getMaxWidth(nodeView.getNode(), nodeView.getStyleOption()).toBaseUnits()), dimension.width);
            dimension.height = Math.min(map.getZoomed(600) - this.getTableHeaderHeight(), dimension.height);
        }
        return dimension;
    }

    NodeView getNodeViewAncestor() {
        return (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, this);
    }

    int getTableHeaderHeight() {
        JTableHeader tableHeader = this.getTableHeader();
        return tableHeader != null ? tableHeader.getPreferredSize().height : 0;
    }

    float getZoom() {
        MapView mapView = this.attributeView.getMapView();
        if (SwingUtilities.isDescendingFrom(this, mapView)) {
            return mapView.getZoom();
        }
        return 1.0f;
    }

    public void insertRow(int row) {
        int actuallyInsertedRow = row;
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            if (this.isEditing()) {
                int editingRow = this.getEditingRow();
                int rowCount = this.getRowCount();
                if (!this.getCellEditor().stopCellEditing()) {
                    return;
                }
                int updatedRowCount = this.getRowCount();
                if (updatedRowCount < rowCount && row >= editingRow) {
                    --actuallyInsertedRow;
                }
            }
            this.insertRow(model, actuallyInsertedRow);
        }
    }

    private void insertRow(ExtendedAttributeTableModelDecorator model, int row) {
        model.insertRow(row);
        this.changeSelection(row, 0, false, false);
        if (this.editCellAt(row, 0)) {
            this.getEditorComponent().requestFocusInWindow();
        }
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.attributeView.areAttributesVisible();
    }

    public void moveRowDown(int row) {
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator && row < this.getRowCount() - 1) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            model.moveRowDown(row);
            this.changeSelection(row + 1, this.getSelectedColumn(), false, false);
        }
    }

    public void moveRowUp(int row) {
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator && row > 0) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            model.moveRowUp(row);
            this.changeSelection(row - 1, this.getSelectedColumn(), false, false);
        }
    }

    @Override
    public Component prepareEditor(TableCellEditor tce, int row, int col) {
        ComboBoxModel model;
        if (tce instanceof DialogTableCellEditor) {
            return super.prepareEditor(tce, row, col);
        }
        JComboBox comboBox = (JComboBox)((DefaultCellEditor)tce).getComponent();
        NodeModel node = this.getAttributeTableModel().getNode();
        AttributeRegistry attributes = AttributeRegistry.getRegistry(node.getMap());
        switch (col) {
            case 0: {
                model = attributes.getComboBoxModel();
                comboBox.setEditable(!attributes.isRestricted());
                break;
            }
            case 1: {
                String attrName = this.getAttributeTableModel().getValueAt(row, 0).toString();
                model = attributes.getDefaultComboBoxModel((Comparable<?>)((Object)attrName));
                comboBox.setEditable(!attributes.isRestricted(attrName));
                break;
            }
            default: {
                model = AttributeTable.getDefaultComboBoxModel();
            }
        }
        Object[] items = new Object[model.getSize()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = model.getElementAt(i);
        }
        DefaultComboBoxModel<Object> currentModel = new DefaultComboBoxModel<Object>(items);
        comboBox.setModel(currentModel);
        this.updateComponentFontAndColors(comboBox);
        JComponent editorComponent = (JComponent)comboBox.getEditor().getEditorComponent();
        this.updateComponentFontAndColors(editorComponent);
        editorComponent.setOpaque(true);
        Font font = editorComponent.getFont();
        editorComponent.setFont(font.deriveFont(font.getSize2D() * this.getZoom()));
        NodeView nodeView = this.getNodeViewAncestor();
        if (nodeView != null) {
            editorComponent.setComponentOrientation(nodeView.getMainView().getComponentOrientation());
        } else {
            TextWritingDirection textDirection = NodeStyleController.getController(Controller.getCurrentModeController()).getTextWritingDirection(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            editorComponent.setComponentOrientation(textDirection.componentOrientation);
        }
        return super.prepareEditor(tce, row, col);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Object value = this.getValueAt(row, column);
        boolean isSelected = false;
        boolean hasFocus = false;
        MapView map = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
        if (map == null || !map.isPrinting()) {
            isSelected = this.isCellSelected(row, column);
            boolean rowIsLead = this.selectionModel.getLeadSelectionIndex() == row;
            boolean colIsLead = this.columnModel.getSelectionModel().getLeadSelectionIndex() == column;
            Window windowAncestor = SwingUtilities.getWindowAncestor(this);
            hasFocus = rowIsLead && colIsLead && windowAncestor != null && this.equals(windowAncestor.getMostRecentFocusOwner());
        }
        return renderer.getTableCellRendererComponent(this, value, isSelected, hasFocus, row, column);
    }

    @Override
    public JToolTip createToolTip() {
        FreeplaneTooltip tip = new FreeplaneTooltip(this.getGraphicsConfiguration(), "text/html", true);
        URL url = this.attributeView.getNode().getMap().getURL();
        if (url != null) {
            tip.setBase(url);
        } else {
            try {
                tip.setBase(new URL("file: "));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        tip.setComponent(this);
        return tip;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (ks.getKeyCode() == 9 && e.getModifiers() == 0 && pressed && this.getSelectedColumn() == 1 && this.getSelectedRow() == this.getRowCount() - 1 && this.getModel() instanceof ExtendedAttributeTableModelDecorator) {
            this.insertRow(this.getRowCount());
            return true;
        }
        if (ks.getKeyCode() == 27 && e.getModifiers() == 0 && pressed) {
            if (!this.isEditing()) {
                this.attributeView.getNodeView().requestFocusInWindow();
                return true;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        if (super.processKeyBinding(ks, e, condition, pressed)) {
            return true;
        }
        if (condition == 0) {
            if (ResourceController.getResourceController().getAcceleratorManager().canProcessKeyEvent(e)) {
                return false;
            }
            return this.editCell(ks, e);
        }
        return false;
    }

    private boolean editCell(KeyStroke ks, KeyEvent e) {
        if (this.isFocusOwner() && ks.getKeyCode() != 9 && e != null && e.getID() == 401 && !e.isActionKey() && e.getKeyChar() != '\uffff' && 0 == (e.getModifiers() & 6)) {
            int leadRow = this.getSelectionModel().getLeadSelectionIndex();
            int leadColumn = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            return leadRow != -1 && leadColumn != -1 && !this.isEditing() && this.editCellAt(leadRow, leadColumn, e);
        }
        return false;
    }

    @Override
    public void removeEditor() {
        Component editorComponent = this.getEditorComponent();
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean requestFocus = editorComponent != null && focusOwner != null && (focusOwner == editorComponent || SwingUtilities.isDescendingFrom(focusOwner, editorComponent));
        this.getAttributeTableModel().editingCanceled();
        boolean focusCycleRoot = this.isFocusCycleRoot();
        this.setFocusCycleRoot(true);
        super.removeEditor();
        this.setFocusCycleRoot(focusCycleRoot);
        if (requestFocus) {
            this.requestFocusInWindow();
        }
    }

    public void removeRow(int row) {
        if (this.getModel() instanceof ExtendedAttributeTableModelDecorator) {
            ExtendedAttributeTableModelDecorator model = (ExtendedAttributeTableModelDecorator)this.getModel();
            model.removeRow(row);
            int rowCount = this.getRowCount();
            if (row <= rowCount - 1) {
                this.changeSelection(row, this.getSelectedColumn(), false, false);
            } else if (rowCount >= 1) {
                this.changeSelection(row - 1, this.getSelectedColumn(), false, false);
            }
        }
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
    }

    public void setOptimalColumnWidths() {
        this.setOptimalColumnWidths(true);
    }

    private void setOptimalColumnWidths(boolean updateModel) {
        Component comp = null;
        int minimumCellWidth = 2 * (int)Math.ceil(this.getFont().getSize2D() / UITools.FONT_SCALE_FACTOR + 4.0f);
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            for (int col = 0; col < 2; ++col) {
                int maxCellWidth = minimumCellWidth;
                for (int row = 0; row < rowCount; ++row) {
                    comp = dtcr.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                    Dimension preferredSize = comp.getPreferredSize();
                    int cellWidth = preferredSize.width + preferredSize.height + 4 + 2 + 1;
                    maxCellWidth = Math.max(cellWidth, maxCellWidth);
                }
                if (updateModel) {
                    this.getAttributeTableModel().setColumnWidth(col, (Quantity<LengthUnit>)LengthUnit.pixelsInPt((double)maxCellWidth));
                    continue;
                }
                this.getColumnModel().getColumn(col).setPreferredWidth(maxCellWidth);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.isEditing() && null == this.getClientProperty(EDITING_STOPPED)) {
            this.removeEditor();
        }
        int selectedRow = this.getSelectedRow();
        super.tableChanged(e);
        if (this.getParent() == null) {
            return;
        }
        switch (e.getType()) {
            case -1: {
                if (selectedRow == -1 || e.getFirstRow() > selectedRow) break;
                if (e.getLastRow() >= selectedRow && e.getFirstRow() != 0) {
                    this.changeSelection(e.getFirstRow() - 1, 0, false, false);
                    break;
                }
                if (e.getLastRow() >= selectedRow) break;
                int rowIndex = selectedRow - (e.getLastRow() - e.getFirstRow() + 1);
                if (rowIndex < 0) {
                    rowIndex = 0;
                }
                if (rowIndex >= this.getRowCount()) break;
                this.changeSelection(rowIndex, this.getSelectedColumn(), false, false);
                break;
            }
            case 1: {
                this.changeSelection(e.getFirstRow(), this.getSelectedColumn(), false, false);
                break;
            }
            default: {
                if (selectedRow <= this.getRowCount() || this.getRowCount() <= 0) break;
                this.changeSelection(this.getRowCount() - 1, this.getSelectedColumn(), false, false);
            }
        }
        this.adjustColumnWidthsIfItTableFitsContent();
        this.getParent().getParent().invalidate();
    }

    void updateAttributeTable() {
        this.updateComponentFontAndColors(this);
        this.updateGridColor();
        this.updateRowHeights();
        if (!this.attributeViewFitsContent(this.attributeView.getMapView())) {
            this.updateColumnWidths();
        }
    }

    private void updateGridColor() {
        NodeView nodeView = this.attributeView.getNodeView();
        if (!SwingUtilities.isDescendingFrom(this, nodeView)) {
            return;
        }
        MapView mapView = nodeView.getMap();
        MapStyleModel model = MapStyleModel.getExtension(mapView.getMap());
        NodeModel attributeStyleNode = model.getStyleNodeSafe(MapStyleModel.ATTRIBUTE_STYLE);
        EdgeModel edge = EdgeModel.getModel(attributeStyleNode);
        if (edge != null) {
            Color edgeColor = edge.getColor();
            this.setGridAndBorderColor(edgeColor);
        } else {
            this.gridColor = null;
        }
    }

    public void setGridAndBorderColor(Color gridColor) {
        this.gridColor = gridColor;
        if (gridColor != null && !gridColor.equals(this.getGridColor())) {
            Border border = BorderFactory.createLineBorder(gridColor);
            JComponent parent = (JComponent)this.getParent();
            if (parent instanceof JViewport) {
                JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, parent);
                scrollPane.setBorder(border);
                scrollPane.setViewportBorder(border);
            } else {
                parent.setBorder(border);
            }
            super.setGridColor(gridColor);
        }
    }

    void updateColumnWidths() {
        float zoom = this.getZoom();
        for (int i = 0; i < 2; ++i) {
            int width = (int)((float)this.getAttributeTableModel().getColumnWidth(i).toBaseUnitsRounded() * zoom);
            this.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
    }

    private void updateComponentFontAndColors(Component c) {
        NodeView nodeView = this.attributeView.getNodeView();
        MapView mapView = nodeView.getMap();
        ModeController modeController = mapView.getModeController();
        NodeStyleController style = modeController.getExtension(NodeStyleController.class);
        MapStyleModel model = MapStyleModel.getExtension(mapView.getMap());
        NodeModel attributeStyleNode = model.getStyleNodeSafe(MapStyleModel.ATTRIBUTE_STYLE);
        Font font = style.getFont(attributeStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        c.setFont(font.deriveFont(UITools.FONT_SCALE_FACTOR * font.getSize2D()));
        if (!SwingUtilities.isDescendingFrom(this, nodeView)) {
            return;
        }
        Color backgroundColor = style.getBackgroundColor(attributeStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        if (backgroundColor != null) {
            c.setBackground(backgroundColor);
        } else {
            c.setBackground(nodeView.getBackgroundColor());
        }
        c.setForeground(style.getColor(attributeStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
    }

    private void updateRowHeights() {
        if (!this.isDisplayable()) {
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if (AttributeTable.this.isDisplayable()) {
                        AttributeTable.this.updateRowHeights();
                        AttributeTable.this.removeHierarchyListener(this);
                    }
                }
            });
            return;
        }
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return;
        }
        float zoom = this.getZoom();
        float fontSize = (float)this.getFont().getMaxCharBounds(((Graphics2D)this.getGraphics()).getFontRenderContext()).getHeight() * zoom;
        int extraHeight = (int)(zoom * 4.0f + 0.7f);
        int rowHeight = Math.max(1, (int)fontSize + extraHeight);
        for (int i = 0; i < rowCount; ++i) {
            this.setRowHeight(i, rowHeight + (i == this.highRowIndex ? 4 : 0));
        }
    }

    public void viewRemoved(NodeView nodeView) {
        this.getModel().removeTableModelListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editingStopped(ChangeEvent e) {
        if (this.isEditing() && null == this.getClientProperty(EDITING_STOPPED)) {
            try {
                this.putClientProperty(EDITING_STOPPED, Boolean.TRUE);
                TableCellEditor editor = this.getCellEditor();
                if (editor != null) {
                    Object value = editor.getCellEditorValue();
                    if (value != null && !value.equals(this.getValueForEdit(this.editingRow, this.editingColumn)) && !Controller.getCurrentModeController().isEditingLocked()) {
                        String pattern = this.extractPatternIfAvailable(this.getValueAt(this.editingRow, this.editingColumn));
                        MTextController textController = (MTextController)TextController.getController(this.getModeController());
                        Object object = textController.guessObject(value, pattern);
                        Object newValue = this.enforceFormattedObjectForIdentityPattern(object, pattern);
                        this.setValueAt(newValue, this.editingRow, this.editingColumn);
                    }
                    this.removeEditor();
                }
            }
            finally {
                this.putClientProperty(EDITING_STOPPED, null);
            }
        }
    }

    private String extractPatternIfAvailable(Object oldValue) {
        return oldValue instanceof IFormattedObject ? ((IFormattedObject)oldValue).getPattern() : null;
    }

    private Object enforceFormattedObjectForIdentityPattern(Object value, String pattern) {
        return "NO_FORMAT".equals(pattern) ? new FormattedObject(value, pattern) : value;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(column == 0 ? aValue.toString() : aValue, row, column);
        this.setSelectedCellTypeInfo();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.setSelectedCellTypeInfo();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        super.columnSelectionChanged(e);
        this.setSelectedCellTypeInfo();
    }

    void setSelectedCellTypeInfo() {
        int r = this.getSelectedRow();
        int c = this.getSelectedColumn();
        if (r >= 0 && c >= 0) {
            Object value = this.getValueAt(r, c);
            ViewController viewController = Controller.getCurrentController().getViewController();
            viewController.addObjectTypeInfo(value);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        NodeView nodeView;
        if (this.gridColor == null && SwingUtilities.isDescendingFrom(this, nodeView = this.attributeView.getNodeView())) {
            this.setGridAndBorderColor(nodeView.getMainView().getBorderColor());
        }
        super.paintComponent(g);
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", globalFocusChangeListener);
        AttributeController.setAttributeSelection(globalFocusChangeListener);
        componentListener = new HeaderMouseListener();
        defaultComboBoxModel = null;
        dtcr = new AttributeTableCellRenderer();
        cursorUpdater = new CursorUpdater();
        editingActions = Stream.of((String)TransferHandler.getCopyAction().getValue("Name"), (String)TransferHandler.getPasteAction().getValue("Name"), (String)TransferHandler.getCutAction().getValue("Name")).collect(Collectors.toSet());
    }

    private static final class EditCellAction
    extends AbstractAction {
        private EditCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeTable table = (AttributeTable)e.getSource();
            int selectedRow = table.getSelectedRow();
            int selectedColumn = table.getSelectedColumn();
            if (selectedColumn >= 0 && selectedRow >= 0) {
                table.editCellAt(selectedRow, selectedColumn, e);
            }
        }
    }

    private static final class TableHeader
    extends JTableHeader {
        private TableHeader(TableColumnModel cm) {
            super(cm);
        }

        @Override
        protected TableCellRenderer createDefaultRenderer() {
            return new TableHeaderRendererImpl(super.createDefaultRenderer());
        }
    }

    private class DialogTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final EditNodeBase.IEditControl editControl;
        private Object value;
        private EditNodeBase editBase;

        public DialogTableCellEditor() {
            this.editControl = new EditNodeBase.IEditControl(){

                public void split(String newText, int position) {
                }

                public void ok(String newText) {
                    DialogTableCellEditor.this.value = newText;
                    DialogTableCellEditor.this.stopCellEditing();
                }

                public void cancel() {
                    DialogTableCellEditor.this.stopCellEditing();
                }

                public boolean canSplit() {
                    return false;
                }

                public EditNodeBase.EditedComponent getEditType() {
                    return EditNodeBase.EditedComponent.TEXT;
                }
            };
        }

        public EditNodeBase.IEditControl getEditControl() {
            return this.editControl;
        }

        public void setEditBase(EditNodeBase editBase) {
            this.editBase = editBase;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        public void startEditing() {
            if (this.editBase == null) {
                return;
            }
            Frame frame = JOptionPane.getFrameForComponent(AttributeTable.this);
            this.editBase.show((Window)frame);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return AttributeTable.this.isCellEditable(anEvent);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return new AttributeTableCellRenderer().getTableCellRendererComponent(table, value, true, true, row, column);
        }
    }

    private static class HeaderMouseListener
    extends MouseAdapter {
        private HeaderMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JTableHeader header = (JTableHeader)e.getSource();
            AttributeTable table = (AttributeTable)header.getTable();
            if (table.getNodeViewAncestor() != null) {
                float zoom = table.attributeView.getMapView().getZoom();
                AttributeTableModel model = (AttributeTableModel)table.getModel();
                for (int col = 0; col < table.getColumnCount(); ++col) {
                    int currentColumnWidth;
                    int modelColumnWidth = model.getColumnWidth(col).toBaseUnitsRounded();
                    if (modelColumnWidth == (currentColumnWidth = Math.round((float)table.getColumnModel().getColumn(col).getWidth() / zoom))) continue;
                    model.setColumnWidth(col, (Quantity<LengthUnit>)LengthUnit.pixelsInPt((double)currentColumnWidth));
                }
            }
        }
    }

    private static final class TableHeaderRendererImpl
    implements TableCellRenderer {
        private final TableCellRenderer delegate;

        TableHeaderRendererImpl(TableCellRenderer renderer) {
            this.delegate = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            AttributeTable attributeTable = (AttributeTable)table;
            attributeTable.updateComponentFontAndColors(c);
            int height = (int)(attributeTable.getZoom() * UITools.FONT_SCALE_FACTOR * 6.0f);
            Dimension preferredSize = new Dimension(1, height);
            c.setPreferredSize(preferredSize);
            return c;
        }
    }
}

