/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.thirdparty.com.google.common.base.Joiner;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class AnnotationFormatter {
    private final Function<JavaClass, String> annotationTypeFormatter;
    private final AnnotationPropertiesFormatter propertiesFormatter;

    AnnotationFormatter(Function<JavaClass, String> annotationTypeFormatter, AnnotationPropertiesFormatter propertiesFormatter) {
        this.annotationTypeFormatter = annotationTypeFormatter;
        this.propertiesFormatter = propertiesFormatter;
    }

    String format(JavaClass annotationType, Map<String, Object> annotationProperties) {
        return String.format("@%s(%s)", this.annotationTypeFormatter.apply(annotationType), this.propertiesFormatter.formatProperties(annotationProperties));
    }

    static Builder formatAnnotationType(Function<JavaClass, String> annotationTypeFormatter) {
        return new Builder(annotationTypeFormatter);
    }

    static class AnnotationPropertiesFormatter {
        private final Function<List<String>, String> arrayFormatter;
        private final Function<Class<?>, String> typeFormatter;
        private final Function<String, String> stringFormatter;
        private final boolean omitOptionalIdentifierForSingleElementAnnotations;

        private AnnotationPropertiesFormatter(Builder builder) {
            this.arrayFormatter = Preconditions.checkNotNull(builder.arrayFormatter);
            this.typeFormatter = Preconditions.checkNotNull(builder.typeFormatter);
            this.stringFormatter = Preconditions.checkNotNull(builder.stringFormatter);
            this.omitOptionalIdentifierForSingleElementAnnotations = builder.omitOptionalIdentifierForSingleElementAnnotations;
        }

        String formatProperties(Map<String, Object> properties) {
            if (properties.size() == 1 && properties.containsKey("value") && this.omitOptionalIdentifierForSingleElementAnnotations) {
                return this.formatValue(properties.get("value"));
            }
            return properties.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + this.formatValue(entry.getValue())).collect(Collectors.joining(", "));
        }

        String formatValue(Object input) {
            if (input instanceof Class) {
                return this.typeFormatter.apply((Class)input);
            }
            if (input instanceof String) {
                return this.stringFormatter.apply((String)input);
            }
            if (!input.getClass().isArray()) {
                return String.valueOf(input);
            }
            List elemToString = IntStream.range(0, Array.getLength(input)).mapToObj(i -> this.formatValue(Array.get(input, i))).collect(Collectors.toList());
            return this.arrayFormatter.apply(elemToString);
        }

        static Builder configure() {
            return new Builder();
        }

        static class Builder {
            private Function<List<String>, String> arrayFormatter;
            private Function<Class<?>, String> typeFormatter;
            private Function<String, String> stringFormatter = Function.identity();
            private boolean omitOptionalIdentifierForSingleElementAnnotations = false;

            Builder() {
            }

            Builder formattingArraysWithSquareBrackets() {
                this.arrayFormatter = input -> "[" + Joiner.on(", ").join((Iterable<? extends Object>)input) + "]";
                return this;
            }

            Builder formattingArraysWithCurlyBrackets() {
                this.arrayFormatter = input -> "{" + Joiner.on(", ").join((Iterable<? extends Object>)input) + "}";
                return this;
            }

            Builder formattingTypesToString() {
                this.typeFormatter = String::valueOf;
                return this;
            }

            Builder formattingTypesAsClassNames() {
                this.typeFormatter = input -> input.getName() + ".class";
                return this;
            }

            Builder quotingStrings() {
                this.stringFormatter = input -> "\"" + input + "\"";
                return this;
            }

            Builder omitOptionalIdentifierForSingleElementAnnotations() {
                this.omitOptionalIdentifierForSingleElementAnnotations = true;
                return this;
            }

            AnnotationPropertiesFormatter build() {
                return new AnnotationPropertiesFormatter(this);
            }
        }
    }

    static class Builder {
        private final Function<JavaClass, String> annotationTypeFormatter;

        private Builder(Function<JavaClass, String> annotationTypeFormatter) {
            this.annotationTypeFormatter = annotationTypeFormatter;
        }

        AnnotationFormatter formatProperties(Consumer<AnnotationPropertiesFormatter.Builder> config) {
            AnnotationPropertiesFormatter.Builder propertiesFormatterBuilder = AnnotationPropertiesFormatter.configure();
            config.accept(propertiesFormatterBuilder);
            return new AnnotationFormatter(this.annotationTypeFormatter, propertiesFormatterBuilder.build());
        }
    }
}

