/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.LDAPExpr;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.permissionadmin.PermissionAdmin;

class Services {
    HashMap<ServiceRegistrationImpl<?>, String[]> services = new HashMap();
    private final HashMap<String, List<ServiceRegistrationImpl<?>>> classServices = new HashMap();
    private PermissionOps secure;
    FrameworkContext framework;
    static final Util.Comparator<ServiceRegistrationImpl<?>, ServiceRegistrationImpl<?>> sComp = new Util.Comparator<ServiceRegistrationImpl<?>, ServiceRegistrationImpl<?>>(){

        @Override
        public int compare(ServiceRegistrationImpl<?> a, ServiceRegistrationImpl<?> b) {
            return a.reference.compareTo(b.reference);
        }
    };

    Services(FrameworkContext fwCtx, PermissionOps perm) {
        this.framework = fwCtx;
        this.secure = perm;
    }

    void clear() {
        this.services.clear();
        this.classServices.clear();
        this.secure = null;
        this.framework = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRegistration<?> register(BundleImpl bundle, String[] classes, Object service, Dictionary<String, ?> properties) {
        if (service == null) {
            throw new IllegalArgumentException("Can't register null as a service");
        }
        String scope = service instanceof ServiceFactory ? (service instanceof PrototypeServiceFactory ? "prototype" : "bundle") : "singleton";
        for (String cls : classes) {
            if (cls == null) {
                throw new IllegalArgumentException("Can't register as null class");
            }
            this.secure.checkRegisterServicePerm(cls);
            if (bundle.id != 0L) {
                if (cls.equals(PackageAdmin.class.getName())) {
                    throw new IllegalArgumentException("Registeration of a PackageAdmin service is not allowed");
                }
                if (cls.equals(PermissionAdmin.class.getName())) {
                    throw new IllegalArgumentException("Registeration of a PermissionAdmin service is not allowed");
                }
                if (cls.equals(ConditionalPermissionAdmin.class.getName())) {
                    throw new IllegalArgumentException("Registeration of a ConditionalPermissionAdmin service is not allowed");
                }
            }
            if (scope != "singleton" || this.checkServiceClass(service, cls)) continue;
            throw new IllegalArgumentException("Service object is not an instance of " + cls);
        }
        ServiceRegistrationImpl res = new ServiceRegistrationImpl(bundle, service, scope, new PropertiesDictionary(properties, classes, null, new Long(bundle.id), scope));
        Services len$ = this;
        synchronized (len$) {
            this.services.put(res, classes);
            for (String clazz : classes) {
                List<ServiceRegistrationImpl<?>> s = this.classServices.get(clazz);
                if (s == null) {
                    s = new ArrayList(1);
                    this.classServices.put(clazz, s);
                }
                int ip = Math.abs(Util.binarySearch(s, sComp, res) + 1);
                s.add(ip, res);
            }
        }
        ServiceReference r = res.getReference();
        bundle.fwCtx.perm.callServiceChanged(bundle.fwCtx, bundle.fwCtx.listeners.getMatchingServiceListeners(r), new ServiceEvent(1, r), null);
        return res;
    }

    synchronized void updateServiceRegistrationOrder(ServiceRegistrationImpl<?> sr, String[] classes) {
        for (String clazz : classes) {
            List<ServiceRegistrationImpl<?>> s = this.classServices.get(clazz);
            s.remove(sr);
            s.add(Math.abs(Util.binarySearch(s, sComp, sr) + 1), sr);
        }
    }

    boolean checkServiceClass(Object service, String cls) {
        Class<?> sc = service.getClass();
        ClassLoader scl = this.secure.getClassLoaderOf(sc);
        Class<?> c = null;
        boolean ok = false;
        try {
            c = scl != null ? scl.loadClass(cls) : Class.forName(cls);
            ok = c.isInstance(service);
        }
        catch (ClassNotFoundException e) {
            block2: for (Class<?> csc = sc; csc != null; csc = csc.getSuperclass()) {
                if (cls.equals(csc.getName())) {
                    ok = true;
                    break;
                }
                Class<?>[] ic = csc.getInterfaces();
                for (int iic = ic.length - 1; iic >= 0; --iic) {
                    if (!cls.equals(ic[iic].getName())) continue;
                    ok = true;
                    continue block2;
                }
            }
        }
        return ok;
    }

    synchronized List<ServiceRegistrationImpl<?>> get(String clazz) {
        List<ServiceRegistrationImpl<?>> v = this.classServices.get(clazz);
        if (v != null) {
            List res = (List)((ArrayList)v).clone();
            return res;
        }
        return null;
    }

    synchronized ServiceReference<?> get(BundleImpl bundle, String clazz, boolean doAssignableToTest) {
        try {
            ServiceReference<?>[] srs = this.get(clazz, null, bundle, doAssignableToTest);
            if (this.framework.debug.service_reference) {
                this.framework.debug.println("get service ref " + clazz + " for bundle " + bundle.location + " = " + (srs != null ? srs[0] : null));
            }
            if (srs != null) {
                return srs[0];
            }
        }
        catch (InvalidSyntaxException _never) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized ServiceReference<?>[] get(String clazz, String filter, BundleImpl bundle, boolean doAssignableToTest) throws InvalidSyntaxException {
        void var5_19;
        LDAPExpr ldap = null;
        if (clazz == null) {
            if (filter != null) {
                ldap = new LDAPExpr(filter);
                Set<String> matched = ldap.getMatchedObjectClasses();
                if (matched != null) {
                    List<ServiceRegistrationImpl<?>> v = null;
                    boolean vReadOnly = true;
                    for (String match : matched) {
                        List<ServiceRegistrationImpl<?>> cl = this.classServices.get(match);
                        if (cl == null) continue;
                        if (v == null) {
                            v = cl;
                            continue;
                        }
                        if (vReadOnly) {
                            v = new ArrayList(v);
                            vReadOnly = false;
                        }
                        v.addAll(cl);
                    }
                    if (v == null) return null;
                    Iterator iterator = v.iterator();
                } else {
                    Iterator<ServiceRegistrationImpl<?>> iterator = this.services.keySet().iterator();
                }
            } else {
                Iterator<ServiceRegistrationImpl<?>> iterator = this.services.keySet().iterator();
            }
        } else {
            List<ServiceRegistrationImpl<?>> v = this.classServices.get(clazz);
            if (v == null) {
                return null;
            }
            Iterator<ServiceRegistrationImpl<?>> iterator = v.iterator();
            if (filter != null) {
                ldap = new LDAPExpr(filter);
            }
        }
        ArrayList<ServiceReference<Object>> res = new ArrayList();
        while (var5_19.hasNext()) {
            ServiceRegistrationImpl sr = (ServiceRegistrationImpl)var5_19.next();
            ServiceReference sri = sr.getReference();
            if (!this.secure.okGetServicePerms(sri) || filter != null && !ldap.evaluate(sr.getProperties(), false)) continue;
            if (doAssignableToTest) {
                String[] classes = this.services.get(sr);
                for (int i = 0; i < classes.length; ++i) {
                    if (sri.isAssignableTo(bundle, classes[i])) continue;
                    sri = null;
                    break;
                }
            }
            if (sri == null) continue;
            res.add(sri);
        }
        if (res.isEmpty()) {
            return null;
        }
        ArrayList allSaved = null;
        if (bundle == this.framework.systemBundle) {
            allSaved = new ArrayList(res);
        }
        if (doAssignableToTest) {
            this.framework.serviceHooks.filterServiceReferences(bundle.bundleContext, clazz, filter, false, res);
        } else {
            this.framework.serviceHooks.filterServiceReferences(null, clazz, filter, true, res);
        }
        if (allSaved != null) {
            res = allSaved;
        }
        if (!res.isEmpty()) return res.toArray(new ServiceReference[res.size()]);
        return null;
    }

    synchronized void removeServiceRegistration(ServiceRegistrationImpl<?> sr) {
        String[] classes = (String[])sr.getProperty("objectClass");
        this.services.remove(sr);
        for (String clazz : classes) {
            List<ServiceRegistrationImpl<?>> s = this.classServices.get(clazz);
            if (s.size() > 1) {
                s.remove(sr);
                continue;
            }
            this.classServices.remove(clazz);
        }
    }

    synchronized Set<ServiceRegistrationImpl<?>> getRegisteredByBundle(Bundle b) {
        HashSet res = new HashSet();
        for (ServiceRegistrationImpl<?> sr : this.services.keySet()) {
            if (sr.bundle != b) continue;
            res.add(sr);
        }
        return res;
    }

    synchronized Set<ServiceRegistrationImpl<?>> getUsedByBundle(Bundle b) {
        HashSet res = new HashSet();
        for (ServiceRegistrationImpl<?> sr : this.services.keySet()) {
            if (!sr.isUsedByBundle(b)) continue;
            res.add(sr);
        }
        return res;
    }

    synchronized Set<ServiceRegistrationImpl<?>> getAllRegistered() {
        return new HashSet(this.services.keySet());
    }
}

