/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note.mindmapmode;

import java.awt.Color;
import java.awt.ComponentOrientation;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.html.StyleSheet;
import org.freeplane.api.TextWritingDirection;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.NoteStyleAccessor;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.note.mindmapmode.NotePanel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.text.TextController;

class NoteManager
implements INodeSelectionListener,
IMapSelectionListener,
IMapLifeCycleListener {
    private static final String NOTE_FOLLOWS_SELECTION_PROPERTY = "noteFollowsSelection";
    private boolean ignoreEditorUpdate;
    private NodeModel node;
    final MNoteController noteController;
    private boolean noteFollowsSelection;

    public NoteManager(final MNoteController noteController) {
        this.noteController = noteController;
        ResourceController resourceController = ResourceController.getResourceController();
        resourceController.addPropertyChangeListener(this::propertyChanged);
        this.noteFollowsSelection = resourceController.getBooleanProperty(NOTE_FOLLOWS_SELECTION_PROPERTY);
        MapController mapController = noteController.getModeController().getMapController();
        mapController.addNodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                if (event.getNode().equals(NoteManager.this.node)) {
                    NotePanel notePanel;
                    if ("note_text".equals(event.getProperty())) {
                        NoteManager.this.updateEditor();
                    } else if (TextWritingDirection.class.equals(event.getProperty()) && (notePanel = noteController.getNotePanel()) != null) {
                        notePanel.setComponentOrientation(NoteManager.this.getNoteTextDirection().componentOrientation);
                    }
                }
            }
        });
        mapController.addMapChangeListener(new IMapChangeListener(){

            public void mapChanged(MapChangeEvent event) {
                NotePanel notePanel;
                Object property = event.getProperty();
                if (NoteManager.this.node != null && NoteManager.this.node.getMap() == event.getMap() && property.equals("MAP_STYLES") && (notePanel = noteController.getNotePanel()) != null) {
                    notePanel.setComponentOrientation(NoteManager.this.getNoteTextDirection().componentOrientation);
                }
            }
        });
    }

    public void onRemove(MapModel map) {
        if (!this.noteFollowsSelection && this.node != null && this.node.getMap() == map) {
            this.stopEditing();
            this.updateEditor();
        }
    }

    public void onDeselect(NodeModel node) {
        if (this.noteFollowsSelection) {
            this.stopEditing();
        }
    }

    private void stopEditing() {
        NotePanel notePanel = this.noteController.getNotePanel();
        if (notePanel == null) {
            return;
        }
        notePanel.removeDocumentListener();
        this.saveNote(this.node);
        notePanel.stopEditing();
        this.node = null;
    }

    public void onSelect(NodeModel node) {
        if (this.noteFollowsSelection) {
            this.node = node;
            this.updateEditor();
        }
    }

    void updateEditor() {
        NotePanel notePanel;
        block12: {
            String note;
            notePanel = this.noteController.getNotePanel();
            if (notePanel == null) {
                return;
            }
            ModeController modeController = Controller.getCurrentModeController();
            NoteStyleAccessor noteStyleAccessor = new NoteStyleAccessor(modeController, this.node, 1.0f, false);
            String noteCssRule = noteStyleAccessor.getNoteCSSStyle();
            Color noteForeground = noteStyleAccessor.getNoteForeground();
            Color noteBackground = noteStyleAccessor.getNoteBackground();
            ComponentOrientation componentOrientation = this.getNoteTextDirection().componentOrientation;
            notePanel.setComponentOrientation(componentOrientation);
            StringBuilder bodyCssBuilder = new StringBuilder("body {").append(noteCssRule).append("}\n");
            if (ResourceController.getResourceController().getBooleanProperty("resources_use_margin_top_zero_for_notes")) {
                bodyCssBuilder.append("p {margin-top:0;}\n");
            }
            String bodyCssRule = bodyCssBuilder.toString();
            StyleSheet noteStyleSheet = noteStyleAccessor.getNoteStyleSheet();
            if (this.node == null) {
                notePanel.setViewedContent("", bodyCssRule, noteStyleSheet, noteForeground, noteBackground);
                return;
            }
            if (this.ignoreEditorUpdate) {
                return;
            }
            String string = note = this.node != null ? NoteModel.getNoteText((NodeModel)this.node) : null;
            if (note != null) {
                try {
                    TextController textController = TextController.getController();
                    Object transformedContent = textController.getTransformedObject(this.node, (Object)NoteModel.getNote((NodeModel)this.node), (Object)note);
                    Icon icon = textController.getIcon(transformedContent);
                    if (icon != null) {
                        notePanel.setViewedImage(icon, noteStyleAccessor.getHorizontalAlignment());
                        break block12;
                    }
                    if (transformedContent == note) {
                        notePanel.removeDocumentListener();
                        String noteContentType = this.noteController.getNoteContentType(this.node);
                        String editedContent = TextController.isHtmlContentType((String)noteContentType) ? HtmlUtils.textToHTML((String)note) : note;
                        notePanel.setEditedContent(editedContent, bodyCssRule, noteStyleSheet, noteForeground, noteBackground);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                notePanel.installDocumentListener();
                            }
                        });
                        break block12;
                    }
                    notePanel.setViewedContent(transformedContent.toString(), bodyCssRule, noteStyleSheet, noteForeground, noteBackground);
                }
                catch (Throwable e) {
                    LogUtils.warn((String)e.getMessage());
                    notePanel.setViewedContent(TextUtils.format((String)"MainView.errorUpdateText", (Object[])new Object[]{note, e.getLocalizedMessage()}), bodyCssRule, noteStyleSheet, noteForeground, noteBackground);
                }
            } else {
                String noteContentType = this.noteController.getNoteContentType(this.node);
                if (TextController.isHtmlContentType((String)noteContentType)) {
                    notePanel.setEditedContent("", bodyCssRule, noteStyleSheet, noteForeground, noteBackground);
                } else {
                    notePanel.setViewedContent("", bodyCssRule, noteStyleSheet, noteForeground, noteBackground);
                }
            }
        }
        notePanel.updateBaseUrl(this.node.getMap().getURL());
    }

    public void afterMapChange(MapModel oldMap, MapModel newMap) {
        if (newMap == null) {
            NotePanel notePanel;
            if (this.node != null) {
                this.saveNote();
                this.node = null;
            }
            if ((notePanel = this.noteController.getNotePanel()) != null) {
                notePanel.removeViewedContent();
            }
        }
    }

    void saveNote(NodeModel savedNode) {
        if (this.node == null || this.node.getMap() != savedNode.getMap()) {
            return;
        }
        this.saveNote();
    }

    void saveNote() {
        if (this.node == null) {
            return;
        }
        NotePanel notePanel = this.noteController.getNotePanel();
        if (notePanel != null) {
            notePanel.saveNote();
        }
    }

    NodeModel getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveNote(String text) {
        boolean isHtml = HtmlUtils.isHtml((String)text);
        boolean editorContentEmpty = isHtml && HtmlUtils.isEmpty((String)text) || !isHtml && text.trim().isEmpty();
        Controller.getCurrentModeController().getMapController().removeNodeSelectionListener((INodeSelectionListener)this);
        try {
            this.ignoreEditorUpdate = true;
            if (editorContentEmpty) {
                this.noteController.setNoteText(this.node, null);
            } else {
                String oldText = this.noteController.getNoteText(this.node);
                if (null == oldText) {
                    this.noteController.setNoteText(this.node, text);
                } else if (isHtml) {
                    String oldTextWithoutHead = NotePanel.HEAD.matcher(oldText).replaceFirst("");
                    if (!oldTextWithoutHead.trim().equals(text.trim())) {
                        this.noteController.setNoteText(this.node, text);
                    }
                } else {
                    this.noteController.setNoteText(this.node, text);
                }
            }
        }
        finally {
            this.ignoreEditorUpdate = false;
        }
        Controller.getCurrentModeController().getMapController().addNodeSelectionListener((INodeSelectionListener)this);
    }

    private void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (!NOTE_FOLLOWS_SELECTION_PROPERTY.equals(propertyName)) {
            return;
        }
        this.noteFollowsSelection = Boolean.parseBoolean(newValue);
        if (this.noteFollowsSelection) {
            NodeModel selectedNode;
            IMapSelection selection = Controller.getCurrentController().getSelection();
            NodeModel nodeModel = selectedNode = selection != null ? selection.getSelected() : null;
            if (this.node != selectedNode) {
                this.node = selectedNode;
                this.updateEditor();
            }
        }
    }

    TextWritingDirection getNoteTextDirection() {
        if (this.node == null) {
            return TextWritingDirection.DEFAULT;
        }
        return ((NodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class)).getTextWritingDirection(this.node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }
}

