/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.view.swing.features.time.mindmapmode.ClockState;
import org.freeplane.view.swing.features.time.mindmapmode.PeriodUnit;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderConditionController;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderExtension;
import org.freeplane.view.swing.features.time.mindmapmode.TimeManagement;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.AllMapsNodeListAction;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.NodeListAction;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.OldReminderListAction;
import org.freeplane.view.swing.features.time.mindmapmode.nodelist.ReminderListAction;

@NodeHookDescriptor(hookName="plugins/TimeManagementReminder.xml", onceForMap=false)
public class ReminderHook
extends PersistentNodeHook
implements IExtension {
    static final String REMINDERS_BLINK = "remindersBlink";
    private static final String REMINDUSERAT = "REMINDUSERAT";
    private static final String PERIOD = "PERIOD";
    private static final String UNIT = "UNIT";
    private static final String SCRIPT = "SCRIPT";
    private static final Integer REMINDER_TOOLTIP = 12;
    private final ModeController modeController;
    private static final IconStore STORE = IconStoreFactory.ICON_STORE;
    private static UIIcon bellIcon;
    private static UIIcon clockIcon;
    private static UIIcon flagIcon;

    public ReminderHook(ModeController modeController) {
        this.modeController = modeController;
        this.registerAction(new TimeManagementAction(this));
        this.registerAction(new ReminderListAction());
        this.registerAction(new OldReminderListAction());
        this.registerAction(new NodeListAction());
        this.registerAction(new AllMapsNodeListAction());
        this.registerTooltipProvider();
        this.registerStateIconProvider();
        FilterController.getCurrentFilterController().getConditionFactory().addConditionController(90, (IElementaryConditionController)new ReminderConditionController());
        this.createCalendarPanel();
    }

    private void registerStateIconProvider() {
        IconController.getController((ModeController)this.modeController).addStateIconProvider(new IStateIconProvider(){

            public UIIcon getStateIcon(NodeModel node) {
                UIIcon icon = null;
                ClockState stateAdded = (ClockState)node.getExtension(ClockState.class);
                ReminderExtension reminder = (ReminderExtension)node.getExtension(ReminderExtension.class);
                if (stateAdded == ClockState.CLOCK_VISIBLE) {
                    icon = ReminderHook.this.getClockIcon();
                } else if (stateAdded == ClockState.CLOCK_INVISIBLE) {
                    icon = reminder != null && node.allClones().contains(reminder.getNode()) ? ReminderHook.this.getBellIcon() : ReminderHook.this.getFlagIcon();
                }
                if (stateAdded != null || reminder != null && node == reminder.getNode() || ReminderExtension.getExtension(node) == null) {
                    return icon;
                }
                return null;
            }

            public boolean mustIncludeInIconRegistry() {
                return true;
            }
        });
    }

    private UIIcon getBellIcon() {
        if (bellIcon == null) {
            bellIcon = STORE.getUIIcon("bell.svg");
        }
        return bellIcon;
    }

    private UIIcon getClockIcon() {
        if (clockIcon == null) {
            clockIcon = STORE.getUIIcon("clock.svg");
        }
        return clockIcon;
    }

    private UIIcon getFlagIcon() {
        if (flagIcon == null) {
            flagIcon = STORE.getUIIcon("flag.svg");
        }
        return flagIcon;
    }

    private void registerTooltipProvider() {
        this.modeController.addToolTipProvider(REMINDER_TOOLTIP, new ITooltipProvider(){

            public String getTooltip(ModeController modeController, NodeModel node, Component view) {
                ReminderExtension model = ReminderExtension.getExtension(node);
                if (model == null) {
                    return null;
                }
                Date date = new Date(model.getRemindUserAt());
                Object[] messageArguments = new Object[]{date};
                MessageFormat formatter = new MessageFormat(TextUtils.getText((String)"reminder.reminderNode.tooltip"));
                String message = formatter.format(messageArguments);
                return message;
            }
        });
    }

    private void createCalendarPanel() {
        TimeManagement timeManagement = new TimeManagement(this);
        final TimeManagement.JTimePanel timePanel = timeManagement.createTimePanel(null, false, 1);
        this.modeController.getMapController().addNodeSelectionListener(new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                timePanel.update(node);
            }

            public void onDeselect(NodeModel node) {
            }
        });
        this.modeController.getMapController().addUINodeChangeListener(new INodeChangeListener(){

            public void nodeChanged(NodeChangeEvent event) {
                NodeModel node = event.getNode();
                if (event.getProperty().equals(ReminderHook.this.getExtensionClass()) && node.equals(ReminderHook.this.modeController.getMapController().getSelectedNode())) {
                    timePanel.update(node);
                }
            }
        });
        JTabbedPane tabs = UITools.getFreeplaneTabbedPanel();
        JScrollPane timeScrollPane = new JScrollPane(timePanel, 20, 30);
        UITools.setScrollbarIncrement((JScrollPane)timeScrollPane);
        tabs.addTab("", ResourceController.getResourceController().getIcon("/images/panelTabs/calendarTab.svg?useAccentColor=true"), timeScrollPane, TextUtils.getText((String)"calendar_panel"));
    }

    public void add(NodeModel node, IExtension extension) {
        ReminderExtension reminder = (ReminderExtension)extension;
        reminder.reminderAdded();
        super.add(node, extension);
    }

    protected IExtension createExtension(NodeModel node, XMLElement element) {
        ReminderExtension reminderExtension = new ReminderExtension(this, node);
        XMLElement parameters = element.getFirstChildNamed("Parameters");
        String time = parameters.getAttribute(REMINDUSERAT, "0");
        String unit = parameters.getAttribute(UNIT, "DAY");
        String period = parameters.getAttribute(PERIOD, "1");
        reminderExtension.setRemindUserAt(Long.parseLong(time));
        reminderExtension.setPeriodUnit(PeriodUnit.valueOf(unit));
        reminderExtension.setPeriod(Integer.parseInt(period));
        String script = parameters.getAttribute(SCRIPT, null);
        reminderExtension.setScript(script);
        return reminderExtension;
    }

    protected PersistentNodeHook.HookAction createHookAction() {
        return new ReminderHookAction();
    }

    protected Class<? extends IExtension> getExtensionClass() {
        return ReminderExtension.class;
    }

    protected IExtension toggle(NodeModel node, IExtension extension) {
        IExtension toggledExtension = super.toggle(node, extension);
        if (node.containsExtension(this.getExtensionClass())) {
            node.putExtension((IExtension)ClockState.CLOCK_VISIBLE);
        } else {
            node.removeExtension(ClockState.class);
        }
        Controller.getCurrentModeController().getMapController().nodeRefresh(node);
        return toggledExtension;
    }

    public void remove(NodeModel node, IExtension extension) {
        ReminderExtension reminderExtension = (ReminderExtension)extension;
        MapController mapController = this.modeController.getMapController();
        mapController.removeMapChangeListener((IMapChangeListener)reminderExtension);
        mapController.removeMapLifeCycleListener((IMapLifeCycleListener)reminderExtension);
        mapController.mapSaved(node.getMap(), false);
        super.remove(node, extension);
        reminderExtension.deactivateTimer();
    }

    protected void saveExtension(IExtension extension, XMLElement element) {
        super.saveExtension(extension, element);
        ReminderExtension reminderExtension = (ReminderExtension)extension;
        XMLElement parameters = element.createElement("Parameters");
        parameters.setAttribute(REMINDUSERAT, Long.toString(reminderExtension.getRemindUserAt()));
        parameters.setAttribute(PERIOD, Integer.toString(reminderExtension.getPeriod()));
        parameters.setAttribute(UNIT, reminderExtension.getPeriodUnit().toString());
        String script = reminderExtension.getScript();
        if (script != null) {
            parameters.setAttribute(SCRIPT, script);
        }
        element.addChild(parameters);
    }

    ModeController getModeController() {
        return this.modeController;
    }

    void showNotificationPopup(ReminderExtension reminderExtension) {
        final NodeModel node = reminderExtension.getNode();
        String information = ((TextController)this.modeController.getExtension(TextController.class)).getText(node);
        String title = TextUtils.getText((String)"reminderNotification");
        int option = JOptionPane.showOptionDialog(UITools.getCurrentFrame(), new JLabel(information), title, -1, 1, null, (Object[])NotificationOptions.values(), (Object)NotificationOptions.SELECT_NODE);
        if (option >= 0) {
            switch (NotificationOptions.values()[option].ordinal()) {
                case 0: {
                    UITools.executeWhenNodeHasFocus((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Timer timer = new Timer(100, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Controller.getCurrentModeController().getMapController().select(node);
                                }
                            });
                            timer.setRepeats(false);
                            timer.start();
                        }
                    });
                    break;
                }
                case 1: {
                    this.undoableDeactivateHook(node);
                    break;
                }
                case 2: {
                    this.remove(node, reminderExtension);
                    long now = new Date().getTime();
                    int delay = ResourceController.getResourceController().getTimeProperty("remindersStandardDelay");
                    reminderExtension.setRemindUserAt(now + (long)delay);
                    this.add(node, reminderExtension);
                    break;
                }
            }
        }
    }

    private static class TimeManagementAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;
        private final TimeManagement timeManagement;

        public TimeManagementAction(ReminderHook reminderHook) {
            super("TimeManagementAction");
            this.timeManagement = new TimeManagement(reminderHook);
        }

        public void actionPerformed(ActionEvent e) {
            this.timeManagement.showDialog();
        }
    }

    @EnabledAction(checkOnNodeChange=true)
    private class ReminderHookAction
    extends PersistentNodeHook.HookAction {
        private static final long serialVersionUID = 1L;

        public ReminderHookAction() {
            super((PersistentNodeHook)ReminderHook.this, "ReminderHookAction");
        }

        public void setEnabled() {
            this.setEnabled(ReminderHook.this.isActiveForSelection());
        }
    }

    private static enum NotificationOptions {
        SELECT_NODE,
        REMOVE_REMINDER,
        REMIND_ME_LATER,
        CLOSE;


        public String toString() {
            return TextUtils.getText((String)("NotificationOptions." + this.name()));
        }
    }
}

