/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.util.regex.Pattern;

public class CJKNormalizer {
    private static final String UNICODE_CJK_AND_FULLWIDTH_RANGES = "[\u3040-\u30ff\u4e00-\u9fff\u1100-\u11ff\uac00-\ud7af\u0e00-\u0e7f\u0e80-\u0eff\u1780-\u17ff\u1000-\u109f\u3000-\u303f\uff00-\uffef]";
    private static final Pattern CJK_FULLWIDTH_CHARACTERS_PATTERN = Pattern.compile("[\u3040-\u30ff\u4e00-\u9fff\u1100-\u11ff\uac00-\ud7af\u0e00-\u0e7f\u0e80-\u0eff\u1780-\u17ff\u1000-\u109f\u3000-\u303f\uff00-\uffef]");
    private static final Pattern WHITESPACE_BETWEEN_CJK_PATTERN = Pattern.compile("(?<=[\u3040-\u30ff\u4e00-\u9fff\u1100-\u11ff\uac00-\ud7af\u0e00-\u0e7f\u0e80-\u0eff\u1780-\u17ff\u1000-\u109f\u3000-\u303f\uff00-\uffef])\\s+(?=[\u3040-\u30ff\u4e00-\u9fff\u1100-\u11ff\uac00-\ud7af\u0e00-\u0e7f\u0e80-\u0eff\u1780-\u17ff\u1000-\u109f\u3000-\u303f\uff00-\uffef])");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

    public static String removeSpacesBetweenCJKCharacters(String value) {
        if (CJK_FULLWIDTH_CHARACTERS_PATTERN.matcher(value).find() && WHITESPACE_PATTERN.matcher(value).find()) {
            return WHITESPACE_BETWEEN_CJK_PATTERN.matcher(value).replaceAll("");
        }
        return value;
    }
}

