/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.Unit;
import java.util.Iterator;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class Evaluator {
    private static final FunctionEvaluator[] funcEvaluators = Evaluator.loadFunctionEvaluators();
    private final short preferredUnit;

    public Evaluator() {
        this(6);
    }

    private static FunctionEvaluator[] loadFunctionEvaluators() {
        FunctionEvaluator[] functionEvaluatorArray = new FunctionEvaluator[]{new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionAbs(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionClamp(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionMax(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionMin(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionRound(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionMod(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionRem(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionHypot(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionHypot2(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionLog(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionExp(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionSqrt(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionPow(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionSign(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionSin(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionCos(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionTan(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionASin(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionACos(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionATan(cSSMathFunctionValue.getArguments(), unit);
            }
        }, new FunctionEvaluator(){

            @Override
            public CSSNumberValue evaluateFunction(Evaluator evaluator, CSSMathFunctionValue cSSMathFunctionValue, Unit unit) {
                return evaluator.functionATan2(cSSMathFunctionValue.getArguments(), unit);
            }
        }};
        return functionEvaluatorArray;
    }

    public Evaluator(short s) {
        this.preferredUnit = s;
    }

    public CSSNumberValue evaluateFunction(CSSMathFunctionValue cSSMathFunctionValue) throws DOMException {
        Unit unit = new Unit();
        CSSNumberValue cSSNumberValue = this.evaluateFunction(cSSMathFunctionValue, unit);
        int n = unit.getExponent();
        if (n > 1 || n < 0) {
            throw new DOMException(17, "Resulting unit is not valid CSS unit.");
        }
        float f = cSSNumberValue.getFloatValue(cSSNumberValue.getUnitType());
        if (Float.isNaN(f)) {
            throw new DOMException(15, "Result is not a number (NaN).");
        }
        if (cSSMathFunctionValue.isExpectingInteger()) {
            cSSNumberValue.roundToInteger();
        }
        return cSSNumberValue;
    }

    CSSNumberValue evaluateFunction(CSSMathFunctionValue cSSMathFunctionValue, Unit unit) throws DOMException {
        return funcEvaluators[cSSMathFunctionValue.getFunctionIndex()].evaluateFunction(this, cSSMathFunctionValue, unit);
    }

    private CSSNumberValue functionMax(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        short s;
        if (cSSValueList.isEmpty()) {
            throw new DOMException(12, "max() functions take at least one argument");
        }
        Iterator iterator = cSSValueList.iterator();
        CSSValue cSSValue = (CSSValue)iterator.next();
        CSSTypedValue cSSTypedValue = this.enforceTyped(cSSValue);
        cSSTypedValue = this.evaluate(cSSTypedValue, unit);
        boolean bl = cSSTypedValue.isCalculatedNumber();
        float f = this.floatValue(cSSTypedValue, unit);
        int n = unit.getExponent();
        short s2 = s = unit.getUnitType();
        float f2 = f;
        while (iterator.hasNext()) {
            cSSValue = (CSSValue)iterator.next();
            cSSTypedValue = this.enforceTyped(cSSValue);
            cSSTypedValue = this.evaluate(cSSTypedValue, unit);
            float f3 = this.floatValue(cSSTypedValue, unit);
            if (n != unit.getExponent()) {
                throw new DOMException(15, "max() arguments have incompatible dimensions.");
            }
            float f4 = NumberValue.floatValueConversion(f3, unit.getUnitType(), s);
            if (!(f < f4)) continue;
            f = f4;
            f2 = f3;
            s2 = unit.getUnitType();
            bl = cSSTypedValue.isCalculatedNumber();
        }
        return this.createNumberValue(s2, f2, bl);
    }

    private CSSTypedValue enforceTyped(CSSValue cSSValue) throws DOMException {
        if (cSSValue.getCssValueType() != CSSValue.CssType.TYPED) {
            throw new DOMException(12, "Unexpected value: " + cSSValue.getCssText());
        }
        CSSTypedValue cSSTypedValue = (CSSTypedValue)cSSValue;
        if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            String string = cSSTypedValue.getStringValue();
            if ("pi".equalsIgnoreCase(string)) {
                cSSTypedValue = NumberValue.createCSSNumberValue((short)0, (float)Math.PI);
            } else if ("e".equalsIgnoreCase(string)) {
                cSSTypedValue = NumberValue.createCSSNumberValue((short)0, (float)Math.E);
            } else {
                throw new DOMException(12, "Unexpected value: " + cSSValue.getCssText());
            }
        }
        return cSSTypedValue;
    }

    private CSSNumberValue functionMin(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        short s;
        if (cSSValueList.isEmpty()) {
            throw new DOMException(12, "min() functions take at least one argument");
        }
        Iterator iterator = cSSValueList.iterator();
        CSSValue cSSValue = (CSSValue)iterator.next();
        CSSTypedValue cSSTypedValue = this.enforceTyped(cSSValue);
        cSSTypedValue = this.evaluate(cSSTypedValue, unit);
        boolean bl = cSSTypedValue.isCalculatedNumber();
        float f = this.floatValue(cSSTypedValue, unit);
        int n = unit.getExponent();
        short s2 = s = unit.getUnitType();
        float f2 = f;
        while (iterator.hasNext()) {
            cSSValue = (CSSValue)iterator.next();
            cSSTypedValue = this.enforceTyped(cSSValue);
            cSSTypedValue = this.evaluate(cSSTypedValue, unit);
            float f3 = this.floatValue(cSSTypedValue, unit);
            if (n != unit.getExponent()) {
                throw new DOMException(15, "min() arguments have incompatible dimensions.");
            }
            float f4 = NumberValue.floatValueConversion(f3, unit.getUnitType(), s);
            if (!(f > f4)) continue;
            f = f4;
            f2 = f3;
            s2 = unit.getUnitType();
            bl = cSSTypedValue.isCalculatedNumber();
        }
        return this.createNumberValue(s2, f2, bl);
    }

    private CSSNumberValue functionClamp(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 3) {
            throw new DOMException(12, "Clamp functions take three arguments");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 1);
        cSSTypedValue = this.evaluate(cSSTypedValue, unit);
        boolean bl = cSSTypedValue.isCalculatedNumber();
        float f = this.floatValue(cSSTypedValue, unit);
        short s = unit.getUnitType();
        int n = unit.getExponent();
        CSSTypedValue cSSTypedValue2 = this.typedArgument(cSSValueList, 0);
        cSSTypedValue2 = this.evaluate(cSSTypedValue2, unit);
        float f2 = this.floatValue(cSSTypedValue2, unit);
        if (n != unit.getExponent()) {
            throw new DOMException(15, "clamp() arguments have incompatible dimensions.");
        }
        f2 = NumberValue.floatValueConversion(f2, unit.getUnitType(), s);
        CSSTypedValue cSSTypedValue3 = this.typedArgument(cSSValueList, 2);
        cSSTypedValue3 = this.evaluate(cSSTypedValue3, unit);
        float f3 = this.floatValue(cSSTypedValue3, unit);
        if (n != unit.getExponent()) {
            throw new DOMException(15, "clamp() arguments have incompatible dimensions.");
        }
        if (f > (f3 = NumberValue.floatValueConversion(f3, unit.getUnitType(), s))) {
            f = f3;
            bl = cSSTypedValue3.isCalculatedNumber();
        }
        if (f < f2) {
            f = f2;
            bl = cSSTypedValue2.isCalculatedNumber();
        }
        return this.createNumberValue(s, f, bl);
    }

    private CSSNumberValue functionRound(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        float f;
        CSSTypedValue cSSTypedValue;
        String string;
        int n = cSSValueList.getLength();
        if (n > 3 || n < 1) {
            throw new DOMException(12, "round() functions take up to three arguments");
        }
        CSSTypedValue cSSTypedValue2 = null;
        CSSValue cSSValue = cSSValueList.item(0);
        if (cSSValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            string = ((CSSTypedValue)cSSValue).getStringValue().toLowerCase(Locale.ROOT);
            if (n == 1) {
                throw new DOMException(12, "Missing operand in round() function");
            }
            cSSTypedValue = this.typedArgument(cSSValueList, 1);
            if (n == 3) {
                cSSTypedValue2 = this.typedArgument(cSSValueList, 2);
            }
        } else {
            cSSTypedValue = this.typedArgument(cSSValueList, 0);
            if (n == 2) {
                cSSTypedValue2 = this.typedArgument(cSSValueList, 1);
            }
            string = "nearest";
        }
        cSSTypedValue = this.evaluate(cSSTypedValue, unit);
        float f2 = this.floatValue(cSSTypedValue, unit);
        short s = unit.getUnitType();
        if (cSSTypedValue2 != null) {
            int n2 = unit.getExponent();
            cSSTypedValue2 = this.evaluate(cSSTypedValue2, unit);
            f = this.floatValue(cSSTypedValue2, unit);
            if (n2 != unit.getExponent()) {
                throw new DOMException(15, "round() arguments have incompatible dimensions.");
            }
            f2 = NumberValue.floatValueConversion(f2, s, unit.getUnitType());
            s = unit.getUnitType();
        } else {
            f = 1.0f;
        }
        float f3 = Evaluator.round(string, f2, f);
        return this.createNumberValue(s, f3, true);
    }

    private static float round(String string, double d, double d2) {
        double d3;
        switch (string) {
            default: {
                d3 = (double)Math.round(d / d2) * d2;
                break;
            }
            case "up": {
                d3 = Math.ceil(d / d2) * d2;
                break;
            }
            case "down": {
                d3 = Math.floor(d / d2) * d2;
                break;
            }
            case "to-zero": {
                d3 = (double)((long)(d / d2)) * d2;
            }
        }
        return (float)d3;
    }

    private CSSNumberValue functionMod(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 2) {
            throw new DOMException(12, "mod() functions take two arguments");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        CSSTypedValue cSSTypedValue2 = this.typedArgument(cSSValueList, 1);
        unit.setUnitType(cSSTypedValue.getUnitType());
        Unit unit2 = new Unit();
        float f = this.evalValue(cSSTypedValue, unit);
        float f2 = this.evalValue(cSSTypedValue2, unit2);
        if (unit2.getExponent() != unit.getExponent()) {
            throw new DOMException(12, "mod() arguments have different units");
        }
        short s = unit2.getUnitType();
        f = NumberValue.floatValueConversion(f, unit.getUnitType(), s);
        unit.setUnitType(s);
        float f3 = (float)((double)f - Math.floor(f / f2) * (double)f2);
        return this.createNumberValue(s, f3, true);
    }

    private CSSNumberValue functionRem(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 2) {
            throw new DOMException(12, "rem() functions take two arguments");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        CSSTypedValue cSSTypedValue2 = this.typedArgument(cSSValueList, 1);
        unit.setUnitType(cSSTypedValue.getUnitType());
        Unit unit2 = new Unit();
        float f = this.evalValue(cSSTypedValue, unit);
        float f2 = this.evalValue(cSSTypedValue2, unit2);
        if (unit2.getExponent() != unit.getExponent()) {
            throw new DOMException(12, "rem() arguments have different units");
        }
        short s = unit2.getUnitType();
        f = NumberValue.floatValueConversion(f, unit.getUnitType(), s);
        unit.setUnitType(s);
        float f3 = f - (float)((int)(f / f2)) * f2;
        return this.createNumberValue(s, f3, true);
    }

    private CSSNumberValue functionSin(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "sin() functions take one argument");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(cSSTypedValue, unit);
        if (unit.getUnitType() != 0) {
            int n = unit.getExponent();
            if (n > 1 || n < 0) {
                throw new DOMException(17, "Argument unit is not angle nor plain number.");
            }
            f = NumberValue.floatValueConversion(f, unit.getUnitType(), (short)81);
        }
        float f2 = (float)Math.sin(f);
        unit.setUnitType((short)0);
        unit.setExponent(0);
        return this.createNumberValue((short)0, f2, true);
    }

    private CSSNumberValue functionCos(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "cos() functions take one argument");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(cSSTypedValue, unit);
        if (unit.getUnitType() != 0) {
            int n = unit.getExponent();
            if (n > 1 || n < 0) {
                throw new DOMException(17, "Argument unit is not angle nor plain number.");
            }
            f = NumberValue.floatValueConversion(f, unit.getUnitType(), (short)81);
        }
        float f2 = (float)Math.cos(f);
        unit.setUnitType((short)0);
        unit.setExponent(0);
        return this.createNumberValue((short)0, f2, true);
    }

    private CSSNumberValue functionTan(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "tan() functions take one argument");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(cSSTypedValue, unit);
        if (unit.getUnitType() != 0) {
            int n = unit.getExponent();
            if (n > 1 || n < 0) {
                throw new DOMException(17, "Argument unit is not angle nor plain number.");
            }
            f = NumberValue.floatValueConversion(f, unit.getUnitType(), (short)81);
        }
        float f2 = (float)Math.tan(f);
        unit.setUnitType((short)0);
        unit.setExponent(0);
        return this.createNumberValue((short)0, f2, true);
    }

    private CSSNumberValue functionASin(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "asin() functions take one argument");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        float f = (float)Math.asin(this.evalValue(cSSTypedValue, unit));
        if (unit.getExponent() != 0) {
            throw new DOMException(12, "asin() argument must be dimensionless");
        }
        unit.setUnitType((short)81);
        unit.setExponent(1);
        return this.createNumberValue((short)81, f, true);
    }

    private CSSNumberValue functionACos(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "acos() functions take one argument");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        float f = (float)Math.acos(this.evalValue(cSSTypedValue, unit));
        if (unit.getExponent() != 0) {
            throw new DOMException(12, "acos() argument must be dimensionless");
        }
        unit.setUnitType((short)81);
        unit.setExponent(1);
        return this.createNumberValue((short)81, f, true);
    }

    private CSSNumberValue functionATan(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "atan() functions take one argument");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(cSSTypedValue, unit);
        if (unit.getExponent() != 0) {
            throw new DOMException(12, "atan() argument must be dimensionless");
        }
        float f2 = (float)Math.atan(f);
        unit.setUnitType((short)81);
        unit.setExponent(1);
        return this.createNumberValue((short)81, f2, true);
    }

    private CSSNumberValue functionATan2(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 2) {
            throw new DOMException(12, "atan2() functions take two arguments");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        CSSTypedValue cSSTypedValue2 = this.typedArgument(cSSValueList, 1);
        float f = this.evalValue(cSSTypedValue, unit);
        if (unit.getUnitType() != 0) {
            throw new DOMException(12, "atan2() arguments must be dimensionless");
        }
        float f2 = this.evalValue(cSSTypedValue2, unit);
        if (unit.getExponent() != 0) {
            throw new DOMException(12, "atan2() arguments must be dimensionless");
        }
        float f3 = (float)Math.atan2(f, f2);
        unit.setUnitType((short)81);
        unit.setExponent(1);
        return this.createNumberValue((short)81, f3, true);
    }

    private CSSNumberValue functionExp(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "exp() functions take one argument");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(cSSTypedValue, unit);
        if (unit.getUnitType() != 0) {
            throw new DOMException(12, "exp() argument must be dimensionless");
        }
        float f2 = (float)Math.exp(f);
        return this.createNumberValue((short)0, f2, true);
    }

    private CSSNumberValue functionLog(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        float f;
        int n = cSSValueList.getLength();
        if (n > 2 || n < 1) {
            throw new DOMException(12, "log() functions take one or two arguments");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        float f2 = this.evalValue(cSSTypedValue, unit);
        if (unit.getUnitType() != 0) {
            throw new DOMException(12, "log() argument must be dimensionless");
        }
        if (n == 2) {
            CSSTypedValue cSSTypedValue2 = this.typedArgument(cSSValueList, 1);
            Unit unit2 = new Unit();
            float f3 = this.evalValue(cSSTypedValue2, unit2);
            if (unit2.getUnitType() != 0) {
                throw new DOMException(12, "log() base cannot have a dimension");
            }
            f = (float)(Math.log(f2) / Math.log(f3));
        } else {
            f = (float)Math.log(f2);
        }
        unit.setUnitType((short)0);
        return this.createNumberValue((short)0, f, true);
    }

    private CSSNumberValue functionPow(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        int n;
        if (cSSValueList.getLength() != 2) {
            throw new DOMException(12, "pow() functions take two arguments");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        CSSTypedValue cSSTypedValue2 = this.typedArgument(cSSValueList, 1);
        unit.setUnitType(cSSTypedValue.getUnitType());
        float f = this.evalValue(cSSTypedValue, unit);
        Unit unit2 = new Unit();
        float f2 = this.evalValue(cSSTypedValue2, unit2);
        if (unit2.getExponent() != 0) {
            throw new DOMException(12, "pow() exponent cannot have a dimension");
        }
        float f3 = (float)Math.pow(f, f2);
        float f4 = (float)unit.getExponent() * f2;
        if (Math.abs(f4 - (float)(n = Math.round(f4))) > 0.06f) {
            throw new DOMException(12, "Result with fractional dimension not supported in pow().");
        }
        unit.setExponent(n);
        return this.createNumberValue(unit.getUnitType(), f3, true);
    }

    private CSSNumberValue functionSqrt(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "sqrt() functions take one argument");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        float f = (float)Math.sqrt(this.evalValue(cSSTypedValue, unit));
        int n = unit.getExponent();
        if (n % 2 != 0) {
            throw new DOMException(15, "invalid CSS unit in sqrt() function");
        }
        unit.setExponent(n / 2);
        return this.createNumberValue(unit.getUnitType(), f, true);
    }

    private CSSNumberValue functionHypot(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        int n = cSSValueList.getLength();
        if (n == 2) {
            return this.functionHypot2(cSSValueList, unit);
        }
        if (n == 0) {
            throw new DOMException(12, "hypot() functions need at least one argument.");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(cSSTypedValue, unit);
        double d = f * f;
        short s = unit.getUnitType();
        for (int i = 1; i < n; ++i) {
            cSSTypedValue = this.typedArgument(cSSValueList, i);
            f = this.evalValue(cSSTypedValue, unit);
            if (s != unit.getUnitType()) {
                f = NumberValue.floatValueConversion(f, unit.getUnitType(), s);
            }
            d += (double)(f * f);
        }
        d = Math.sqrt(d);
        return this.createNumberValue(s, (float)d, true);
    }

    private CSSNumberValue functionHypot2(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        CSSTypedValue cSSTypedValue2 = this.typedArgument(cSSValueList, 1);
        Unit unit2 = new Unit();
        float f = this.evalValue(cSSTypedValue, unit);
        float f2 = this.evalValue(cSSTypedValue2, unit2);
        if (unit.getUnitType() != unit2.getUnitType()) {
            f2 = NumberValue.floatValueConversion(f2, unit2.getUnitType(), unit.getUnitType());
        }
        float f3 = (float)Math.hypot(f, f2);
        return this.createNumberValue(unit.getUnitType(), f3, true);
    }

    private CSSNumberValue functionAbs(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "abs() functions take one argument.");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        CSSTypedValue cSSTypedValue2 = this.evaluate(cSSTypedValue, unit);
        float f = this.floatValue(cSSTypedValue2, unit);
        float f2 = Math.abs(f);
        return this.createNumberValue(unit.getUnitType(), f2, cSSTypedValue2.isCalculatedNumber());
    }

    private CSSNumberValue functionSign(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "sign() functions take one argument.");
        }
        CSSTypedValue cSSTypedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(cSSTypedValue, unit);
        unit.setUnitType((short)0);
        unit.setExponent(0);
        float f2 = Math.signum(f);
        return this.createNumberValue((short)0, f2, false);
    }

    CSSTypedValue unknownFunction(CSSFunctionValue cSSFunctionValue, Unit unit) {
        unit.setUnitType((short)255);
        return cSSFunctionValue;
    }

    private CSSTypedValue typedArgument(CSSValueList<? extends CSSValue> cSSValueList, int n) {
        CSSValue cSSValue = cSSValueList.item(n);
        return this.enforceTyped(cSSValue);
    }

    private float evalValue(CSSTypedValue cSSTypedValue, Unit unit) throws DOMException {
        CSSTypedValue cSSTypedValue2 = this.evaluate(cSSTypedValue, unit);
        return this.floatValue(cSSTypedValue2, unit);
    }

    private float floatValue(CSSTypedValue cSSTypedValue, Unit unit) throws DOMException {
        float f;
        short s = unit.getUnitType();
        short s2 = cSSTypedValue.getUnitType();
        if (s2 == 0) {
            f = cSSTypedValue.getFloatValue((short)0);
        } else if (s2 != 2) {
            f = cSSTypedValue.getFloatValue(s);
        } else {
            short s3 = this.getPreferredUnit();
            f = this.percentage(cSSTypedValue, s3);
            unit.setUnitType(s3);
        }
        return f;
    }

    protected CSSNumberValue createNumberValue(short s, float f, boolean bl) {
        NumberValue numberValue = NumberValue.createCSSNumberValue(s, f);
        numberValue.setCalculatedNumber(bl);
        return numberValue;
    }

    short getPreferredUnit() {
        return this.preferredUnit;
    }

    public CSSTypedValue evaluateExpression(CSSExpressionValue cSSExpressionValue) throws DOMException {
        Unit unit = new Unit();
        CSSTypedValue cSSTypedValue = this.evaluateExpression(cSSExpressionValue.getExpression(), unit);
        int n = unit.getExponent();
        if (n > 1 || n < 0) {
            throw new DOMException(17, "Resulting unit is not valid CSS unit.");
        }
        float f = cSSTypedValue.getFloatValue(cSSTypedValue.getUnitType());
        if (Float.isNaN(f)) {
            throw new DOMException(15, "Result is not a number (NaN).");
        }
        if (cSSExpressionValue.isExpectingInteger()) {
            ((CSSNumberValue)cSSTypedValue).roundToInteger();
        }
        return cSSTypedValue;
    }

    CSSTypedValue evaluateExpression(CSSExpression cSSExpression, Unit unit) throws DOMException {
        float f;
        Object object;
        switch (cSSExpression.getPartType()) {
            case SUM: {
                object = (AlgebraicExpression)cSSExpression;
                f = this.sum((AlgebraicExpression)object, unit);
                if (cSSExpression.getParentExpression() != null || !cSSExpression.isInverseOperation()) break;
                f = -f;
                break;
            }
            case PRODUCT: {
                AlgebraicExpression algebraicExpression = (AlgebraicExpression)cSSExpression;
                f = this.multiply(algebraicExpression, unit);
                break;
            }
            default: {
                return this.evaluate(((CSSOperandExpression)cSSExpression).getOperand(), unit);
            }
        }
        object = NumberValue.createCSSNumberValue(unit.getUnitType(), f);
        ((NumberValue)object).setCalculatedNumber(true);
        ((NumberValue)object).setAbsolutizedUnit();
        return object;
    }

    private float sum(AlgebraicExpression algebraicExpression, Unit unit) throws DOMException {
        int n = algebraicExpression.getLength();
        if (n == 0) {
            throw new DOMException(12, "Sum without operands.");
        }
        CSSExpression cSSExpression = algebraicExpression.item(0);
        float f = this.evalValue(this.evaluateExpression(cSSExpression, unit), unit);
        if (cSSExpression.isInverseOperation()) {
            f = -f;
        }
        short s = unit.getUnitType();
        for (int i = 1; i < n; ++i) {
            cSSExpression = algebraicExpression.item(i);
            float f2 = this.evalValue(this.evaluateExpression(cSSExpression, unit), unit);
            short s2 = unit.getUnitType();
            if (s != s2) {
                f2 = NumberValue.floatValueConversion(f2, s2, s);
            }
            if (cSSExpression.isInverseOperation()) {
                f -= f2;
                continue;
            }
            f += f2;
        }
        unit.setUnitType(s);
        return f;
    }

    private float multiply(AlgebraicExpression algebraicExpression, Unit unit) throws DOMException {
        float f = 1.0f;
        short s = 0;
        int n = 0;
        int n2 = algebraicExpression.getLength();
        for (int i = 0; i < n2; ++i) {
            CSSExpression cSSExpression = algebraicExpression.item(i);
            CSSTypedValue cSSTypedValue = this.evaluateExpression(cSSExpression, unit);
            float f2 = this.evalValue(cSSTypedValue, unit);
            short s2 = unit.getUnitType();
            if (s2 != 0) {
                if (s == 0) {
                    s = s2;
                } else {
                    try {
                        f2 = NumberValue.floatValueConversion(f2, s2, s);
                    }
                    catch (DOMException dOMException) {
                        if (cSSExpression.isInverseOperation()) {
                            throw dOMException;
                        }
                        f2 = this.unitCancellation(f2, s2, s, dOMException);
                        if (--n == 0) {
                            s = 0;
                        }
                        f *= f2;
                        continue;
                    }
                    s2 = s;
                }
            }
            if (cSSExpression.isInverseOperation()) {
                if (s2 != 0) {
                    s = --n != 0 ? s2 : (short)0;
                }
                if (!Float.isNaN(f /= f2)) continue;
                throw new DOMException(15, "Found NaN.");
            }
            if (s2 != 0) {
                s = ++n != 0 ? s2 : (short)0;
            }
            f *= f2;
        }
        if (n < 0) {
            if (s == 100) {
                s = 90;
                n = -n;
            } else if (s == 101) {
                s = 91;
                n = -n;
            } else if (s == 90) {
                s = 100;
                n = -n;
            } else if (s == 91) {
                s = 101;
                n = -n;
            }
        }
        unit.setUnitType(s);
        unit.setExponent(n);
        return f;
    }

    private float unitCancellation(float f, short s, short s2, DOMException dOMException) throws DOMException {
        if (s == 90 || s == 91) {
            if (s2 == 100) {
                return NumberValue.floatValueConversion(f, s, (short)90);
            }
            if (s2 == 101) {
                return NumberValue.floatValueConversion(f, s, (short)91);
            }
        } else if (s == 100 || s == 101) {
            if (s2 == 90) {
                return NumberValue.floatValueConversion(f, s, (short)100);
            }
            if (s2 == 91) {
                return NumberValue.floatValueConversion(f, s, (short)101);
            }
        }
        throw dOMException;
    }

    private CSSTypedValue evaluate(CSSPrimitiveValue cSSPrimitiveValue, Unit unit) {
        CSSTypedValue cSSTypedValue;
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case MATH_FUNCTION: {
                cSSTypedValue = this.evaluateFunction((CSSMathFunctionValue)cSSPrimitiveValue, unit);
                break;
            }
            case EXPRESSION: {
                CSSExpression cSSExpression = ((CSSExpressionValue)cSSPrimitiveValue).getExpression();
                cSSTypedValue = this.evaluateExpression(cSSExpression, unit);
                break;
            }
            case FUNCTION: {
                cSSTypedValue = this.unknownFunction((CSSFunctionValue)cSSPrimitiveValue, unit);
                break;
            }
            default: {
                cSSTypedValue = this.absoluteValue(cSSPrimitiveValue);
                unit.setUnitType(cSSTypedValue.getUnitType());
            }
        }
        return cSSTypedValue;
    }

    protected CSSTypedValue absoluteValue(CSSPrimitiveValue cSSPrimitiveValue) throws DOMException {
        while (cSSPrimitiveValue.getCssValueType() == CSSValue.CssType.PROXY) {
            CSSValue cSSValue = this.absoluteProxyValue(cSSPrimitiveValue);
            if (cSSValue == null || !cSSValue.isPrimitiveValue()) {
                throw new DOMException(15, "Unable to evaluate: " + cSSPrimitiveValue.getCssText());
            }
            cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
        }
        if (cSSPrimitiveValue.getCssValueType() == CSSValue.CssType.TYPED) {
            return this.absoluteTypedValue((CSSTypedValue)cSSPrimitiveValue);
        }
        throw new DOMException(15, "Unexpected value: " + cSSPrimitiveValue.getCssText());
    }

    protected CSSTypedValue absoluteTypedValue(CSSTypedValue cSSTypedValue) {
        return cSSTypedValue;
    }

    protected CSSValue absoluteProxyValue(CSSPrimitiveValue cSSPrimitiveValue) {
        throw new DOMException(15, "Unexpected value: " + cSSPrimitiveValue.getCssText());
    }

    protected float percentage(CSSTypedValue cSSTypedValue, short s) throws DOMException {
        throw new DOMException(9, "Unexpected percentage in calc()");
    }

    static interface FunctionEvaluator {
        public CSSNumberValue evaluateFunction(Evaluator var1, CSSMathFunctionValue var2, Unit var3);
    }
}

